/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileLock;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class FileChannel
extends AbstractInterruptibleChannel
implements SeekableByteChannel,
GatheringByteChannel,
ScatteringByteChannel {
    private static final FileAttribute<?>[] NO_ATTRIBUTES = new FileAttribute[0];

    protected FileChannel() {
    }

    public static FileChannel open(Path path, Set<? extends OpenOption> set, FileAttribute<?> ... fileAttributeArray) throws IOException {
        FileSystemProvider fileSystemProvider = path.getFileSystem().provider();
        return fileSystemProvider.newFileChannel(path, set, fileAttributeArray);
    }

    public static FileChannel open(Path path, OpenOption ... openOptionArray) throws IOException {
        HashSet hashSet = new HashSet(a.arrayLength((Object[])openOptionArray));
        Collections.addAll(hashSet, openOptionArray);
        return FileChannel.open(path, hashSet, NO_ATTRIBUTES);
    }

    @Override
    public abstract int read(ByteBuffer var1) throws IOException;

    @Override
    public abstract long read(ByteBuffer[] var1, int var2, int var3) throws IOException;

    @Override
    public final long read(ByteBuffer[] byteBufferArray) throws IOException {
        return this.read(byteBufferArray, 0, a.arrayLength((Object[])byteBufferArray));
    }

    @Override
    public abstract int write(ByteBuffer var1) throws IOException;

    @Override
    public abstract long write(ByteBuffer[] var1, int var2, int var3) throws IOException;

    @Override
    public final long write(ByteBuffer[] byteBufferArray) throws IOException {
        return this.write(byteBufferArray, 0, a.arrayLength((Object[])byteBufferArray));
    }

    @Override
    public abstract long position() throws IOException;

    @Override
    public abstract FileChannel position(long var1) throws IOException;

    @Override
    public abstract long size() throws IOException;

    @Override
    public abstract FileChannel truncate(long var1) throws IOException;

    public abstract void force(boolean var1) throws IOException;

    public abstract long transferTo(long var1, long var3, WritableByteChannel var5) throws IOException;

    public abstract long transferFrom(ReadableByteChannel var1, long var2, long var4) throws IOException;

    public abstract int read(ByteBuffer var1, long var2) throws IOException;

    public abstract int write(ByteBuffer var1, long var2) throws IOException;

    public abstract MappedByteBuffer map(MapMode var1, long var2, long var4) throws IOException;

    public abstract FileLock lock(long var1, long var3, boolean var5) throws IOException;

    public final FileLock lock() throws IOException {
        return this.lock(0L, Long.MAX_VALUE, false);
    }

    public abstract FileLock tryLock(long var1, long var3, boolean var5) throws IOException;

    public final FileLock tryLock() throws IOException {
        return this.tryLock(0L, Long.MAX_VALUE, false);
    }

    protected /* synthetic */ FileChannel(h h2) {
        super(h2);
    }

    public static class MapMode
    extends h {
        public static final MapMode READ_ONLY = new MapMode("READ_ONLY");
        public static final MapMode READ_WRITE = new MapMode("READ_WRITE");
        public static final MapMode PRIVATE = new MapMode("PRIVATE");
        private final String name;

        private MapMode(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }

        private static /* synthetic */ void _jr$ip$name(MapMode mapMode, String string) {
            mapMode.name = string;
        }

        protected /* synthetic */ MapMode(h h2) {
            super(h2);
        }
    }
}

