/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels;

import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.facade.x;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;

public abstract class FileLock
extends h
implements AutoCloseable {
    private final Channel channel;
    private final long position;
    private final long size;
    private final boolean shared;

    protected FileLock(FileChannel fileChannel, long l, long l2, boolean bl) {
        if (l < 0L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Negative position"));
        }
        if (l2 < 0L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Negative size"));
        }
        if (l + l2 < 0L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Negative position + size"));
        }
        this.channel = fileChannel;
        this.position = l;
        this.size = l2;
        this.shared = bl;
    }

    protected FileLock(AsynchronousFileChannel asynchronousFileChannel, long l, long l2, boolean bl) {
        if (l < 0L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Negative position"));
        }
        if (l2 < 0L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Negative size"));
        }
        if (l + l2 < 0L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Negative position + size"));
        }
        this.channel = asynchronousFileChannel;
        this.position = l;
        this.size = l2;
        this.shared = bl;
    }

    public final FileChannel channel() {
        return g.convertForInstanceOf((Object)this.channel, FileChannel.class) instanceof FileChannel ? (FileChannel)g.convertForCast((Object)this.channel, FileChannel.class) : null;
    }

    public Channel acquiredBy() {
        return this.channel;
    }

    public final long position() {
        return this.position;
    }

    public final long size() {
        return this.size;
    }

    public final boolean isShared() {
        return this.shared;
    }

    public final boolean overlaps(long l, long l2) {
        if (l + l2 <= this.position) {
            return false;
        }
        return this.position + this.size > l;
    }

    public abstract boolean isValid();

    public abstract void release() throws IOException;

    @Override
    public final void close() throws IOException {
        this.release();
    }

    public final String toString() {
        return x.getName(this.getClass()) + "[" + this.position + ":" + this.size + " " + (this.shared ? "shared" : "exclusive") + " " + (this.isValid() ? "valid" : "invalid") + "]";
    }

    private static /* synthetic */ void _jr$ip$channel(FileLock fileLock, Channel channel) {
        fileLock.channel = channel;
    }

    private static /* synthetic */ void _jr$ip$position(FileLock fileLock, long l) {
        fileLock.position = l;
    }

    private static /* synthetic */ void _jr$ip$size(FileLock fileLock, long l) {
        fileLock.size = l;
    }

    private static /* synthetic */ void _jr$ip$shared(FileLock fileLock, boolean bl) {
        fileLock.shared = bl;
    }

    protected /* synthetic */ FileLock(h h2) {
        super(h2);
    }
}

