/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels.spi;

import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelectionKey;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import sun.nio.ch.Interruptible;

public abstract class AbstractSelector
extends Selector {
    private AtomicBoolean selectorOpen;
    private final SelectorProvider provider;
    private final Set<SelectionKey> cancelledKeys;
    private Interruptible interruptor;

    protected AbstractSelector(SelectorProvider selectorProvider) {
        this.selectorOpen = new AtomicBoolean(true);
        this.cancelledKeys = new HashSet<SelectionKey>();
        this.interruptor = null;
        this.provider = selectorProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel(SelectionKey selectionKey) {
        Object object = ah.getMonitor((Object)this.cancelledKeys);
        synchronized (object) {
            try {
                this.cancelledKeys.add(selectionKey);
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    public final void close() throws IOException {
        boolean bl = this.selectorOpen.getAndSet(false);
        if (!bl) {
            return;
        }
        this.implCloseSelector();
    }

    protected abstract void implCloseSelector() throws IOException;

    @Override
    public final boolean isOpen() {
        return this.selectorOpen.get();
    }

    @Override
    public final SelectorProvider provider() {
        return this.provider;
    }

    protected final Set<SelectionKey> cancelledKeys() {
        return this.cancelledKeys;
    }

    protected abstract SelectionKey register(AbstractSelectableChannel var1, int var2, Object var3);

    protected final void deregister(AbstractSelectionKey abstractSelectionKey) {
        ((AbstractSelectableChannel)g.convertForCast((Object)abstractSelectionKey.channel(), AbstractSelectableChannel.class)).removeKey(abstractSelectionKey);
    }

    protected final void begin() {
        if (this.interruptor == null) {
            this.interruptor = new Interruptible(){

                @Override
                public void interrupt(Thread ignore) {
                    AbstractSelector.this.wakeup();
                }
            };
        }
        AbstractInterruptibleChannel.blockedOn(this.interruptor);
        Thread thread = Thread.currentThread();
        if (thread.isInterrupted()) {
            this.interruptor.interrupt(thread);
        }
    }

    protected final void end() {
        AbstractInterruptibleChannel.blockedOn(null);
    }

    private static /* synthetic */ void _jr$ip$selectorOpen(AbstractSelector abstractSelector, AtomicBoolean atomicBoolean) {
        abstractSelector.selectorOpen = atomicBoolean;
    }

    private static /* synthetic */ void _jr$ip$provider(AbstractSelector abstractSelector, SelectorProvider selectorProvider) {
        abstractSelector.provider = selectorProvider;
    }

    private static /* synthetic */ void _jr$ip$cancelledKeys(AbstractSelector abstractSelector, Set set) {
        abstractSelector.cancelledKeys = set;
    }

    protected /* synthetic */ AbstractSelector(h h2) {
        super(h2);
    }
}

