/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.charset.spi.CharsetProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import sun.misc.ASCIICaseInsensitiveComparator;
import sun.misc.VM;
import sun.nio.cs.StandardCharsets;
import sun.nio.cs.ThreadLocalCoders;
import sun.security.action.GetPropertyAction;

/*
 * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
 */
public abstract class Charset
extends h
implements Comparable {
    private static volatile String bugLevel = null;
    private static CharsetProvider standardProvider = new StandardCharsets();
    private static volatile Object[] cache1 = null;
    private static volatile Object[] cache2 = null;
    private static ThreadLocal<ThreadLocal> gate = new ThreadLocal();
    private static Object extendedProviderLock = new Object();
    private static boolean extendedProviderProbed = false;
    private static CharsetProvider extendedProvider = null;
    private static volatile Charset defaultCharset;
    private final String name;
    private final String[] aliases;
    private Set<String> aliasSet;

    static boolean atBugLevel(String string) {
        String string2 = bugLevel;
        if (string2 == null) {
            if (!VM.isBooted()) {
                return false;
            }
            bugLevel = string2 = (String)AccessController.doPrivileged(new GetPropertyAction("sun.nio.cs.bugLevel", ""));
        }
        return string2.equals(string);
    }

    private static void checkName(String string) {
        int n2 = string.length();
        if (!Charset.atBugLevel("1.4") && n2 == 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalCharsetNameException(string));
        }
        for (int i = 0; i < n2; ++i) {
            char c2 = string.charAt(i);
            if (c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 >= '0' && c2 <= '9' || c2 == '-' && i != 0 || c2 == '+' && i != 0 || c2 == ':' && i != 0 || c2 == '_' && i != 0 || c2 == '.' && i != 0) continue;
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalCharsetNameException(string));
        }
    }

    private static void cache(String string, Charset charset) {
        cache2 = cache1;
        Object[] objectArray = new Object[2];
        a.arrayStore((Object[])objectArray, (int)0, (Object)string);
        a.arrayStore((Object[])objectArray, (int)1, (Object)charset);
        cache1 = objectArray;
    }

    private static Iterator providers() {
        return new Iterator(){
            ClassLoader cl;
            ServiceLoader<CharsetProvider> sl;
            Iterator<CharsetProvider> i;
            Object next;
            {
                this.cl = ClassLoader.getSystemClassLoader();
                this.sl = ServiceLoader.load(CharsetProvider.class, this.cl);
                this.i = this.sl.iterator();
                this.next = null;
            }

            private boolean getNext() {
                while (this.next == null) {
                    try {
                        if (!this.i.hasNext()) {
                            return false;
                        }
                        this.next = this.i.next();
                    }
                    catch (ServiceConfigurationError serviceConfigurationError) {
                        if (g.convertForInstanceOf((Object)serviceConfigurationError.getCause(), SecurityException.class) instanceof SecurityException) continue;
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)serviceConfigurationError);
                    }
                }
                return true;
            }

            @Override
            public boolean hasNext() {
                return this.getNext();
            }

            public Object next() {
                if (!this.getNext()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
                }
                Object object = this.next;
                this.next = null;
                return object;
            }

            @Override
            public void remove() {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
            }

            static /* synthetic */ ClassLoader _jr$ig$cl(Object object) {
                return (object).cl;
            }

            static /* synthetic */ void _jr$ip$cl(Object object, ClassLoader classLoader) {
                (object).cl = classLoader;
            }

            static /* synthetic */ ServiceLoader _jr$ig$sl(Object object) {
                return (object).sl;
            }

            static /* synthetic */ void _jr$ip$sl(Object object, ServiceLoader serviceLoader) {
                (object).sl = serviceLoader;
            }

            static /* synthetic */ Iterator _jr$ig$i(Object object) {
                return (object).i;
            }

            static /* synthetic */ void _jr$ip$i(Object object, Iterator iterator) {
                (object).i = iterator;
            }

            static /* synthetic */ Object _jr$ig$next(Object object) {
                return (object).next;
            }

            static /* synthetic */ void _jr$ip$next(Object object, Object object2) {
                (object).next = object2;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Charset lookupViaProviders(final String string) {
        if (!VM.isBooted()) {
            return null;
        }
        if (gate.get() != null) {
            return null;
        }
        try {
            gate.set(gate);
            Charset charset = (Charset)g.convertForCast((Object)AccessController.doPrivileged(new PrivilegedAction<Charset>(){

                @Override
                public Charset run() {
                    Iterator i = Charset.providers();
                    while (i.hasNext()) {
                        CharsetProvider cp = (CharsetProvider)((Object)i.next());
                        Charset cs = cp.charsetForName(string);
                        if (cs == null) continue;
                        return cs;
                    }
                    return null;
                }
            }), Charset.class);
            gate.set(null);
            return charset;
        }
        catch (Throwable throwable) {
            gate.set(null);
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    private static void probeExtendedProvider() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class<?> clazz = Class.forName("sun.nio.cs.ext.ExtendedCharsets");
                    extendedProvider = (CharsetProvider)((Object)g.convertForCast(ai.getCurrentClass(clazz).newInstance(), CharsetProvider.class));
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Error(instantiationException));
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Error(illegalAccessException));
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Charset lookupExtendedCharset(String string) {
        CharsetProvider charsetProvider = null;
        Object object = ah.getMonitor((Object)extendedProviderLock);
        synchronized (object) {
            try {
                if (!extendedProviderProbed) {
                    Charset.probeExtendedProvider();
                    extendedProviderProbed = true;
                }
                charsetProvider = extendedProvider;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        return charsetProvider != null ? charsetProvider.charsetForName(string) : null;
    }

    private static Charset lookup(String string) {
        if (string == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Null charset name"));
        }
        Object[] objectArray = cache1;
        if (cache1 != null && string.equals(a.arrayLoad((Object[])objectArray, (int)0))) {
            return (Charset)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)1), Charset.class);
        }
        return Charset.lookup2(string);
    }

    private static Charset lookup2(String string) {
        Object[] objectArray = cache2;
        if (cache2 != null && string.equals(a.arrayLoad((Object[])objectArray, (int)0))) {
            cache2 = cache1;
            cache1 = objectArray;
            return (Charset)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)1), Charset.class);
        }
        Charset charset = standardProvider.charsetForName(string);
        if (charset != null || (charset = Charset.lookupExtendedCharset(string)) != null || (charset = Charset.lookupViaProviders(string)) != null) {
            Charset.cache(string, charset);
            return charset;
        }
        Charset.checkName(string);
        return null;
    }

    public static boolean isSupported(String string) {
        return Charset.lookup(string) != null;
    }

    public static Charset forName(String string) {
        Charset charset = Charset.lookup(string);
        if (charset != null) {
            return charset;
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedCharsetException(string));
    }

    private static void put(Iterator<Charset> iterator, Map<String, Charset> map) {
        while (iterator.hasNext()) {
            Charset charset = (Charset)g.convertForCast((Object)iterator.next(), Charset.class);
            if (map.containsKey(charset.name())) continue;
            map.put(charset.name(), charset);
        }
    }

    public static SortedMap<String, Charset> availableCharsets() {
        return (SortedMap)g.convertForCast(AccessController.doPrivileged(new PrivilegedAction(){

            public SortedMap<String, Charset> run() {
                TreeMap treeMap = new TreeMap(ASCIICaseInsensitiveComparator.CASE_INSENSITIVE_ORDER);
                Charset.put(standardProvider.charsets(), treeMap);
                Iterator iterator = Charset.providers();
                while (iterator.hasNext()) {
                    CharsetProvider charsetProvider = (CharsetProvider)((Object)g.convertForCast(iterator.next(), CharsetProvider.class));
                    Charset.put(charsetProvider.charsets(), treeMap);
                }
                return Collections.unmodifiableSortedMap(treeMap);
            }
        }), SortedMap.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Charset defaultCharset() {
        if (defaultCharset == null) {
            Object object = ah.getMonitor(Charset.class);
            synchronized (object) {
                try {
                    String string = (String)AccessController.doPrivileged(new GetPropertyAction("file.encoding"));
                    Charset charset = Charset.lookup(string);
                    defaultCharset = charset != null ? charset : Charset.forName("UTF-8");
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
        return defaultCharset;
    }

    protected Charset(String string, String[] stringArray) {
        this.aliasSet = null;
        Charset.checkName(string);
        String[] stringArray2 = stringArray == null ? new String[]{} : stringArray;
        for (int i = 0; i < stringArray2.length; ++i) {
            Charset.checkName(stringArray2[i]);
        }
        this.name = string;
        this.aliases = stringArray2;
    }

    public final String name() {
        return this.name;
    }

    public final Set<String> aliases() {
        if (this.aliasSet != null) {
            return this.aliasSet;
        }
        int n2 = this.aliases.length;
        HashSet<String> hashSet = new HashSet<String>(n2);
        for (int i = 0; i < n2; ++i) {
            hashSet.add(this.aliases[i]);
        }
        this.aliasSet = Collections.unmodifiableSet(hashSet);
        return this.aliasSet;
    }

    public String displayName() {
        return this.name;
    }

    public final boolean isRegistered() {
        return !this.name.startsWith("X-") && !this.name.startsWith("x-");
    }

    public String displayName(Locale locale) {
        return this.name;
    }

    public abstract boolean contains(Charset var1);

    public abstract CharsetDecoder newDecoder();

    public abstract CharsetEncoder newEncoder();

    public boolean canEncode() {
        return true;
    }

    public final CharBuffer decode(ByteBuffer byteBuffer) {
        try {
            return ThreadLocalCoders.decoderFor(this).onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).decode(byteBuffer);
        }
        catch (CharacterCodingException characterCodingException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Error(characterCodingException));
        }
    }

    public final ByteBuffer encode(CharBuffer charBuffer) {
        try {
            return ThreadLocalCoders.encoderFor(this).onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).encode(charBuffer);
        }
        catch (CharacterCodingException characterCodingException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Error(characterCodingException));
        }
    }

    public final ByteBuffer encode(String string) {
        return this.encode(CharBuffer.wrap(string));
    }

    public final int compareTo(Charset charset) {
        return this.name().compareToIgnoreCase(charset.name());
    }

    public final int hashCode() {
        return this.name().hashCode();
    }

    public final boolean equals(Object object) {
        if (!(g.convertForInstanceOf((Object)object, Charset.class) instanceof Charset)) {
            return false;
        }
        if (!f.ifAcmp((Object)this, (Object)object)) {
            return true;
        }
        return this.name.equals(((Charset)g.convertForCast((Object)object, Charset.class)).name());
    }

    public final String toString() {
        return this.name();
    }

    private static /* synthetic */ void _jr$ip$name(Charset charset, String string) {
        charset.name = string;
    }

    private static /* synthetic */ void _jr$ip$aliases(Charset charset, String[] stringArray) {
        charset.aliases = stringArray;
    }

    protected /* synthetic */ Charset(h h2) {
        super(h2);
    }
}

