/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.h;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CoderMalfunctionError;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public abstract class CharsetDecoder
extends h {
    private final Charset charset;
    private final float averageCharsPerByte;
    private final float maxCharsPerByte;
    private String replacement;
    private CodingErrorAction malformedInputAction;
    private CodingErrorAction unmappableCharacterAction;
    private static final int ST_RESET = 0;
    private static final int ST_CODING = 1;
    private static final int ST_END = 2;
    private static final int ST_FLUSHED = 3;
    private int state;
    private static String[] stateNames = new String[]{"RESET", "CODING", "CODING_END", "FLUSHED"};

    private CharsetDecoder(Charset charset, float f2, float f3, String string) {
        this.malformedInputAction = CodingErrorAction.REPORT;
        this.unmappableCharacterAction = CodingErrorAction.REPORT;
        this.state = 0;
        this.charset = charset;
        if (f2 <= 0.0f) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Non-positive averageCharsPerByte"));
        }
        if (f3 <= 0.0f) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Non-positive maxCharsPerByte"));
        }
        if (!Charset.atBugLevel("1.4") && f2 > f3) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("averageCharsPerByte exceeds maxCharsPerByte"));
        }
        this.replacement = string;
        this.averageCharsPerByte = f2;
        this.maxCharsPerByte = f3;
        this.replaceWith(string);
    }

    protected CharsetDecoder(Charset charset, float f2, float f3) {
        this(charset, f2, f3, "\ufffd");
    }

    public final Charset charset() {
        return this.charset;
    }

    public final String replacement() {
        return this.replacement;
    }

    public final CharsetDecoder replaceWith(String string) {
        if (string == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Null replacement"));
        }
        int n2 = string.length();
        if (n2 == 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Empty replacement"));
        }
        if ((float)n2 > this.maxCharsPerByte) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Replacement too long"));
        }
        this.replacement = string;
        this.implReplaceWith(string);
        return this;
    }

    protected void implReplaceWith(String string) {
    }

    public CodingErrorAction malformedInputAction() {
        return this.malformedInputAction;
    }

    public final CharsetDecoder onMalformedInput(CodingErrorAction codingErrorAction) {
        if (codingErrorAction == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Null action"));
        }
        this.malformedInputAction = codingErrorAction;
        this.implOnMalformedInput(codingErrorAction);
        return this;
    }

    protected void implOnMalformedInput(CodingErrorAction codingErrorAction) {
    }

    public CodingErrorAction unmappableCharacterAction() {
        return this.unmappableCharacterAction;
    }

    public final CharsetDecoder onUnmappableCharacter(CodingErrorAction codingErrorAction) {
        if (codingErrorAction == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Null action"));
        }
        this.unmappableCharacterAction = codingErrorAction;
        this.implOnUnmappableCharacter(codingErrorAction);
        return this;
    }

    protected void implOnUnmappableCharacter(CodingErrorAction codingErrorAction) {
    }

    public final float averageCharsPerByte() {
        return this.averageCharsPerByte;
    }

    public final float maxCharsPerByte() {
        return this.maxCharsPerByte;
    }

    public final CoderResult decode(ByteBuffer byteBuffer, CharBuffer charBuffer, boolean bl) {
        int n2;
        int n3 = n2 = bl ? 2 : 1;
        if (!(this.state == 0 || this.state == 1 || bl && this.state == 2)) {
            this.throwIllegalStateException(this.state, n2);
        }
        this.state = n2;
        while (true) {
            CoderResult coderResult;
            try {
                coderResult = this.decodeLoop(byteBuffer, charBuffer);
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CoderMalfunctionError(bufferUnderflowException));
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CoderMalfunctionError(bufferOverflowException));
            }
            if (coderResult.isOverflow()) {
                return coderResult;
            }
            if (coderResult.isUnderflow()) {
                if (bl && byteBuffer.hasRemaining()) {
                    coderResult = CoderResult.malformedForLength(byteBuffer.remaining());
                } else {
                    return coderResult;
                }
            }
            CodingErrorAction codingErrorAction = null;
            if (coderResult.isMalformed()) {
                codingErrorAction = this.malformedInputAction;
            } else if (coderResult.isUnmappable()) {
                codingErrorAction = this.unmappableCharacterAction;
            } else if (!$assertionsDisabled) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError((Object)coderResult.toString()));
            }
            if (!f.ifAcmp((Object)((Object)codingErrorAction), (Object)((Object)CodingErrorAction.REPORT))) {
                return coderResult;
            }
            if (!f.ifAcmp((Object)((Object)codingErrorAction), (Object)((Object)CodingErrorAction.REPLACE))) {
                if (charBuffer.remaining() < this.replacement.length()) {
                    return CoderResult.OVERFLOW;
                }
                charBuffer.put(this.replacement);
            }
            if (!f.ifAcmp((Object)((Object)codingErrorAction), (Object)((Object)CodingErrorAction.IGNORE)) || !f.ifAcmp((Object)((Object)codingErrorAction), (Object)((Object)CodingErrorAction.REPLACE))) {
                byteBuffer.position(byteBuffer.position() + coderResult.length());
                continue;
            }
            if (!$assertionsDisabled) break;
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
    }

    public final CoderResult flush(CharBuffer charBuffer) {
        if (this.state == 2) {
            CoderResult coderResult = this.implFlush(charBuffer);
            if (coderResult.isUnderflow()) {
                this.state = 3;
            }
            return coderResult;
        }
        if (this.state != 3) {
            this.throwIllegalStateException(this.state, 3);
        }
        return CoderResult.UNDERFLOW;
    }

    protected CoderResult implFlush(CharBuffer charBuffer) {
        return CoderResult.UNDERFLOW;
    }

    public final CharsetDecoder reset() {
        this.implReset();
        this.state = 0;
        return this;
    }

    protected void implReset() {
    }

    protected abstract CoderResult decodeLoop(ByteBuffer var1, CharBuffer var2);

    public final CharBuffer decode(ByteBuffer byteBuffer) throws CharacterCodingException {
        int n2 = (int)((float)byteBuffer.remaining() * this.averageCharsPerByte());
        CharBuffer charBuffer = CharBuffer.allocate(n2);
        if (n2 == 0 && byteBuffer.remaining() == 0) {
            return charBuffer;
        }
        this.reset();
        while (true) {
            CoderResult coderResult;
            CoderResult coderResult2 = coderResult = byteBuffer.hasRemaining() ? this.decode(byteBuffer, charBuffer, true) : CoderResult.UNDERFLOW;
            if (coderResult.isUnderflow()) {
                coderResult = this.flush(charBuffer);
            }
            if (coderResult.isUnderflow()) break;
            if (coderResult.isOverflow()) {
                n2 = 2 * n2 + 1;
                CharBuffer charBuffer2 = CharBuffer.allocate(n2);
                charBuffer.flip();
                charBuffer2.put(charBuffer);
                charBuffer = charBuffer2;
                continue;
            }
            coderResult.throwException();
        }
        charBuffer.flip();
        return charBuffer;
    }

    public boolean isAutoDetecting() {
        return false;
    }

    public boolean isCharsetDetected() {
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
    }

    public Charset detectedCharset() {
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
    }

    private void throwIllegalStateException(int n2, int n3) {
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("Current state = " + stateNames[n2] + ", new state = " + stateNames[n3]));
    }

    private static /* synthetic */ void _jr$ip$charset(CharsetDecoder charsetDecoder, Charset charset) {
        charsetDecoder.charset = charset;
    }

    private static /* synthetic */ void _jr$ip$averageCharsPerByte(CharsetDecoder charsetDecoder, float f2) {
        charsetDecoder.averageCharsPerByte = f2;
    }

    private static /* synthetic */ void _jr$ip$maxCharsPerByte(CharsetDecoder charsetDecoder, float f2) {
        charsetDecoder.maxCharsPerByte = f2;
    }

    protected /* synthetic */ CharsetDecoder(h h2) {
        super(h2);
    }
}

