/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.lang.ref.WeakReference;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderMalfunctionError;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public abstract class CharsetEncoder
extends h {
    private final Charset charset;
    private final float averageBytesPerChar;
    private final float maxBytesPerChar;
    private byte[] replacement;
    private CodingErrorAction malformedInputAction;
    private CodingErrorAction unmappableCharacterAction;
    private static final int ST_RESET = 0;
    private static final int ST_CODING = 1;
    private static final int ST_END = 2;
    private static final int ST_FLUSHED = 3;
    private int state;
    private static String[] stateNames;
    private WeakReference<CharsetDecoder> cachedDecoder;

    protected CharsetEncoder(Charset charset, float f2, float f3, byte[] byArray) {
        this.malformedInputAction = CodingErrorAction.REPORT;
        this.unmappableCharacterAction = CodingErrorAction.REPORT;
        this.state = 0;
        this.cachedDecoder = null;
        this.charset = charset;
        if (f2 <= 0.0f) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Non-positive averageBytesPerChar"));
        }
        if (f3 <= 0.0f) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Non-positive maxBytesPerChar"));
        }
        if (!Charset.atBugLevel("1.4") && f2 > f3) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("averageBytesPerChar exceeds maxBytesPerChar"));
        }
        this.replacement = byArray;
        this.averageBytesPerChar = f2;
        this.maxBytesPerChar = f3;
        this.replaceWith(byArray);
    }

    protected CharsetEncoder(Charset charset, float f2, float f3) {
        this(charset, f2, f3, new byte[]{63});
    }

    public final Charset charset() {
        return this.charset;
    }

    public final byte[] replacement() {
        return this.replacement;
    }

    public final CharsetEncoder replaceWith(byte[] byArray) {
        if (byArray == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Null replacement"));
        }
        int n2 = byArray.length;
        if (n2 == 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Empty replacement"));
        }
        if ((float)n2 > this.maxBytesPerChar) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Replacement too long"));
        }
        if (!this.isLegalReplacement(byArray)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Illegal replacement"));
        }
        this.replacement = byArray;
        this.implReplaceWith(byArray);
        return this;
    }

    protected void implReplaceWith(byte[] byArray) {
    }

    public boolean isLegalReplacement(byte[] byArray) {
        WeakReference weakReference = this.cachedDecoder;
        CharsetDecoder charsetDecoder = null;
        if (weakReference == null || (charsetDecoder = (CharsetDecoder)((Object)g.convertForCast(weakReference.get(), CharsetDecoder.class))) == null) {
            charsetDecoder = this.charset().newDecoder();
            charsetDecoder.onMalformedInput(CodingErrorAction.REPORT);
            charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            this.cachedDecoder = new WeakReference<CharsetDecoder>(charsetDecoder);
        } else {
            charsetDecoder.reset();
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        CharBuffer charBuffer = CharBuffer.allocate((int)((float)byteBuffer.remaining() * charsetDecoder.maxCharsPerByte()));
        CoderResult coderResult = charsetDecoder.decode(byteBuffer, charBuffer, true);
        return !coderResult.isError();
    }

    public CodingErrorAction malformedInputAction() {
        return this.malformedInputAction;
    }

    public final CharsetEncoder onMalformedInput(CodingErrorAction codingErrorAction) {
        if (codingErrorAction == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Null action"));
        }
        this.malformedInputAction = codingErrorAction;
        this.implOnMalformedInput(codingErrorAction);
        return this;
    }

    protected void implOnMalformedInput(CodingErrorAction codingErrorAction) {
    }

    public CodingErrorAction unmappableCharacterAction() {
        return this.unmappableCharacterAction;
    }

    public final CharsetEncoder onUnmappableCharacter(CodingErrorAction codingErrorAction) {
        if (codingErrorAction == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Null action"));
        }
        this.unmappableCharacterAction = codingErrorAction;
        this.implOnUnmappableCharacter(codingErrorAction);
        return this;
    }

    protected void implOnUnmappableCharacter(CodingErrorAction codingErrorAction) {
    }

    public final float averageBytesPerChar() {
        return this.averageBytesPerChar;
    }

    public final float maxBytesPerChar() {
        return this.maxBytesPerChar;
    }

    public final CoderResult encode(CharBuffer charBuffer, ByteBuffer byteBuffer, boolean bl) {
        int n2;
        int n3 = n2 = bl ? 2 : 1;
        if (!(this.state == 0 || this.state == 1 || bl && this.state == 2)) {
            this.throwIllegalStateException(this.state, n2);
        }
        this.state = n2;
        while (true) {
            CoderResult coderResult;
            try {
                coderResult = this.encodeLoop(charBuffer, byteBuffer);
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CoderMalfunctionError(bufferUnderflowException));
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CoderMalfunctionError(bufferOverflowException));
            }
            if (coderResult.isOverflow()) {
                return coderResult;
            }
            if (coderResult.isUnderflow()) {
                if (bl && charBuffer.hasRemaining()) {
                    coderResult = CoderResult.malformedForLength(charBuffer.remaining());
                } else {
                    return coderResult;
                }
            }
            CodingErrorAction codingErrorAction = null;
            if (coderResult.isMalformed()) {
                codingErrorAction = this.malformedInputAction;
            } else if (coderResult.isUnmappable()) {
                codingErrorAction = this.unmappableCharacterAction;
            } else if (!$assertionsDisabled) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError((Object)coderResult.toString()));
            }
            if (!f.ifAcmp((Object)((Object)codingErrorAction), (Object)((Object)CodingErrorAction.REPORT))) {
                return coderResult;
            }
            if (!f.ifAcmp((Object)((Object)codingErrorAction), (Object)((Object)CodingErrorAction.REPLACE))) {
                if (byteBuffer.remaining() < this.replacement.length) {
                    return CoderResult.OVERFLOW;
                }
                byteBuffer.put(this.replacement);
            }
            if (!f.ifAcmp((Object)((Object)codingErrorAction), (Object)((Object)CodingErrorAction.IGNORE)) || !f.ifAcmp((Object)((Object)codingErrorAction), (Object)((Object)CodingErrorAction.REPLACE))) {
                charBuffer.position(charBuffer.position() + coderResult.length());
                continue;
            }
            if (!$assertionsDisabled) break;
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
    }

    public final CoderResult flush(ByteBuffer byteBuffer) {
        if (this.state == 2) {
            CoderResult coderResult = this.implFlush(byteBuffer);
            if (coderResult.isUnderflow()) {
                this.state = 3;
            }
            return coderResult;
        }
        if (this.state != 3) {
            this.throwIllegalStateException(this.state, 3);
        }
        return CoderResult.UNDERFLOW;
    }

    protected CoderResult implFlush(ByteBuffer byteBuffer) {
        return CoderResult.UNDERFLOW;
    }

    public final CharsetEncoder reset() {
        this.implReset();
        this.state = 0;
        return this;
    }

    protected void implReset() {
    }

    protected abstract CoderResult encodeLoop(CharBuffer var1, ByteBuffer var2);

    public final ByteBuffer encode(CharBuffer charBuffer) throws CharacterCodingException {
        int n2 = (int)((float)charBuffer.remaining() * this.averageBytesPerChar());
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        if (n2 == 0 && charBuffer.remaining() == 0) {
            return byteBuffer;
        }
        this.reset();
        while (true) {
            CoderResult coderResult;
            CoderResult coderResult2 = coderResult = charBuffer.hasRemaining() ? this.encode(charBuffer, byteBuffer, true) : CoderResult.UNDERFLOW;
            if (coderResult.isUnderflow()) {
                coderResult = this.flush(byteBuffer);
            }
            if (coderResult.isUnderflow()) break;
            if (coderResult.isOverflow()) {
                n2 = 2 * n2 + 1;
                ByteBuffer byteBuffer2 = ByteBuffer.allocate(n2);
                byteBuffer.flip();
                byteBuffer2.put(byteBuffer);
                byteBuffer = byteBuffer2;
                continue;
            }
            coderResult.throwException();
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canEncode(CharBuffer charBuffer) {
        if (this.state == 3) {
            this.reset();
        } else if (this.state != 0) {
            this.throwIllegalStateException(this.state, 1);
        }
        CodingErrorAction codingErrorAction = this.malformedInputAction();
        CodingErrorAction codingErrorAction2 = this.unmappableCharacterAction();
        try {
            this.onMalformedInput(CodingErrorAction.REPORT);
            this.onUnmappableCharacter(CodingErrorAction.REPORT);
            this.encode(charBuffer);
            this.onMalformedInput(codingErrorAction);
        }
        catch (CharacterCodingException characterCodingException) {
            boolean bl;
            try {
                bl = false;
                this.onMalformedInput(codingErrorAction);
            }
            catch (Throwable throwable) {
                this.onMalformedInput(codingErrorAction);
                this.onUnmappableCharacter(codingErrorAction2);
                this.reset();
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
            this.onUnmappableCharacter(codingErrorAction2);
            this.reset();
            return bl;
        }
        this.onUnmappableCharacter(codingErrorAction2);
        this.reset();
        return true;
    }

    public boolean canEncode(char c) {
        CharBuffer charBuffer = CharBuffer.allocate(1);
        charBuffer.put(c);
        charBuffer.flip();
        return this.canEncode(charBuffer);
    }

    public boolean canEncode(CharSequence charSequence) {
        CharBuffer charBuffer = g.convertForInstanceOf((Object)charSequence, CharBuffer.class) instanceof CharBuffer ? ((CharBuffer)g.convertForCast((Object)charSequence, CharBuffer.class)).duplicate() : CharBuffer.wrap(charSequence.toString());
        return this.canEncode(charBuffer);
    }

    private void throwIllegalStateException(int n2, int n3) {
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("Current state = " + (String)a.arrayLoad((Object[])stateNames, (int)n2) + ", new state = " + (String)a.arrayLoad((Object[])stateNames, (int)n3)));
    }

    static {
        Object[] objectArray = new String[4];
        a.arrayStore((Object[])objectArray, (int)0, (Object)"RESET");
        a.arrayStore((Object[])objectArray, (int)1, (Object)"CODING");
        a.arrayStore((Object[])objectArray, (int)2, (Object)"CODING_END");
        a.arrayStore((Object[])objectArray, (int)3, (Object)"FLUSHED");
        stateNames = objectArray;
    }

    private static /* synthetic */ void _jr$ip$charset(CharsetEncoder charsetEncoder, Charset charset) {
        charsetEncoder.charset = charset;
    }

    private static /* synthetic */ void _jr$ip$averageBytesPerChar(CharsetEncoder charsetEncoder, float f2) {
        charsetEncoder.averageBytesPerChar = f2;
    }

    private static /* synthetic */ void _jr$ip$maxBytesPerChar(CharsetEncoder charsetEncoder, float f2) {
        charsetEncoder.maxBytesPerChar = f2;
    }

    protected /* synthetic */ CharsetEncoder(h h2) {
        super(h2);
    }
}

