/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.lang.ref.WeakReference;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.util.HashMap;
import java.util.Map;

public class CoderResult
extends h {
    private static final int CR_UNDERFLOW = 0;
    private static final int CR_OVERFLOW = 1;
    private static final int CR_ERROR_MIN = 2;
    private static final int CR_MALFORMED = 2;
    private static final int CR_UNMAPPABLE = 3;
    private static final String[] names;
    private final int type;
    private final int length;
    public static final CoderResult UNDERFLOW;
    public static final CoderResult OVERFLOW;
    private static Cache malformedCache;
    private static Cache unmappableCache;

    private CoderResult(int n2, int n3) {
        this.type = n2;
        this.length = n3;
    }

    public String toString() {
        String string = (String)a.arrayLoad((Object[])names, (int)this.type);
        return this.isError() ? string + "[" + this.length + "]" : string;
    }

    public boolean isUnderflow() {
        return this.type == 0;
    }

    public boolean isOverflow() {
        return this.type == 1;
    }

    public boolean isError() {
        return this.type >= 2;
    }

    public boolean isMalformed() {
        return this.type == 2;
    }

    public boolean isUnmappable() {
        return this.type == 3;
    }

    public int length() {
        if (!this.isError()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
        }
        return this.length;
    }

    public static CoderResult malformedForLength(int n2) {
        return CoderResult.malformedCache.get(n2);
    }

    public static CoderResult unmappableForLength(int n2) {
        return CoderResult.unmappableCache.get(n2);
    }

    public void throwException() throws CharacterCodingException {
        switch (this.type) {
            case 0: {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new BufferUnderflowException());
            }
            case 1: {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new BufferOverflowException());
            }
            case 2: {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new MalformedInputException(this.length));
            }
            case 3: {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnmappableCharacterException(this.length));
            }
        }
        if (!$assertionsDisabled) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
    }

    static {
        Object[] objectArray = new String[4];
        a.arrayStore((Object[])objectArray, (int)0, (Object)"UNDERFLOW");
        a.arrayStore((Object[])objectArray, (int)1, (Object)"OVERFLOW");
        a.arrayStore((Object[])objectArray, (int)2, (Object)"MALFORMED");
        a.arrayStore((Object[])objectArray, (int)3, (Object)"UNMAPPABLE");
        names = objectArray;
        UNDERFLOW = new CoderResult(0, 0);
        OVERFLOW = new CoderResult(1, 0);
        malformedCache = new Cache(){

            @Override
            public CoderResult create(int n2) {
                return new CoderResult(2, n2);
            }
        };
        unmappableCache = new Cache(){

            @Override
            public CoderResult create(int n2) {
                return new CoderResult(3, n2);
            }
        };
    }

    private static /* synthetic */ void _jr$ip$type(CoderResult coderResult, int n2) {
        coderResult.type = n2;
    }

    private static /* synthetic */ void _jr$ip$length(CoderResult coderResult, int n2) {
        coderResult.length = n2;
    }

    protected /* synthetic */ CoderResult(h h2) {
        super(h2);
    }

    private static abstract class Cache
    extends h {
        private Map<Integer, WeakReference<CoderResult>> cache;

        private Cache() {
            this.cache = null;
        }

        protected abstract CoderResult create(int var1);

        @af(modifiers=34)
        private CoderResult get(int n2) {
            Object object = ah.getMonitor((Object)((Object)this));
            synchronized (object) {
                try {
                    if (n2 <= 0) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Non-positive length"));
                    }
                    Integer n3 = new Integer(n2);
                    CoderResult coderResult = null;
                    if (this.cache == null) {
                        this.cache = new HashMap();
                    } else {
                        WeakReference weakReference = (WeakReference)((Object)g.convertForCast(this.cache.get(n3), WeakReference.class));
                        if (weakReference != null) {
                            coderResult = (CoderResult)((Object)g.convertForCast(weakReference.get(), CoderResult.class));
                        }
                    }
                    if (coderResult == null) {
                        coderResult = this.create(n2);
                        this.cache.put(n3, new WeakReference<CoderResult>(coderResult));
                    }
                    return coderResult;
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }

        protected /* synthetic */ Cache(h h2) {
            super(h2);
        }
    }
}

