/*
 * Decompiled with CFR 0.152.
 */
package java.nio.file;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.facade.aj;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.spi.FileSystemProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import sun.nio.fs.DefaultFileSystemProvider;

public final class FileSystems
extends h {
    private FileSystems() {
    }

    public static FileSystem getDefault() {
        return DefaultFileSystemHolder.defaultFileSystem;
    }

    public static FileSystem getFileSystem(URI uRI) {
        String string = uRI.getScheme();
        Iterator<FileSystemProvider> iterator = FileSystemProvider.installedProviders().iterator();
        while (iterator.hasNext()) {
            FileSystemProvider fileSystemProvider = (FileSystemProvider)((Object)g.convertForCast((Object)((Object)iterator.next()), FileSystemProvider.class));
            if (!string.equalsIgnoreCase(fileSystemProvider.getScheme())) continue;
            return fileSystemProvider.getFileSystem(uRI);
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ProviderNotFoundException("Provider \"" + string + "\" not found"));
    }

    public static FileSystem newFileSystem(URI uRI, Map<String, ?> map) throws IOException {
        return FileSystems.newFileSystem(uRI, map, null);
    }

    public static FileSystem newFileSystem(URI uRI, Map<String, ?> map, ClassLoader classLoader) throws IOException {
        Object object;
        String string = uRI.getScheme();
        Object object2 = FileSystemProvider.installedProviders().iterator();
        while (object2.hasNext()) {
            object = (FileSystemProvider)((Object)g.convertForCast((Object)((Object)object2.next()), FileSystemProvider.class));
            if (!string.equalsIgnoreCase(object.getScheme())) continue;
            return object.newFileSystem(uRI, map);
        }
        if (classLoader != null) {
            object2 = ServiceLoader.load(FileSystemProvider.class, classLoader);
            object = ((ServiceLoader)object2).iterator();
            while (object.hasNext()) {
                FileSystemProvider fileSystemProvider = (FileSystemProvider)((Object)g.convertForCast(object.next(), FileSystemProvider.class));
                if (!string.equalsIgnoreCase(fileSystemProvider.getScheme())) continue;
                return fileSystemProvider.newFileSystem(uRI, map);
            }
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ProviderNotFoundException("Provider \"" + string + "\" not found"));
    }

    public static FileSystem newFileSystem(Path path, ClassLoader classLoader) throws IOException {
        Object object;
        if (path == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        Map map = Collections.emptyMap();
        Object object2 = FileSystemProvider.installedProviders().iterator();
        while (object2.hasNext()) {
            object = (FileSystemProvider)((Object)g.convertForCast((Object)((Object)object2.next()), FileSystemProvider.class));
            try {
                return ((FileSystemProvider)((Object)object)).newFileSystem(path, map);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
        }
        if (classLoader != null) {
            object2 = ServiceLoader.load(FileSystemProvider.class, classLoader);
            object = ((ServiceLoader)object2).iterator();
            while (object.hasNext()) {
                FileSystemProvider fileSystemProvider = (FileSystemProvider)((Object)g.convertForCast(object.next(), FileSystemProvider.class));
                try {
                    return fileSystemProvider.newFileSystem(path, map);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                }
            }
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ProviderNotFoundException("Provider not found"));
    }

    private static class DefaultFileSystemHolder
    extends h {
        static final FileSystem defaultFileSystem = DefaultFileSystemHolder.defaultFileSystem();

        private DefaultFileSystemHolder() {
        }

        private static FileSystem defaultFileSystem() {
            FileSystemProvider fileSystemProvider = (FileSystemProvider)((Object)g.convertForCast(AccessController.doPrivileged(new PrivilegedAction(){

                public FileSystemProvider run() {
                    return DefaultFileSystemHolder.getDefaultProvider();
                }
            }), FileSystemProvider.class));
            return fileSystemProvider.getFileSystem(URI.create("file:///"));
        }

        private static FileSystemProvider getDefaultProvider() {
            FileSystemProvider fileSystemProvider = DefaultFileSystemProvider.create();
            String string = System.getProperty("java.nio.file.spi.DefaultFileSystemProvider");
            if (string != null) {
                for (String string2 : string.split(",")) {
                    try {
                        Class<?> clazz = Class.forName(string2, true, ClassLoader.getSystemClassLoader());
                        aj aj2 = ai.convertArgs(clazz, (Class[])new Class[]{FileSystemProvider.class});
                        Constructor constructor = aj2.clazz.getDeclaredConstructor(aj2.args);
                        Object[] objectArray = new Object[1];
                        a.arrayStore((Object[])objectArray, (int)0, (Object)((Object)fileSystemProvider));
                        fileSystemProvider = (FileSystemProvider)((Object)g.convertForCast(constructor.newInstance(objectArray), FileSystemProvider.class));
                        if (fileSystemProvider.getScheme().equals("file")) continue;
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Error("Default provider must use scheme 'file'"));
                    }
                    catch (Exception exception) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Error(exception));
                    }
                }
            }
            return fileSystemProvider;
        }

        protected /* synthetic */ DefaultFileSystemHolder(h h2) {
            super(h2);
        }
    }
}

