/*
 * Decompiled with CFR 0.152.
 */
package java.nio.file;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.file.AccessMode;
import java.nio.file.CopyMoveHelper;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileTreeWalker;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.TempFileHelper;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.spi.FileSystemProvider;
import java.nio.file.spi.FileTypeDetector;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import sun.nio.fs.DefaultFileTypeDetector;

public final class Files
extends h {
    private static final int BUFFER_SIZE = 8192;

    private Files() {
    }

    private static FileSystemProvider provider(Path path) {
        return path.getFileSystem().provider();
    }

    public static InputStream newInputStream(Path path, OpenOption ... openOptionArray) throws IOException {
        return Files.provider(path).newInputStream(path, openOptionArray);
    }

    public static OutputStream newOutputStream(Path path, OpenOption ... openOptionArray) throws IOException {
        return Files.provider(path).newOutputStream(path, openOptionArray);
    }

    public static SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> set, FileAttribute<?> ... fileAttributeArray) throws IOException {
        return Files.provider(path).newByteChannel(path, set, fileAttributeArray);
    }

    public static SeekableByteChannel newByteChannel(Path path, OpenOption ... openOptionArray) throws IOException {
        HashSet hashSet = new HashSet(a.arrayLength((Object[])openOptionArray));
        Collections.addAll(hashSet, openOptionArray);
        return Files.newByteChannel(path, hashSet, new FileAttribute[0]);
    }

    public static DirectoryStream<Path> newDirectoryStream(Path path) throws IOException {
        return Files.provider(path).newDirectoryStream(path, AcceptAllFilter.FILTER);
    }

    public static DirectoryStream<Path> newDirectoryStream(Path path, String string) throws IOException {
        if (string.equals("*")) {
            return Files.newDirectoryStream(path);
        }
        FileSystem fileSystem = path.getFileSystem();
        final PathMatcher pathMatcher = fileSystem.getPathMatcher("glob:" + string);
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) {
                return pathMatcher.matches(entry.getFileName());
            }
        };
        return fileSystem.provider().newDirectoryStream(path, (DirectoryStream.Filter<? super Path>)filter);
    }

    public static DirectoryStream<Path> newDirectoryStream(Path path, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return Files.provider(path).newDirectoryStream(path, filter);
    }

    public static Path createFile(Path path, FileAttribute<?> ... fileAttributeArray) throws IOException {
        EnumSet<StandardOpenOption> enumSet = EnumSet.of(StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        Files.newByteChannel(path, enumSet, fileAttributeArray).close();
        return path;
    }

    public static Path createDirectory(Path path, FileAttribute<?> ... fileAttributeArray) throws IOException {
        Files.provider(path).createDirectory(path, fileAttributeArray);
        return path;
    }

    public static Path createDirectories(Path path, FileAttribute<?> ... fileAttributeArray) throws IOException {
        try {
            Files.createAndCheckIsDirectory(path, fileAttributeArray);
            return path;
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)fileAlreadyExistsException);
        }
        catch (IOException iOException) {
            Path path2;
            SecurityException securityException = null;
            try {
                path = path.toAbsolutePath();
            }
            catch (SecurityException securityException2) {
                securityException = securityException2;
            }
            for (path2 = path.getParent(); path2 != null; path2 = path2.getParent()) {
                try {
                    Files.provider(path2).checkAccess(path2, new AccessMode[0]);
                    break;
                }
                catch (NoSuchFileException noSuchFileException) {
                    continue;
                }
            }
            if (path2 == null) {
                if (securityException != null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)securityException);
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Root directory does not exist"));
            }
            Path path3 = path2;
            Iterator<Path> iterator = path2.relativize(path).iterator();
            while (iterator.hasNext()) {
                Path path4 = (Path)g.convertForCast((Object)iterator.next(), Path.class);
                path3 = path3.resolve(path4);
                Files.createAndCheckIsDirectory(path3, fileAttributeArray);
            }
            return path;
        }
    }

    private static void createAndCheckIsDirectory(Path path, FileAttribute<?> ... fileAttributeArray) throws IOException {
        block2: {
            try {
                Files.createDirectory(path, fileAttributeArray);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                if (Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) break block2;
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)fileAlreadyExistsException);
            }
        }
    }

    public static Path createTempFile(Path path, String string, String string2, FileAttribute<?> ... fileAttributeArray) throws IOException {
        return TempFileHelper.createTempFile((Path)g.convertForCast((Object)Objects.requireNonNull(path), Path.class), string, string2, fileAttributeArray);
    }

    public static Path createTempFile(String string, String string2, FileAttribute<?> ... fileAttributeArray) throws IOException {
        return TempFileHelper.createTempFile(null, string, string2, fileAttributeArray);
    }

    public static Path createTempDirectory(Path path, String string, FileAttribute<?> ... fileAttributeArray) throws IOException {
        return TempFileHelper.createTempDirectory((Path)g.convertForCast((Object)Objects.requireNonNull(path), Path.class), string, fileAttributeArray);
    }

    public static Path createTempDirectory(String string, FileAttribute<?> ... fileAttributeArray) throws IOException {
        return TempFileHelper.createTempDirectory(null, string, fileAttributeArray);
    }

    public static Path createSymbolicLink(Path path, Path path2, FileAttribute<?> ... fileAttributeArray) throws IOException {
        Files.provider(path).createSymbolicLink(path, path2, fileAttributeArray);
        return path;
    }

    public static Path createLink(Path path, Path path2) throws IOException {
        Files.provider(path).createLink(path, path2);
        return path;
    }

    public static void delete(Path path) throws IOException {
        Files.provider(path).delete(path);
    }

    public static boolean deleteIfExists(Path path) throws IOException {
        return Files.provider(path).deleteIfExists(path);
    }

    public static Path copy(Path path, Path path2, CopyOption ... copyOptionArray) throws IOException {
        FileSystemProvider fileSystemProvider = Files.provider(path);
        if (!f.ifAcmp((Object)((Object)Files.provider(path2)), (Object)((Object)fileSystemProvider))) {
            fileSystemProvider.copy(path, path2, copyOptionArray);
        } else {
            CopyMoveHelper.copyToForeignTarget(path, path2, copyOptionArray);
        }
        return path2;
    }

    public static Path move(Path path, Path path2, CopyOption ... copyOptionArray) throws IOException {
        FileSystemProvider fileSystemProvider = Files.provider(path);
        if (!f.ifAcmp((Object)((Object)Files.provider(path2)), (Object)((Object)fileSystemProvider))) {
            fileSystemProvider.move(path, path2, copyOptionArray);
        } else {
            CopyMoveHelper.moveToForeignTarget(path, path2, copyOptionArray);
        }
        return path2;
    }

    public static Path readSymbolicLink(Path path) throws IOException {
        return Files.provider(path).readSymbolicLink(path);
    }

    public static FileStore getFileStore(Path path) throws IOException {
        return Files.provider(path).getFileStore(path);
    }

    public static boolean isSameFile(Path path, Path path2) throws IOException {
        return Files.provider(path).isSameFile(path, path2);
    }

    public static boolean isHidden(Path path) throws IOException {
        return Files.provider(path).isHidden(path);
    }

    public static String probeContentType(Path path) throws IOException {
        Iterator<FileTypeDetector> iterator = FileTypeDetectors.installeDetectors.iterator();
        while (iterator.hasNext()) {
            FileTypeDetector fileTypeDetector = (FileTypeDetector)g.convertForCast((Object)iterator.next(), FileTypeDetector.class);
            String string = fileTypeDetector.probeContentType(path);
            if (string == null) continue;
            return string;
        }
        return FileTypeDetectors.defaultFileTypeDetector.probeContentType(path);
    }

    public static <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> clazz, LinkOption ... linkOptionArray) {
        return Files.provider(path).getFileAttributeView(path, clazz, linkOptionArray);
    }

    public static <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> clazz, LinkOption ... linkOptionArray) throws IOException {
        return Files.provider(path).readAttributes(path, clazz, linkOptionArray);
    }

    public static Path setAttribute(Path path, String string, Object object, LinkOption ... linkOptionArray) throws IOException {
        Files.provider(path).setAttribute(path, string, object, linkOptionArray);
        return path;
    }

    public static Object getAttribute(Path path, String string, LinkOption ... linkOptionArray) throws IOException {
        if (string.indexOf(42) >= 0 || string.indexOf(44) >= 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException(string));
        }
        Map<String, Object> map = Files.readAttributes(path, string, linkOptionArray);
        if (!$assertionsDisabled && map.size() != 1) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        int n2 = string.indexOf(58);
        String string2 = n2 == -1 ? string : (n2 == string.length() ? "" : string.substring(n2 + 1));
        return map.get(string2);
    }

    public static Map<String, Object> readAttributes(Path path, String string, LinkOption ... linkOptionArray) throws IOException {
        return Files.provider(path).readAttributes(path, string, linkOptionArray);
    }

    public static Set<PosixFilePermission> getPosixFilePermissions(Path path, LinkOption ... linkOptionArray) throws IOException {
        return ((PosixFileAttributes)g.convertForCast((Object)Files.readAttributes(path, PosixFileAttributes.class, linkOptionArray), PosixFileAttributes.class)).permissions();
    }

    public static Path setPosixFilePermissions(Path path, Set<PosixFilePermission> set) throws IOException {
        PosixFileAttributeView posixFileAttributeView = (PosixFileAttributeView)g.convertForCast((Object)Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]), PosixFileAttributeView.class);
        if (posixFileAttributeView == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
        }
        posixFileAttributeView.setPermissions(set);
        return path;
    }

    public static UserPrincipal getOwner(Path path, LinkOption ... linkOptionArray) throws IOException {
        FileOwnerAttributeView fileOwnerAttributeView = (FileOwnerAttributeView)g.convertForCast((Object)Files.getFileAttributeView(path, FileOwnerAttributeView.class, linkOptionArray), FileOwnerAttributeView.class);
        if (fileOwnerAttributeView == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
        }
        return fileOwnerAttributeView.getOwner();
    }

    public static Path setOwner(Path path, UserPrincipal userPrincipal) throws IOException {
        FileOwnerAttributeView fileOwnerAttributeView = (FileOwnerAttributeView)g.convertForCast((Object)Files.getFileAttributeView(path, FileOwnerAttributeView.class, new LinkOption[0]), FileOwnerAttributeView.class);
        if (fileOwnerAttributeView == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
        }
        fileOwnerAttributeView.setOwner(userPrincipal);
        return path;
    }

    public static boolean isSymbolicLink(Path path) {
        try {
            return Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS).isSymbolicLink();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isDirectory(Path path, LinkOption ... linkOptionArray) {
        try {
            return Files.readAttributes(path, BasicFileAttributes.class, linkOptionArray).isDirectory();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isRegularFile(Path path, LinkOption ... linkOptionArray) {
        try {
            return Files.readAttributes(path, BasicFileAttributes.class, linkOptionArray).isRegularFile();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static FileTime getLastModifiedTime(Path path, LinkOption ... linkOptionArray) throws IOException {
        return Files.readAttributes(path, BasicFileAttributes.class, linkOptionArray).lastModifiedTime();
    }

    public static Path setLastModifiedTime(Path path, FileTime fileTime) throws IOException {
        ((BasicFileAttributeView)g.convertForCast((Object)Files.getFileAttributeView(path, BasicFileAttributeView.class, new LinkOption[0]), BasicFileAttributeView.class)).setTimes(fileTime, null, null);
        return path;
    }

    public static long size(Path path) throws IOException {
        return Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]).size();
    }

    private static boolean followLinks(LinkOption ... linkOptionArray) {
        boolean bl = true;
        for (LinkOption linkOption : linkOptionArray) {
            if (f.ifAcmp((Object)linkOption, (Object)LinkOption.NOFOLLOW_LINKS)) {
                if (linkOption == null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError((Object)"Should not get here"));
            }
            bl = false;
        }
        return bl;
    }

    public static boolean exists(Path path, LinkOption ... linkOptionArray) {
        try {
            if (Files.followLinks(linkOptionArray)) {
                Files.provider(path).checkAccess(path, new AccessMode[0]);
            } else {
                Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean notExists(Path path, LinkOption ... linkOptionArray) {
        try {
            if (Files.followLinks(linkOptionArray)) {
                Files.provider(path).checkAccess(path, new AccessMode[0]);
            } else {
                Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            }
            return false;
        }
        catch (NoSuchFileException noSuchFileException) {
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static boolean isAccessible(Path path, AccessMode ... accessModeArray) {
        try {
            Files.provider(path).checkAccess(path, accessModeArray);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isReadable(Path path) {
        AccessMode[] accessModeArray = new AccessMode[1];
        a.arrayStore((Object[])accessModeArray, (int)0, (Object)((Object)AccessMode.READ));
        return Files.isAccessible(path, accessModeArray);
    }

    public static boolean isWritable(Path path) {
        AccessMode[] accessModeArray = new AccessMode[1];
        a.arrayStore((Object[])accessModeArray, (int)0, (Object)((Object)AccessMode.WRITE));
        return Files.isAccessible(path, accessModeArray);
    }

    public static boolean isExecutable(Path path) {
        AccessMode[] accessModeArray = new AccessMode[1];
        a.arrayStore((Object[])accessModeArray, (int)0, (Object)((Object)AccessMode.EXECUTE));
        return Files.isAccessible(path, accessModeArray);
    }

    public static Path walkFileTree(Path path, Set<FileVisitOption> set, int n2, FileVisitor<? super Path> fileVisitor) throws IOException {
        if (n2 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("'maxDepth' is negative"));
        }
        new FileTreeWalker(set, fileVisitor, n2).walk(path);
        return path;
    }

    public static Path walkFileTree(Path path, FileVisitor<? super Path> fileVisitor) throws IOException {
        return Files.walkFileTree(path, EnumSet.noneOf(FileVisitOption.class), Integer.MAX_VALUE, fileVisitor);
    }

    public static BufferedReader newBufferedReader(Path path, Charset charset) throws IOException {
        CharsetDecoder charsetDecoder = charset.newDecoder();
        InputStreamReader inputStreamReader = new InputStreamReader(Files.newInputStream(path, new OpenOption[0]), charsetDecoder);
        return new BufferedReader(inputStreamReader);
    }

    public static BufferedWriter newBufferedWriter(Path path, Charset charset, OpenOption ... openOptionArray) throws IOException {
        CharsetEncoder charsetEncoder = charset.newEncoder();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(Files.newOutputStream(path, openOptionArray), charsetEncoder);
        return new BufferedWriter(outputStreamWriter);
    }

    private static long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n2;
        long l = 0L;
        byte[] byArray = new byte[8192];
        while ((n2 = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n2);
            l += (long)n2;
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long copy(InputStream inputStream, Path path, CopyOption ... copyOptionArray) throws IOException {
        long l;
        OutputStream outputStream;
        block16: {
            OutputStream outputStream2;
            Object object;
            Objects.requireNonNull(inputStream);
            boolean bl = false;
            Object object2 = copyOptionArray;
            int n2 = a.arrayLength((Object[])object2);
            for (int i = 0; i < n2; ++i) {
                object = (CopyOption)g.convertForCast((Object)a.arrayLoad((Object[])object2, (int)i), CopyOption.class);
                if (f.ifAcmp((Object)object, (Object)StandardCopyOption.REPLACE_EXISTING)) {
                    if (object != null) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException(object + " not supported"));
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("options contains 'null'"));
                }
                bl = true;
            }
            object2 = null;
            if (bl) {
                try {
                    Files.deleteIfExists(path);
                }
                catch (SecurityException securityException) {
                    object2 = securityException;
                }
            }
            try {
                Object[] objectArray = new OpenOption[2];
                a.arrayStore((Object[])objectArray, (int)0, (Object)StandardOpenOption.CREATE_NEW);
                a.arrayStore((Object[])objectArray, (int)1, (Object)StandardOpenOption.WRITE);
                outputStream2 = Files.newOutputStream(path, (OpenOption[])objectArray);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                if (object2 == null) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)fileAlreadyExistsException);
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)object2);
            }
            outputStream = outputStream2;
            object = null;
            try {
                l = Files.copy(inputStream, outputStream);
                if (outputStream == null) return l;
                if (object == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    object = throwable;
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
                catch (Throwable throwable2) {
                    if (outputStream == null) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable2);
                    if (object == null) {
                        outputStream.close();
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable2);
                    }
                    try {
                        outputStream.close();
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable2);
                    }
                    catch (Throwable throwable3) {
                        ((Throwable)object).addSuppressed(throwable3);
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable2);
                    }
                }
            }
            try {
                outputStream.close();
                return l;
            }
            catch (Throwable throwable) {
                ((Throwable)object).addSuppressed(throwable);
                return l;
            }
        }
        outputStream.close();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long copy(Path path, OutputStream outputStream) throws IOException {
        long l;
        InputStream inputStream;
        block9: {
            Objects.requireNonNull(outputStream);
            inputStream = Files.newInputStream(path, new OpenOption[0]);
            Throwable throwable = null;
            try {
                l = Files.copy(inputStream, outputStream);
                if (inputStream == null) return l;
                if (throwable == null) break block9;
            }
            catch (Throwable throwable3) {
                try {
                    throwable = throwable3;
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable3);
                }
                catch (Throwable throwable4) {
                    if (inputStream == null) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable4);
                    if (throwable == null) {
                        inputStream.close();
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable4);
                    }
                    try {
                        inputStream.close();
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable4);
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable4);
                    }
                }
            }
            try {
                inputStream.close();
                return l;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
                return l;
            }
        }
        inputStream.close();
        return l;
    }

    private static byte[] read(InputStream inputStream, int n2) throws IOException {
        int n3;
        int n4 = n2;
        byte[] byArray = new byte[n4];
        int n5 = 0;
        int n6 = byArray.length;
        while ((n3 = inputStream.read(byArray, n5, n6)) > 0) {
            n5 += n3;
            if (!$assertionsDisabled && (n6 -= n3) < 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            if (n6 != 0) continue;
            int n7 = n4 << 1;
            if (n7 < 0) {
                if (n4 == Integer.MAX_VALUE) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new OutOfMemoryError("Required array size too large"));
                }
                n7 = Integer.MAX_VALUE;
            }
            n6 = n7 - n4;
            byArray = Arrays.copyOf(byArray, n7);
            n4 = n7;
        }
        return n4 == n5 ? byArray : Arrays.copyOf(byArray, n5);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readAllBytes(Path path) throws IOException {
        byte[] byArray;
        InputStream inputStream;
        block10: {
            long l = Files.size(path);
            if (l > Integer.MAX_VALUE) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new OutOfMemoryError("Required array size too large"));
            }
            inputStream = Files.newInputStream(path, new OpenOption[0]);
            Throwable throwable = null;
            try {
                byArray = Files.read(inputStream, (int)l);
                if (inputStream == null) return byArray;
                if (throwable == null) break block10;
            }
            catch (Throwable throwable3) {
                try {
                    throwable = throwable3;
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable3);
                }
                catch (Throwable throwable4) {
                    if (inputStream == null) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable4);
                    if (throwable == null) {
                        inputStream.close();
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable4);
                    }
                    try {
                        inputStream.close();
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable4);
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable4);
                    }
                }
            }
            try {
                inputStream.close();
                return byArray;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
                return byArray;
            }
        }
        inputStream.close();
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> readAllLines(Path path, Charset charset) throws IOException {
        Object object;
        BufferedReader bufferedReader;
        block11: {
            bufferedReader = Files.newBufferedReader(path, charset);
            Throwable throwable = null;
            try {
                ArrayList<String> arrayList = new ArrayList<String>();
                while (true) {
                    if ((object = bufferedReader.readLine()) == null) {
                        object = arrayList;
                        if (bufferedReader == null) return object;
                        if (throwable == null) break block11;
                        break;
                    }
                    arrayList.add((String)object);
                }
            }
            catch (Throwable throwable3) {
                try {
                    throwable = throwable3;
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable3);
                }
                catch (Throwable throwable4) {
                    if (bufferedReader == null) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable4);
                    if (throwable == null) {
                        bufferedReader.close();
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable4);
                    }
                    try {
                        bufferedReader.close();
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable4);
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable4);
                    }
                }
            }
            try {
                bufferedReader.close();
                return object;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
                return object;
            }
        }
        bufferedReader.close();
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Path write(Path path, byte[] byArray, OpenOption ... openOptionArray) throws IOException {
        OutputStream outputStream;
        block10: {
            Objects.requireNonNull(byArray);
            outputStream = Files.newOutputStream(path, openOptionArray);
            Throwable throwable = null;
            try {
                int n2;
                int n3;
                for (int i = n2 = byArray.length; i > 0; i -= n3) {
                    n3 = Math.min(i, 8192);
                    outputStream.write(byArray, n2 - i, n3);
                }
                if (outputStream == null) return path;
                if (throwable == null) break block10;
            }
            catch (Throwable throwable3) {
                try {
                    throwable = throwable3;
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable3);
                }
                catch (Throwable throwable4) {
                    if (outputStream == null) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable4);
                    if (throwable == null) {
                        outputStream.close();
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable4);
                    }
                    try {
                        outputStream.close();
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable4);
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable4);
                    }
                }
            }
            try {
                outputStream.close();
                return path;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
                return path;
            }
        }
        outputStream.close();
        return path;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Path write(Path path, Iterable<? extends CharSequence> iterable, Charset charset, OpenOption ... openOptionArray) throws IOException {
        BufferedWriter bufferedWriter;
        block10: {
            Objects.requireNonNull(iterable);
            CharsetEncoder charsetEncoder = charset.newEncoder();
            OutputStream outputStream = Files.newOutputStream(path, openOptionArray);
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, charsetEncoder));
            Throwable throwable = null;
            try {
                Iterator<? extends CharSequence> iterator = iterable.iterator();
                while (iterator.hasNext()) {
                    CharSequence charSequence = (CharSequence)g.convertForCast((Object)iterator.next(), CharSequence.class);
                    bufferedWriter.append(charSequence);
                    bufferedWriter.newLine();
                }
                if (bufferedWriter == null) return path;
                if (throwable == null) break block10;
            }
            catch (Throwable throwable3) {
                try {
                    throwable = throwable3;
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable3);
                }
                catch (Throwable throwable4) {
                    if (bufferedWriter == null) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable4);
                    if (throwable == null) {
                        bufferedWriter.close();
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable4);
                    }
                    try {
                        bufferedWriter.close();
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable4);
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable4);
                    }
                }
            }
            try {
                bufferedWriter.close();
                return path;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
                return path;
            }
        }
        bufferedWriter.close();
        return path;
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    private static class AcceptAllFilter
    extends h
    implements DirectoryStream.Filter {
        static final AcceptAllFilter FILTER = new AcceptAllFilter();

        private AcceptAllFilter() {
        }

        public boolean accept(Path path) {
            return true;
        }

        protected /* synthetic */ AcceptAllFilter(h h2) {
            super(h2);
        }
    }

    private static class FileTypeDetectors
    extends h {
        static final FileTypeDetector defaultFileTypeDetector = FileTypeDetectors.createDefaultFileTypeDetector();
        static final List<FileTypeDetector> installeDetectors = FileTypeDetectors.loadInstalledDetectors();

        private FileTypeDetectors() {
        }

        private static FileTypeDetector createDefaultFileTypeDetector() {
            return (FileTypeDetector)g.convertForCast((Object)AccessController.doPrivileged(new PrivilegedAction<FileTypeDetector>(){

                @Override
                public FileTypeDetector run() {
                    return DefaultFileTypeDetector.create();
                }
            }), FileTypeDetector.class);
        }

        private static List<FileTypeDetector> loadInstalledDetectors() {
            return (List)g.convertForCast(AccessController.doPrivileged(new PrivilegedAction<List<FileTypeDetector>>(){

                @Override
                public List<FileTypeDetector> run() {
                    ArrayList<FileTypeDetector> list = new ArrayList<FileTypeDetector>();
                    ServiceLoader<FileTypeDetector> loader = ServiceLoader.load(FileTypeDetector.class, ClassLoader.getSystemClassLoader());
                    for (FileTypeDetector detector : loader) {
                        list.add(detector);
                    }
                    return list;
                }
            }), List.class);
        }

        protected /* synthetic */ FileTypeDetectors(h h2) {
            super(h2);
        }
    }
}

