/*
 * Decompiled with CFR 0.152.
 */
package java.nio.file.spi;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public abstract class FileSystemProvider
extends h {
    private static final Object lock = new Object();
    private static volatile List<FileSystemProvider> installedProviders;
    private static boolean loadingProviders;

    private static Void checkPermission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("fileSystemProvider"));
        }
        return null;
    }

    private FileSystemProvider(Void void_) {
    }

    protected FileSystemProvider() {
        this(FileSystemProvider.checkPermission());
    }

    private static List<FileSystemProvider> loadInstalledProviders() {
        ArrayList<FileSystemProvider> arrayList = new ArrayList<FileSystemProvider>();
        ServiceLoader<FileSystemProvider> serviceLoader = ServiceLoader.load(FileSystemProvider.class, ClassLoader.getSystemClassLoader());
        Iterator iterator = serviceLoader.iterator();
        while (iterator.hasNext()) {
            FileSystemProvider fileSystemProvider = (FileSystemProvider)((Object)g.convertForCast(iterator.next(), FileSystemProvider.class));
            String string = fileSystemProvider.getScheme();
            if (string.equalsIgnoreCase("file")) continue;
            boolean bl = false;
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                FileSystemProvider fileSystemProvider2 = (FileSystemProvider)((Object)g.convertForCast(iterator2.next(), FileSystemProvider.class));
                if (!fileSystemProvider2.getScheme().equalsIgnoreCase(string)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(fileSystemProvider);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FileSystemProvider> installedProviders() {
        if (installedProviders == null) {
            FileSystemProvider fileSystemProvider = FileSystems.getDefault().provider();
            Object object = ah.getMonitor((Object)lock);
            synchronized (object) {
                try {
                    if (installedProviders == null) {
                        if (loadingProviders) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Error("Circular loading of installed providers detected"));
                        }
                        loadingProviders = true;
                        List list = (List)g.convertForCast(AccessController.doPrivileged(new PrivilegedAction<List<FileSystemProvider>>(){

                            @Override
                            public List<FileSystemProvider> run() {
                                return FileSystemProvider.loadInstalledProviders();
                            }
                        }), List.class);
                        list.add(0, fileSystemProvider);
                        installedProviders = Collections.unmodifiableList(list);
                    }
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
        return installedProviders;
    }

    public abstract String getScheme();

    public abstract FileSystem newFileSystem(URI var1, Map<String, ?> var2) throws IOException;

    public abstract FileSystem getFileSystem(URI var1);

    public abstract Path getPath(URI var1);

    public FileSystem newFileSystem(Path path, Map<String, ?> map) throws IOException {
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
    }

    public InputStream newInputStream(Path path, OpenOption ... openOptionArray) throws IOException {
        if (a.arrayLength((Object[])openOptionArray) > 0) {
            Object[] objectArray = openOptionArray;
            int n = a.arrayLength((Object[])objectArray);
            for (int i = 0; i < n; ++i) {
                OpenOption openOption = (OpenOption)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), OpenOption.class);
                if (!f.ifAcmp((Object)openOption, (Object)StandardOpenOption.READ)) continue;
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException("'" + openOption + "' not allowed"));
            }
        }
        return Channels.newInputStream(Files.newByteChannel(path, new OpenOption[0]));
    }

    public OutputStream newOutputStream(Path path, OpenOption ... openOptionArray) throws IOException {
        int n = a.arrayLength((Object[])openOptionArray);
        HashSet<OpenOption> hashSet = new HashSet<OpenOption>(n + 3);
        if (n == 0) {
            hashSet.add(StandardOpenOption.CREATE);
            hashSet.add(StandardOpenOption.TRUNCATE_EXISTING);
        } else {
            Object[] objectArray = openOptionArray;
            int n2 = a.arrayLength((Object[])objectArray);
            for (int i = 0; i < n2; ++i) {
                OpenOption openOption = (OpenOption)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), OpenOption.class);
                if (!f.ifAcmp((Object)openOption, (Object)StandardOpenOption.READ)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("READ not allowed"));
                }
                hashSet.add(openOption);
            }
        }
        hashSet.add(StandardOpenOption.WRITE);
        return Channels.newOutputStream(this.newByteChannel(path, hashSet, new FileAttribute[0]));
    }

    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> set, FileAttribute<?> ... fileAttributeArray) throws IOException {
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
    }

    public AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set<? extends OpenOption> set, ExecutorService executorService, FileAttribute<?> ... fileAttributeArray) throws IOException {
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
    }

    public abstract SeekableByteChannel newByteChannel(Path var1, Set<? extends OpenOption> var2, FileAttribute<?> ... var3) throws IOException;

    public abstract DirectoryStream<Path> newDirectoryStream(Path var1, DirectoryStream.Filter<? super Path> var2) throws IOException;

    public abstract void createDirectory(Path var1, FileAttribute<?> ... var2) throws IOException;

    public void createSymbolicLink(Path path, Path path2, FileAttribute<?> ... fileAttributeArray) throws IOException {
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
    }

    public void createLink(Path path, Path path2) throws IOException {
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
    }

    public abstract void delete(Path var1) throws IOException;

    public boolean deleteIfExists(Path path) throws IOException {
        try {
            this.delete(path);
            return true;
        }
        catch (NoSuchFileException noSuchFileException) {
            return false;
        }
    }

    public Path readSymbolicLink(Path path) throws IOException {
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
    }

    public abstract void copy(Path var1, Path var2, CopyOption ... var3) throws IOException;

    public abstract void move(Path var1, Path var2, CopyOption ... var3) throws IOException;

    public abstract boolean isSameFile(Path var1, Path var2) throws IOException;

    public abstract boolean isHidden(Path var1) throws IOException;

    public abstract FileStore getFileStore(Path var1) throws IOException;

    public abstract void checkAccess(Path var1, AccessMode ... var2) throws IOException;

    public abstract <V extends FileAttributeView> V getFileAttributeView(Path var1, Class<V> var2, LinkOption ... var3);

    public abstract <A extends BasicFileAttributes> A readAttributes(Path var1, Class<A> var2, LinkOption ... var3) throws IOException;

    public abstract Map<String, Object> readAttributes(Path var1, String var2, LinkOption ... var3) throws IOException;

    public abstract void setAttribute(Path var1, String var2, Object var3, LinkOption ... var4) throws IOException;

    static /* synthetic */ List access$000() {
        return FileSystemProvider.loadInstalledProviders();
    }

    static {
        loadingProviders = false;
    }

    protected /* synthetic */ FileSystemProvider(h h2) {
        super(h2);
    }
}

