/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import sun.security.util.Debug;
import sun.security.util.SecurityConstants;

public final class AccessControlContext
extends h {
    private ProtectionDomain[] context;
    private boolean isPrivileged;
    private boolean isAuthorized = false;
    private AccessControlContext privilegedContext;
    private DomainCombiner combiner = null;
    private static boolean debugInit = false;
    private static Debug debug = null;

    static Debug getDebug() {
        if (debugInit) {
            return debug;
        }
        if (Policy.isSet()) {
            debug = Debug.getInstance("access");
            debugInit = true;
        }
        return debug;
    }

    public AccessControlContext(ProtectionDomain[] protectionDomainArray) {
        if (a.arrayLength((Object[])protectionDomainArray) == 0) {
            this.context = null;
        } else if (a.arrayLength((Object[])protectionDomainArray) == 1) {
            this.context = (ProtectionDomain)((Object)g.convertForCast((Object)a.arrayLoad((Object[])protectionDomainArray, (int)0), ProtectionDomain.class)) != null ? (ProtectionDomain[])g.convertForCast((Object)a.cloneArray((Object)protectionDomainArray), ProtectionDomain[].class) : null;
        } else {
            ArrayList<ProtectionDomain> arrayList = new ArrayList<ProtectionDomain>(a.arrayLength((Object[])protectionDomainArray));
            for (int i = 0; i < a.arrayLength((Object[])protectionDomainArray); ++i) {
                if ((ProtectionDomain)((Object)g.convertForCast((Object)a.arrayLoad((Object[])protectionDomainArray, (int)i), ProtectionDomain.class)) == null || arrayList.contains((Object)((ProtectionDomain)((Object)g.convertForCast((Object)a.arrayLoad((Object[])protectionDomainArray, (int)i), ProtectionDomain.class))))) continue;
                arrayList.add((ProtectionDomain)((Object)g.convertForCast((Object)a.arrayLoad((Object[])protectionDomainArray, (int)i), ProtectionDomain.class)));
            }
            if (!arrayList.isEmpty()) {
                this.context = new ProtectionDomain[arrayList.size()];
                this.context = (ProtectionDomain[])g.convertForCast((Object)arrayList.toArray(this.context), ProtectionDomain[].class);
            }
        }
    }

    public AccessControlContext(AccessControlContext accessControlContext, DomainCombiner domainCombiner) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.CREATE_ACC_PERMISSION);
            this.isAuthorized = true;
        }
        this.context = accessControlContext.context;
        this.combiner = domainCombiner;
    }

    AccessControlContext(ProtectionDomain[] protectionDomainArray, DomainCombiner domainCombiner) {
        if (protectionDomainArray != null) {
            this.context = (ProtectionDomain[])g.convertForCast((Object)a.cloneArray((Object)protectionDomainArray), ProtectionDomain[].class);
        }
        this.combiner = domainCombiner;
        this.isAuthorized = true;
    }

    AccessControlContext(ProtectionDomain[] protectionDomainArray, boolean bl) {
        this.context = protectionDomainArray;
        this.isPrivileged = bl;
        this.isAuthorized = true;
    }

    AccessControlContext(ProtectionDomain[] protectionDomainArray, AccessControlContext accessControlContext) {
        this.context = protectionDomainArray;
        this.privilegedContext = accessControlContext;
        this.isPrivileged = true;
    }

    ProtectionDomain[] getContext() {
        return this.context;
    }

    boolean isPrivileged() {
        return this.isPrivileged;
    }

    DomainCombiner getAssignedCombiner() {
        AccessControlContext accessControlContext = this.isPrivileged ? this.privilegedContext : AccessController.getInheritedAccessControlContext();
        if (accessControlContext != null) {
            return accessControlContext.combiner;
        }
        return null;
    }

    public DomainCombiner getDomainCombiner() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.GET_COMBINER_PERMISSION);
        }
        return this.combiner;
    }

    public void checkPermission(Permission permission) throws AccessControlException {
        int n2;
        boolean bl = false;
        if (permission == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("permission can't be null"));
        }
        if (AccessControlContext.getDebug() != null) {
            boolean bl2 = bl = !Debug.isOn("codebase=");
            if (!bl) {
                for (n2 = 0; this.context != null && n2 < a.arrayLength((Object[])this.context); ++n2) {
                    if (((ProtectionDomain)((Object)g.convertForCast((Object)a.arrayLoad((Object[])this.context, (int)n2), ProtectionDomain.class))).getCodeSource() == null || ((ProtectionDomain)((Object)g.convertForCast((Object)a.arrayLoad((Object[])this.context, (int)n2), ProtectionDomain.class))).getCodeSource().getLocation() == null || !Debug.isOn("codebase=" + ((ProtectionDomain)((Object)g.convertForCast((Object)a.arrayLoad((Object[])this.context, (int)n2), ProtectionDomain.class))).getCodeSource().getLocation().toString())) continue;
                    bl = true;
                    break;
                }
            }
            if ((bl &= !Debug.isOn("permission=") || Debug.isOn("permission=" + ai.getCurrentClass(permission.getClass()).getCanonicalName())) && Debug.isOn("stack")) {
                Thread.currentThread();
                Thread.dumpStack();
            }
            if (bl && Debug.isOn("domain")) {
                if (this.context == null) {
                    debug.println("domain (context is null)");
                } else {
                    for (n2 = 0; n2 < a.arrayLength((Object[])this.context); ++n2) {
                        debug.println("domain " + n2 + " " + (Object)((Object)((ProtectionDomain)((Object)g.convertForCast((Object)a.arrayLoad((Object[])this.context, (int)n2), ProtectionDomain.class)))));
                    }
                }
            }
        }
        if (this.context == null) {
            return;
        }
        for (n2 = 0; n2 < a.arrayLength((Object[])this.context); ++n2) {
            if ((ProtectionDomain)((Object)g.convertForCast((Object)a.arrayLoad((Object[])this.context, (int)n2), ProtectionDomain.class)) == null || ((ProtectionDomain)((Object)g.convertForCast((Object)a.arrayLoad((Object[])this.context, (int)n2), ProtectionDomain.class))).implies(permission)) continue;
            if (bl) {
                debug.println("access denied " + permission);
            }
            if (Debug.isOn("failure") && debug != null) {
                if (!bl) {
                    debug.println("access denied " + permission);
                }
                Thread.currentThread();
                Thread.dumpStack();
                final ProtectionDomain protectionDomain = (ProtectionDomain)((Object)g.convertForCast((Object)a.arrayLoad((Object[])this.context, (int)n2), ProtectionDomain.class));
                final Debug debug = AccessControlContext.debug;
                AccessController.doPrivileged(new PrivilegedAction<Object>(this){

                    @Override
                    public Void run() {
                        debug.println("domain that failed " + (Object)((Object)protectionDomain));
                        return null;
                    }
                });
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AccessControlException("access denied " + permission, permission));
        }
        if (bl) {
            debug.println("access allowed " + permission);
        }
    }

    AccessControlContext optimize() {
        boolean bl;
        AccessControlContext accessControlContext = this.isPrivileged ? this.privilegedContext : AccessController.getInheritedAccessControlContext();
        boolean bl2 = this.context == null;
        boolean bl3 = bl = accessControlContext == null || accessControlContext.context == null;
        if (accessControlContext != null && accessControlContext.combiner != null) {
            return this.goCombiner(this.context, accessControlContext);
        }
        if (bl && bl2) {
            return this;
        }
        if (bl2) {
            return accessControlContext;
        }
        int n2 = a.arrayLength((Object[])this.context);
        if (bl && n2 <= 2) {
            return this;
        }
        if (n2 == 1 && !f.ifAcmp((Object)((Object)((ProtectionDomain)((Object)g.convertForCast((Object)a.arrayLoad((Object[])this.context, (int)0), ProtectionDomain.class)))), (Object)((Object)((ProtectionDomain)((Object)g.convertForCast((Object)a.arrayLoad((Object[])accessControlContext.context, (int)0), ProtectionDomain.class)))))) {
            return accessControlContext;
        }
        int n3 = bl ? 0 : a.arrayLength((Object[])accessControlContext.context);
        ProtectionDomain[] protectionDomainArray = new ProtectionDomain[n2 + n3];
        if (!bl) {
            a.arraycopy((Object)accessControlContext.context, (int)0, (Object)protectionDomainArray, (int)0, (int)n3);
        }
        block0: for (int i = 0; i < a.arrayLength((Object[])this.context); ++i) {
            ProtectionDomain protectionDomain = (ProtectionDomain)((Object)g.convertForCast((Object)a.arrayLoad((Object[])this.context, (int)i), ProtectionDomain.class));
            if (protectionDomain == null) continue;
            for (int k = 0; k < n3; ++k) {
                if (!f.ifAcmp((Object)((Object)protectionDomain), (Object)((Object)((ProtectionDomain)((Object)g.convertForCast((Object)a.arrayLoad((Object[])protectionDomainArray, (int)k), ProtectionDomain.class)))))) continue block0;
            }
            a.arrayStore((Object[])protectionDomainArray, (int)n3++, (Object)((Object)protectionDomain));
        }
        if (n3 != a.arrayLength((Object[])protectionDomainArray)) {
            if (!bl && n3 == a.arrayLength((Object[])accessControlContext.context)) {
                return accessControlContext;
            }
            if (bl && n3 == n2) {
                return this;
            }
            ProtectionDomain[] protectionDomainArray2 = new ProtectionDomain[n3];
            a.arraycopy((Object)protectionDomainArray, (int)0, (Object)protectionDomainArray2, (int)0, (int)n3);
            protectionDomainArray = protectionDomainArray2;
        }
        this.context = protectionDomainArray;
        this.combiner = null;
        this.isPrivileged = false;
        return this;
    }

    private AccessControlContext goCombiner(ProtectionDomain[] protectionDomainArray, AccessControlContext accessControlContext) {
        if (AccessControlContext.getDebug() != null) {
            debug.println("AccessControlContext invoking the Combiner");
        }
        ProtectionDomain[] protectionDomainArray2 = accessControlContext.combiner.combine(protectionDomainArray, accessControlContext.context);
        this.context = protectionDomainArray2;
        this.combiner = accessControlContext.combiner;
        this.isPrivileged = false;
        this.isAuthorized = accessControlContext.isAuthorized;
        return this;
    }

    public boolean equals(Object object) {
        if (!f.ifAcmp((Object)object, (Object)((Object)this))) {
            return true;
        }
        if (!(object instanceof AccessControlContext)) {
            return false;
        }
        AccessControlContext accessControlContext = (AccessControlContext)((Object)object);
        if (this.context == null) {
            return accessControlContext.context == null;
        }
        if (accessControlContext.context == null) {
            return false;
        }
        if (!this.containsAllPDs(accessControlContext) || !accessControlContext.containsAllPDs(this)) {
            return false;
        }
        if (this.combiner == null) {
            return accessControlContext.combiner == null;
        }
        if (accessControlContext.combiner == null) {
            return false;
        }
        return this.combiner.equals(accessControlContext.combiner);
    }

    private boolean containsAllPDs(AccessControlContext accessControlContext) {
        boolean bl = false;
        for (int i = 0; i < a.arrayLength((Object[])this.context); ++i) {
            bl = false;
            ProtectionDomain protectionDomain = (ProtectionDomain)((Object)g.convertForCast((Object)a.arrayLoad((Object[])this.context, (int)i), ProtectionDomain.class));
            if (protectionDomain == null) {
                for (int k = 0; k < a.arrayLength((Object[])accessControlContext.context) && !bl; ++k) {
                    bl = (ProtectionDomain)((Object)g.convertForCast((Object)a.arrayLoad((Object[])accessControlContext.context, (int)k), ProtectionDomain.class)) == null;
                }
            } else {
                Class<?> clazz = ((Object)((Object)protectionDomain)).getClass();
                for (int k = 0; k < a.arrayLength((Object[])accessControlContext.context) && !bl; ++k) {
                    ProtectionDomain protectionDomain2 = (ProtectionDomain)((Object)g.convertForCast((Object)a.arrayLoad((Object[])accessControlContext.context, (int)k), ProtectionDomain.class));
                    bl = protectionDomain2 != null && !f.ifAcmp(clazz, ((Object)((Object)protectionDomain2)).getClass()) && ((Object)((Object)protectionDomain)).equals((Object)protectionDomain2);
                }
            }
            if (bl) continue;
            return false;
        }
        return bl;
    }

    public int hashCode() {
        int n2 = 0;
        if (this.context == null) {
            return n2;
        }
        for (int i = 0; i < a.arrayLength((Object[])this.context); ++i) {
            if ((ProtectionDomain)((Object)g.convertForCast((Object)a.arrayLoad((Object[])this.context, (int)i), ProtectionDomain.class)) == null) continue;
            n2 ^= ((Object)((Object)((ProtectionDomain)((Object)g.convertForCast((Object)a.arrayLoad((Object[])this.context, (int)i), ProtectionDomain.class))))).hashCode();
        }
        return n2;
    }

    private static /* synthetic */ ProtectionDomain[] _jr$ig$context(AccessControlContext accessControlContext) {
        return accessControlContext.context;
    }

    private static /* synthetic */ void _jr$ip$context(AccessControlContext accessControlContext, ProtectionDomain[] protectionDomainArray) {
        accessControlContext.context = protectionDomainArray;
    }

    private static /* synthetic */ boolean _jr$ig$isPrivileged(AccessControlContext accessControlContext) {
        return accessControlContext.isPrivileged;
    }

    private static /* synthetic */ void _jr$ip$isPrivileged(AccessControlContext accessControlContext, boolean bl) {
        accessControlContext.isPrivileged = bl;
    }

    private static /* synthetic */ boolean _jr$ig$isAuthorized(AccessControlContext accessControlContext) {
        return accessControlContext.isAuthorized;
    }

    private static /* synthetic */ void _jr$ip$isAuthorized(AccessControlContext accessControlContext, boolean bl) {
        accessControlContext.isAuthorized = bl;
    }

    private static /* synthetic */ AccessControlContext _jr$ig$privilegedContext(AccessControlContext accessControlContext) {
        return accessControlContext.privilegedContext;
    }

    private static /* synthetic */ void _jr$ip$privilegedContext(AccessControlContext accessControlContext, AccessControlContext accessControlContext2) {
        accessControlContext.privilegedContext = accessControlContext2;
    }

    private static /* synthetic */ DomainCombiner _jr$ig$combiner(AccessControlContext accessControlContext) {
        return accessControlContext.combiner;
    }

    private static /* synthetic */ void _jr$ip$combiner(AccessControlContext accessControlContext, DomainCombiner domainCombiner) {
        accessControlContext.combiner = domainCombiner;
    }
}

