/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;
import sun.security.util.Debug;

public final class AccessController
extends h {
    private AccessController() {
    }

    @CallerSensitive
    public static native <T> T doPrivileged(PrivilegedAction<T> var0);

    @CallerSensitive
    public static <T> T doPrivilegedWithCombiner(PrivilegedAction<T> privilegedAction) {
        AccessControlContext accessControlContext = AccessController.getStackAccessControlContext();
        if (accessControlContext == null) {
            return AccessController.doPrivileged(privilegedAction);
        }
        DomainCombiner domainCombiner = accessControlContext.getAssignedCombiner();
        return AccessController.doPrivileged(privilegedAction, AccessController.preserveCombiner(domainCombiner, Reflection.getCallerClass()));
    }

    @CallerSensitive
    public static native <T> T doPrivileged(PrivilegedAction<T> var0, AccessControlContext var1);

    @CallerSensitive
    public static native <T> T doPrivileged(PrivilegedExceptionAction<T> var0) throws PrivilegedActionException;

    @CallerSensitive
    public static <T> T doPrivilegedWithCombiner(PrivilegedExceptionAction<T> privilegedExceptionAction) throws PrivilegedActionException {
        AccessControlContext accessControlContext = AccessController.getStackAccessControlContext();
        if (accessControlContext == null) {
            return AccessController.doPrivileged(privilegedExceptionAction);
        }
        DomainCombiner domainCombiner = accessControlContext.getAssignedCombiner();
        return AccessController.doPrivileged(privilegedExceptionAction, AccessController.preserveCombiner(domainCombiner, Reflection.getCallerClass()));
    }

    private static AccessControlContext preserveCombiner(DomainCombiner domainCombiner, Class<?> clazz) {
        ProtectionDomain protectionDomain = (ProtectionDomain)((Object)g.convertForCast(AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */), ProtectionDomain.class));
        ProtectionDomain[] protectionDomainArray = new ProtectionDomain[1];
        a.arrayStore((Object[])protectionDomainArray, (int)0, (Object)((Object)protectionDomain));
        ProtectionDomain[] protectionDomainArray2 = protectionDomainArray;
        if (domainCombiner == null) {
            return new AccessControlContext(protectionDomainArray2);
        }
        return new AccessControlContext(domainCombiner.combine(protectionDomainArray2, null), domainCombiner);
    }

    @CallerSensitive
    public static native <T> T doPrivileged(PrivilegedExceptionAction<T> var0, AccessControlContext var1) throws PrivilegedActionException;

    private static native AccessControlContext getStackAccessControlContext();

    static native AccessControlContext getInheritedAccessControlContext();

    public static AccessControlContext getContext() {
        AccessControlContext accessControlContext = AccessController.getStackAccessControlContext();
        if (accessControlContext == null) {
            return new AccessControlContext(null, true);
        }
        return accessControlContext.optimize();
    }

    public static void checkPermission(Permission permission) throws AccessControlException {
        if (permission == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("permission can't be null"));
        }
        AccessControlContext accessControlContext = AccessController.getStackAccessControlContext();
        if (accessControlContext == null) {
            Debug debug = AccessControlContext.getDebug();
            boolean bl = false;
            if (debug != null) {
                bl = !Debug.isOn("codebase=");
                bl &= !Debug.isOn("permission=") || Debug.isOn("permission=" + ai.getCurrentClass(permission.getClass()).getCanonicalName());
            }
            if (bl && Debug.isOn("stack")) {
                Thread.currentThread();
                Thread.dumpStack();
            }
            if (bl && Debug.isOn("domain")) {
                debug.println("domain (context is null)");
            }
            if (bl) {
                debug.println("access allowed " + permission);
            }
            return;
        }
        AccessControlContext accessControlContext2 = accessControlContext.optimize();
        accessControlContext2.checkPermission(permission);
    }
}

