/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.BasicPermissionCollection;
import java.security.Permission;
import java.security.PermissionCollection;

public abstract class BasicPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = 6279438298436773498L;
    private transient boolean wildcard;
    private transient String path;
    private transient boolean exitVM;

    private void init(String string) {
        if (string == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("name can't be null"));
        }
        int n = string.length();
        if (n == 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("name can't be empty"));
        }
        char c = string.charAt(n - 1);
        if (c == '*' && (n == 1 || string.charAt(n - 2) == '.')) {
            this.wildcard = true;
            if (n == 1) {
                this.path = "";
            } else {
                this.path = string.substring(0, n - 1);
            }
        } else if (string.equals("exitVM")) {
            this.wildcard = true;
            this.path = "exitVM.";
            this.exitVM = true;
        } else {
            this.path = string;
        }
    }

    public BasicPermission(String string) {
        super(string);
        this.init(string);
    }

    public BasicPermission(String string, String string2) {
        super(string);
        this.init(string);
    }

    @Override
    public boolean implies(Permission permission) {
        if (permission == null || f.ifAcmp(permission.getClass(), this.getClass())) {
            return false;
        }
        BasicPermission basicPermission = (BasicPermission)g.convertForCast((Object)permission, BasicPermission.class);
        if (this.wildcard) {
            if (basicPermission.wildcard) {
                return basicPermission.path.startsWith(this.path);
            }
            return basicPermission.path.length() > this.path.length() && basicPermission.path.startsWith(this.path);
        }
        if (basicPermission.wildcard) {
            return false;
        }
        return this.path.equals(basicPermission.path);
    }

    @Override
    public boolean equals(Object object) {
        if (!f.ifAcmp((Object)object, (Object)this)) {
            return true;
        }
        if (object == null || f.ifAcmp(object.getClass(), this.getClass())) {
            return false;
        }
        BasicPermission basicPermission = (BasicPermission)g.convertForCast((Object)object, BasicPermission.class);
        return this.getName().equals(basicPermission.getName());
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public String getActions() {
        return "";
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new BasicPermissionCollection(this.getClass());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(this.getName());
    }

    final String getCanonicalName() {
        return this.exitVM ? "exitVM.*" : this.getName();
    }

    protected /* synthetic */ BasicPermission(h h2) {
        super(h2);
    }
}

