/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.SocketPermission;
import java.net.URL;
import java.security.CodeSigner;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;

public class CodeSource
extends h
implements Serializable {
    private static final long serialVersionUID = 4977541819976013951L;
    private URL location;
    private transient CodeSigner[] signers;
    private transient Certificate[] certs;
    private transient SocketPermission sp;
    private transient CertificateFactory factory;

    public CodeSource(URL uRL, Certificate[] certificateArray) {
        this.signers = null;
        this.certs = null;
        this.factory = null;
        this.location = uRL;
        if (certificateArray != null) {
            this.certs = (Certificate[])g.convertForCast((Object)a.cloneArray((Object)certificateArray), Certificate[].class);
        }
    }

    public CodeSource(URL uRL, CodeSigner[] codeSignerArray) {
        this.signers = null;
        this.certs = null;
        this.factory = null;
        this.location = uRL;
        if (codeSignerArray != null) {
            this.signers = (CodeSigner[])a.cloneArray((Object)codeSignerArray);
        }
    }

    public int hashCode() {
        if (this.location != null) {
            return this.location.hashCode();
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (!f.ifAcmp((Object)object, (Object)this)) {
            return true;
        }
        if (!(g.convertForInstanceOf((Object)object, CodeSource.class) instanceof CodeSource)) {
            return false;
        }
        CodeSource codeSource = (CodeSource)g.convertForCast((Object)object, CodeSource.class);
        if (this.location == null ? codeSource.location != null : !this.location.equals(codeSource.location)) {
            return false;
        }
        return this.matchCerts(codeSource, true);
    }

    public final URL getLocation() {
        return this.location;
    }

    public final Certificate[] getCertificates() {
        if (this.certs != null) {
            return (Certificate[])g.convertForCast((Object)a.cloneArray((Object)this.certs), Certificate[].class);
        }
        if (this.signers != null) {
            ArrayList<? extends Certificate> arrayList = new ArrayList<Certificate>();
            for (int i = 0; i < this.signers.length; ++i) {
                arrayList.addAll(this.signers[i].getSignerCertPath().getCertificates());
            }
            this.certs = (Certificate[])g.convertForCast((Object)arrayList.toArray(new Certificate[arrayList.size()]), Certificate[].class);
            return (Certificate[])g.convertForCast((Object)a.cloneArray((Object)this.certs), Certificate[].class);
        }
        return null;
    }

    public final CodeSigner[] getCodeSigners() {
        if (this.signers != null) {
            return (CodeSigner[])a.cloneArray((Object)this.signers);
        }
        if (this.certs != null) {
            this.signers = this.convertCertArrayToSignerArray(this.certs);
            return (CodeSigner[])a.cloneArray((Object)this.signers);
        }
        return null;
    }

    public boolean implies(CodeSource codeSource) {
        if (codeSource == null) {
            return false;
        }
        return this.matchCerts(codeSource, false) && this.matchLocation(codeSource);
    }

    private boolean matchCerts(CodeSource codeSource, boolean bl) {
        if (this.certs == null && this.signers == null) {
            if (bl) {
                return codeSource.certs == null && codeSource.signers == null;
            }
            return true;
        }
        if (this.signers != null && codeSource.signers != null) {
            if (bl && this.signers.length != codeSource.signers.length) {
                return false;
            }
            for (int i = 0; i < this.signers.length; ++i) {
                boolean bl2 = false;
                for (int k = 0; k < codeSource.signers.length; ++k) {
                    if (!this.signers[i].equals(codeSource.signers[k])) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                return false;
            }
            return true;
        }
        if (this.certs != null && codeSource.certs != null) {
            if (bl && a.arrayLength((Object[])this.certs) != a.arrayLength((Object[])codeSource.certs)) {
                return false;
            }
            for (int i = 0; i < a.arrayLength((Object[])this.certs); ++i) {
                boolean bl3 = false;
                for (int k = 0; k < a.arrayLength((Object[])codeSource.certs); ++k) {
                    if (!((Certificate)g.convertForCast((Object)a.arrayLoad((Object[])this.certs, (int)i), Certificate.class)).equals((Certificate)g.convertForCast((Object)a.arrayLoad((Object[])codeSource.certs, (int)k), Certificate.class))) continue;
                    bl3 = true;
                    break;
                }
                if (bl3) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean matchLocation(CodeSource codeSource) {
        String string;
        String string2;
        if (this.location == null) {
            return true;
        }
        if (codeSource == null || codeSource.location == null) {
            return false;
        }
        if (this.location.equals(codeSource.location)) {
            return true;
        }
        if (!this.location.getProtocol().equalsIgnoreCase(codeSource.location.getProtocol())) {
            return false;
        }
        if (this.location.getPort() != -1 && this.location.getPort() != codeSource.location.getPort()) {
            return false;
        }
        if (this.location.getFile().endsWith("/-")) {
            string2 = this.location.getFile().substring(0, this.location.getFile().length() - 1);
            if (!codeSource.location.getFile().startsWith(string2)) {
                return false;
            }
        } else if (this.location.getFile().endsWith("/*")) {
            int n2 = codeSource.location.getFile().lastIndexOf(47);
            if (n2 == -1) {
                return false;
            }
            string = this.location.getFile().substring(0, this.location.getFile().length() - 1);
            String string3 = codeSource.location.getFile().substring(0, n2 + 1);
            if (!string3.equals(string)) {
                return false;
            }
        } else if (!codeSource.location.getFile().equals(this.location.getFile()) && !codeSource.location.getFile().equals(this.location.getFile() + "/")) {
            return false;
        }
        if (this.location.getRef() != null && !this.location.getRef().equals(codeSource.location.getRef())) {
            return false;
        }
        string2 = this.location.getHost();
        string = codeSource.location.getHost();
        if (!(string2 == null || ("".equals(string2) || "localhost".equals(string2)) && ("".equals(string) || "localhost".equals(string)) || string2.equalsIgnoreCase(string))) {
            if (string == null) {
                return false;
            }
            if (this.sp == null) {
                this.sp = new SocketPermission(string2, "resolve");
            }
            if (codeSource.sp == null) {
                codeSource.sp = new SocketPermission(string, "resolve");
            }
            if (!this.sp.implies(codeSource.sp)) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append(this.location);
        if (this.certs != null && a.arrayLength((Object[])this.certs) > 0) {
            for (int i = 0; i < a.arrayLength((Object[])this.certs); ++i) {
                stringBuilder.append(" " + (Certificate)g.convertForCast((Object)a.arrayLoad((Object[])this.certs, (int)i), Certificate.class));
            }
        } else if (this.signers != null && this.signers.length > 0) {
            for (int i = 0; i < this.signers.length; ++i) {
                stringBuilder.append(" " + this.signers[i]);
            }
        } else {
            stringBuilder.append(" <no signer certificates>");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.certs == null || a.arrayLength((Object[])this.certs) == 0) {
            objectOutputStream.writeInt(0);
        } else {
            objectOutputStream.writeInt(a.arrayLength((Object[])this.certs));
            for (int i = 0; i < a.arrayLength((Object[])this.certs); ++i) {
                Certificate certificate = (Certificate)g.convertForCast((Object)a.arrayLoad((Object[])this.certs, (int)i), Certificate.class);
                try {
                    objectOutputStream.writeUTF(certificate.getType());
                    byte[] byArray = certificate.getEncoded();
                    objectOutputStream.writeInt(byArray.length);
                    objectOutputStream.write(byArray);
                    continue;
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException(certificateEncodingException.getMessage()));
                }
            }
        }
        if (this.signers != null && this.signers.length > 0) {
            objectOutputStream.writeObject(this.signers);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Hashtable<String, CertificateFactory> hashtable = null;
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        if (n2 > 0) {
            hashtable = new Hashtable<String, CertificateFactory>(3);
            this.certs = new Certificate[n2];
        }
        for (int i = 0; i < n2; ++i) {
            CertificateFactory certificateFactory;
            String string = objectInputStream.readUTF();
            if (hashtable.containsKey(string)) {
                certificateFactory = (CertificateFactory)((Object)g.convertForCast(hashtable.get(string), CertificateFactory.class));
            } else {
                try {
                    certificateFactory = CertificateFactory.getInstance(string);
                }
                catch (CertificateException certificateException) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ClassNotFoundException("Certificate factory for " + string + " not found"));
                }
                hashtable.put(string, certificateFactory);
            }
            byte[] byArray = null;
            try {
                byArray = new byte[objectInputStream.readInt()];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Certificate too big"));
            }
            objectInputStream.readFully(byArray);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            try {
                a.arrayStore((Object[])this.certs, (int)i, (Object)certificateFactory.generateCertificate(byteArrayInputStream));
            }
            catch (CertificateException certificateException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException(certificateException.getMessage()));
            }
            byteArrayInputStream.close();
        }
        try {
            this.signers = (CodeSigner[])a.cloneArray((Object)((CodeSigner[])objectInputStream.readObject()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private CodeSigner[] convertCertArrayToSignerArray(Certificate[] certificateArray) {
        if (certificateArray == null) {
            return null;
        }
        try {
            if (this.factory == null) {
                this.factory = CertificateFactory.getInstance("X.509");
            }
            int n2 = 0;
            ArrayList<CodeSigner> arrayList = new ArrayList<CodeSigner>();
            while (n2 < a.arrayLength((Object[])certificateArray)) {
                int n3;
                ArrayList<Certificate> arrayList2 = new ArrayList<Certificate>();
                arrayList2.add((Certificate)g.convertForCast((Object)a.arrayLoad((Object[])certificateArray, (int)n2++), Certificate.class));
                for (n3 = n2; n3 < a.arrayLength((Object[])certificateArray) && g.convertForInstanceOf((Object)((Certificate)g.convertForCast((Object)a.arrayLoad((Object[])certificateArray, (int)n3), Certificate.class)), X509Certificate.class) instanceof X509Certificate && ((X509Certificate)g.convertForCast((Object)((Certificate)g.convertForCast((Object)a.arrayLoad((Object[])certificateArray, (int)n3), Certificate.class)), X509Certificate.class)).getBasicConstraints() != -1; ++n3) {
                    arrayList2.add((Certificate)g.convertForCast((Object)a.arrayLoad((Object[])certificateArray, (int)n3), Certificate.class));
                }
                n2 = n3;
                CertPath certPath = this.factory.generateCertPath(arrayList2);
                arrayList.add(new CodeSigner(certPath, null));
            }
            if (arrayList.isEmpty()) {
                return null;
            }
            return arrayList.toArray(new CodeSigner[arrayList.size()]);
        }
        catch (CertificateException certificateException) {
            return null;
        }
    }

    private static /* synthetic */ void _jr$ip$location(CodeSource codeSource, URL uRL) {
        codeSource.location = uRL;
    }

    protected /* synthetic */ CodeSource(h h2) {
        super(h2);
    }
}

