/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Iterator;
import java.util.List;
import sun.security.jca.GetInstance;
import sun.security.util.Debug;

public class KeyFactory
extends h {
    private static final Debug debug = Debug.getInstance("jca", "KeyFactory");
    private final String algorithm;
    private Provider provider;
    private volatile KeyFactorySpi spi;
    private final Object lock;
    private Iterator<Provider.Service> serviceIterator;

    protected KeyFactory(KeyFactorySpi keyFactorySpi, Provider provider, String string) {
        this.lock = new Object();
        this.spi = keyFactorySpi;
        this.provider = provider;
        this.algorithm = string;
    }

    private KeyFactory(String string) throws NoSuchAlgorithmException {
        this.lock = new Object();
        this.algorithm = string;
        List<Provider.Service> list = GetInstance.getServices("KeyFactory", string);
        this.serviceIterator = list.iterator();
        if (this.nextSpi(null) == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchAlgorithmException(string + " KeyFactory not available"));
        }
    }

    public static KeyFactory getInstance(String string) throws NoSuchAlgorithmException {
        return new KeyFactory(string);
    }

    public static KeyFactory getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        GetInstance.Instance instance = GetInstance.getInstance("KeyFactory", KeyFactorySpi.class, string, string2);
        return new KeyFactory((KeyFactorySpi)((Object)g.convertForCast((Object)instance.impl, KeyFactorySpi.class)), instance.provider, string);
    }

    public static KeyFactory getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        GetInstance.Instance instance = GetInstance.getInstance("KeyFactory", KeyFactorySpi.class, string, provider);
        return new KeyFactory((KeyFactorySpi)((Object)g.convertForCast((Object)instance.impl, KeyFactorySpi.class)), instance.provider, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Provider getProvider() {
        Object object = ah.getMonitor((Object)this.lock);
        synchronized (object) {
            try {
                this.serviceIterator = null;
                return this.provider;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyFactorySpi nextSpi(KeyFactorySpi keyFactorySpi) {
        Object object = ah.getMonitor((Object)this.lock);
        synchronized (object) {
            try {
                if (keyFactorySpi != null && f.ifAcmp((Object)((Object)keyFactorySpi), (Object)((Object)this.spi))) {
                    return this.spi;
                }
                if (this.serviceIterator == null) {
                    return null;
                }
                while (this.serviceIterator.hasNext()) {
                    Provider.Service service = (Provider.Service)((Object)g.convertForCast(this.serviceIterator.next(), Provider.Service.class));
                    try {
                        Object object2 = service.newInstance(null);
                        if (!(g.convertForInstanceOf((Object)object2, KeyFactorySpi.class) instanceof KeyFactorySpi)) continue;
                        KeyFactorySpi keyFactorySpi2 = (KeyFactorySpi)((Object)g.convertForCast((Object)object2, KeyFactorySpi.class));
                        this.provider = service.getProvider();
                        this.spi = keyFactorySpi2;
                        return keyFactorySpi2;
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    }
                }
                this.serviceIterator = null;
                return null;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public final PublicKey generatePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (this.serviceIterator == null) {
            return this.spi.engineGeneratePublic(keySpec);
        }
        Exception exception = null;
        KeyFactorySpi keyFactorySpi = this.spi;
        while (true) {
            try {
                return keyFactorySpi.engineGeneratePublic(keySpec);
            }
            catch (Exception exception2) {
                if (exception != null) continue;
                exception = exception2;
                if ((keyFactorySpi = this.nextSpi(keyFactorySpi)) != null) continue;
                if (g.convertForInstanceOf((Object)exception, RuntimeException.class) instanceof RuntimeException) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((RuntimeException)g.convertForCast((Object)exception, RuntimeException.class)));
                }
                if (g.convertForInstanceOf((Object)exception, InvalidKeySpecException.class) instanceof InvalidKeySpecException) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((InvalidKeySpecException)g.convertForCast((Object)exception, InvalidKeySpecException.class)));
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeySpecException("Could not generate public key", exception));
            }
            break;
        }
    }

    public final PrivateKey generatePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (this.serviceIterator == null) {
            return this.spi.engineGeneratePrivate(keySpec);
        }
        Exception exception = null;
        KeyFactorySpi keyFactorySpi = this.spi;
        while (true) {
            try {
                return keyFactorySpi.engineGeneratePrivate(keySpec);
            }
            catch (Exception exception2) {
                if (exception != null) continue;
                exception = exception2;
                if ((keyFactorySpi = this.nextSpi(keyFactorySpi)) != null) continue;
                if (g.convertForInstanceOf((Object)exception, RuntimeException.class) instanceof RuntimeException) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((RuntimeException)g.convertForCast((Object)exception, RuntimeException.class)));
                }
                if (g.convertForInstanceOf((Object)exception, InvalidKeySpecException.class) instanceof InvalidKeySpecException) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((InvalidKeySpecException)g.convertForCast((Object)exception, InvalidKeySpecException.class)));
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeySpecException("Could not generate private key", exception));
            }
            break;
        }
    }

    public final <T extends KeySpec> T getKeySpec(Key key, Class<T> clazz) throws InvalidKeySpecException {
        if (this.serviceIterator == null) {
            return this.spi.engineGetKeySpec(key, clazz);
        }
        Exception exception = null;
        KeyFactorySpi keyFactorySpi = this.spi;
        while (true) {
            try {
                return keyFactorySpi.engineGetKeySpec(key, clazz);
            }
            catch (Exception exception2) {
                if (exception != null) continue;
                exception = exception2;
                if ((keyFactorySpi = this.nextSpi(keyFactorySpi)) != null) continue;
                if (g.convertForInstanceOf((Object)exception, RuntimeException.class) instanceof RuntimeException) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((RuntimeException)g.convertForCast((Object)exception, RuntimeException.class)));
                }
                if (g.convertForInstanceOf((Object)exception, InvalidKeySpecException.class) instanceof InvalidKeySpecException) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((InvalidKeySpecException)g.convertForCast((Object)exception, InvalidKeySpecException.class)));
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeySpecException("Could not get key spec", exception));
            }
            break;
        }
    }

    public final Key translateKey(Key key) throws InvalidKeyException {
        if (this.serviceIterator == null) {
            return this.spi.engineTranslateKey(key);
        }
        Exception exception = null;
        KeyFactorySpi keyFactorySpi = this.spi;
        while (true) {
            try {
                return keyFactorySpi.engineTranslateKey(key);
            }
            catch (Exception exception2) {
                if (exception != null) continue;
                exception = exception2;
                if ((keyFactorySpi = this.nextSpi(keyFactorySpi)) != null) continue;
                if (g.convertForInstanceOf((Object)exception, RuntimeException.class) instanceof RuntimeException) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((RuntimeException)g.convertForCast((Object)exception, RuntimeException.class)));
                }
                if (g.convertForInstanceOf((Object)exception, InvalidKeyException.class) instanceof InvalidKeyException) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((InvalidKeyException)g.convertForCast((Object)exception, InvalidKeyException.class)));
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("Could not translate key", exception));
            }
            break;
        }
    }

    private static /* synthetic */ void _jr$ip$algorithm(KeyFactory keyFactory, String string) {
        keyFactory.algorithm = string;
    }

    private static /* synthetic */ void _jr$ip$lock(KeyFactory keyFactory, Object object) {
        keyFactory.lock = object;
    }

    protected /* synthetic */ KeyFactory(h h2) {
        super(h2);
    }
}

