/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;

public class KeyStore
extends h {
    private static final String KEYSTORE_TYPE = "keystore.type";
    private String type;
    private Provider provider;
    private KeyStoreSpi keyStoreSpi;
    private boolean initialized;

    protected KeyStore(KeyStoreSpi keyStoreSpi, Provider provider, String string) {
        this.initialized = false;
        this.keyStoreSpi = keyStoreSpi;
        this.provider = provider;
        this.type = string;
    }

    public static KeyStore getInstance(String string) throws KeyStoreException {
        try {
            Object[] objectArray = Security.getImpl(string, "KeyStore", (String)null);
            return new KeyStore((KeyStoreSpi)((Object)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)0), KeyStoreSpi.class)), (Provider)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)1), Provider.class), string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KeyStoreException(string + " not found", noSuchAlgorithmException));
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KeyStoreException(string + " not found", noSuchProviderException));
        }
    }

    public static KeyStore getInstance(String string, String string2) throws KeyStoreException, NoSuchProviderException {
        if (string2 == null || string2.length() == 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("missing provider"));
        }
        try {
            Object[] objectArray = Security.getImpl(string, "KeyStore", string2);
            return new KeyStore((KeyStoreSpi)((Object)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)0), KeyStoreSpi.class)), (Provider)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)1), Provider.class), string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KeyStoreException(string + " not found", noSuchAlgorithmException));
        }
    }

    public static KeyStore getInstance(String string, Provider provider) throws KeyStoreException {
        if (provider == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("missing provider"));
        }
        try {
            Object[] objectArray = Security.getImpl(string, "KeyStore", provider);
            return new KeyStore((KeyStoreSpi)((Object)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)0), KeyStoreSpi.class)), (Provider)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)1), Provider.class), string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KeyStoreException(string + " not found", noSuchAlgorithmException));
        }
    }

    public static final String getDefaultType() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public String run() {
                return Security.getProperty(KeyStore.KEYSTORE_TYPE);
            }
        });
        if (string == null) {
            string = "jks";
        }
        return string;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getType() {
        return this.type;
    }

    public final Key getKey(String string, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (!this.initialized) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KeyStoreException("Uninitialized keystore"));
        }
        return this.keyStoreSpi.engineGetKey(string, cArray);
    }

    public final Certificate[] getCertificateChain(String string) throws KeyStoreException {
        if (!this.initialized) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KeyStoreException("Uninitialized keystore"));
        }
        return this.keyStoreSpi.engineGetCertificateChain(string);
    }

    public final Certificate getCertificate(String string) throws KeyStoreException {
        if (!this.initialized) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KeyStoreException("Uninitialized keystore"));
        }
        return this.keyStoreSpi.engineGetCertificate(string);
    }

    public final Date getCreationDate(String string) throws KeyStoreException {
        if (!this.initialized) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KeyStoreException("Uninitialized keystore"));
        }
        return this.keyStoreSpi.engineGetCreationDate(string);
    }

    public final void setKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        if (!this.initialized) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KeyStoreException("Uninitialized keystore"));
        }
        if (g.convertForInstanceOf((Object)key, PrivateKey.class) instanceof PrivateKey && (certificateArray == null || a.arrayLength((Object[])certificateArray) == 0)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Private key must be accompanied by certificate chain"));
        }
        this.keyStoreSpi.engineSetKeyEntry(string, key, cArray, certificateArray);
    }

    public final void setKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        if (!this.initialized) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KeyStoreException("Uninitialized keystore"));
        }
        this.keyStoreSpi.engineSetKeyEntry(string, byArray, certificateArray);
    }

    public final void setCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        if (!this.initialized) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KeyStoreException("Uninitialized keystore"));
        }
        this.keyStoreSpi.engineSetCertificateEntry(string, certificate);
    }

    public final void deleteEntry(String string) throws KeyStoreException {
        if (!this.initialized) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KeyStoreException("Uninitialized keystore"));
        }
        this.keyStoreSpi.engineDeleteEntry(string);
    }

    public final Enumeration<String> aliases() throws KeyStoreException {
        if (!this.initialized) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KeyStoreException("Uninitialized keystore"));
        }
        return this.keyStoreSpi.engineAliases();
    }

    public final boolean containsAlias(String string) throws KeyStoreException {
        if (!this.initialized) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KeyStoreException("Uninitialized keystore"));
        }
        return this.keyStoreSpi.engineContainsAlias(string);
    }

    public final int size() throws KeyStoreException {
        if (!this.initialized) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KeyStoreException("Uninitialized keystore"));
        }
        return this.keyStoreSpi.engineSize();
    }

    public final boolean isKeyEntry(String string) throws KeyStoreException {
        if (!this.initialized) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KeyStoreException("Uninitialized keystore"));
        }
        return this.keyStoreSpi.engineIsKeyEntry(string);
    }

    public final boolean isCertificateEntry(String string) throws KeyStoreException {
        if (!this.initialized) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KeyStoreException("Uninitialized keystore"));
        }
        return this.keyStoreSpi.engineIsCertificateEntry(string);
    }

    public final String getCertificateAlias(Certificate certificate) throws KeyStoreException {
        if (!this.initialized) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KeyStoreException("Uninitialized keystore"));
        }
        return this.keyStoreSpi.engineGetCertificateAlias(certificate);
    }

    public final void store(OutputStream outputStream, char[] cArray) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        if (!this.initialized) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KeyStoreException("Uninitialized keystore"));
        }
        this.keyStoreSpi.engineStore(outputStream, cArray);
    }

    public final void store(LoadStoreParameter loadStoreParameter) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        if (!this.initialized) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KeyStoreException("Uninitialized keystore"));
        }
        this.keyStoreSpi.engineStore(loadStoreParameter);
    }

    public final void load(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.keyStoreSpi.engineLoad(inputStream, cArray);
        this.initialized = true;
    }

    public final void load(LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.keyStoreSpi.engineLoad(loadStoreParameter);
        this.initialized = true;
    }

    public final Entry getEntry(String string, ProtectionParameter protectionParameter) throws NoSuchAlgorithmException, UnrecoverableEntryException, KeyStoreException {
        if (string == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("invalid null input"));
        }
        if (!this.initialized) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KeyStoreException("Uninitialized keystore"));
        }
        return this.keyStoreSpi.engineGetEntry(string, protectionParameter);
    }

    public final void setEntry(String string, Entry entry, ProtectionParameter protectionParameter) throws KeyStoreException {
        if (string == null || entry == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("invalid null input"));
        }
        if (!this.initialized) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KeyStoreException("Uninitialized keystore"));
        }
        this.keyStoreSpi.engineSetEntry(string, entry, protectionParameter);
    }

    public final boolean entryInstanceOf(String string, Class<? extends Entry> clazz) throws KeyStoreException {
        if (string == null || clazz == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("invalid null input"));
        }
        if (!this.initialized) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KeyStoreException("Uninitialized keystore"));
        }
        return this.keyStoreSpi.engineEntryInstanceOf(string, clazz);
    }

    private static /* synthetic */ void _jr$ip$type(KeyStore keyStore, String string) {
        keyStore.type = string;
    }

    private static /* synthetic */ void _jr$ip$provider(KeyStore keyStore, Provider provider) {
        keyStore.provider = provider;
    }

    private static /* synthetic */ void _jr$ip$keyStoreSpi(KeyStore keyStore, KeyStoreSpi keyStoreSpi) {
        keyStore.keyStoreSpi = keyStoreSpi;
    }

    protected /* synthetic */ KeyStore(h h2) {
        super(h2);
    }

    public static abstract class Builder
    extends h {
        static final int MAX_CALLBACK_TRIES = 3;

        protected Builder() {
        }

        public abstract KeyStore getKeyStore() throws KeyStoreException;

        public abstract ProtectionParameter getProtectionParameter(String var1) throws KeyStoreException;

        public static Builder newInstance(final KeyStore keyStore, final ProtectionParameter protectionParameter) {
            if (keyStore == null || protectionParameter == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
            }
            if (!keyStore.initialized) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("KeyStore not initialized"));
            }
            return new Builder(){
                private volatile boolean getCalled;

                @Override
                public KeyStore getKeyStore() {
                    this.getCalled = true;
                    return keyStore;
                }

                @Override
                public ProtectionParameter getProtectionParameter(String alias) {
                    if (alias == null) {
                        throw new NullPointerException();
                    }
                    if (!this.getCalled) {
                        throw new IllegalStateException("getKeyStore() must be called first");
                    }
                    return protectionParameter;
                }
            };
        }

        public static Builder newInstance(String string, Provider provider, File file, ProtectionParameter protectionParameter) {
            if (string == null || file == null || protectionParameter == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
            }
            if (!(g.convertForInstanceOf((Object)protectionParameter, PasswordProtection.class) instanceof PasswordProtection) && !(g.convertForInstanceOf((Object)protectionParameter, CallbackHandlerProtection.class) instanceof CallbackHandlerProtection)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Protection must be PasswordProtection or CallbackHandlerProtection"));
            }
            if (!file.isFile()) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("File does not exist or it does not refer to a normal file: " + file));
            }
            return new FileBuilder(string, provider, file, protectionParameter, AccessController.getContext());
        }

        public static Builder newInstance(final String string, final Provider provider, final ProtectionParameter protectionParameter) {
            if (string == null || protectionParameter == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
            }
            final AccessControlContext accessControlContext = AccessController.getContext();
            return new Builder(){
                private volatile boolean getCalled;
                private IOException oldException;
                private final PrivilegedExceptionAction<KeyStore> action = new PrivilegedExceptionAction<KeyStore>(){

                    @Override
                    public KeyStore run() throws Exception {
                        KeyStore ks = provider == null ? KeyStore.getInstance(string) : KeyStore.getInstance(string, provider);
                        SimpleLoadStoreParameter param = new SimpleLoadStoreParameter(protectionParameter);
                        if (!(protectionParameter instanceof CallbackHandlerProtection)) {
                            ks.load(param);
                        } else {
                            int tries = 0;
                            while (true) {
                                ++tries;
                                try {
                                    ks.load(param);
                                }
                                catch (IOException e2) {
                                    if (e2.getCause() instanceof UnrecoverableKeyException) {
                                        if (tries < 3) continue;
                                        oldException = e2;
                                    }
                                    throw e2;
                                }
                                break;
                            }
                        }
                        getCalled = true;
                        return ks;
                    }
                };

                @Override
                public synchronized KeyStore getKeyStore() throws KeyStoreException {
                    if (this.oldException != null) {
                        throw new KeyStoreException("Previous KeyStore instantiation failed", this.oldException);
                    }
                    try {
                        return AccessController.doPrivileged(this.action, accessControlContext);
                    }
                    catch (PrivilegedActionException e2) {
                        Throwable cause = e2.getCause();
                        throw new KeyStoreException("KeyStore instantiation failed", cause);
                    }
                }

                @Override
                public ProtectionParameter getProtectionParameter(String alias) {
                    if (alias == null) {
                        throw new NullPointerException();
                    }
                    if (!this.getCalled) {
                        throw new IllegalStateException("getKeyStore() must be called first");
                    }
                    return protectionParameter;
                }
            };
        }

        protected /* synthetic */ Builder(h h2) {
            super(h2);
        }

        private static final class FileBuilder
        extends Builder {
            private final String type;
            private final Provider provider;
            private final File file;
            private ProtectionParameter protection;
            private ProtectionParameter keyProtection;
            private final AccessControlContext context;
            private KeyStore keyStore;
            private Throwable oldException;

            FileBuilder(String string, Provider provider, File file, ProtectionParameter protectionParameter, AccessControlContext accessControlContext) {
                this.type = string;
                this.provider = provider;
                this.file = file;
                this.protection = protectionParameter;
                this.context = accessControlContext;
            }

            @Override
            public synchronized KeyStore getKeyStore() throws KeyStoreException {
                if (this.keyStore != null) {
                    return this.keyStore;
                }
                if (this.oldException != null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KeyStoreException("Previous KeyStore instantiation failed", this.oldException));
                }
                PrivilegedExceptionAction<KeyStore> privilegedExceptionAction = new PrivilegedExceptionAction<KeyStore>(){

                    @Override
                    public KeyStore run() throws Exception {
                        if (!(protection instanceof CallbackHandlerProtection)) {
                            return this.run0();
                        }
                        int tries = 0;
                        while (true) {
                            ++tries;
                            try {
                                return this.run0();
                            }
                            catch (IOException e2) {
                                if (tries < 3 && e2.getCause() instanceof UnrecoverableKeyException) continue;
                                throw e2;
                            }
                            break;
                        }
                    }

                    public KeyStore run0() throws Exception {
                        KeyStore ks;
                        char[] password;
                        if (protection instanceof PasswordProtection) {
                            password = ((PasswordProtection)protection).getPassword();
                            keyProtection = protection;
                        } else {
                            CallbackHandler handler = ((CallbackHandlerProtection)protection).getCallbackHandler();
                            PasswordCallback callback = new PasswordCallback("Password for keystore " + file.getName(), false);
                            handler.handle(new Callback[]{callback});
                            password = callback.getPassword();
                            if (password == null) {
                                throw new KeyStoreException("No password provided");
                            }
                            callback.clearPassword();
                            keyProtection = new PasswordProtection(password);
                        }
                        if (type.isEmpty()) {
                            ks = KeyStore.getInstance((File)file, (char[])password);
                        } else {
                            ks = provider == null ? KeyStore.getInstance(type) : KeyStore.getInstance(type, provider);
                            try (FileInputStream in = new FileInputStream(file);){
                                ks.load(in, password);
                            }
                        }
                        return ks;
                    }
                };
                try {
                    this.keyStore = (KeyStore)((Object)g.convertForCast((Object)((Object)AccessController.doPrivileged(privilegedExceptionAction, this.context)), KeyStore.class));
                    return this.keyStore;
                }
                catch (PrivilegedActionException privilegedActionException) {
                    this.oldException = privilegedActionException.getCause();
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KeyStoreException("KeyStore instantiation failed", this.oldException));
                }
            }

            @Override
            public synchronized ProtectionParameter getProtectionParameter(String string) {
                if (string == null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
                }
                if (this.keyStore == null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("getKeyStore() must be called first"));
                }
                return this.keyProtection;
            }

            static /* synthetic */ ProtectionParameter access$100(FileBuilder fileBuilder) {
                return fileBuilder.protection;
            }

            static /* synthetic */ Provider access$200(FileBuilder fileBuilder) {
                return fileBuilder.provider;
            }

            static /* synthetic */ String access$300(FileBuilder fileBuilder) {
                return fileBuilder.type;
            }

            static /* synthetic */ File access$400(FileBuilder fileBuilder) {
                return fileBuilder.file;
            }

            static /* synthetic */ ProtectionParameter access$502(FileBuilder fileBuilder, ProtectionParameter protectionParameter) {
                fileBuilder.keyProtection = protectionParameter;
                return fileBuilder.keyProtection;
            }

            private static /* synthetic */ String _jr$ig$type(FileBuilder fileBuilder) {
                return fileBuilder.type;
            }

            private static /* synthetic */ void _jr$ip$type(FileBuilder fileBuilder, String string) {
                fileBuilder.type = string;
            }

            private static /* synthetic */ Provider _jr$ig$provider(FileBuilder fileBuilder) {
                return fileBuilder.provider;
            }

            private static /* synthetic */ void _jr$ip$provider(FileBuilder fileBuilder, Provider provider) {
                fileBuilder.provider = provider;
            }

            private static /* synthetic */ File _jr$ig$file(FileBuilder fileBuilder) {
                return fileBuilder.file;
            }

            private static /* synthetic */ void _jr$ip$file(FileBuilder fileBuilder, File file) {
                fileBuilder.file = file;
            }

            private static /* synthetic */ ProtectionParameter _jr$ig$protection(FileBuilder fileBuilder) {
                return fileBuilder.protection;
            }

            private static /* synthetic */ void _jr$ip$protection(FileBuilder fileBuilder, ProtectionParameter protectionParameter) {
                fileBuilder.protection = protectionParameter;
            }

            private static /* synthetic */ ProtectionParameter _jr$ig$keyProtection(FileBuilder fileBuilder) {
                return fileBuilder.keyProtection;
            }

            private static /* synthetic */ void _jr$ip$keyProtection(FileBuilder fileBuilder, ProtectionParameter protectionParameter) {
                fileBuilder.keyProtection = protectionParameter;
            }

            private static /* synthetic */ AccessControlContext _jr$ig$context(FileBuilder fileBuilder) {
                return fileBuilder.context;
            }

            private static /* synthetic */ void _jr$ip$context(FileBuilder fileBuilder, AccessControlContext accessControlContext) {
                fileBuilder.context = accessControlContext;
            }

            private static /* synthetic */ KeyStore _jr$ig$keyStore(FileBuilder fileBuilder) {
                return fileBuilder.keyStore;
            }

            private static /* synthetic */ void _jr$ip$keyStore(FileBuilder fileBuilder, KeyStore keyStore) {
                fileBuilder.keyStore = keyStore;
            }

            private static /* synthetic */ Throwable _jr$ig$oldException(FileBuilder fileBuilder) {
                return fileBuilder.oldException;
            }

            private static /* synthetic */ void _jr$ip$oldException(FileBuilder fileBuilder, Throwable throwable) {
                fileBuilder.oldException = throwable;
            }
        }
    }

    public static class CallbackHandlerProtection
    extends h
    implements ProtectionParameter {
        private final CallbackHandler handler;

        public CallbackHandlerProtection(CallbackHandler callbackHandler) {
            if (callbackHandler == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("handler must not be null"));
            }
            this.handler = callbackHandler;
        }

        public CallbackHandler getCallbackHandler() {
            return this.handler;
        }

        private static /* synthetic */ void _jr$ip$handler(CallbackHandlerProtection callbackHandlerProtection, CallbackHandler callbackHandler) {
            callbackHandlerProtection.handler = callbackHandler;
        }

        protected /* synthetic */ CallbackHandlerProtection(h h2) {
            super(h2);
        }
    }

    public static interface Entry {
        default public Set<Attribute> getAttributes() {
            return Collections.emptySet();
        }

        public static interface Attribute {
            public String getName();

            public String getValue();
        }
    }

    public static interface LoadStoreParameter {
        public ProtectionParameter getProtectionParameter();
    }

    public static class PasswordProtection
    extends h
    implements ProtectionParameter,
    Destroyable {
        private final char[] password;
        private volatile boolean destroyed;

        public PasswordProtection(char[] cArray) {
            this.destroyed = false;
            this.password = cArray == null ? null : (char[])cArray.clone();
        }

        @af(modifiers=33)
        public char[] getPassword() {
            Object object = ah.getMonitor((Object)this);
            synchronized (object) {
                try {
                    if (this.destroyed) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("password has been cleared"));
                    }
                    return this.password;
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }

        @Override
        @af(modifiers=33)
        public void destroy() throws DestroyFailedException {
            Object object = ah.getMonitor((Object)this);
            synchronized (object) {
                try {
                    this.destroyed = true;
                    if (this.password != null) {
                        Arrays.fill(this.password, ' ');
                    }
                    return;
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }

        @Override
        @af(modifiers=33)
        public boolean isDestroyed() {
            Object object = ah.getMonitor((Object)this);
            synchronized (object) {
                try {
                    return this.destroyed;
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }

        private static /* synthetic */ void _jr$ip$password(PasswordProtection passwordProtection, char[] cArray) {
            passwordProtection.password = cArray;
        }

        protected /* synthetic */ PasswordProtection(h h2) {
            super(h2);
        }
    }

    public static final class PrivateKeyEntry
    extends h
    implements Entry {
        private final PrivateKey privKey;
        private final Certificate[] chain;

        public PrivateKeyEntry(PrivateKey privateKey, Certificate[] certificateArray) {
            if (privateKey == null || certificateArray == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("invalid null input"));
            }
            if (a.arrayLength((Object[])certificateArray) == 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("invalid zero-length input chain"));
            }
            Object[] objectArray = (Certificate[])g.convertForCast((Object)a.cloneArray((Object)certificateArray), Certificate[].class);
            String string = ((Certificate)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)0), Certificate.class)).getType();
            for (int i = 1; i < a.arrayLength((Object[])objectArray); ++i) {
                if (string.equals(((Certificate)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), Certificate.class)).getType())) continue;
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("chain does not contain certificates of the same type"));
            }
            if (!privateKey.getAlgorithm().equals(((Certificate)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)0), Certificate.class)).getPublicKey().getAlgorithm())) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("private key algorithm does not match algorithm of public key in end entity certificate (at index 0)"));
            }
            this.privKey = privateKey;
            if (g.convertForInstanceOf((Object)((Certificate)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)0), Certificate.class)), X509Certificate.class) instanceof X509Certificate && !(g.convertForInstanceOf((Object)objectArray, X509Certificate[].class) instanceof X509Certificate[])) {
                this.chain = new X509Certificate[a.arrayLength((Object[])objectArray)];
                a.arraycopy((Object)objectArray, (int)0, (Object)this.chain, (int)0, (int)a.arrayLength((Object[])objectArray));
            } else {
                this.chain = objectArray;
            }
        }

        public PrivateKey getPrivateKey() {
            return this.privKey;
        }

        public Certificate[] getCertificateChain() {
            return (Certificate[])g.convertForCast((Object)a.cloneArray((Object)this.chain), Certificate[].class);
        }

        public Certificate getCertificate() {
            return (Certificate)g.convertForCast((Object)a.arrayLoad((Object[])this.chain, (int)0), Certificate.class);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Private key entry and certificate chain with " + a.arrayLength((Object[])this.chain) + " elements:\r\n");
            Object[] objectArray = this.chain;
            int n2 = a.arrayLength((Object[])objectArray);
            for (int i = 0; i < n2; ++i) {
                Certificate certificate = (Certificate)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), Certificate.class);
                stringBuilder.append(certificate);
                stringBuilder.append("\r\n");
            }
            return stringBuilder.toString();
        }

        private static /* synthetic */ PrivateKey _jr$ig$privKey(PrivateKeyEntry privateKeyEntry) {
            return privateKeyEntry.privKey;
        }

        private static /* synthetic */ void _jr$ip$privKey(PrivateKeyEntry privateKeyEntry, PrivateKey privateKey) {
            privateKeyEntry.privKey = privateKey;
        }

        private static /* synthetic */ Certificate[] _jr$ig$chain(PrivateKeyEntry privateKeyEntry) {
            return privateKeyEntry.chain;
        }

        private static /* synthetic */ void _jr$ip$chain(PrivateKeyEntry privateKeyEntry, Certificate[] certificateArray) {
            privateKeyEntry.chain = certificateArray;
        }
    }

    public static interface ProtectionParameter {
    }

    public static final class SecretKeyEntry
    extends h
    implements Entry {
        private final SecretKey sKey;

        public SecretKeyEntry(SecretKey secretKey) {
            if (secretKey == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("invalid null input"));
            }
            this.sKey = secretKey;
        }

        public SecretKey getSecretKey() {
            return this.sKey;
        }

        public String toString() {
            return "Secret key entry with algorithm " + this.sKey.getAlgorithm();
        }

        private static /* synthetic */ SecretKey _jr$ig$sKey(SecretKeyEntry secretKeyEntry) {
            return secretKeyEntry.sKey;
        }

        private static /* synthetic */ void _jr$ip$sKey(SecretKeyEntry secretKeyEntry, SecretKey secretKey) {
            secretKeyEntry.sKey = secretKey;
        }
    }

    static class SimpleLoadStoreParameter
    extends h
    implements LoadStoreParameter {
        private final ProtectionParameter protection;

        SimpleLoadStoreParameter(ProtectionParameter protectionParameter) {
            this.protection = protectionParameter;
        }

        @Override
        public ProtectionParameter getProtectionParameter() {
            return this.protection;
        }

        private static /* synthetic */ void _jr$ip$protection(SimpleLoadStoreParameter simpleLoadStoreParameter, ProtectionParameter protectionParameter) {
            simpleLoadStoreParameter.protection = protectionParameter;
        }

        protected /* synthetic */ SimpleLoadStoreParameter(h h2) {
            super(h2);
        }
    }

    public static final class TrustedCertificateEntry
    extends h
    implements Entry {
        private final Certificate cert;

        public TrustedCertificateEntry(Certificate certificate) {
            if (certificate == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("invalid null input"));
            }
            this.cert = certificate;
        }

        public Certificate getTrustedCertificate() {
            return this.cert;
        }

        public String toString() {
            return "Trusted certificate entry:\r\n" + this.cert.toString();
        }

        private static /* synthetic */ Certificate _jr$ig$cert(TrustedCertificateEntry trustedCertificateEntry) {
            return trustedCertificateEntry.cert;
        }

        private static /* synthetic */ void _jr$ip$cert(TrustedCertificateEntry trustedCertificateEntry, Certificate certificate) {
            trustedCertificateEntry.cert = certificate;
        }
    }
}

