/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.MessageDigestSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;

public abstract class MessageDigest
extends MessageDigestSpi {
    private String algorithm;
    private static final int INITIAL = 0;
    private static final int IN_PROGRESS = 1;
    private int state;
    private Provider provider;

    protected MessageDigest(String string) {
        this.state = 0;
        this.algorithm = string;
    }

    public static MessageDigest getInstance(String string) throws NoSuchAlgorithmException {
        try {
            Object[] objectArray = Security.getImpl(string, "MessageDigest", (String)null);
            if (g.convertForInstanceOf((Object)a.arrayLoad((Object[])objectArray, (int)0), MessageDigest.class) instanceof MessageDigest) {
                MessageDigest messageDigest = (MessageDigest)((Object)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)0), MessageDigest.class));
                messageDigest.provider = (Provider)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)1), Provider.class);
                return messageDigest;
            }
            Delegate delegate = new Delegate((MessageDigestSpi)((Object)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)0), MessageDigestSpi.class)), string);
            ((MessageDigest)delegate).provider = (Provider)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)1), Provider.class);
            return delegate;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchAlgorithmException(string + " not found"));
        }
    }

    public static MessageDigest getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null || string2.length() == 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("missing provider"));
        }
        Object[] objectArray = Security.getImpl(string, "MessageDigest", string2);
        if (g.convertForInstanceOf((Object)a.arrayLoad((Object[])objectArray, (int)0), MessageDigest.class) instanceof MessageDigest) {
            MessageDigest messageDigest = (MessageDigest)((Object)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)0), MessageDigest.class));
            messageDigest.provider = (Provider)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)1), Provider.class);
            return messageDigest;
        }
        Delegate delegate = new Delegate((MessageDigestSpi)((Object)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)0), MessageDigestSpi.class)), string);
        ((MessageDigest)delegate).provider = (Provider)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)1), Provider.class);
        return delegate;
    }

    public static MessageDigest getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("missing provider"));
        }
        Object[] objectArray = Security.getImpl(string, "MessageDigest", provider);
        if (g.convertForInstanceOf((Object)a.arrayLoad((Object[])objectArray, (int)0), MessageDigest.class) instanceof MessageDigest) {
            MessageDigest messageDigest = (MessageDigest)((Object)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)0), MessageDigest.class));
            messageDigest.provider = (Provider)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)1), Provider.class);
            return messageDigest;
        }
        Delegate delegate = new Delegate((MessageDigestSpi)((Object)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)0), MessageDigestSpi.class)), string);
        ((MessageDigest)delegate).provider = (Provider)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)1), Provider.class);
        return delegate;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public void update(byte by) {
        this.engineUpdate(by);
        this.state = 1;
    }

    public void update(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("No input buffer given"));
        }
        if (byArray.length - n2 < n3) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Input buffer too short"));
        }
        this.engineUpdate(byArray, n2, n3);
        this.state = 1;
    }

    public void update(byte[] byArray) {
        this.engineUpdate(byArray, 0, byArray.length);
        this.state = 1;
    }

    public final void update(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        this.engineUpdate(byteBuffer);
        this.state = 1;
    }

    public byte[] digest() {
        byte[] byArray = this.engineDigest();
        this.state = 0;
        return byArray;
    }

    public int digest(byte[] byArray, int n2, int n3) throws DigestException {
        if (byArray == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("No output buffer given"));
        }
        if (byArray.length - n2 < n3) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Output buffer too small for specified offset and length"));
        }
        int n4 = this.engineDigest(byArray, n2, n3);
        this.state = 0;
        return n4;
    }

    public byte[] digest(byte[] byArray) {
        this.update(byArray);
        return this.digest();
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        printStream.print(this.algorithm + " Message Digest from " + this.provider.getName() + ", ");
        switch (this.state) {
            case 0: {
                printStream.print("<initialized>");
                break;
            }
            case 1: {
                printStream.print("<in progress>");
            }
        }
        printStream.println();
        return byteArrayOutputStream.toString();
    }

    public static boolean isEqual(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n2 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n2 |= byArray[i] ^ byArray2[i];
        }
        return n2 == 0;
    }

    public void reset() {
        this.engineReset();
        this.state = 0;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final int getDigestLength() {
        int n2 = this.engineGetDigestLength();
        if (n2 == 0) {
            try {
                MessageDigest messageDigest = (MessageDigest)((Object)g.convertForCast((Object)this.clone(), MessageDigest.class));
                byte[] byArray = messageDigest.digest();
                return byArray.length;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return n2;
            }
        }
        return n2;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (g.convertForInstanceOf((Object)((Object)this), Cloneable.class) instanceof Cloneable) {
            return super.clone();
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CloneNotSupportedException());
    }

    static /* synthetic */ Provider access$102(MessageDigest messageDigest, Provider provider) {
        Provider provider2 = provider;
        messageDigest.provider = provider2;
        return provider2;
    }

    static /* synthetic */ int access$202(MessageDigest messageDigest, int n2) {
        int n3 = n2;
        messageDigest.state = n3;
        return n3;
    }

    private static /* synthetic */ void _jr$ip$algorithm(MessageDigest messageDigest, String string) {
        messageDigest.algorithm = string;
    }

    protected /* synthetic */ MessageDigest(h h2) {
        super(h2);
    }

    static class Delegate
    extends MessageDigest {
        private MessageDigestSpi digestSpi;

        public Delegate(MessageDigestSpi messageDigestSpi, String string) {
            super(string);
            this.digestSpi = messageDigestSpi;
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            if (g.convertForInstanceOf((Object)((Object)this.digestSpi), Cloneable.class) instanceof Cloneable) {
                MessageDigestSpi messageDigestSpi = (MessageDigestSpi)((Object)g.convertForCast((Object)this.digestSpi.clone(), MessageDigestSpi.class));
                Delegate delegate = new Delegate(messageDigestSpi, ((MessageDigest)this).algorithm);
                MessageDigest.access$102(delegate, ((MessageDigest)this).provider);
                MessageDigest.access$202(delegate, ((MessageDigest)this).state);
                return delegate;
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CloneNotSupportedException());
        }

        @Override
        protected int engineGetDigestLength() {
            return this.digestSpi.engineGetDigestLength();
        }

        @Override
        protected void engineUpdate(byte by) {
            this.digestSpi.engineUpdate(by);
        }

        @Override
        protected void engineUpdate(byte[] byArray, int n2, int n3) {
            this.digestSpi.engineUpdate(byArray, n2, n3);
        }

        @Override
        protected void engineUpdate(ByteBuffer byteBuffer) {
            this.digestSpi.engineUpdate(byteBuffer);
        }

        @Override
        protected byte[] engineDigest() {
            return this.digestSpi.engineDigest();
        }

        @Override
        protected int engineDigest(byte[] byArray, int n2, int n3) throws DigestException {
            return this.digestSpi.engineDigest(byArray, n2, n3);
        }

        @Override
        protected void engineReset() {
            this.digestSpi.engineReset();
        }

        private static /* synthetic */ void _jr$ip$digestSpi(Delegate delegate, MessageDigestSpi messageDigestSpi) {
            delegate.digestSpi = messageDigestSpi;
        }

        protected /* synthetic */ Delegate(h h2) {
            super(h2);
        }
    }
}

