/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PolicySpi;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Provider;
import java.security.Security;
import java.security.SecurityPermission;
import java.util.Enumeration;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import sun.security.jca.GetInstance;
import sun.security.provider.PolicyFile;
import sun.security.util.Debug;
import sun.security.util.SecurityConstants;

public abstract class Policy
extends h {
    public static final PermissionCollection UNSUPPORTED_EMPTY_COLLECTION = new UnsupportedEmptyCollection();
    private static AtomicReference<PolicyInfo> policy = new AtomicReference(new PolicyInfo(null, false));
    private static final Debug debug = Debug.getInstance("policy");
    private WeakHashMap<ProtectionDomain.Key, PermissionCollection> pdMapping;

    public Policy() {
    }

    static boolean isSet() {
        PolicyInfo policyInfo = (PolicyInfo)((Object)g.convertForCast(policy.get(), PolicyInfo.class));
        return ((PolicyInfo)((Object)((Object)policyInfo))).policy != null && ((PolicyInfo)((Object)((Object)policyInfo))).initialized;
    }

    private static void checkPermission(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("createPolicy." + string));
        }
    }

    public static Policy getPolicy() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.GET_POLICY_PERMISSION);
        }
        return Policy.getPolicyNoCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Policy getPolicyNoCheck() {
        PolicyInfo policyInfo = (PolicyInfo)((Object)g.convertForCast(policy.get(), PolicyInfo.class));
        if (!((PolicyInfo)((Object)((Object)policyInfo))).initialized || ((PolicyInfo)((Object)((Object)policyInfo))).policy == null) {
            Object object = ah.getMonitor(Policy.class);
            synchronized (object) {
                try {
                    PolicyInfo policyInfo2 = (PolicyInfo)((Object)g.convertForCast(policy.get(), PolicyInfo.class));
                    if (((PolicyInfo)((Object)((Object)policyInfo2))).policy == null) {
                        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

                            @Override
                            public String run() {
                                return Security.getProperty("policy.provider");
                            }
                        });
                        if (string == null) {
                            string = "sun.security.provider.PolicyFile";
                        }
                        try {
                            policyInfo2 = new PolicyInfo((Policy)((Object)g.convertForCast(ai.getCurrentClass(Class.forName(string)).newInstance(), Policy.class)), true);
                        }
                        catch (Exception exception) {
                            PolicyFile policyFile = new PolicyFile();
                            policyInfo2 = new PolicyInfo(policyFile, false);
                            policy.set(policyInfo2);
                            final String string2 = string;
                            Policy policy = (Policy)((Object)g.convertForCast((Object)((Object)AccessController.doPrivileged(new PrivilegedAction<Policy>(){

                                @Override
                                public Policy run() {
                                    try {
                                        ClassLoader scl = ClassLoader.getSystemClassLoader();
                                        Object o = Class.forName(string2, true, scl).newInstance();
                                        return (Policy)((Object)o);
                                    }
                                    catch (Exception e2) {
                                        if (debug != null) {
                                            debug.println("policy provider " + string2 + " not available");
                                            e2.printStackTrace();
                                        }
                                        return null;
                                    }
                                }
                            })), Policy.class));
                            if (policy != null) {
                                policyInfo2 = new PolicyInfo(policy, true);
                            }
                            if (debug != null) {
                                debug.println("using sun.security.provider.PolicyFile");
                            }
                            policyInfo2 = new PolicyInfo(policyFile, true);
                        }
                        policy.set(policyInfo2);
                    }
                    return ((PolicyInfo)((Object)((Object)policyInfo2))).policy;
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
        return ((PolicyInfo)((Object)((Object)policyInfo))).policy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPolicy(Policy policy) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (policy != null) {
            Policy.initPolicy(policy);
        }
        Object object = ah.getMonitor(Policy.class);
        synchronized (object) {
            try {
                Policy.policy.set(new PolicyInfo(policy, policy != null));
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initPolicy(final Policy policy) {
        ProtectionDomain protectionDomain = (ProtectionDomain)((Object)g.convertForCast((Object)((Object)AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

            @Override
            public ProtectionDomain run() {
                return ((Object)((Object)policy)).getClass().getProtectionDomain();
            }
        })), ProtectionDomain.class));
        PermissionCollection permissionCollection = null;
        Object object = ah.getMonitor((Object)((Object)policy));
        synchronized (object) {
            try {
                if (policy.pdMapping == null) {
                    policy.pdMapping = new WeakHashMap();
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        if (protectionDomain.getCodeSource() != null) {
            object = ((PolicyInfo)((Object)((Object)((PolicyInfo)((Object)g.convertForCast(Policy.policy.get(), PolicyInfo.class)))))).policy;
            if (object != null) {
                permissionCollection = ((Policy)((Object)object)).getPermissions(protectionDomain);
            }
            if (permissionCollection == null) {
                permissionCollection = new Permissions();
                permissionCollection.add(SecurityConstants.ALL_PERMISSION);
            }
            Object object2 = ah.getMonitor((Object)policy.pdMapping);
            synchronized (object2) {
                try {
                    policy.pdMapping.put(ProtectionDomain._jr$ig$key((Object)protectionDomain), permissionCollection);
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
    }

    public static Policy getInstance(String string, Parameters parameters) throws NoSuchAlgorithmException {
        Policy.checkPermission(string);
        try {
            GetInstance.Instance instance = GetInstance.getInstance("Policy", PolicySpi.class, string, parameters);
            return new PolicyDelegate((PolicySpi)((Object)g.convertForCast((Object)instance.impl, PolicySpi.class)), instance.provider, string, parameters);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return Policy.handleException(noSuchAlgorithmException);
        }
    }

    public static Policy getInstance(String string, Parameters parameters, String string2) throws NoSuchProviderException, NoSuchAlgorithmException {
        if (string2 == null || string2.length() == 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("missing provider"));
        }
        Policy.checkPermission(string);
        try {
            GetInstance.Instance instance = GetInstance.getInstance("Policy", PolicySpi.class, string, (Object)parameters, string2);
            return new PolicyDelegate((PolicySpi)((Object)g.convertForCast((Object)instance.impl, PolicySpi.class)), instance.provider, string, parameters);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return Policy.handleException(noSuchAlgorithmException);
        }
    }

    public static Policy getInstance(String string, Parameters parameters, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("missing provider"));
        }
        Policy.checkPermission(string);
        try {
            GetInstance.Instance instance = GetInstance.getInstance("Policy", PolicySpi.class, string, (Object)parameters, provider);
            return new PolicyDelegate((PolicySpi)((Object)g.convertForCast((Object)instance.impl, PolicySpi.class)), instance.provider, string, parameters);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return Policy.handleException(noSuchAlgorithmException);
        }
    }

    private static Policy handleException(NoSuchAlgorithmException noSuchAlgorithmException) throws NoSuchAlgorithmException {
        Throwable throwable = noSuchAlgorithmException.getCause();
        if (g.convertForInstanceOf((Object)throwable, IllegalArgumentException.class) instanceof IllegalArgumentException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((IllegalArgumentException)g.convertForCast((Object)throwable, IllegalArgumentException.class)));
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)noSuchAlgorithmException);
    }

    public Provider getProvider() {
        return null;
    }

    public String getType() {
        return null;
    }

    public Parameters getParameters() {
        return null;
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        return UNSUPPORTED_EMPTY_COLLECTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PermissionCollection getPermissions(ProtectionDomain protectionDomain) {
        PermissionCollection permissionCollection = null;
        if (protectionDomain == null) {
            return new Permissions();
        }
        if (this.pdMapping == null) {
            Policy.initPolicy(this);
        }
        Object object = ah.getMonitor((Object)this.pdMapping);
        synchronized (object) {
            try {
                permissionCollection = (PermissionCollection)g.convertForCast(this.pdMapping.get((Object)ProtectionDomain._jr$ig$key((Object)protectionDomain)), PermissionCollection.class);
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        if (permissionCollection != null) {
            object = new Permissions();
            Object object2 = ah.getMonitor((Object)permissionCollection);
            synchronized (object2) {
                try {
                    Enumeration<Permission> enumeration = permissionCollection.elements();
                    while (enumeration.hasMoreElements()) {
                        ((Permissions)object).add((Permission)g.convertForCast((Object)enumeration.nextElement(), Permission.class));
                    }
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
            return object;
        }
        permissionCollection = this.getPermissions(protectionDomain.getCodeSource());
        if (permissionCollection == null || !f.ifAcmp((Object)permissionCollection, (Object)UNSUPPORTED_EMPTY_COLLECTION)) {
            permissionCollection = new Permissions();
        }
        this.addStaticPerms(permissionCollection, protectionDomain.getPermissions());
        return permissionCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStaticPerms(PermissionCollection permissionCollection, PermissionCollection permissionCollection2) {
        if (permissionCollection2 != null) {
            Object object = ah.getMonitor((Object)permissionCollection2);
            synchronized (object) {
                try {
                    Enumeration<Permission> enumeration = permissionCollection2.elements();
                    while (enumeration.hasMoreElements()) {
                        permissionCollection.add((Permission)g.convertForCast((Object)enumeration.nextElement(), Permission.class));
                    }
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean implies(ProtectionDomain protectionDomain, Permission permission) {
        PermissionCollection permissionCollection;
        if (this.pdMapping == null) {
            Policy.initPolicy(this);
        }
        Object object = ah.getMonitor((Object)this.pdMapping);
        synchronized (object) {
            try {
                permissionCollection = (PermissionCollection)g.convertForCast(this.pdMapping.get((Object)ProtectionDomain._jr$ig$key((Object)protectionDomain)), PermissionCollection.class);
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        if (permissionCollection != null) {
            return permissionCollection.implies(permission);
        }
        permissionCollection = this.getPermissions(protectionDomain);
        if (permissionCollection == null) {
            return false;
        }
        object = ah.getMonitor((Object)this.pdMapping);
        synchronized (object) {
            try {
                this.pdMapping.put(ProtectionDomain._jr$ig$key((Object)protectionDomain), permissionCollection);
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        return permissionCollection.implies(permission);
    }

    public void refresh() {
    }

    static /* synthetic */ Debug access$000() {
        return debug;
    }

    protected /* synthetic */ Policy(h h2) {
        super(h2);
    }

    @Deprecated(since="17", forRemoval=true)
    public static interface Parameters {
    }

    private static class PolicyDelegate
    extends Policy {
        private PolicySpi spi;
        private Provider p;
        private String type;
        private Parameters params;

        private PolicyDelegate(PolicySpi policySpi, Provider provider, String string, Parameters parameters) {
            this.spi = policySpi;
            this.p = provider;
            this.type = string;
            this.params = parameters;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public Parameters getParameters() {
            return this.params;
        }

        @Override
        public Provider getProvider() {
            return this.p;
        }

        @Override
        public PermissionCollection getPermissions(CodeSource codeSource) {
            return this.spi.engineGetPermissions(codeSource);
        }

        @Override
        public PermissionCollection getPermissions(ProtectionDomain protectionDomain) {
            return this.spi.engineGetPermissions(protectionDomain);
        }

        @Override
        public boolean implies(ProtectionDomain protectionDomain, Permission permission) {
            return this.spi.engineImplies(protectionDomain, permission);
        }

        @Override
        public void refresh() {
            this.spi.engineRefresh();
        }

        private static /* synthetic */ void _jr$ip$spi(PolicyDelegate policyDelegate, PolicySpi policySpi) {
            policyDelegate.spi = policySpi;
        }

        private static /* synthetic */ void _jr$ip$p(PolicyDelegate policyDelegate, Provider provider) {
            policyDelegate.p = provider;
        }

        private static /* synthetic */ void _jr$ip$type(PolicyDelegate policyDelegate, String string) {
            policyDelegate.type = string;
        }

        private static /* synthetic */ void _jr$ip$params(PolicyDelegate policyDelegate, Parameters parameters) {
            policyDelegate.params = parameters;
        }

        protected /* synthetic */ PolicyDelegate(h h2) {
            super(h2);
        }
    }

    private static class PolicyInfo
    extends h {
        final Policy policy;
        final boolean initialized;

        PolicyInfo(Policy policy, boolean bl) {
            this.policy = policy;
            this.initialized = bl;
        }

        static /* synthetic */ void _jr$ip$policy(Object object, Policy policy) {
            ((PolicyInfo)((Object)object)).policy = policy;
        }

        static /* synthetic */ void _jr$ip$initialized(Object object, boolean bl) {
            ((PolicyInfo)((Object)object)).initialized = bl;
        }

        protected /* synthetic */ PolicyInfo(h h2) {
            super(h2);
        }
    }

    private static class UnsupportedEmptyCollection
    extends PermissionCollection {
        private Permissions perms;

        public UnsupportedEmptyCollection() {
            this.perms = new Permissions();
            this.perms.setReadOnly();
        }

        @Override
        public void add(Permission permission) {
            this.perms.add(permission);
        }

        @Override
        public boolean implies(Permission permission) {
            return this.perms.implies(permission);
        }

        @Override
        public Enumeration<Permission> elements() {
            return this.perms.elements();
        }

        private static /* synthetic */ void _jr$ip$perms(UnsupportedEmptyCollection unsupportedEmptyCollection, Permissions permissions) {
            unsupportedEmptyCollection.perms = permissions;
        }

        protected /* synthetic */ UnsupportedEmptyCollection(h h2) {
            super(h2);
        }
    }
}

