/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.facade.x;
import com.zeroturnaround.jrebelbase.h;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.WeakHashMap;
import sun.misc.JavaSecurityAccess;
import sun.misc.JavaSecurityProtectionDomainAccess;
import sun.misc.SharedSecrets;
import sun.security.util.Debug;
import sun.security.util.SecurityConstants;

public class ProtectionDomain
extends h {
    private CodeSource codesource;
    private ClassLoader classloader;
    private Principal[] principals;
    private PermissionCollection permissions;
    private boolean hasAllPerm;
    private boolean staticPermissions;
    final Key key;
    private static final Debug debug;

    public ProtectionDomain(CodeSource codeSource, PermissionCollection permissionCollection) {
        this.hasAllPerm = false;
        this.key = new Key();
        this.codesource = codeSource;
        if (permissionCollection != null) {
            this.permissions = permissionCollection;
            this.permissions.setReadOnly();
            if (g.convertForInstanceOf((Object)permissionCollection, Permissions.class) instanceof Permissions && Permissions._jr$ig$allPermission((Permissions)g.convertForCast((Object)permissionCollection, Permissions.class)) != null) {
                this.hasAllPerm = true;
            }
        }
        this.classloader = null;
        this.principals = new Principal[0];
        this.staticPermissions = true;
    }

    public ProtectionDomain(CodeSource codeSource, PermissionCollection permissionCollection, ClassLoader classLoader, Principal[] principalArray) {
        this.hasAllPerm = false;
        this.key = new Key();
        this.codesource = codeSource;
        if (permissionCollection != null) {
            this.permissions = permissionCollection;
            this.permissions.setReadOnly();
            if (g.convertForInstanceOf((Object)permissionCollection, Permissions.class) instanceof Permissions && Permissions._jr$ig$allPermission((Permissions)g.convertForCast((Object)permissionCollection, Permissions.class)) != null) {
                this.hasAllPerm = true;
            }
        }
        this.classloader = classLoader;
        this.principals = principalArray != null ? (Principal[])g.convertForCast((Object)a.cloneArray((Object)principalArray), Principal[].class) : new Principal[]{};
        this.staticPermissions = false;
    }

    public final CodeSource getCodeSource() {
        return this.codesource;
    }

    public final ClassLoader getClassLoader() {
        return this.classloader;
    }

    public final Principal[] getPrincipals() {
        return (Principal[])g.convertForCast((Object)a.cloneArray((Object)this.principals), Principal[].class);
    }

    public final PermissionCollection getPermissions() {
        return this.permissions;
    }

    public boolean implies(Permission permission) {
        if (this.hasAllPerm) {
            return true;
        }
        if (!this.staticPermissions && Policy.getPolicyNoCheck().implies(this, permission)) {
            return true;
        }
        if (this.permissions != null) {
            return this.permissions.implies(permission);
        }
        return false;
    }

    boolean impliesCreateAccessControlContext() {
        return this.implies(SecurityConstants.CREATE_ACC_PERMISSION);
    }

    public String toString() {
        h h2;
        String string = "<no principals>";
        if (this.principals != null && a.arrayLength((Object[])this.principals) > 0) {
            h2 = new StringBuilder("(principals ");
            for (int i = 0; i < a.arrayLength((Object[])this.principals); ++i) {
                h2.append(x.getName(((Principal)g.convertForCast((Object)a.arrayLoad((Object[])this.principals, (int)i), Principal.class)).getClass()) + " \"" + ((Principal)g.convertForCast((Object)a.arrayLoad((Object[])this.principals, (int)i), Principal.class)).getName() + "\"");
                if (i < a.arrayLength((Object[])this.principals) - 1) {
                    h2.append(",\n");
                    continue;
                }
                h2.append(")\n");
            }
            string = h2.toString();
        }
        h2 = Policy.isSet() && ProtectionDomain.seeAllp() ? this.mergePermissions() : this.getPermissions();
        return "ProtectionDomain  " + this.codesource + "\n" + " " + (Object)((Object)this.classloader) + "\n" + " " + string + "\n" + " " + h2 + "\n";
    }

    private static boolean seeAllp() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return true;
        }
        if (debug != null) {
            if (((Object)((Object)securityManager)).getClass().getClassLoader() == null && ((Object)((Object)Policy.getPolicyNoCheck())).getClass().getClassLoader() == null) {
                return true;
            }
        } else {
            try {
                securityManager.checkPermission(SecurityConstants.GET_POLICY_PERMISSION);
                return true;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PermissionCollection mergePermissions() {
        Enumeration<Permission> enumeration;
        Object object;
        if (this.staticPermissions) {
            return this.permissions;
        }
        PermissionCollection permissionCollection = (PermissionCollection)g.convertForCast(AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */), PermissionCollection.class);
        Permissions permissions = new Permissions();
        int n = 32;
        int n2 = 8;
        ArrayList<Permission> arrayList = new ArrayList<Permission>(n2);
        ArrayList<Permission> arrayList2 = new ArrayList<Permission>(n);
        if (this.permissions != null) {
            object = ah.getMonitor((Object)this.permissions);
            synchronized (object) {
                try {
                    enumeration = this.permissions.elements();
                    while (enumeration.hasMoreElements()) {
                        arrayList.add(enumeration.nextElement());
                    }
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
        if (permissionCollection != null) {
            object = ah.getMonitor((Object)permissionCollection);
            synchronized (object) {
                try {
                    enumeration = permissionCollection.elements();
                    while (enumeration.hasMoreElements()) {
                        arrayList2.add(enumeration.nextElement());
                        ++n2;
                    }
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
        if (permissionCollection != null && this.permissions != null) {
            object = ah.getMonitor((Object)this.permissions);
            synchronized (object) {
                try {
                    enumeration = this.permissions.elements();
                    block11: while (enumeration.hasMoreElements()) {
                        Permission permission = (Permission)g.convertForCast((Object)enumeration.nextElement(), Permission.class);
                        Class<?> clazz = permission.getClass();
                        String string = permission.getActions();
                        String string2 = permission.getName();
                        for (int i = 0; i < arrayList2.size(); ++i) {
                            Permission permission2 = (Permission)g.convertForCast(arrayList2.get(i), Permission.class);
                            if (!x.isInstance(clazz, (Object)permission2) || !string2.equals(permission2.getName()) || !string.equals(permission2.getActions())) continue;
                            arrayList2.remove(i);
                            continue block11;
                        }
                    }
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
        if (permissionCollection != null) {
            for (int i = arrayList2.size() - 1; i >= 0; --i) {
                permissions.add((Permission)g.convertForCast(arrayList2.get(i), Permission.class));
            }
        }
        if (this.permissions != null) {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                permissions.add((Permission)g.convertForCast(arrayList.get(i), Permission.class));
            }
        }
        return permissions;
    }

    static {
        SharedSecrets.setJavaSecurityAccess(new JavaSecurityAccess(){

            public <T> T doIntersectionPrivilege(PrivilegedAction<T> privilegedAction, AccessControlContext accessControlContext, AccessControlContext accessControlContext2) {
                if (privilegedAction == null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
                }
                return AccessController.doPrivileged(privilegedAction, new AccessControlContext(accessControlContext.getContext(), accessControlContext2).optimize());
            }

            public <T> T doIntersectionPrivilege(PrivilegedAction<T> privilegedAction, AccessControlContext accessControlContext) {
                return this.doIntersectionPrivilege(privilegedAction, AccessController.getContext(), accessControlContext);
            }
        });
        debug = Debug.getInstance("domain");
        SharedSecrets.setJavaSecurityProtectionDomainAccess(new JavaSecurityProtectionDomainAccess(){

            public JavaSecurityProtectionDomainAccess.ProtectionDomainCache getProtectionDomainCache() {
                return new JavaSecurityProtectionDomainAccess.ProtectionDomainCache(this){
                    private final Map<Key, PermissionCollection> map;
                    final /* synthetic */ 3 this$0;
                    {
                        this.this$0 = var1_1;
                        this.map = Collections.synchronizedMap(new WeakHashMap());
                    }

                    public void put(ProtectionDomain protectionDomain, PermissionCollection permissionCollection) {
                        this.map.put(protectionDomain == null ? null : ((ProtectionDomain)((Object)((Object)protectionDomain))).key, permissionCollection);
                    }

                    public PermissionCollection get(ProtectionDomain protectionDomain) {
                        return protectionDomain == null ? (PermissionCollection)g.convertForCast(this.map.get(null), PermissionCollection.class) : (PermissionCollection)g.convertForCast(this.map.get((Object)((ProtectionDomain)((Object)((Object)protectionDomain))).key), PermissionCollection.class);
                    }

                    private static /* synthetic */ void _jr$ip$map(1 var0, Map map) {
                        var0.map = map;
                    }

                    static /* synthetic */ 3 _jr$ig$this$0(Object object) {
                        return ((Object)object).this$0;
                    }

                    static /* synthetic */ void _jr$ip$this$0(Object object, 3 var1_1) {
                        ((Object)object).this$0 = var1_1;
                    }
                };
            }
        });
    }

    private static /* synthetic */ void _jr$ip$codesource(ProtectionDomain protectionDomain, CodeSource codeSource) {
        protectionDomain.codesource = codeSource;
    }

    private static /* synthetic */ void _jr$ip$classloader(ProtectionDomain protectionDomain, ClassLoader classLoader) {
        protectionDomain.classloader = classLoader;
    }

    private static /* synthetic */ void _jr$ip$principals(ProtectionDomain protectionDomain, Principal[] principalArray) {
        protectionDomain.principals = principalArray;
    }

    private static /* synthetic */ void _jr$ip$permissions(ProtectionDomain protectionDomain, PermissionCollection permissionCollection) {
        protectionDomain.permissions = permissionCollection;
    }

    private static /* synthetic */ void _jr$ip$hasAllPerm(ProtectionDomain protectionDomain, boolean bl) {
        protectionDomain.hasAllPerm = bl;
    }

    private static /* synthetic */ void _jr$ip$staticPermissions(ProtectionDomain protectionDomain, boolean bl) {
        protectionDomain.staticPermissions = bl;
    }

    static /* synthetic */ void _jr$ip$key(Object object, Key key) {
        ((ProtectionDomain)((Object)object)).key = key;
    }

    protected /* synthetic */ ProtectionDomain(h h2) {
        super(h2);
    }

    final class Key
    extends h {
        Key() {
        }

        static /* synthetic */ ProtectionDomain _jr$ig$this$0(Object object) {
            return ((Key)((Object)object)).ProtectionDomain.this;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, ProtectionDomain protectionDomain) {
            ((Key)((Object)object)).ProtectionDomain.this = protectionDomain;
        }
    }
}

