/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.facade.aj;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.facade.x;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import sun.security.util.Debug;

public abstract class Provider
extends Properties {
    static final long serialVersionUID = -4298000515446427739L;
    private static final Debug debug = Debug.getInstance("provider", "Provider");
    private String name;
    private String info;
    private double version;
    private transient Set<Map.Entry<Object, Object>> entrySet;
    private transient int entrySetCallCount;
    private transient boolean initialized;
    private transient boolean legacyChanged;
    private transient boolean servicesChanged;
    private transient Map<String, String> legacyStrings;
    private transient Map<ServiceKey, Service> serviceMap;
    private transient Map<ServiceKey, Service> legacyMap;
    private transient Set<Service> serviceSet;
    private static final String ALIAS_PREFIX = "Alg.Alias.";
    private static final String ALIAS_PREFIX_LOWER = "alg.alias.";
    private static final int ALIAS_LENGTH = "Alg.Alias.".length();
    private static volatile ServiceKey previousKey = new ServiceKey("", "", false);
    private static final Map<String, EngineDescription> knownEngines = new HashMap<String, EngineDescription>();

    protected Provider(String string, double d, String string2) {
        this.entrySet = null;
        this.entrySetCallCount = 0;
        this.name = string;
        this.version = d;
        this.info = string2;
        this.putId();
        this.initialized = true;
    }

    public String getName() {
        return this.name;
    }

    public double getVersion() {
        return this.version;
    }

    public String getInfo() {
        return this.info;
    }

    @Override
    public String toString() {
        return this.name + " version " + this.version;
    }

    @Override
    @af(modifiers=33)
    public void clear() {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                this.check("clearProviderProperties." + this.name);
                if (debug != null) {
                    debug.println("Remove " + this.name + " provider properties");
                }
                this.implClear();
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    @af(modifiers=33)
    public void load(InputStream inputStream) throws IOException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                this.check("putProviderProperty." + this.name);
                if (debug != null) {
                    debug.println("Load " + this.name + " provider properties");
                }
                Properties properties = new Properties();
                properties.load(inputStream);
                this.implPutAll(properties);
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    @af(modifiers=33)
    public void putAll(Map<?, ?> map) {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                this.check("putProviderProperty." + this.name);
                if (debug != null) {
                    debug.println("Put all " + this.name + " provider properties");
                }
                this.implPutAll(map);
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    @af(modifiers=33)
    public Set<Map.Entry<Object, Object>> entrySet() {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                this.checkInitialized();
                if (this.entrySet == null) {
                    Provider provider = this;
                    int n2 = provider.entrySetCallCount;
                    provider.entrySetCallCount = n2 + 1;
                    if (n2 == 0) {
                        this.entrySet = Collections.unmodifiableMap(this).entrySet();
                    } else {
                        return super.entrySet();
                    }
                }
                if (this.entrySetCallCount != 2) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new RuntimeException("Internal error."));
                }
                return this.entrySet;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    public Set<Object> keySet() {
        this.checkInitialized();
        return Collections.unmodifiableSet(super.keySet());
    }

    @Override
    public Collection<Object> values() {
        this.checkInitialized();
        return Collections.unmodifiableCollection(super.values());
    }

    @Override
    @af(modifiers=33)
    public Object put(Object object, Object object2) {
        Object object3 = ah.getMonitor((Object)this);
        synchronized (object3) {
            try {
                this.check("putProviderProperty." + this.name);
                if (debug != null) {
                    debug.println("Set " + this.name + " provider property [" + object + "/" + object2 + "]");
                }
                return this.implPut(object, object2);
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    @af(modifiers=33)
    public Object remove(Object object) {
        Object object2 = ah.getMonitor((Object)this);
        synchronized (object2) {
            try {
                this.check("removeProviderProperty." + this.name);
                if (debug != null) {
                    debug.println("Remove " + this.name + " provider property " + object);
                }
                return this.implRemove(object);
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    public Object get(Object object) {
        this.checkInitialized();
        return super.get(object);
    }

    @Override
    public Enumeration<Object> keys() {
        this.checkInitialized();
        return super.keys();
    }

    @Override
    public Enumeration<Object> elements() {
        this.checkInitialized();
        return super.elements();
    }

    @Override
    public String getProperty(String string) {
        this.checkInitialized();
        return super.getProperty(string);
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException());
        }
    }

    private void check(String string) {
        this.checkInitialized();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess(string);
        }
    }

    private void putId() {
        super.put("Provider.id name", String.valueOf(this.name));
        super.put("Provider.id version", String.valueOf(this.version));
        super.put("Provider.id info", String.valueOf(this.info));
        super.put("Provider.id className", x.getName(this.getClass()));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        HashMap hashMap = new HashMap();
        Iterator iterator = super.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)g.convertForCast(iterator.next(), Map.Entry.class);
            hashMap.put(entry.getKey(), entry.getValue());
        }
        Provider._jr$ip$defaults(this, null);
        objectInputStream.defaultReadObject();
        this.implClear();
        this.initialized = true;
        this.putAll((Map<?, ?>)hashMap);
    }

    private void implPutAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)g.convertForCast(iterator.next(), Map.Entry.class);
            this.implPut(entry.getKey(), entry.getValue());
        }
    }

    private Object implRemove(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            if (string.startsWith("Provider.")) {
                return null;
            }
            this.legacyChanged = true;
            if (this.legacyStrings == null) {
                this.legacyStrings = new LinkedHashMap();
            }
            this.legacyStrings.remove(string);
        }
        return super.remove(object);
    }

    private Object implPut(Object object, Object object2) {
        if (object instanceof String && object2 instanceof String) {
            String string = (String)object;
            if (string.startsWith("Provider.")) {
                return null;
            }
            this.legacyChanged = true;
            if (this.legacyStrings == null) {
                this.legacyStrings = new LinkedHashMap();
            }
            this.legacyStrings.put(string, (String)object2);
        }
        return super.put(object, object2);
    }

    private void implClear() {
        if (this.legacyStrings != null) {
            this.legacyStrings.clear();
        }
        if (this.legacyMap != null) {
            this.legacyMap.clear();
        }
        if (this.serviceMap != null) {
            this.serviceMap.clear();
        }
        this.legacyChanged = false;
        this.servicesChanged = false;
        this.serviceSet = null;
        super.clear();
        this.putId();
    }

    private void ensureLegacyParsed() {
        if (!this.legacyChanged || this.legacyStrings == null) {
            return;
        }
        this.serviceSet = null;
        if (this.legacyMap == null) {
            this.legacyMap = new LinkedHashMap();
        } else {
            this.legacyMap.clear();
        }
        Iterator iterator = this.legacyStrings.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)g.convertForCast(iterator.next(), Map.Entry.class);
            this.parseLegacyPut((String)entry.getKey(), (String)entry.getValue());
        }
        this.removeInvalidServices(this.legacyMap);
        this.legacyChanged = false;
    }

    private void removeInvalidServices(Map<ServiceKey, Service> map) {
        Iterator<Map.Entry<ServiceKey, Service>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)g.convertForCast(iterator.next(), Map.Entry.class);
            Service service = (Service)((Object)g.convertForCast(entry.getValue(), Service.class));
            if (service.isValid()) continue;
            iterator.remove();
        }
    }

    private String[] getTypeAndAlgorithm(String string) {
        int n2 = string.indexOf(".");
        if (n2 < 1) {
            if (debug != null) {
                debug.println("Ignoring invalid entry in provider " + this.name + ":" + string);
            }
            return null;
        }
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2 + 1);
        return new String[]{string2, string3};
    }

    private void parseLegacyPut(String string, String string2) {
        if (string.toLowerCase(Locale.ENGLISH).startsWith(ALIAS_PREFIX_LOWER)) {
            String string3 = string2;
            String string4 = string.substring(ALIAS_LENGTH);
            String[] stringArray = this.getTypeAndAlgorithm(string4);
            if (stringArray == null) {
                return;
            }
            String string5 = Provider.getEngineName(stringArray[0]);
            String string6 = stringArray[1].intern();
            ServiceKey serviceKey = new ServiceKey(string5, string3, true);
            Service service = (Service)((Object)g.convertForCast(this.legacyMap.get((Object)serviceKey), Service.class));
            if (service == null) {
                service = new Service(this);
                Service.access$302(service, string5);
                Service.access$402(service, string3);
                this.legacyMap.put(serviceKey, service);
            }
            this.legacyMap.put(new ServiceKey(string5, string6, true), service);
            service.addAlias(string6);
        } else {
            String[] stringArray = this.getTypeAndAlgorithm(string);
            if (stringArray == null) {
                return;
            }
            int n2 = stringArray[1].indexOf(32);
            if (n2 == -1) {
                String string7 = Provider.getEngineName(stringArray[0]);
                String string8 = stringArray[1].intern();
                String string9 = string2;
                ServiceKey serviceKey = new ServiceKey(string7, string8, true);
                Service service = (Service)((Object)g.convertForCast(this.legacyMap.get((Object)serviceKey), Service.class));
                if (service == null) {
                    service = new Service(this);
                    Service.access$302(service, string7);
                    Service.access$402(service, string8);
                    this.legacyMap.put(serviceKey, service);
                }
                Service.access$602(service, string9);
            } else {
                String string10 = string2;
                String string11 = Provider.getEngineName(stringArray[0]);
                String string12 = stringArray[1];
                String string13 = string12.substring(0, n2).intern();
                String string14 = string12.substring(n2 + 1);
                while (string14.startsWith(" ")) {
                    string14 = string14.substring(1);
                }
                string14 = string14.intern();
                ServiceKey serviceKey = new ServiceKey(string11, string13, true);
                Service service = (Service)((Object)g.convertForCast(this.legacyMap.get((Object)serviceKey), Service.class));
                if (service == null) {
                    service = new Service(this);
                    Service.access$302(service, string11);
                    Service.access$402(service, string13);
                    this.legacyMap.put(serviceKey, service);
                }
                service.addAttribute(string14, string10);
            }
        }
    }

    @af(modifiers=33)
    public Service getService(String string, String string2) {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                Service service;
                this.checkInitialized();
                ServiceKey serviceKey = previousKey;
                if (!serviceKey.matches(string, string2)) {
                    previousKey = serviceKey = new ServiceKey(string, string2, false);
                }
                if (this.serviceMap != null && (service = (Service)((Object)g.convertForCast(this.serviceMap.get((Object)serviceKey), Service.class))) != null) {
                    return service;
                }
                this.ensureLegacyParsed();
                return this.legacyMap != null ? (Service)((Object)g.convertForCast(this.legacyMap.get((Object)serviceKey), Service.class)) : null;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @af(modifiers=33)
    public Set<Service> getServices() {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                this.checkInitialized();
                if (this.legacyChanged || this.servicesChanged) {
                    this.serviceSet = null;
                }
                if (this.serviceSet == null) {
                    this.ensureLegacyParsed();
                    LinkedHashSet linkedHashSet = new LinkedHashSet();
                    if (this.serviceMap != null) {
                        linkedHashSet.addAll(this.serviceMap.values());
                    }
                    if (this.legacyMap != null) {
                        linkedHashSet.addAll(this.legacyMap.values());
                    }
                    this.serviceSet = Collections.unmodifiableSet(linkedHashSet);
                    this.servicesChanged = false;
                }
                return this.serviceSet;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @af(modifiers=36)
    protected void putService(Service service) {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                this.check("putProviderProperty." + this.name);
                if (debug != null) {
                    debug.println(this.name + ".putService(): " + (Object)((Object)service));
                }
                if (service == null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
                }
                if (f.ifAcmp((Object)service.getProvider(), (Object)this)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("service.getProvider() must match this Provider object"));
                }
                if (this.serviceMap == null) {
                    this.serviceMap = new LinkedHashMap();
                }
                this.servicesChanged = true;
                String string = service.getType();
                String string2 = service.getAlgorithm();
                ServiceKey serviceKey = new ServiceKey(string, string2, true);
                this.implRemoveService((Service)((Object)g.convertForCast(this.serviceMap.get((Object)serviceKey), Service.class)));
                this.serviceMap.put(serviceKey, service);
                for (String string3 : service.getAliases()) {
                    this.serviceMap.put(new ServiceKey(string, string3, true), service);
                }
                this.putPropertyStrings(service);
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    private void putPropertyStrings(Service service) {
        String string = service.getType();
        String string2 = service.getAlgorithm();
        super.put(string + "." + string2, service.getClassName());
        for (Object object : service.getAliases()) {
            super.put(ALIAS_PREFIX + string + "." + (String)object, string2);
        }
        Iterator<Object> iterator = Service._jr$ig$attributes(service).entrySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            object = (Map.Entry)g.convertForCast((Object)iterator.next(), Map.Entry.class);
            String string3 = string + "." + string2 + " " + object.getKey();
            super.put(string3, object.getValue());
        }
    }

    private void removePropertyStrings(Service service) {
        String string = service.getType();
        String string2 = service.getAlgorithm();
        super.remove(string + "." + string2);
        for (Object object : service.getAliases()) {
            super.remove(ALIAS_PREFIX + string + "." + (String)object);
        }
        Iterator<Object> iterator = Service._jr$ig$attributes(service).entrySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            object = (Map.Entry)g.convertForCast((Object)iterator.next(), Map.Entry.class);
            String string3 = string + "." + string2 + " " + object.getKey();
            super.remove(string3);
        }
    }

    @af(modifiers=36)
    protected void removeService(Service service) {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                this.check("removeProviderProperty." + this.name);
                if (debug != null) {
                    debug.println(this.name + ".removeService(): " + (Object)((Object)service));
                }
                if (service == null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
                }
                this.implRemoveService(service);
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    private void implRemoveService(Service service) {
        if (service == null || this.serviceMap == null) {
            return;
        }
        String string = service.getType();
        String string2 = service.getAlgorithm();
        ServiceKey serviceKey = new ServiceKey(string, string2, false);
        Service service2 = (Service)((Object)g.convertForCast(this.serviceMap.get((Object)serviceKey), Service.class));
        if (f.ifAcmp((Object)((Object)service), (Object)((Object)service2))) {
            return;
        }
        this.servicesChanged = true;
        this.serviceMap.remove((Object)serviceKey);
        for (String string3 : service.getAliases()) {
            this.serviceMap.remove((Object)new ServiceKey(string, string3, false));
        }
        this.removePropertyStrings(service);
    }

    private static void addEngine(String string, boolean bl, String string2) {
        EngineDescription engineDescription = new EngineDescription(string, bl, string2);
        knownEngines.put(string.toLowerCase(Locale.ENGLISH), engineDescription);
        knownEngines.put(string, engineDescription);
    }

    private static String getEngineName(String string) {
        EngineDescription engineDescription = (EngineDescription)((Object)g.convertForCast((Object)((Object)knownEngines.get(string)), EngineDescription.class));
        if (engineDescription == null) {
            engineDescription = (EngineDescription)((Object)g.convertForCast((Object)((Object)knownEngines.get(string.toLowerCase(Locale.ENGLISH))), EngineDescription.class));
        }
        return engineDescription == null ? string : ((EngineDescription)((Object)((Object)engineDescription))).name;
    }

    static {
        Provider.addEngine("AlgorithmParameterGenerator", false, null);
        Provider.addEngine("AlgorithmParameters", false, null);
        Provider.addEngine("KeyFactory", false, null);
        Provider.addEngine("KeyPairGenerator", false, null);
        Provider.addEngine("KeyStore", false, null);
        Provider.addEngine("MessageDigest", false, null);
        Provider.addEngine("SecureRandom", false, null);
        Provider.addEngine("Signature", true, null);
        Provider.addEngine("CertificateFactory", false, null);
        Provider.addEngine("CertPathBuilder", false, null);
        Provider.addEngine("CertPathValidator", false, null);
        Provider.addEngine("CertStore", false, "java.security.cert.CertStoreParameters");
        Provider.addEngine("Cipher", true, null);
        Provider.addEngine("ExemptionMechanism", false, null);
        Provider.addEngine("Mac", true, null);
        Provider.addEngine("KeyAgreement", true, null);
        Provider.addEngine("KeyGenerator", false, null);
        Provider.addEngine("SecretKeyFactory", false, null);
        Provider.addEngine("KeyManagerFactory", false, null);
        Provider.addEngine("SSLContext", false, null);
        Provider.addEngine("TrustManagerFactory", false, null);
        Provider.addEngine("GssApiMechanism", false, null);
        Provider.addEngine("SaslClientFactory", false, null);
        Provider.addEngine("SaslServerFactory", false, null);
        Provider.addEngine("Policy", false, "java.security.Policy$Parameters");
        Provider.addEngine("Configuration", false, "javax.security.auth.login.Configuration$Parameters");
        Provider.addEngine("XMLSignatureFactory", false, null);
        Provider.addEngine("KeyInfoFactory", false, null);
        Provider.addEngine("TransformService", false, null);
        Provider.addEngine("TerminalFactory", false, "java.lang.Object");
    }

    private static /* synthetic */ void _jr$ip$name(Provider provider, String string) {
        provider.name = string;
    }

    private static /* synthetic */ void _jr$ip$info(Provider provider, String string) {
        provider.info = string;
    }

    private static /* synthetic */ void _jr$ip$version(Provider provider, double d) {
        provider.version = d;
    }

    protected /* synthetic */ Provider(h h2) {
        super(h2);
    }

    private static class EngineDescription
    extends h {
        final String name;
        final boolean supportsParameter;
        final String constructorParameterClassName;
        private volatile Class constructorParameterClass;

        EngineDescription(String string, boolean bl, String string2) {
            this.name = string;
            this.supportsParameter = bl;
            this.constructorParameterClassName = string2;
        }

        Class getConstructorParameterClass() throws ClassNotFoundException {
            Class<?> clazz = this.constructorParameterClass;
            if (clazz == null) {
                clazz = Class.forName(((EngineDescription)((Object)((Object)this))).constructorParameterClassName);
                this.constructorParameterClass = clazz;
            }
            return clazz;
        }

        static /* synthetic */ void _jr$ip$name(Object object, String string) {
            ((EngineDescription)((Object)object)).name = string;
        }

        static /* synthetic */ void _jr$ip$supportsParameter(Object object, boolean bl) {
            ((EngineDescription)((Object)object)).supportsParameter = bl;
        }

        static /* synthetic */ void _jr$ip$constructorParameterClassName(Object object, String string) {
            ((EngineDescription)((Object)object)).constructorParameterClassName = string;
        }

        protected /* synthetic */ EngineDescription(h h2) {
            super(h2);
        }
    }

    public static class Service
    extends h {
        private String type;
        private String algorithm;
        private String className;
        private final Provider provider;
        private List<String> aliases;
        private Map<UString, String> attributes;
        private volatile Reference<Class> classRef;
        private volatile Boolean hasKeyAttributes;
        private String[] supportedFormats;
        private Class[] supportedClasses;
        private boolean registered;
        private static final Class[] CLASS0 = new Class[0];

        private Service(Provider provider) {
            this.provider = provider;
            this.aliases = Collections.emptyList();
            this.attributes = Collections.emptyMap();
        }

        private boolean isValid() {
            return this.type != null && this.algorithm != null && this.className != null;
        }

        private void addAlias(String string) {
            if (this.aliases.isEmpty()) {
                this.aliases = new ArrayList(2);
            }
            this.aliases.add(string);
        }

        void addAttribute(String string, String string2) {
            if (this.attributes.isEmpty()) {
                this.attributes = new HashMap(8);
            }
            this.attributes.put(new UString(string), string2);
        }

        public Service(Provider provider, String string, String string2, String string3, List<String> list, Map<String, String> map) {
            if (provider == null || string == null || string2 == null || string3 == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
            }
            this.provider = provider;
            this.type = Provider.getEngineName(string);
            this.algorithm = string2;
            this.className = string3;
            this.aliases = list == null ? Collections.emptyList() : new ArrayList<String>(list);
            if (map == null) {
                this.attributes = Collections.emptyMap();
            } else {
                this.attributes = new HashMap<UString, String>();
                Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)g.convertForCast(iterator.next(), Map.Entry.class);
                    this.attributes.put(new UString((String)entry.getKey()), (String)entry.getValue());
                }
            }
        }

        public final String getType() {
            return this.type;
        }

        public final String getAlgorithm() {
            return this.algorithm;
        }

        public final Provider getProvider() {
            return this.provider;
        }

        public final String getClassName() {
            return this.className;
        }

        private final List<String> getAliases() {
            return this.aliases;
        }

        public final String getAttribute(String string) {
            if (string == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
            }
            return (String)this.attributes.get((Object)new UString(string));
        }

        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            if (!this.registered) {
                if (f.ifAcmp((Object)((Object)this.provider.getService(this.type, this.algorithm)), (Object)((Object)this))) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchAlgorithmException("Service not registered with Provider " + this.provider.getName() + ": " + (Object)((Object)this)));
                }
                this.registered = true;
            }
            try {
                Class clazz;
                EngineDescription engineDescription = (EngineDescription)((Object)g.convertForCast(knownEngines.get(this.type), EngineDescription.class));
                if (engineDescription == null) {
                    return this.newInstanceGeneric(object);
                }
                if (((EngineDescription)((Object)((Object)engineDescription))).constructorParameterClassName == null) {
                    if (object != null) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidParameterException("constructorParameter not used with " + this.type + " engines"));
                    }
                    Class clazz2 = this.getImplClass();
                    return ai.getCurrentClass((Class)clazz2).newInstance();
                }
                Class clazz3 = engineDescription.getConstructorParameterClass();
                if (object != null && !x.isAssignableFrom((Class)clazz3, (Class)(clazz = object.getClass()))) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidParameterException("constructorParameter must be instanceof " + ((EngineDescription)((Object)((Object)engineDescription))).constructorParameterClassName.replace('$', '.') + " for engine type " + this.type));
                }
                clazz = this.getImplClass();
                Object[] objectArray = new Class[1];
                a.arrayStore((Object[])objectArray, (int)0, (Object)clazz3);
                aj aj2 = ai.convertArgs((Class)clazz, (Class[])objectArray);
                Constructor constructor = aj2.clazz.getConstructor(aj2.args);
                Object[] objectArray2 = new Object[1];
                a.arrayStore((Object[])objectArray2, (int)0, (Object)object);
                return constructor.newInstance(objectArray2);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)noSuchAlgorithmException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchAlgorithmException("Error constructing implementation (algorithm: " + this.algorithm + ", provider: " + this.provider.getName() + ", class: " + this.className + ")", invocationTargetException.getCause()));
            }
            catch (Exception exception) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchAlgorithmException("Error constructing implementation (algorithm: " + this.algorithm + ", provider: " + this.provider.getName() + ", class: " + this.className + ")", exception));
            }
        }

        private Class getImplClass() throws NoSuchAlgorithmException {
            try {
                Class<?> clazz;
                Reference reference = this.classRef;
                Class<?> clazz2 = clazz = reference == null ? null : (Class<?>)reference.get();
                if (clazz == null) {
                    ClassLoader classLoader = this.provider.getClass().getClassLoader();
                    clazz = classLoader == null ? Class.forName(this.className) : classLoader.loadClass(this.className);
                    this.classRef = new WeakReference(clazz);
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchAlgorithmException("class configured for " + this.type + "(provider: " + this.provider.getName() + ")" + "cannot be found.", classNotFoundException));
            }
        }

        private Object newInstanceGeneric(Object object) throws Exception {
            Class clazz = this.getImplClass();
            if (object == null) {
                Object t = ai.getCurrentClass((Class)clazz).newInstance();
                return t;
            }
            Class<?> clazz2 = object.getClass();
            Object[] objectArray = ai.getCurrentClass((Class)clazz).getConstructors();
            for (int i = 0; i < a.arrayLength((Object[])objectArray); ++i) {
                Constructor constructor = (Constructor)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), Constructor.class);
                Object[] objectArray2 = constructor.getParameterTypes();
                if (a.arrayLength((Object[])objectArray2) != 1 || !x.isAssignableFrom((Class)((Class)a.arrayLoad((Object[])objectArray2, (int)0)), clazz2)) continue;
                Object[] objectArray3 = new Object[1];
                a.arrayStore((Object[])objectArray3, (int)0, (Object)object);
                Object t = constructor.newInstance(objectArray3);
                return t;
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchAlgorithmException("No constructor matching " + x.getName(clazz2) + " found in class " + this.className));
        }

        public boolean supportsParameter(Object object) {
            EngineDescription engineDescription = (EngineDescription)((Object)g.convertForCast(knownEngines.get(this.type), EngineDescription.class));
            if (engineDescription == null) {
                return true;
            }
            if (!((EngineDescription)((Object)((Object)engineDescription))).supportsParameter) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidParameterException("supportsParameter() not used with " + this.type + " engines"));
            }
            if (object != null && !(g.convertForInstanceOf((Object)object, Key.class) instanceof Key)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidParameterException("Parameter must be instanceof Key for engine " + this.type));
            }
            if (!this.hasKeyAttributes()) {
                return true;
            }
            if (object == null) {
                return false;
            }
            Key key = (Key)g.convertForCast((Object)object, Key.class);
            if (this.supportsKeyFormat(key)) {
                return true;
            }
            return this.supportsKeyClass(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean hasKeyAttributes() {
            Boolean bl = this.hasKeyAttributes;
            if (bl == null) {
                Object object = ah.getMonitor((Object)((Object)this));
                synchronized (object) {
                    try {
                        String string = this.getAttribute("SupportedKeyFormats");
                        if (string != null) {
                            this.supportedFormats = string.split("\\|");
                        }
                        if ((string = this.getAttribute("SupportedKeyClasses")) != null) {
                            Object[] objectArray = string.split("\\|");
                            ArrayList<Class> arrayList = new ArrayList<Class>(a.arrayLength((Object[])objectArray));
                            Object[] objectArray2 = objectArray;
                            int n2 = a.arrayLength((Object[])objectArray2);
                            for (int i = 0; i < n2; ++i) {
                                String string2 = (String)a.arrayLoad((Object[])objectArray2, (int)i);
                                Class clazz = this.getKeyClass(string2);
                                if (clazz == null) continue;
                                arrayList.add(clazz);
                            }
                            this.supportedClasses = arrayList.toArray(Service.CLASS0);
                        }
                        boolean bl2 = this.supportedFormats != null || this.supportedClasses != null;
                        bl = bl2;
                        this.hasKeyAttributes = bl;
                    }
                    catch (Throwable throwable) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                    }
                }
            }
            return bl;
        }

        private Class getKeyClass(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    ClassLoader classLoader = this.provider.getClass().getClassLoader();
                    if (classLoader != null) {
                        return classLoader.loadClass(string);
                    }
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    // empty catch block
                }
                return null;
            }
        }

        private boolean supportsKeyFormat(Key key) {
            if (this.supportedFormats == null) {
                return false;
            }
            String string = key.getFormat();
            if (string == null) {
                return false;
            }
            Object[] objectArray = this.supportedFormats;
            int n2 = a.arrayLength((Object[])objectArray);
            for (int i = 0; i < n2; ++i) {
                String string2 = (String)a.arrayLoad((Object[])objectArray, (int)i);
                if (!string2.equals(string)) continue;
                return true;
            }
            return false;
        }

        private boolean supportsKeyClass(Key key) {
            if (this.supportedClasses == null) {
                return false;
            }
            Class<?> clazz = key.getClass();
            Object[] objectArray = this.supportedClasses;
            int n2 = a.arrayLength((Object[])objectArray);
            for (int i = 0; i < n2; ++i) {
                Class clazz2 = (Class)a.arrayLoad((Object[])objectArray, (int)i);
                if (!x.isAssignableFrom((Class)clazz2, clazz)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            String string = this.aliases.isEmpty() ? "" : "\r\n  aliases: " + this.aliases.toString();
            String string2 = this.attributes.isEmpty() ? "" : "\r\n  attributes: " + this.attributes.toString();
            return this.provider.getName() + ": " + this.type + "." + this.algorithm + " -> " + this.className + string + string2 + "\r\n";
        }

        static /* synthetic */ String access$302(Service service, String string) {
            String string2 = string;
            service.type = string2;
            return string2;
        }

        static /* synthetic */ String access$402(Service service, String string) {
            String string2 = string;
            service.algorithm = string2;
            return string2;
        }

        static /* synthetic */ String access$602(Service service, String string) {
            String string2 = string;
            service.className = string2;
            return string2;
        }

        private static /* synthetic */ void _jr$ip$provider(Service service, Provider provider) {
            service.provider = provider;
        }

        protected /* synthetic */ Service(h h2) {
            super(h2);
        }
    }

    private static class ServiceKey
    extends h {
        private final String type;
        private final String algorithm;
        private final String originalAlgorithm;

        private ServiceKey(String string, String string2, boolean bl) {
            this.type = string;
            this.originalAlgorithm = string2;
            string2 = string2.toUpperCase(Locale.ENGLISH);
            this.algorithm = bl ? string2.intern() : string2;
        }

        public int hashCode() {
            return this.type.hashCode() + this.algorithm.hashCode();
        }

        public boolean equals(Object object) {
            if (!f.ifAcmp((Object)((Object)this), (Object)object)) {
                return true;
            }
            if (!(g.convertForInstanceOf((Object)object, ServiceKey.class) instanceof ServiceKey)) {
                return false;
            }
            ServiceKey serviceKey = (ServiceKey)((Object)g.convertForCast((Object)object, ServiceKey.class));
            return this.type.equals(serviceKey.type) && this.algorithm.equals(serviceKey.algorithm);
        }

        boolean matches(String string, String string2) {
            return !f.ifAcmp((Object)this.type, (Object)string) && !f.ifAcmp((Object)this.originalAlgorithm, (Object)string2);
        }

        private static /* synthetic */ void _jr$ip$type(ServiceKey serviceKey, String string) {
            serviceKey.type = string;
        }

        private static /* synthetic */ void _jr$ip$algorithm(ServiceKey serviceKey, String string) {
            serviceKey.algorithm = string;
        }

        private static /* synthetic */ void _jr$ip$originalAlgorithm(ServiceKey serviceKey, String string) {
            serviceKey.originalAlgorithm = string;
        }

        protected /* synthetic */ ServiceKey(h h2) {
            super(h2);
        }
    }

    private static class UString
    extends h {
        final String string;
        final String lowerString;

        UString(String string) {
            this.string = string;
            this.lowerString = string.toLowerCase(Locale.ENGLISH);
        }

        public int hashCode() {
            return ((UString)((Object)((Object)this))).lowerString.hashCode();
        }

        public boolean equals(Object object) {
            if (!f.ifAcmp((Object)((Object)this), (Object)object)) {
                return true;
            }
            if (!(g.convertForInstanceOf((Object)object, UString.class) instanceof UString)) {
                return false;
            }
            UString uString = (UString)((Object)g.convertForCast((Object)object, UString.class));
            return ((UString)((Object)((Object)this))).lowerString.equals(((UString)((Object)((Object)uString))).lowerString);
        }

        public String toString() {
            return ((UString)((Object)((Object)this))).string;
        }

        static /* synthetic */ void _jr$ip$string(Object object, String string) {
            ((UString)((Object)object)).string = string;
        }

        static /* synthetic */ void _jr$ip$lowerString(Object object, String string) {
            ((UString)((Object)object)).lowerString = string;
        }

        protected /* synthetic */ UString(h h2) {
            super(h2);
        }
    }
}

