/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.nio.ByteBuffer;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.HashMap;
import sun.security.util.Debug;

public class SecureClassLoader
extends ClassLoader {
    private final boolean initialized;
    private final HashMap<CodeSource, ProtectionDomain> pdcache;
    private static final Debug debug = Debug.getInstance("scl");

    protected SecureClassLoader(ClassLoader classLoader) {
        super(classLoader);
        this.pdcache = new HashMap(11);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.initialized = true;
    }

    protected SecureClassLoader() {
        this.pdcache = new HashMap(11);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.initialized = true;
    }

    protected final Class<?> defineClass(String string, byte[] byArray, int n, int n2, CodeSource codeSource) {
        return this.defineClass(string, byArray, n, n2, this.getProtectionDomain(codeSource));
    }

    protected final Class<?> defineClass(String string, ByteBuffer byteBuffer, CodeSource codeSource) {
        return this.defineClass(string, byteBuffer, this.getProtectionDomain(codeSource));
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        this.check();
        return new Permissions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProtectionDomain getProtectionDomain(CodeSource codeSource) {
        if (codeSource == null) {
            return null;
        }
        ProtectionDomain protectionDomain = null;
        Object object = ah.getMonitor((Object)this.pdcache);
        synchronized (object) {
            try {
                protectionDomain = (ProtectionDomain)((Object)g.convertForCast(this.pdcache.get(codeSource), ProtectionDomain.class));
                if (protectionDomain == null) {
                    PermissionCollection permissionCollection = this.getPermissions(codeSource);
                    protectionDomain = new ProtectionDomain(codeSource, permissionCollection, this, null);
                    this.pdcache.put(codeSource, protectionDomain);
                    if (debug != null) {
                        debug.println(" getPermissions " + (Object)((Object)protectionDomain));
                        debug.println("");
                    }
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        return protectionDomain;
    }

    private void check() {
        if (!this.initialized) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SecurityException("ClassLoader object not initialized"));
        }
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }

    private static /* synthetic */ void _jr$ip$initialized(SecureClassLoader secureClassLoader, boolean bl) {
        secureClassLoader.initialized = bl;
    }

    private static /* synthetic */ void _jr$ip$pdcache(SecureClassLoader secureClassLoader, HashMap hashMap) {
        secureClassLoader.pdcache = hashMap;
    }

    protected /* synthetic */ SecureClassLoader(h h2) {
        super(h2);
    }
}

