/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandomSpi;
import java.util.Iterator;
import java.util.Random;
import sun.security.jca.GetInstance;
import sun.security.jca.Providers;

public class SecureRandom
extends Random {
    private Provider provider;
    private SecureRandomSpi secureRandomSpi;
    private String algorithm;
    private static volatile SecureRandom seedGenerator = null;
    static final long serialVersionUID = 4940670005562187L;
    private byte[] state;
    private MessageDigest digest;
    private byte[] randomBytes;
    private int randomBytesUsed;
    private long counter;

    public SecureRandom() {
        super(0L);
        this.provider = null;
        this.secureRandomSpi = null;
        this.digest = null;
        this.getDefaultPRNG(false, null);
    }

    public SecureRandom(byte[] byArray) {
        super(0L);
        this.provider = null;
        this.secureRandomSpi = null;
        this.digest = null;
        this.getDefaultPRNG(true, byArray);
    }

    private void getDefaultPRNG(boolean bl, byte[] byArray) {
        String string = SecureRandom.getPrngAlgorithm();
        if (string == null) {
            string = "SHA1PRNG";
            this.secureRandomSpi = new sun.security.provider.SecureRandom();
            this.provider = Providers.getSunProvider();
            if (bl) {
                this.secureRandomSpi.engineSetSeed(byArray);
            }
        } else {
            try {
                SecureRandom secureRandom = SecureRandom.getInstance(string);
                this.secureRandomSpi = secureRandom.getSecureRandomSpi();
                this.provider = secureRandom.getProvider();
                if (bl) {
                    this.secureRandomSpi.engineSetSeed(byArray);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new RuntimeException(noSuchAlgorithmException));
            }
        }
        if (!f.ifAcmp(this.getClass(), SecureRandom.class)) {
            this.algorithm = string;
        }
    }

    protected SecureRandom(SecureRandomSpi secureRandomSpi, Provider provider) {
        this(secureRandomSpi, provider, null);
    }

    private SecureRandom(SecureRandomSpi secureRandomSpi, Provider provider, String string) {
        super(0L);
        this.provider = null;
        this.secureRandomSpi = null;
        this.digest = null;
        this.secureRandomSpi = secureRandomSpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public static SecureRandom getInstance(String string) throws NoSuchAlgorithmException {
        GetInstance.Instance instance = GetInstance.getInstance("SecureRandom", SecureRandomSpi.class, string);
        return new SecureRandom((SecureRandomSpi)g.convertForCast((Object)instance.impl, SecureRandomSpi.class), instance.provider, string);
    }

    public static SecureRandom getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        GetInstance.Instance instance = GetInstance.getInstance("SecureRandom", SecureRandomSpi.class, string, string2);
        return new SecureRandom((SecureRandomSpi)g.convertForCast((Object)instance.impl, SecureRandomSpi.class), instance.provider, string);
    }

    public static SecureRandom getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        GetInstance.Instance instance = GetInstance.getInstance("SecureRandom", SecureRandomSpi.class, string, provider);
        return new SecureRandom((SecureRandomSpi)g.convertForCast((Object)instance.impl, SecureRandomSpi.class), instance.provider, string);
    }

    SecureRandomSpi getSecureRandomSpi() {
        return this.secureRandomSpi;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public String getAlgorithm() {
        return this.algorithm != null ? this.algorithm : "unknown";
    }

    @af(modifiers=33)
    public void setSeed(byte[] byArray) {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                this.secureRandomSpi.engineSetSeed(byArray);
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    public void setSeed(long l) {
        if (l != 0L) {
            this.secureRandomSpi.engineSetSeed(SecureRandom.longToByteArray(l));
        }
    }

    @Override
    @af(modifiers=33)
    public void nextBytes(byte[] byArray) {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                this.secureRandomSpi.engineNextBytes(byArray);
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    protected final int next(int n2) {
        int n3 = (n2 + 7) / 8;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        this.nextBytes(byArray);
        for (int i = 0; i < n3; ++i) {
            n4 = (n4 << 8) + (byArray[i] & 0xFF);
        }
        return n4 >>> n3 * 8 - n2;
    }

    public static byte[] getSeed(int n2) {
        if (seedGenerator == null) {
            seedGenerator = new SecureRandom();
        }
        return seedGenerator.generateSeed(n2);
    }

    public byte[] generateSeed(int n2) {
        return this.secureRandomSpi.engineGenerateSeed(n2);
    }

    private static byte[] longToByteArray(long l) {
        byte[] byArray = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)l;
            l >>= 8;
        }
        return byArray;
    }

    private static String getPrngAlgorithm() {
        Iterator<Provider> iterator = Providers.getProviderList().providers().iterator();
        while (iterator.hasNext()) {
            Provider provider = (Provider)g.convertForCast((Object)iterator.next(), Provider.class);
            Iterator<Provider.Service> iterator2 = provider.getServices().iterator();
            while (iterator2.hasNext()) {
                Provider.Service service = (Provider.Service)((Object)g.convertForCast((Object)((Object)iterator2.next()), Provider.Service.class));
                if (!service.getType().equals("SecureRandom")) continue;
                return service.getAlgorithm();
            }
        }
        return null;
    }

    private static /* synthetic */ byte[] _jr$ig$state(SecureRandom secureRandom) {
        return secureRandom.state;
    }

    private static /* synthetic */ void _jr$ip$state(SecureRandom secureRandom, byte[] byArray) {
        secureRandom.state = byArray;
    }

    private static /* synthetic */ MessageDigest _jr$ig$digest(SecureRandom secureRandom) {
        return secureRandom.digest;
    }

    private static /* synthetic */ void _jr$ip$digest(SecureRandom secureRandom, MessageDigest messageDigest) {
        secureRandom.digest = messageDigest;
    }

    private static /* synthetic */ byte[] _jr$ig$randomBytes(SecureRandom secureRandom) {
        return secureRandom.randomBytes;
    }

    private static /* synthetic */ void _jr$ip$randomBytes(SecureRandom secureRandom, byte[] byArray) {
        secureRandom.randomBytes = byArray;
    }

    private static /* synthetic */ int _jr$ig$randomBytesUsed(SecureRandom secureRandom) {
        return secureRandom.randomBytesUsed;
    }

    private static /* synthetic */ void _jr$ip$randomBytesUsed(SecureRandom secureRandom, int n2) {
        secureRandom.randomBytesUsed = n2;
    }

    private static /* synthetic */ long _jr$ig$counter(SecureRandom secureRandom) {
        return secureRandom.counter;
    }

    private static /* synthetic */ void _jr$ip$counter(SecureRandom secureRandom, long l) {
        secureRandom.counter = l;
    }

    protected /* synthetic */ SecureRandom(h h2) {
        super(h2);
    }
}

