/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.SecurityPermission;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import sun.security.jca.GetInstance;
import sun.security.jca.ProviderList;
import sun.security.jca.Providers;
import sun.security.util.Debug;
import sun.security.util.PropertyExpander;

public final class Security
extends h {
    private static final Debug sdebug = Debug.getInstance("properties");
    private static Properties props;
    private static final Map<String, Class> spiMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void initialize() {
        boolean bl;
        block36: {
            InputStream inputStream;
            Object object;
            File file;
            boolean bl2;
            block35: {
                props = new Properties();
                bl = false;
                bl2 = false;
                file = Security.securityPropFile("java.security");
                if (file.exists()) {
                    object = null;
                    inputStream = new FileInputStream(file);
                    object = new BufferedInputStream(inputStream);
                    props.load((InputStream)object);
                    bl = true;
                    if (sdebug != null) {
                        sdebug.println("reading security properties file: " + file);
                    }
                    if (object == null) break block35;
                    try {
                        ((InputStream)object).close();
                    }
                    catch (IOException iOException) {
                        if (sdebug != null) {
                            sdebug.println("unable to close input stream");
                        }
                        break block35;
                    }
                    catch (IOException iOException) {
                        try {
                            if (sdebug != null) {
                                sdebug.println("unable to load security properties from " + file);
                                iOException.printStackTrace();
                            }
                            if (object == null) break block35;
                        }
                        catch (Throwable throwable) {
                            if (object == null) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                            try {
                                ((InputStream)object).close();
                                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                            }
                            catch (IOException iOException2) {
                                if (sdebug == null) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                                sdebug.println("unable to close input stream");
                            }
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                        }
                        try {
                            ((InputStream)object).close();
                        }
                        catch (IOException iOException3) {
                            if (sdebug != null) {
                                sdebug.println("unable to close input stream");
                            }
                        }
                    }
                }
            }
            if ("true".equalsIgnoreCase(props.getProperty("security.overridePropertiesFile"))) {
                object = System.getProperty("java.security.properties");
                if (object != null && ((String)object).startsWith("=")) {
                    bl2 = true;
                    object = ((String)object).substring(1);
                }
                if (bl2) {
                    props = new Properties();
                    if (sdebug != null) {
                        sdebug.println("overriding other security properties files!");
                    }
                }
                if (object != null) {
                    inputStream = null;
                    object = PropertyExpander.expand((String)object);
                    file = new File((String)object);
                    URL uRL = file.exists() ? new URL("file:" + file.getCanonicalPath()) : new URL((String)object);
                    inputStream = new BufferedInputStream(uRL.openStream());
                    props.load(inputStream);
                    bl = true;
                    if (sdebug != null) {
                        sdebug.println("reading security properties file: " + uRL);
                        if (bl2) {
                            sdebug.println("overriding other security properties files!");
                        }
                    }
                    if (inputStream == null) break block36;
                    try {
                        ((BufferedInputStream)inputStream).close();
                    }
                    catch (IOException iOException) {
                        if (sdebug != null) {
                            sdebug.println("unable to close input stream");
                        }
                        break block36;
                    }
                    catch (Exception exception) {
                        try {
                            if (sdebug != null) {
                                sdebug.println("unable to load security properties from " + (String)object);
                                exception.printStackTrace();
                            }
                            if (inputStream == null) break block36;
                        }
                        catch (Throwable throwable) {
                            if (inputStream == null) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                            try {
                                ((BufferedInputStream)inputStream).close();
                                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                            }
                            catch (IOException iOException) {
                                if (sdebug == null) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                                sdebug.println("unable to close input stream");
                            }
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                        }
                        try {
                            ((BufferedInputStream)inputStream).close();
                        }
                        catch (IOException iOException) {
                            if (sdebug != null) {
                                sdebug.println("unable to close input stream");
                            }
                        }
                    }
                }
            }
        }
        if (bl) return;
        Security.initializeStatic();
        if (sdebug == null) return;
        sdebug.println("unable to load security properties -- using defaults");
    }

    private static void initializeStatic() {
        props.put("security.provider.1", "sun.security.provider.Sun");
        props.put("security.provider.2", "sun.security.rsa.SunRsaSign");
        props.put("security.provider.3", "com.sun.net.ssl.internal.ssl.Provider");
        props.put("security.provider.4", "com.sun.crypto.provider.SunJCE");
        props.put("security.provider.5", "sun.security.jgss.SunProvider");
        props.put("security.provider.6", "com.sun.security.sasl.Provider");
    }

    private Security() {
    }

    private static File securityPropFile(String string) {
        String string2 = File.separator;
        return new File(System.getProperty("java.home") + string2 + "lib" + string2 + "security" + string2 + string);
    }

    private static ProviderProperty getProviderProperty(String string) {
        ProviderProperty providerProperty = null;
        List<Provider> list = Providers.getProviderList().providers();
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            String string2 = null;
            Provider provider = (Provider)g.convertForCast((Object)list.get(i), Provider.class);
            String string3 = provider.getProperty(string);
            if (string3 == null) {
                object = provider.keys();
                while (object.hasMoreElements() && string3 == null) {
                    string2 = (String)object.nextElement();
                    if (!string.equalsIgnoreCase(string2)) continue;
                    string3 = provider.getProperty(string2);
                    break;
                }
            }
            if (string3 == null) continue;
            object = new ProviderProperty();
            ((ProviderProperty)((Object)object)).className = string3;
            ((ProviderProperty)((Object)object)).provider = provider;
            return object;
        }
        return providerProperty;
    }

    private static String getProviderProperty(String string, Provider provider) {
        String string2 = provider.getProperty(string);
        if (string2 == null) {
            Enumeration<Object> enumeration = provider.keys();
            while (enumeration.hasMoreElements() && string2 == null) {
                String string3 = (String)enumeration.nextElement();
                if (!string.equalsIgnoreCase(string3)) continue;
                string2 = provider.getProperty(string3);
                break;
            }
        }
        return string2;
    }

    @Deprecated
    public static String getAlgorithmProperty(String string, String string2) {
        ProviderProperty providerProperty = Security.getProviderProperty("Alg." + string2 + "." + string);
        if (providerProperty != null) {
            return ((ProviderProperty)((Object)((Object)providerProperty))).className;
        }
        return null;
    }

    public static synchronized int insertProviderAt(Provider provider, int n2) {
        String string = provider.getName();
        Security.check("insertProvider." + string);
        ProviderList providerList = Providers.getFullProviderList();
        ProviderList providerList2 = ProviderList.insertAt(providerList, provider, n2 - 1);
        if (!f.ifAcmp((Object)((Object)providerList), (Object)((Object)providerList2))) {
            return -1;
        }
        Providers.setProviderList(providerList2);
        return providerList2.getIndex(string) + 1;
    }

    public static int addProvider(Provider provider) {
        return Security.insertProviderAt(provider, 0);
    }

    public static synchronized void removeProvider(String string) {
        Security.check("removeProvider." + string);
        ProviderList providerList = Providers.getFullProviderList();
        ProviderList providerList2 = ProviderList.remove(providerList, string);
        Providers.setProviderList(providerList2);
    }

    public static Provider[] getProviders() {
        return Providers.getFullProviderList().toArray();
    }

    public static Provider getProvider(String string) {
        return Providers.getProviderList().getProvider(string);
    }

    public static Provider[] getProviders(String string) {
        String string2 = null;
        String string3 = null;
        int n2 = string.indexOf(58);
        if (n2 == -1) {
            string2 = string;
            string3 = "";
        } else {
            string2 = string.substring(0, n2);
            string3 = string.substring(n2 + 1);
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>(1);
        hashtable.put(string2, string3);
        return Security.getProviders(hashtable);
    }

    public static Provider[] getProviders(Map<String, String> map) {
        Provider[] providerArray = Security.getProviders();
        Set<String> set = map.keySet();
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet(5);
        if (set == null || providerArray == null) {
            return providerArray;
        }
        boolean bl = true;
        for (String objectArray2 : set) {
            String i = map.get(objectArray2);
            LinkedHashSet<Provider> linkedHashSet2 = Security.getAllQualifyingCandidates(objectArray2, i, providerArray);
            if (bl) {
                linkedHashSet = linkedHashSet2;
                bl = false;
            }
            if (linkedHashSet2 != null && !linkedHashSet2.isEmpty()) {
                Iterator iterator = linkedHashSet.iterator();
                while (iterator.hasNext()) {
                    Provider provider = (Provider)g.convertForCast(iterator.next(), Provider.class);
                    if (linkedHashSet2.contains(provider)) continue;
                    iterator.remove();
                }
                continue;
            }
            linkedHashSet = null;
            break;
        }
        if (linkedHashSet == null || linkedHashSet.isEmpty()) {
            return null;
        }
        Object[] objectArray3 = linkedHashSet.toArray();
        Object[] objectArray = new Provider[a.arrayLength((Object[])objectArray3)];
        for (int i = 0; i < a.arrayLength((Object[])objectArray); ++i) {
            a.arrayStore((Object[])objectArray, (int)i, (Object)((Provider)g.convertForCast((Object)a.arrayLoad((Object[])objectArray3, (int)i), Provider.class)));
        }
        return objectArray;
    }

    private static Class getSpiClass(String string) {
        Class<?> clazz = spiMap.get(string);
        if (clazz != null) {
            return clazz;
        }
        try {
            clazz = Class.forName("java.security." + string + "Spi");
            spiMap.put(string, clazz);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError("Spi class not found", classNotFoundException));
        }
    }

    static Object[] getImpl(String string, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string3 == null) {
            return GetInstance.getInstance(string2, Security.getSpiClass(string2), string).toArray();
        }
        return GetInstance.getInstance(string2, Security.getSpiClass(string2), string, string3).toArray();
    }

    static Object[] getImpl(String string, String string2, String string3, Object object) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        if (string3 == null) {
            return GetInstance.getInstance(string2, Security.getSpiClass(string2), string, object).toArray();
        }
        return GetInstance.getInstance(string2, Security.getSpiClass(string2), string, object, string3).toArray();
    }

    static Object[] getImpl(String string, String string2, Provider provider) throws NoSuchAlgorithmException {
        return GetInstance.getInstance(string2, Security.getSpiClass(string2), string, provider).toArray();
    }

    static Object[] getImpl(String string, String string2, Provider provider, Object object) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        return GetInstance.getInstance(string2, Security.getSpiClass(string2), string, object, provider).toArray();
    }

    public static String getProperty(String string) {
        String string2;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("getProperty." + string));
        }
        if ((string2 = props.getProperty(string)) != null) {
            string2 = string2.trim();
        }
        return string2;
    }

    public static void setProperty(String string, String string2) {
        Security.check("setProperty." + string);
        props.put(string, string2);
        Security.invalidateSMCache(string);
    }

    private static void invalidateSMCache(String string) {
        boolean bl = string.equals("package.access");
        boolean bl2 = string.equals("package.definition");
        if (bl || bl2) {
            AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private static void check(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess(string);
        }
    }

    private static LinkedHashSet<Provider> getAllQualifyingCandidates(String string, String string2, Provider[] providerArray) {
        Object[] objectArray = Security.getFilterComponents(string, string2);
        String string3 = (String)a.arrayLoad((Object[])objectArray, (int)0);
        String string4 = (String)a.arrayLoad((Object[])objectArray, (int)1);
        String string5 = (String)a.arrayLoad((Object[])objectArray, (int)2);
        return Security.getProvidersNotUsingCache(string3, string4, string5, string2, providerArray);
    }

    private static LinkedHashSet<Provider> getProvidersNotUsingCache(String string, String string2, String string3, String string4, Provider[] providerArray) {
        LinkedHashSet<Provider> linkedHashSet = new LinkedHashSet<Provider>(5);
        for (int i = 0; i < a.arrayLength((Object[])providerArray); ++i) {
            if (!Security.isCriterionSatisfied((Provider)g.convertForCast((Object)a.arrayLoad((Object[])providerArray, (int)i), Provider.class), string, string2, string3, string4)) continue;
            linkedHashSet.add((Provider)g.convertForCast((Object)a.arrayLoad((Object[])providerArray, (int)i), Provider.class));
        }
        return linkedHashSet;
    }

    private static boolean isCriterionSatisfied(Provider provider, String string, String string2, String string3, String string4) {
        String string5;
        String string6 = string + '.' + string2;
        if (string3 != null) {
            string6 = string6 + ' ' + string3;
        }
        if ((string5 = Security.getProviderProperty(string6, provider)) == null) {
            String string7 = Security.getProviderProperty("Alg.Alias." + string + "." + string2, provider);
            if (string7 != null) {
                string6 = string + "." + string7;
                if (string3 != null) {
                    string6 = string6 + ' ' + string3;
                }
                string5 = Security.getProviderProperty(string6, provider);
            }
            if (string5 == null) {
                return false;
            }
        }
        if (string3 == null) {
            return true;
        }
        if (Security.isStandardAttr(string3)) {
            return Security.isConstraintSatisfied(string3, string4, string5);
        }
        return string4.equalsIgnoreCase(string5);
    }

    private static boolean isStandardAttr(String string) {
        if (string.equalsIgnoreCase("KeySize")) {
            return true;
        }
        return string.equalsIgnoreCase("ImplementedIn");
    }

    private static boolean isConstraintSatisfied(String string, String string2, String string3) {
        if (string.equalsIgnoreCase("KeySize")) {
            int n2;
            int n3 = Integer.parseInt(string2);
            return n3 <= (n2 = Integer.parseInt(string3));
        }
        if (string.equalsIgnoreCase("ImplementedIn")) {
            return string2.equalsIgnoreCase(string3);
        }
        return false;
    }

    static String[] getFilterComponents(String string, String string2) {
        int n2 = string.indexOf(46);
        if (n2 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidParameterException("Invalid filter"));
        }
        String string3 = string.substring(0, n2);
        String string4 = null;
        String string5 = null;
        if (string2.length() == 0) {
            string4 = string.substring(n2 + 1).trim();
            if (string4.length() == 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidParameterException("Invalid filter"));
            }
        } else {
            int n3 = string.indexOf(32);
            if (n3 == -1) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidParameterException("Invalid filter"));
            }
            string5 = string.substring(n3 + 1).trim();
            if (string5.length() == 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidParameterException("Invalid filter"));
            }
            if (n3 < n2 || n2 == n3 - 1) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidParameterException("Invalid filter"));
            }
            string4 = string.substring(n2 + 1, n3);
        }
        Object[] objectArray = new String[3];
        a.arrayStore((Object[])objectArray, (int)0, (Object)string3);
        a.arrayStore((Object[])objectArray, (int)1, (Object)string4);
        a.arrayStore((Object[])objectArray, (int)2, (Object)string5);
        return objectArray;
    }

    public static Set<String> getAlgorithms(String string) {
        if (string == null || string.length() == 0 || string.endsWith(".")) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Object[] objectArray = Security.getProviders();
        for (int i = 0; i < a.arrayLength((Object[])objectArray); ++i) {
            Enumeration<Object> enumeration = ((Provider)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), Provider.class)).keys();
            while (enumeration.hasMoreElements()) {
                String string2 = ((String)enumeration.nextElement()).toUpperCase();
                if (!string2.startsWith(string.toUpperCase()) || string2.indexOf(" ") >= 0) continue;
                hashSet.add(string2.substring(string.length() + 1));
            }
        }
        return Collections.unmodifiableSet(hashSet);
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Void run() {
                Security.initialize();
                return null;
            }
        });
        spiMap = new ConcurrentHashMap<String, Class>();
    }

    private static class ProviderProperty
    extends h {
        String className;
        Provider provider;

        private ProviderProperty() {
        }

        static /* synthetic */ Provider _jr$ig$provider(Object object) {
            return ((ProviderProperty)((Object)object)).provider;
        }

        protected /* synthetic */ ProviderProperty(h h2) {
            super(h2);
        }
    }
}

