/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.facade.x;
import com.zeroturnaround.jrebelbase.h;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import sun.security.jca.GetInstance;
import sun.security.jca.ServiceId;
import sun.security.util.Debug;

public abstract class Signature
extends SignatureSpi {
    private static final Debug debug = Debug.getInstance("jca", "Signature");
    private String algorithm;
    Provider provider;
    protected static final int UNINITIALIZED = 0;
    protected static final int SIGN = 2;
    protected static final int VERIFY = 3;
    protected int state;
    private static final String RSA_SIGNATURE = "NONEwithRSA";
    private static final String RSA_CIPHER = "RSA/ECB/PKCS1Padding";
    private static final List<ServiceId> rsaIds = Arrays.asList(new ServiceId("Signature", "NONEwithRSA"), new ServiceId("Cipher", "RSA/ECB/PKCS1Padding"), new ServiceId("Cipher", "RSA/ECB"), new ServiceId("Cipher", "RSA//PKCS1Padding"), new ServiceId("Cipher", "RSA"));
    private static final Map<String, Boolean> signatureInfo = new ConcurrentHashMap<String, Boolean>();

    protected Signature(String string) {
        this.state = 0;
        this.algorithm = string;
    }

    public static Signature getInstance(String string) throws NoSuchAlgorithmException {
        List<Provider.Service> list = string.equalsIgnoreCase(RSA_SIGNATURE) ? GetInstance.getServices(rsaIds) : GetInstance.getServices("Signature", string);
        Iterator<Provider.Service> iterator = list.iterator();
        if (!iterator.hasNext()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchAlgorithmException(string + " Signature not available"));
        }
        Provider.Service service;
        while (!Signature.isSpi(service = (Provider.Service)((Object)g.convertForCast((Object)((Object)iterator.next()), Provider.Service.class)))) {
            try {
                GetInstance.Instance instance = GetInstance.getInstance(service, SignatureSpi.class);
                return Signature.getInstance(instance, string);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                NoSuchAlgorithmException noSuchAlgorithmException2 = noSuchAlgorithmException;
                if (iterator.hasNext()) continue;
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)noSuchAlgorithmException2);
            }
            break;
        }
        return new Delegate(service, iterator, string);
    }

    private static Signature getInstance(GetInstance.Instance instance, String string) {
        Signature signature;
        if (g.convertForInstanceOf((Object)instance.impl, Signature.class) instanceof Signature) {
            signature = (Signature)((Object)g.convertForCast((Object)instance.impl, Signature.class));
        } else {
            SignatureSpi signatureSpi = (SignatureSpi)((Object)g.convertForCast((Object)instance.impl, SignatureSpi.class));
            signature = new Delegate(signatureSpi, string);
        }
        ((Signature)((Object)((Object)signature))).provider = instance.provider;
        return signature;
    }

    private static boolean isSpi(Provider.Service service) {
        if (service.getType().equals("Cipher")) {
            return true;
        }
        String string = service.getClassName();
        Boolean bl = (Boolean)g.convertForCast((Object)signatureInfo.get(string), Boolean.class);
        if (bl == null) {
            try {
                boolean bl2;
                Object object = service.newInstance(null);
                boolean bl3 = bl2 = g.convertForInstanceOf((Object)object, SignatureSpi.class) instanceof SignatureSpi && !(g.convertForInstanceOf((Object)object, Signature.class) instanceof Signature);
                if (debug != null && !bl2) {
                    debug.println("Not a SignatureSpi " + string);
                    debug.println("Delayed provider selection may not be available for algorithm " + service.getAlgorithm());
                }
                bl = bl2;
                signatureInfo.put(string, bl);
            }
            catch (Exception exception) {
                return false;
            }
        }
        return bl;
    }

    public static Signature getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string.equalsIgnoreCase(RSA_SIGNATURE)) {
            if (string2 == null || string2.length() == 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("missing provider"));
            }
            Provider provider = Security.getProvider(string2);
            if (provider == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchProviderException("no such provider: " + string2));
            }
            return Signature.getInstanceRSA(provider);
        }
        GetInstance.Instance instance = GetInstance.getInstance("Signature", SignatureSpi.class, string, string2);
        return Signature.getInstance(instance, string);
    }

    public static Signature getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (string.equalsIgnoreCase(RSA_SIGNATURE)) {
            if (provider == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("missing provider"));
            }
            return Signature.getInstanceRSA(provider);
        }
        GetInstance.Instance instance = GetInstance.getInstance("Signature", SignatureSpi.class, string, provider);
        return Signature.getInstance(instance, string);
    }

    private static Signature getInstanceRSA(Provider provider) throws NoSuchAlgorithmException {
        Provider.Service service = provider.getService("Signature", RSA_SIGNATURE);
        if (service != null) {
            GetInstance.Instance instance = GetInstance.getInstance(service, SignatureSpi.class);
            return Signature.getInstance(instance, RSA_SIGNATURE);
        }
        try {
            Cipher cipher = Cipher.getInstance(RSA_CIPHER, provider);
            return new Delegate(new CipherAdapter(cipher), RSA_SIGNATURE);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchAlgorithmException("no such algorithm: NONEwithRSA for provider " + provider.getName(), generalSecurityException));
        }
    }

    public final Provider getProvider() {
        this.chooseFirstProvider();
        return ((Signature)((Object)((Object)this))).provider;
    }

    void chooseFirstProvider() {
    }

    public final void initVerify(PublicKey publicKey) throws InvalidKeyException {
        this.engineInitVerify(publicKey);
        ((Signature)((Object)((Object)this))).state = 3;
    }

    public final void initVerify(Certificate certificate) throws InvalidKeyException {
        boolean[] blArray;
        Serializable serializable;
        Set set;
        if (g.convertForInstanceOf((Object)certificate, X509Certificate.class) instanceof X509Certificate && (set = (serializable = (X509Certificate)g.convertForCast((Object)certificate, X509Certificate.class)).getCriticalExtensionOIDs()) != null && !set.isEmpty() && set.contains("2.5.29.15") && (blArray = ((X509Certificate)serializable).getKeyUsage()) != null && !blArray[0]) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("Wrong key usage"));
        }
        serializable = certificate.getPublicKey();
        this.engineInitVerify((PublicKey)serializable);
        ((Signature)((Object)((Object)this))).state = 3;
    }

    public final void initSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey);
        ((Signature)((Object)((Object)this))).state = 2;
    }

    public final void initSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.engineInitSign(privateKey, secureRandom);
        ((Signature)((Object)((Object)this))).state = 2;
    }

    public final byte[] sign() throws SignatureException {
        if (((Signature)((Object)((Object)this))).state == 2) {
            return this.engineSign();
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SignatureException("object not initialized for signing"));
    }

    public final int sign(byte[] byArray, int n2, int n3) throws SignatureException {
        if (byArray == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("No output buffer given"));
        }
        if (byArray.length - n2 < n3) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Output buffer too small for specified offset and length"));
        }
        if (((Signature)((Object)((Object)this))).state != 2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SignatureException("object not initialized for signing"));
        }
        return this.engineSign(byArray, n2, n3);
    }

    public final boolean verify(byte[] byArray) throws SignatureException {
        if (((Signature)((Object)((Object)this))).state == 3) {
            return this.engineVerify(byArray);
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SignatureException("object not initialized for verification"));
    }

    public final boolean verify(byte[] byArray, int n2, int n3) throws SignatureException {
        if (((Signature)((Object)((Object)this))).state == 3) {
            if (byArray == null || n2 < 0 || n3 < 0 || n3 > byArray.length - n2) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Bad arguments"));
            }
            return this.engineVerify(byArray, n2, n3);
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SignatureException("object not initialized for verification"));
    }

    public final void update(byte by) throws SignatureException {
        if (((Signature)((Object)((Object)this))).state != 3 && ((Signature)((Object)((Object)this))).state != 2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SignatureException("object not initialized for signature or verification"));
        }
        this.engineUpdate(by);
    }

    public final void update(byte[] byArray) throws SignatureException {
        this.update(byArray, 0, byArray.length);
    }

    public final void update(byte[] byArray, int n2, int n3) throws SignatureException {
        if (((Signature)((Object)((Object)this))).state != 2 && ((Signature)((Object)((Object)this))).state != 3) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SignatureException("object not initialized for signature or verification"));
        }
        this.engineUpdate(byArray, n2, n3);
    }

    public final void update(ByteBuffer byteBuffer) throws SignatureException {
        if (((Signature)((Object)((Object)this))).state != 2 && ((Signature)((Object)((Object)this))).state != 3) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SignatureException("object not initialized for signature or verification"));
        }
        if (byteBuffer == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        this.engineUpdate(byteBuffer);
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public String toString() {
        String string = "";
        switch (((Signature)((Object)((Object)this))).state) {
            case 0: {
                string = "<not initialized>";
                break;
            }
            case 3: {
                string = "<initialized for verifying>";
                break;
            }
            case 2: {
                string = "<initialized for signing>";
            }
        }
        return "Signature object: " + this.getAlgorithm() + string;
    }

    @Deprecated
    public final void setParameter(String string, Object object) throws InvalidParameterException {
        this.engineSetParameter(string, object);
    }

    public final void setParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.engineSetParameter(algorithmParameterSpec);
    }

    public final AlgorithmParameters getParameters() {
        return this.engineGetParameters();
    }

    @Deprecated
    public final Object getParameter(String string) throws InvalidParameterException {
        return this.engineGetParameter(string);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (g.convertForInstanceOf((Object)((Object)this), Cloneable.class) instanceof Cloneable) {
            return super.clone();
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CloneNotSupportedException());
    }

    static {
        Boolean bl = Boolean.TRUE;
        signatureInfo.put("sun.security.provider.DSA$RawDSA", bl);
        signatureInfo.put("sun.security.provider.DSA$SHA1withDSA", bl);
        signatureInfo.put("sun.security.rsa.RSASignature$MD2withRSA", bl);
        signatureInfo.put("sun.security.rsa.RSASignature$MD5withRSA", bl);
        signatureInfo.put("sun.security.rsa.RSASignature$SHA1withRSA", bl);
        signatureInfo.put("sun.security.rsa.RSASignature$SHA256withRSA", bl);
        signatureInfo.put("sun.security.rsa.RSASignature$SHA384withRSA", bl);
        signatureInfo.put("sun.security.rsa.RSASignature$SHA512withRSA", bl);
        signatureInfo.put("com.sun.net.ssl.internal.ssl.RSASignature", bl);
        signatureInfo.put("sun.security.pkcs11.P11Signature", bl);
    }

    private static /* synthetic */ void _jr$ip$algorithm(Signature signature, String string) {
        signature.algorithm = string;
    }

    protected /* synthetic */ Signature(h h2) {
        super(h2);
    }

    private static class CipherAdapter
    extends SignatureSpi {
        private final Cipher cipher;
        private ByteArrayOutputStream data;

        CipherAdapter(Cipher cipher) {
            this.cipher = cipher;
        }

        @Override
        protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
            this.cipher.init(2, publicKey);
            if (this.data == null) {
                this.data = new ByteArrayOutputStream(128);
            } else {
                this.data.reset();
            }
        }

        @Override
        protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
            this.cipher.init(1, privateKey);
            this.data = null;
        }

        @Override
        protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
            this.cipher.init(1, (Key)privateKey, secureRandom);
            this.data = null;
        }

        @Override
        protected void engineUpdate(byte by) throws SignatureException {
            this.engineUpdate(new byte[]{by}, 0, 1);
        }

        @Override
        protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
            if (this.data != null) {
                this.data.write(byArray, n2, n3);
                return;
            }
            byte[] byArray2 = this.cipher.update(byArray, n2, n3);
            if (byArray2 != null && byArray2.length != 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SignatureException("Cipher unexpectedly returned data"));
            }
        }

        @Override
        protected byte[] engineSign() throws SignatureException {
            try {
                return this.cipher.doFinal();
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SignatureException("doFinal() failed", illegalBlockSizeException));
            }
            catch (BadPaddingException badPaddingException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SignatureException("doFinal() failed", badPaddingException));
            }
        }

        @Override
        protected boolean engineVerify(byte[] byArray) throws SignatureException {
            try {
                byte[] byArray2 = this.cipher.doFinal(byArray);
                byte[] byArray3 = this.data.toByteArray();
                this.data.reset();
                return Arrays.equals(byArray2, byArray3);
            }
            catch (BadPaddingException badPaddingException) {
                return false;
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SignatureException("doFinal() failed", illegalBlockSizeException));
            }
        }

        @Override
        protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidParameterException("Parameters not supported"));
        }

        @Override
        protected Object engineGetParameter(String string) throws InvalidParameterException {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidParameterException("Parameters not supported"));
        }

        private static /* synthetic */ void _jr$ip$cipher(CipherAdapter cipherAdapter, Cipher cipher) {
            cipherAdapter.cipher = cipher;
        }

        protected /* synthetic */ CipherAdapter(h h2) {
            super(h2);
        }
    }

    private static class Delegate
    extends Signature {
        private SignatureSpi sigSpi;
        private final Object lock;
        private Provider.Service firstService;
        private Iterator<Provider.Service> serviceIterator;
        private static int warnCount = 10;
        private static final int I_PUB = 1;
        private static final int I_PRIV = 2;
        private static final int I_PRIV_SR = 3;

        Delegate(SignatureSpi signatureSpi, String string) {
            super(string);
            this.sigSpi = signatureSpi;
            this.lock = null;
        }

        Delegate(Provider.Service service, Iterator<Provider.Service> iterator, String string) {
            super(string);
            this.firstService = service;
            this.serviceIterator = iterator;
            this.lock = new Object();
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            this.chooseFirstProvider();
            if (g.convertForInstanceOf((Object)((Object)this.sigSpi), Cloneable.class) instanceof Cloneable) {
                SignatureSpi signatureSpi = (SignatureSpi)((Object)g.convertForCast((Object)this.sigSpi.clone(), SignatureSpi.class));
                Delegate delegate = new Delegate(signatureSpi, ((Signature)this).algorithm);
                ((Signature)((Object)((Object)delegate))).provider = ((Signature)((Object)((Object)this))).provider;
                return delegate;
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CloneNotSupportedException());
        }

        private static SignatureSpi newInstance(Provider.Service service) throws NoSuchAlgorithmException {
            if (service.getType().equals("Cipher")) {
                try {
                    Cipher cipher = Cipher.getInstance(Signature.RSA_CIPHER, service.getProvider());
                    return new CipherAdapter(cipher);
                }
                catch (NoSuchPaddingException noSuchPaddingException) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchAlgorithmException(noSuchPaddingException));
                }
            }
            Object object = service.newInstance(null);
            if (!(g.convertForInstanceOf((Object)object, SignatureSpi.class) instanceof SignatureSpi)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchAlgorithmException("Not a SignatureSpi: " + x.getName(object.getClass())));
            }
            return (SignatureSpi)((Object)g.convertForCast((Object)object, SignatureSpi.class));
        }

        @Override
        void chooseFirstProvider() {
            if (this.sigSpi != null) {
                return;
            }
            Object object = ah.getMonitor((Object)this.lock);
            synchronized (object) {
                try {
                    h h2;
                    int n2;
                    if (this.sigSpi != null) {
                        return;
                    }
                    if (debug != null && (n2 = --warnCount) >= 0) {
                        debug.println("Signature.init() not first method called, disabling delayed provider selection");
                        if (n2 == 0) {
                            debug.println("Further warnings of this type will be suppressed");
                        }
                        new Exception("Call trace").printStackTrace();
                    }
                    NoSuchAlgorithmException noSuchAlgorithmException = null;
                    while (this.firstService != null || this.serviceIterator.hasNext()) {
                        if (this.firstService != null) {
                            h2 = this.firstService;
                            this.firstService = null;
                        } else {
                            h2 = (Provider.Service)((Object)g.convertForCast(this.serviceIterator.next(), Provider.Service.class));
                        }
                        if (!Signature.isSpi((Provider.Service)h2)) continue;
                        try {
                            this.sigSpi = Delegate.newInstance((Provider.Service)h2);
                            Delegate._jr$ip$provider((Object)this, h2.getProvider());
                            this.firstService = null;
                            this.serviceIterator = null;
                            return;
                        }
                        catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                            noSuchAlgorithmException = noSuchAlgorithmException2;
                        }
                    }
                    h2 = new ProviderException("Could not construct SignatureSpi instance");
                    if (noSuchAlgorithmException != null) {
                        h2.initCause(noSuchAlgorithmException);
                    }
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)h2);
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }

        private void chooseProvider(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
            Object object = ah.getMonitor((Object)this.lock);
            synchronized (object) {
                try {
                    Object object2;
                    if (this.sigSpi != null) {
                        this.init(this.sigSpi, n2, key, secureRandom);
                        return;
                    }
                    Exception exception = null;
                    while (this.firstService != null || this.serviceIterator.hasNext()) {
                        if (this.firstService != null) {
                            object2 = this.firstService;
                            this.firstService = null;
                        } else {
                            object2 = (Provider.Service)((Object)g.convertForCast(this.serviceIterator.next(), Provider.Service.class));
                        }
                        if (!((Provider.Service)((Object)object2)).supportsParameter(key) || !Signature.isSpi((Provider.Service)((Object)object2))) continue;
                        try {
                            SignatureSpi signatureSpi = Delegate.newInstance((Provider.Service)((Object)object2));
                            this.init(signatureSpi, n2, key, secureRandom);
                            Delegate._jr$ip$provider((Object)this, ((Provider.Service)((Object)object2)).getProvider());
                            this.sigSpi = signatureSpi;
                            this.firstService = null;
                            this.serviceIterator = null;
                            return;
                        }
                        catch (Exception exception2) {
                            if (exception != null) continue;
                            exception = exception2;
                        }
                    }
                    if (g.convertForInstanceOf(exception, InvalidKeyException.class) instanceof InvalidKeyException) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((InvalidKeyException)g.convertForCast(exception, InvalidKeyException.class)));
                    }
                    if (g.convertForInstanceOf(exception, RuntimeException.class) instanceof RuntimeException) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((RuntimeException)g.convertForCast(exception, RuntimeException.class)));
                    }
                    object2 = key != null ? x.getName(key.getClass()) : "(null)";
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("No installed provider supports this key: " + (String)object2, exception));
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }

        private void init(SignatureSpi signatureSpi, int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
            switch (n2) {
                case 1: {
                    signatureSpi.engineInitVerify((PublicKey)g.convertForCast((Object)key, PublicKey.class));
                    break;
                }
                case 2: {
                    signatureSpi.engineInitSign((PrivateKey)g.convertForCast((Object)key, PrivateKey.class));
                    break;
                }
                case 3: {
                    signatureSpi.engineInitSign((PrivateKey)g.convertForCast((Object)key, PrivateKey.class), secureRandom);
                    break;
                }
                default: {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError((Object)("Internal error: " + n2)));
                }
            }
        }

        @Override
        protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
            if (this.sigSpi != null) {
                this.sigSpi.engineInitVerify(publicKey);
            } else {
                this.chooseProvider(1, publicKey, null);
            }
        }

        @Override
        protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
            if (this.sigSpi != null) {
                this.sigSpi.engineInitSign(privateKey);
            } else {
                this.chooseProvider(2, privateKey, null);
            }
        }

        @Override
        protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
            if (this.sigSpi != null) {
                this.sigSpi.engineInitSign(privateKey, secureRandom);
            } else {
                this.chooseProvider(3, privateKey, secureRandom);
            }
        }

        @Override
        protected void engineUpdate(byte by) throws SignatureException {
            this.chooseFirstProvider();
            this.sigSpi.engineUpdate(by);
        }

        @Override
        protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
            this.chooseFirstProvider();
            this.sigSpi.engineUpdate(byArray, n2, n3);
        }

        @Override
        protected void engineUpdate(ByteBuffer byteBuffer) {
            this.chooseFirstProvider();
            this.sigSpi.engineUpdate(byteBuffer);
        }

        @Override
        protected byte[] engineSign() throws SignatureException {
            this.chooseFirstProvider();
            return this.sigSpi.engineSign();
        }

        @Override
        protected int engineSign(byte[] byArray, int n2, int n3) throws SignatureException {
            this.chooseFirstProvider();
            return this.sigSpi.engineSign(byArray, n2, n3);
        }

        @Override
        protected boolean engineVerify(byte[] byArray) throws SignatureException {
            this.chooseFirstProvider();
            return this.sigSpi.engineVerify(byArray);
        }

        @Override
        protected boolean engineVerify(byte[] byArray, int n2, int n3) throws SignatureException {
            this.chooseFirstProvider();
            return this.sigSpi.engineVerify(byArray, n2, n3);
        }

        @Override
        protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
            this.chooseFirstProvider();
            this.sigSpi.engineSetParameter(string, object);
        }

        @Override
        protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            this.chooseFirstProvider();
            this.sigSpi.engineSetParameter(algorithmParameterSpec);
        }

        @Override
        protected Object engineGetParameter(String string) throws InvalidParameterException {
            this.chooseFirstProvider();
            return this.sigSpi.engineGetParameter(string);
        }

        @Override
        protected AlgorithmParameters engineGetParameters() {
            this.chooseFirstProvider();
            return this.sigSpi.engineGetParameters();
        }

        private static /* synthetic */ void _jr$ip$lock(Delegate delegate, Object object) {
            delegate.lock = object;
        }

        protected /* synthetic */ Delegate(h h2) {
            super(h2);
        }
    }
}

