/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.ByteArrayInputStream;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Iterator;
import java.util.List;

public abstract class CertPath
extends h
implements Serializable {
    private static final long serialVersionUID = 6068470306649138683L;
    private String type;

    protected CertPath(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }

    public abstract Iterator<String> getEncodings();

    public boolean equals(Object object) {
        if (!f.ifAcmp((Object)this, (Object)object)) {
            return true;
        }
        if (!(g.convertForInstanceOf((Object)object, CertPath.class) instanceof CertPath)) {
            return false;
        }
        CertPath certPath = (CertPath)g.convertForCast((Object)object, CertPath.class);
        if (!certPath.getType().equals(this.type)) {
            return false;
        }
        List<? extends Certificate> list = this.getCertificates();
        List<? extends Certificate> list2 = certPath.getCertificates();
        return list.equals(list2);
    }

    public int hashCode() {
        int n2 = this.type.hashCode();
        n2 = 31 * n2 + this.getCertificates().hashCode();
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<? extends Certificate> iterator = this.getCertificates().iterator();
        stringBuffer.append("\n" + this.type + " Cert Path: length = " + this.getCertificates().size() + ".\n");
        stringBuffer.append("[\n");
        int n2 = 1;
        while (iterator.hasNext()) {
            stringBuffer.append("=========================================================Certificate " + n2 + " start.\n");
            Certificate certificate = (Certificate)g.convertForCast((Object)iterator.next(), Certificate.class);
            stringBuffer.append(certificate.toString());
            stringBuffer.append("\n=========================================================Certificate " + n2 + " end.\n\n\n");
            ++n2;
        }
        stringBuffer.append("\n]");
        return stringBuffer.toString();
    }

    public abstract byte[] getEncoded() throws CertificateEncodingException;

    public abstract byte[] getEncoded(String var1) throws CertificateEncodingException;

    public abstract List<? extends Certificate> getCertificates();

    protected Object writeReplace() throws ObjectStreamException {
        try {
            return new CertPathRep(this.type, this.getEncoded());
        }
        catch (CertificateException certificateException) {
            NotSerializableException notSerializableException = new NotSerializableException("java.security.cert.CertPath: " + this.type);
            notSerializableException.initCause(certificateException);
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)notSerializableException);
        }
    }

    private static /* synthetic */ void _jr$ip$type(CertPath certPath, String string) {
        certPath.type = string;
    }

    protected /* synthetic */ CertPath(h h2) {
        super(h2);
    }

    protected static class CertPathRep
    extends h
    implements Serializable {
        private static final long serialVersionUID = 3015633072427920915L;
        private String type;
        private byte[] data;

        protected CertPathRep(String string, byte[] byArray) {
            this.type = string;
            this.data = byArray;
        }

        protected Object readResolve() throws ObjectStreamException {
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance(this.type);
                return certificateFactory.generateCertPath(new ByteArrayInputStream(this.data));
            }
            catch (CertificateException certificateException) {
                NotSerializableException notSerializableException = new NotSerializableException("java.security.cert.CertPath: " + this.type);
                notSerializableException.initCause(certificateException);
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)notSerializableException);
            }
        }

        private static /* synthetic */ void _jr$ip$type(CertPathRep certPathRep, String string) {
            certPathRep.type = string;
        }

        private static /* synthetic */ void _jr$ip$data(CertPathRep certPathRep, byte[] byArray) {
            certPathRep.data = byArray;
        }

        protected /* synthetic */ CertPathRep(h h2) {
            super(h2);
        }
    }
}

