/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.ByteArrayInputStream;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import sun.security.x509.X509CertImpl;

public abstract class Certificate
extends h
implements Serializable {
    private static final long serialVersionUID = -3585440601605666277L;
    private final String type;

    protected Certificate(String string) {
        this.type = string;
    }

    public final String getType() {
        return this.type;
    }

    public boolean equals(Object object) {
        if (!f.ifAcmp((Object)this, (Object)object)) {
            return true;
        }
        if (!(g.convertForInstanceOf((Object)object, Certificate.class) instanceof Certificate)) {
            return false;
        }
        try {
            byte[] byArray = X509CertImpl.getEncodedInternal(this);
            byte[] byArray2 = X509CertImpl.getEncodedInternal((Certificate)g.convertForCast((Object)object, Certificate.class));
            return Arrays.equals(byArray, byArray2);
        }
        catch (CertificateException certificateException) {
            return false;
        }
    }

    public int hashCode() {
        int n2 = 0;
        try {
            byte[] byArray = X509CertImpl.getEncodedInternal(this);
            for (int i = 1; i < byArray.length; ++i) {
                n2 += byArray[i] * i;
            }
            return n2;
        }
        catch (CertificateException certificateException) {
            return n2;
        }
    }

    public abstract byte[] getEncoded() throws CertificateEncodingException;

    public abstract void verify(PublicKey var1) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract void verify(PublicKey var1, String var2) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract String toString();

    public abstract PublicKey getPublicKey();

    protected Object writeReplace() throws ObjectStreamException {
        try {
            return new CertificateRep(this.type, this.getEncoded());
        }
        catch (CertificateException certificateException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NotSerializableException("java.security.cert.Certificate: " + this.type + ": " + certificateException.getMessage()));
        }
    }

    private static /* synthetic */ void _jr$ip$type(Certificate certificate, String string) {
        certificate.type = string;
    }

    protected /* synthetic */ Certificate(h h2) {
        super(h2);
    }

    protected static class CertificateRep
    extends h
    implements Serializable {
        private static final long serialVersionUID = -8563758940495660020L;
        private String type;
        private byte[] data;

        protected CertificateRep(String string, byte[] byArray) {
            this.type = string;
            this.data = byArray;
        }

        protected Object readResolve() throws ObjectStreamException {
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance(this.type);
                return certificateFactory.generateCertificate(new ByteArrayInputStream(this.data));
            }
            catch (CertificateException certificateException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NotSerializableException("java.security.cert.Certificate: " + this.type + ": " + certificateException.getMessage()));
            }
        }

        private static /* synthetic */ void _jr$ip$type(CertificateRep certificateRep, String string) {
            certificateRep.type = string;
        }

        private static /* synthetic */ void _jr$ip$data(CertificateRep certificateRep, byte[] byArray) {
            certificateRep.data = byArray;
        }

        protected /* synthetic */ CertificateRep(h h2) {
            super(h2);
        }
    }
}

