/*
 * Decompiled with CFR 0.152.
 */
package java.security.spec;

import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.math.BigInteger;
import java.security.spec.ECField;
import java.util.Arrays;

public class ECFieldF2m
extends h
implements ECField {
    private int m;
    private int[] ks;
    private BigInteger rp;

    public ECFieldF2m(int n) {
        if (n <= 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("m is not positive"));
        }
        this.m = n;
        this.ks = null;
        this.rp = null;
    }

    public ECFieldF2m(int n, BigInteger bigInteger) {
        this.m = n;
        this.rp = bigInteger;
        if (n <= 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("m is not positive"));
        }
        int n2 = this.rp.bitCount();
        if (!this.rp.testBit(0) || !this.rp.testBit(n) || n2 != 3 && n2 != 5) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("rp does not represent a valid reduction polynomial"));
        }
        BigInteger bigInteger2 = this.rp.clearBit(0).clearBit(n);
        this.ks = new int[n2 - 2];
        for (int i = this.ks.length - 1; i >= 0; --i) {
            int n3;
            this.ks[i] = n3 = bigInteger2.getLowestSetBit();
            bigInteger2 = bigInteger2.clearBit(n3);
        }
    }

    public ECFieldF2m(int n, int[] nArray) {
        int n2;
        this.m = n;
        this.ks = (int[])nArray.clone();
        if (n <= 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("m is not positive"));
        }
        if (this.ks.length != 1 && this.ks.length != 3) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("length of ks is neither 1 nor 3"));
        }
        for (n2 = 0; n2 < this.ks.length; ++n2) {
            if (this.ks[n2] < 1 || this.ks[n2] > n - 1) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("ks[" + n2 + "] is out of range"));
            }
            if (n2 == 0 || this.ks[n2] < this.ks[n2 - 1]) continue;
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("values in ks are not in descending order"));
        }
        this.rp = BigInteger.ONE;
        this.rp = this.rp.setBit(n);
        for (n2 = 0; n2 < this.ks.length; ++n2) {
            this.rp = this.rp.setBit(this.ks[n2]);
        }
    }

    @Override
    public int getFieldSize() {
        return this.m;
    }

    public int getM() {
        return this.m;
    }

    public BigInteger getReductionPolynomial() {
        return this.rp;
    }

    public int[] getMidTermsOfReductionPolynomial() {
        if (this.ks == null) {
            return null;
        }
        return (int[])this.ks.clone();
    }

    public boolean equals(Object object) {
        if (!f.ifAcmp((Object)this, (Object)object)) {
            return true;
        }
        if (g.convertForInstanceOf((Object)object, ECFieldF2m.class) instanceof ECFieldF2m) {
            return this.m == ((ECFieldF2m)g.convertForCast((Object)object, ECFieldF2m.class)).m && Arrays.equals(this.ks, ((ECFieldF2m)g.convertForCast((Object)object, ECFieldF2m.class)).ks);
        }
        return false;
    }

    public int hashCode() {
        int n = this.m << 5;
        return n += this.rp == null ? 0 : this.rp.hashCode();
    }

    private static /* synthetic */ void _jr$ip$m(ECFieldF2m eCFieldF2m, int n) {
        eCFieldF2m.m = n;
    }

    private static /* synthetic */ void _jr$ip$ks(ECFieldF2m eCFieldF2m, int[] nArray) {
        eCFieldF2m.ks = nArray;
    }

    private static /* synthetic */ void _jr$ip$rp(ECFieldF2m eCFieldF2m, BigInteger bigInteger) {
        eCFieldF2m.rp = bigInteger;
    }

    protected /* synthetic */ ECFieldF2m(h h2) {
        super(h2);
    }
}

