/*
 * Decompiled with CFR 0.152.
 */
package java.security.spec;

import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.math.BigInteger;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;

public class EllipticCurve
extends h {
    private final ECField field;
    private final BigInteger a;
    private final BigInteger b;
    private final byte[] seed;

    private static void checkValidity(ECField eCField, BigInteger bigInteger, String string) {
        if (g.convertForInstanceOf((Object)eCField, ECFieldFp.class) instanceof ECFieldFp) {
            BigInteger bigInteger2 = ((ECFieldFp)g.convertForCast((Object)eCField, ECFieldFp.class)).getP();
            if (bigInteger2.compareTo(bigInteger) != 1) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException(string + " is too large"));
            }
            if (bigInteger.signum() < 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException(string + " is negative"));
            }
        } else if (g.convertForInstanceOf((Object)eCField, ECFieldF2m.class) instanceof ECFieldF2m) {
            int n2 = ((ECFieldF2m)g.convertForCast((Object)eCField, ECFieldF2m.class)).getM();
            if (bigInteger.bitLength() > n2) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException(string + " is too large"));
            }
        }
    }

    public EllipticCurve(ECField eCField, BigInteger bigInteger, BigInteger bigInteger2) {
        this(eCField, bigInteger, bigInteger2, null);
    }

    public EllipticCurve(ECField eCField, BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray) {
        if (eCField == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("field is null"));
        }
        if (bigInteger == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("first coefficient is null"));
        }
        if (bigInteger2 == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("second coefficient is null"));
        }
        EllipticCurve.checkValidity(eCField, bigInteger, "first coefficient");
        EllipticCurve.checkValidity(eCField, bigInteger2, "second coefficient");
        this.field = eCField;
        this.a = bigInteger;
        this.b = bigInteger2;
        this.seed = (byte[])(byArray != null ? (byte[])byArray.clone() : null);
    }

    public ECField getField() {
        return this.field;
    }

    public BigInteger getA() {
        return this.a;
    }

    public BigInteger getB() {
        return this.b;
    }

    public byte[] getSeed() {
        if (this.seed == null) {
            return null;
        }
        return (byte[])this.seed.clone();
    }

    public boolean equals(Object object) {
        if (!f.ifAcmp((Object)((Object)this), (Object)object)) {
            return true;
        }
        if (g.convertForInstanceOf((Object)object, EllipticCurve.class) instanceof EllipticCurve) {
            EllipticCurve ellipticCurve = (EllipticCurve)((Object)g.convertForCast((Object)object, EllipticCurve.class));
            if (this.field.equals(ellipticCurve.field) && this.a.equals(ellipticCurve.a) && this.b.equals(ellipticCurve.b)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.field.hashCode() << 6 + (this.a.hashCode() << 4) + (this.b.hashCode() << 2);
    }

    private static /* synthetic */ void _jr$ip$field(EllipticCurve ellipticCurve, ECField eCField) {
        ellipticCurve.field = eCField;
    }

    private static /* synthetic */ void _jr$ip$a(EllipticCurve ellipticCurve, BigInteger bigInteger) {
        ellipticCurve.a = bigInteger;
    }

    private static /* synthetic */ void _jr$ip$b(EllipticCurve ellipticCurve, BigInteger bigInteger) {
        ellipticCurve.b = bigInteger;
    }

    private static /* synthetic */ void _jr$ip$seed(EllipticCurve ellipticCurve, byte[] byArray) {
        ellipticCurve.seed = byArray;
    }

    protected /* synthetic */ EllipticCurve(h h2) {
        super(h2);
    }
}

