/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.text.CollationKey;
import java.text.CollationRules;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.text.spi.CollatorProvider;
import java.util.Comparator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import sun.misc.SoftCache;
import sun.util.LocaleServiceProviderPool;
import sun.util.resources.LocaleData;

/*
 * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
 */
public abstract class Collator
extends h
implements Comparator,
Cloneable {
    public static final int PRIMARY = 0;
    public static final int SECONDARY = 1;
    public static final int TERTIARY = 2;
    public static final int IDENTICAL = 3;
    public static final int NO_DECOMPOSITION = 0;
    public static final int CANONICAL_DECOMPOSITION = 1;
    public static final int FULL_DECOMPOSITION = 2;
    private int strength;
    private int decmp;
    private static SoftCache cache = new SoftCache();
    static final int LESS = -1;
    static final int EQUAL = 0;
    static final int GREATER = 1;

    public static synchronized Collator getInstance() {
        return Collator.getInstance(Locale.getDefault());
    }

    public static synchronized Collator getInstance(Locale locale) {
        Object object;
        Collator collator = (Collator)g.convertForCast((Object)cache.get((Object)locale), Collator.class);
        if (collator != null) {
            return (Collator)g.convertForCast((Object)collator.clone(), Collator.class);
        }
        LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(CollatorProvider.class);
        if (localeServiceProviderPool.hasProviders()) {
            CollatorGetter collatorGetter = CollatorGetter.INSTANCE;
            Object[] objectArray = new Object[1];
            a.arrayStore((Object[])objectArray, (int)0, (Object)locale);
            object = (Collator)g.convertForCast(localeServiceProviderPool.getLocalizedObject(collatorGetter, locale, objectArray), Collator.class);
            if (object != null) {
                return object;
            }
        }
        object = "";
        try {
            ResourceBundle resourceBundle = LocaleData.getCollationData(locale);
            object = resourceBundle.getString("Rule");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            collator = new RuleBasedCollator(CollationRules.DEFAULTRULES + (String)object, 1);
        }
        catch (ParseException parseException) {
            try {
                collator = new RuleBasedCollator(CollationRules.DEFAULTRULES);
            }
            catch (ParseException parseException2) {
                // empty catch block
            }
        }
        collator.setDecomposition(0);
        cache.put((Object)locale, (Object)collator);
        return (Collator)g.convertForCast((Object)collator.clone(), Collator.class);
    }

    public abstract int compare(String var1, String var2);

    public int compare(Object object, Object object2) {
        return this.compare((String)object, (String)object2);
    }

    public abstract CollationKey getCollationKey(String var1);

    public boolean equals(String string, String string2) {
        return this.compare(string, string2) == 0;
    }

    @af(modifiers=33)
    public int getStrength() {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                return this.strength;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @af(modifiers=33)
    public void setStrength(int n2) {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (n2 != 0 && n2 != 1 && n2 != 2 && n2 != 3) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Incorrect comparison level."));
                }
                this.strength = n2;
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @af(modifiers=33)
    public int getDecomposition() {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                return this.decmp;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @af(modifiers=33)
    public void setDecomposition(int n2) {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (n2 != 0 && n2 != 1 && n2 != 2) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Wrong decomposition mode."));
                }
                this.decmp = n2;
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public static synchronized Locale[] getAvailableLocales() {
        LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(CollatorProvider.class);
        return localeServiceProviderPool.getAvailableLocales();
    }

    public Object clone() {
        try {
            return (Collator)g.convertForCast((Object)super.clone(), Collator.class);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!f.ifAcmp((Object)this, (Object)object)) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (f.ifAcmp(this.getClass(), object.getClass())) {
            return false;
        }
        Collator collator = (Collator)g.convertForCast((Object)object, Collator.class);
        return this.strength == collator.strength && this.decmp == collator.decmp;
    }

    public abstract int hashCode();

    protected Collator() {
        this.strength = 0;
        this.decmp = 0;
        this.strength = 2;
        this.decmp = 1;
    }

    protected /* synthetic */ Collator(h h2) {
        super(h2);
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    private static class CollatorGetter
    extends h
    implements LocaleServiceProviderPool.LocalizedObjectGetter {
        private static final CollatorGetter INSTANCE = new CollatorGetter();

        private CollatorGetter() {
        }

        public Collator getObject(CollatorProvider collatorProvider, Locale locale, String string, Object ... objectArray) {
            if (!$assertionsDisabled && a.arrayLength((Object[])objectArray) != 1) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            Collator collator = collatorProvider.getInstance(locale);
            if (collator != null) {
                cache.put((Object)((Locale)a.arrayLoad((Object[])objectArray, (int)0)), (Object)collator);
                cache.put((Object)locale, (Object)collator);
                return (Collator)g.convertForCast((Object)collator.clone(), Collator.class);
            }
            return null;
        }

        protected /* synthetic */ CollatorGetter(h h2) {
            super(h2);
        }
    }
}

