/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.InvalidObjectException;
import java.text.DontCareFieldPosition;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.text.spi.DateFormatProvider;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.TimeZone;
import sun.util.LocaleServiceProviderPool;

public abstract class DateFormat
extends Format {
    protected Calendar calendar;
    protected NumberFormat numberFormat;
    public static final int ERA_FIELD = 0;
    public static final int YEAR_FIELD = 1;
    public static final int MONTH_FIELD = 2;
    public static final int DATE_FIELD = 3;
    public static final int HOUR_OF_DAY1_FIELD = 4;
    public static final int HOUR_OF_DAY0_FIELD = 5;
    public static final int MINUTE_FIELD = 6;
    public static final int SECOND_FIELD = 7;
    public static final int MILLISECOND_FIELD = 8;
    public static final int DAY_OF_WEEK_FIELD = 9;
    public static final int DAY_OF_YEAR_FIELD = 10;
    public static final int DAY_OF_WEEK_IN_MONTH_FIELD = 11;
    public static final int WEEK_OF_YEAR_FIELD = 12;
    public static final int WEEK_OF_MONTH_FIELD = 13;
    public static final int AM_PM_FIELD = 14;
    public static final int HOUR1_FIELD = 15;
    public static final int HOUR0_FIELD = 16;
    public static final int TIMEZONE_FIELD = 17;
    private static final long serialVersionUID = 7218322306649953788L;
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    public static final int DEFAULT = 2;

    @Override
    public final StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (g.convertForInstanceOf((Object)object, Date.class) instanceof Date) {
            return this.format((Date)g.convertForCast((Object)object, Date.class), stringBuffer, fieldPosition);
        }
        if (g.convertForInstanceOf((Object)object, Number.class) instanceof Number) {
            return this.format(new Date(((Number)g.convertForCast((Object)object, Number.class)).longValue()), stringBuffer, fieldPosition);
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Cannot format given Object as a Date"));
    }

    public abstract StringBuffer format(Date var1, StringBuffer var2, FieldPosition var3);

    public final String format(Date date) {
        return this.format(date, new StringBuffer(), DontCareFieldPosition.INSTANCE).toString();
    }

    public Date parse(String string) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = this.parse(string, parsePosition);
        if (ParsePosition._jr$ig$index((Object)parsePosition) == 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ParseException("Unparseable date: \"" + string + "\"", ParsePosition._jr$ig$errorIndex((Object)parsePosition)));
        }
        return date;
    }

    public abstract Date parse(String var1, ParsePosition var2);

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition);
    }

    public static final DateFormat getTimeInstance() {
        return DateFormat.get(2, 0, 1, Locale.getDefault(Locale.Category.FORMAT));
    }

    public static final DateFormat getTimeInstance(int n2) {
        return DateFormat.get(n2, 0, 1, Locale.getDefault(Locale.Category.FORMAT));
    }

    public static final DateFormat getTimeInstance(int n2, Locale locale) {
        return DateFormat.get(n2, 0, 1, locale);
    }

    public static final DateFormat getDateInstance() {
        return DateFormat.get(0, 2, 2, Locale.getDefault(Locale.Category.FORMAT));
    }

    public static final DateFormat getDateInstance(int n2) {
        return DateFormat.get(0, n2, 2, Locale.getDefault(Locale.Category.FORMAT));
    }

    public static final DateFormat getDateInstance(int n2, Locale locale) {
        return DateFormat.get(0, n2, 2, locale);
    }

    public static final DateFormat getDateTimeInstance() {
        return DateFormat.get(2, 2, 3, Locale.getDefault(Locale.Category.FORMAT));
    }

    public static final DateFormat getDateTimeInstance(int n2, int n3) {
        return DateFormat.get(n3, n2, 3, Locale.getDefault(Locale.Category.FORMAT));
    }

    public static final DateFormat getDateTimeInstance(int n2, int n3, Locale locale) {
        return DateFormat.get(n3, n2, 3, locale);
    }

    public static final DateFormat getInstance() {
        return DateFormat.getDateTimeInstance(3, 3);
    }

    public static Locale[] getAvailableLocales() {
        LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(DateFormatProvider.class);
        return localeServiceProviderPool.getAvailableLocales();
    }

    public void setCalendar(Calendar calendar) {
        ((DateFormat)this).calendar = calendar;
    }

    public Calendar getCalendar() {
        return ((DateFormat)this).calendar;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        ((DateFormat)this).numberFormat = numberFormat;
    }

    public NumberFormat getNumberFormat() {
        return ((DateFormat)this).numberFormat;
    }

    public void setTimeZone(TimeZone timeZone) {
        ((DateFormat)this).calendar.setTimeZone(timeZone);
    }

    public TimeZone getTimeZone() {
        return ((DateFormat)this).calendar.getTimeZone();
    }

    public void setLenient(boolean bl) {
        ((DateFormat)this).calendar.setLenient(bl);
    }

    public boolean isLenient() {
        return ((DateFormat)this).calendar.isLenient();
    }

    public int hashCode() {
        return ((DateFormat)this).numberFormat.hashCode();
    }

    public boolean equals(Object object) {
        if (!f.ifAcmp((Object)this, (Object)object)) {
            return true;
        }
        if (object == null || f.ifAcmp(this.getClass(), object.getClass())) {
            return false;
        }
        DateFormat dateFormat = (DateFormat)g.convertForCast((Object)object, DateFormat.class);
        return ((DateFormat)this).calendar.getFirstDayOfWeek() == ((DateFormat)dateFormat).calendar.getFirstDayOfWeek() && ((DateFormat)this).calendar.getMinimalDaysInFirstWeek() == ((DateFormat)dateFormat).calendar.getMinimalDaysInFirstWeek() && ((DateFormat)this).calendar.isLenient() == ((DateFormat)dateFormat).calendar.isLenient() && ((DateFormat)this).calendar.getTimeZone().equals(((DateFormat)dateFormat).calendar.getTimeZone()) && ((DateFormat)this).numberFormat.equals(((DateFormat)dateFormat).numberFormat);
    }

    @Override
    public Object clone() {
        DateFormat dateFormat = (DateFormat)g.convertForCast((Object)super.clone(), DateFormat.class);
        ((DateFormat)dateFormat).calendar = (Calendar)g.convertForCast((Object)((DateFormat)this).calendar.clone(), Calendar.class);
        ((DateFormat)dateFormat).numberFormat = (NumberFormat)g.convertForCast((Object)((DateFormat)this).numberFormat.clone(), NumberFormat.class);
        return dateFormat;
    }

    private static DateFormat get(int n2, int n3, int n4, Locale locale) {
        if ((n4 & 1) != 0) {
            if (n2 < 0 || n2 > 3) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Illegal time style " + n2));
            }
        } else {
            n2 = -1;
        }
        if ((n4 & 2) != 0) {
            if (n3 < 0 || n3 > 3) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Illegal date style " + n3));
            }
        } else {
            n3 = -1;
        }
        try {
            LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(DateFormatProvider.class);
            if (localeServiceProviderPool.hasProviders()) {
                DateFormatGetter dateFormatGetter = DateFormatGetter.INSTANCE;
                Object[] objectArray = new Object[3];
                a.arrayStore((Object[])objectArray, (int)0, (Object)n2);
                a.arrayStore((Object[])objectArray, (int)1, (Object)n3);
                a.arrayStore((Object[])objectArray, (int)2, (Object)n4);
                DateFormat dateFormat = (DateFormat)g.convertForCast(localeServiceProviderPool.getLocalizedObject(dateFormatGetter, locale, objectArray), DateFormat.class);
                if (dateFormat != null) {
                    return dateFormat;
                }
            }
            return new SimpleDateFormat(n2, n3, locale);
        }
        catch (MissingResourceException missingResourceException) {
            return new SimpleDateFormat("M/d/yy h:mm a");
        }
    }

    protected DateFormat() {
    }

    protected /* synthetic */ DateFormat(h h2) {
        super(h2);
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    private static class DateFormatGetter
    extends h
    implements LocaleServiceProviderPool.LocalizedObjectGetter {
        private static final DateFormatGetter INSTANCE = new DateFormatGetter();

        private DateFormatGetter() {
        }

        public DateFormat getObject(DateFormatProvider dateFormatProvider, Locale locale, String string, Object ... objectArray) {
            if (!$assertionsDisabled && a.arrayLength((Object[])objectArray) != 3) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            int n2 = (Integer)a.arrayLoad((Object[])objectArray, (int)0);
            int n3 = (Integer)a.arrayLoad((Object[])objectArray, (int)1);
            int n4 = (Integer)a.arrayLoad((Object[])objectArray, (int)2);
            switch (n4) {
                case 1: {
                    return dateFormatProvider.getTimeInstance(n2, locale);
                }
                case 2: {
                    return dateFormatProvider.getDateInstance(n3, locale);
                }
                case 3: {
                    return dateFormatProvider.getDateTimeInstance(n3, n2, locale);
                }
            }
            if (!$assertionsDisabled) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError((Object)"should not happen"));
            }
            return null;
        }

        protected /* synthetic */ DateFormatGetter(h h2) {
            super(h2);
        }
    }

    public static class Field
    extends Format.Field {
        private static final long serialVersionUID = 7441350119349544720L;
        private static final Map instanceMap = new HashMap(18);
        private static final Field[] calendarToFieldMapping = new Field[17];
        private int calendarField;
        public static final Field ERA = new Field("era", 0);
        public static final Field YEAR = new Field("year", 1);
        public static final Field MONTH = new Field("month", 2);
        public static final Field DAY_OF_MONTH = new Field("day of month", 5);
        public static final Field HOUR_OF_DAY1 = new Field("hour of day 1", -1);
        public static final Field HOUR_OF_DAY0 = new Field("hour of day", 11);
        public static final Field MINUTE = new Field("minute", 12);
        public static final Field SECOND = new Field("second", 13);
        public static final Field MILLISECOND = new Field("millisecond", 14);
        public static final Field DAY_OF_WEEK = new Field("day of week", 7);
        public static final Field DAY_OF_YEAR = new Field("day of year", 6);
        public static final Field DAY_OF_WEEK_IN_MONTH = new Field("day of week in month", 8);
        public static final Field WEEK_OF_YEAR = new Field("week of year", 3);
        public static final Field WEEK_OF_MONTH = new Field("week of month", 4);
        public static final Field AM_PM = new Field("am pm", 9);
        public static final Field HOUR1 = new Field("hour 1", -1);
        public static final Field HOUR0 = new Field("hour", 10);
        public static final Field TIME_ZONE = new Field("time zone", -1);

        public static Field ofCalendarField(int n2) {
            if (n2 < 0 || n2 >= a.arrayLength((Object[])calendarToFieldMapping)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Unknown Calendar constant " + n2));
            }
            return (Field)g.convertForCast((Object)a.arrayLoad((Object[])calendarToFieldMapping, (int)n2), Field.class);
        }

        protected Field(String string, int n2) {
            super(string);
            this.calendarField = n2;
            if (!f.ifAcmp(this.getClass(), Field.class)) {
                instanceMap.put(string, this);
                if (n2 >= 0) {
                    a.arrayStore((Object[])calendarToFieldMapping, (int)n2, (Object)this);
                }
            }
        }

        public int getCalendarField() {
            return this.calendarField;
        }

        @Override
        protected Object readResolve() throws InvalidObjectException {
            if (f.ifAcmp(this.getClass(), Field.class)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidObjectException("subclass didn't correctly implement readResolve"));
            }
            Object v = instanceMap.get(this.getName());
            if (v != null) {
                return v;
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidObjectException("unknown attribute name"));
        }

        private static /* synthetic */ void _jr$ip$calendarField(Field field, int n2) {
            field.calendarField = n2;
        }

        protected /* synthetic */ Field(h h2) {
            super(h2);
        }
    }
}

