/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIteratorFieldDelegate;
import java.text.DecimalFormatSymbols;
import java.text.DigitList;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Currency;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import sun.util.resources.LocaleData;

public class DecimalFormat
extends NumberFormat {
    private transient BigInteger bigIntegerMultiplier;
    private transient BigDecimal bigDecimalMultiplier;
    private static final int STATUS_INFINITE = 0;
    private static final int STATUS_POSITIVE = 1;
    private static final int STATUS_LENGTH = 2;
    private transient DigitList digitList;
    private String positivePrefix;
    private String positiveSuffix;
    private String negativePrefix;
    private String negativeSuffix;
    private String posPrefixPattern;
    private String posSuffixPattern;
    private String negPrefixPattern;
    private String negSuffixPattern;
    private int multiplier;
    private byte groupingSize;
    private boolean decimalSeparatorAlwaysShown;
    private boolean parseBigDecimal;
    private transient boolean isCurrencyFormat;
    private DecimalFormatSymbols symbols;
    private boolean useExponentialNotation;
    private transient FieldPosition[] positivePrefixFieldPositions;
    private transient FieldPosition[] positiveSuffixFieldPositions;
    private transient FieldPosition[] negativePrefixFieldPositions;
    private transient FieldPosition[] negativeSuffixFieldPositions;
    private byte minExponentDigits;
    private int maximumIntegerDigits;
    private int minimumIntegerDigits;
    private int maximumFractionDigits;
    private int minimumFractionDigits;
    private RoundingMode roundingMode;
    static final int currentSerialVersion = 4;
    private int serialVersionOnStream;
    private static final char PATTERN_ZERO_DIGIT = '0';
    private static final char PATTERN_GROUPING_SEPARATOR = ',';
    private static final char PATTERN_DECIMAL_SEPARATOR = '.';
    private static final char PATTERN_PER_MILLE = '\u2030';
    private static final char PATTERN_PERCENT = '%';
    private static final char PATTERN_DIGIT = '#';
    private static final char PATTERN_SEPARATOR = ';';
    private static final String PATTERN_EXPONENT = "E";
    private static final char PATTERN_MINUS = '-';
    private static final char CURRENCY_SIGN = '\u00a4';
    private static final char QUOTE = '\'';
    private static FieldPosition[] EmptyFieldPositionArray = new FieldPosition[0];
    static final int DOUBLE_INTEGER_DIGITS = 309;
    static final int DOUBLE_FRACTION_DIGITS = 340;
    static final int MAXIMUM_INTEGER_DIGITS = Integer.MAX_VALUE;
    static final int MAXIMUM_FRACTION_DIGITS = Integer.MAX_VALUE;
    static final long serialVersionUID = 864413376551465018L;
    private static final ConcurrentMap<Locale, String> cachedLocaleData = new ConcurrentHashMap<Locale, String>(3);

    public DecimalFormat() {
        this.digitList = new DigitList();
        this.positivePrefix = "";
        this.positiveSuffix = "";
        this.negativePrefix = "-";
        this.negativeSuffix = "";
        this.multiplier = 1;
        this.groupingSize = (byte)3;
        this.decimalSeparatorAlwaysShown = false;
        this.parseBigDecimal = false;
        this.isCurrencyFormat = false;
        this.symbols = null;
        this.maximumIntegerDigits = super.getMaximumIntegerDigits();
        this.minimumIntegerDigits = super.getMinimumIntegerDigits();
        this.maximumFractionDigits = super.getMaximumFractionDigits();
        this.minimumFractionDigits = super.getMinimumFractionDigits();
        this.roundingMode = RoundingMode.HALF_EVEN;
        this.serialVersionOnStream = 4;
        Locale locale = Locale.getDefault(Locale.Category.FORMAT);
        String string = (String)cachedLocaleData.get(locale);
        if (string == null) {
            ResourceBundle resourceBundle = LocaleData.getNumberFormatData(locale);
            Object[] objectArray = resourceBundle.getStringArray("NumberPatterns");
            string = (String)a.arrayLoad((Object[])objectArray, (int)0);
            cachedLocaleData.putIfAbsent(locale, string);
        }
        this.symbols = new DecimalFormatSymbols(locale);
        this.applyPattern(string, false);
    }

    public DecimalFormat(String string) {
        this.digitList = new DigitList();
        this.positivePrefix = "";
        this.positiveSuffix = "";
        this.negativePrefix = "-";
        this.negativeSuffix = "";
        this.multiplier = 1;
        this.groupingSize = (byte)3;
        this.decimalSeparatorAlwaysShown = false;
        this.parseBigDecimal = false;
        this.isCurrencyFormat = false;
        this.symbols = null;
        this.maximumIntegerDigits = super.getMaximumIntegerDigits();
        this.minimumIntegerDigits = super.getMinimumIntegerDigits();
        this.maximumFractionDigits = super.getMaximumFractionDigits();
        this.minimumFractionDigits = super.getMinimumFractionDigits();
        this.roundingMode = RoundingMode.HALF_EVEN;
        this.serialVersionOnStream = 4;
        this.symbols = new DecimalFormatSymbols(Locale.getDefault(Locale.Category.FORMAT));
        this.applyPattern(string, false);
    }

    public DecimalFormat(String string, DecimalFormatSymbols decimalFormatSymbols) {
        this.digitList = new DigitList();
        this.positivePrefix = "";
        this.positiveSuffix = "";
        this.negativePrefix = "-";
        this.negativeSuffix = "";
        this.multiplier = 1;
        this.groupingSize = (byte)3;
        this.decimalSeparatorAlwaysShown = false;
        this.parseBigDecimal = false;
        this.isCurrencyFormat = false;
        this.symbols = null;
        this.maximumIntegerDigits = super.getMaximumIntegerDigits();
        this.minimumIntegerDigits = super.getMinimumIntegerDigits();
        this.maximumFractionDigits = super.getMaximumFractionDigits();
        this.minimumFractionDigits = super.getMinimumFractionDigits();
        this.roundingMode = RoundingMode.HALF_EVEN;
        this.serialVersionOnStream = 4;
        this.symbols = (DecimalFormatSymbols)g.convertForCast((Object)decimalFormatSymbols.clone(), DecimalFormatSymbols.class);
        this.applyPattern(string, false);
    }

    @Override
    public final StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (g.convertForInstanceOf((Object)object, Long.class) instanceof Long || object instanceof Integer || g.convertForInstanceOf((Object)object, Short.class) instanceof Short || object instanceof Byte || g.convertForInstanceOf((Object)object, AtomicInteger.class) instanceof AtomicInteger || g.convertForInstanceOf((Object)object, AtomicLong.class) instanceof AtomicLong || g.convertForInstanceOf((Object)object, BigInteger.class) instanceof BigInteger && ((BigInteger)g.convertForCast((Object)object, BigInteger.class)).bitLength() < 64) {
            return this.format(((Number)g.convertForCast((Object)object, Number.class)).longValue(), stringBuffer, fieldPosition);
        }
        if (g.convertForInstanceOf((Object)object, BigDecimal.class) instanceof BigDecimal) {
            return this.format((BigDecimal)g.convertForCast((Object)object, BigDecimal.class), stringBuffer, fieldPosition);
        }
        if (g.convertForInstanceOf((Object)object, BigInteger.class) instanceof BigInteger) {
            return this.format((BigInteger)g.convertForCast((Object)object, BigInteger.class), stringBuffer, fieldPosition);
        }
        if (g.convertForInstanceOf((Object)object, Number.class) instanceof Number) {
            return this.format(((Number)g.convertForCast((Object)object, Number.class)).doubleValue(), stringBuffer, fieldPosition);
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Cannot format given Object as a Number"));
    }

    @Override
    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        return this.format(d, stringBuffer, fieldPosition.getFieldDelegate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer format(double d, StringBuffer stringBuffer, Format.FieldDelegate fieldDelegate) {
        if (Double.isNaN(d) || Double.isInfinite(d) && this.multiplier == 0) {
            int n2 = stringBuffer.length();
            stringBuffer.append(this.symbols.getNaN());
            fieldDelegate.formatted(0, NumberFormat.Field.INTEGER, NumberFormat.Field.INTEGER, n2, stringBuffer.length(), stringBuffer);
            return stringBuffer;
        }
        boolean bl = (d < 0.0 || d == 0.0 && 1.0 / d < 0.0) ^ this.multiplier < 0;
        if (this.multiplier != 1) {
            d *= (double)this.multiplier;
        }
        if (Double.isInfinite(d)) {
            if (bl) {
                this.append(stringBuffer, this.negativePrefix, fieldDelegate, this.getNegativePrefixFieldPositions(), NumberFormat.Field.SIGN);
            } else {
                this.append(stringBuffer, this.positivePrefix, fieldDelegate, this.getPositivePrefixFieldPositions(), NumberFormat.Field.SIGN);
            }
            int n3 = stringBuffer.length();
            stringBuffer.append(this.symbols.getInfinity());
            fieldDelegate.formatted(0, NumberFormat.Field.INTEGER, NumberFormat.Field.INTEGER, n3, stringBuffer.length(), stringBuffer);
            if (bl) {
                this.append(stringBuffer, this.negativeSuffix, fieldDelegate, this.getNegativeSuffixFieldPositions(), NumberFormat.Field.SIGN);
            } else {
                this.append(stringBuffer, this.positiveSuffix, fieldDelegate, this.getPositiveSuffixFieldPositions(), NumberFormat.Field.SIGN);
            }
            return stringBuffer;
        }
        if (bl) {
            d = -d;
        }
        if (!($assertionsDisabled || d >= 0.0 && !Double.isInfinite(d))) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        Object object = ah.getMonitor((Object)this.digitList);
        synchronized (object) {
            try {
                int n4 = super.getMaximumIntegerDigits();
                int n5 = super.getMinimumIntegerDigits();
                int n6 = super.getMaximumFractionDigits();
                int n7 = super.getMinimumFractionDigits();
                this.digitList.set(bl, d, this.useExponentialNotation ? n4 + n6 : n6, !this.useExponentialNotation);
                return this.subformat(stringBuffer, fieldDelegate, bl, false, n4, n5, n6, n7);
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        return this.format(l, stringBuffer, fieldPosition.getFieldDelegate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer format(long l, StringBuffer stringBuffer, Format.FieldDelegate fieldDelegate) {
        boolean bl;
        boolean bl2 = bl = l < 0L;
        if (bl) {
            l = -l;
        }
        boolean bl3 = false;
        if (l < 0L) {
            if (this.multiplier != 0) {
                bl3 = true;
            }
        } else if (this.multiplier != 1 && this.multiplier != 0) {
            long l2 = Long.MAX_VALUE / (long)this.multiplier;
            if (l2 < 0L) {
                l2 = -l2;
            }
            boolean bl4 = bl3 = l > l2;
        }
        if (bl3) {
            if (bl) {
                l = -l;
            }
            BigInteger bigInteger = BigInteger.valueOf(l);
            return this.format(bigInteger, stringBuffer, fieldDelegate, true);
        }
        if ((l *= (long)this.multiplier) == 0L) {
            bl = false;
        } else if (this.multiplier < 0) {
            l = -l;
            bl = !bl;
        }
        Object object = ah.getMonitor((Object)this.digitList);
        synchronized (object) {
            try {
                int n2 = super.getMaximumIntegerDigits();
                int n3 = super.getMinimumIntegerDigits();
                int n4 = super.getMaximumFractionDigits();
                int n5 = super.getMinimumFractionDigits();
                this.digitList.set(bl, l, this.useExponentialNotation ? n2 + n4 : 0);
                return this.subformat(stringBuffer, fieldDelegate, bl, true, n2, n3, n4, n5);
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    private StringBuffer format(BigDecimal bigDecimal, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        return this.format(bigDecimal, stringBuffer, fieldPosition.getFieldDelegate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer format(BigDecimal bigDecimal, StringBuffer stringBuffer, Format.FieldDelegate fieldDelegate) {
        boolean bl;
        if (this.multiplier != 1) {
            bigDecimal = bigDecimal.multiply(this.getBigDecimalMultiplier());
        }
        boolean bl2 = bl = bigDecimal.signum() == -1;
        if (bl) {
            bigDecimal = bigDecimal.negate();
        }
        Object object = ah.getMonitor((Object)this.digitList);
        synchronized (object) {
            try {
                int n2 = this.getMaximumIntegerDigits();
                int n3 = this.getMinimumIntegerDigits();
                int n4 = this.getMaximumFractionDigits();
                int n5 = this.getMinimumFractionDigits();
                int n6 = n2 + n4;
                this.digitList.set(bl, bigDecimal, this.useExponentialNotation ? (n6 < 0 ? Integer.MAX_VALUE : n6) : n4, !this.useExponentialNotation);
                return this.subformat(stringBuffer, fieldDelegate, bl, false, n2, n3, n4, n5);
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    private StringBuffer format(BigInteger bigInteger, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        return this.format(bigInteger, stringBuffer, fieldPosition.getFieldDelegate(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer format(BigInteger bigInteger, StringBuffer stringBuffer, Format.FieldDelegate fieldDelegate, boolean bl) {
        boolean bl2;
        if (this.multiplier != 1) {
            bigInteger = bigInteger.multiply(this.getBigIntegerMultiplier());
        }
        boolean bl3 = bl2 = bigInteger.signum() == -1;
        if (bl2) {
            bigInteger = bigInteger.negate();
        }
        Object object = ah.getMonitor((Object)this.digitList);
        synchronized (object) {
            try {
                int n2;
                int n3;
                int n4;
                int n5;
                int n6;
                if (bl) {
                    n6 = super.getMaximumIntegerDigits();
                    n5 = super.getMinimumIntegerDigits();
                    n4 = super.getMaximumFractionDigits();
                    n3 = super.getMinimumFractionDigits();
                    n2 = n6 + n4;
                } else {
                    n6 = this.getMaximumIntegerDigits();
                    n5 = this.getMinimumIntegerDigits();
                    n4 = this.getMaximumFractionDigits();
                    n3 = this.getMinimumFractionDigits();
                    n2 = n6 + n4;
                    if (n2 < 0) {
                        n2 = Integer.MAX_VALUE;
                    }
                }
                this.digitList.set(bl2, bigInteger, this.useExponentialNotation ? n2 : 0);
                return this.subformat(stringBuffer, fieldDelegate, bl2, true, n6, n5, n4, n3);
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        CharacterIteratorFieldDelegate characterIteratorFieldDelegate = new CharacterIteratorFieldDelegate();
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof Double || g.convertForInstanceOf((Object)object, Float.class) instanceof Float) {
            this.format(((Number)g.convertForCast((Object)object, Number.class)).doubleValue(), stringBuffer, (Format.FieldDelegate)characterIteratorFieldDelegate);
        } else if (g.convertForInstanceOf((Object)object, Long.class) instanceof Long || object instanceof Integer || g.convertForInstanceOf((Object)object, Short.class) instanceof Short || object instanceof Byte || g.convertForInstanceOf((Object)object, AtomicInteger.class) instanceof AtomicInteger || g.convertForInstanceOf((Object)object, AtomicLong.class) instanceof AtomicLong) {
            this.format(((Number)g.convertForCast((Object)object, Number.class)).longValue(), stringBuffer, (Format.FieldDelegate)characterIteratorFieldDelegate);
        } else if (g.convertForInstanceOf((Object)object, BigDecimal.class) instanceof BigDecimal) {
            this.format((BigDecimal)g.convertForCast((Object)object, BigDecimal.class), stringBuffer, (Format.FieldDelegate)characterIteratorFieldDelegate);
        } else if (g.convertForInstanceOf((Object)object, BigInteger.class) instanceof BigInteger) {
            this.format((BigInteger)g.convertForCast((Object)object, BigInteger.class), stringBuffer, characterIteratorFieldDelegate, false);
        } else {
            if (object == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("formatToCharacterIterator must be passed non-null object"));
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Cannot format given Object as a Number"));
        }
        return characterIteratorFieldDelegate.getIterator(stringBuffer.toString());
    }

    private StringBuffer subformat(StringBuffer stringBuffer, Format.FieldDelegate fieldDelegate, boolean bl, boolean bl2, int n2, int n3, int n4, int n5) {
        char c;
        char c2 = this.symbols.getZeroDigit();
        int n6 = c2 - 48;
        char c3 = this.symbols.getGroupingSeparator();
        char c4 = c = this.isCurrencyFormat ? this.symbols.getMonetaryDecimalSeparator() : this.symbols.getDecimalSeparator();
        if (this.digitList.isZero()) {
            DigitList._jr$ip$decimalAt(this.digitList, 0);
        }
        if (bl) {
            this.append(stringBuffer, this.negativePrefix, fieldDelegate, this.getNegativePrefixFieldPositions(), NumberFormat.Field.SIGN);
        } else {
            this.append(stringBuffer, this.positivePrefix, fieldDelegate, this.getPositivePrefixFieldPositions(), NumberFormat.Field.SIGN);
        }
        if (this.useExponentialNotation) {
            int n7;
            boolean bl3;
            int n8;
            int n9;
            int n10;
            int n11 = stringBuffer.length();
            int n12 = -1;
            int n13 = -1;
            int n14 = DigitList._jr$ig$decimalAt(this.digitList);
            int n15 = n2;
            int n16 = n3;
            if (n15 > 1 && n15 > n3) {
                n14 = n14 >= 1 ? (n14 - 1) / n15 * n15 : (n14 - n15) / n15 * n15;
                n16 = 1;
            } else {
                n14 -= n16;
            }
            int n17 = n3 + n5;
            if (n17 < 0) {
                n17 = Integer.MAX_VALUE;
            }
            int n18 = n10 = this.digitList.isZero() ? n16 : DigitList._jr$ig$decimalAt(this.digitList) - n14;
            if (n17 < n10) {
                n17 = n10;
            }
            if (n17 > (n9 = DigitList._jr$ig$count(this.digitList))) {
                n9 = n17;
            }
            boolean bl4 = false;
            for (n8 = 0; n8 < n9; ++n8) {
                if (n8 == n10) {
                    n12 = stringBuffer.length();
                    stringBuffer.append(c);
                    bl4 = true;
                    n13 = stringBuffer.length();
                }
                stringBuffer.append(n8 < DigitList._jr$ig$count(this.digitList) ? (char)(DigitList._jr$ig$digits(this.digitList)[n8] + n6) : c2);
            }
            if (this.decimalSeparatorAlwaysShown && n9 == n10) {
                n12 = stringBuffer.length();
                stringBuffer.append(c);
                bl4 = true;
                n13 = stringBuffer.length();
            }
            if (n12 == -1) {
                n12 = stringBuffer.length();
            }
            fieldDelegate.formatted(0, NumberFormat.Field.INTEGER, NumberFormat.Field.INTEGER, n11, n12, stringBuffer);
            if (bl4) {
                fieldDelegate.formatted(NumberFormat.Field.DECIMAL_SEPARATOR, NumberFormat.Field.DECIMAL_SEPARATOR, n12, n13, stringBuffer);
            }
            if (n13 == -1) {
                n13 = stringBuffer.length();
            }
            fieldDelegate.formatted(1, NumberFormat.Field.FRACTION, NumberFormat.Field.FRACTION, n13, stringBuffer.length(), stringBuffer);
            n8 = stringBuffer.length();
            stringBuffer.append(this.symbols.getExponentSeparator());
            fieldDelegate.formatted(NumberFormat.Field.EXPONENT_SYMBOL, NumberFormat.Field.EXPONENT_SYMBOL, n8, stringBuffer.length(), stringBuffer);
            if (this.digitList.isZero()) {
                n14 = 0;
            }
            boolean bl5 = bl3 = n14 < 0;
            if (bl3) {
                n14 = -n14;
                n8 = stringBuffer.length();
                stringBuffer.append(this.symbols.getMinusSign());
                fieldDelegate.formatted(NumberFormat.Field.EXPONENT_SIGN, NumberFormat.Field.EXPONENT_SIGN, n8, stringBuffer.length(), stringBuffer);
            }
            this.digitList.set(bl3, n14);
            int n19 = stringBuffer.length();
            for (n7 = DigitList._jr$ig$decimalAt(this.digitList); n7 < this.minExponentDigits; ++n7) {
                stringBuffer.append(c2);
            }
            for (n7 = 0; n7 < DigitList._jr$ig$decimalAt(this.digitList); ++n7) {
                stringBuffer.append(n7 < DigitList._jr$ig$count(this.digitList) ? (char)(DigitList._jr$ig$digits(this.digitList)[n7] + n6) : c2);
            }
            fieldDelegate.formatted(NumberFormat.Field.EXPONENT, NumberFormat.Field.EXPONENT, n19, stringBuffer.length(), stringBuffer);
        } else {
            int n20;
            int n21;
            int n22 = stringBuffer.length();
            int n23 = n3;
            int n24 = 0;
            if (DigitList._jr$ig$decimalAt(this.digitList) > 0 && n23 < DigitList._jr$ig$decimalAt(this.digitList)) {
                n23 = DigitList._jr$ig$decimalAt(this.digitList);
            }
            if (n23 > n2) {
                n23 = n2;
                n24 = DigitList._jr$ig$decimalAt(this.digitList) - n23;
            }
            int n25 = stringBuffer.length();
            for (n21 = n23 - 1; n21 >= 0; --n21) {
                if (n21 < DigitList._jr$ig$decimalAt(this.digitList) && n24 < DigitList._jr$ig$count(this.digitList)) {
                    stringBuffer.append((char)(DigitList._jr$ig$digits(this.digitList)[n24++] + n6));
                } else {
                    stringBuffer.append(c2);
                }
                if (!this.isGroupingUsed() || n21 <= 0 || this.groupingSize == 0 || n21 % this.groupingSize != 0) continue;
                n20 = stringBuffer.length();
                stringBuffer.append(c3);
                fieldDelegate.formatted(NumberFormat.Field.GROUPING_SEPARATOR, NumberFormat.Field.GROUPING_SEPARATOR, n20, stringBuffer.length(), stringBuffer);
            }
            int n26 = n21 = n5 > 0 || !bl2 && n24 < DigitList._jr$ig$count(this.digitList) ? 1 : 0;
            if (n21 == 0 && stringBuffer.length() == n25) {
                stringBuffer.append(c2);
            }
            fieldDelegate.formatted(0, NumberFormat.Field.INTEGER, NumberFormat.Field.INTEGER, n22, stringBuffer.length(), stringBuffer);
            n20 = stringBuffer.length();
            if (this.decimalSeparatorAlwaysShown || n21 != 0) {
                stringBuffer.append(c);
            }
            if (n20 != stringBuffer.length()) {
                fieldDelegate.formatted(NumberFormat.Field.DECIMAL_SEPARATOR, NumberFormat.Field.DECIMAL_SEPARATOR, n20, stringBuffer.length(), stringBuffer);
            }
            int n27 = stringBuffer.length();
            for (int i = 0; i < n4 && (i < n5 || !bl2 && n24 < DigitList._jr$ig$count(this.digitList)); ++i) {
                if (-1 - i > DigitList._jr$ig$decimalAt(this.digitList) - 1) {
                    stringBuffer.append(c2);
                    continue;
                }
                if (!bl2 && n24 < DigitList._jr$ig$count(this.digitList)) {
                    stringBuffer.append((char)(DigitList._jr$ig$digits(this.digitList)[n24++] + n6));
                    continue;
                }
                stringBuffer.append(c2);
            }
            fieldDelegate.formatted(1, NumberFormat.Field.FRACTION, NumberFormat.Field.FRACTION, n27, stringBuffer.length(), stringBuffer);
        }
        if (bl) {
            this.append(stringBuffer, this.negativeSuffix, fieldDelegate, this.getNegativeSuffixFieldPositions(), NumberFormat.Field.SIGN);
        } else {
            this.append(stringBuffer, this.positiveSuffix, fieldDelegate, this.getPositiveSuffixFieldPositions(), NumberFormat.Field.SIGN);
        }
        return stringBuffer;
    }

    private void append(StringBuffer stringBuffer, String string, Format.FieldDelegate fieldDelegate, FieldPosition[] fieldPositionArray, Format.Field field) {
        int n2 = stringBuffer.length();
        if (string.length() > 0) {
            stringBuffer.append(string);
            int n3 = a.arrayLength((Object[])fieldPositionArray);
            for (int i = 0; i < n3; ++i) {
                FieldPosition fieldPosition = (FieldPosition)((Object)g.convertForCast((Object)a.arrayLoad((Object[])fieldPositionArray, (int)i), FieldPosition.class));
                Format.Field field2 = fieldPosition.getFieldAttribute();
                if (!f.ifAcmp((Object)field2, (Object)NumberFormat.Field.SIGN)) {
                    field2 = field;
                }
                fieldDelegate.formatted(field2, field2, n2 + fieldPosition.getBeginIndex(), n2 + fieldPosition.getEndIndex(), stringBuffer);
            }
        }
    }

    @Override
    public Number parse(String string, ParsePosition parsePosition) {
        if (string.regionMatches(ParsePosition._jr$ig$index((Object)parsePosition), this.symbols.getNaN(), 0, this.symbols.getNaN().length())) {
            ParsePosition._jr$ip$index((Object)parsePosition, (int)(ParsePosition._jr$ig$index((Object)parsePosition) + this.symbols.getNaN().length()));
            return new Double(Double.NaN);
        }
        boolean[] blArray = new boolean[2];
        if (!this.subparse(string, parsePosition, this.positivePrefix, this.negativePrefix, this.digitList, false, blArray)) {
            return null;
        }
        if (blArray[0]) {
            if (blArray[1] == this.multiplier >= 0) {
                return new Double(Double.POSITIVE_INFINITY);
            }
            return new Double(Double.NEGATIVE_INFINITY);
        }
        if (this.multiplier == 0) {
            if (this.digitList.isZero()) {
                return new Double(Double.NaN);
            }
            if (blArray[1]) {
                return new Double(Double.POSITIVE_INFINITY);
            }
            return new Double(Double.NEGATIVE_INFINITY);
        }
        if (this.isParseBigDecimal()) {
            BigDecimal bigDecimal = this.digitList.getBigDecimal();
            if (this.multiplier != 1) {
                try {
                    bigDecimal = bigDecimal.divide(this.getBigDecimalMultiplier());
                }
                catch (ArithmeticException arithmeticException) {
                    bigDecimal = bigDecimal.divide(this.getBigDecimalMultiplier(), this.roundingMode);
                }
            }
            if (!blArray[1]) {
                bigDecimal = bigDecimal.negate();
            }
            return bigDecimal;
        }
        boolean bl = true;
        boolean bl2 = false;
        double d = 0.0;
        long l = 0L;
        if (this.digitList.fitsIntoLong(blArray[1], this.isParseIntegerOnly())) {
            bl = false;
            l = this.digitList.getLong();
            if (l < 0L) {
                bl2 = true;
            }
        } else {
            d = this.digitList.getDouble();
        }
        if (this.multiplier != 1) {
            if (bl) {
                d /= (double)this.multiplier;
            } else if (l % (long)this.multiplier == 0L) {
                l /= (long)this.multiplier;
            } else {
                d = (double)l / (double)this.multiplier;
                bl = true;
            }
        }
        if (!blArray[1] && !bl2) {
            d = -d;
            l = -l;
        }
        if (this.multiplier != 1 && bl) {
            l = (long)d;
            bl = (d != (double)l || d == 0.0 && 1.0 / d < 0.0) && !this.isParseIntegerOnly();
        }
        return bl ? (Number)new Double(d) : (Number)new Long(l);
    }

    private BigInteger getBigIntegerMultiplier() {
        if (this.bigIntegerMultiplier == null) {
            this.bigIntegerMultiplier = BigInteger.valueOf(this.multiplier);
        }
        return this.bigIntegerMultiplier;
    }

    private BigDecimal getBigDecimalMultiplier() {
        if (this.bigDecimalMultiplier == null) {
            this.bigDecimalMultiplier = new BigDecimal(this.multiplier);
        }
        return this.bigDecimalMultiplier;
    }

    private final boolean subparse(String string, ParsePosition parsePosition, String string2, String string3, DigitList digitList, boolean bl, boolean[] blArray) {
        int n2 = ParsePosition._jr$ig$index((Object)parsePosition);
        int n3 = ParsePosition._jr$ig$index((Object)parsePosition);
        boolean bl2 = string.regionMatches(n2, string2, 0, string2.length());
        boolean bl3 = string.regionMatches(n2, string3, 0, string3.length());
        if (bl2 && bl3) {
            if (string2.length() > string3.length()) {
                bl3 = false;
            } else if (string2.length() < string3.length()) {
                bl2 = false;
            }
        }
        if (bl2) {
            n2 += string2.length();
        } else if (bl3) {
            n2 += string3.length();
        } else {
            ParsePosition._jr$ip$errorIndex((Object)parsePosition, (int)n2);
            return false;
        }
        blArray[0] = false;
        if (!bl && string.regionMatches(n2, this.symbols.getInfinity(), 0, this.symbols.getInfinity().length())) {
            n2 += this.symbols.getInfinity().length();
            blArray[0] = true;
        } else {
            DigitList._jr$ip$count(digitList, 0);
            DigitList._jr$ip$decimalAt(digitList, 0);
            char c = this.symbols.getZeroDigit();
            char c2 = this.isCurrencyFormat ? this.symbols.getMonetaryDecimalSeparator() : this.symbols.getDecimalSeparator();
            char c3 = this.symbols.getGroupingSeparator();
            String string4 = this.symbols.getExponentSeparator();
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            int n4 = 0;
            int n5 = 0;
            int n6 = -1;
            while (n2 < string.length()) {
                char c4 = string.charAt(n2);
                int n7 = c4 - c;
                if (n7 < 0 || n7 > 9) {
                    n7 = Character.digit(c4, 10);
                }
                if (n7 == 0) {
                    n6 = -1;
                    bl6 = true;
                    if (DigitList._jr$ig$count(digitList) == 0) {
                        if (bl4) {
                            DigitList digitList2 = digitList;
                            DigitList._jr$ip$decimalAt(digitList2, DigitList._jr$ig$decimalAt(digitList2) - 1);
                        }
                    } else {
                        ++n5;
                        digitList.append((char)(n7 + 48));
                    }
                } else if (n7 > 0 && n7 <= 9) {
                    bl6 = true;
                    ++n5;
                    digitList.append((char)(n7 + 48));
                    n6 = -1;
                } else if (!bl && c4 == c2) {
                    if (this.isParseIntegerOnly() || bl4) break;
                    DigitList._jr$ip$decimalAt(digitList, n5);
                    bl4 = true;
                } else if (!bl && c4 == c3 && this.isGroupingUsed()) {
                    if (bl4) break;
                    n6 = n2;
                } else {
                    if (bl || !string.regionMatches(n2, string4, 0, string4.length()) || bl5) break;
                    ParsePosition parsePosition2 = new ParsePosition(n2 + string4.length());
                    boolean[] blArray2 = new boolean[2];
                    DigitList digitList3 = new DigitList();
                    if (!this.subparse(string, parsePosition2, "", Character.toString(this.symbols.getMinusSign()), digitList3, true, blArray2) || !digitList3.fitsIntoLong(blArray2[1], true)) break;
                    n2 = ParsePosition._jr$ig$index((Object)parsePosition2);
                    n4 = (int)digitList3.getLong();
                    if (!blArray2[1]) {
                        n4 = -n4;
                    }
                    bl5 = true;
                    break;
                }
                ++n2;
            }
            if (n6 != -1) {
                n2 = n6;
            }
            if (!bl4) {
                DigitList._jr$ip$decimalAt(digitList, n5);
            }
            DigitList digitList4 = digitList;
            DigitList._jr$ip$decimalAt(digitList4, DigitList._jr$ig$decimalAt(digitList4) + n4);
            if (!bl6 && n5 == 0) {
                ParsePosition._jr$ip$index((Object)parsePosition, (int)n3);
                ParsePosition._jr$ip$errorIndex((Object)parsePosition, (int)n3);
                return false;
            }
        }
        if (!bl) {
            if (bl2) {
                bl2 = string.regionMatches(n2, this.positiveSuffix, 0, this.positiveSuffix.length());
            }
            if (bl3) {
                bl3 = string.regionMatches(n2, this.negativeSuffix, 0, this.negativeSuffix.length());
            }
            if (bl2 && bl3) {
                if (this.positiveSuffix.length() > this.negativeSuffix.length()) {
                    bl3 = false;
                } else if (this.positiveSuffix.length() < this.negativeSuffix.length()) {
                    bl2 = false;
                }
            }
            if (bl2 == bl3) {
                ParsePosition._jr$ip$errorIndex((Object)parsePosition, (int)n2);
                return false;
            }
            ParsePosition._jr$ip$index((Object)parsePosition, (int)(n2 + (bl2 ? this.positiveSuffix.length() : this.negativeSuffix.length())));
        } else {
            ParsePosition._jr$ip$index((Object)parsePosition, (int)n2);
        }
        blArray[1] = bl2;
        if (ParsePosition._jr$ig$index((Object)parsePosition) == n3) {
            ParsePosition._jr$ip$errorIndex((Object)parsePosition, (int)n2);
            return false;
        }
        return true;
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        try {
            return (DecimalFormatSymbols)g.convertForCast((Object)this.symbols.clone(), DecimalFormatSymbols.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols decimalFormatSymbols) {
        try {
            this.symbols = (DecimalFormatSymbols)g.convertForCast((Object)decimalFormatSymbols.clone(), DecimalFormatSymbols.class);
            this.expandAffixes();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getPositivePrefix() {
        return this.positivePrefix;
    }

    public void setPositivePrefix(String string) {
        this.positivePrefix = string;
        this.posPrefixPattern = null;
        this.positivePrefixFieldPositions = null;
    }

    private FieldPosition[] getPositivePrefixFieldPositions() {
        if (this.positivePrefixFieldPositions == null) {
            if (this.posPrefixPattern != null) {
                this.positivePrefixFieldPositions = this.expandAffix(this.posPrefixPattern);
            } else {
                this.positivePrefixFieldPositions = DecimalFormat.EmptyFieldPositionArray;
            }
        }
        return this.positivePrefixFieldPositions;
    }

    public String getNegativePrefix() {
        return this.negativePrefix;
    }

    public void setNegativePrefix(String string) {
        this.negativePrefix = string;
        this.negPrefixPattern = null;
    }

    private FieldPosition[] getNegativePrefixFieldPositions() {
        if (this.negativePrefixFieldPositions == null) {
            if (this.negPrefixPattern != null) {
                this.negativePrefixFieldPositions = this.expandAffix(this.negPrefixPattern);
            } else {
                this.negativePrefixFieldPositions = DecimalFormat.EmptyFieldPositionArray;
            }
        }
        return this.negativePrefixFieldPositions;
    }

    public String getPositiveSuffix() {
        return this.positiveSuffix;
    }

    public void setPositiveSuffix(String string) {
        this.positiveSuffix = string;
        this.posSuffixPattern = null;
    }

    private FieldPosition[] getPositiveSuffixFieldPositions() {
        if (this.positiveSuffixFieldPositions == null) {
            if (this.posSuffixPattern != null) {
                this.positiveSuffixFieldPositions = this.expandAffix(this.posSuffixPattern);
            } else {
                this.positiveSuffixFieldPositions = DecimalFormat.EmptyFieldPositionArray;
            }
        }
        return this.positiveSuffixFieldPositions;
    }

    public String getNegativeSuffix() {
        return this.negativeSuffix;
    }

    public void setNegativeSuffix(String string) {
        this.negativeSuffix = string;
        this.negSuffixPattern = null;
    }

    private FieldPosition[] getNegativeSuffixFieldPositions() {
        if (this.negativeSuffixFieldPositions == null) {
            if (this.negSuffixPattern != null) {
                this.negativeSuffixFieldPositions = this.expandAffix(this.negSuffixPattern);
            } else {
                this.negativeSuffixFieldPositions = DecimalFormat.EmptyFieldPositionArray;
            }
        }
        return this.negativeSuffixFieldPositions;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(int n2) {
        this.multiplier = n2;
        this.bigDecimalMultiplier = null;
        this.bigIntegerMultiplier = null;
    }

    public int getGroupingSize() {
        return this.groupingSize;
    }

    public void setGroupingSize(int n2) {
        this.groupingSize = (byte)n2;
    }

    public boolean isDecimalSeparatorAlwaysShown() {
        return this.decimalSeparatorAlwaysShown;
    }

    public void setDecimalSeparatorAlwaysShown(boolean bl) {
        this.decimalSeparatorAlwaysShown = bl;
    }

    public boolean isParseBigDecimal() {
        return this.parseBigDecimal;
    }

    public void setParseBigDecimal(boolean bl) {
        this.parseBigDecimal = bl;
    }

    @Override
    public Object clone() {
        try {
            DecimalFormat decimalFormat = (DecimalFormat)g.convertForCast((Object)super.clone(), DecimalFormat.class);
            decimalFormat.symbols = (DecimalFormatSymbols)g.convertForCast((Object)this.symbols.clone(), DecimalFormatSymbols.class);
            decimalFormat.digitList = (DigitList)g.convertForCast((Object)this.digitList.clone(), DigitList.class);
            return decimalFormat;
        }
        catch (Exception exception) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        DecimalFormat decimalFormat = (DecimalFormat)g.convertForCast((Object)object, DecimalFormat.class);
        return (!f.ifAcmp((Object)this.posPrefixPattern, (Object)decimalFormat.posPrefixPattern) && this.positivePrefix.equals(decimalFormat.positivePrefix) || this.posPrefixPattern != null && this.posPrefixPattern.equals(decimalFormat.posPrefixPattern)) && (!f.ifAcmp((Object)this.posSuffixPattern, (Object)decimalFormat.posSuffixPattern) && this.positiveSuffix.equals(decimalFormat.positiveSuffix) || this.posSuffixPattern != null && this.posSuffixPattern.equals(decimalFormat.posSuffixPattern)) && (!f.ifAcmp((Object)this.negPrefixPattern, (Object)decimalFormat.negPrefixPattern) && this.negativePrefix.equals(decimalFormat.negativePrefix) || this.negPrefixPattern != null && this.negPrefixPattern.equals(decimalFormat.negPrefixPattern)) && (!f.ifAcmp((Object)this.negSuffixPattern, (Object)decimalFormat.negSuffixPattern) && this.negativeSuffix.equals(decimalFormat.negativeSuffix) || this.negSuffixPattern != null && this.negSuffixPattern.equals(decimalFormat.negSuffixPattern)) && this.multiplier == decimalFormat.multiplier && this.groupingSize == decimalFormat.groupingSize && this.decimalSeparatorAlwaysShown == decimalFormat.decimalSeparatorAlwaysShown && this.parseBigDecimal == decimalFormat.parseBigDecimal && this.useExponentialNotation == decimalFormat.useExponentialNotation && (!this.useExponentialNotation || this.minExponentDigits == decimalFormat.minExponentDigits) && this.maximumIntegerDigits == decimalFormat.maximumIntegerDigits && this.minimumIntegerDigits == decimalFormat.minimumIntegerDigits && this.maximumFractionDigits == decimalFormat.maximumFractionDigits && this.minimumFractionDigits == decimalFormat.minimumFractionDigits && !f.ifAcmp((Object)((Object)this.roundingMode), (Object)((Object)decimalFormat.roundingMode)) && this.symbols.equals(decimalFormat.symbols);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 37 + this.positivePrefix.hashCode();
    }

    public String toPattern() {
        return this.toPattern(false);
    }

    public String toLocalizedPattern() {
        return this.toPattern(true);
    }

    private void expandAffixes() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.posPrefixPattern != null) {
            this.positivePrefix = this.expandAffix(this.posPrefixPattern, stringBuffer);
            this.positivePrefixFieldPositions = null;
        }
        if (this.posSuffixPattern != null) {
            this.positiveSuffix = this.expandAffix(this.posSuffixPattern, stringBuffer);
            this.positiveSuffixFieldPositions = null;
        }
        if (this.negPrefixPattern != null) {
            this.negativePrefix = this.expandAffix(this.negPrefixPattern, stringBuffer);
            this.negativePrefixFieldPositions = null;
        }
        if (this.negSuffixPattern != null) {
            this.negativeSuffix = this.expandAffix(this.negSuffixPattern, stringBuffer);
            this.negativeSuffixFieldPositions = null;
        }
    }

    private String expandAffix(String string, StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        int n2 = 0;
        block6: while (n2 < string.length()) {
            char c;
            if ((c = string.charAt(n2++)) == '\'') {
                c = string.charAt(n2++);
                switch (c) {
                    case '\u00a4': {
                        if (n2 < string.length() && string.charAt(n2) == '\u00a4') {
                            ++n2;
                            stringBuffer.append(this.symbols.getInternationalCurrencySymbol());
                            continue block6;
                        }
                        stringBuffer.append(this.symbols.getCurrencySymbol());
                        continue block6;
                    }
                    case '%': {
                        c = this.symbols.getPercent();
                        break;
                    }
                    case '\u2030': {
                        c = this.symbols.getPerMill();
                        break;
                    }
                    case '-': {
                        c = this.symbols.getMinusSign();
                    }
                }
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private FieldPosition[] expandAffix(String string) {
        ArrayList<Object> arrayList = null;
        int n2 = 0;
        int n3 = 0;
        block6: while (n3 < string.length()) {
            char c;
            if ((c = string.charAt(n3++)) == '\'') {
                Object object;
                int n4 = -1;
                NumberFormat.Field field = null;
                c = string.charAt(n3++);
                switch (c) {
                    case '\u00a4': {
                        if (n3 < string.length() && string.charAt(n3) == '\u00a4') {
                            ++n3;
                            object = this.symbols.getInternationalCurrencySymbol();
                        } else {
                            object = this.symbols.getCurrencySymbol();
                        }
                        if (((String)object).length() <= 0) continue block6;
                        if (arrayList == null) {
                            arrayList = new ArrayList(2);
                        }
                        FieldPosition fieldPosition = new FieldPosition(NumberFormat.Field.CURRENCY);
                        fieldPosition.setBeginIndex(n2);
                        fieldPosition.setEndIndex(n2 + ((String)object).length());
                        arrayList.add((Object)fieldPosition);
                        n2 += ((String)object).length();
                        continue block6;
                    }
                    case '%': {
                        c = this.symbols.getPercent();
                        n4 = -1;
                        field = NumberFormat.Field.PERCENT;
                        break;
                    }
                    case '\u2030': {
                        c = this.symbols.getPerMill();
                        n4 = -1;
                        field = NumberFormat.Field.PERMILLE;
                        break;
                    }
                    case '-': {
                        c = this.symbols.getMinusSign();
                        n4 = -1;
                        field = NumberFormat.Field.SIGN;
                    }
                }
                if (field != null) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<Object>(2);
                    }
                    object = new FieldPosition(field, n4);
                    ((FieldPosition)((Object)object)).setBeginIndex(n2);
                    ((FieldPosition)((Object)object)).setEndIndex(n2 + 1);
                    arrayList.add(object);
                }
            }
            ++n2;
        }
        if (arrayList != null) {
            return (FieldPosition[])g.convertForCast((Object)((FieldPosition[])g.convertForCast((Object)arrayList.toArray(EmptyFieldPositionArray), FieldPosition[].class)), FieldPosition[].class);
        }
        return EmptyFieldPositionArray;
    }

    private void appendAffix(StringBuffer stringBuffer, String string, String string2, boolean bl) {
        if (string == null) {
            this.appendAffix(stringBuffer, string2, bl);
        } else {
            int n2 = 0;
            while (n2 < string.length()) {
                int n3 = string.indexOf(39, n2);
                if (n3 < 0) {
                    this.appendAffix(stringBuffer, string.substring(n2), bl);
                    break;
                }
                if (n3 > n2) {
                    this.appendAffix(stringBuffer, string.substring(n2, n3), bl);
                }
                char c = string.charAt(++n3);
                ++n3;
                if (c == '\'') {
                    stringBuffer.append(c);
                } else if (c == '\u00a4' && n3 < string.length() && string.charAt(n3) == '\u00a4') {
                    stringBuffer.append(c);
                } else if (bl) {
                    switch (c) {
                        case '%': {
                            c = this.symbols.getPercent();
                            break;
                        }
                        case '\u2030': {
                            c = this.symbols.getPerMill();
                            break;
                        }
                        case '-': {
                            c = this.symbols.getMinusSign();
                        }
                    }
                }
                stringBuffer.append(c);
                n2 = ++n3;
            }
        }
    }

    private void appendAffix(StringBuffer stringBuffer, String string, boolean bl) {
        boolean bl2;
        if (bl) {
            bl2 = string.indexOf(this.symbols.getZeroDigit()) >= 0 || string.indexOf(this.symbols.getGroupingSeparator()) >= 0 || string.indexOf(this.symbols.getDecimalSeparator()) >= 0 || string.indexOf(this.symbols.getPercent()) >= 0 || string.indexOf(this.symbols.getPerMill()) >= 0 || string.indexOf(this.symbols.getDigit()) >= 0 || string.indexOf(this.symbols.getPatternSeparator()) >= 0 || string.indexOf(this.symbols.getMinusSign()) >= 0 || string.indexOf(164) >= 0;
        } else {
            boolean bl3 = bl2 = string.indexOf(48) >= 0 || string.indexOf(44) >= 0 || string.indexOf(46) >= 0 || string.indexOf(37) >= 0 || string.indexOf(8240) >= 0 || string.indexOf(35) >= 0 || string.indexOf(59) >= 0 || string.indexOf(45) >= 0 || string.indexOf(164) >= 0;
        }
        if (bl2) {
            stringBuffer.append('\'');
        }
        if (string.indexOf(39) < 0) {
            stringBuffer.append(string);
        } else {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                stringBuffer.append(c);
                if (c != '\'') continue;
                stringBuffer.append(c);
            }
        }
        if (bl2) {
            stringBuffer.append('\'');
        }
    }

    private String toPattern(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i >= 0; --i) {
            int n2;
            int n3;
            if (i == 1) {
                this.appendAffix(stringBuffer, this.posPrefixPattern, this.positivePrefix, bl);
            } else {
                this.appendAffix(stringBuffer, this.negPrefixPattern, this.negativePrefix, bl);
            }
            for (n3 = n2 = this.useExponentialNotation ? this.getMaximumIntegerDigits() : Math.max(this.groupingSize, this.getMinimumIntegerDigits()) + 1; n3 > 0; --n3) {
                if (n3 != n2 && this.isGroupingUsed() && this.groupingSize != 0 && n3 % this.groupingSize == 0) {
                    stringBuffer.append(bl ? this.symbols.getGroupingSeparator() : (char)',');
                }
                stringBuffer.append(n3 <= this.getMinimumIntegerDigits() ? (bl ? this.symbols.getZeroDigit() : (char)'0') : (bl ? this.symbols.getDigit() : (char)'#'));
            }
            if (this.getMaximumFractionDigits() > 0 || this.decimalSeparatorAlwaysShown) {
                stringBuffer.append(bl ? this.symbols.getDecimalSeparator() : (char)'.');
            }
            for (n3 = 0; n3 < this.getMaximumFractionDigits(); ++n3) {
                if (n3 < this.getMinimumFractionDigits()) {
                    stringBuffer.append(bl ? this.symbols.getZeroDigit() : (char)'0');
                    continue;
                }
                stringBuffer.append(bl ? this.symbols.getDigit() : (char)'#');
            }
            if (this.useExponentialNotation) {
                stringBuffer.append(bl ? this.symbols.getExponentSeparator() : PATTERN_EXPONENT);
                for (n3 = 0; n3 < this.minExponentDigits; ++n3) {
                    stringBuffer.append(bl ? this.symbols.getZeroDigit() : (char)'0');
                }
            }
            if (i == 1) {
                this.appendAffix(stringBuffer, this.posSuffixPattern, this.positiveSuffix, bl);
                if ((!f.ifAcmp((Object)this.negSuffixPattern, (Object)this.posSuffixPattern) && this.negativeSuffix.equals(this.positiveSuffix) || this.negSuffixPattern != null && this.negSuffixPattern.equals(this.posSuffixPattern)) && (this.negPrefixPattern != null && this.posPrefixPattern != null && this.negPrefixPattern.equals("'-" + this.posPrefixPattern) || !f.ifAcmp((Object)this.negPrefixPattern, (Object)this.posPrefixPattern) && this.negativePrefix.equals(this.symbols.getMinusSign() + this.positivePrefix))) break;
                stringBuffer.append(bl ? this.symbols.getPatternSeparator() : (char)';');
                continue;
            }
            this.appendAffix(stringBuffer, this.negSuffixPattern, this.negativeSuffix, bl);
        }
        return stringBuffer.toString();
    }

    public void applyPattern(String string) {
        this.applyPattern(string, false);
    }

    public void applyLocalizedPattern(String string) {
        this.applyPattern(string, true);
    }

    private void applyPattern(String string, boolean bl) {
        int n2 = 48;
        int n3 = 44;
        int n4 = 46;
        int n5 = 37;
        int n6 = 8240;
        int n7 = 35;
        int n8 = 59;
        String string2 = PATTERN_EXPONENT;
        int n9 = 45;
        if (bl) {
            n2 = this.symbols.getZeroDigit();
            n3 = this.symbols.getGroupingSeparator();
            n4 = this.symbols.getDecimalSeparator();
            n5 = this.symbols.getPercent();
            n6 = this.symbols.getPerMill();
            n7 = this.symbols.getDigit();
            n8 = this.symbols.getPatternSeparator();
            string2 = this.symbols.getExponentSeparator();
            n9 = this.symbols.getMinusSign();
        }
        boolean bl2 = false;
        this.decimalSeparatorAlwaysShown = false;
        this.isCurrencyFormat = false;
        this.useExponentialNotation = false;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        for (int i = 1; i >= 0 && n12 < string.length(); --i) {
            int n13;
            int n14;
            boolean bl3 = false;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            int n15 = -1;
            int n16 = 1;
            int n17 = 0;
            int n18 = 0;
            int n19 = 0;
            byte by = -1;
            int n20 = 0;
            StringBuffer stringBuffer3 = stringBuffer;
            block5: for (n14 = n12; n14 < string.length(); ++n14) {
                n13 = string.charAt(n14);
                switch (n20) {
                    case 0: 
                    case 2: {
                        if (bl3) {
                            if (n13 == 39) {
                                if (n14 + 1 < string.length() && string.charAt(n14 + 1) == '\'') {
                                    ++n14;
                                    stringBuffer3.append("''");
                                    continue block5;
                                }
                                bl3 = false;
                                continue block5;
                            }
                        } else {
                            if (n13 == n7 || n13 == n2 || n13 == n3 || n13 == n4) {
                                n20 = 1;
                                if (i == 1) {
                                    n10 = n14;
                                }
                                --n14;
                                continue block5;
                            }
                            if (n13 == 164) {
                                boolean bl4;
                                boolean bl5 = bl4 = n14 + 1 < string.length() && string.charAt(n14 + 1) == '\u00a4';
                                if (bl4) {
                                    ++n14;
                                }
                                this.isCurrencyFormat = true;
                                stringBuffer3.append(bl4 ? "'\u00a4\u00a4" : "'\u00a4");
                                continue block5;
                            }
                            if (n13 == 39) {
                                if (n13 == 39) {
                                    if (n14 + 1 < string.length() && string.charAt(n14 + 1) == '\'') {
                                        ++n14;
                                        stringBuffer3.append("''");
                                        continue block5;
                                    }
                                    bl3 = true;
                                    continue block5;
                                }
                            } else {
                                if (n13 == n8) {
                                    if (n20 == 0 || i == 0) {
                                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Unquoted special character '" + (char)n13 + "' in pattern \"" + string + '\"'));
                                    }
                                    n12 = n14 + 1;
                                    n14 = string.length();
                                    continue block5;
                                }
                                if (n13 == n5) {
                                    if (n16 != 1) {
                                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Too many percent/per mille characters in pattern \"" + string + '\"'));
                                    }
                                    n16 = 100;
                                    stringBuffer3.append("'%");
                                    continue block5;
                                }
                                if (n13 == n6) {
                                    if (n16 != 1) {
                                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Too many percent/per mille characters in pattern \"" + string + '\"'));
                                    }
                                    n16 = 1000;
                                    stringBuffer3.append("'\u2030");
                                    continue block5;
                                }
                                if (n13 == n9) {
                                    stringBuffer3.append("'-");
                                    continue block5;
                                }
                            }
                        }
                        stringBuffer3.append((char)n13);
                        continue block5;
                    }
                    case 1: {
                        if (i == 1) {
                            ++n11;
                        } else {
                            if (--n11 != 0) continue block5;
                            n20 = 2;
                            stringBuffer3 = stringBuffer2;
                            continue block5;
                        }
                        if (n13 == n7) {
                            if (n18 > 0) {
                                ++n19;
                            } else {
                                ++n17;
                            }
                            if (by < 0 || n15 >= 0) continue block5;
                            by = (byte)(by + 1);
                            continue block5;
                        }
                        if (n13 == n2) {
                            if (n19 > 0) {
                                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Unexpected '0' in pattern \"" + string + '\"'));
                            }
                            ++n18;
                            if (by < 0 || n15 >= 0) continue block5;
                            by = (byte)(by + 1);
                            continue block5;
                        }
                        if (n13 == n3) {
                            by = 0;
                            continue block5;
                        }
                        if (n13 == n4) {
                            if (n15 >= 0) {
                                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Multiple decimal separators in pattern \"" + string + '\"'));
                            }
                            n15 = n17 + n18 + n19;
                            continue block5;
                        }
                        if (string.regionMatches(n14, string2, 0, string2.length())) {
                            if (this.useExponentialNotation) {
                                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Multiple exponential symbols in pattern \"" + string + '\"'));
                            }
                            this.useExponentialNotation = true;
                            this.minExponentDigits = (byte)0;
                            n14 += string2.length();
                            while (n14 < string.length() && string.charAt(n14) == n2) {
                                DecimalFormat decimalFormat = this;
                                decimalFormat.minExponentDigits = (byte)(decimalFormat.minExponentDigits + 1);
                                ++n11;
                                ++n14;
                            }
                            if (n17 + n18 < 1 || this.minExponentDigits < 1) {
                                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Malformed exponential pattern \"" + string + '\"'));
                            }
                            n20 = 2;
                            stringBuffer3 = stringBuffer2;
                            --n14;
                            continue block5;
                        }
                        n20 = 2;
                        stringBuffer3 = stringBuffer2;
                        --n14;
                        --n11;
                        continue block5;
                    }
                }
            }
            if (n18 == 0 && n17 > 0 && n15 >= 0) {
                n14 = n15;
                if (n14 == 0) {
                    ++n14;
                }
                n19 = n17 - n14;
                n17 = n14 - 1;
                n18 = 1;
            }
            if (n15 < 0 && n19 > 0 || n15 >= 0 && (n15 < n17 || n15 > n17 + n18) || by == 0 || bl3) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Malformed pattern \"" + string + '\"'));
            }
            if (i == 1) {
                this.posPrefixPattern = stringBuffer.toString();
                this.posSuffixPattern = stringBuffer2.toString();
                this.negPrefixPattern = this.posPrefixPattern;
                this.negSuffixPattern = this.posSuffixPattern;
                n14 = n17 + n18 + n19;
                n13 = n15 >= 0 ? n15 : n14;
                this.setMinimumIntegerDigits(n13 - n17);
                this.setMaximumIntegerDigits(this.useExponentialNotation ? n17 + this.getMinimumIntegerDigits() : Integer.MAX_VALUE);
                this.setMaximumFractionDigits(n15 >= 0 ? n14 - n15 : 0);
                this.setMinimumFractionDigits(n15 >= 0 ? n17 + n18 - n15 : 0);
                this.setGroupingUsed(by > 0);
                this.groupingSize = by > 0 ? by : (byte)0;
                this.multiplier = n16;
                this.setDecimalSeparatorAlwaysShown(n15 == 0 || n15 == n14);
                continue;
            }
            this.negPrefixPattern = stringBuffer.toString();
            this.negSuffixPattern = stringBuffer2.toString();
            bl2 = true;
        }
        if (string.length() == 0) {
            this.posSuffixPattern = "";
            this.posPrefixPattern = "";
            this.setMinimumIntegerDigits(0);
            this.setMaximumIntegerDigits(Integer.MAX_VALUE);
            this.setMinimumFractionDigits(0);
            this.setMaximumFractionDigits(Integer.MAX_VALUE);
        }
        if (!bl2 || this.negPrefixPattern.equals(this.posPrefixPattern) && this.negSuffixPattern.equals(this.posSuffixPattern)) {
            this.negSuffixPattern = this.posSuffixPattern;
            this.negPrefixPattern = "'-" + this.posPrefixPattern;
        }
        this.expandAffixes();
    }

    @Override
    public void setMaximumIntegerDigits(int n2) {
        this.maximumIntegerDigits = Math.min(Math.max(0, n2), Integer.MAX_VALUE);
        super.setMaximumIntegerDigits(this.maximumIntegerDigits > 309 ? 309 : this.maximumIntegerDigits);
        if (this.minimumIntegerDigits > this.maximumIntegerDigits) {
            this.minimumIntegerDigits = this.maximumIntegerDigits;
            super.setMinimumIntegerDigits(this.minimumIntegerDigits > 309 ? 309 : this.minimumIntegerDigits);
        }
    }

    @Override
    public void setMinimumIntegerDigits(int n2) {
        this.minimumIntegerDigits = Math.min(Math.max(0, n2), Integer.MAX_VALUE);
        super.setMinimumIntegerDigits(this.minimumIntegerDigits > 309 ? 309 : this.minimumIntegerDigits);
        if (this.minimumIntegerDigits > this.maximumIntegerDigits) {
            this.maximumIntegerDigits = this.minimumIntegerDigits;
            super.setMaximumIntegerDigits(this.maximumIntegerDigits > 309 ? 309 : this.maximumIntegerDigits);
        }
    }

    @Override
    public void setMaximumFractionDigits(int n2) {
        this.maximumFractionDigits = Math.min(Math.max(0, n2), Integer.MAX_VALUE);
        super.setMaximumFractionDigits(this.maximumFractionDigits > 340 ? 340 : this.maximumFractionDigits);
        if (this.minimumFractionDigits > this.maximumFractionDigits) {
            this.minimumFractionDigits = this.maximumFractionDigits;
            super.setMinimumFractionDigits(this.minimumFractionDigits > 340 ? 340 : this.minimumFractionDigits);
        }
    }

    @Override
    public void setMinimumFractionDigits(int n2) {
        this.minimumFractionDigits = Math.min(Math.max(0, n2), Integer.MAX_VALUE);
        super.setMinimumFractionDigits(this.minimumFractionDigits > 340 ? 340 : this.minimumFractionDigits);
        if (this.minimumFractionDigits > this.maximumFractionDigits) {
            this.maximumFractionDigits = this.minimumFractionDigits;
            super.setMaximumFractionDigits(this.maximumFractionDigits > 340 ? 340 : this.maximumFractionDigits);
        }
    }

    @Override
    public int getMaximumIntegerDigits() {
        return this.maximumIntegerDigits;
    }

    @Override
    public int getMinimumIntegerDigits() {
        return this.minimumIntegerDigits;
    }

    @Override
    public int getMaximumFractionDigits() {
        return this.maximumFractionDigits;
    }

    @Override
    public int getMinimumFractionDigits() {
        return this.minimumFractionDigits;
    }

    @Override
    public Currency getCurrency() {
        return this.symbols.getCurrency();
    }

    @Override
    public void setCurrency(Currency currency) {
        if (f.ifAcmp((Object)currency, (Object)this.symbols.getCurrency())) {
            this.symbols.setCurrency(currency);
            if (this.isCurrencyFormat) {
                this.expandAffixes();
            }
        }
    }

    @Override
    public RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    @Override
    public void setRoundingMode(RoundingMode roundingMode) {
        if (roundingMode == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        this.roundingMode = roundingMode;
        this.digitList.setRoundingMode(roundingMode);
    }

    void adjustForCurrencyDefaultFractionDigits() {
        int n2;
        Currency currency = this.symbols.getCurrency();
        if (currency == null) {
            try {
                currency = Currency.getInstance(this.symbols.getInternationalCurrencySymbol());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (currency != null && (n2 = currency.getDefaultFractionDigits()) != -1) {
            int n3 = this.getMinimumFractionDigits();
            if (n3 == this.getMaximumFractionDigits()) {
                this.setMinimumFractionDigits(n2);
                this.setMaximumFractionDigits(n2);
            } else {
                this.setMinimumFractionDigits(Math.min(n2, n3));
                this.setMaximumFractionDigits(n2);
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.digitList = new DigitList();
        if (this.serialVersionOnStream < 4) {
            this.setRoundingMode(RoundingMode.HALF_EVEN);
        }
        if (super.getMaximumIntegerDigits() > 309 || super.getMaximumFractionDigits() > 340) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidObjectException("Digit count out of range"));
        }
        if (this.serialVersionOnStream < 3) {
            this.setMaximumIntegerDigits(super.getMaximumIntegerDigits());
            this.setMinimumIntegerDigits(super.getMinimumIntegerDigits());
            this.setMaximumFractionDigits(super.getMaximumFractionDigits());
            this.setMinimumFractionDigits(super.getMinimumFractionDigits());
        }
        if (this.serialVersionOnStream < 1) {
            this.useExponentialNotation = false;
        }
        this.serialVersionOnStream = 4;
    }

    protected /* synthetic */ DecimalFormat(h h2) {
        super(h2);
    }
}

