/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.j;
import com.zeroturnaround.jrebelbase.h;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

final class DigitList
extends h
implements Cloneable {
    public static final int MAX_COUNT = 19;
    public int decimalAt = 0;
    public int count = 0;
    public char[] digits = new char[19];
    private char[] data;
    private RoundingMode roundingMode = RoundingMode.HALF_EVEN;
    private boolean isNegative = false;
    private static final char[] LONG_MIN_REP = "9223372036854775808".toCharArray();
    private StringBuffer tempBuffer;

    DigitList() {
    }

    boolean isZero() {
        for (int i = 0; i < this.count; ++i) {
            if (this.digits[i] == '0') continue;
            return false;
        }
        return true;
    }

    void setRoundingMode(RoundingMode roundingMode) {
        this.roundingMode = roundingMode;
    }

    public void clear() {
        this.decimalAt = 0;
        this.count = 0;
    }

    public void append(char c2) {
        if (this.count == this.digits.length) {
            char[] cArray = new char[this.count + 100];
            a.arraycopy((Object)this.digits, (int)0, (Object)cArray, (int)0, (int)this.count);
            this.digits = cArray;
        }
        this.digits[this.count++] = c2;
    }

    public final double getDouble() {
        if (this.count == 0) {
            return 0.0;
        }
        StringBuffer stringBuffer = this.getStringBuffer();
        stringBuffer.append('.');
        stringBuffer.append(this.digits, 0, this.count);
        stringBuffer.append('E');
        stringBuffer.append(this.decimalAt);
        return Double.parseDouble(stringBuffer.toString());
    }

    public final long getLong() {
        if (this.count == 0) {
            return 0L;
        }
        if (this.isLongMIN_VALUE()) {
            return Long.MIN_VALUE;
        }
        StringBuffer stringBuffer = this.getStringBuffer();
        stringBuffer.append(this.digits, 0, this.count);
        for (int i = this.count; i < this.decimalAt; ++i) {
            stringBuffer.append('0');
        }
        return Long.parseLong(stringBuffer.toString());
    }

    public final BigDecimal getBigDecimal() {
        if (this.count == 0) {
            if (this.decimalAt == 0) {
                return BigDecimal.ZERO;
            }
            return new BigDecimal("0E" + this.decimalAt);
        }
        if (this.decimalAt == this.count) {
            return new BigDecimal(this.digits, 0, this.count);
        }
        return new BigDecimal(this.digits, 0, this.count).scaleByPowerOfTen(this.decimalAt - this.count);
    }

    boolean fitsIntoLong(boolean bl, boolean bl2) {
        while (this.count > 0 && this.digits[this.count - 1] == '0') {
            --this.count;
        }
        if (this.count == 0) {
            return bl || bl2;
        }
        if (this.decimalAt < this.count || this.decimalAt > 19) {
            return false;
        }
        if (this.decimalAt < 19) {
            return true;
        }
        for (int i = 0; i < this.count; ++i) {
            char c2 = this.digits[i];
            char c3 = LONG_MIN_REP[i];
            if (c2 > c3) {
                return false;
            }
            if (c2 >= c3) continue;
            return true;
        }
        if (this.count < this.decimalAt) {
            return true;
        }
        return !bl;
    }

    public final void set(boolean bl, double d, int n2) {
        this.set(bl, d, n2, true);
    }

    final void set(boolean bl, double d, int n2, boolean bl2) {
        this.set(bl, Double.toString(d), n2, bl2);
    }

    final void set(boolean bl, String string, int n2, boolean bl2) {
        this.isNegative = bl;
        int n3 = string.length();
        char[] cArray = this.getDataChars(n3);
        string.getChars(0, n3, cArray, 0);
        this.decimalAt = -1;
        this.count = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl3 = false;
        int n6 = 0;
        while (n6 < n3) {
            char c2;
            if ((c2 = cArray[n6++]) == '.') {
                this.decimalAt = this.count;
                continue;
            }
            if (c2 == 'e' || c2 == 'E') {
                n4 = DigitList.parseInt(cArray, n6, n3);
                break;
            }
            if (!bl3) {
                boolean bl4 = bl3 = c2 != '0';
                if (!bl3 && this.decimalAt != -1) {
                    ++n5;
                }
            }
            if (!bl3) continue;
            this.digits[this.count++] = c2;
        }
        if (this.decimalAt == -1) {
            this.decimalAt = this.count;
        }
        if (bl3) {
            this.decimalAt += n4 - n5;
        }
        if (bl2) {
            if (-this.decimalAt > n2) {
                this.count = 0;
                return;
            }
            if (-this.decimalAt == n2) {
                if (this.shouldRoundUp(0)) {
                    this.count = 1;
                    ++this.decimalAt;
                    this.digits[0] = 49;
                } else {
                    this.count = 0;
                }
                return;
            }
        }
        while (this.count > 1 && this.digits[this.count - 1] == '0') {
            --this.count;
        }
        this.round(bl2 ? n2 + this.decimalAt : n2);
    }

    private final void round(int n2) {
        if (n2 >= 0 && n2 < this.count) {
            if (this.shouldRoundUp(n2)) {
                do {
                    if (--n2 < 0) {
                        this.digits[0] = 49;
                        ++this.decimalAt;
                        n2 = 0;
                        break;
                    }
                    int n3 = n2;
                    this.digits[n3] = (char)(this.digits[n3] + '\u0001');
                } while (this.digits[n2] > '9');
                ++n2;
            }
            this.count = n2;
            while (this.count > 1 && this.digits[this.count - 1] == '0') {
                --this.count;
            }
        }
    }

    private boolean shouldRoundUp(int n2) {
        if (n2 < this.count) {
            switch (1.$SwitchMap$java$math$RoundingMode[this.roundingMode.ordinal() + 1]) {
                case 1: {
                    for (int i = n2; i < this.count; ++i) {
                        if (this.digits[i] == '0') continue;
                        return true;
                    }
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    for (int i = n2; i < this.count; ++i) {
                        if (this.digits[i] == '0') continue;
                        return !this.isNegative;
                    }
                    break;
                }
                case 4: {
                    for (int i = n2; i < this.count; ++i) {
                        if (this.digits[i] == '0') continue;
                        return this.isNegative;
                    }
                    break;
                }
                case 5: {
                    if (this.digits[n2] < '5') break;
                    return true;
                }
                case 6: {
                    if (this.digits[n2] > '5') {
                        return true;
                    }
                    if (this.digits[n2] != '5') break;
                    for (int i = n2 + 1; i < this.count; ++i) {
                        if (this.digits[i] == '0') continue;
                        return true;
                    }
                    break;
                }
                case 7: {
                    if (this.digits[n2] > '5') {
                        return true;
                    }
                    if (this.digits[n2] != '5') break;
                    for (int i = n2 + 1; i < this.count; ++i) {
                        if (this.digits[i] == '0') continue;
                        return true;
                    }
                    return n2 > 0 && this.digits[n2 - 1] % 2 != 0;
                }
                case 8: {
                    for (int i = n2; i < this.count; ++i) {
                        if (this.digits[i] == '0') continue;
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ArithmeticException("Rounding needed with the rounding mode being set to RoundingMode.UNNECESSARY"));
                    }
                    break;
                }
                default: {
                    if ($assertionsDisabled) break;
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
            }
        }
        return false;
    }

    public final void set(boolean bl, long l) {
        this.set(bl, l, 0);
    }

    public final void set(boolean bl, long l, int n2) {
        this.isNegative = bl;
        if (l <= 0L) {
            if (l == Long.MIN_VALUE) {
                this.count = 19;
                this.decimalAt = 19;
                a.arraycopy((Object)LONG_MIN_REP, (int)0, (Object)this.digits, (int)0, (int)this.count);
            } else {
                this.count = 0;
                this.decimalAt = 0;
            }
        } else {
            int n3 = 19;
            while (l > 0L) {
                this.digits[--n3] = (char)(48L + l % 10L);
                l /= 10L;
            }
            this.decimalAt = 19 - n3;
            int n4 = 18;
            while (this.digits[n4] == '0') {
                --n4;
            }
            this.count = n4 - n3 + 1;
            a.arraycopy((Object)this.digits, (int)n3, (Object)this.digits, (int)0, (int)this.count);
        }
        if (n2 > 0) {
            this.round(n2);
        }
    }

    final void set(boolean bl, BigDecimal bigDecimal, int n2, boolean bl2) {
        String string = bigDecimal.toString();
        this.extendDigits(string.length());
        this.set(bl, string, n2, bl2);
    }

    final void set(boolean bl, BigInteger bigInteger, int n2) {
        int n3;
        this.isNegative = bl;
        String string = bigInteger.toString();
        int n4 = string.length();
        this.extendDigits(n4);
        string.getChars(0, n4, this.digits, 0);
        this.decimalAt = n4;
        for (n3 = n4 - 1; n3 >= 0 && this.digits[n3] == '0'; --n3) {
        }
        this.count = n3 + 1;
        if (n2 > 0) {
            this.round(n2);
        }
    }

    public boolean equals(Object object) {
        if (!f.ifAcmp((Object)this, (Object)object)) {
            return true;
        }
        if (!(object instanceof DigitList)) {
            return false;
        }
        DigitList digitList = (DigitList)object;
        if (this.count != digitList.count || this.decimalAt != digitList.decimalAt) {
            return false;
        }
        for (int i = 0; i < this.count; ++i) {
            if (this.digits[i] == digitList.digits[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = this.decimalAt;
        for (int i = 0; i < this.count; ++i) {
            n2 = n2 * 37 + this.digits[i];
        }
        return n2;
    }

    public Object clone() {
        try {
            DigitList digitList = (DigitList)super.clone();
            char[] cArray = new char[this.digits.length];
            a.arraycopy((Object)this.digits, (int)0, (Object)cArray, (int)0, (int)this.digits.length);
            digitList.digits = cArray;
            digitList.tempBuffer = null;
            return digitList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
        }
    }

    private boolean isLongMIN_VALUE() {
        if (this.decimalAt != this.count || this.count != 19) {
            return false;
        }
        for (int i = 0; i < this.count; ++i) {
            if (this.digits[i] == LONG_MIN_REP[i]) continue;
            return false;
        }
        return true;
    }

    private static final int parseInt(char[] cArray, int n2, int n3) {
        boolean bl = true;
        char c2 = cArray[n2];
        if (c2 == '-') {
            bl = false;
            ++n2;
        } else if (c2 == '+') {
            ++n2;
        }
        int n4 = 0;
        while (n2 < n3 && (c2 = cArray[n2++]) >= '0' && c2 <= '9') {
            n4 = n4 * 10 + (c2 - 48);
        }
        return bl ? n4 : -n4;
    }

    public String toString() {
        if (this.isZero()) {
            return "0";
        }
        StringBuffer stringBuffer = this.getStringBuffer();
        stringBuffer.append("0.");
        stringBuffer.append(this.digits, 0, this.count);
        stringBuffer.append("x10^");
        stringBuffer.append(this.decimalAt);
        return stringBuffer.toString();
    }

    private StringBuffer getStringBuffer() {
        if (this.tempBuffer == null) {
            this.tempBuffer = new StringBuffer(19);
        } else {
            this.tempBuffer.setLength(0);
        }
        return this.tempBuffer;
    }

    private void extendDigits(int n2) {
        if (n2 > this.digits.length) {
            this.digits = new char[n2];
        }
    }

    private final char[] getDataChars(int n2) {
        if (this.data == null || this.data.length < n2) {
            this.data = new char[n2];
        }
        return this.data;
    }

    public static /* synthetic */ int _jr$ig$decimalAt(Object object) {
        return ((DigitList)object).decimalAt;
    }

    public static /* synthetic */ void _jr$ip$decimalAt(Object object, int n2) {
        ((DigitList)object).decimalAt = n2;
    }

    public static /* synthetic */ int _jr$ig$count(Object object) {
        return ((DigitList)object).count;
    }

    public static /* synthetic */ void _jr$ip$count(Object object, int n2) {
        ((DigitList)object).count = n2;
    }

    public static /* synthetic */ char[] _jr$ig$digits(Object object) {
        return ((DigitList)object).digits;
    }

    public static /* synthetic */ void _jr$ip$digits(Object object, char[] cArray) {
        ((DigitList)object).digits = cArray;
    }

    private static /* synthetic */ char[] _jr$ig$data(DigitList digitList) {
        return digitList.data;
    }

    private static /* synthetic */ void _jr$ip$data(DigitList digitList, char[] cArray) {
        digitList.data = cArray;
    }

    private static /* synthetic */ RoundingMode _jr$ig$roundingMode(DigitList digitList) {
        return digitList.roundingMode;
    }

    private static /* synthetic */ void _jr$ip$roundingMode(DigitList digitList, RoundingMode roundingMode) {
        digitList.roundingMode = roundingMode;
    }

    private static /* synthetic */ boolean _jr$ig$isNegative(DigitList digitList) {
        return digitList.isNegative;
    }

    private static /* synthetic */ void _jr$ip$isNegative(DigitList digitList, boolean bl) {
        digitList.isNegative = bl;
    }

    private static /* synthetic */ StringBuffer _jr$ig$tempBuffer(DigitList digitList) {
        return digitList.tempBuffer;
    }

    private static /* synthetic */ void _jr$ip$tempBuffer(DigitList digitList, StringBuffer stringBuffer) {
        digitList.tempBuffer = stringBuffer;
    }

    static class 1
    extends h {
        static final /* synthetic */ int[] $SwitchMap$java$math$RoundingMode;

        static {
            RoundingMode[] roundingModeArray = RoundingMode.values();
            j.registerSwitchClass(1.class, RoundingMode.class, null);
            int[] nArray = new int[roundingModeArray.length + 1];
            nArray[0] = -1;
            $SwitchMap$java$math$RoundingMode = nArray;
            try {
                1.$SwitchMap$java$math$RoundingMode[RoundingMode.UP.ordinal() + 1] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$java$math$RoundingMode[RoundingMode.DOWN.ordinal() + 1] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$java$math$RoundingMode[RoundingMode.CEILING.ordinal() + 1] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$java$math$RoundingMode[RoundingMode.FLOOR.ordinal() + 1] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$java$math$RoundingMode[RoundingMode.HALF_UP.ordinal() + 1] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$java$math$RoundingMode[RoundingMode.HALF_DOWN.ordinal() + 1] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$java$math$RoundingMode[RoundingMode.HALF_EVEN.ordinal() + 1] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$java$math$RoundingMode[RoundingMode.UNNECESSARY.ordinal() + 1] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }

        public static /* synthetic */ void _jr$$rebel_clinit() {
            RoundingMode[] roundingModeArray = RoundingMode.values();
            j.registerSwitchClass(1.class, RoundingMode.class, null);
            int[] nArray = new int[roundingModeArray.length + 1];
            nArray[0] = -1;
            j.updateSwitchMap((int[])nArray, 1.class, (String)"$SwitchMap$java$math$RoundingMode");
            try {
                1.$SwitchMap$java$math$RoundingMode[RoundingMode.UP.ordinal() + 1] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$java$math$RoundingMode[RoundingMode.DOWN.ordinal() + 1] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$java$math$RoundingMode[RoundingMode.CEILING.ordinal() + 1] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$java$math$RoundingMode[RoundingMode.FLOOR.ordinal() + 1] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$java$math$RoundingMode[RoundingMode.HALF_UP.ordinal() + 1] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$java$math$RoundingMode[RoundingMode.HALF_DOWN.ordinal() + 1] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$java$math$RoundingMode[RoundingMode.HALF_EVEN.ordinal() + 1] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$java$math$RoundingMode[RoundingMode.UNNECESSARY.ordinal() + 1] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }

        protected /* synthetic */ 1(h h2) {
            super(h2);
        }
    }
}

