/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.facade.x;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.text.AttributedCharacterIterator;
import java.text.CalendarBuilder;
import java.text.CharacterIteratorFieldDelegate;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DontCareFieldPosition;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import sun.util.calendar.CalendarUtils;
import sun.util.calendar.ZoneInfoFile;
import sun.util.resources.LocaleData;

public class SimpleDateFormat
extends DateFormat {
    static final long serialVersionUID = 4774881970558875024L;
    static final int currentSerialVersion = 1;
    private int serialVersionOnStream;
    private String pattern;
    private transient NumberFormat originalNumberFormat;
    private transient String originalNumberPattern;
    private transient char minusSign;
    private transient boolean hasFollowingMinusSign;
    private transient char[] compiledPattern;
    private static final int TAG_QUOTE_ASCII_CHAR = 100;
    private static final int TAG_QUOTE_CHARS = 101;
    private transient char zeroDigit;
    private DateFormatSymbols formatData;
    private Date defaultCenturyStart;
    private transient int defaultCenturyStartYear;
    private static final int MILLIS_PER_MINUTE = 60000;
    private static final String GMT = "GMT";
    private static final ConcurrentMap<Locale, String[]> cachedLocaleData = new ConcurrentHashMap<Locale, String[]>(3);
    private static final ConcurrentMap<Locale, NumberFormat> cachedNumberFormatData = new ConcurrentHashMap<Locale, NumberFormat>(3);
    private Locale locale;
    transient boolean useDateFormatSymbols;
    private static final int[] PATTERN_INDEX_TO_CALENDAR_FIELD = new int[]{0, 1, 2, 5, 11, 11, 12, 13, 14, 7, 6, 8, 3, 4, 9, 10, 10, 15, 15, 17, 1000, 15};
    private static final int[] PATTERN_INDEX_TO_DATE_FORMAT_FIELD = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 17, 1, 9, 17};
    private static final DateFormat.Field[] PATTERN_INDEX_TO_DATE_FORMAT_FIELD_ID;

    public SimpleDateFormat() {
        this(3, 3, Locale.getDefault(Locale.Category.FORMAT));
    }

    public SimpleDateFormat(String string) {
        this(string, Locale.getDefault(Locale.Category.FORMAT));
    }

    public SimpleDateFormat(String string, Locale locale) {
        this.serialVersionOnStream = 1;
        this.minusSign = (char)45;
        this.hasFollowingMinusSign = false;
        if (string == null || locale == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        this.initializeCalendar(locale);
        this.pattern = string;
        this.formatData = DateFormatSymbols.getInstanceRef(locale);
        this.locale = locale;
        this.initialize(locale);
    }

    public SimpleDateFormat(String string, DateFormatSymbols dateFormatSymbols) {
        this.serialVersionOnStream = 1;
        this.minusSign = (char)45;
        this.hasFollowingMinusSign = false;
        if (string == null || dateFormatSymbols == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        this.pattern = string;
        this.formatData = (DateFormatSymbols)g.convertForCast((Object)dateFormatSymbols.clone(), DateFormatSymbols.class);
        this.locale = Locale.getDefault(Locale.Category.FORMAT);
        this.initializeCalendar(this.locale);
        this.initialize(this.locale);
        this.useDateFormatSymbols = true;
    }

    SimpleDateFormat(int n2, int n3, Locale locale) {
        Object[] objectArray;
        this.serialVersionOnStream = 1;
        this.minusSign = (char)45;
        this.hasFollowingMinusSign = false;
        if (locale == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        this.locale = locale;
        this.initializeCalendar(locale);
        String[] stringArray = (String[])cachedLocaleData.get(locale);
        if (stringArray == null) {
            objectArray = LocaleData.getDateFormatData(locale);
            if (!this.isGregorianCalendar()) {
                try {
                    stringArray = objectArray.getStringArray(this.getCalendarName() + ".DateTimePatterns");
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            if (stringArray == null) {
                stringArray = objectArray.getStringArray("DateTimePatterns");
            }
            cachedLocaleData.putIfAbsent(locale, stringArray);
        }
        this.formatData = DateFormatSymbols.getInstanceRef(locale);
        if (n2 >= 0 && n3 >= 0) {
            Object[] objectArray2 = new Object[2];
            a.arrayStore((Object[])objectArray2, (int)0, (Object)stringArray[n2]);
            a.arrayStore((Object[])objectArray2, (int)1, (Object)stringArray[n3 + 4]);
            objectArray = objectArray2;
            this.pattern = MessageFormat.format(stringArray[8], objectArray);
        } else if (n2 >= 0) {
            this.pattern = stringArray[n2];
        } else if (n3 >= 0) {
            this.pattern = stringArray[n3 + 4];
        } else {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("No date or time style specified"));
        }
        this.initialize(locale);
    }

    private void initialize(Locale locale) {
        this.compiledPattern = this.compile(this.pattern);
        SimpleDateFormat._jr$ip$numberFormat(this, (NumberFormat)g.convertForCast(cachedNumberFormatData.get(locale), NumberFormat.class));
        if (SimpleDateFormat._jr$ig$numberFormat(this) == null) {
            SimpleDateFormat._jr$ip$numberFormat(this, NumberFormat.getIntegerInstance(locale));
            SimpleDateFormat._jr$ig$numberFormat(this).setGroupingUsed(false);
            cachedNumberFormatData.putIfAbsent(locale, SimpleDateFormat._jr$ig$numberFormat(this));
        }
        SimpleDateFormat._jr$ip$numberFormat(this, (NumberFormat)g.convertForCast((Object)SimpleDateFormat._jr$ig$numberFormat(this).clone(), NumberFormat.class));
        this.initializeDefaultCentury();
    }

    private void initializeCalendar(Locale locale) {
        if (SimpleDateFormat._jr$ig$calendar(this) == null) {
            if (!$assertionsDisabled && locale == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            SimpleDateFormat._jr$ip$calendar(this, Calendar.getInstance(TimeZone.getDefault(), locale));
        }
    }

    private char[] compile(String string) {
        int n2;
        int n3 = string.length();
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder(n3 * 2);
        StringBuilder stringBuilder2 = null;
        int n4 = 0;
        int n5 = -1;
        for (n2 = 0; n2 < n3; ++n2) {
            char c2;
            int n6;
            char c3 = string.charAt(n2);
            if (c3 == '\'') {
                if (n2 + 1 < n3 && (c3 = string.charAt(n2 + 1)) == '\'') {
                    ++n2;
                    if (n4 != 0) {
                        SimpleDateFormat.encode(n5, n4, stringBuilder);
                        n5 = -1;
                        n4 = 0;
                    }
                    if (bl) {
                        stringBuilder2.append(c3);
                        continue;
                    }
                    stringBuilder.append((char)(0x6400 | c3));
                    continue;
                }
                if (!bl) {
                    if (n4 != 0) {
                        SimpleDateFormat.encode(n5, n4, stringBuilder);
                        n5 = -1;
                        n4 = 0;
                    }
                    if (stringBuilder2 == null) {
                        stringBuilder2 = new StringBuilder(n3);
                    } else {
                        stringBuilder2.setLength(0);
                    }
                    bl = true;
                    continue;
                }
                n6 = stringBuilder2.length();
                if (n6 == 1) {
                    c2 = stringBuilder2.charAt(0);
                    if (c2 < '\u0080') {
                        stringBuilder.append((char)(0x6400 | c2));
                    } else {
                        stringBuilder.append('\u6501');
                        stringBuilder.append(c2);
                    }
                } else {
                    SimpleDateFormat.encode(101, n6, stringBuilder);
                    stringBuilder.append((CharSequence)stringBuilder2);
                }
                bl = false;
                continue;
            }
            if (bl) {
                stringBuilder2.append(c3);
                continue;
            }
            if (!(c3 >= 'a' && c3 <= 'z' || c3 >= 'A' && c3 <= 'Z')) {
                if (n4 != 0) {
                    SimpleDateFormat.encode(n5, n4, stringBuilder);
                    n5 = -1;
                    n4 = 0;
                }
                if (c3 < '\u0080') {
                    stringBuilder.append((char)(0x6400 | c3));
                    continue;
                }
                for (n6 = n2 + 1; !(n6 >= n3 || (c2 = string.charAt(n6)) == '\'' || c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z'); ++n6) {
                }
                stringBuilder.append((char)(0x6500 | n6 - n2));
                while (n2 < n6) {
                    stringBuilder.append(string.charAt(n2));
                    ++n2;
                }
                --n2;
                continue;
            }
            n6 = "GyMdkHmsSEDFwWahKzZYuX".indexOf(c3);
            if (n6 == -1) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Illegal pattern character '" + c3 + "'"));
            }
            if (n5 == -1 || n5 == n6) {
                n5 = n6;
                ++n4;
                continue;
            }
            SimpleDateFormat.encode(n5, n4, stringBuilder);
            n5 = n6;
            n4 = 1;
        }
        if (bl) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Unterminated quote"));
        }
        if (n4 != 0) {
            SimpleDateFormat.encode(n5, n4, stringBuilder);
        }
        n2 = stringBuilder.length();
        char[] cArray = new char[n2];
        stringBuilder.getChars(0, n2, cArray, 0);
        return cArray;
    }

    private static final void encode(int n2, int n3, StringBuilder stringBuilder) {
        if (n2 == 21 && n3 >= 4) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("invalid ISO 8601 format: length=" + n3));
        }
        if (n3 < 255) {
            stringBuilder.append((char)(n2 << 8 | n3));
        } else {
            stringBuilder.append((char)(n2 << 8 | 0xFF));
            stringBuilder.append((char)(n3 >>> 16));
            stringBuilder.append((char)(n3 & 0xFFFF));
        }
    }

    private void initializeDefaultCentury() {
        SimpleDateFormat._jr$ig$calendar(this).setTimeInMillis(System.currentTimeMillis());
        SimpleDateFormat._jr$ig$calendar(this).add(1, -80);
        this.parseAmbiguousDatesAsAfter(SimpleDateFormat._jr$ig$calendar(this).getTime());
    }

    private void parseAmbiguousDatesAsAfter(Date date) {
        this.defaultCenturyStart = date;
        SimpleDateFormat._jr$ig$calendar(this).setTime(date);
        this.defaultCenturyStartYear = SimpleDateFormat._jr$ig$calendar(this).get(1);
    }

    public void set2DigitYearStart(Date date) {
        this.parseAmbiguousDatesAsAfter(new Date(date.getTime()));
    }

    public Date get2DigitYearStart() {
        return (Date)g.convertForCast((Object)this.defaultCenturyStart.clone(), Date.class);
    }

    @Override
    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        FieldPosition._jr$ip$endIndex((Object)fieldPosition, 0);
        FieldPosition._jr$ip$beginIndex((Object)fieldPosition, 0);
        return this.format(date, stringBuffer, fieldPosition.getFieldDelegate());
    }

    private StringBuffer format(Date date, StringBuffer stringBuffer, Format.FieldDelegate fieldDelegate) {
        SimpleDateFormat._jr$ig$calendar(this).setTime(date);
        boolean bl = this.useDateFormatSymbols();
        int n2 = 0;
        block4: while (n2 < this.compiledPattern.length) {
            int n3 = this.compiledPattern[n2] >>> 8;
            int n4 = this.compiledPattern[n2++] & 0xFF;
            if (n4 == 255) {
                n4 = this.compiledPattern[n2++] << 16;
                n4 |= this.compiledPattern[n2++];
            }
            switch (n3) {
                case 100: {
                    stringBuffer.append((char)n4);
                    continue block4;
                }
                case 101: {
                    stringBuffer.append(this.compiledPattern, n2, n4);
                    n2 += n4;
                    continue block4;
                }
            }
            this.subFormat(n3, n4, fieldDelegate, stringBuffer, bl);
        }
        return stringBuffer;
    }

    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        CharacterIteratorFieldDelegate characterIteratorFieldDelegate = new CharacterIteratorFieldDelegate();
        if (g.convertForInstanceOf((Object)object, Date.class) instanceof Date) {
            this.format((Date)g.convertForCast((Object)object, Date.class), stringBuffer, characterIteratorFieldDelegate);
        } else if (g.convertForInstanceOf((Object)object, Number.class) instanceof Number) {
            this.format(new Date(((Number)g.convertForCast((Object)object, Number.class)).longValue()), stringBuffer, characterIteratorFieldDelegate);
        } else {
            if (object == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("formatToCharacterIterator must be passed non-null object"));
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Cannot format given Object as a Date"));
        }
        return characterIteratorFieldDelegate.getIterator(stringBuffer.toString());
    }

    private void subFormat(int n2, int n3, Format.FieldDelegate fieldDelegate, StringBuffer stringBuffer, boolean bl) {
        int n4;
        int n5;
        int n6 = Integer.MAX_VALUE;
        String string = null;
        int n7 = stringBuffer.length();
        int n8 = PATTERN_INDEX_TO_CALENDAR_FIELD[n2];
        if (n8 == 17) {
            if (SimpleDateFormat._jr$ig$calendar(this).isWeekDateSupported()) {
                n5 = SimpleDateFormat._jr$ig$calendar(this).getWeekYear();
            } else {
                n2 = 1;
                n8 = PATTERN_INDEX_TO_CALENDAR_FIELD[n2];
                n5 = SimpleDateFormat._jr$ig$calendar(this).get(n8);
            }
        } else {
            n5 = n8 == 1000 ? CalendarBuilder.toISODayOfWeek(SimpleDateFormat._jr$ig$calendar(this).get(7)) : SimpleDateFormat._jr$ig$calendar(this).get(n8);
        }
        int n9 = n4 = n3 >= 4 ? 2 : 1;
        if (!bl && n8 != 1000) {
            string = SimpleDateFormat._jr$ig$calendar(this).getDisplayName(n8, n4, this.locale);
        }
        switch (n2) {
            case 0: {
                String[] stringArray;
                if (bl && n5 < (stringArray = this.formatData.getEras()).length) {
                    string = stringArray[n5];
                }
                if (string != null) break;
                string = "";
                break;
            }
            case 1: 
            case 19: {
                if (g.convertForInstanceOf((Object)SimpleDateFormat._jr$ig$calendar(this), GregorianCalendar.class) instanceof GregorianCalendar) {
                    if (n3 != 2) {
                        this.zeroPaddingNumber(n5, n3, n6, stringBuffer);
                        break;
                    }
                    this.zeroPaddingNumber(n5, 2, 2, stringBuffer);
                    break;
                }
                if (string != null) break;
                this.zeroPaddingNumber(n5, n4 == 2 ? 1 : n3, n6, stringBuffer);
                break;
            }
            case 2: {
                if (bl) {
                    String[] stringArray;
                    if (n3 >= 4) {
                        stringArray = this.formatData.getMonths();
                        string = stringArray[n5];
                    } else if (n3 == 3) {
                        stringArray = this.formatData.getShortMonths();
                        string = stringArray[n5];
                    }
                } else if (n3 < 3) {
                    string = null;
                }
                if (string != null) break;
                this.zeroPaddingNumber(n5 + 1, n3, n6, stringBuffer);
                break;
            }
            case 4: {
                if (string != null) break;
                if (n5 == 0) {
                    this.zeroPaddingNumber(SimpleDateFormat._jr$ig$calendar(this).getMaximum(11) + 1, n3, n6, stringBuffer);
                    break;
                }
                this.zeroPaddingNumber(n5, n3, n6, stringBuffer);
                break;
            }
            case 9: {
                String[] stringArray;
                if (!bl) break;
                if (n3 >= 4) {
                    stringArray = this.formatData.getWeekdays();
                    string = stringArray[n5];
                    break;
                }
                stringArray = this.formatData.getShortWeekdays();
                string = stringArray[n5];
                break;
            }
            case 14: {
                if (!bl) break;
                String[] stringArray = this.formatData.getAmPmStrings();
                string = stringArray[n5];
                break;
            }
            case 15: {
                if (string != null) break;
                if (n5 == 0) {
                    this.zeroPaddingNumber(SimpleDateFormat._jr$ig$calendar(this).getLeastMaximum(10) + 1, n3, n6, stringBuffer);
                    break;
                }
                this.zeroPaddingNumber(n5, n3, n6, stringBuffer);
                break;
            }
            case 17: {
                int n10;
                if (string != null) break;
                if (DateFormatSymbols._jr$ig$locale(this.formatData) == null || DateFormatSymbols._jr$ig$isZoneStringsSet(this.formatData)) {
                    int n11 = this.formatData.getZoneIndex(SimpleDateFormat._jr$ig$calendar(this).getTimeZone().getID());
                    if (n11 == -1) {
                        n5 = SimpleDateFormat._jr$ig$calendar(this).get(15) + SimpleDateFormat._jr$ig$calendar(this).get(16);
                        stringBuffer.append(ZoneInfoFile.toCustomID(n5));
                        break;
                    }
                    int n12 = n10 = SimpleDateFormat._jr$ig$calendar(this).get(16) == 0 ? 1 : 3;
                    if (n3 < 4) {
                        ++n10;
                    }
                    String[][] stringArray = this.formatData.getZoneStringsWrapper();
                    stringBuffer.append(stringArray[n11][n10]);
                    break;
                }
                TimeZone timeZone = SimpleDateFormat._jr$ig$calendar(this).getTimeZone();
                n10 = SimpleDateFormat._jr$ig$calendar(this).get(16) != 0 ? 1 : 0;
                int n13 = n3 < 4 ? 0 : 1;
                stringBuffer.append(timeZone.getDisplayName(n10 != 0, n13, DateFormatSymbols._jr$ig$locale(this.formatData)));
                break;
            }
            case 18: {
                n5 = (SimpleDateFormat._jr$ig$calendar(this).get(15) + SimpleDateFormat._jr$ig$calendar(this).get(16)) / 60000;
                int n14 = 4;
                if (n5 >= 0) {
                    stringBuffer.append('+');
                } else {
                    ++n14;
                }
                int n10 = n5 / 60 * 100 + n5 % 60;
                CalendarUtils.sprintf0d(stringBuffer, n10, n14);
                break;
            }
            case 21: {
                n5 = SimpleDateFormat._jr$ig$calendar(this).get(15) + SimpleDateFormat._jr$ig$calendar(this).get(16);
                if (n5 == 0) {
                    stringBuffer.append('Z');
                    break;
                }
                if ((n5 /= 60000) >= 0) {
                    stringBuffer.append('+');
                } else {
                    stringBuffer.append('-');
                    n5 = -n5;
                }
                CalendarUtils.sprintf0d(stringBuffer, n5 / 60, 2);
                if (n3 == 1) break;
                if (n3 == 3) {
                    stringBuffer.append(':');
                }
                CalendarUtils.sprintf0d(stringBuffer, n5 % 60, 2);
                break;
            }
            default: {
                if (string != null) break;
                this.zeroPaddingNumber(n5, n3, n6, stringBuffer);
            }
        }
        if (string != null) {
            stringBuffer.append(string);
        }
        int n15 = PATTERN_INDEX_TO_DATE_FORMAT_FIELD[n2];
        DateFormat.Field field = (DateFormat.Field)g.convertForCast((Object)a.arrayLoad((Object[])PATTERN_INDEX_TO_DATE_FORMAT_FIELD_ID, (int)n2), DateFormat.Field.class);
        fieldDelegate.formatted(n15, field, field, n7, stringBuffer.length(), stringBuffer);
    }

    private final void zeroPaddingNumber(int n2, int n3, int n4, StringBuffer stringBuffer) {
        try {
            if (this.zeroDigit == '\u0000') {
                this.zeroDigit = ((DecimalFormat)g.convertForCast((Object)SimpleDateFormat._jr$ig$numberFormat(this), DecimalFormat.class)).getDecimalFormatSymbols().getZeroDigit();
            }
            if (n2 >= 0) {
                if (n2 < 100 && n3 >= 1 && n3 <= 2) {
                    if (n2 < 10) {
                        if (n3 == 2) {
                            stringBuffer.append(this.zeroDigit);
                        }
                        stringBuffer.append((char)(this.zeroDigit + n2));
                    } else {
                        stringBuffer.append((char)(this.zeroDigit + n2 / 10));
                        stringBuffer.append((char)(this.zeroDigit + n2 % 10));
                    }
                    return;
                }
                if (n2 >= 1000 && n2 < 10000) {
                    if (n3 == 4) {
                        stringBuffer.append((char)(this.zeroDigit + n2 / 1000));
                        stringBuffer.append((char)(this.zeroDigit + (n2 %= 1000) / 100));
                        stringBuffer.append((char)(this.zeroDigit + (n2 %= 100) / 10));
                        stringBuffer.append((char)(this.zeroDigit + n2 % 10));
                        return;
                    }
                    if (n3 == 2 && n4 == 2) {
                        this.zeroPaddingNumber(n2 % 100, 2, 2, stringBuffer);
                        return;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        SimpleDateFormat._jr$ig$numberFormat(this).setMinimumIntegerDigits(n3);
        SimpleDateFormat._jr$ig$numberFormat(this).setMaximumIntegerDigits(n4);
        SimpleDateFormat._jr$ig$numberFormat(this).format(n2, stringBuffer, DontCareFieldPosition.INSTANCE);
    }

    @Override
    public Date parse(String string, ParsePosition parsePosition) {
        Date date;
        int n2;
        this.checkNegativeNumberExpression();
        int n3 = n2 = ParsePosition._jr$ig$index((Object)parsePosition);
        int n4 = string.length();
        boolean[] blArray = new boolean[]{false};
        CalendarBuilder calendarBuilder = new CalendarBuilder();
        int n5 = 0;
        block6: while (n5 < this.compiledPattern.length) {
            int n6 = this.compiledPattern[n5] >>> 8;
            int n7 = this.compiledPattern[n5++] & 0xFF;
            if (n7 == 255) {
                n7 = this.compiledPattern[n5++] << 16;
                n7 |= this.compiledPattern[n5++];
            }
            switch (n6) {
                case 100: {
                    if (n2 >= n4 || string.charAt(n2) != (char)n7) {
                        ParsePosition._jr$ip$index((Object)parsePosition, (int)n3);
                        ParsePosition._jr$ip$errorIndex((Object)parsePosition, (int)n2);
                        return null;
                    }
                    ++n2;
                    continue block6;
                }
                case 101: {
                    while (n7-- > 0) {
                        if (n2 >= n4 || string.charAt(n2) != this.compiledPattern[n5++]) {
                            ParsePosition._jr$ip$index((Object)parsePosition, (int)n3);
                            ParsePosition._jr$ip$errorIndex((Object)parsePosition, (int)n2);
                            return null;
                        }
                        ++n2;
                    }
                    continue block6;
                }
            }
            boolean bl = false;
            boolean bl2 = false;
            if (n5 < this.compiledPattern.length) {
                int n8;
                int n9 = this.compiledPattern[n5] >>> 8;
                if (n9 != 100 && n9 != 101) {
                    bl = true;
                }
                if (this.hasFollowingMinusSign && (n9 == 100 || n9 == 101) && (n8 = n9 == 100 ? this.compiledPattern[n5] & 0xFF : this.compiledPattern[n5 + 1]) == this.minusSign) {
                    bl2 = true;
                }
            }
            if ((n2 = this.subParse(string, n2, n6, n7, bl, blArray, parsePosition, bl2, calendarBuilder)) >= 0) continue;
            ParsePosition._jr$ip$index((Object)parsePosition, (int)n3);
            return null;
        }
        ParsePosition._jr$ip$index((Object)parsePosition, (int)n2);
        try {
            date = calendarBuilder.establish(SimpleDateFormat._jr$ig$calendar(this)).getTime();
            if (blArray[0] && date.before(this.defaultCenturyStart)) {
                date = calendarBuilder.addYear(100).establish(SimpleDateFormat._jr$ig$calendar(this)).getTime();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ParsePosition._jr$ip$errorIndex((Object)parsePosition, (int)n2);
            ParsePosition._jr$ip$index((Object)parsePosition, (int)n3);
            return null;
        }
        return date;
    }

    private int matchString(String string, int n2, int n3, String[] stringArray, CalendarBuilder calendarBuilder) {
        int n4 = 0;
        int n5 = stringArray.length;
        if (n3 == 7) {
            n4 = 1;
        }
        int n6 = 0;
        int n7 = -1;
        while (n4 < n5) {
            int n8 = stringArray[n4].length();
            if (n8 > n6 && string.regionMatches(true, n2, stringArray[n4], 0, n8)) {
                n7 = n4;
                n6 = n8;
            }
            ++n4;
        }
        if (n7 >= 0) {
            calendarBuilder.set(n3, n7);
            return n2 + n6;
        }
        return -n2;
    }

    private int matchString(String string, int n2, int n3, Map<String, Integer> map, CalendarBuilder calendarBuilder) {
        if (map != null) {
            String string2 = null;
            for (String string3 : map.keySet()) {
                int n4 = string3.length();
                if (string2 != null && n4 <= string2.length() || !string.regionMatches(true, n2, string3, 0, n4)) continue;
                string2 = string3;
            }
            if (string2 != null) {
                calendarBuilder.set(n3, map.get(string2));
                return n2 + string2.length();
            }
        }
        return -n2;
    }

    private int matchZoneString(String string, int n2, String[] stringArray) {
        for (int i = 1; i <= 4; ++i) {
            String string2 = stringArray[i];
            if (!string.regionMatches(true, n2, string2, 0, string2.length())) continue;
            return i;
        }
        return -1;
    }

    private boolean matchDSTString(String string, int n2, int n3, int n4, String[][] stringArray) {
        int n5 = n4 + 2;
        String string2 = stringArray[n3][n5];
        return string.regionMatches(true, n2, string2, 0, string2.length());
    }

    private int subParseZoneString(String string, int n2, CalendarBuilder calendarBuilder) {
        int n3;
        boolean bl = false;
        TimeZone timeZone = this.getTimeZone();
        int n4 = this.formatData.getZoneIndex(timeZone.getID());
        Object object = null;
        String[][] stringArray = this.formatData.getZoneStringsWrapper();
        String[] stringArray2 = null;
        int n5 = 0;
        if (n4 != -1 && (n5 = this.matchZoneString(string, n2, stringArray2 = stringArray[n4])) > 0) {
            if (n5 <= 2) {
                bl = stringArray2[n5].equalsIgnoreCase(stringArray2[n5 + 2]);
            }
            object = TimeZone.getTimeZone(stringArray2[0]);
        }
        if (object == null && (n4 = this.formatData.getZoneIndex(TimeZone.getDefault().getID())) != -1 && (n5 = this.matchZoneString(string, n2, stringArray2 = stringArray[n4])) > 0) {
            if (n5 <= 2) {
                bl = stringArray2[n5].equalsIgnoreCase(stringArray2[n5 + 2]);
            }
            object = TimeZone.getTimeZone(stringArray2[0]);
        }
        if (object == null) {
            n3 = stringArray.length;
            for (int i = 0; i < n3; ++i) {
                stringArray2 = stringArray[i];
                n5 = this.matchZoneString(string, n2, stringArray2);
                if (n5 <= 0) continue;
                if (n5 <= 2) {
                    bl = stringArray2[n5].equalsIgnoreCase(stringArray2[n5 + 2]);
                }
                object = TimeZone.getTimeZone(stringArray2[0]);
                break;
            }
        }
        if (object != null) {
            if (!object.equals(timeZone)) {
                this.setTimeZone((TimeZone)object);
            }
            int n6 = n3 = n5 >= 3 ? ((TimeZone)object).getDSTSavings() : 0;
            if (!(bl || n5 >= 3 && n3 == 0)) {
                calendarBuilder.clear(15).set(16, n3);
            }
            return n2 + stringArray2[n5].length();
        }
        return 0;
    }

    private int subParseNumericZone(String string, int n2, int n3, int n4, boolean bl, CalendarBuilder calendarBuilder) {
        int n5;
        block7: {
            n5 = n2;
            try {
                char c2 = string.charAt(n5++);
                if (!this.isDigit(c2)) break block7;
                int n6 = c2 - 48;
                if (this.isDigit(c2 = string.charAt(n5++))) {
                    n6 = n6 * 10 + (c2 - 48);
                } else {
                    if (n4 > 0 || !bl) break block7;
                    --n5;
                }
                if (n6 > 23) break block7;
                int n7 = 0;
                if (n4 != 1) {
                    c2 = string.charAt(n5++);
                    if (bl) {
                        if (c2 != ':') break block7;
                        c2 = string.charAt(n5++);
                    }
                    if (!this.isDigit(c2)) break block7;
                    n7 = c2 - 48;
                    if (!this.isDigit(c2 = string.charAt(n5++)) || (n7 = n7 * 10 + (c2 - 48)) > 59) break block7;
                }
                calendarBuilder.set(15, (n7 += n6 * 60) * 60000 * n3).set(16, 0);
                return n5;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return 1 - n5;
    }

    private boolean isDigit(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    private int subParse(String string, int n2, int n3, int n4, boolean bl, boolean[] blArray, ParsePosition parsePosition, boolean bl2, CalendarBuilder calendarBuilder) {
        ParsePosition parsePosition2;
        block54: {
            char c2;
            int n5;
            int n6;
            Number number;
            block52: {
                block56: {
                    block55: {
                        block53: {
                            number = null;
                            n6 = 0;
                            parsePosition2 = new ParsePosition(0);
                            ParsePosition._jr$ip$index((Object)parsePosition2, (int)n2);
                            if (n3 == 19 && !SimpleDateFormat._jr$ig$calendar(this).isWeekDateSupported()) {
                                n3 = 1;
                            }
                            n5 = PATTERN_INDEX_TO_CALENDAR_FIELD[n3];
                            while (true) {
                                if (ParsePosition._jr$ig$index((Object)parsePosition2) >= string.length()) {
                                    ParsePosition._jr$ip$errorIndex((Object)parsePosition, (int)n2);
                                    return -1;
                                }
                                c2 = string.charAt(ParsePosition._jr$ig$index((Object)parsePosition2));
                                if (c2 != ' ' && c2 != '\t') break;
                                ParsePosition parsePosition3 = parsePosition2;
                                ParsePosition._jr$ip$index((Object)parsePosition3, (int)(ParsePosition._jr$ig$index((Object)parsePosition3) + 1));
                            }
                            if (n3 != 4 && n3 != 15 && (n3 != 2 || n4 > 2) && n3 != 1 && n3 != 19) break block52;
                            if (!bl) break block53;
                            if (n2 + n4 > string.length()) break block54;
                            number = SimpleDateFormat._jr$ig$numberFormat(this).parse(string.substring(0, n2 + n4), parsePosition2);
                            break block55;
                        }
                        number = SimpleDateFormat._jr$ig$numberFormat(this).parse(string, parsePosition2);
                    }
                    if (number != null) break block56;
                    if (n3 == 1 && !(g.convertForInstanceOf((Object)SimpleDateFormat._jr$ig$calendar(this), GregorianCalendar.class) instanceof GregorianCalendar)) break block52;
                    break block54;
                }
                n6 = number.intValue();
                if (bl2 && n6 < 0 && (ParsePosition._jr$ig$index((Object)parsePosition2) < string.length() && string.charAt(ParsePosition._jr$ig$index((Object)parsePosition2)) != this.minusSign || ParsePosition._jr$ig$index((Object)parsePosition2) == string.length() && string.charAt(ParsePosition._jr$ig$index((Object)parsePosition2) - 1) == this.minusSign)) {
                    n6 = -n6;
                    ParsePosition parsePosition4 = parsePosition2;
                    ParsePosition._jr$ip$index((Object)parsePosition4, (int)(ParsePosition._jr$ig$index((Object)parsePosition4) - 1));
                }
            }
            c2 = (char)(this.useDateFormatSymbols() ? 1 : 0);
            switch (n3) {
                case 0: {
                    if (c2 != '\u0000') {
                        int n7 = this.matchString(string, n2, 0, this.formatData.getEras(), calendarBuilder);
                        if (n7 <= 0) break;
                        return n7;
                    }
                    Map<String, Integer> map = SimpleDateFormat._jr$ig$calendar(this).getDisplayNames(n5, 0, this.locale);
                    int n8 = this.matchString(string, n2, n5, map, calendarBuilder);
                    if (n8 <= 0) break;
                    return n8;
                }
                case 1: 
                case 19: {
                    if (!(g.convertForInstanceOf((Object)SimpleDateFormat._jr$ig$calendar(this), GregorianCalendar.class) instanceof GregorianCalendar)) {
                        int n9;
                        int n10 = n4 >= 4 ? 2 : 1;
                        Map<String, Integer> map = SimpleDateFormat._jr$ig$calendar(this).getDisplayNames(n5, n10, this.locale);
                        if (map != null && (n9 = this.matchString(string, n2, n5, map, calendarBuilder)) > 0) {
                            return n9;
                        }
                        calendarBuilder.set(n5, n6);
                        return ParsePosition._jr$ig$index((Object)parsePosition2);
                    }
                    if (n4 <= 2 && ParsePosition._jr$ig$index((Object)parsePosition2) - n2 == 2 && Character.isDigit(string.charAt(n2)) && Character.isDigit(string.charAt(n2 + 1))) {
                        int n11 = this.defaultCenturyStartYear % 100;
                        blArray[0] = n6 == n11;
                        n6 += this.defaultCenturyStartYear / 100 * 100 + (n6 < n11 ? 100 : 0);
                    }
                    calendarBuilder.set(n5, n6);
                    return ParsePosition._jr$ig$index((Object)parsePosition2);
                }
                case 2: {
                    if (n4 <= 2) {
                        calendarBuilder.set(2, n6 - 1);
                        return ParsePosition._jr$ig$index((Object)parsePosition2);
                    }
                    if (c2 != '\u0000') {
                        int n12 = 0;
                        n12 = this.matchString(string, n2, 2, this.formatData.getMonths(), calendarBuilder);
                        if (n12 > 0) {
                            return n12;
                        }
                        int n13 = this.matchString(string, n2, 2, this.formatData.getShortMonths(), calendarBuilder);
                        if (n13 <= 0) break;
                        return n13;
                    }
                    Map<String, Integer> map = SimpleDateFormat._jr$ig$calendar(this).getDisplayNames(n5, 0, this.locale);
                    int n14 = this.matchString(string, n2, n5, map, calendarBuilder);
                    if (n14 <= 0) break;
                    return n14;
                }
                case 4: {
                    if (!this.isLenient() && (n6 < 1 || n6 > 24)) break;
                    if (n6 == SimpleDateFormat._jr$ig$calendar(this).getMaximum(11) + 1) {
                        n6 = 0;
                    }
                    calendarBuilder.set(11, n6);
                    return ParsePosition._jr$ig$index((Object)parsePosition2);
                }
                case 9: {
                    int[] nArray;
                    if (c2 != '\u0000') {
                        int n15 = 0;
                        n15 = this.matchString(string, n2, 7, this.formatData.getWeekdays(), calendarBuilder);
                        if (n15 > 0) {
                            return n15;
                        }
                        int n16 = this.matchString(string, n2, 7, this.formatData.getShortWeekdays(), calendarBuilder);
                        if (n16 <= 0) break;
                        return n16;
                    }
                    for (int n17 : nArray = new int[]{2, 1}) {
                        Map<String, Integer> map = SimpleDateFormat._jr$ig$calendar(this).getDisplayNames(n5, n17, this.locale);
                        int n18 = this.matchString(string, n2, n5, map, calendarBuilder);
                        if (n18 <= 0) continue;
                        return n18;
                    }
                    break;
                }
                case 14: {
                    if (c2 != '\u0000') {
                        int n19 = this.matchString(string, n2, 9, this.formatData.getAmPmStrings(), calendarBuilder);
                        if (n19 <= 0) break;
                        return n19;
                    }
                    Map<String, Integer> map = SimpleDateFormat._jr$ig$calendar(this).getDisplayNames(n5, 0, this.locale);
                    int n20 = this.matchString(string, n2, n5, map, calendarBuilder);
                    if (n20 <= 0) break;
                    return n20;
                }
                case 15: {
                    if (!this.isLenient() && (n6 < 1 || n6 > 12)) break;
                    if (n6 == SimpleDateFormat._jr$ig$calendar(this).getLeastMaximum(10) + 1) {
                        n6 = 0;
                    }
                    calendarBuilder.set(10, n6);
                    return ParsePosition._jr$ig$index((Object)parsePosition2);
                }
                case 17: 
                case 18: {
                    int n21 = 0;
                    try {
                        char c3 = string.charAt(ParsePosition._jr$ig$index((Object)parsePosition2));
                        if (c3 == '+') {
                            n21 = 1;
                        } else if (c3 == '-') {
                            n21 = -1;
                        }
                        if (n21 == 0) {
                            if ((c3 == 'G' || c3 == 'g') && string.length() - n2 >= GMT.length() && string.regionMatches(true, n2, GMT, 0, GMT.length())) {
                                ParsePosition._jr$ip$index((Object)parsePosition2, (int)(n2 + GMT.length()));
                                if (string.length() - ParsePosition._jr$ig$index((Object)parsePosition2) > 0) {
                                    c3 = string.charAt(ParsePosition._jr$ig$index((Object)parsePosition2));
                                    if (c3 == '+') {
                                        n21 = 1;
                                    } else if (c3 == '-') {
                                        n21 = -1;
                                    }
                                }
                                if (n21 == 0) {
                                    calendarBuilder.set(15, 0).set(16, 0);
                                    return ParsePosition._jr$ig$index((Object)parsePosition2);
                                }
                                ParsePosition parsePosition5 = parsePosition2;
                                int n22 = ParsePosition._jr$ig$index((Object)parsePosition5) + 1;
                                ParsePosition._jr$ip$index((Object)parsePosition5, (int)n22);
                                int n23 = this.subParseNumericZone(string, n22, n21, 0, true, calendarBuilder);
                                if (n23 > 0) {
                                    return n23;
                                }
                                ParsePosition._jr$ip$index((Object)parsePosition2, (int)(-n23));
                                break;
                            }
                            int n24 = this.subParseZoneString(string, ParsePosition._jr$ig$index((Object)parsePosition2), calendarBuilder);
                            if (n24 > 0) {
                                return n24;
                            }
                            ParsePosition._jr$ip$index((Object)parsePosition2, (int)(-n24));
                            break;
                        }
                        ParsePosition parsePosition6 = parsePosition2;
                        int n25 = ParsePosition._jr$ig$index((Object)parsePosition6) + 1;
                        ParsePosition._jr$ip$index((Object)parsePosition6, (int)n25);
                        int n26 = this.subParseNumericZone(string, n25, n21, 0, false, calendarBuilder);
                        if (n26 > 0) {
                            return n26;
                        }
                        ParsePosition._jr$ip$index((Object)parsePosition2, (int)(-n26));
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                    break;
                }
                case 21: {
                    if (string.length() - ParsePosition._jr$ig$index((Object)parsePosition2) <= 0) break;
                    int n27 = 0;
                    char c4 = string.charAt(ParsePosition._jr$ig$index((Object)parsePosition2));
                    if (c4 == 'Z') {
                        calendarBuilder.set(15, 0).set(16, 0);
                        ParsePosition parsePosition7 = parsePosition2;
                        int n28 = ParsePosition._jr$ig$index((Object)parsePosition7) + 1;
                        ParsePosition._jr$ip$index((Object)parsePosition7, (int)n28);
                        return n28;
                    }
                    if (c4 == '+') {
                        n27 = 1;
                    } else if (c4 == '-') {
                        n27 = -1;
                    } else {
                        ParsePosition parsePosition8 = parsePosition2;
                        ParsePosition._jr$ip$index((Object)parsePosition8, (int)(ParsePosition._jr$ig$index((Object)parsePosition8) + 1));
                        break;
                    }
                    ParsePosition parsePosition9 = parsePosition2;
                    int n29 = ParsePosition._jr$ig$index((Object)parsePosition9) + 1;
                    ParsePosition._jr$ip$index((Object)parsePosition9, (int)n29);
                    int n30 = this.subParseNumericZone(string, n29, n27, n4, n4 == 3, calendarBuilder);
                    if (n30 > 0) {
                        return n30;
                    }
                    ParsePosition._jr$ip$index((Object)parsePosition2, (int)(-n30));
                    break;
                }
                default: {
                    if (bl) {
                        if (n2 + n4 > string.length()) break;
                        number = SimpleDateFormat._jr$ig$numberFormat(this).parse(string.substring(0, n2 + n4), parsePosition2);
                    } else {
                        number = SimpleDateFormat._jr$ig$numberFormat(this).parse(string, parsePosition2);
                    }
                    if (number == null) break;
                    n6 = number.intValue();
                    if (bl2 && n6 < 0 && (ParsePosition._jr$ig$index((Object)parsePosition2) < string.length() && string.charAt(ParsePosition._jr$ig$index((Object)parsePosition2)) != this.minusSign || ParsePosition._jr$ig$index((Object)parsePosition2) == string.length() && string.charAt(ParsePosition._jr$ig$index((Object)parsePosition2) - 1) == this.minusSign)) {
                        n6 = -n6;
                        ParsePosition parsePosition10 = parsePosition2;
                        ParsePosition._jr$ip$index((Object)parsePosition10, (int)(ParsePosition._jr$ig$index((Object)parsePosition10) - 1));
                    }
                    calendarBuilder.set(n5, n6);
                    return ParsePosition._jr$ig$index((Object)parsePosition2);
                }
            }
        }
        ParsePosition._jr$ip$errorIndex((Object)parsePosition, (int)ParsePosition._jr$ig$index((Object)parsePosition2));
        return -1;
    }

    private final String getCalendarName() {
        return x.getName(SimpleDateFormat._jr$ig$calendar(this).getClass());
    }

    private boolean useDateFormatSymbols() {
        if (((SimpleDateFormat)this).useDateFormatSymbols) {
            return true;
        }
        return this.isGregorianCalendar() || this.locale == null;
    }

    private boolean isGregorianCalendar() {
        return "java.util.GregorianCalendar".equals(this.getCalendarName());
    }

    private String translatePattern(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (bl) {
                if (c2 == '\'') {
                    bl = false;
                }
            } else if (c2 == '\'') {
                bl = true;
            } else if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z') {
                int n2 = string2.indexOf(c2);
                if (n2 >= 0) {
                    if (n2 < string3.length()) {
                        c2 = string3.charAt(n2);
                    }
                } else {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Illegal pattern  character '" + c2 + "'"));
                }
            }
            stringBuilder.append(c2);
        }
        if (bl) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Unfinished quote in pattern"));
        }
        return stringBuilder.toString();
    }

    public String toPattern() {
        return this.pattern;
    }

    public String toLocalizedPattern() {
        return this.translatePattern(this.pattern, "GyMdkHmsSEDFwWahKzZYuX", this.formatData.getLocalPatternChars());
    }

    public void applyPattern(String string) {
        this.compiledPattern = this.compile(string);
        this.pattern = string;
    }

    public void applyLocalizedPattern(String string) {
        String string2 = this.translatePattern(string, this.formatData.getLocalPatternChars(), "GyMdkHmsSEDFwWahKzZYuX");
        this.compiledPattern = this.compile(string2);
        this.pattern = string2;
    }

    public DateFormatSymbols getDateFormatSymbols() {
        return (DateFormatSymbols)g.convertForCast((Object)this.formatData.clone(), DateFormatSymbols.class);
    }

    public void setDateFormatSymbols(DateFormatSymbols dateFormatSymbols) {
        this.formatData = (DateFormatSymbols)g.convertForCast((Object)dateFormatSymbols.clone(), DateFormatSymbols.class);
        ((SimpleDateFormat)this).useDateFormatSymbols = true;
    }

    @Override
    public Object clone() {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)g.convertForCast((Object)super.clone(), SimpleDateFormat.class);
        simpleDateFormat.formatData = (DateFormatSymbols)g.convertForCast((Object)this.formatData.clone(), DateFormatSymbols.class);
        return simpleDateFormat;
    }

    @Override
    public int hashCode() {
        return this.pattern.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)g.convertForCast((Object)object, SimpleDateFormat.class);
        return this.pattern.equals(simpleDateFormat.pattern) && this.formatData.equals(simpleDateFormat.formatData);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        String string;
        TimeZone timeZone;
        objectInputStream.defaultReadObject();
        try {
            this.compiledPattern = this.compile(this.pattern);
        }
        catch (Exception exception) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidObjectException("invalid pattern"));
        }
        if (this.serialVersionOnStream < 1) {
            this.initializeDefaultCentury();
        } else {
            this.parseAmbiguousDatesAsAfter(this.defaultCenturyStart);
        }
        this.serialVersionOnStream = 1;
        TimeZone timeZone2 = this.getTimeZone();
        if (g.convertForInstanceOf((Object)timeZone2, SimpleTimeZone.class) instanceof SimpleTimeZone && (timeZone = TimeZone.getTimeZone(string = timeZone2.getID())) != null && timeZone.hasSameRules(timeZone2) && timeZone.getID().equals(string)) {
            this.setTimeZone(timeZone);
        }
    }

    private void checkNegativeNumberExpression() {
        if (g.convertForInstanceOf((Object)SimpleDateFormat._jr$ig$numberFormat(this), DecimalFormat.class) instanceof DecimalFormat && !SimpleDateFormat._jr$ig$numberFormat(this).equals(this.originalNumberFormat)) {
            String string = ((DecimalFormat)g.convertForCast((Object)SimpleDateFormat._jr$ig$numberFormat(this), DecimalFormat.class)).toPattern();
            if (!string.equals(this.originalNumberPattern)) {
                int n2;
                this.hasFollowingMinusSign = false;
                int n3 = string.indexOf(59);
                if (n3 > -1 && (n2 = string.indexOf(45, n3)) > string.lastIndexOf(48) && n2 > string.lastIndexOf(35)) {
                    this.hasFollowingMinusSign = true;
                    this.minusSign = ((DecimalFormat)g.convertForCast((Object)SimpleDateFormat._jr$ig$numberFormat(this), DecimalFormat.class)).getDecimalFormatSymbols().getMinusSign();
                }
                this.originalNumberPattern = string;
            }
            this.originalNumberFormat = SimpleDateFormat._jr$ig$numberFormat(this);
        }
    }

    static {
        Object[] objectArray = new DateFormat.Field[22];
        a.arrayStore((Object[])objectArray, (int)0, (Object)DateFormat.Field.ERA);
        a.arrayStore((Object[])objectArray, (int)1, (Object)DateFormat.Field.YEAR);
        a.arrayStore((Object[])objectArray, (int)2, (Object)DateFormat.Field.MONTH);
        a.arrayStore((Object[])objectArray, (int)3, (Object)DateFormat.Field.DAY_OF_MONTH);
        a.arrayStore((Object[])objectArray, (int)4, (Object)DateFormat.Field.HOUR_OF_DAY1);
        a.arrayStore((Object[])objectArray, (int)5, (Object)DateFormat.Field.HOUR_OF_DAY0);
        a.arrayStore((Object[])objectArray, (int)6, (Object)DateFormat.Field.MINUTE);
        a.arrayStore((Object[])objectArray, (int)7, (Object)DateFormat.Field.SECOND);
        a.arrayStore((Object[])objectArray, (int)8, (Object)DateFormat.Field.MILLISECOND);
        a.arrayStore((Object[])objectArray, (int)9, (Object)DateFormat.Field.DAY_OF_WEEK);
        a.arrayStore((Object[])objectArray, (int)10, (Object)DateFormat.Field.DAY_OF_YEAR);
        a.arrayStore((Object[])objectArray, (int)11, (Object)DateFormat.Field.DAY_OF_WEEK_IN_MONTH);
        a.arrayStore((Object[])objectArray, (int)12, (Object)DateFormat.Field.WEEK_OF_YEAR);
        a.arrayStore((Object[])objectArray, (int)13, (Object)DateFormat.Field.WEEK_OF_MONTH);
        a.arrayStore((Object[])objectArray, (int)14, (Object)DateFormat.Field.AM_PM);
        a.arrayStore((Object[])objectArray, (int)15, (Object)DateFormat.Field.HOUR1);
        a.arrayStore((Object[])objectArray, (int)16, (Object)DateFormat.Field.HOUR0);
        a.arrayStore((Object[])objectArray, (int)17, (Object)DateFormat.Field.TIME_ZONE);
        a.arrayStore((Object[])objectArray, (int)18, (Object)DateFormat.Field.TIME_ZONE);
        a.arrayStore((Object[])objectArray, (int)19, (Object)DateFormat.Field.YEAR);
        a.arrayStore((Object[])objectArray, (int)20, (Object)DateFormat.Field.DAY_OF_WEEK);
        a.arrayStore((Object[])objectArray, (int)21, (Object)DateFormat.Field.TIME_ZONE);
        PATTERN_INDEX_TO_DATE_FORMAT_FIELD_ID = objectArray;
    }

    private static /* synthetic */ void _jr$ip$locale(SimpleDateFormat simpleDateFormat, Locale locale) {
        simpleDateFormat.locale = locale;
    }

    protected /* synthetic */ SimpleDateFormat(h h2) {
        super(h2);
    }
}

