/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.RandomAccessSubList;
import java.util.SubList;

public abstract class AbstractList<E>
extends AbstractCollection<E>
implements List<E> {
    protected transient int modCount;

    protected AbstractList() {
        this.modCount = 0;
    }

    @Override
    public boolean add(E e2) {
        this.add(this.size(), e2);
        return true;
    }

    @Override
    public abstract E get(int var1);

    @Override
    public E set(int n2, E e2) {
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
    }

    @Override
    public void add(int n2, E e2) {
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
    }

    @Override
    public E remove(int n2) {
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
    }

    @Override
    public int indexOf(Object object) {
        ListIterator<E> listIterator = this.listIterator();
        if (object == null) {
            while (listIterator.hasNext()) {
                if (listIterator.next() != null) continue;
                return listIterator.previousIndex();
            }
        } else {
            while (listIterator.hasNext()) {
                if (!object.equals(listIterator.next())) continue;
                return listIterator.previousIndex();
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        ListIterator<E> listIterator = this.listIterator(this.size());
        if (object == null) {
            while (listIterator.hasPrevious()) {
                if (listIterator.previous() != null) continue;
                return listIterator.nextIndex();
            }
        } else {
            while (listIterator.hasPrevious()) {
                if (!object.equals(listIterator.previous())) continue;
                return listIterator.nextIndex();
            }
        }
        return -1;
    }

    @Override
    public void clear() {
        this.removeRange(0, this.size());
    }

    @Override
    public boolean addAll(int n2, Collection<? extends E> collection) {
        this.rangeCheckForAdd(n2);
        boolean bl = false;
        for (E e2 : collection) {
            this.add(n2++, e2);
            bl = true;
        }
        return bl;
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr(this);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int n2) {
        this.rangeCheckForAdd(n2);
        return new ListItr(this, n2);
    }

    @Override
    public List<E> subList(int n2, int n3) {
        return g.convertForInstanceOf((Object)this, RandomAccess.class) instanceof RandomAccess ? new RandomAccessSubList(this, n2, n3) : new SubList(this, n2, n3);
    }

    @Override
    public boolean equals(Object object) {
        if (!f.ifAcmp((Object)object, (Object)this)) {
            return true;
        }
        if (!(g.convertForInstanceOf((Object)object, List.class) instanceof List)) {
            return false;
        }
        ListIterator<E> listIterator = this.listIterator();
        ListIterator listIterator2 = ((List)g.convertForCast((Object)object, List.class)).listIterator();
        while (listIterator.hasNext() && listIterator2.hasNext()) {
            E e2 = listIterator.next();
            Object e3 = listIterator2.next();
            if (e2 != null ? e2.equals(e3) : e3 == null) continue;
            return false;
        }
        return !listIterator.hasNext() && !listIterator2.hasNext();
    }

    @Override
    public int hashCode() {
        int n2 = 1;
        for (E e2 : this) {
            n2 = 31 * n2 + (e2 == null ? 0 : e2.hashCode());
        }
        return n2;
    }

    protected void removeRange(int n2, int n3) {
        ListIterator<E> listIterator = this.listIterator(n2);
        int n4 = n3 - n2;
        for (int i = 0; i < n4; ++i) {
            listIterator.next();
            listIterator.remove();
        }
    }

    private void rangeCheckForAdd(int n2) {
        if (n2 < 0 || n2 > this.size()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException(this.outOfBoundsMsg(n2)));
        }
    }

    private String outOfBoundsMsg(int n2) {
        return "Index: " + n2 + ", Size: " + this.size();
    }

    protected static /* synthetic */ void _jr$ip$modCount(Object object, int n2) {
        ((AbstractList)object).modCount = n2;
    }

    protected /* synthetic */ AbstractList(h h2) {
        super(h2);
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    private class Itr
    extends h
    implements Iterator {
        int cursor;
        int lastRet;
        int expectedModCount;
        final /* synthetic */ AbstractList this$0;

        private Itr(AbstractList abstractList) {
            this.this$0 = abstractList;
            this.cursor = 0;
            this.lastRet = -1;
            this.expectedModCount = ((AbstractList)this.this$0).modCount;
        }

        @Override
        public boolean hasNext() {
            return ((Itr)this).cursor != ((Itr)this).this$0.size();
        }

        @Override
        public E next() {
            this.checkForComodification();
            try {
                int n2 = ((Itr)this).cursor;
                Object e2 = ((Itr)this).this$0.get(n2);
                ((Itr)this).lastRet = n2;
                ((Itr)this).cursor = n2 + 1;
                return e2;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkForComodification();
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
            }
        }

        @Override
        public void remove() {
            if (((Itr)this).lastRet < 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException());
            }
            this.checkForComodification();
            try {
                ((Itr)this).this$0.remove(((Itr)this).lastRet);
                if (((Itr)this).lastRet < ((Itr)this).cursor) {
                    Itr itr = this;
                    ((Itr)itr).cursor = ((Itr)itr).cursor - 1;
                }
                ((Itr)this).lastRet = -1;
                ((Itr)this).expectedModCount = ((AbstractList)((Itr)this).this$0).modCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
            }
        }

        final void checkForComodification() {
            if (((AbstractList)((Itr)this).this$0).modCount != ((Itr)this).expectedModCount) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
            }
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, AbstractList abstractList) {
            ((Itr)object).this$0 = abstractList;
        }

        protected /* synthetic */ Itr(h h2) {
            super(h2);
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator<E> {
        final /* synthetic */ AbstractList this$0;

        ListItr(AbstractList abstractList, int n2) {
            this.this$0 = abstractList;
            super(abstractList);
            this.cursor = n2;
        }

        @Override
        public boolean hasPrevious() {
            return ListItr._jr$ig$cursor(this) != 0;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            try {
                int n2 = ListItr._jr$ig$cursor(this) - 1;
                Object e2 = ((ListItr)this).this$0.get(n2);
                int n3 = n2;
                ListItr._jr$ip$cursor(this, n3);
                ListItr._jr$ip$lastRet(this, n3);
                return e2;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkForComodification();
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
            }
        }

        @Override
        public int nextIndex() {
            return ListItr._jr$ig$cursor(this);
        }

        @Override
        public int previousIndex() {
            return ListItr._jr$ig$cursor(this) - 1;
        }

        @Override
        public void set(E e2) {
            if (ListItr._jr$ig$lastRet(this) < 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException());
            }
            this.checkForComodification();
            try {
                ((ListItr)this).this$0.set(ListItr._jr$ig$lastRet(this), e2);
                ListItr._jr$ip$expectedModCount(this, ((AbstractList)((ListItr)this).this$0).modCount);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
            }
        }

        @Override
        public void add(E e2) {
            this.checkForComodification();
            try {
                int n2 = ListItr._jr$ig$cursor(this);
                ((ListItr)this).this$0.add(n2, e2);
                ListItr._jr$ip$lastRet(this, -1);
                ListItr._jr$ip$cursor(this, n2 + 1);
                ListItr._jr$ip$expectedModCount(this, ((AbstractList)((ListItr)this).this$0).modCount);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
            }
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, AbstractList abstractList) {
            ((ListItr)object).this$0 = abstractList;
        }

        protected /* synthetic */ ListItr(h h2) {
            super(h2);
        }
    }
}

