/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayDeque<E>
extends AbstractCollection<E>
implements Deque<E>,
Cloneable,
Serializable {
    private transient E[] elements;
    private transient int head;
    private transient int tail;
    private static final int MIN_INITIAL_CAPACITY = 8;
    private static final long serialVersionUID = 2340985798034038923L;

    private void allocateElements(int n2) {
        int n3 = 8;
        if (n2 >= n3) {
            n3 = n2;
            n3 |= n3 >>> 1;
            n3 |= n3 >>> 2;
            n3 |= n3 >>> 4;
            n3 |= n3 >>> 8;
            n3 |= n3 >>> 16;
            if (++n3 < 0) {
                n3 >>>= 1;
            }
        }
        this.elements = (Object[])g.convertForCast((Object)new Object[n3], Object[].class);
    }

    private void doubleCapacity() {
        if (!$assertionsDisabled && this.head != this.tail) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        int n2 = this.head;
        int n3 = a.arrayLength((Object[])this.elements);
        int n4 = n3 - n2;
        int n5 = n3 << 1;
        if (n5 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("Sorry, deque too big"));
        }
        Object[] objectArray = new Object[n5];
        a.arraycopy((Object)this.elements, (int)n2, (Object)objectArray, (int)0, (int)n4);
        a.arraycopy((Object)this.elements, (int)0, (Object)objectArray, (int)n4, (int)n2);
        this.elements = (Object[])g.convertForCast((Object)objectArray, Object[].class);
        this.head = 0;
        this.tail = n3;
    }

    private <T> T[] copyElements(T[] TArray) {
        if (this.head < this.tail) {
            a.arraycopy((Object)this.elements, (int)this.head, TArray, (int)0, (int)this.size());
        } else if (this.head > this.tail) {
            int n2 = a.arrayLength((Object[])this.elements) - this.head;
            a.arraycopy((Object)this.elements, (int)this.head, TArray, (int)0, (int)n2);
            a.arraycopy((Object)this.elements, (int)0, TArray, (int)n2, (int)this.tail);
        }
        return TArray;
    }

    public ArrayDeque() {
        this.elements = (Object[])g.convertForCast((Object)new Object[16], Object[].class);
    }

    public ArrayDeque(int n2) {
        this.allocateElements(n2);
    }

    public ArrayDeque(Collection<? extends E> collection) {
        this.allocateElements(collection.size());
        this.addAll(collection);
    }

    @Override
    public void addFirst(E e2) {
        if (e2 == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        Object[] objectArray = this.elements;
        int n2 = this.head - 1 & a.arrayLength((Object[])this.elements) - 1;
        this.head = n2;
        a.arrayStore((Object[])objectArray, (int)n2, e2);
        if (this.head == this.tail) {
            this.doubleCapacity();
        }
    }

    @Override
    public void addLast(E e2) {
        if (e2 == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        a.arrayStore((Object[])this.elements, (int)this.tail, e2);
        int n2 = this.tail + 1 & a.arrayLength((Object[])this.elements) - 1;
        this.tail = n2;
        if (n2 == this.head) {
            this.doubleCapacity();
        }
    }

    @Override
    public boolean offerFirst(E e2) {
        this.addFirst(e2);
        return true;
    }

    @Override
    public boolean offerLast(E e2) {
        this.addLast(e2);
        return true;
    }

    @Override
    public E removeFirst() {
        E e2 = this.pollFirst();
        if (e2 == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
        }
        return e2;
    }

    @Override
    public E removeLast() {
        E e2 = this.pollLast();
        if (e2 == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
        }
        return e2;
    }

    @Override
    public E pollFirst() {
        int n2 = this.head;
        Object object = a.arrayLoad((Object[])this.elements, (int)n2);
        if (object == null) {
            return null;
        }
        a.arrayStore((Object[])this.elements, (int)n2, null);
        this.head = n2 + 1 & a.arrayLength((Object[])this.elements) - 1;
        return (E)object;
    }

    @Override
    public E pollLast() {
        int n2 = this.tail - 1 & a.arrayLength((Object[])this.elements) - 1;
        Object object = a.arrayLoad((Object[])this.elements, (int)n2);
        if (object == null) {
            return null;
        }
        a.arrayStore((Object[])this.elements, (int)n2, null);
        this.tail = n2;
        return (E)object;
    }

    @Override
    public E getFirst() {
        Object object = a.arrayLoad((Object[])this.elements, (int)this.head);
        if (object == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
        }
        return (E)object;
    }

    @Override
    public E getLast() {
        Object object = a.arrayLoad((Object[])this.elements, (int)(this.tail - 1 & a.arrayLength((Object[])this.elements) - 1));
        if (object == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
        }
        return (E)object;
    }

    @Override
    public E peekFirst() {
        return (E)a.arrayLoad((Object[])this.elements, (int)this.head);
    }

    @Override
    public E peekLast() {
        return (E)a.arrayLoad((Object[])this.elements, (int)(this.tail - 1 & a.arrayLength((Object[])this.elements) - 1));
    }

    @Override
    public boolean removeFirstOccurrence(Object object) {
        Object object2;
        if (object == null) {
            return false;
        }
        int n2 = a.arrayLength((Object[])this.elements) - 1;
        int n3 = this.head;
        while ((object2 = a.arrayLoad((Object[])this.elements, (int)n3)) != null) {
            if (object.equals(object2)) {
                this.delete(n3);
                return true;
            }
            n3 = n3 + 1 & n2;
        }
        return false;
    }

    @Override
    public boolean removeLastOccurrence(Object object) {
        Object object2;
        if (object == null) {
            return false;
        }
        int n2 = a.arrayLength((Object[])this.elements) - 1;
        int n3 = this.tail - 1 & n2;
        while ((object2 = a.arrayLoad((Object[])this.elements, (int)n3)) != null) {
            if (object.equals(object2)) {
                this.delete(n3);
                return true;
            }
            n3 = n3 - 1 & n2;
        }
        return false;
    }

    @Override
    public boolean add(E e2) {
        this.addLast(e2);
        return true;
    }

    @Override
    public boolean offer(E e2) {
        return this.offerLast(e2);
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public void push(E e2) {
        this.addFirst(e2);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    private void checkInvariants() {
        if (!$assertionsDisabled && a.arrayLoad((Object[])this.elements, (int)this.tail) != null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        if (!$assertionsDisabled && !(this.head != this.tail ? a.arrayLoad((Object[])this.elements, (int)this.head) != null && a.arrayLoad((Object[])this.elements, (int)(this.tail - 1 & a.arrayLength((Object[])this.elements) - 1)) != null : a.arrayLoad((Object[])this.elements, (int)this.head) == null)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        if (!$assertionsDisabled && a.arrayLoad((Object[])this.elements, (int)(this.head - 1 & a.arrayLength((Object[])this.elements) - 1)) != null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
    }

    private boolean delete(int n2) {
        this.checkInvariants();
        Object[] objectArray = this.elements;
        int n3 = a.arrayLength((Object[])objectArray) - 1;
        int n4 = this.head;
        int n5 = this.tail;
        int n6 = n2 - n4 & n3;
        int n7 = n5 - n2 & n3;
        if (n6 >= (n5 - n4 & n3)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
        }
        if (n6 < n7) {
            if (n4 <= n2) {
                a.arraycopy((Object)objectArray, (int)n4, (Object)objectArray, (int)(n4 + 1), (int)n6);
            } else {
                a.arraycopy((Object)objectArray, (int)0, (Object)objectArray, (int)1, (int)n2);
                a.arrayStore((Object[])objectArray, (int)0, (Object)a.arrayLoad((Object[])objectArray, (int)n3));
                a.arraycopy((Object)objectArray, (int)n4, (Object)objectArray, (int)(n4 + 1), (int)(n3 - n4));
            }
            a.arrayStore((Object[])objectArray, (int)n4, null);
            this.head = n4 + 1 & n3;
            return false;
        }
        if (n2 < n5) {
            a.arraycopy((Object)objectArray, (int)(n2 + 1), (Object)objectArray, (int)n2, (int)n7);
            this.tail = n5 - 1;
        } else {
            a.arraycopy((Object)objectArray, (int)(n2 + 1), (Object)objectArray, (int)n2, (int)(n3 - n2));
            a.arrayStore((Object[])objectArray, (int)n3, (Object)a.arrayLoad((Object[])objectArray, (int)0));
            a.arraycopy((Object)objectArray, (int)1, (Object)objectArray, (int)0, (int)n5);
            this.tail = n5 - 1 & n3;
        }
        return true;
    }

    @Override
    public int size() {
        return this.tail - this.head & a.arrayLength((Object[])this.elements) - 1;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.tail;
    }

    @Override
    public Iterator<E> iterator() {
        return new DeqIterator(this);
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new DescendingIterator(this);
    }

    @Override
    public boolean contains(Object object) {
        Object object2;
        if (object == null) {
            return false;
        }
        int n2 = a.arrayLength((Object[])this.elements) - 1;
        int n3 = this.head;
        while ((object2 = a.arrayLoad((Object[])this.elements, (int)n3)) != null) {
            if (object.equals(object2)) {
                return true;
            }
            n3 = n3 + 1 & n2;
        }
        return false;
    }

    @Override
    public boolean remove(Object object) {
        return this.removeFirstOccurrence(object);
    }

    @Override
    public void clear() {
        int n2;
        int n3 = this.head;
        if (n3 != (n2 = this.tail)) {
            this.tail = 0;
            this.head = 0;
            int n4 = n3;
            int n5 = a.arrayLength((Object[])this.elements) - 1;
            do {
                a.arrayStore((Object[])this.elements, (int)n4, null);
            } while ((n4 = n4 + 1 & n5) != n2);
        }
    }

    @Override
    public Object[] toArray() {
        return this.copyElements(new Object[this.size()]);
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        int n2 = this.size();
        if (a.arrayLength((Object[])objectArray) < n2) {
            objectArray = (Object[])g.convertForCast((Object)((Object[])g.convertForCast((Object)Array.newInstance(ai.getCurrentClass(objectArray.getClass()).getComponentType(), n2), Object[].class)), Object[].class);
        }
        this.copyElements(objectArray);
        if (a.arrayLength((Object[])objectArray) > n2) {
            a.arrayStore((Object[])objectArray, (int)n2, null);
        }
        return objectArray;
    }

    public ArrayDeque<E> clone() {
        try {
            ArrayDeque arrayDeque = (ArrayDeque)g.convertForCast((Object)super.clone(), ArrayDeque.class);
            arrayDeque.elements = Arrays.copyOf(this.elements, a.arrayLength((Object[])this.elements));
            return arrayDeque;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size());
        int n2 = a.arrayLength((Object[])this.elements) - 1;
        int n3 = this.head;
        while (n3 != this.tail) {
            objectOutputStream.writeObject(a.arrayLoad((Object[])this.elements, (int)n3));
            n3 = n3 + 1 & n2;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        this.allocateElements(n2);
        this.head = 0;
        this.tail = n2;
        for (int i = 0; i < n2; ++i) {
            a.arrayStore((Object[])this.elements, (int)i, (Object)objectInputStream.readObject());
        }
    }

    protected /* synthetic */ ArrayDeque(h h2) {
        super(h2);
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    private class DeqIterator
    extends h
    implements Iterator {
        private int cursor;
        private int fence;
        private int lastRet;
        final /* synthetic */ ArrayDeque this$0;

        private DeqIterator(ArrayDeque arrayDeque) {
            this.this$0 = arrayDeque;
            this.cursor = this.this$0.head;
            this.fence = this.this$0.tail;
            this.lastRet = -1;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != this.fence;
        }

        @Override
        public E next() {
            if (this.cursor == this.fence) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
            }
            Object object = a.arrayLoad((Object[])((DeqIterator)this).this$0.elements, (int)this.cursor);
            if (((DeqIterator)this).this$0.tail != this.fence || object == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
            }
            this.lastRet = this.cursor;
            this.cursor = this.cursor + 1 & a.arrayLength((Object[])((DeqIterator)this).this$0.elements) - 1;
            return object;
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException());
            }
            if (((DeqIterator)this).this$0.delete(this.lastRet)) {
                this.cursor = this.cursor - 1 & a.arrayLength((Object[])((DeqIterator)this).this$0.elements) - 1;
                this.fence = ((DeqIterator)this).this$0.tail;
            }
            this.lastRet = -1;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, ArrayDeque arrayDeque) {
            ((DeqIterator)object).this$0 = arrayDeque;
        }

        protected /* synthetic */ DeqIterator(h h2) {
            super(h2);
        }
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    private class DescendingIterator
    extends h
    implements Iterator {
        private int cursor;
        private int fence;
        private int lastRet;
        final /* synthetic */ ArrayDeque this$0;

        private DescendingIterator(ArrayDeque arrayDeque) {
            this.this$0 = arrayDeque;
            this.cursor = this.this$0.tail;
            this.fence = this.this$0.head;
            this.lastRet = -1;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != this.fence;
        }

        @Override
        public E next() {
            if (this.cursor == this.fence) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
            }
            this.cursor = this.cursor - 1 & a.arrayLength((Object[])((DescendingIterator)this).this$0.elements) - 1;
            Object object = a.arrayLoad((Object[])((DescendingIterator)this).this$0.elements, (int)this.cursor);
            if (((DescendingIterator)this).this$0.head != this.fence || object == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
            }
            this.lastRet = this.cursor;
            return object;
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException());
            }
            if (!((DescendingIterator)this).this$0.delete(this.lastRet)) {
                this.cursor = this.cursor + 1 & a.arrayLength((Object[])((DescendingIterator)this).this$0.elements) - 1;
                this.fence = ((DescendingIterator)this).this$0.head;
            }
            this.lastRet = -1;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, ArrayDeque arrayDeque) {
            ((DescendingIterator)object).this$0 = arrayDeque;
        }

        protected /* synthetic */ DescendingIterator(h h2) {
            super(h2);
        }
    }
}

