/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class ArrayList<E>
extends AbstractList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8683452581122892189L;
    private static final int DEFAULT_CAPACITY = 10;
    private static final Object[] EMPTY_ELEMENTDATA = new Object[0];
    private transient Object[] elementData;
    private int size;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public ArrayList(int n2) {
        if (n2 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Illegal Capacity: " + n2));
        }
        this.elementData = new Object[n2];
    }

    public ArrayList() {
        this.elementData = EMPTY_ELEMENTDATA;
    }

    public ArrayList(Collection<? extends E> collection) {
        this.elementData = collection.toArray();
        this.size = a.arrayLength((Object[])this.elementData);
        if (f.ifAcmp(this.elementData.getClass(), Object[].class)) {
            this.elementData = a.copyOf((Object[])this.elementData, (int)this.size, Object[].class);
        }
    }

    public void trimToSize() {
        ArrayList arrayList = this;
        ArrayList._jr$ip$modCount(arrayList, ArrayList._jr$ig$modCount(arrayList) + 1);
        if (this.size < a.arrayLength((Object[])this.elementData)) {
            this.elementData = Arrays.copyOf(this.elementData, this.size);
        }
    }

    public void ensureCapacity(int n2) {
        int n3;
        int n4 = n3 = f.ifAcmp((Object)this.elementData, (Object)EMPTY_ELEMENTDATA) ? 0 : 10;
        if (n2 > n3) {
            this.ensureExplicitCapacity(n2);
        }
    }

    private void ensureCapacityInternal(int n2) {
        if (!f.ifAcmp((Object)this.elementData, (Object)EMPTY_ELEMENTDATA)) {
            n2 = Math.max(10, n2);
        }
        this.ensureExplicitCapacity(n2);
    }

    private void ensureExplicitCapacity(int n2) {
        ArrayList arrayList = this;
        ArrayList._jr$ip$modCount(arrayList, ArrayList._jr$ig$modCount(arrayList) + 1);
        if (n2 - a.arrayLength((Object[])this.elementData) > 0) {
            this.grow(n2);
        }
    }

    private void grow(int n2) {
        int n3 = a.arrayLength((Object[])this.elementData);
        int n4 = n3 + (n3 >> 1);
        if (n4 - n2 < 0) {
            n4 = n2;
        }
        if (n4 - 0x7FFFFFF7 > 0) {
            n4 = ArrayList.hugeCapacity(n2);
        }
        this.elementData = Arrays.copyOf(this.elementData, n4);
    }

    private static int hugeCapacity(int n2) {
        if (n2 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new OutOfMemoryError());
        }
        return n2 > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    @Override
    public int indexOf(Object object) {
        if (object == null) {
            for (int i = 0; i < this.size; ++i) {
                if (a.arrayLoad((Object[])this.elementData, (int)i) != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!object.equals(a.arrayLoad((Object[])this.elementData, (int)i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        if (object == null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (a.arrayLoad((Object[])this.elementData, (int)i) != null) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!object.equals(a.arrayLoad((Object[])this.elementData, (int)i))) continue;
                return i;
            }
        }
        return -1;
    }

    public Object clone() {
        try {
            ArrayList arrayList = (ArrayList)g.convertForCast((Object)super.clone(), ArrayList.class);
            arrayList.elementData = Arrays.copyOf(this.elementData, this.size);
            ArrayList._jr$ip$modCount(arrayList, 0);
            return arrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
        }
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.elementData, this.size);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        if (a.arrayLength((Object[])TArray) < this.size) {
            return (Object[])g.convertForCast((Object)a.copyOf((Object[])this.elementData, (int)this.size, TArray.getClass()), Object[].class);
        }
        a.arraycopy((Object)this.elementData, (int)0, TArray, (int)0, (int)this.size);
        if (a.arrayLength((Object[])TArray) > this.size) {
            a.arrayStore((Object[])TArray, (int)this.size, null);
        }
        return TArray;
    }

    E elementData(int n2) {
        return (E)a.arrayLoad((Object[])this.elementData, (int)n2);
    }

    @Override
    public E get(int n2) {
        this.rangeCheck(n2);
        return this.elementData(n2);
    }

    @Override
    public E set(int n2, E e2) {
        this.rangeCheck(n2);
        E e3 = this.elementData(n2);
        a.arrayStore((Object[])this.elementData, (int)n2, e2);
        return e3;
    }

    @Override
    public boolean add(E e2) {
        this.ensureCapacityInternal(this.size + 1);
        Object[] objectArray = this.elementData;
        ArrayList arrayList = this;
        int n2 = arrayList.size;
        arrayList.size = n2 + 1;
        a.arrayStore((Object[])objectArray, (int)n2, e2);
        return true;
    }

    @Override
    public void add(int n2, E e2) {
        this.rangeCheckForAdd(n2);
        this.ensureCapacityInternal(this.size + 1);
        a.arraycopy((Object)this.elementData, (int)n2, (Object)this.elementData, (int)(n2 + 1), (int)(this.size - n2));
        a.arrayStore((Object[])this.elementData, (int)n2, e2);
        ArrayList arrayList = this;
        arrayList.size = arrayList.size + 1;
    }

    @Override
    public E remove(int n2) {
        this.rangeCheck(n2);
        ArrayList arrayList = this;
        ArrayList._jr$ip$modCount(arrayList, ArrayList._jr$ig$modCount(arrayList) + 1);
        E e2 = this.elementData(n2);
        int n3 = this.size - n2 - 1;
        if (n3 > 0) {
            a.arraycopy((Object)this.elementData, (int)(n2 + 1), (Object)this.elementData, (int)n2, (int)n3);
        }
        Object[] objectArray = this.elementData;
        ArrayList arrayList2 = this;
        int n4 = arrayList2.size - 1;
        arrayList2.size = n4;
        a.arrayStore((Object[])objectArray, (int)n4, null);
        return e2;
    }

    @Override
    public boolean remove(Object object) {
        if (object == null) {
            for (int i = 0; i < this.size; ++i) {
                if (a.arrayLoad((Object[])this.elementData, (int)i) != null) continue;
                this.fastRemove(i);
                return true;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!object.equals(a.arrayLoad((Object[])this.elementData, (int)i))) continue;
                this.fastRemove(i);
                return true;
            }
        }
        return false;
    }

    private void fastRemove(int n2) {
        ArrayList arrayList = this;
        ArrayList._jr$ip$modCount(arrayList, ArrayList._jr$ig$modCount(arrayList) + 1);
        int n3 = this.size - n2 - 1;
        if (n3 > 0) {
            a.arraycopy((Object)this.elementData, (int)(n2 + 1), (Object)this.elementData, (int)n2, (int)n3);
        }
        Object[] objectArray = this.elementData;
        ArrayList arrayList2 = this;
        int n4 = arrayList2.size - 1;
        arrayList2.size = n4;
        a.arrayStore((Object[])objectArray, (int)n4, null);
    }

    @Override
    public void clear() {
        ArrayList arrayList = this;
        ArrayList._jr$ip$modCount(arrayList, ArrayList._jr$ig$modCount(arrayList) + 1);
        for (int i = 0; i < this.size; ++i) {
            a.arrayStore((Object[])this.elementData, (int)i, null);
        }
        this.size = 0;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        Object[] objectArray = collection.toArray();
        int n2 = a.arrayLength((Object[])objectArray);
        this.ensureCapacityInternal(this.size + n2);
        a.arraycopy((Object)objectArray, (int)0, (Object)this.elementData, (int)this.size, (int)n2);
        ArrayList arrayList = this;
        arrayList.size = arrayList.size + n2;
        return n2 != 0;
    }

    @Override
    public boolean addAll(int n2, Collection<? extends E> collection) {
        this.rangeCheckForAdd(n2);
        Object[] objectArray = collection.toArray();
        int n3 = a.arrayLength((Object[])objectArray);
        this.ensureCapacityInternal(this.size + n3);
        int n4 = this.size - n2;
        if (n4 > 0) {
            a.arraycopy((Object)this.elementData, (int)n2, (Object)this.elementData, (int)(n2 + n3), (int)n4);
        }
        a.arraycopy((Object)objectArray, (int)0, (Object)this.elementData, (int)n2, (int)n3);
        ArrayList arrayList = this;
        arrayList.size = arrayList.size + n3;
        return n3 != 0;
    }

    @Override
    protected void removeRange(int n2, int n3) {
        int n4;
        ArrayList arrayList = this;
        ArrayList._jr$ip$modCount(arrayList, ArrayList._jr$ig$modCount(arrayList) + 1);
        int n5 = this.size - n3;
        a.arraycopy((Object)this.elementData, (int)n3, (Object)this.elementData, (int)n2, (int)n5);
        for (int i = n4 = this.size - (n3 - n2); i < this.size; ++i) {
            a.arrayStore((Object[])this.elementData, (int)i, null);
        }
        this.size = n4;
    }

    private void rangeCheck(int n2) {
        if (n2 >= this.size) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException(this.outOfBoundsMsg(n2)));
        }
    }

    private void rangeCheckForAdd(int n2) {
        if (n2 > this.size || n2 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException(this.outOfBoundsMsg(n2)));
        }
    }

    private String outOfBoundsMsg(int n2) {
        return "Index: " + n2 + ", Size: " + this.size;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.batchRemove(collection, false);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.batchRemove(collection, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean batchRemove(Collection<?> collection, boolean bl) {
        int n2;
        Object[] objectArray = this.elementData;
        int n3 = 0;
        boolean bl2 = false;
        try {
            for (n2 = 0; n2 < this.size; ++n2) {
                if (collection.contains(a.arrayLoad((Object[])objectArray, (int)n2)) != bl) continue;
                a.arrayStore((Object[])objectArray, (int)n3++, (Object)a.arrayLoad((Object[])objectArray, (int)n2));
            }
        }
        catch (Throwable throwable) {
            if (n2 != this.size) {
                a.arraycopy((Object)objectArray, (int)n2, (Object)objectArray, (int)n3, (int)(this.size - n2));
                n3 += this.size - n2;
            }
            if (n3 != this.size) {
                for (int i = n3; i < this.size; ++i) {
                    a.arrayStore((Object[])objectArray, (int)i, null);
                }
                ArrayList arrayList = this;
                ArrayList._jr$ip$modCount(arrayList, ArrayList._jr$ig$modCount(arrayList) + (this.size - n3));
                this.size = n3;
                bl2 = true;
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        if (n2 != this.size) {
            a.arraycopy((Object)objectArray, (int)n2, (Object)objectArray, (int)n3, (int)(this.size - n2));
            n3 += this.size - n2;
        }
        if (n3 != this.size) {
            for (int i = n3; i < this.size; ++i) {
                a.arrayStore((Object[])objectArray, (int)i, null);
            }
            ArrayList arrayList = this;
            ArrayList._jr$ip$modCount(arrayList, ArrayList._jr$ig$modCount(arrayList) + (this.size - n3));
            this.size = n3;
            bl2 = true;
        }
        return bl2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n2 = ArrayList._jr$ig$modCount(this);
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            objectOutputStream.writeObject(a.arrayLoad((Object[])this.elementData, (int)i));
        }
        if (ArrayList._jr$ig$modCount(this) != n2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.elementData = ArrayList.EMPTY_ELEMENTDATA;
        objectInputStream.defaultReadObject();
        objectInputStream.readInt();
        if (this.size > 0) {
            this.ensureCapacityInternal(this.size);
            Object[] objectArray = this.elementData;
            for (int i = 0; i < this.size; ++i) {
                a.arrayStore((Object[])objectArray, (int)i, (Object)objectInputStream.readObject());
            }
        }
    }

    @Override
    public ListIterator<E> listIterator(int n2) {
        if (n2 < 0 || n2 > this.size) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException("Index: " + n2));
        }
        return new ListItr(this, n2);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ListItr(this, 0);
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr(this);
    }

    @Override
    public List<E> subList(int n2, int n3) {
        ArrayList.subListRangeCheck(n2, n3, this.size);
        return new SubList(this, this, 0, n2, n3);
    }

    static void subListRangeCheck(int n2, int n3, int n4) {
        if (n2 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException("fromIndex = " + n2));
        }
        if (n3 > n4) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException("toIndex = " + n3));
        }
        if (n2 > n3) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("fromIndex(" + n2 + ") > toIndex(" + n3 + ")"));
        }
    }

    protected /* synthetic */ ArrayList(h h2) {
        super(h2);
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    private class Itr
    extends h
    implements Iterator {
        int cursor;
        int lastRet;
        int expectedModCount;
        final /* synthetic */ ArrayList this$0;

        private Itr(ArrayList arrayList) {
            this.this$0 = arrayList;
            this.lastRet = -1;
            this.expectedModCount = ArrayList._jr$ig$modCount(this.this$0);
        }

        @Override
        public boolean hasNext() {
            return ((Itr)this).cursor != ((Itr)this).this$0.size;
        }

        @Override
        public E next() {
            this.checkForComodification();
            int n2 = ((Itr)this).cursor;
            if (n2 >= ((Itr)this).this$0.size) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
            }
            Object[] objectArray = ((Itr)this).this$0.elementData;
            if (n2 >= a.arrayLength((Object[])objectArray)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
            }
            ((Itr)this).cursor = n2 + 1;
            int n3 = n2;
            ((Itr)this).lastRet = n3;
            return a.arrayLoad((Object[])objectArray, (int)n3);
        }

        @Override
        public void remove() {
            if (((Itr)this).lastRet < 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException());
            }
            this.checkForComodification();
            try {
                ((Itr)this).this$0.remove(((Itr)this).lastRet);
                ((Itr)this).cursor = ((Itr)this).lastRet;
                ((Itr)this).lastRet = -1;
                ((Itr)this).expectedModCount = ArrayList._jr$ig$modCount(((Itr)this).this$0);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
            }
        }

        final void checkForComodification() {
            if (ArrayList._jr$ig$modCount(((Itr)this).this$0) != ((Itr)this).expectedModCount) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
            }
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, ArrayList arrayList) {
            ((Itr)object).this$0 = arrayList;
        }

        protected /* synthetic */ Itr(h h2) {
            super(h2);
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator<E> {
        final /* synthetic */ ArrayList this$0;

        ListItr(ArrayList arrayList, int n2) {
            this.this$0 = arrayList;
            super(arrayList);
            this.cursor = n2;
        }

        @Override
        public boolean hasPrevious() {
            return ListItr._jr$ig$cursor(this) != 0;
        }

        @Override
        public int nextIndex() {
            return ListItr._jr$ig$cursor(this);
        }

        @Override
        public int previousIndex() {
            return ListItr._jr$ig$cursor(this) - 1;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            int n2 = ListItr._jr$ig$cursor(this) - 1;
            if (n2 < 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
            }
            Object[] objectArray = ((ListItr)this).this$0.elementData;
            if (n2 >= a.arrayLength((Object[])objectArray)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
            }
            ListItr._jr$ip$cursor(this, n2);
            int n3 = n2;
            ListItr._jr$ip$lastRet(this, n3);
            return a.arrayLoad((Object[])objectArray, (int)n3);
        }

        @Override
        public void set(E e2) {
            if (ListItr._jr$ig$lastRet(this) < 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException());
            }
            this.checkForComodification();
            try {
                ((ListItr)this).this$0.set(ListItr._jr$ig$lastRet(this), e2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
            }
        }

        @Override
        public void add(E e2) {
            this.checkForComodification();
            try {
                int n2 = ListItr._jr$ig$cursor(this);
                ((ListItr)this).this$0.add(n2, e2);
                ListItr._jr$ip$cursor(this, n2 + 1);
                ListItr._jr$ip$lastRet(this, -1);
                ListItr._jr$ip$expectedModCount(this, ArrayList._jr$ig$modCount(((ListItr)this).this$0));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
            }
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, ArrayList arrayList) {
            ((ListItr)object).this$0 = arrayList;
        }

        protected /* synthetic */ ListItr(h h2) {
            super(h2);
        }
    }

    private class SubList
    extends AbstractList<E>
    implements RandomAccess {
        private final AbstractList<E> parent;
        private final int parentOffset;
        private final int offset;
        int size;
        final /* synthetic */ ArrayList this$0;

        SubList(ArrayList arrayList, AbstractList<E> abstractList, int n2, int n3, int n4) {
            this.this$0 = arrayList;
            this.parent = abstractList;
            this.parentOffset = n3;
            this.offset = n2 + n3;
            this.size = n4 - n3;
            this.modCount = arrayList.modCount;
        }

        @Override
        public E set(int n2, E e2) {
            this.rangeCheck(n2);
            this.checkForComodification();
            Object e3 = ((SubList)this).this$0.elementData(this.offset + n2);
            a.arrayStore((Object[])((SubList)this).this$0.elementData, (int)(this.offset + n2), e2);
            return e3;
        }

        @Override
        public E get(int n2) {
            this.rangeCheck(n2);
            this.checkForComodification();
            return ((SubList)this).this$0.elementData(this.offset + n2);
        }

        @Override
        public int size() {
            this.checkForComodification();
            return ((SubList)this).size;
        }

        @Override
        public void add(int n2, E e2) {
            this.rangeCheckForAdd(n2);
            this.checkForComodification();
            this.parent.add(this.parentOffset + n2, e2);
            SubList._jr$ip$modCount(this, AbstractList._jr$ig$modCount(this.parent));
            SubList subList = this;
            ((SubList)subList).size = ((SubList)subList).size + 1;
        }

        @Override
        public E remove(int n2) {
            this.rangeCheck(n2);
            this.checkForComodification();
            Object e2 = this.parent.remove(this.parentOffset + n2);
            SubList._jr$ip$modCount(this, AbstractList._jr$ig$modCount(this.parent));
            SubList subList = this;
            ((SubList)subList).size = ((SubList)subList).size - 1;
            return e2;
        }

        @Override
        protected void removeRange(int n2, int n3) {
            this.checkForComodification();
            this.parent.removeRange(this.parentOffset + n2, this.parentOffset + n3);
            SubList._jr$ip$modCount(this, AbstractList._jr$ig$modCount(this.parent));
            SubList subList = this;
            ((SubList)subList).size = ((SubList)subList).size - (n3 - n2);
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            return this.addAll(((SubList)this).size, collection);
        }

        @Override
        public boolean addAll(int n2, Collection<? extends E> collection) {
            this.rangeCheckForAdd(n2);
            int n3 = collection.size();
            if (n3 == 0) {
                return false;
            }
            this.checkForComodification();
            this.parent.addAll(this.parentOffset + n2, collection);
            SubList._jr$ip$modCount(this, AbstractList._jr$ig$modCount(this.parent));
            SubList subList = this;
            ((SubList)subList).size = ((SubList)subList).size + n3;
            return true;
        }

        @Override
        public Iterator<E> iterator() {
            return this.listIterator();
        }

        @Override
        public ListIterator<E> listIterator(int n2) {
            this.checkForComodification();
            this.rangeCheckForAdd(n2);
            int n3 = this.offset;
            return new ListIterator(this, n2, n3){
                int cursor;
                int lastRet;
                int expectedModCount;
                final /* synthetic */ int val$index;
                final /* synthetic */ int val$offset;
                final /* synthetic */ SubList this$1;
                {
                    this.this$1 = subList;
                    this.val$index = n2;
                    this.val$offset = n3;
                    this.cursor = this.val$index;
                    this.lastRet = -1;
                    this.expectedModCount = ArrayList._jr$ig$modCount(this.this$1.this$0);
                }

                @Override
                public boolean hasNext() {
                    return (this).cursor != ((SubList)this.this$1).size;
                }

                @Override
                public E next() {
                    this.checkForComodification();
                    int n2 = (this).cursor;
                    if (n2 >= ((SubList)this.this$1).size) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
                    }
                    Object[] objectArray = this.this$1.this$0.elementData;
                    if ((this).val$offset + n2 >= a.arrayLength((Object[])objectArray)) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
                    }
                    (this).cursor = n2 + 1;
                    int n3 = (this).val$offset;
                    int n4 = n2;
                    (this).lastRet = n4;
                    return a.arrayLoad((Object[])objectArray, (int)(n3 + n4));
                }

                @Override
                public boolean hasPrevious() {
                    return (this).cursor != 0;
                }

                @Override
                public E previous() {
                    this.checkForComodification();
                    int n2 = (this).cursor - 1;
                    if (n2 < 0) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
                    }
                    Object[] objectArray = this.this$1.this$0.elementData;
                    if ((this).val$offset + n2 >= a.arrayLength((Object[])objectArray)) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
                    }
                    (this).cursor = n2;
                    int n3 = (this).val$offset;
                    int n4 = n2;
                    (this).lastRet = n4;
                    return a.arrayLoad((Object[])objectArray, (int)(n3 + n4));
                }

                @Override
                public int nextIndex() {
                    return (this).cursor;
                }

                @Override
                public int previousIndex() {
                    return (this).cursor - 1;
                }

                @Override
                public void remove() {
                    if ((this).lastRet < 0) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException());
                    }
                    this.checkForComodification();
                    try {
                        this.this$1.remove((this).lastRet);
                        (this).cursor = (this).lastRet;
                        (this).lastRet = -1;
                        (this).expectedModCount = ArrayList._jr$ig$modCount(this.this$1.this$0);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
                    }
                }

                @Override
                public void set(E e2) {
                    if ((this).lastRet < 0) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException());
                    }
                    this.checkForComodification();
                    try {
                        this.this$1.this$0.set((this).val$offset + (this).lastRet, e2);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
                    }
                }

                @Override
                public void add(E e2) {
                    this.checkForComodification();
                    try {
                        int n2 = (this).cursor;
                        this.this$1.add(n2, e2);
                        (this).cursor = n2 + 1;
                        (this).lastRet = -1;
                        (this).expectedModCount = ArrayList._jr$ig$modCount(this.this$1.this$0);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
                    }
                }

                final void checkForComodification() {
                    if ((this).expectedModCount != ArrayList._jr$ig$modCount(this.this$1.this$0)) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
                    }
                }

                static /* synthetic */ int _jr$ig$val$index(Object object) {
                    return (object).val$index;
                }

                static /* synthetic */ void _jr$ip$val$index(Object object, int n2) {
                    (object).val$index = n2;
                }

                static /* synthetic */ void _jr$ip$val$offset(Object object, int n2) {
                    (object).val$offset = n2;
                }

                static /* synthetic */ SubList _jr$ig$this$1(Object object) {
                    return (object).this$1;
                }

                static /* synthetic */ void _jr$ip$this$1(Object object, SubList subList) {
                    (object).this$1 = subList;
                }
            };
        }

        @Override
        public List<E> subList(int n2, int n3) {
            ArrayList.subListRangeCheck(n2, n3, ((SubList)this).size);
            return new SubList(((SubList)this).this$0, this, this.offset, n2, n3);
        }

        private void rangeCheck(int n2) {
            if (n2 < 0 || n2 >= ((SubList)this).size) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException(this.outOfBoundsMsg(n2)));
            }
        }

        private void rangeCheckForAdd(int n2) {
            if (n2 < 0 || n2 > ((SubList)this).size) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException(this.outOfBoundsMsg(n2)));
            }
        }

        private String outOfBoundsMsg(int n2) {
            return "Index: " + n2 + ", Size: " + ((SubList)this).size;
        }

        private void checkForComodification() {
            if (ArrayList._jr$ig$modCount(((SubList)this).this$0) != SubList._jr$ig$modCount(this)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
            }
        }

        private static /* synthetic */ void _jr$ip$parent(SubList subList, AbstractList abstractList) {
            subList.parent = abstractList;
        }

        private static /* synthetic */ void _jr$ip$parentOffset(SubList subList, int n2) {
            subList.parentOffset = n2;
        }

        private static /* synthetic */ void _jr$ip$offset(SubList subList, int n2) {
            subList.offset = n2;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, ArrayList arrayList) {
            ((SubList)object).this$0 = arrayList;
        }

        protected /* synthetic */ SubList(h h2) {
            super(h2);
        }
    }
}

