/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.security.AccessController;
import java.util.AbstractList;
import java.util.ComparableTimSort;
import java.util.Comparator;
import java.util.DualPivotQuicksort;
import java.util.HashSet;
import java.util.List;
import java.util.RandomAccess;
import java.util.Set;
import java.util.TimSort;
import sun.security.action.GetBooleanAction;

public class Arrays
extends h {
    private static final int INSERTIONSORT_THRESHOLD = 7;

    private Arrays() {
    }

    public static void sort(int[] nArray) {
        DualPivotQuicksort.sort((int[])nArray);
    }

    public static void sort(int[] nArray, int n2, int n3) {
        Arrays.rangeCheck(nArray.length, n2, n3);
        DualPivotQuicksort.sort((int[])nArray, (int)n2, (int)(n3 - 1));
    }

    public static void sort(long[] lArray) {
        DualPivotQuicksort.sort((long[])lArray);
    }

    public static void sort(long[] lArray, int n2, int n3) {
        Arrays.rangeCheck(lArray.length, n2, n3);
        DualPivotQuicksort.sort((long[])lArray, (int)n2, (int)(n3 - 1));
    }

    public static void sort(short[] sArray) {
        DualPivotQuicksort.sort((short[])sArray);
    }

    public static void sort(short[] sArray, int n2, int n3) {
        Arrays.rangeCheck(sArray.length, n2, n3);
        DualPivotQuicksort.sort(sArray, n2, n3 - 1);
    }

    public static void sort(char[] cArray) {
        DualPivotQuicksort.sort((char[])cArray);
    }

    public static void sort(char[] cArray, int n2, int n3) {
        Arrays.rangeCheck(cArray.length, n2, n3);
        DualPivotQuicksort.sort(cArray, n2, n3 - 1);
    }

    public static void sort(byte[] byArray) {
        DualPivotQuicksort.sort((byte[])byArray);
    }

    public static void sort(byte[] byArray, int n2, int n3) {
        Arrays.rangeCheck(byArray.length, n2, n3);
        DualPivotQuicksort.sort(byArray, n2, n3 - 1);
    }

    public static void sort(float[] fArray) {
        DualPivotQuicksort.sort((float[])fArray);
    }

    public static void sort(float[] fArray, int n2, int n3) {
        Arrays.rangeCheck(fArray.length, n2, n3);
        DualPivotQuicksort.sort((float[])fArray, (int)n2, (int)(n3 - 1));
    }

    public static void sort(double[] dArray) {
        DualPivotQuicksort.sort((double[])dArray);
    }

    public static void sort(double[] dArray, int n2, int n3) {
        Arrays.rangeCheck(dArray.length, n2, n3);
        DualPivotQuicksort.sort((double[])dArray, (int)n2, (int)(n3 - 1));
    }

    public static void sort(Object[] objectArray) {
        if (LegacyMergeSort.userRequested) {
            Arrays.legacyMergeSort(objectArray);
        } else {
            ComparableTimSort.sort(objectArray);
        }
    }

    private static void legacyMergeSort(Object[] objectArray) {
        Object[] objectArray2 = (Object[])g.convertForCast((Object)a.cloneArray((Object)objectArray), Object[].class);
        Arrays.mergeSort(objectArray2, objectArray, 0, a.arrayLength((Object[])objectArray), 0);
    }

    public static void sort(Object[] objectArray, int n2, int n3) {
        if (LegacyMergeSort.userRequested) {
            Arrays.legacyMergeSort(objectArray, n2, n3);
        } else {
            ComparableTimSort.sort(objectArray, n2, n3);
        }
    }

    private static void legacyMergeSort(Object[] objectArray, int n2, int n3) {
        Arrays.rangeCheck(a.arrayLength((Object[])objectArray), n2, n3);
        Object[] objectArray2 = Arrays.copyOfRange(objectArray, n2, n3);
        Arrays.mergeSort(objectArray2, objectArray, n2, n3, -n2);
    }

    private static void mergeSort(Object[] objectArray, Object[] objectArray2, int n2, int n3, int n4) {
        int n5 = n3 - n2;
        if (n5 < 7) {
            for (int i = n2; i < n3; ++i) {
                for (int k = i; k > n2 && ((Comparable)g.convertForCast((Object)a.arrayLoad((Object[])objectArray2, (int)(k - 1)), Comparable.class)).compareTo(a.arrayLoad((Object[])objectArray2, (int)k)) > 0; --k) {
                    Arrays.swap(objectArray2, k, k - 1);
                }
            }
            return;
        }
        int n6 = n2;
        int n7 = n3;
        int n8 = (n2 += n4) + (n3 += n4) >>> 1;
        Arrays.mergeSort(objectArray2, objectArray, n2, n8, -n4);
        Arrays.mergeSort(objectArray2, objectArray, n8, n3, -n4);
        if (((Comparable)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)(n8 - 1)), Comparable.class)).compareTo(a.arrayLoad((Object[])objectArray, (int)n8)) <= 0) {
            a.arraycopy((Object)objectArray, (int)n2, (Object)objectArray2, (int)n6, (int)n5);
            return;
        }
        int n9 = n2;
        int n10 = n8;
        for (int i = n6; i < n7; ++i) {
            if (n10 >= n3 || n9 < n8 && ((Comparable)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)n9), Comparable.class)).compareTo(a.arrayLoad((Object[])objectArray, (int)n10)) <= 0) {
                a.arrayStore((Object[])objectArray2, (int)i, (Object)a.arrayLoad((Object[])objectArray, (int)n9++));
                continue;
            }
            a.arrayStore((Object[])objectArray2, (int)i, (Object)a.arrayLoad((Object[])objectArray, (int)n10++));
        }
    }

    private static void swap(Object[] objectArray, int n2, int n3) {
        Object object = a.arrayLoad((Object[])objectArray, (int)n2);
        a.arrayStore((Object[])objectArray, (int)n2, (Object)a.arrayLoad((Object[])objectArray, (int)n3));
        a.arrayStore((Object[])objectArray, (int)n3, (Object)object);
    }

    public static <T> void sort(T[] TArray, Comparator<? super T> comparator) {
        if (LegacyMergeSort.userRequested) {
            Arrays.legacyMergeSort(TArray, comparator);
        } else {
            TimSort.sort(TArray, comparator);
        }
    }

    private static <T> void legacyMergeSort(T[] TArray, Comparator<? super T> comparator) {
        Object[] objectArray = (Object[])g.convertForCast((Object)a.cloneArray(TArray), Object[].class);
        if (comparator == null) {
            Arrays.mergeSort(objectArray, TArray, 0, a.arrayLength((Object[])TArray), 0);
        } else {
            Arrays.mergeSort(objectArray, TArray, 0, a.arrayLength((Object[])TArray), 0, comparator);
        }
    }

    public static <T> void sort(T[] TArray, int n2, int n3, Comparator<? super T> comparator) {
        if (LegacyMergeSort.userRequested) {
            Arrays.legacyMergeSort(TArray, n2, n3, comparator);
        } else {
            TimSort.sort(TArray, n2, n3, comparator);
        }
    }

    private static <T> void legacyMergeSort(T[] TArray, int n2, int n3, Comparator<? super T> comparator) {
        Arrays.rangeCheck(a.arrayLength((Object[])TArray), n2, n3);
        Object[] objectArray = Arrays.copyOfRange(TArray, n2, n3);
        if (comparator == null) {
            Arrays.mergeSort(objectArray, TArray, n2, n3, -n2);
        } else {
            Arrays.mergeSort(objectArray, TArray, n2, n3, -n2, comparator);
        }
    }

    private static void mergeSort(Object[] objectArray, Object[] objectArray2, int n2, int n3, int n4, Comparator comparator) {
        int n5 = n3 - n2;
        if (n5 < 7) {
            for (int i = n2; i < n3; ++i) {
                for (int k = i; k > n2 && comparator.compare(a.arrayLoad((Object[])objectArray2, (int)(k - 1)), a.arrayLoad((Object[])objectArray2, (int)k)) > 0; --k) {
                    Arrays.swap(objectArray2, k, k - 1);
                }
            }
            return;
        }
        int n6 = n2;
        int n7 = n3;
        int n8 = (n2 += n4) + (n3 += n4) >>> 1;
        Arrays.mergeSort(objectArray2, objectArray, n2, n8, -n4, comparator);
        Arrays.mergeSort(objectArray2, objectArray, n8, n3, -n4, comparator);
        if (comparator.compare(a.arrayLoad((Object[])objectArray, (int)(n8 - 1)), a.arrayLoad((Object[])objectArray, (int)n8)) <= 0) {
            a.arraycopy((Object)objectArray, (int)n2, (Object)objectArray2, (int)n6, (int)n5);
            return;
        }
        int n9 = n2;
        int n10 = n8;
        for (int i = n6; i < n7; ++i) {
            if (n10 >= n3 || n9 < n8 && comparator.compare(a.arrayLoad((Object[])objectArray, (int)n9), a.arrayLoad((Object[])objectArray, (int)n10)) <= 0) {
                a.arrayStore((Object[])objectArray2, (int)i, (Object)a.arrayLoad((Object[])objectArray, (int)n9++));
                continue;
            }
            a.arrayStore((Object[])objectArray2, (int)i, (Object)a.arrayLoad((Object[])objectArray, (int)n10++));
        }
    }

    private static void rangeCheck(int n2, int n3, int n4) {
        if (n3 > n4) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("fromIndex(" + n3 + ") > toIndex(" + n4 + ")"));
        }
        if (n3 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ArrayIndexOutOfBoundsException(n3));
        }
        if (n4 > n2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ArrayIndexOutOfBoundsException(n4));
        }
    }

    public static int binarySearch(long[] lArray, long l2) {
        return Arrays.binarySearch0(lArray, 0, lArray.length, l2);
    }

    public static int binarySearch(long[] lArray, int n2, int n3, long l2) {
        Arrays.rangeCheck(lArray.length, n2, n3);
        return Arrays.binarySearch0(lArray, n2, n3, l2);
    }

    private static int binarySearch0(long[] lArray, int n2, int n3, long l2) {
        int n4 = n2;
        int n5 = n3 - 1;
        while (n4 <= n5) {
            int n6 = n4 + n5 >>> 1;
            long l3 = lArray[n6];
            if (l3 < l2) {
                n4 = n6 + 1;
                continue;
            }
            if (l3 > l2) {
                n5 = n6 - 1;
                continue;
            }
            return n6;
        }
        return -(n4 + 1);
    }

    public static int binarySearch(int[] nArray, int n2) {
        return Arrays.binarySearch0(nArray, 0, nArray.length, n2);
    }

    public static int binarySearch(int[] nArray, int n2, int n3, int n4) {
        Arrays.rangeCheck(nArray.length, n2, n3);
        return Arrays.binarySearch0(nArray, n2, n3, n4);
    }

    private static int binarySearch0(int[] nArray, int n2, int n3, int n4) {
        int n5 = n2;
        int n6 = n3 - 1;
        while (n5 <= n6) {
            int n7 = n5 + n6 >>> 1;
            int n8 = nArray[n7];
            if (n8 < n4) {
                n5 = n7 + 1;
                continue;
            }
            if (n8 > n4) {
                n6 = n7 - 1;
                continue;
            }
            return n7;
        }
        return -(n5 + 1);
    }

    public static int binarySearch(short[] sArray, short s) {
        return Arrays.binarySearch0(sArray, 0, sArray.length, s);
    }

    public static int binarySearch(short[] sArray, int n2, int n3, short s) {
        Arrays.rangeCheck(sArray.length, n2, n3);
        return Arrays.binarySearch0(sArray, n2, n3, s);
    }

    private static int binarySearch0(short[] sArray, int n2, int n3, short s) {
        int n4 = n2;
        int n5 = n3 - 1;
        while (n4 <= n5) {
            int n6 = n4 + n5 >>> 1;
            short s2 = sArray[n6];
            if (s2 < s) {
                n4 = n6 + 1;
                continue;
            }
            if (s2 > s) {
                n5 = n6 - 1;
                continue;
            }
            return n6;
        }
        return -(n4 + 1);
    }

    public static int binarySearch(char[] cArray, char c2) {
        return Arrays.binarySearch0(cArray, 0, cArray.length, c2);
    }

    public static int binarySearch(char[] cArray, int n2, int n3, char c2) {
        Arrays.rangeCheck(cArray.length, n2, n3);
        return Arrays.binarySearch0(cArray, n2, n3, c2);
    }

    private static int binarySearch0(char[] cArray, int n2, int n3, char c2) {
        int n4 = n2;
        int n5 = n3 - 1;
        while (n4 <= n5) {
            int n6 = n4 + n5 >>> 1;
            char c3 = cArray[n6];
            if (c3 < c2) {
                n4 = n6 + 1;
                continue;
            }
            if (c3 > c2) {
                n5 = n6 - 1;
                continue;
            }
            return n6;
        }
        return -(n4 + 1);
    }

    public static int binarySearch(byte[] byArray, byte by) {
        return Arrays.binarySearch0(byArray, 0, byArray.length, by);
    }

    public static int binarySearch(byte[] byArray, int n2, int n3, byte by) {
        Arrays.rangeCheck(byArray.length, n2, n3);
        return Arrays.binarySearch0(byArray, n2, n3, by);
    }

    private static int binarySearch0(byte[] byArray, int n2, int n3, byte by) {
        int n4 = n2;
        int n5 = n3 - 1;
        while (n4 <= n5) {
            int n6 = n4 + n5 >>> 1;
            byte by2 = byArray[n6];
            if (by2 < by) {
                n4 = n6 + 1;
                continue;
            }
            if (by2 > by) {
                n5 = n6 - 1;
                continue;
            }
            return n6;
        }
        return -(n4 + 1);
    }

    public static int binarySearch(double[] dArray, double d) {
        return Arrays.binarySearch0(dArray, 0, dArray.length, d);
    }

    public static int binarySearch(double[] dArray, int n2, int n3, double d) {
        Arrays.rangeCheck(dArray.length, n2, n3);
        return Arrays.binarySearch0(dArray, n2, n3, d);
    }

    private static int binarySearch0(double[] dArray, int n2, int n3, double d) {
        int n4 = n2;
        int n5 = n3 - 1;
        while (n4 <= n5) {
            long l2;
            int n6 = n4 + n5 >>> 1;
            double d2 = dArray[n6];
            if (d2 < d) {
                n4 = n6 + 1;
                continue;
            }
            if (d2 > d) {
                n5 = n6 - 1;
                continue;
            }
            long l3 = Double.doubleToLongBits(d2);
            if (l3 == (l2 = Double.doubleToLongBits(d))) {
                return n6;
            }
            if (l3 < l2) {
                n4 = n6 + 1;
                continue;
            }
            n5 = n6 - 1;
        }
        return -(n4 + 1);
    }

    public static int binarySearch(float[] fArray, float f2) {
        return Arrays.binarySearch0(fArray, 0, fArray.length, f2);
    }

    public static int binarySearch(float[] fArray, int n2, int n3, float f2) {
        Arrays.rangeCheck(fArray.length, n2, n3);
        return Arrays.binarySearch0(fArray, n2, n3, f2);
    }

    private static int binarySearch0(float[] fArray, int n2, int n3, float f2) {
        int n4 = n2;
        int n5 = n3 - 1;
        while (n4 <= n5) {
            int n6;
            int n7 = n4 + n5 >>> 1;
            float f3 = fArray[n7];
            if (f3 < f2) {
                n4 = n7 + 1;
                continue;
            }
            if (f3 > f2) {
                n5 = n7 - 1;
                continue;
            }
            int n8 = Float.floatToIntBits(f3);
            if (n8 == (n6 = Float.floatToIntBits(f2))) {
                return n7;
            }
            if (n8 < n6) {
                n4 = n7 + 1;
                continue;
            }
            n5 = n7 - 1;
        }
        return -(n4 + 1);
    }

    public static int binarySearch(Object[] objectArray, Object object) {
        return Arrays.binarySearch0(objectArray, 0, a.arrayLength((Object[])objectArray), object);
    }

    public static int binarySearch(Object[] objectArray, int n2, int n3, Object object) {
        Arrays.rangeCheck(a.arrayLength((Object[])objectArray), n2, n3);
        return Arrays.binarySearch0(objectArray, n2, n3, object);
    }

    private static int binarySearch0(Object[] objectArray, int n2, int n3, Object object) {
        int n4 = n2;
        int n5 = n3 - 1;
        while (n4 <= n5) {
            int n6 = n4 + n5 >>> 1;
            Comparable comparable = (Comparable)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)n6), Comparable.class);
            int n7 = comparable.compareTo(object);
            if (n7 < 0) {
                n4 = n6 + 1;
                continue;
            }
            if (n7 > 0) {
                n5 = n6 - 1;
                continue;
            }
            return n6;
        }
        return -(n4 + 1);
    }

    public static <T> int binarySearch(T[] TArray, T t, Comparator<? super T> comparator) {
        return Arrays.binarySearch0(TArray, 0, a.arrayLength((Object[])TArray), t, comparator);
    }

    public static <T> int binarySearch(T[] TArray, int n2, int n3, T t, Comparator<? super T> comparator) {
        Arrays.rangeCheck(a.arrayLength((Object[])TArray), n2, n3);
        return Arrays.binarySearch0(TArray, n2, n3, t, comparator);
    }

    private static <T> int binarySearch0(T[] TArray, int n2, int n3, T t, Comparator<? super T> comparator) {
        if (comparator == null) {
            return Arrays.binarySearch0(TArray, n2, n3, t);
        }
        int n4 = n2;
        int n5 = n3 - 1;
        while (n4 <= n5) {
            int n6 = n4 + n5 >>> 1;
            Object object = a.arrayLoad((Object[])TArray, (int)n6);
            int n7 = comparator.compare(object, t);
            if (n7 < 0) {
                n4 = n6 + 1;
                continue;
            }
            if (n7 > 0) {
                n5 = n6 - 1;
                continue;
            }
            return n6;
        }
        return -(n4 + 1);
    }

    public static boolean equals(long[] lArray, long[] lArray2) {
        if (!f.ifAcmp((Object)lArray, (Object)lArray2)) {
            return true;
        }
        if (lArray == null || lArray2 == null) {
            return false;
        }
        int n2 = lArray.length;
        if (lArray2.length != n2) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (lArray[i] == lArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(int[] nArray, int[] nArray2) {
        if (!f.ifAcmp((Object)nArray, (Object)nArray2)) {
            return true;
        }
        if (nArray == null || nArray2 == null) {
            return false;
        }
        int n2 = nArray.length;
        if (nArray2.length != n2) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(short[] sArray, short[] sArray2) {
        if (!f.ifAcmp((Object)sArray, (Object)sArray2)) {
            return true;
        }
        if (sArray == null || sArray2 == null) {
            return false;
        }
        int n2 = sArray.length;
        if (sArray2.length != n2) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (sArray[i] == sArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(char[] cArray, char[] cArray2) {
        if (!f.ifAcmp((Object)cArray, (Object)cArray2)) {
            return true;
        }
        if (cArray == null || cArray2 == null) {
            return false;
        }
        int n2 = cArray.length;
        if (cArray2.length != n2) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (cArray[i] == cArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(byte[] byArray, byte[] byArray2) {
        if (!f.ifAcmp((Object)byArray, (Object)byArray2)) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        int n2 = byArray.length;
        if (byArray2.length != n2) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(boolean[] blArray, boolean[] blArray2) {
        if (!f.ifAcmp((Object)blArray, (Object)blArray2)) {
            return true;
        }
        if (blArray == null || blArray2 == null) {
            return false;
        }
        int n2 = blArray.length;
        if (blArray2.length != n2) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (blArray[i] == blArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(double[] dArray, double[] dArray2) {
        if (!f.ifAcmp((Object)dArray, (Object)dArray2)) {
            return true;
        }
        if (dArray == null || dArray2 == null) {
            return false;
        }
        int n2 = dArray.length;
        if (dArray2.length != n2) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (Double.doubleToLongBits(dArray[i]) == Double.doubleToLongBits(dArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(float[] fArray, float[] fArray2) {
        if (!f.ifAcmp((Object)fArray, (Object)fArray2)) {
            return true;
        }
        if (fArray == null || fArray2 == null) {
            return false;
        }
        int n2 = fArray.length;
        if (fArray2.length != n2) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (Float.floatToIntBits(fArray[i]) == Float.floatToIntBits(fArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object[] objectArray, Object[] objectArray2) {
        if (!f.ifAcmp((Object)objectArray, (Object)objectArray2)) {
            return true;
        }
        if (objectArray == null || objectArray2 == null) {
            return false;
        }
        int n2 = a.arrayLength((Object[])objectArray);
        if (a.arrayLength((Object[])objectArray2) != n2) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            Object object = a.arrayLoad((Object[])objectArray, (int)i);
            Object object2 = a.arrayLoad((Object[])objectArray2, (int)i);
            if (object != null ? object.equals(object2) : object2 == null) continue;
            return false;
        }
        return true;
    }

    public static void fill(long[] lArray, long l2) {
        int n2 = lArray.length;
        for (int i = 0; i < n2; ++i) {
            lArray[i] = l2;
        }
    }

    public static void fill(long[] lArray, int n2, int n3, long l2) {
        Arrays.rangeCheck(lArray.length, n2, n3);
        for (int i = n2; i < n3; ++i) {
            lArray[i] = l2;
        }
    }

    public static void fill(int[] nArray, int n2) {
        int n3 = nArray.length;
        for (int i = 0; i < n3; ++i) {
            nArray[i] = n2;
        }
    }

    public static void fill(int[] nArray, int n2, int n3, int n4) {
        Arrays.rangeCheck(nArray.length, n2, n3);
        for (int i = n2; i < n3; ++i) {
            nArray[i] = n4;
        }
    }

    public static void fill(short[] sArray, short s) {
        int n2 = sArray.length;
        for (int i = 0; i < n2; ++i) {
            sArray[i] = s;
        }
    }

    public static void fill(short[] sArray, int n2, int n3, short s) {
        Arrays.rangeCheck(sArray.length, n2, n3);
        for (int i = n2; i < n3; ++i) {
            sArray[i] = s;
        }
    }

    public static void fill(char[] cArray, char c2) {
        int n2 = cArray.length;
        for (int i = 0; i < n2; ++i) {
            cArray[i] = c2;
        }
    }

    public static void fill(char[] cArray, int n2, int n3, char c2) {
        Arrays.rangeCheck(cArray.length, n2, n3);
        for (int i = n2; i < n3; ++i) {
            cArray[i] = c2;
        }
    }

    public static void fill(byte[] byArray, byte by) {
        int n2 = byArray.length;
        for (int i = 0; i < n2; ++i) {
            byArray[i] = by;
        }
    }

    public static void fill(byte[] byArray, int n2, int n3, byte by) {
        Arrays.rangeCheck(byArray.length, n2, n3);
        for (int i = n2; i < n3; ++i) {
            byArray[i] = by;
        }
    }

    public static void fill(boolean[] blArray, boolean bl) {
        int n2 = blArray.length;
        for (int i = 0; i < n2; ++i) {
            blArray[i] = bl;
        }
    }

    public static void fill(boolean[] blArray, int n2, int n3, boolean bl) {
        Arrays.rangeCheck(blArray.length, n2, n3);
        for (int i = n2; i < n3; ++i) {
            blArray[i] = bl;
        }
    }

    public static void fill(double[] dArray, double d) {
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            dArray[i] = d;
        }
    }

    public static void fill(double[] dArray, int n2, int n3, double d) {
        Arrays.rangeCheck(dArray.length, n2, n3);
        for (int i = n2; i < n3; ++i) {
            dArray[i] = d;
        }
    }

    public static void fill(float[] fArray, float f2) {
        int n2 = fArray.length;
        for (int i = 0; i < n2; ++i) {
            fArray[i] = f2;
        }
    }

    public static void fill(float[] fArray, int n2, int n3, float f2) {
        Arrays.rangeCheck(fArray.length, n2, n3);
        for (int i = n2; i < n3; ++i) {
            fArray[i] = f2;
        }
    }

    public static void fill(Object[] objectArray, Object object) {
        int n2 = a.arrayLength((Object[])objectArray);
        for (int i = 0; i < n2; ++i) {
            a.arrayStore((Object[])objectArray, (int)i, (Object)object);
        }
    }

    public static void fill(Object[] objectArray, int n2, int n3, Object object) {
        Arrays.rangeCheck(a.arrayLength((Object[])objectArray), n2, n3);
        for (int i = n2; i < n3; ++i) {
            a.arrayStore((Object[])objectArray, (int)i, (Object)object);
        }
    }

    public static <T> T[] copyOf(T[] TArray, int n2) {
        return (Object[])g.convertForCast((Object)a.copyOf((Object[])TArray, (int)n2, TArray.getClass()), Object[].class);
    }

    public static <T, U> T[] copyOf(U[] UArray, int n2, Class<? extends T[]> clazz) {
        Object[] objectArray = !f.ifAcmp(clazz, Object[].class) ? (Object[])g.convertForCast((Object)new Object[n2], Object[].class) : (Object[])g.convertForCast((Object)((Object[])g.convertForCast((Object)Array.newInstance(ai.getCurrentClass(clazz).getComponentType(), n2), Object[].class)), Object[].class);
        a.arraycopy(UArray, (int)0, (Object)objectArray, (int)0, (int)Math.min(a.arrayLength((Object[])UArray), n2));
        return objectArray;
    }

    public static byte[] copyOf(byte[] byArray, int n2) {
        byte[] byArray2 = new byte[n2];
        a.arraycopy((Object)byArray, (int)0, (Object)byArray2, (int)0, (int)Math.min(byArray.length, n2));
        return byArray2;
    }

    public static short[] copyOf(short[] sArray, int n2) {
        short[] sArray2 = new short[n2];
        a.arraycopy((Object)sArray, (int)0, (Object)sArray2, (int)0, (int)Math.min(sArray.length, n2));
        return sArray2;
    }

    public static int[] copyOf(int[] nArray, int n2) {
        int[] nArray2 = new int[n2];
        a.arraycopy((Object)nArray, (int)0, (Object)nArray2, (int)0, (int)Math.min(nArray.length, n2));
        return nArray2;
    }

    public static long[] copyOf(long[] lArray, int n2) {
        long[] lArray2 = new long[n2];
        a.arraycopy((Object)lArray, (int)0, (Object)lArray2, (int)0, (int)Math.min(lArray.length, n2));
        return lArray2;
    }

    public static char[] copyOf(char[] cArray, int n2) {
        char[] cArray2 = new char[n2];
        a.arraycopy((Object)cArray, (int)0, (Object)cArray2, (int)0, (int)Math.min(cArray.length, n2));
        return cArray2;
    }

    public static float[] copyOf(float[] fArray, int n2) {
        float[] fArray2 = new float[n2];
        a.arraycopy((Object)fArray, (int)0, (Object)fArray2, (int)0, (int)Math.min(fArray.length, n2));
        return fArray2;
    }

    public static double[] copyOf(double[] dArray, int n2) {
        double[] dArray2 = new double[n2];
        a.arraycopy((Object)dArray, (int)0, (Object)dArray2, (int)0, (int)Math.min(dArray.length, n2));
        return dArray2;
    }

    public static boolean[] copyOf(boolean[] blArray, int n2) {
        boolean[] blArray2 = new boolean[n2];
        a.arraycopy((Object)blArray, (int)0, (Object)blArray2, (int)0, (int)Math.min(blArray.length, n2));
        return blArray2;
    }

    public static <T> T[] copyOfRange(T[] TArray, int n2, int n3) {
        return a.copyOfRange((Object[])TArray, (int)n2, (int)n3, TArray.getClass());
    }

    public static <T, U> T[] copyOfRange(U[] UArray, int n2, int n3, Class<? extends T[]> clazz) {
        int n4 = n3 - n2;
        if (n4 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException(n2 + " > " + n3));
        }
        Object[] objectArray = !f.ifAcmp(clazz, Object[].class) ? (Object[])g.convertForCast((Object)new Object[n4], Object[].class) : (Object[])g.convertForCast((Object)((Object[])g.convertForCast((Object)Array.newInstance(ai.getCurrentClass(clazz).getComponentType(), n4), Object[].class)), Object[].class);
        a.arraycopy(UArray, (int)n2, (Object)objectArray, (int)0, (int)Math.min(a.arrayLength((Object[])UArray) - n2, n4));
        return objectArray;
    }

    public static byte[] copyOfRange(byte[] byArray, int n2, int n3) {
        int n4 = n3 - n2;
        if (n4 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException(n2 + " > " + n3));
        }
        byte[] byArray2 = new byte[n4];
        a.arraycopy((Object)byArray, (int)n2, (Object)byArray2, (int)0, (int)Math.min(byArray.length - n2, n4));
        return byArray2;
    }

    public static short[] copyOfRange(short[] sArray, int n2, int n3) {
        int n4 = n3 - n2;
        if (n4 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException(n2 + " > " + n3));
        }
        short[] sArray2 = new short[n4];
        a.arraycopy((Object)sArray, (int)n2, (Object)sArray2, (int)0, (int)Math.min(sArray.length - n2, n4));
        return sArray2;
    }

    public static int[] copyOfRange(int[] nArray, int n2, int n3) {
        int n4 = n3 - n2;
        if (n4 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException(n2 + " > " + n3));
        }
        int[] nArray2 = new int[n4];
        a.arraycopy((Object)nArray, (int)n2, (Object)nArray2, (int)0, (int)Math.min(nArray.length - n2, n4));
        return nArray2;
    }

    public static long[] copyOfRange(long[] lArray, int n2, int n3) {
        int n4 = n3 - n2;
        if (n4 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException(n2 + " > " + n3));
        }
        long[] lArray2 = new long[n4];
        a.arraycopy((Object)lArray, (int)n2, (Object)lArray2, (int)0, (int)Math.min(lArray.length - n2, n4));
        return lArray2;
    }

    public static char[] copyOfRange(char[] cArray, int n2, int n3) {
        int n4 = n3 - n2;
        if (n4 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException(n2 + " > " + n3));
        }
        char[] cArray2 = new char[n4];
        a.arraycopy((Object)cArray, (int)n2, (Object)cArray2, (int)0, (int)Math.min(cArray.length - n2, n4));
        return cArray2;
    }

    public static float[] copyOfRange(float[] fArray, int n2, int n3) {
        int n4 = n3 - n2;
        if (n4 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException(n2 + " > " + n3));
        }
        float[] fArray2 = new float[n4];
        a.arraycopy((Object)fArray, (int)n2, (Object)fArray2, (int)0, (int)Math.min(fArray.length - n2, n4));
        return fArray2;
    }

    public static double[] copyOfRange(double[] dArray, int n2, int n3) {
        int n4 = n3 - n2;
        if (n4 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException(n2 + " > " + n3));
        }
        double[] dArray2 = new double[n4];
        a.arraycopy((Object)dArray, (int)n2, (Object)dArray2, (int)0, (int)Math.min(dArray.length - n2, n4));
        return dArray2;
    }

    public static boolean[] copyOfRange(boolean[] blArray, int n2, int n3) {
        int n4 = n3 - n2;
        if (n4 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException(n2 + " > " + n3));
        }
        boolean[] blArray2 = new boolean[n4];
        a.arraycopy((Object)blArray, (int)n2, (Object)blArray2, (int)0, (int)Math.min(blArray.length - n2, n4));
        return blArray2;
    }

    @SafeVarargs
    public static <T> List<T> asList(T ... TArray) {
        return new ArrayList<T>(TArray);
    }

    public static int hashCode(long[] lArray) {
        if (lArray == null) {
            return 0;
        }
        int n2 = 1;
        for (long l2 : lArray) {
            int n3 = (int)(l2 ^ l2 >>> 32);
            n2 = 31 * n2 + n3;
        }
        return n2;
    }

    public static int hashCode(int[] nArray) {
        if (nArray == null) {
            return 0;
        }
        int n2 = 1;
        for (int n3 : nArray) {
            n2 = 31 * n2 + n3;
        }
        return n2;
    }

    public static int hashCode(short[] sArray) {
        if (sArray == null) {
            return 0;
        }
        int n2 = 1;
        for (short s : sArray) {
            n2 = 31 * n2 + s;
        }
        return n2;
    }

    public static int hashCode(char[] cArray) {
        if (cArray == null) {
            return 0;
        }
        int n2 = 1;
        for (char c2 : cArray) {
            n2 = 31 * n2 + c2;
        }
        return n2;
    }

    public static int hashCode(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        int n2 = 1;
        for (byte by : byArray) {
            n2 = 31 * n2 + by;
        }
        return n2;
    }

    public static int hashCode(boolean[] blArray) {
        if (blArray == null) {
            return 0;
        }
        int n2 = 1;
        for (boolean bl : blArray) {
            n2 = 31 * n2 + (bl ? 1231 : 1237);
        }
        return n2;
    }

    public static int hashCode(float[] fArray) {
        if (fArray == null) {
            return 0;
        }
        int n2 = 1;
        for (float f2 : fArray) {
            n2 = 31 * n2 + Float.floatToIntBits(f2);
        }
        return n2;
    }

    public static int hashCode(double[] dArray) {
        if (dArray == null) {
            return 0;
        }
        int n2 = 1;
        for (double d : dArray) {
            long l2 = Double.doubleToLongBits(d);
            n2 = 31 * n2 + (int)(l2 ^ l2 >>> 32);
        }
        return n2;
    }

    public static int hashCode(Object[] objectArray) {
        if (objectArray == null) {
            return 0;
        }
        int n2 = 1;
        Object[] objectArray2 = objectArray;
        int n3 = a.arrayLength((Object[])objectArray2);
        for (int i = 0; i < n3; ++i) {
            Object object = a.arrayLoad((Object[])objectArray2, (int)i);
            n2 = 31 * n2 + (object == null ? 0 : object.hashCode());
        }
        return n2;
    }

    public static int deepHashCode(Object[] objectArray) {
        if (objectArray == null) {
            return 0;
        }
        int n2 = 1;
        Object[] objectArray2 = objectArray;
        int n3 = a.arrayLength((Object[])objectArray2);
        for (int i = 0; i < n3; ++i) {
            Object object = a.arrayLoad((Object[])objectArray2, (int)i);
            int n4 = 0;
            if (g.convertForInstanceOf((Object)object, Object[].class) instanceof Object[]) {
                n4 = Arrays.deepHashCode((Object[])g.convertForCast((Object)((Object[])g.convertForCast((Object)object, Object[].class)), Object[].class));
            } else if (object instanceof byte[]) {
                n4 = Arrays.hashCode((byte[])object);
            } else if (object instanceof short[]) {
                n4 = Arrays.hashCode((short[])object);
            } else if (object instanceof int[]) {
                n4 = Arrays.hashCode((int[])object);
            } else if (object instanceof long[]) {
                n4 = Arrays.hashCode((long[])object);
            } else if (object instanceof char[]) {
                n4 = Arrays.hashCode((char[])object);
            } else if (object instanceof float[]) {
                n4 = Arrays.hashCode((float[])object);
            } else if (object instanceof double[]) {
                n4 = Arrays.hashCode((double[])object);
            } else if (object instanceof boolean[]) {
                n4 = Arrays.hashCode((boolean[])object);
            } else if (object != null) {
                n4 = object.hashCode();
            }
            n2 = 31 * n2 + n4;
        }
        return n2;
    }

    public static boolean deepEquals(Object[] objectArray, Object[] objectArray2) {
        if (!f.ifAcmp((Object)objectArray, (Object)objectArray2)) {
            return true;
        }
        if (objectArray == null || objectArray2 == null) {
            return false;
        }
        int n2 = a.arrayLength((Object[])objectArray);
        if (a.arrayLength((Object[])objectArray2) != n2) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            Object object;
            Object object2 = a.arrayLoad((Object[])objectArray, (int)i);
            if (!f.ifAcmp((Object)object2, (Object)(object = a.arrayLoad((Object[])objectArray2, (int)i)))) continue;
            if (object2 == null) {
                return false;
            }
            boolean bl = Arrays.deepEquals0(object2, object);
            if (bl) continue;
            return false;
        }
        return true;
    }

    static boolean deepEquals0(Object object, Object object2) {
        if (!$assertionsDisabled && object == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        boolean bl = g.convertForInstanceOf((Object)object, Object[].class) instanceof Object[] && g.convertForInstanceOf((Object)object2, Object[].class) instanceof Object[] ? Arrays.deepEquals((Object[])g.convertForCast((Object)((Object[])g.convertForCast((Object)object, Object[].class)), Object[].class), (Object[])g.convertForCast((Object)((Object[])g.convertForCast((Object)object2, Object[].class)), Object[].class)) : (object instanceof byte[] && object2 instanceof byte[] ? Arrays.equals((byte[])object, (byte[])object2) : (object instanceof short[] && object2 instanceof short[] ? Arrays.equals((short[])object, (short[])object2) : (object instanceof int[] && object2 instanceof int[] ? Arrays.equals((int[])object, (int[])object2) : (object instanceof long[] && object2 instanceof long[] ? Arrays.equals((long[])object, (long[])object2) : (object instanceof char[] && object2 instanceof char[] ? Arrays.equals((char[])object, (char[])object2) : (object instanceof float[] && object2 instanceof float[] ? Arrays.equals((float[])object, (float[])object2) : (object instanceof double[] && object2 instanceof double[] ? Arrays.equals((double[])object, (double[])object2) : (object instanceof boolean[] && object2 instanceof boolean[] ? Arrays.equals((boolean[])object, (boolean[])object2) : object.equals(object2)))))))));
        return bl;
    }

    public static String toString(long[] lArray) {
        if (lArray == null) {
            return "null";
        }
        int n2 = lArray.length - 1;
        if (n2 == -1) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n3 = 0;
        while (true) {
            stringBuilder.append(lArray[n3]);
            if (n3 == n2) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(", ");
            ++n3;
        }
    }

    public static String toString(int[] nArray) {
        if (nArray == null) {
            return "null";
        }
        int n2 = nArray.length - 1;
        if (n2 == -1) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n3 = 0;
        while (true) {
            stringBuilder.append(nArray[n3]);
            if (n3 == n2) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(", ");
            ++n3;
        }
    }

    public static String toString(short[] sArray) {
        if (sArray == null) {
            return "null";
        }
        int n2 = sArray.length - 1;
        if (n2 == -1) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n3 = 0;
        while (true) {
            stringBuilder.append(sArray[n3]);
            if (n3 == n2) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(", ");
            ++n3;
        }
    }

    public static String toString(char[] cArray) {
        if (cArray == null) {
            return "null";
        }
        int n2 = cArray.length - 1;
        if (n2 == -1) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n3 = 0;
        while (true) {
            stringBuilder.append(cArray[n3]);
            if (n3 == n2) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(", ");
            ++n3;
        }
    }

    public static String toString(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        int n2 = byArray.length - 1;
        if (n2 == -1) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n3 = 0;
        while (true) {
            stringBuilder.append(byArray[n3]);
            if (n3 == n2) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(", ");
            ++n3;
        }
    }

    public static String toString(boolean[] blArray) {
        if (blArray == null) {
            return "null";
        }
        int n2 = blArray.length - 1;
        if (n2 == -1) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n3 = 0;
        while (true) {
            stringBuilder.append(blArray[n3]);
            if (n3 == n2) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(", ");
            ++n3;
        }
    }

    public static String toString(float[] fArray) {
        if (fArray == null) {
            return "null";
        }
        int n2 = fArray.length - 1;
        if (n2 == -1) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n3 = 0;
        while (true) {
            stringBuilder.append(fArray[n3]);
            if (n3 == n2) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(", ");
            ++n3;
        }
    }

    public static String toString(double[] dArray) {
        if (dArray == null) {
            return "null";
        }
        int n2 = dArray.length - 1;
        if (n2 == -1) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n3 = 0;
        while (true) {
            stringBuilder.append(dArray[n3]);
            if (n3 == n2) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(", ");
            ++n3;
        }
    }

    public static String toString(Object[] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        int n2 = a.arrayLength((Object[])objectArray) - 1;
        if (n2 == -1) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n3 = 0;
        while (true) {
            stringBuilder.append(String.valueOf(a.arrayLoad((Object[])objectArray, (int)n3)));
            if (n3 == n2) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(", ");
            ++n3;
        }
    }

    public static String deepToString(Object[] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        int n2 = 20 * a.arrayLength((Object[])objectArray);
        if (a.arrayLength((Object[])objectArray) != 0 && n2 <= 0) {
            n2 = Integer.MAX_VALUE;
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        Arrays.deepToString(objectArray, stringBuilder, new HashSet<Object[]>());
        return stringBuilder.toString();
    }

    private static void deepToString(Object[] objectArray, StringBuilder stringBuilder, Set<Object[]> set) {
        if (objectArray == null) {
            stringBuilder.append("null");
            return;
        }
        int n2 = a.arrayLength((Object[])objectArray) - 1;
        if (n2 == -1) {
            stringBuilder.append("[]");
            return;
        }
        set.add(objectArray);
        stringBuilder.append('[');
        int n3 = 0;
        while (true) {
            Object object;
            if ((object = a.arrayLoad((Object[])objectArray, (int)n3)) == null) {
                stringBuilder.append("null");
            } else {
                Class<?> clazz = object.getClass();
                if (ai.getCurrentClass(clazz).isArray()) {
                    if (!f.ifAcmp(clazz, byte[].class)) {
                        stringBuilder.append(Arrays.toString((byte[])object));
                    } else if (!f.ifAcmp(clazz, short[].class)) {
                        stringBuilder.append(Arrays.toString((short[])object));
                    } else if (!f.ifAcmp(clazz, int[].class)) {
                        stringBuilder.append(Arrays.toString((int[])object));
                    } else if (!f.ifAcmp(clazz, long[].class)) {
                        stringBuilder.append(Arrays.toString((long[])object));
                    } else if (!f.ifAcmp(clazz, char[].class)) {
                        stringBuilder.append(Arrays.toString((char[])object));
                    } else if (!f.ifAcmp(clazz, float[].class)) {
                        stringBuilder.append(Arrays.toString((float[])object));
                    } else if (!f.ifAcmp(clazz, double[].class)) {
                        stringBuilder.append(Arrays.toString((double[])object));
                    } else if (!f.ifAcmp(clazz, boolean[].class)) {
                        stringBuilder.append(Arrays.toString((boolean[])object));
                    } else if (set.contains(object)) {
                        stringBuilder.append("[...]");
                    } else {
                        Arrays.deepToString((Object[])g.convertForCast((Object)((Object[])g.convertForCast((Object)object, Object[].class)), Object[].class), stringBuilder, set);
                    }
                } else {
                    stringBuilder.append(object.toString());
                }
            }
            if (n3 == n2) break;
            stringBuilder.append(", ");
            ++n3;
        }
        stringBuilder.append(']');
        set.remove(objectArray);
    }

    protected /* synthetic */ Arrays(h h2) {
        super(h2);
    }

    private static class ArrayList<E>
    extends AbstractList<E>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = -2764017481108945198L;
        private final E[] a;

        ArrayList(E[] EArray) {
            if (EArray == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
            }
            this.a = EArray;
        }

        @Override
        public int size() {
            return com.zeroturnaround.jrebelbase.facade.a.arrayLength((Object[])this.a);
        }

        @Override
        public Object[] toArray() {
            return (Object[])g.convertForCast((Object)com.zeroturnaround.jrebelbase.facade.a.cloneArray((Object)this.a), Object[].class);
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            int n2 = this.size();
            if (com.zeroturnaround.jrebelbase.facade.a.arrayLength((Object[])TArray) < n2) {
                return com.zeroturnaround.jrebelbase.facade.a.copyOf((Object[])this.a, (int)n2, TArray.getClass());
            }
            com.zeroturnaround.jrebelbase.facade.a.arraycopy((Object)this.a, (int)0, TArray, (int)0, (int)n2);
            if (com.zeroturnaround.jrebelbase.facade.a.arrayLength((Object[])TArray) > n2) {
                com.zeroturnaround.jrebelbase.facade.a.arrayStore((Object[])TArray, (int)n2, null);
            }
            return TArray;
        }

        @Override
        public E get(int n2) {
            return (E)com.zeroturnaround.jrebelbase.facade.a.arrayLoad((Object[])this.a, (int)n2);
        }

        @Override
        public E set(int n2, E e2) {
            Object object = com.zeroturnaround.jrebelbase.facade.a.arrayLoad((Object[])this.a, (int)n2);
            com.zeroturnaround.jrebelbase.facade.a.arrayStore((Object[])this.a, (int)n2, e2);
            return (E)object;
        }

        @Override
        public int indexOf(Object object) {
            if (object == null) {
                for (int i = 0; i < com.zeroturnaround.jrebelbase.facade.a.arrayLength((Object[])this.a); ++i) {
                    if (com.zeroturnaround.jrebelbase.facade.a.arrayLoad((Object[])this.a, (int)i) != null) continue;
                    return i;
                }
            } else {
                for (int i = 0; i < com.zeroturnaround.jrebelbase.facade.a.arrayLength((Object[])this.a); ++i) {
                    if (!object.equals(com.zeroturnaround.jrebelbase.facade.a.arrayLoad((Object[])this.a, (int)i))) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public boolean contains(Object object) {
            return this.indexOf(object) != -1;
        }

        private static /* synthetic */ void _jr$ip$a(ArrayList arrayList, Object[] objectArray) {
            arrayList.a = objectArray;
        }

        protected /* synthetic */ ArrayList(h h2) {
            super(h2);
        }
    }

    static final class LegacyMergeSort
    extends h {
        private static final boolean userRequested = (Boolean)g.convertForCast(AccessController.doPrivileged(new GetBooleanAction("java.util.Arrays.useLegacyMergeSort")), Boolean.class);

        LegacyMergeSort() {
        }
    }
}

