/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.util.Arrays;

public class BitSet
extends h
implements Cloneable,
Serializable {
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;
    private static final int BIT_INDEX_MASK = 63;
    private static final long WORD_MASK = -1L;
    private static final ObjectStreamField[] serialPersistentFields;
    private long[] words;
    private transient int wordsInUse;
    private transient boolean sizeIsSticky;
    private static final long serialVersionUID = 7997698588986878753L;

    private static int wordIndex(int n2) {
        return n2 >> 6;
    }

    private void checkInvariants() {
        if (!$assertionsDisabled && this.wordsInUse != 0 && this.words[this.wordsInUse - 1] == 0L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        if (!($assertionsDisabled || this.wordsInUse >= 0 && this.wordsInUse <= this.words.length)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        if (!$assertionsDisabled && this.wordsInUse != this.words.length && this.words[this.wordsInUse] != 0L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
    }

    private void recalculateWordsInUse() {
        int n2;
        for (n2 = this.wordsInUse - 1; n2 >= 0 && this.words[n2] == 0L; --n2) {
        }
        this.wordsInUse = n2 + 1;
    }

    public BitSet() {
        this.wordsInUse = 0;
        this.sizeIsSticky = false;
        this.initWords(64);
        this.sizeIsSticky = false;
    }

    public BitSet(int n2) {
        this.wordsInUse = 0;
        this.sizeIsSticky = false;
        if (n2 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NegativeArraySizeException("nbits < 0: " + n2));
        }
        this.initWords(n2);
        this.sizeIsSticky = true;
    }

    private void initWords(int n2) {
        this.words = new long[BitSet.wordIndex(n2 - 1) + 1];
    }

    private BitSet(long[] lArray) {
        this.wordsInUse = 0;
        this.sizeIsSticky = false;
        this.words = lArray;
        this.wordsInUse = lArray.length;
        this.checkInvariants();
    }

    public static BitSet valueOf(long[] lArray) {
        int n2;
        for (n2 = lArray.length; n2 > 0 && lArray[n2 - 1] == 0L; --n2) {
        }
        return new BitSet(Arrays.copyOf(lArray, n2));
    }

    public static BitSet valueOf(LongBuffer longBuffer) {
        int n2;
        longBuffer = longBuffer.slice();
        for (n2 = longBuffer.remaining(); n2 > 0 && longBuffer.get(n2 - 1) == 0L; --n2) {
        }
        long[] lArray = new long[n2];
        longBuffer.get(lArray);
        return new BitSet(lArray);
    }

    public static BitSet valueOf(byte[] byArray) {
        return BitSet.valueOf(ByteBuffer.wrap(byArray));
    }

    public static BitSet valueOf(ByteBuffer byteBuffer) {
        int n2;
        byteBuffer = byteBuffer.slice().order(ByteOrder.LITTLE_ENDIAN);
        for (n2 = byteBuffer.remaining(); n2 > 0 && byteBuffer.get(n2 - 1) == 0; --n2) {
        }
        long[] lArray = new long[(n2 + 7) / 8];
        byteBuffer.limit(n2);
        int n3 = 0;
        while (byteBuffer.remaining() >= 8) {
            lArray[n3++] = byteBuffer.getLong();
        }
        int n4 = byteBuffer.remaining();
        for (int i = 0; i < n4; ++i) {
            int n5 = n3;
            lArray[n5] = lArray[n5] | ((long)byteBuffer.get() & 0xFFL) << 8 * i;
        }
        return new BitSet(lArray);
    }

    public byte[] toByteArray() {
        int n2 = this.wordsInUse;
        if (n2 == 0) {
            return new byte[0];
        }
        int n3 = 8 * (n2 - 1);
        for (long i = this.words[n2 - 1]; i != 0L; i >>>= 8) {
            ++n3;
        }
        byte[] byArray = new byte[n3];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < n2 - 1; ++i) {
            byteBuffer.putLong(this.words[i]);
        }
        for (long i = this.words[n2 - 1]; i != 0L; i >>>= 8) {
            byteBuffer.put((byte)(i & 0xFFL));
        }
        return byArray;
    }

    public long[] toLongArray() {
        return Arrays.copyOf(this.words, this.wordsInUse);
    }

    private void ensureCapacity(int n2) {
        if (this.words.length < n2) {
            int n3 = Math.max(2 * this.words.length, n2);
            this.words = Arrays.copyOf(this.words, n3);
            this.sizeIsSticky = false;
        }
    }

    private void expandTo(int n2) {
        int n3 = n2 + 1;
        if (this.wordsInUse < n3) {
            this.ensureCapacity(n3);
            this.wordsInUse = n3;
        }
    }

    private static void checkRange(int n2, int n3) {
        if (n2 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException("fromIndex < 0: " + n2));
        }
        if (n3 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException("toIndex < 0: " + n3));
        }
        if (n2 > n3) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException("fromIndex: " + n2 + " > toIndex: " + n3));
        }
    }

    public void flip(int n2) {
        if (n2 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException("bitIndex < 0: " + n2));
        }
        int n3 = BitSet.wordIndex(n2);
        this.expandTo(n3);
        long[] lArray = this.words;
        int n4 = n3;
        lArray[n4] = lArray[n4] ^ 1L << n2;
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public void flip(int n2, int n3) {
        BitSet.checkRange(n2, n3);
        if (n2 == n3) {
            return;
        }
        int n4 = BitSet.wordIndex(n2);
        int n5 = BitSet.wordIndex(n3 - 1);
        this.expandTo(n5);
        long l = -1L << n2;
        long l2 = -1L >>> -n3;
        if (n4 == n5) {
            long[] lArray = this.words;
            int n6 = n4;
            lArray[n6] = lArray[n6] ^ l & l2;
        } else {
            long[] lArray = this.words;
            int n7 = n4;
            lArray[n7] = lArray[n7] ^ l;
            int n8 = n4 + 1;
            while (n8 < n5) {
                long[] lArray2 = this.words;
                int n9 = n8++;
                lArray2[n9] = lArray2[n9] ^ 0xFFFFFFFFFFFFFFFFL;
            }
            long[] lArray3 = this.words;
            int n10 = n5;
            lArray3[n10] = lArray3[n10] ^ l2;
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public void set(int n2) {
        if (n2 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException("bitIndex < 0: " + n2));
        }
        int n3 = BitSet.wordIndex(n2);
        this.expandTo(n3);
        long[] lArray = this.words;
        int n4 = n3;
        lArray[n4] = lArray[n4] | 1L << n2;
        this.checkInvariants();
    }

    public void set(int n2, boolean bl) {
        if (bl) {
            this.set(n2);
        } else {
            this.clear(n2);
        }
    }

    public void set(int n2, int n3) {
        BitSet.checkRange(n2, n3);
        if (n2 == n3) {
            return;
        }
        int n4 = BitSet.wordIndex(n2);
        int n5 = BitSet.wordIndex(n3 - 1);
        this.expandTo(n5);
        long l = -1L << n2;
        long l2 = -1L >>> -n3;
        if (n4 == n5) {
            long[] lArray = this.words;
            int n6 = n4;
            lArray[n6] = lArray[n6] | l & l2;
        } else {
            long[] lArray = this.words;
            int n7 = n4;
            lArray[n7] = lArray[n7] | l;
            for (int i = n4 + 1; i < n5; ++i) {
                ((BitSet)this).words[i] = -1L;
            }
            long[] lArray2 = this.words;
            int n8 = n5;
            lArray2[n8] = lArray2[n8] | l2;
        }
        this.checkInvariants();
    }

    public void set(int n2, int n3, boolean bl) {
        if (bl) {
            this.set(n2, n3);
        } else {
            this.clear(n2, n3);
        }
    }

    public void clear(int n2) {
        if (n2 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException("bitIndex < 0: " + n2));
        }
        int n3 = BitSet.wordIndex(n2);
        if (n3 >= this.wordsInUse) {
            return;
        }
        long[] lArray = this.words;
        int n4 = n3;
        lArray[n4] = lArray[n4] & (1L << n2 ^ 0xFFFFFFFFFFFFFFFFL);
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public void clear(int n2, int n3) {
        BitSet.checkRange(n2, n3);
        if (n2 == n3) {
            return;
        }
        int n4 = BitSet.wordIndex(n2);
        if (n4 >= this.wordsInUse) {
            return;
        }
        int n5 = BitSet.wordIndex(n3 - 1);
        if (n5 >= this.wordsInUse) {
            n3 = this.length();
            n5 = this.wordsInUse - 1;
        }
        long l = -1L << n2;
        long l2 = -1L >>> -n3;
        if (n4 == n5) {
            long[] lArray = this.words;
            int n6 = n4;
            lArray[n6] = lArray[n6] & (l & l2 ^ 0xFFFFFFFFFFFFFFFFL);
        } else {
            long[] lArray = this.words;
            int n7 = n4;
            lArray[n7] = lArray[n7] & (l ^ 0xFFFFFFFFFFFFFFFFL);
            for (int i = n4 + 1; i < n5; ++i) {
                ((BitSet)this).words[i] = 0L;
            }
            long[] lArray2 = this.words;
            int n8 = n5;
            lArray2[n8] = lArray2[n8] & (l2 ^ 0xFFFFFFFFFFFFFFFFL);
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public void clear() {
        while (this.wordsInUse > 0) {
            long[] lArray = this.words;
            BitSet bitSet = this;
            int n2 = bitSet.wordsInUse - 1;
            bitSet.wordsInUse = n2;
            lArray[n2] = 0L;
        }
    }

    public boolean get(int n2) {
        if (n2 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException("bitIndex < 0: " + n2));
        }
        this.checkInvariants();
        int n3 = BitSet.wordIndex(n2);
        return n3 < this.wordsInUse && (this.words[n3] & 1L << n2) != 0L;
    }

    public BitSet get(int n2, int n3) {
        BitSet.checkRange(n2, n3);
        this.checkInvariants();
        int n4 = this.length();
        if (n4 <= n2 || n2 == n3) {
            return new BitSet(0);
        }
        if (n3 > n4) {
            n3 = n4;
        }
        BitSet bitSet = new BitSet(n3 - n2);
        int n5 = BitSet.wordIndex(n3 - n2 - 1) + 1;
        int n6 = BitSet.wordIndex(n2);
        boolean bl = (n2 & 0x3F) == 0;
        int n7 = 0;
        while (n7 < n5 - 1) {
            ((BitSet)bitSet).words[n7] = bl ? this.words[n6] : this.words[n6] >>> n2 | this.words[n6 + 1] << -n2;
            ++n7;
            ++n6;
        }
        long l = -1L >>> -n3;
        ((BitSet)bitSet).words[n5 - 1] = (n3 - 1 & 0x3F) < (n2 & 0x3F) ? this.words[n6] >>> n2 | (this.words[n6 + 1] & l) << -n2 : (this.words[n6] & l) >>> n2;
        bitSet.wordsInUse = n5;
        bitSet.recalculateWordsInUse();
        bitSet.checkInvariants();
        return bitSet;
    }

    public int nextSetBit(int n2) {
        if (n2 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException("fromIndex < 0: " + n2));
        }
        this.checkInvariants();
        int n3 = BitSet.wordIndex(n2);
        if (n3 >= this.wordsInUse) {
            return -1;
        }
        long l = this.words[n3] & -1L << n2;
        while (l == 0L) {
            if (++n3 == this.wordsInUse) {
                return -1;
            }
            l = this.words[n3];
        }
        return n3 * 64 + Long.numberOfTrailingZeros(l);
    }

    public int nextClearBit(int n2) {
        if (n2 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException("fromIndex < 0: " + n2));
        }
        this.checkInvariants();
        int n3 = BitSet.wordIndex(n2);
        if (n3 >= this.wordsInUse) {
            return n2;
        }
        long l = (this.words[n3] ^ 0xFFFFFFFFFFFFFFFFL) & -1L << n2;
        while (l == 0L) {
            if (++n3 == this.wordsInUse) {
                return this.wordsInUse * 64;
            }
            l = this.words[n3] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return n3 * 64 + Long.numberOfTrailingZeros(l);
    }

    public int previousSetBit(int n2) {
        if (n2 < 0) {
            if (n2 == -1) {
                return -1;
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException("fromIndex < -1: " + n2));
        }
        this.checkInvariants();
        int n3 = BitSet.wordIndex(n2);
        if (n3 >= this.wordsInUse) {
            return this.length() - 1;
        }
        long l = this.words[n3] & -1L >>> -(n2 + 1);
        while (l == 0L) {
            if (n3-- == 0) {
                return -1;
            }
            l = this.words[n3];
        }
        return (n3 + 1) * 64 - 1 - Long.numberOfLeadingZeros(l);
    }

    public int previousClearBit(int n2) {
        if (n2 < 0) {
            if (n2 == -1) {
                return -1;
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException("fromIndex < -1: " + n2));
        }
        this.checkInvariants();
        int n3 = BitSet.wordIndex(n2);
        if (n3 >= this.wordsInUse) {
            return n2;
        }
        long l = (this.words[n3] ^ 0xFFFFFFFFFFFFFFFFL) & -1L >>> -(n2 + 1);
        while (l == 0L) {
            if (n3-- == 0) {
                return -1;
            }
            l = this.words[n3] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return (n3 + 1) * 64 - 1 - Long.numberOfLeadingZeros(l);
    }

    public int length() {
        if (this.wordsInUse == 0) {
            return 0;
        }
        return 64 * (this.wordsInUse - 1) + (64 - Long.numberOfLeadingZeros(this.words[this.wordsInUse - 1]));
    }

    public boolean isEmpty() {
        return this.wordsInUse == 0;
    }

    public boolean intersects(BitSet bitSet) {
        for (int i = Math.min(this.wordsInUse, bitSet.wordsInUse) - 1; i >= 0; --i) {
            if ((this.words[i] & bitSet.words[i]) == 0L) continue;
            return true;
        }
        return false;
    }

    public int cardinality() {
        int n2 = 0;
        for (int i = 0; i < this.wordsInUse; ++i) {
            n2 += Long.bitCount(this.words[i]);
        }
        return n2;
    }

    public void and(BitSet bitSet) {
        if (!f.ifAcmp((Object)this, (Object)bitSet)) {
            return;
        }
        while (this.wordsInUse > bitSet.wordsInUse) {
            long[] lArray = this.words;
            BitSet bitSet2 = this;
            int n2 = bitSet2.wordsInUse - 1;
            bitSet2.wordsInUse = n2;
            lArray[n2] = 0L;
        }
        for (int i = 0; i < this.wordsInUse; ++i) {
            long[] lArray = this.words;
            int n3 = i;
            lArray[n3] = lArray[n3] & bitSet.words[i];
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public void or(BitSet bitSet) {
        if (!f.ifAcmp((Object)this, (Object)bitSet)) {
            return;
        }
        int n2 = Math.min(this.wordsInUse, bitSet.wordsInUse);
        if (this.wordsInUse < bitSet.wordsInUse) {
            this.ensureCapacity(bitSet.wordsInUse);
            this.wordsInUse = bitSet.wordsInUse;
        }
        for (int i = 0; i < n2; ++i) {
            long[] lArray = this.words;
            int n3 = i;
            lArray[n3] = lArray[n3] | bitSet.words[i];
        }
        if (n2 < bitSet.wordsInUse) {
            a.arraycopy((Object)bitSet.words, (int)n2, (Object)this.words, (int)n2, (int)(this.wordsInUse - n2));
        }
        this.checkInvariants();
    }

    public void xor(BitSet bitSet) {
        int n2 = Math.min(this.wordsInUse, bitSet.wordsInUse);
        if (this.wordsInUse < bitSet.wordsInUse) {
            this.ensureCapacity(bitSet.wordsInUse);
            this.wordsInUse = bitSet.wordsInUse;
        }
        for (int i = 0; i < n2; ++i) {
            long[] lArray = this.words;
            int n3 = i;
            lArray[n3] = lArray[n3] ^ bitSet.words[i];
        }
        if (n2 < bitSet.wordsInUse) {
            a.arraycopy((Object)bitSet.words, (int)n2, (Object)this.words, (int)n2, (int)(bitSet.wordsInUse - n2));
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public void andNot(BitSet bitSet) {
        for (int i = Math.min(this.wordsInUse, bitSet.wordsInUse) - 1; i >= 0; --i) {
            long[] lArray = this.words;
            int n2 = i;
            lArray[n2] = lArray[n2] & (bitSet.words[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public int hashCode() {
        long l = 1234L;
        int n2 = this.wordsInUse;
        while (--n2 >= 0) {
            l ^= this.words[n2] * (long)(n2 + 1);
        }
        return (int)(l >> 32 ^ l);
    }

    public int size() {
        return this.words.length * 64;
    }

    public boolean equals(Object object) {
        if (!(g.convertForInstanceOf((Object)object, BitSet.class) instanceof BitSet)) {
            return false;
        }
        if (!f.ifAcmp((Object)this, (Object)object)) {
            return true;
        }
        BitSet bitSet = (BitSet)g.convertForCast((Object)object, BitSet.class);
        this.checkInvariants();
        bitSet.checkInvariants();
        if (this.wordsInUse != bitSet.wordsInUse) {
            return false;
        }
        for (int i = 0; i < this.wordsInUse; ++i) {
            if (this.words[i] == bitSet.words[i]) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        if (!this.sizeIsSticky) {
            this.trimToSize();
        }
        try {
            BitSet bitSet = (BitSet)g.convertForCast((Object)super.clone(), BitSet.class);
            bitSet.words = (long[])this.words.clone();
            bitSet.checkInvariants();
            return bitSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
        }
    }

    private void trimToSize() {
        if (this.wordsInUse != this.words.length) {
            this.words = Arrays.copyOf(this.words, this.wordsInUse);
            this.checkInvariants();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.checkInvariants();
        if (!this.sizeIsSticky) {
            this.trimToSize();
        }
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("bits", this.words);
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.words = (long[])getField.get("bits", null);
        this.wordsInUse = this.words.length;
        this.recalculateWordsInUse();
        this.sizeIsSticky = this.words.length > 0 && this.words[this.words.length - 1] == 0L;
        this.checkInvariants();
    }

    public String toString() {
        this.checkInvariants();
        int n2 = this.wordsInUse > 128 ? this.cardinality() : this.wordsInUse * 64;
        StringBuilder stringBuilder = new StringBuilder(6 * n2 + 2);
        stringBuilder.append('{');
        int n3 = this.nextSetBit(0);
        if (n3 != -1) {
            stringBuilder.append(n3);
            n3 = this.nextSetBit(n3 + 1);
            while (n3 >= 0) {
                int n4 = this.nextClearBit(n3);
                do {
                    stringBuilder.append(", ").append(n3);
                } while (++n3 < n4);
                n3 = this.nextSetBit(n3 + 1);
            }
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    static {
        Object[] objectArray = new ObjectStreamField[1];
        a.arrayStore((Object[])objectArray, (int)0, (Object)new ObjectStreamField("bits", long[].class));
        serialPersistentFields = objectArray;
    }

    protected /* synthetic */ BitSet(h h2) {
        super(h2);
    }
}

