/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.facade.h;
import com.zeroturnaround.jrebelbase.facade.x;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import java.util.Random;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.function.Consumer;

public class Collections
extends com.zeroturnaround.jrebelbase.h {
    private static final int BINARYSEARCH_THRESHOLD = 5000;
    private static final int REVERSE_THRESHOLD = 18;
    private static final int SHUFFLE_THRESHOLD = 5;
    private static final int FILL_THRESHOLD = 25;
    private static final int ROTATE_THRESHOLD = 100;
    private static final int COPY_THRESHOLD = 10;
    private static final int REPLACEALL_THRESHOLD = 11;
    private static final int INDEXOFSUBLIST_THRESHOLD = 35;
    private static Random r;
    public static final Set EMPTY_SET;
    public static final List EMPTY_LIST;
    public static final Map EMPTY_MAP;

    private Collections() {
    }

    public static <T extends Comparable<? super T>> void sort(List<T> list) {
        Object[] objectArray = list.toArray();
        Arrays.sort(objectArray);
        ListIterator<T> listIterator = list.listIterator();
        for (int i = 0; i < a.arrayLength((Object[])objectArray); ++i) {
            listIterator.next();
            listIterator.set((Comparable)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), Comparable.class));
        }
    }

    public static <T> void sort(List<T> list, Comparator<? super T> comparator) {
        Object[] objectArray = list.toArray();
        Arrays.sort(objectArray, comparator);
        ListIterator<T> listIterator = list.listIterator();
        for (int i = 0; i < a.arrayLength((Object[])objectArray); ++i) {
            listIterator.next();
            listIterator.set(a.arrayLoad((Object[])objectArray, (int)i));
        }
    }

    public static <T> int binarySearch(List<? extends Comparable<? super T>> list, T t) {
        if (g.convertForInstanceOf(list, RandomAccess.class) instanceof RandomAccess || list.size() < 5000) {
            return Collections.indexedBinarySearch(list, t);
        }
        return Collections.iteratorBinarySearch(list, t);
    }

    private static <T> int indexedBinarySearch(List<? extends Comparable<? super T>> list, T t) {
        int n = 0;
        int n2 = list.size() - 1;
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            Comparable comparable = (Comparable)g.convertForCast(list.get(n3), Comparable.class);
            int n4 = comparable.compareTo(t);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    private static <T> int iteratorBinarySearch(List<? extends Comparable<? super T>> list, T t) {
        int n = 0;
        int n2 = list.size() - 1;
        ListIterator<? extends Comparable<? super T>> listIterator = list.listIterator();
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            Comparable comparable = (Comparable)g.convertForCast(Collections.get(listIterator, n3), Comparable.class);
            int n4 = comparable.compareTo(t);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    private static <T> T get(ListIterator<? extends T> listIterator, int n) {
        T t = null;
        int n2 = listIterator.nextIndex();
        if (n2 <= n) {
            do {
                t = listIterator.next();
            } while (n2++ < n);
        } else {
            do {
                t = listIterator.previous();
            } while (--n2 > n);
        }
        return t;
    }

    public static <T> int binarySearch(List<? extends T> list, T t, Comparator<? super T> comparator) {
        if (comparator == null) {
            return Collections.binarySearch(list, t);
        }
        if (g.convertForInstanceOf(list, RandomAccess.class) instanceof RandomAccess || list.size() < 5000) {
            return Collections.indexedBinarySearch(list, t, comparator);
        }
        return Collections.iteratorBinarySearch(list, t, comparator);
    }

    private static <T> int indexedBinarySearch(List<? extends T> list, T t, Comparator<? super T> comparator) {
        int n = 0;
        int n2 = list.size() - 1;
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            T t2 = list.get(n3);
            int n4 = comparator.compare(t2, t);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    private static <T> int iteratorBinarySearch(List<? extends T> list, T t, Comparator<? super T> comparator) {
        int n = 0;
        int n2 = list.size() - 1;
        ListIterator<? extends T> listIterator = list.listIterator();
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            T t2 = Collections.get(listIterator, n3);
            int n4 = comparator.compare(t2, t);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    public static void reverse(List<?> list) {
        int n = list.size();
        if (n < 18 || g.convertForInstanceOf(list, RandomAccess.class) instanceof RandomAccess) {
            int n2 = 0;
            int n3 = n >> 1;
            int n4 = n - 1;
            while (n2 < n3) {
                Collections.swap(list, n2, n4);
                ++n2;
                --n4;
            }
        } else {
            ListIterator<?> listIterator = list.listIterator();
            ListIterator<?> listIterator2 = list.listIterator(n);
            int n5 = list.size() >> 1;
            for (int i = 0; i < n5; ++i) {
                Object obj = listIterator.next();
                listIterator.set(listIterator2.previous());
                listIterator2.set(obj);
            }
        }
    }

    public static void shuffle(List<?> list) {
        Random random = r;
        if (random == null) {
            r = random = new Random();
        }
        Collections.shuffle(list, random);
    }

    public static void shuffle(List<?> list, Random random) {
        int n = list.size();
        if (n < 5 || g.convertForInstanceOf(list, RandomAccess.class) instanceof RandomAccess) {
            for (int i = n; i > 1; --i) {
                Collections.swap(list, i - 1, random.nextInt(i));
            }
        } else {
            Object[] objectArray = list.toArray();
            for (int i = n; i > 1; --i) {
                Collections.swap(objectArray, i - 1, random.nextInt(i));
            }
            ListIterator<?> listIterator = list.listIterator();
            for (int i = 0; i < a.arrayLength((Object[])objectArray); ++i) {
                listIterator.next();
                listIterator.set(a.arrayLoad((Object[])objectArray, (int)i));
            }
        }
    }

    public static void swap(List<?> list, int n, int n2) {
        List<?> list2 = list;
        list2.set(n, list2.set(n2, list2.get(n)));
    }

    private static void swap(Object[] objectArray, int n, int n2) {
        Object object = a.arrayLoad((Object[])objectArray, (int)n);
        a.arrayStore((Object[])objectArray, (int)n, (Object)a.arrayLoad((Object[])objectArray, (int)n2));
        a.arrayStore((Object[])objectArray, (int)n2, (Object)object);
    }

    public static <T> void fill(List<? super T> list, T t) {
        int n = list.size();
        if (n < 25 || g.convertForInstanceOf(list, RandomAccess.class) instanceof RandomAccess) {
            for (int i = 0; i < n; ++i) {
                list.set(i, t);
            }
        } else {
            ListIterator<T> listIterator = list.listIterator();
            for (int i = 0; i < n; ++i) {
                listIterator.next();
                listIterator.set(t);
            }
        }
    }

    public static <T> void copy(List<? super T> list, List<? extends T> list2) {
        int n = list2.size();
        if (n > list.size()) {
            throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new IndexOutOfBoundsException("Source does not fit in dest"));
        }
        if (n < 10 || g.convertForInstanceOf(list2, RandomAccess.class) instanceof RandomAccess && g.convertForInstanceOf(list, RandomAccess.class) instanceof RandomAccess) {
            for (int i = 0; i < n; ++i) {
                list.set(i, list2.get(i));
            }
        } else {
            ListIterator<T> listIterator = list.listIterator();
            ListIterator<T> listIterator2 = list2.listIterator();
            for (int i = 0; i < n; ++i) {
                listIterator.next();
                listIterator.set(listIterator2.next());
            }
        }
    }

    public static <T> T min(Collection<? extends T> collection) {
        Iterator<T> iterator = collection.iterator();
        T t = iterator.next();
        while (iterator.hasNext()) {
            T t2 = iterator.next();
            if (((Comparable)g.convertForCast(t2, Comparable.class)).compareTo(t) >= 0) continue;
            t = t2;
        }
        return t;
    }

    public static <T> T min(Collection<? extends T> collection, Comparator<? super T> comparator) {
        if (comparator == null) {
            return Collections.min(collection);
        }
        Iterator<T> iterator = collection.iterator();
        T t = iterator.next();
        while (iterator.hasNext()) {
            T t2 = iterator.next();
            if (comparator.compare(t2, t) >= 0) continue;
            t = t2;
        }
        return t;
    }

    public static <T> T max(Collection<? extends T> collection) {
        Iterator<T> iterator = collection.iterator();
        T t = iterator.next();
        while (iterator.hasNext()) {
            T t2 = iterator.next();
            if (((Comparable)g.convertForCast(t2, Comparable.class)).compareTo(t) <= 0) continue;
            t = t2;
        }
        return t;
    }

    public static <T> T max(Collection<? extends T> collection, Comparator<? super T> comparator) {
        if (comparator == null) {
            return Collections.max(collection);
        }
        Iterator<T> iterator = collection.iterator();
        T t = iterator.next();
        while (iterator.hasNext()) {
            T t2 = iterator.next();
            if (comparator.compare(t2, t) <= 0) continue;
            t = t2;
        }
        return t;
    }

    public static void rotate(List<?> list, int n) {
        if (g.convertForInstanceOf(list, RandomAccess.class) instanceof RandomAccess || list.size() < 100) {
            Collections.rotate1(list, n);
        } else {
            Collections.rotate2(list, n);
        }
    }

    private static <T> void rotate1(List<T> list, int n) {
        int n2 = list.size();
        if (n2 == 0) {
            return;
        }
        if ((n %= n2) < 0) {
            n += n2;
        }
        if (n == 0) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 != n2) {
            T t = list.get(n3);
            int n5 = n3;
            do {
                if ((n5 += n) >= n2) {
                    n5 -= n2;
                }
                t = list.set(n5, t);
                ++n4;
            } while (n5 != n3);
            ++n3;
        }
    }

    private static void rotate2(List<?> list, int n) {
        int n2 = list.size();
        if (n2 == 0) {
            return;
        }
        int n3 = -n % n2;
        if (n3 < 0) {
            n3 += n2;
        }
        if (n3 == 0) {
            return;
        }
        Collections.reverse(list.subList(0, n3));
        Collections.reverse(list.subList(n3, n2));
        Collections.reverse(list);
    }

    public static <T> boolean replaceAll(List<T> list, T t, T t2) {
        boolean bl = false;
        int n = list.size();
        if (n < 11 || g.convertForInstanceOf(list, RandomAccess.class) instanceof RandomAccess) {
            if (t == null) {
                for (int i = 0; i < n; ++i) {
                    if (list.get(i) != null) continue;
                    list.set(i, t2);
                    bl = true;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    if (!t.equals(list.get(i))) continue;
                    list.set(i, t2);
                    bl = true;
                }
            }
        } else {
            ListIterator<T> listIterator = list.listIterator();
            if (t == null) {
                for (int i = 0; i < n; ++i) {
                    if (listIterator.next() != null) continue;
                    listIterator.set(t2);
                    bl = true;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    if (!t.equals(listIterator.next())) continue;
                    listIterator.set(t2);
                    bl = true;
                }
            }
        }
        return bl;
    }

    public static int indexOfSubList(List<?> list, List<?> list2) {
        int n = list.size();
        int n2 = list2.size();
        int n3 = n - n2;
        if (n < 35 || g.convertForInstanceOf(list, RandomAccess.class) instanceof RandomAccess && g.convertForInstanceOf(list2, RandomAccess.class) instanceof RandomAccess) {
            block0: for (int i = 0; i <= n3; ++i) {
                int n4 = 0;
                int n5 = i;
                while (n4 < n2) {
                    if (!Collections.eq(list2.get(n4), list.get(n5))) continue block0;
                    ++n4;
                    ++n5;
                }
                return i;
            }
        } else {
            ListIterator<?> listIterator = list.listIterator();
            block2: for (int i = 0; i <= n3; ++i) {
                ListIterator<?> listIterator2 = list2.listIterator();
                for (int k = 0; k < n2; ++k) {
                    if (Collections.eq(listIterator2.next(), listIterator.next())) continue;
                    for (int i2 = 0; i2 < k; ++i2) {
                        listIterator.previous();
                    }
                    continue block2;
                }
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOfSubList(List<?> list, List<?> list2) {
        int n = list.size();
        int n2 = list2.size();
        int n3 = n - n2;
        if (n < 35 || g.convertForInstanceOf(list, RandomAccess.class) instanceof RandomAccess) {
            block0: for (int i = n3; i >= 0; --i) {
                int n4 = 0;
                int n5 = i;
                while (n4 < n2) {
                    if (!Collections.eq(list2.get(n4), list.get(n5))) continue block0;
                    ++n4;
                    ++n5;
                }
                return i;
            }
        } else {
            if (n3 < 0) {
                return -1;
            }
            ListIterator<?> listIterator = list.listIterator(n3);
            block2: for (int i = n3; i >= 0; --i) {
                ListIterator<?> listIterator2 = list2.listIterator();
                for (int k = 0; k < n2; ++k) {
                    if (Collections.eq(listIterator2.next(), listIterator.next())) continue;
                    if (i == 0) continue block2;
                    for (int i2 = 0; i2 <= k + 1; ++i2) {
                        listIterator.previous();
                    }
                    continue block2;
                }
                return i;
            }
        }
        return -1;
    }

    public static <T> Collection<T> unmodifiableCollection(Collection<? extends T> collection) {
        return new UnmodifiableCollection(collection);
    }

    public static <T> Set<T> unmodifiableSet(Set<? extends T> set) {
        return new UnmodifiableSet<T>(set);
    }

    public static <T> SortedSet<T> unmodifiableSortedSet(SortedSet<T> sortedSet) {
        return new UnmodifiableSortedSet<T>(sortedSet);
    }

    public static <T> List<T> unmodifiableList(List<? extends T> list) {
        return g.convertForInstanceOf(list, RandomAccess.class) instanceof RandomAccess ? new UnmodifiableRandomAccessList<T>(list) : new UnmodifiableList<T>(list);
    }

    public static <K, V> Map<K, V> unmodifiableMap(Map<? extends K, ? extends V> map) {
        return new UnmodifiableMap(map);
    }

    public static <K, V> SortedMap<K, V> unmodifiableSortedMap(SortedMap<K, ? extends V> sortedMap) {
        return new UnmodifiableSortedMap<K, V>(sortedMap);
    }

    public static <T> Collection<T> synchronizedCollection(Collection<T> collection) {
        return new SynchronizedCollection(collection);
    }

    static <T> Collection<T> synchronizedCollection(Collection<T> collection, Object object) {
        return new SynchronizedCollection(collection, object);
    }

    public static <T> Set<T> synchronizedSet(Set<T> set) {
        return new SynchronizedSet<T>(set);
    }

    static <T> Set<T> synchronizedSet(Set<T> set, Object object) {
        return new SynchronizedSet<T>(set, object);
    }

    public static <T> SortedSet<T> synchronizedSortedSet(SortedSet<T> sortedSet) {
        return new SynchronizedSortedSet<T>(sortedSet);
    }

    public static <T> List<T> synchronizedList(List<T> list) {
        return g.convertForInstanceOf(list, RandomAccess.class) instanceof RandomAccess ? new SynchronizedRandomAccessList<T>(list) : new SynchronizedList<T>(list);
    }

    static <T> List<T> synchronizedList(List<T> list, Object object) {
        return g.convertForInstanceOf(list, RandomAccess.class) instanceof RandomAccess ? new SynchronizedRandomAccessList<T>(list, object) : new SynchronizedList<T>(list, object);
    }

    public static <K, V> Map<K, V> synchronizedMap(Map<K, V> map) {
        return new SynchronizedMap(map);
    }

    public static <K, V> SortedMap<K, V> synchronizedSortedMap(SortedMap<K, V> sortedMap) {
        return new SynchronizedSortedMap<K, V>(sortedMap);
    }

    public static <E> Collection<E> checkedCollection(Collection<E> collection, Class<E> clazz) {
        return new CheckedCollection(collection, clazz);
    }

    static <T> T[] zeroLengthArray(Class<T> clazz) {
        return (Object[])g.convertForCast((Object)((Object[])g.convertForCast((Object)Array.newInstance(clazz, 0), Object[].class)), Object[].class);
    }

    public static <E> Set<E> checkedSet(Set<E> set, Class<E> clazz) {
        return new CheckedSet<E>(set, clazz);
    }

    public static <E> SortedSet<E> checkedSortedSet(SortedSet<E> sortedSet, Class<E> clazz) {
        return new CheckedSortedSet<E>(sortedSet, clazz);
    }

    public static <E> List<E> checkedList(List<E> list, Class<E> clazz) {
        return g.convertForInstanceOf(list, RandomAccess.class) instanceof RandomAccess ? new CheckedRandomAccessList<E>(list, clazz) : new CheckedList<E>(list, clazz);
    }

    public static <K, V> Map<K, V> checkedMap(Map<K, V> map, Class<K> clazz, Class<V> clazz2) {
        return new CheckedMap(map, clazz, clazz2);
    }

    public static <K, V> SortedMap<K, V> checkedSortedMap(SortedMap<K, V> sortedMap, Class<K> clazz, Class<V> clazz2) {
        return new CheckedSortedMap<K, V>(sortedMap, clazz, clazz2);
    }

    public static <T> Iterator<T> emptyIterator() {
        return EmptyIterator.EMPTY_ITERATOR;
    }

    public static <T> ListIterator<T> emptyListIterator() {
        return EmptyListIterator.EMPTY_ITERATOR;
    }

    public static <T> Enumeration<T> emptyEnumeration() {
        return EmptyEnumeration.EMPTY_ENUMERATION;
    }

    public static final <T> Set<T> emptySet() {
        return EMPTY_SET;
    }

    public static final <T> List<T> emptyList() {
        return EMPTY_LIST;
    }

    public static final <K, V> Map<K, V> emptyMap() {
        return EMPTY_MAP;
    }

    public static <T> Set<T> singleton(T t) {
        return new SingletonSet<T>(t);
    }

    static <E> Iterator<E> singletonIterator(final E e) {
        return new Iterator<E>(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public E next() {
                if (this.hasNext) {
                    this.hasNext = false;
                    return e;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void forEachRemaining(Consumer<? super E> action) {
                Objects.requireNonNull(action);
                if (this.hasNext) {
                    this.hasNext = false;
                    action.accept(e);
                }
            }
        };
    }

    public static <T> List<T> singletonList(T t) {
        return new SingletonList<T>(t);
    }

    public static <K, V> Map<K, V> singletonMap(K k, V v) {
        return new SingletonMap<K, V>(k, v);
    }

    public static <T> List<T> nCopies(int n, T t) {
        if (n < 0) {
            throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new IllegalArgumentException("List length = " + n));
        }
        return new CopiesList<T>(n, t);
    }

    public static <T> Comparator<T> reverseOrder() {
        return ReverseComparator.REVERSE_ORDER;
    }

    public static <T> Comparator<T> reverseOrder(Comparator<T> comparator) {
        if (comparator == null) {
            return Collections.reverseOrder();
        }
        if (g.convertForInstanceOf(comparator, ReverseComparator2.class) instanceof ReverseComparator2) {
            return ((ReverseComparator2)((ReverseComparator2)g.convertForCast(comparator, ReverseComparator2.class))).cmp;
        }
        return new ReverseComparator2(comparator);
    }

    public static <T> Enumeration<T> enumeration(final Collection<T> collection) {
        return new Spliterator<T>(collection){
            long est = 1L;

            @Override
            public Spliterator<T> trySplit() {
                return null;
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> consumer) {
                Objects.requireNonNull(consumer);
                if (this.est > 0L) {
                    --this.est;
                    consumer.accept(collection);
                    return true;
                }
                return false;
            }

            @Override
            public void forEachRemaining(Consumer<? super T> consumer) {
                this.tryAdvance(consumer);
            }

            @Override
            public long estimateSize() {
                return this.est;
            }

            @Override
            public int characteristics() {
                int value = collection != null ? 256 : 0;
                return value | 0x40 | 0x4000 | 0x400 | 1 | 0x10;
            }
        };
    }

    public static <T> ArrayList<T> list(Enumeration<T> enumeration) {
        ArrayList<T> arrayList = new ArrayList<T>();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList;
    }

    static boolean eq(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public static int frequency(Collection<?> collection, Object object) {
        int n = 0;
        if (object == null) {
            for (Object obj : collection) {
                if (obj != null) continue;
                ++n;
            }
        } else {
            for (Object obj : collection) {
                if (!object.equals(obj)) continue;
                ++n;
            }
        }
        return n;
    }

    public static boolean disjoint(Collection<?> collection, Collection<?> collection2) {
        Collection<?> collection3 = collection2;
        Collection<?> collection4 = collection;
        if (g.convertForInstanceOf(collection, Set.class) instanceof Set) {
            collection4 = collection2;
            collection3 = collection;
        } else if (!(g.convertForInstanceOf(collection2, Set.class) instanceof Set)) {
            int n = collection.size();
            int n2 = collection2.size();
            if (n == 0 || n2 == 0) {
                return true;
            }
            if (n > n2) {
                collection4 = collection2;
                collection3 = collection;
            }
        }
        for (Object obj : collection4) {
            if (!collection3.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @SafeVarargs
    public static <T> boolean addAll(Collection<? super T> collection, T ... TArray) {
        boolean bl = false;
        Object[] objectArray = TArray;
        int n = a.arrayLength((Object[])objectArray);
        for (int i = 0; i < n; ++i) {
            Object object = a.arrayLoad((Object[])objectArray, (int)i);
            bl |= collection.add(object);
        }
        return bl;
    }

    public static <E> Set<E> newSetFromMap(Map<E, Boolean> map) {
        return new SetFromMap<E>(map);
    }

    public static <T> Queue<T> asLifoQueue(Deque<T> deque) {
        return new AsLIFOQueue<T>(deque);
    }

    static {
        EMPTY_SET = new EmptySet();
        EMPTY_LIST = new EmptyList();
        EMPTY_MAP = new EmptyMap();
    }

    protected /* synthetic */ Collections(com.zeroturnaround.jrebelbase.h h2) {
        super(h2);
    }

    static class AsLIFOQueue<E>
    extends AbstractQueue<E>
    implements Queue<E>,
    Serializable {
        private static final long serialVersionUID = 1802017725587941708L;
        private final Deque<E> q;

        AsLIFOQueue(Deque<E> deque) {
            this.q = deque;
        }

        @Override
        public boolean add(E e) {
            this.q.addFirst(e);
            return true;
        }

        @Override
        public boolean offer(E e) {
            return this.q.offerFirst(e);
        }

        @Override
        public E poll() {
            return this.q.pollFirst();
        }

        @Override
        public E remove() {
            return this.q.removeFirst();
        }

        @Override
        public E peek() {
            return this.q.peekFirst();
        }

        @Override
        public E element() {
            return this.q.getFirst();
        }

        @Override
        public void clear() {
            this.q.clear();
        }

        @Override
        public int size() {
            return this.q.size();
        }

        @Override
        public boolean isEmpty() {
            return this.q.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.q.contains(object);
        }

        @Override
        public boolean remove(Object object) {
            return this.q.remove(object);
        }

        @Override
        public Iterator<E> iterator() {
            return this.q.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.q.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.q.toArray(TArray);
        }

        @Override
        public String toString() {
            return this.q.toString();
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.q.containsAll(collection);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return this.q.removeAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return this.q.retainAll(collection);
        }

        private static /* synthetic */ void _jr$ip$q(AsLIFOQueue asLIFOQueue, Deque deque) {
            asLIFOQueue.q = deque;
        }

        protected /* synthetic */ AsLIFOQueue(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    static class CheckedCollection
    extends com.zeroturnaround.jrebelbase.h
    implements Collection,
    Serializable {
        private static final long serialVersionUID = 1578914078182001775L;
        final Collection<E> c;
        final Class<E> type;
        private E[] zeroLengthElementArray;

        void typeCheck(Object object) {
            if (object != null && !x.isInstance((Class)((CheckedCollection)this).type, (Object)object)) {
                throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new ClassCastException(this.badElementMsg(object)));
            }
        }

        private String badElementMsg(Object object) {
            return "Attempt to insert " + object.getClass() + " element into collection with element type " + ((CheckedCollection)this).type;
        }

        CheckedCollection(Collection<E> collection, Class<E> clazz) {
            this.zeroLengthElementArray = null;
            if (collection == null || clazz == null) {
                throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new NullPointerException());
            }
            this.c = collection;
            this.type = clazz;
        }

        @Override
        public int size() {
            return ((CheckedCollection)this).c.size();
        }

        @Override
        public boolean isEmpty() {
            return ((CheckedCollection)this).c.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return ((CheckedCollection)this).c.contains(object);
        }

        @Override
        public Object[] toArray() {
            return ((CheckedCollection)this).c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return ((CheckedCollection)this).c.toArray(TArray);
        }

        public String toString() {
            return ((CheckedCollection)this).c.toString();
        }

        @Override
        public boolean remove(Object object) {
            return ((CheckedCollection)this).c.remove(object);
        }

        @Override
        public void clear() {
            ((CheckedCollection)this).c.clear();
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return ((CheckedCollection)this).c.containsAll(collection);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return ((CheckedCollection)this).c.removeAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return ((CheckedCollection)this).c.retainAll(collection);
        }

        @Override
        public Iterator<E> iterator() {
            final Iterator iterator = ((CheckedCollection)this).c.iterator();
            return new Iterator<E>(this){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public E next() {
                    return iterator.next();
                }

                @Override
                public void remove() {
                    iterator.remove();
                }

                @Override
                public void forEachRemaining(Consumer<? super E> action) {
                    iterator.forEachRemaining(action);
                }
            };
        }

        @Override
        public boolean add(E e) {
            this.typeCheck(e);
            return ((CheckedCollection)this).c.add(e);
        }

        private E[] zeroLengthElementArray() {
            Object[] objectArray;
            if (this.zeroLengthElementArray != null) {
                objectArray = this.zeroLengthElementArray;
            } else {
                Object[] objectArray2 = Collections.zeroLengthArray(((CheckedCollection)this).type);
                objectArray = objectArray2;
                this.zeroLengthElementArray = objectArray2;
            }
            return objectArray;
        }

        Collection<E> checkedCopyOf(Collection<? extends E> collection) {
            Object[] objectArray;
            block3: {
                objectArray = null;
                try {
                    E[] EArray = this.zeroLengthElementArray();
                    objectArray = collection.toArray(EArray);
                    if (!f.ifAcmp(objectArray.getClass(), EArray.getClass())) break block3;
                    objectArray = a.copyOf((Object[])objectArray, (int)a.arrayLength((Object[])objectArray), EArray.getClass());
                }
                catch (ArrayStoreException arrayStoreException) {
                    Object[] objectArray2 = objectArray = (Object[])g.convertForCast((Object)a.cloneArray((Object)collection.toArray()), Object[].class);
                    int n = a.arrayLength((Object[])objectArray2);
                    for (int i = 0; i < n; ++i) {
                        Object object = a.arrayLoad((Object[])objectArray2, (int)i);
                        this.typeCheck(object);
                    }
                }
            }
            return Arrays.asList(objectArray);
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            return ((CheckedCollection)this).c.addAll(this.checkedCopyOf(collection));
        }

        static /* synthetic */ void _jr$ip$c(Object object, Collection collection) {
            ((CheckedCollection)object).c = collection;
        }

        static /* synthetic */ void _jr$ip$type(Object object, Class clazz) {
            ((CheckedCollection)object).type = clazz;
        }

        protected /* synthetic */ CheckedCollection(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    static class CheckedList<E>
    extends CheckedCollection<E>
    implements List<E> {
        private static final long serialVersionUID = 65247728283967356L;
        final List<E> list;

        CheckedList(List<E> list, Class<E> clazz) {
            super(list, clazz);
            this.list = list;
        }

        @Override
        public boolean equals(Object object) {
            return !f.ifAcmp((Object)object, (Object)this) || ((CheckedList)this).list.equals(object);
        }

        @Override
        public int hashCode() {
            return ((CheckedList)this).list.hashCode();
        }

        @Override
        public E get(int n) {
            return ((CheckedList)this).list.get(n);
        }

        @Override
        public E remove(int n) {
            return ((CheckedList)this).list.remove(n);
        }

        @Override
        public int indexOf(Object object) {
            return ((CheckedList)this).list.indexOf(object);
        }

        @Override
        public int lastIndexOf(Object object) {
            return ((CheckedList)this).list.lastIndexOf(object);
        }

        @Override
        public E set(int n, E e) {
            this.typeCheck(e);
            return ((CheckedList)this).list.set(n, e);
        }

        @Override
        public void add(int n, E e) {
            this.typeCheck(e);
            ((CheckedList)this).list.add(n, e);
        }

        @Override
        public boolean addAll(int n, Collection<? extends E> collection) {
            return ((CheckedList)this).list.addAll(n, this.checkedCopyOf(collection));
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(int n) {
            final ListIterator listIterator = ((CheckedList)this).list.listIterator(n);
            return new ListIterator<E>(){

                @Override
                public boolean hasNext() {
                    return listIterator.hasNext();
                }

                @Override
                public E next() {
                    return listIterator.next();
                }

                @Override
                public boolean hasPrevious() {
                    return listIterator.hasPrevious();
                }

                @Override
                public E previous() {
                    return listIterator.previous();
                }

                @Override
                public int nextIndex() {
                    return listIterator.nextIndex();
                }

                @Override
                public int previousIndex() {
                    return listIterator.previousIndex();
                }

                @Override
                public void remove() {
                    listIterator.remove();
                }

                @Override
                public void set(E e) {
                    listIterator.set(this.typeCheck(e));
                }

                @Override
                public void add(E e) {
                    listIterator.add(this.typeCheck(e));
                }

                @Override
                public void forEachRemaining(Consumer<? super E> action) {
                    listIterator.forEachRemaining(action);
                }
            };
        }

        @Override
        public List<E> subList(int n, int n2) {
            return new CheckedList(((CheckedList)this).list.subList(n, n2), CheckedList._jr$ig$type(this));
        }

        static /* synthetic */ void _jr$ip$list(Object object, List list) {
            ((CheckedList)object).list = list;
        }

        protected /* synthetic */ CheckedList(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    private static class CheckedMap
    extends com.zeroturnaround.jrebelbase.h
    implements Map,
    Serializable {
        private static final long serialVersionUID = 5742860141034234728L;
        private final Map<K, V> m;
        final Class<K> keyType;
        final Class<V> valueType;
        private transient Set<Map.Entry<K, V>> entrySet;

        private void typeCheck(Object object, Object object2) {
            if (object != null && !x.isInstance((Class)((CheckedMap)this).keyType, (Object)object)) {
                throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new ClassCastException(this.badKeyMsg(object)));
            }
            if (object2 != null && !x.isInstance((Class)((CheckedMap)this).valueType, (Object)object2)) {
                throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new ClassCastException(this.badValueMsg(object2)));
            }
        }

        private String badKeyMsg(Object object) {
            return "Attempt to insert " + object.getClass() + " key into map with key type " + ((CheckedMap)this).keyType;
        }

        private String badValueMsg(Object object) {
            return "Attempt to insert " + object.getClass() + " value into map with value type " + ((CheckedMap)this).valueType;
        }

        CheckedMap(Map<K, V> map, Class<K> clazz, Class<V> clazz2) {
            this.entrySet = null;
            if (map == null || clazz == null || clazz2 == null) {
                throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new NullPointerException());
            }
            this.m = map;
            this.keyType = clazz;
            this.valueType = clazz2;
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean containsKey(Object object) {
            return this.m.containsKey(object);
        }

        @Override
        public boolean containsValue(Object object) {
            return this.m.containsValue(object);
        }

        @Override
        public V get(Object object) {
            return this.m.get(object);
        }

        @Override
        public V remove(Object object) {
            return this.m.remove(object);
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public Set<K> keySet() {
            return this.m.keySet();
        }

        @Override
        public Collection<V> values() {
            return this.m.values();
        }

        @Override
        public boolean equals(Object object) {
            return !f.ifAcmp((Object)object, (Object)this) || this.m.equals(object);
        }

        @Override
        public int hashCode() {
            return this.m.hashCode();
        }

        public String toString() {
            return this.m.toString();
        }

        @Override
        public V put(K k, V v) {
            this.typeCheck(k, v);
            return this.m.put(k, v);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            Object[] objectArray = map.entrySet().toArray();
            ArrayList<AbstractMap.SimpleImmutableEntry> arrayList = new ArrayList<AbstractMap.SimpleImmutableEntry>(a.arrayLength((Object[])objectArray));
            Object object = objectArray;
            int n = a.arrayLength((Object[])object);
            for (int i = 0; i < n; ++i) {
                Object object2 = a.arrayLoad((Object[])object, (int)i);
                Map.Entry entry = (Map.Entry)g.convertForCast((Object)object2, Map.Entry.class);
                Object k = entry.getKey();
                Object v = entry.getValue();
                this.typeCheck(k, v);
                arrayList.add(new AbstractMap.SimpleImmutableEntry(k, v));
            }
            object = arrayList.iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)g.convertForCast(object.next(), Map.Entry.class);
                this.m.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new CheckedEntrySet(this.m.entrySet(), ((CheckedMap)this).valueType);
            }
            return this.entrySet;
        }

        private static /* synthetic */ void _jr$ip$m(CheckedMap checkedMap, Map map) {
            checkedMap.m = map;
        }

        static /* synthetic */ void _jr$ip$keyType(Object object, Class clazz) {
            ((CheckedMap)object).keyType = clazz;
        }

        static /* synthetic */ void _jr$ip$valueType(Object object, Class clazz) {
            ((CheckedMap)object).valueType = clazz;
        }

        protected /* synthetic */ CheckedMap(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }

        /*
         * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
         */
        static class CheckedEntrySet
        extends com.zeroturnaround.jrebelbase.h
        implements Set {
            private final Set<Map.Entry<K, V>> s;
            private final Class<V> valueType;

            CheckedEntrySet(Set<Map.Entry<K, V>> set, Class<V> clazz) {
                this.s = set;
                this.valueType = clazz;
            }

            @Override
            public int size() {
                return this.s.size();
            }

            @Override
            public boolean isEmpty() {
                return this.s.isEmpty();
            }

            public String toString() {
                return this.s.toString();
            }

            @Override
            public int hashCode() {
                return this.s.hashCode();
            }

            @Override
            public void clear() {
                this.s.clear();
            }

            @Override
            public boolean add(Map.Entry<K, V> entry) {
                throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new UnsupportedOperationException());
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<K, V>> collection) {
                throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new UnsupportedOperationException());
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                Iterator iterator = this.s.iterator();
                Class clazz = this.valueType;
                return new Iterator<Map.Entry<K, V>>(this, iterator, clazz){
                    final /* synthetic */ Iterator val$i;
                    final /* synthetic */ CheckedEntrySet this$0;
                    {
                        this.this$0 = this$0;
                        this.val$i = iterator;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.val$i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.val$i.remove();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        return CheckedEntrySet.checkedEntry((Map.Entry)this.val$i.next(), this.this$0.valueType);
                    }

                    @Override
                    public void forEachRemaining(Consumer<? super Map.Entry<K, V>> action) {
                        Objects.requireNonNull(action);
                        this.val$i.forEachRemaining((? super E e) -> action.accept(CheckedEntrySet.checkedEntry(e, this.this$0.valueType)));
                    }
                };
            }

            @Override
            public Object[] toArray() {
                Object[] objectArray = this.s.toArray();
                Object[] objectArray2 = x.isInstance(CheckedEntry.class, ai.getCurrentClass(objectArray.getClass()).getComponentType()) ? objectArray : new Object[a.arrayLength((Object[])objectArray)];
                for (int i = 0; i < a.arrayLength((Object[])objectArray); ++i) {
                    a.arrayStore((Object[])objectArray2, (int)i, CheckedEntrySet.checkedEntry((Map.Entry)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), Map.Entry.class), this.valueType));
                }
                return objectArray2;
            }

            @Override
            public <T> T[] toArray(T[] TArray) {
                Object[] objectArray = this.s.toArray(a.arrayLength((Object[])TArray) == 0 ? TArray : Arrays.copyOf(TArray, 0));
                for (int i = 0; i < a.arrayLength((Object[])objectArray); ++i) {
                    a.arrayStore((Object[])objectArray, (int)i, CheckedEntrySet.checkedEntry((Map.Entry)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), Map.Entry.class), this.valueType));
                }
                if (a.arrayLength((Object[])objectArray) > a.arrayLength((Object[])TArray)) {
                    return objectArray;
                }
                a.arraycopy((Object)objectArray, (int)0, TArray, (int)0, (int)a.arrayLength((Object[])objectArray));
                if (a.arrayLength((Object[])TArray) > a.arrayLength((Object[])objectArray)) {
                    a.arrayStore((Object[])TArray, (int)a.arrayLength((Object[])objectArray), null);
                }
                return TArray;
            }

            @Override
            public boolean contains(Object object) {
                if (!(g.convertForInstanceOf((Object)object, Map.Entry.class) instanceof Map.Entry)) {
                    return false;
                }
                CheckedEntry checkedEntry = (CheckedEntry)g.convertForCast((Object)object, Map.Entry.class);
                return this.s.contains(g.convertForInstanceOf((Object)checkedEntry, CheckedEntry.class) instanceof CheckedEntry ? checkedEntry : CheckedEntrySet.checkedEntry(checkedEntry, this.valueType));
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                for (Object obj : collection) {
                    if (this.contains(obj)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean remove(Object object) {
                if (!(g.convertForInstanceOf((Object)object, Map.Entry.class) instanceof Map.Entry)) {
                    return false;
                }
                return this.s.remove(new AbstractMap.SimpleImmutableEntry((Map.Entry)g.convertForCast((Object)object, Map.Entry.class)));
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                return this.batchRemove(collection, false);
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                return this.batchRemove(collection, true);
            }

            private boolean batchRemove(Collection<?> collection, boolean bl) {
                boolean bl2 = false;
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    if (collection.contains(iterator.next()) == bl) continue;
                    iterator.remove();
                    bl2 = true;
                }
                return bl2;
            }

            @Override
            public boolean equals(Object object) {
                if (!f.ifAcmp((Object)object, (Object)this)) {
                    return true;
                }
                if (!(g.convertForInstanceOf((Object)object, Set.class) instanceof Set)) {
                    return false;
                }
                Set set = (Set)g.convertForCast((Object)object, Set.class);
                return set.size() == this.s.size() && this.containsAll(set);
            }

            static <K, V, T> CheckedEntry<K, V, T> checkedEntry(Map.Entry<K, V> entry, Class<T> clazz) {
                return new CheckedEntry(entry, clazz);
            }

            private static /* synthetic */ void _jr$ip$s(CheckedEntrySet checkedEntrySet, Set set) {
                checkedEntrySet.s = set;
            }

            private static /* synthetic */ void _jr$ip$valueType(CheckedEntrySet checkedEntrySet, Class clazz) {
                checkedEntrySet.valueType = clazz;
            }

            protected /* synthetic */ CheckedEntrySet(com.zeroturnaround.jrebelbase.h h2) {
                super(h2);
            }

            /*
             * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
             */
            private static class CheckedEntry
            extends com.zeroturnaround.jrebelbase.h
            implements Map.Entry {
                private final Map.Entry<K, V> e;
                private final Class<T> valueType;

                CheckedEntry(Map.Entry<K, V> entry, Class<T> clazz) {
                    this.e = entry;
                    this.valueType = clazz;
                }

                @Override
                public K getKey() {
                    return this.e.getKey();
                }

                @Override
                public V getValue() {
                    return this.e.getValue();
                }

                @Override
                public int hashCode() {
                    return this.e.hashCode();
                }

                public String toString() {
                    return this.e.toString();
                }

                @Override
                public V setValue(V v) {
                    if (v != null && !x.isInstance((Class)this.valueType, v)) {
                        throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new ClassCastException(this.badValueMsg(v)));
                    }
                    return this.e.setValue(v);
                }

                private String badValueMsg(Object object) {
                    return "Attempt to insert " + object.getClass() + " value into map with value type " + this.valueType;
                }

                @Override
                public boolean equals(Object object) {
                    if (!f.ifAcmp((Object)object, (Object)this)) {
                        return true;
                    }
                    if (!(g.convertForInstanceOf((Object)object, Map.Entry.class) instanceof Map.Entry)) {
                        return false;
                    }
                    return this.e.equals(new AbstractMap.SimpleImmutableEntry((Map.Entry)g.convertForCast((Object)object, Map.Entry.class)));
                }

                private static /* synthetic */ void _jr$ip$e(CheckedEntry checkedEntry, Map.Entry entry) {
                    checkedEntry.e = entry;
                }

                private static /* synthetic */ void _jr$ip$valueType(CheckedEntry checkedEntry, Class clazz) {
                    checkedEntry.valueType = clazz;
                }

                protected /* synthetic */ CheckedEntry(com.zeroturnaround.jrebelbase.h h2) {
                    super(h2);
                }
            }
        }
    }

    static class CheckedRandomAccessList<E>
    extends CheckedList<E>
    implements RandomAccess {
        private static final long serialVersionUID = 1638200125423088369L;

        CheckedRandomAccessList(List<E> list, Class<E> clazz) {
            super(list, clazz);
        }

        @Override
        public List<E> subList(int n, int n2) {
            return new CheckedRandomAccessList(CheckedRandomAccessList._jr$ig$list(this).subList(n, n2), CheckedRandomAccessList._jr$ig$type(this));
        }

        protected /* synthetic */ CheckedRandomAccessList(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    static class CheckedSet<E>
    extends CheckedCollection<E>
    implements Set<E>,
    Serializable {
        private static final long serialVersionUID = 4694047833775013803L;

        CheckedSet(Set<E> set, Class<E> clazz) {
            super(set, clazz);
        }

        @Override
        public boolean equals(Object object) {
            return !f.ifAcmp((Object)object, (Object)this) || CheckedSet._jr$ig$c(this).equals(object);
        }

        @Override
        public int hashCode() {
            return CheckedSet._jr$ig$c(this).hashCode();
        }

        protected /* synthetic */ CheckedSet(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    static class CheckedSortedMap<K, V>
    extends CheckedMap<K, V>
    implements SortedMap<K, V>,
    Serializable {
        private static final long serialVersionUID = 1599671320688067438L;
        private final SortedMap<K, V> sm;

        CheckedSortedMap(SortedMap<K, V> sortedMap, Class<K> clazz, Class<V> clazz2) {
            super(sortedMap, clazz, clazz2);
            this.sm = sortedMap;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sm.comparator();
        }

        @Override
        public K firstKey() {
            return this.sm.firstKey();
        }

        @Override
        public K lastKey() {
            return this.sm.lastKey();
        }

        @Override
        public SortedMap<K, V> subMap(K k, K k2) {
            return Collections.checkedSortedMap(this.sm.subMap(k, k2), CheckedSortedMap._jr$ig$keyType(this), CheckedSortedMap._jr$ig$valueType(this));
        }

        @Override
        public SortedMap<K, V> headMap(K k) {
            return Collections.checkedSortedMap(this.sm.headMap(k), CheckedSortedMap._jr$ig$keyType(this), CheckedSortedMap._jr$ig$valueType(this));
        }

        @Override
        public SortedMap<K, V> tailMap(K k) {
            return Collections.checkedSortedMap(this.sm.tailMap(k), CheckedSortedMap._jr$ig$keyType(this), CheckedSortedMap._jr$ig$valueType(this));
        }

        private static /* synthetic */ void _jr$ip$sm(CheckedSortedMap checkedSortedMap, SortedMap sortedMap) {
            checkedSortedMap.sm = sortedMap;
        }

        protected /* synthetic */ CheckedSortedMap(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    static class CheckedSortedSet<E>
    extends CheckedSet<E>
    implements SortedSet<E>,
    Serializable {
        private static final long serialVersionUID = 1599911165492914959L;
        private final SortedSet<E> ss;

        CheckedSortedSet(SortedSet<E> sortedSet, Class<E> clazz) {
            super(sortedSet, clazz);
            this.ss = sortedSet;
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.ss.comparator();
        }

        @Override
        public E first() {
            return this.ss.first();
        }

        @Override
        public E last() {
            return this.ss.last();
        }

        @Override
        public SortedSet<E> subSet(E e, E e2) {
            return Collections.checkedSortedSet(this.ss.subSet(e, e2), CheckedSortedSet._jr$ig$type(this));
        }

        @Override
        public SortedSet<E> headSet(E e) {
            return Collections.checkedSortedSet(this.ss.headSet(e), CheckedSortedSet._jr$ig$type(this));
        }

        @Override
        public SortedSet<E> tailSet(E e) {
            return Collections.checkedSortedSet(this.ss.tailSet(e), CheckedSortedSet._jr$ig$type(this));
        }

        private static /* synthetic */ void _jr$ip$ss(CheckedSortedSet checkedSortedSet, SortedSet sortedSet) {
            checkedSortedSet.ss = sortedSet;
        }

        protected /* synthetic */ CheckedSortedSet(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    private static class CopiesList<E>
    extends AbstractList<E>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 2739099268398711800L;
        final int n;
        final E element;

        CopiesList(int n, E e) {
            if (!$assertionsDisabled && n < 0) {
                throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new AssertionError());
            }
            this.n = n;
            this.element = e;
        }

        @Override
        public int size() {
            return ((CopiesList)this).n;
        }

        @Override
        public boolean contains(Object object) {
            return ((CopiesList)this).n != 0 && Collections.eq(object, ((CopiesList)this).element);
        }

        @Override
        public int indexOf(Object object) {
            return this.contains(object) ? 0 : -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            return this.contains(object) ? ((CopiesList)this).n - 1 : -1;
        }

        @Override
        public E get(int n) {
            if (n < 0 || n >= ((CopiesList)this).n) {
                throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new IndexOutOfBoundsException("Index: " + n + ", Size: " + ((CopiesList)this).n));
            }
            return (E)((CopiesList)this).element;
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[((CopiesList)this).n];
            if (((CopiesList)this).element != null) {
                Arrays.fill(objectArray, 0, ((CopiesList)this).n, ((CopiesList)this).element);
            }
            return objectArray;
        }

        @Override
        public <T> T[] toArray(T[] objectArray) {
            int n = ((CopiesList)this).n;
            if (a.arrayLength((Object[])objectArray) < n) {
                objectArray = (Object[])g.convertForCast((Object)((Object[])g.convertForCast((Object)Array.newInstance(ai.getCurrentClass(objectArray.getClass()).getComponentType(), n), Object[].class)), Object[].class);
                if (((CopiesList)this).element != null) {
                    Arrays.fill(objectArray, 0, n, ((CopiesList)this).element);
                }
            } else {
                Arrays.fill(objectArray, 0, n, ((CopiesList)this).element);
                if (a.arrayLength((Object[])objectArray) > n) {
                    a.arrayStore((Object[])objectArray, (int)n, null);
                }
            }
            return objectArray;
        }

        @Override
        public List<E> subList(int n, int n2) {
            if (n < 0) {
                throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new IndexOutOfBoundsException("fromIndex = " + n));
            }
            if (n2 > ((CopiesList)this).n) {
                throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new IndexOutOfBoundsException("toIndex = " + n2));
            }
            if (n > n2) {
                throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")"));
            }
            return new CopiesList<Object>(n2 - n, ((CopiesList)this).element);
        }

        static /* synthetic */ void _jr$ip$n(Object object, int n) {
            ((CopiesList)object).n = n;
        }

        static /* synthetic */ void _jr$ip$element(Object object, Object object2) {
            ((CopiesList)object).element = object2;
        }

        protected /* synthetic */ CopiesList(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    private static class EmptyEnumeration
    extends com.zeroturnaround.jrebelbase.h
    implements Enumeration {
        static final EmptyEnumeration<Object> EMPTY_ENUMERATION = new EmptyEnumeration();

        private EmptyEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public E nextElement() {
            throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new NoSuchElementException());
        }

        protected /* synthetic */ EmptyEnumeration(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    private static class EmptyIterator
    extends com.zeroturnaround.jrebelbase.h
    implements Iterator {
        static final EmptyIterator<Object> EMPTY_ITERATOR = new EmptyIterator();

        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public E next() {
            throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new NoSuchElementException());
        }

        @Override
        public void remove() {
            throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new IllegalStateException());
        }

        protected /* synthetic */ EmptyIterator(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    private static class EmptyList<E>
    extends AbstractList<E>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 8842843931221139166L;

        private EmptyList() {
        }

        @Override
        public Iterator<E> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public ListIterator<E> listIterator() {
            return Collections.emptyListIterator();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(Object object) {
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return collection.isEmpty();
        }

        @Override
        public Object[] toArray() {
            return new Object[0];
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            if (a.arrayLength((Object[])TArray) > 0) {
                a.arrayStore((Object[])TArray, (int)0, null);
            }
            return TArray;
        }

        @Override
        public E get(int n) {
            throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new IndexOutOfBoundsException("Index: " + n));
        }

        @Override
        public boolean equals(Object object) {
            return g.convertForInstanceOf((Object)object, List.class) instanceof List && ((List)g.convertForCast((Object)object, List.class)).isEmpty();
        }

        @Override
        public int hashCode() {
            return 1;
        }

        private Object readResolve() {
            return EMPTY_LIST;
        }

        protected /* synthetic */ EmptyList(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    private static class EmptyListIterator<E>
    extends EmptyIterator<E>
    implements ListIterator<E> {
        static final EmptyListIterator<Object> EMPTY_ITERATOR = new EmptyListIterator();

        private EmptyListIterator() {
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public E previous() {
            throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new NoSuchElementException());
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        @Override
        public void set(E e) {
            throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new IllegalStateException());
        }

        @Override
        public void add(E e) {
            throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new UnsupportedOperationException());
        }

        protected /* synthetic */ EmptyListIterator(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    private static class EmptyMap<K, V>
    extends AbstractMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = 6428348081105594320L;

        private EmptyMap() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean containsKey(Object object) {
            return false;
        }

        @Override
        public boolean containsValue(Object object) {
            return false;
        }

        @Override
        public V get(Object object) {
            return null;
        }

        @Override
        public Set<K> keySet() {
            return Collections.emptySet();
        }

        @Override
        public Collection<V> values() {
            return Collections.emptySet();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return Collections.emptySet();
        }

        @Override
        public boolean equals(Object object) {
            return g.convertForInstanceOf((Object)object, Map.class) instanceof Map && ((Map)g.convertForCast((Object)object, Map.class)).isEmpty();
        }

        @Override
        public int hashCode() {
            return 0;
        }

        private Object readResolve() {
            return EMPTY_MAP;
        }

        protected /* synthetic */ EmptyMap(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    private static class EmptySet<E>
    extends AbstractSet<E>
    implements Serializable {
        private static final long serialVersionUID = 1582296315990362920L;

        private EmptySet() {
        }

        @Override
        public Iterator<E> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(Object object) {
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return collection.isEmpty();
        }

        @Override
        public Object[] toArray() {
            return new Object[0];
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            if (a.arrayLength((Object[])TArray) > 0) {
                a.arrayStore((Object[])TArray, (int)0, null);
            }
            return TArray;
        }

        private Object readResolve() {
            return EMPTY_SET;
        }

        protected /* synthetic */ EmptySet(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    private static class ReverseComparator
    extends com.zeroturnaround.jrebelbase.h
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 7207038068494060240L;
        static final ReverseComparator REVERSE_ORDER = new ReverseComparator();

        private ReverseComparator() {
        }

        public int compare(Comparable<Object> comparable, Comparable<Object> comparable2) {
            return comparable2.compareTo(comparable);
        }

        private Object readResolve() {
            return Collections.reverseOrder();
        }

        protected /* synthetic */ ReverseComparator(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    private static class ReverseComparator2
    extends com.zeroturnaround.jrebelbase.h
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 4374092139857L;
        final Comparator<T> cmp;

        ReverseComparator2(Comparator<T> comparator) {
            if (!$assertionsDisabled && comparator == null) {
                throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new AssertionError());
            }
            this.cmp = comparator;
        }

        @Override
        public int compare(T t, T t2) {
            return ((ReverseComparator2)this).cmp.compare(t2, t);
        }

        @Override
        public boolean equals(Object object) {
            return !f.ifAcmp((Object)object, (Object)this) || g.convertForInstanceOf((Object)object, ReverseComparator2.class) instanceof ReverseComparator2 && ((ReverseComparator2)this).cmp.equals(((ReverseComparator2)((ReverseComparator2)g.convertForCast((Object)object, ReverseComparator2.class))).cmp);
        }

        public int hashCode() {
            return ((ReverseComparator2)this).cmp.hashCode() ^ Integer.MIN_VALUE;
        }

        static /* synthetic */ void _jr$ip$cmp(Object object, Comparator comparator) {
            ((ReverseComparator2)object).cmp = comparator;
        }

        protected /* synthetic */ ReverseComparator2(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    private static class SetFromMap<E>
    extends AbstractSet<E>
    implements Set<E>,
    Serializable {
        private final Map<E, Boolean> m;
        private transient Set<E> s;
        private static final long serialVersionUID = 2454657854757543876L;

        SetFromMap(Map<E, Boolean> map) {
            if (!map.isEmpty()) {
                throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new IllegalArgumentException("Map is non-empty"));
            }
            this.m = map;
            this.s = map.keySet();
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.m.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return this.m.remove(object) != null;
        }

        @Override
        public boolean add(E e) {
            return this.m.put(e, Boolean.TRUE) == null;
        }

        @Override
        public Iterator<E> iterator() {
            return this.s.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.s.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.s.toArray(TArray);
        }

        @Override
        public String toString() {
            return this.s.toString();
        }

        @Override
        public int hashCode() {
            return this.s.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            return !f.ifAcmp((Object)object, (Object)this) || this.s.equals(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.s.containsAll(collection);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return this.s.removeAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return this.s.retainAll(collection);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.s = this.m.keySet();
        }

        private static /* synthetic */ void _jr$ip$m(SetFromMap setFromMap, Map map) {
            setFromMap.m = map;
        }

        protected /* synthetic */ SetFromMap(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    private static class SingletonList<E>
    extends AbstractList<E>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 3093736618740652951L;
        private final E element;

        SingletonList(E e) {
            this.element = e;
        }

        @Override
        public Iterator<E> iterator() {
            return Collections.singletonIterator(this.element);
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean contains(Object object) {
            return Collections.eq(object, this.element);
        }

        @Override
        public E get(int n) {
            if (n != 0) {
                throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new IndexOutOfBoundsException("Index: " + n + ", Size: 1"));
            }
            return (E)this.element;
        }

        private static /* synthetic */ void _jr$ip$element(SingletonList singletonList, Object object) {
            singletonList.element = object;
        }

        protected /* synthetic */ SingletonList(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    private static class SingletonMap<K, V>
    extends AbstractMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = -6979724477215052911L;
        private final K k;
        private final V v;
        private transient Set<K> keySet;
        private transient Set<Map.Entry<K, V>> entrySet;
        private transient Collection<V> values;

        SingletonMap(K k, V v) {
            this.keySet = null;
            this.entrySet = null;
            this.values = null;
            this.k = k;
            this.v = v;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(Object object) {
            return Collections.eq(object, this.k);
        }

        @Override
        public boolean containsValue(Object object) {
            return Collections.eq(object, this.v);
        }

        @Override
        public V get(Object object) {
            return (V)(Collections.eq(object, this.k) ? this.v : null);
        }

        @Override
        public Set<K> keySet() {
            if (this.keySet == null) {
                this.keySet = Collections.singleton(this.k);
            }
            return this.keySet;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = Collections.singleton(new AbstractMap.SimpleImmutableEntry(this.k, this.v));
            }
            return this.entrySet;
        }

        @Override
        public Collection<V> values() {
            if (this.values == null) {
                this.values = Collections.singleton(this.v);
            }
            return this.values;
        }

        private static /* synthetic */ void _jr$ip$k(SingletonMap singletonMap, Object object) {
            singletonMap.k = object;
        }

        private static /* synthetic */ void _jr$ip$v(SingletonMap singletonMap, Object object) {
            singletonMap.v = object;
        }

        protected /* synthetic */ SingletonMap(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    private static class SingletonSet<E>
    extends AbstractSet<E>
    implements Serializable {
        private static final long serialVersionUID = 3193687207550431679L;
        private final E element;

        SingletonSet(E e) {
            this.element = e;
        }

        @Override
        public Iterator<E> iterator() {
            return Collections.singletonIterator(this.element);
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean contains(Object object) {
            return Collections.eq(object, this.element);
        }

        private static /* synthetic */ void _jr$ip$element(SingletonSet singletonSet, Object object) {
            singletonSet.element = object;
        }

        protected /* synthetic */ SingletonSet(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    static class SynchronizedCollection
    extends com.zeroturnaround.jrebelbase.h
    implements Collection,
    Serializable {
        private static final long serialVersionUID = 3053995032091335093L;
        final Collection<E> c;
        final Object mutex;

        SynchronizedCollection(Collection<E> collection) {
            if (collection == null) {
                throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new NullPointerException());
            }
            this.c = collection;
            this.mutex = this;
        }

        SynchronizedCollection(Collection<E> collection, Object object) {
            this.c = collection;
            this.mutex = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = ah.getMonitor((Object)((SynchronizedCollection)this).mutex);
            synchronized (object) {
                try {
                    return ((SynchronizedCollection)this).c.size();
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = ah.getMonitor((Object)((SynchronizedCollection)this).mutex);
            synchronized (object) {
                try {
                    return ((SynchronizedCollection)this).c.isEmpty();
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object object) {
            Object object2 = ah.getMonitor((Object)((SynchronizedCollection)this).mutex);
            synchronized (object2) {
                try {
                    return ((SynchronizedCollection)this).c.contains(object);
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = ah.getMonitor((Object)((SynchronizedCollection)this).mutex);
            synchronized (object) {
                try {
                    return ((SynchronizedCollection)this).c.toArray();
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] TArray) {
            Object object = ah.getMonitor((Object)((SynchronizedCollection)this).mutex);
            synchronized (object) {
                try {
                    return ((SynchronizedCollection)this).c.toArray(TArray);
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        @Override
        public Iterator<E> iterator() {
            return ((SynchronizedCollection)this).c.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(E e) {
            Object object = ah.getMonitor((Object)((SynchronizedCollection)this).mutex);
            synchronized (object) {
                try {
                    return ((SynchronizedCollection)this).c.add(e);
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object object) {
            Object object2 = ah.getMonitor((Object)((SynchronizedCollection)this).mutex);
            synchronized (object2) {
                try {
                    return ((SynchronizedCollection)this).c.remove(object);
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> collection) {
            Object object = ah.getMonitor((Object)((SynchronizedCollection)this).mutex);
            synchronized (object) {
                try {
                    return ((SynchronizedCollection)this).c.containsAll(collection);
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends E> collection) {
            Object object = ah.getMonitor((Object)((SynchronizedCollection)this).mutex);
            synchronized (object) {
                try {
                    return ((SynchronizedCollection)this).c.addAll(collection);
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> collection) {
            Object object = ah.getMonitor((Object)((SynchronizedCollection)this).mutex);
            synchronized (object) {
                try {
                    return ((SynchronizedCollection)this).c.removeAll(collection);
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> collection) {
            Object object = ah.getMonitor((Object)((SynchronizedCollection)this).mutex);
            synchronized (object) {
                try {
                    return ((SynchronizedCollection)this).c.retainAll(collection);
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = ah.getMonitor((Object)((SynchronizedCollection)this).mutex);
            synchronized (object) {
                try {
                    ((SynchronizedCollection)this).c.clear();
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = ah.getMonitor((Object)((SynchronizedCollection)this).mutex);
            synchronized (object) {
                try {
                    return ((SynchronizedCollection)this).c.toString();
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            Object object = ah.getMonitor((Object)((SynchronizedCollection)this).mutex);
            synchronized (object) {
                try {
                    objectOutputStream.defaultWriteObject();
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        static /* synthetic */ void _jr$ip$c(Object object, Collection collection) {
            ((SynchronizedCollection)object).c = collection;
        }

        static /* synthetic */ void _jr$ip$mutex(Object object, Object object2) {
            ((SynchronizedCollection)object).mutex = object2;
        }

        protected /* synthetic */ SynchronizedCollection(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    static class SynchronizedList<E>
    extends SynchronizedCollection<E>
    implements List<E> {
        private static final long serialVersionUID = -7754090372962971524L;
        final List<E> list;

        SynchronizedList(List<E> list) {
            super(list);
            this.list = list;
        }

        SynchronizedList(List<E> list, Object object) {
            super(list, object);
            this.list = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object object) {
            if (!f.ifAcmp((Object)this, (Object)object)) {
                return true;
            }
            Object object2 = ah.getMonitor((Object)SynchronizedList._jr$ig$mutex(this));
            synchronized (object2) {
                try {
                    return ((SynchronizedList)this).list.equals(object);
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = ah.getMonitor((Object)SynchronizedList._jr$ig$mutex(this));
            synchronized (object) {
                try {
                    return ((SynchronizedList)this).list.hashCode();
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E get(int n) {
            Object object = ah.getMonitor((Object)SynchronizedList._jr$ig$mutex(this));
            synchronized (object) {
                try {
                    return ((SynchronizedList)this).list.get(n);
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E set(int n, E e) {
            Object object = ah.getMonitor((Object)SynchronizedList._jr$ig$mutex(this));
            synchronized (object) {
                try {
                    return ((SynchronizedList)this).list.set(n, e);
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int n, E e) {
            Object object = ah.getMonitor((Object)SynchronizedList._jr$ig$mutex(this));
            synchronized (object) {
                try {
                    ((SynchronizedList)this).list.add(n, e);
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E remove(int n) {
            Object object = ah.getMonitor((Object)SynchronizedList._jr$ig$mutex(this));
            synchronized (object) {
                try {
                    return ((SynchronizedList)this).list.remove(n);
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object object) {
            Object object2 = ah.getMonitor((Object)SynchronizedList._jr$ig$mutex(this));
            synchronized (object2) {
                try {
                    return ((SynchronizedList)this).list.indexOf(object);
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object object) {
            Object object2 = ah.getMonitor((Object)SynchronizedList._jr$ig$mutex(this));
            synchronized (object2) {
                try {
                    return ((SynchronizedList)this).list.lastIndexOf(object);
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int n, Collection<? extends E> collection) {
            Object object = ah.getMonitor((Object)SynchronizedList._jr$ig$mutex(this));
            synchronized (object) {
                try {
                    return ((SynchronizedList)this).list.addAll(n, collection);
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        @Override
        public ListIterator<E> listIterator() {
            return ((SynchronizedList)this).list.listIterator();
        }

        @Override
        public ListIterator<E> listIterator(int n) {
            return ((SynchronizedList)this).list.listIterator(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<E> subList(int n, int n2) {
            Object object = ah.getMonitor((Object)SynchronizedList._jr$ig$mutex(this));
            synchronized (object) {
                try {
                    return new SynchronizedList(((SynchronizedList)this).list.subList(n, n2), SynchronizedList._jr$ig$mutex(this));
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        private Object readResolve() {
            return g.convertForInstanceOf((Object)((SynchronizedList)this).list, RandomAccess.class) instanceof RandomAccess ? new SynchronizedRandomAccessList(((SynchronizedList)this).list) : this;
        }

        static /* synthetic */ void _jr$ip$list(Object object, List list) {
            ((SynchronizedList)object).list = list;
        }

        protected /* synthetic */ SynchronizedList(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    private static class SynchronizedMap
    extends com.zeroturnaround.jrebelbase.h
    implements Map,
    Serializable {
        private static final long serialVersionUID = 1978198479659022715L;
        private final Map<K, V> m;
        final Object mutex;
        private transient Set<K> keySet;
        private transient Set<Map.Entry<K, V>> entrySet;
        private transient Collection<V> values;

        SynchronizedMap(Map<K, V> map) {
            this.keySet = null;
            this.entrySet = null;
            this.values = null;
            if (map == null) {
                throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new NullPointerException());
            }
            this.m = map;
            this.mutex = this;
        }

        SynchronizedMap(Map<K, V> map, Object object) {
            this.keySet = null;
            this.entrySet = null;
            this.values = null;
            this.m = map;
            this.mutex = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = ah.getMonitor((Object)((SynchronizedMap)this).mutex);
            synchronized (object) {
                try {
                    return this.m.size();
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = ah.getMonitor((Object)((SynchronizedMap)this).mutex);
            synchronized (object) {
                try {
                    return this.m.isEmpty();
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object object) {
            Object object2 = ah.getMonitor((Object)((SynchronizedMap)this).mutex);
            synchronized (object2) {
                try {
                    return this.m.containsKey(object);
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object object) {
            Object object2 = ah.getMonitor((Object)((SynchronizedMap)this).mutex);
            synchronized (object2) {
                try {
                    return this.m.containsValue(object);
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(Object object) {
            Object object2 = ah.getMonitor((Object)((SynchronizedMap)this).mutex);
            synchronized (object2) {
                try {
                    return this.m.get(object);
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V put(K k, V v) {
            Object object = ah.getMonitor((Object)((SynchronizedMap)this).mutex);
            synchronized (object) {
                try {
                    return this.m.put(k, v);
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V remove(Object object) {
            Object object2 = ah.getMonitor((Object)((SynchronizedMap)this).mutex);
            synchronized (object2) {
                try {
                    return this.m.remove(object);
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            Object object = ah.getMonitor((Object)((SynchronizedMap)this).mutex);
            synchronized (object) {
                try {
                    this.m.putAll(map);
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = ah.getMonitor((Object)((SynchronizedMap)this).mutex);
            synchronized (object) {
                try {
                    this.m.clear();
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<K> keySet() {
            Object object = ah.getMonitor((Object)((SynchronizedMap)this).mutex);
            synchronized (object) {
                try {
                    if (this.keySet == null) {
                        this.keySet = new SynchronizedSet(this.m.keySet(), ((SynchronizedMap)this).mutex);
                    }
                    return this.keySet;
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            Object object = ah.getMonitor((Object)((SynchronizedMap)this).mutex);
            synchronized (object) {
                try {
                    if (this.entrySet == null) {
                        this.entrySet = new SynchronizedSet(this.m.entrySet(), ((SynchronizedMap)this).mutex);
                    }
                    return this.entrySet;
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<V> values() {
            Object object = ah.getMonitor((Object)((SynchronizedMap)this).mutex);
            synchronized (object) {
                try {
                    if (this.values == null) {
                        this.values = new SynchronizedCollection(this.m.values(), ((SynchronizedMap)this).mutex);
                    }
                    return this.values;
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object object) {
            if (!f.ifAcmp((Object)this, (Object)object)) {
                return true;
            }
            Object object2 = ah.getMonitor((Object)((SynchronizedMap)this).mutex);
            synchronized (object2) {
                try {
                    return this.m.equals(object);
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = ah.getMonitor((Object)((SynchronizedMap)this).mutex);
            synchronized (object) {
                try {
                    return this.m.hashCode();
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = ah.getMonitor((Object)((SynchronizedMap)this).mutex);
            synchronized (object) {
                try {
                    return this.m.toString();
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            Object object = ah.getMonitor((Object)((SynchronizedMap)this).mutex);
            synchronized (object) {
                try {
                    objectOutputStream.defaultWriteObject();
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        private static /* synthetic */ void _jr$ip$m(SynchronizedMap synchronizedMap, Map map) {
            synchronizedMap.m = map;
        }

        static /* synthetic */ void _jr$ip$mutex(Object object, Object object2) {
            ((SynchronizedMap)object).mutex = object2;
        }

        protected /* synthetic */ SynchronizedMap(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    static class SynchronizedRandomAccessList<E>
    extends SynchronizedList<E>
    implements RandomAccess {
        private static final long serialVersionUID = 1530674583602358482L;

        SynchronizedRandomAccessList(List<E> list) {
            super(list);
        }

        SynchronizedRandomAccessList(List<E> list, Object object) {
            super(list, object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<E> subList(int n, int n2) {
            Object object = ah.getMonitor((Object)SynchronizedRandomAccessList._jr$ig$mutex(this));
            synchronized (object) {
                try {
                    return new SynchronizedRandomAccessList(SynchronizedRandomAccessList._jr$ig$list(this).subList(n, n2), SynchronizedRandomAccessList._jr$ig$mutex(this));
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        private Object writeReplace() {
            return new SynchronizedList(SynchronizedRandomAccessList._jr$ig$list(this));
        }

        protected /* synthetic */ SynchronizedRandomAccessList(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    static class SynchronizedSet<E>
    extends SynchronizedCollection<E>
    implements Set<E> {
        private static final long serialVersionUID = 487447009682186044L;

        SynchronizedSet(Set<E> set) {
            super(set);
        }

        SynchronizedSet(Set<E> set, Object object) {
            super(set, object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object object) {
            if (!f.ifAcmp((Object)this, (Object)object)) {
                return true;
            }
            Object object2 = ah.getMonitor((Object)SynchronizedSet._jr$ig$mutex(this));
            synchronized (object2) {
                try {
                    return SynchronizedSet._jr$ig$c(this).equals(object);
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = ah.getMonitor((Object)SynchronizedSet._jr$ig$mutex(this));
            synchronized (object) {
                try {
                    return SynchronizedSet._jr$ig$c(this).hashCode();
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        protected /* synthetic */ SynchronizedSet(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    static class SynchronizedSortedMap<K, V>
    extends SynchronizedMap<K, V>
    implements SortedMap<K, V> {
        private static final long serialVersionUID = -8798146769416483793L;
        private final SortedMap<K, V> sm;

        SynchronizedSortedMap(SortedMap<K, V> sortedMap) {
            super(sortedMap);
            this.sm = sortedMap;
        }

        SynchronizedSortedMap(SortedMap<K, V> sortedMap, Object object) {
            super(sortedMap, object);
            this.sm = sortedMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Comparator<? super K> comparator() {
            Object object = ah.getMonitor((Object)SynchronizedSortedMap._jr$ig$mutex(this));
            synchronized (object) {
                try {
                    return this.sm.comparator();
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> subMap(K k, K k2) {
            Object object = ah.getMonitor((Object)SynchronizedSortedMap._jr$ig$mutex(this));
            synchronized (object) {
                try {
                    return new SynchronizedSortedMap(this.sm.subMap(k, k2), SynchronizedSortedMap._jr$ig$mutex(this));
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> headMap(K k) {
            Object object = ah.getMonitor((Object)SynchronizedSortedMap._jr$ig$mutex(this));
            synchronized (object) {
                try {
                    return new SynchronizedSortedMap(this.sm.headMap(k), SynchronizedSortedMap._jr$ig$mutex(this));
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> tailMap(K k) {
            Object object = ah.getMonitor((Object)SynchronizedSortedMap._jr$ig$mutex(this));
            synchronized (object) {
                try {
                    return new SynchronizedSortedMap(this.sm.tailMap(k), SynchronizedSortedMap._jr$ig$mutex(this));
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K firstKey() {
            Object object = ah.getMonitor((Object)SynchronizedSortedMap._jr$ig$mutex(this));
            synchronized (object) {
                try {
                    return this.sm.firstKey();
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K lastKey() {
            Object object = ah.getMonitor((Object)SynchronizedSortedMap._jr$ig$mutex(this));
            synchronized (object) {
                try {
                    return this.sm.lastKey();
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        private static /* synthetic */ void _jr$ip$sm(SynchronizedSortedMap synchronizedSortedMap, SortedMap sortedMap) {
            synchronizedSortedMap.sm = sortedMap;
        }

        protected /* synthetic */ SynchronizedSortedMap(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    static class SynchronizedSortedSet<E>
    extends SynchronizedSet<E>
    implements SortedSet<E> {
        private static final long serialVersionUID = 8695801310862127406L;
        private final SortedSet<E> ss;

        SynchronizedSortedSet(SortedSet<E> sortedSet) {
            super(sortedSet);
            this.ss = sortedSet;
        }

        SynchronizedSortedSet(SortedSet<E> sortedSet, Object object) {
            super(sortedSet, object);
            this.ss = sortedSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Comparator<? super E> comparator() {
            Object object = ah.getMonitor((Object)SynchronizedSortedSet._jr$ig$mutex(this));
            synchronized (object) {
                try {
                    return this.ss.comparator();
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet<E> subSet(E e, E e2) {
            Object object = ah.getMonitor((Object)SynchronizedSortedSet._jr$ig$mutex(this));
            synchronized (object) {
                try {
                    return new SynchronizedSortedSet<E>(this.ss.subSet(e, e2), SynchronizedSortedSet._jr$ig$mutex(this));
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet<E> headSet(E e) {
            Object object = ah.getMonitor((Object)SynchronizedSortedSet._jr$ig$mutex(this));
            synchronized (object) {
                try {
                    return new SynchronizedSortedSet<E>(this.ss.headSet(e), SynchronizedSortedSet._jr$ig$mutex(this));
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet<E> tailSet(E e) {
            Object object = ah.getMonitor((Object)SynchronizedSortedSet._jr$ig$mutex(this));
            synchronized (object) {
                try {
                    return new SynchronizedSortedSet<E>(this.ss.tailSet(e), SynchronizedSortedSet._jr$ig$mutex(this));
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E first() {
            Object object = ah.getMonitor((Object)SynchronizedSortedSet._jr$ig$mutex(this));
            synchronized (object) {
                try {
                    return this.ss.first();
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E last() {
            Object object = ah.getMonitor((Object)SynchronizedSortedSet._jr$ig$mutex(this));
            synchronized (object) {
                try {
                    return this.ss.last();
                }
                catch (Throwable throwable) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
                }
            }
        }

        private static /* synthetic */ void _jr$ip$ss(SynchronizedSortedSet synchronizedSortedSet, SortedSet sortedSet) {
            synchronizedSortedSet.ss = sortedSet;
        }

        protected /* synthetic */ SynchronizedSortedSet(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    static class UnmodifiableCollection
    extends com.zeroturnaround.jrebelbase.h
    implements Collection,
    Serializable {
        private static final long serialVersionUID = 1820017752578914078L;
        final Collection<? extends E> c;

        UnmodifiableCollection(Collection<? extends E> collection) {
            if (collection == null) {
                throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new NullPointerException());
            }
            this.c = collection;
        }

        @Override
        public int size() {
            return ((UnmodifiableCollection)this).c.size();
        }

        @Override
        public boolean isEmpty() {
            return ((UnmodifiableCollection)this).c.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return ((UnmodifiableCollection)this).c.contains(object);
        }

        @Override
        public Object[] toArray() {
            return ((UnmodifiableCollection)this).c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return ((UnmodifiableCollection)this).c.toArray(TArray);
        }

        public String toString() {
            return ((UnmodifiableCollection)this).c.toString();
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator(this){
                private final Iterator<? extends E> i;
                final /* synthetic */ UnmodifiableCollection this$0;
                {
                    this.this$0 = unmodifiableCollection;
                    this.i = ((UnmodifiableCollection)this.this$0).c.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public E next() {
                    return this.i.next();
                }

                @Override
                public void remove() {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new UnsupportedOperationException());
                }

                private static /* synthetic */ void _jr$ip$i(1 var0, Iterator iterator) {
                    var0.i = iterator;
                }

                static /* synthetic */ UnmodifiableCollection _jr$ig$this$0(Object object) {
                    return (object).this$0;
                }

                static /* synthetic */ void _jr$ip$this$0(Object object, UnmodifiableCollection unmodifiableCollection) {
                    (object).this$0 = unmodifiableCollection;
                }
            };
        }

        @Override
        public boolean add(E e) {
            throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new UnsupportedOperationException());
        }

        @Override
        public boolean remove(Object object) {
            throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new UnsupportedOperationException());
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return ((UnmodifiableCollection)this).c.containsAll(collection);
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new UnsupportedOperationException());
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new UnsupportedOperationException());
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new UnsupportedOperationException());
        }

        @Override
        public void clear() {
            throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new UnsupportedOperationException());
        }

        static /* synthetic */ void _jr$ip$c(Object object, Collection collection) {
            ((UnmodifiableCollection)object).c = collection;
        }

        protected /* synthetic */ UnmodifiableCollection(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    static class UnmodifiableList<E>
    extends UnmodifiableCollection<E>
    implements List<E> {
        private static final long serialVersionUID = -283967356065247728L;
        final List<? extends E> list;

        UnmodifiableList(List<? extends E> list) {
            super(list);
            this.list = list;
        }

        @Override
        public boolean equals(Object object) {
            return !f.ifAcmp((Object)object, (Object)this) || ((UnmodifiableList)this).list.equals(object);
        }

        @Override
        public int hashCode() {
            return ((UnmodifiableList)this).list.hashCode();
        }

        @Override
        public E get(int n) {
            return ((UnmodifiableList)this).list.get(n);
        }

        @Override
        public E set(int n, E e) {
            throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new UnsupportedOperationException());
        }

        @Override
        public void add(int n, E e) {
            throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new UnsupportedOperationException());
        }

        @Override
        public E remove(int n) {
            throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new UnsupportedOperationException());
        }

        @Override
        public int indexOf(Object object) {
            return ((UnmodifiableList)this).list.indexOf(object);
        }

        @Override
        public int lastIndexOf(Object object) {
            return ((UnmodifiableList)this).list.lastIndexOf(object);
        }

        @Override
        public boolean addAll(int n, Collection<? extends E> collection) {
            throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new UnsupportedOperationException());
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(final int n) {
            return new ListIterator<E>(){
                private final ListIterator<? extends E> i;
                {
                    this.i = list.listIterator(n);
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public E next() {
                    return this.i.next();
                }

                @Override
                public boolean hasPrevious() {
                    return this.i.hasPrevious();
                }

                @Override
                public E previous() {
                    return this.i.previous();
                }

                @Override
                public int nextIndex() {
                    return this.i.nextIndex();
                }

                @Override
                public int previousIndex() {
                    return this.i.previousIndex();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void set(E e) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void add(E e) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void forEachRemaining(Consumer<? super E> action) {
                    this.i.forEachRemaining(action);
                }
            };
        }

        @Override
        public List<E> subList(int n, int n2) {
            return new UnmodifiableList(((UnmodifiableList)this).list.subList(n, n2));
        }

        private Object readResolve() {
            return g.convertForInstanceOf((Object)((UnmodifiableList)this).list, RandomAccess.class) instanceof RandomAccess ? new UnmodifiableRandomAccessList(((UnmodifiableList)this).list) : this;
        }

        static /* synthetic */ void _jr$ip$list(Object object, List list) {
            ((UnmodifiableList)object).list = list;
        }

        protected /* synthetic */ UnmodifiableList(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    private static class UnmodifiableMap
    extends com.zeroturnaround.jrebelbase.h
    implements Map,
    Serializable {
        private static final long serialVersionUID = -1034234728574286014L;
        private final Map<? extends K, ? extends V> m;
        private transient Set<K> keySet;
        private transient Set<Map.Entry<K, V>> entrySet;
        private transient Collection<V> values;

        UnmodifiableMap(Map<? extends K, ? extends V> map) {
            this.keySet = null;
            this.entrySet = null;
            this.values = null;
            if (map == null) {
                throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new NullPointerException());
            }
            this.m = map;
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean containsKey(Object object) {
            return this.m.containsKey(object);
        }

        @Override
        public boolean containsValue(Object object) {
            return this.m.containsValue(object);
        }

        @Override
        public V get(Object object) {
            return this.m.get(object);
        }

        @Override
        public V put(K k, V v) {
            throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new UnsupportedOperationException());
        }

        @Override
        public V remove(Object object) {
            throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new UnsupportedOperationException());
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new UnsupportedOperationException());
        }

        @Override
        public void clear() {
            throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new UnsupportedOperationException());
        }

        @Override
        public Set<K> keySet() {
            if (this.keySet == null) {
                this.keySet = Collections.unmodifiableSet(this.m.keySet());
            }
            return this.keySet;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new UnmodifiableEntrySet(this.m.entrySet());
            }
            return this.entrySet;
        }

        @Override
        public Collection<V> values() {
            if (this.values == null) {
                this.values = Collections.unmodifiableCollection(this.m.values());
            }
            return this.values;
        }

        @Override
        public boolean equals(Object object) {
            return !f.ifAcmp((Object)object, (Object)this) || this.m.equals(object);
        }

        @Override
        public int hashCode() {
            return this.m.hashCode();
        }

        public String toString() {
            return this.m.toString();
        }

        private static /* synthetic */ void _jr$ip$m(UnmodifiableMap unmodifiableMap, Map map) {
            unmodifiableMap.m = map;
        }

        protected /* synthetic */ UnmodifiableMap(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }

        static class UnmodifiableEntrySet<K, V>
        extends UnmodifiableSet<Map.Entry<K, V>> {
            private static final long serialVersionUID = 7854390611657943733L;

            UnmodifiableEntrySet(Set<? extends Map.Entry<? extends K, ? extends V>> set) {
                super(set);
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private final Iterator<? extends Map.Entry<? extends K, ? extends V>> i;
                    {
                        this.i = c.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        return new UnmodifiableEntry(this.i.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public void forEachRemaining(Consumer<? super Map.Entry<K, V>> action) {
                        Objects.requireNonNull(action);
                        this.i.forEachRemaining(UnmodifiableEntrySet.entryConsumer(action));
                    }
                };
            }

            @Override
            public Object[] toArray() {
                Object[] objectArray = UnmodifiableEntrySet._jr$ig$c(this).toArray();
                for (int i = 0; i < a.arrayLength((Object[])objectArray); ++i) {
                    a.arrayStore((Object[])objectArray, (int)i, (Object)new UnmodifiableEntry((Map.Entry)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), Map.Entry.class)));
                }
                return objectArray;
            }

            @Override
            public <T> T[] toArray(T[] TArray) {
                Object[] objectArray = UnmodifiableEntrySet._jr$ig$c(this).toArray(a.arrayLength((Object[])TArray) == 0 ? TArray : Arrays.copyOf(TArray, 0));
                for (int i = 0; i < a.arrayLength((Object[])objectArray); ++i) {
                    a.arrayStore((Object[])objectArray, (int)i, (Object)new UnmodifiableEntry((Map.Entry)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), Map.Entry.class)));
                }
                if (a.arrayLength((Object[])objectArray) > a.arrayLength((Object[])TArray)) {
                    return (Object[])g.convertForCast((Object)objectArray, Object[].class);
                }
                a.arraycopy((Object)objectArray, (int)0, TArray, (int)0, (int)a.arrayLength((Object[])objectArray));
                if (a.arrayLength((Object[])TArray) > a.arrayLength((Object[])objectArray)) {
                    a.arrayStore((Object[])TArray, (int)a.arrayLength((Object[])objectArray), null);
                }
                return TArray;
            }

            @Override
            public boolean contains(Object object) {
                if (!(g.convertForInstanceOf((Object)object, Map.Entry.class) instanceof Map.Entry)) {
                    return false;
                }
                return UnmodifiableEntrySet._jr$ig$c(this).contains(new UnmodifiableEntry((Map.Entry)g.convertForCast((Object)object, Map.Entry.class)));
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                for (Object obj : collection) {
                    if (this.contains(obj)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean equals(Object object) {
                if (!f.ifAcmp((Object)object, (Object)this)) {
                    return true;
                }
                if (!(g.convertForInstanceOf((Object)object, Set.class) instanceof Set)) {
                    return false;
                }
                Set set = (Set)g.convertForCast((Object)object, Set.class);
                if (set.size() != UnmodifiableEntrySet._jr$ig$c(this).size()) {
                    return false;
                }
                return this.containsAll(set);
            }

            protected /* synthetic */ UnmodifiableEntrySet(com.zeroturnaround.jrebelbase.h h2) {
                super(h2);
            }

            /*
             * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
             */
            private static class UnmodifiableEntry
            extends com.zeroturnaround.jrebelbase.h
            implements Map.Entry {
                private Map.Entry<? extends K, ? extends V> e;

                UnmodifiableEntry(Map.Entry<? extends K, ? extends V> entry) {
                    this.e = entry;
                }

                @Override
                public K getKey() {
                    return this.e.getKey();
                }

                @Override
                public V getValue() {
                    return this.e.getValue();
                }

                @Override
                public V setValue(V v) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new UnsupportedOperationException());
                }

                @Override
                public int hashCode() {
                    return this.e.hashCode();
                }

                @Override
                public boolean equals(Object object) {
                    if (!f.ifAcmp((Object)this, (Object)object)) {
                        return true;
                    }
                    if (!(g.convertForInstanceOf((Object)object, Map.Entry.class) instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)g.convertForCast((Object)object, Map.Entry.class);
                    return Collections.eq(this.e.getKey(), entry.getKey()) && Collections.eq(this.e.getValue(), entry.getValue());
                }

                public String toString() {
                    return this.e.toString();
                }

                private static /* synthetic */ void _jr$ip$e(UnmodifiableEntry unmodifiableEntry, Map.Entry entry) {
                    unmodifiableEntry.e = entry;
                }

                protected /* synthetic */ UnmodifiableEntry(com.zeroturnaround.jrebelbase.h h2) {
                    super(h2);
                }
            }
        }
    }

    static class UnmodifiableRandomAccessList<E>
    extends UnmodifiableList<E>
    implements RandomAccess {
        private static final long serialVersionUID = -2542308836966382001L;

        UnmodifiableRandomAccessList(List<? extends E> list) {
            super(list);
        }

        @Override
        public List<E> subList(int n, int n2) {
            return new UnmodifiableRandomAccessList(UnmodifiableRandomAccessList._jr$ig$list(this).subList(n, n2));
        }

        private Object writeReplace() {
            return new UnmodifiableList(UnmodifiableRandomAccessList._jr$ig$list(this));
        }

        protected /* synthetic */ UnmodifiableRandomAccessList(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    static class UnmodifiableSet<E>
    extends UnmodifiableCollection<E>
    implements Set<E>,
    Serializable {
        private static final long serialVersionUID = -9215047833775013803L;

        UnmodifiableSet(Set<? extends E> set) {
            super(set);
        }

        @Override
        public boolean equals(Object object) {
            return !f.ifAcmp((Object)object, (Object)this) || UnmodifiableSet._jr$ig$c(this).equals(object);
        }

        @Override
        public int hashCode() {
            return UnmodifiableSet._jr$ig$c(this).hashCode();
        }

        protected /* synthetic */ UnmodifiableSet(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    static class UnmodifiableSortedMap<K, V>
    extends UnmodifiableMap<K, V>
    implements SortedMap<K, V>,
    Serializable {
        private static final long serialVersionUID = -8806743815996713206L;
        private final SortedMap<K, ? extends V> sm;

        UnmodifiableSortedMap(SortedMap<K, ? extends V> sortedMap) {
            super(sortedMap);
            this.sm = sortedMap;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sm.comparator();
        }

        @Override
        public SortedMap<K, V> subMap(K k, K k2) {
            return new UnmodifiableSortedMap(this.sm.subMap(k, k2));
        }

        @Override
        public SortedMap<K, V> headMap(K k) {
            return new UnmodifiableSortedMap(this.sm.headMap(k));
        }

        @Override
        public SortedMap<K, V> tailMap(K k) {
            return new UnmodifiableSortedMap(this.sm.tailMap(k));
        }

        @Override
        public K firstKey() {
            return this.sm.firstKey();
        }

        @Override
        public K lastKey() {
            return this.sm.lastKey();
        }

        private static /* synthetic */ void _jr$ip$sm(UnmodifiableSortedMap unmodifiableSortedMap, SortedMap sortedMap) {
            unmodifiableSortedMap.sm = sortedMap;
        }

        protected /* synthetic */ UnmodifiableSortedMap(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    static class UnmodifiableSortedSet<E>
    extends UnmodifiableSet<E>
    implements SortedSet<E>,
    Serializable {
        private static final long serialVersionUID = -4929149591599911165L;
        private final SortedSet<E> ss;

        UnmodifiableSortedSet(SortedSet<E> sortedSet) {
            super(sortedSet);
            this.ss = sortedSet;
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.ss.comparator();
        }

        @Override
        public SortedSet<E> subSet(E e, E e2) {
            return new UnmodifiableSortedSet<E>(this.ss.subSet(e, e2));
        }

        @Override
        public SortedSet<E> headSet(E e) {
            return new UnmodifiableSortedSet<E>(this.ss.headSet(e));
        }

        @Override
        public SortedSet<E> tailSet(E e) {
            return new UnmodifiableSortedSet<E>(this.ss.tailSet(e));
        }

        @Override
        public E first() {
            return this.ss.first();
        }

        @Override
        public E last() {
            return this.ss.last();
        }

        private static /* synthetic */ void _jr$ip$ss(UnmodifiableSortedSet unmodifiableSortedSet, SortedSet sortedSet) {
            unmodifiableSortedSet.ss = sortedSet;
        }

        protected /* synthetic */ UnmodifiableSortedSet(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }
}

