/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.spi.CurrencyNameProvider;
import sun.util.LocaleServiceProviderPool;
import sun.util.logging.PlatformLogger;
import sun.util.resources.LocaleData;
import sun.util.resources.OpenListResourceBundle;

public final class Currency
extends h
implements Serializable {
    private static final long serialVersionUID = -158308464356906721L;
    private final String currencyCode;
    private final transient int defaultFractionDigits;
    private final transient int numericCode;
    private static HashMap<String, Currency> instances = new HashMap(7);
    private static HashSet<Currency> available;
    static int formatVersion;
    static int dataVersion;
    static int[] mainTable;
    static long[] scCutOverTimes;
    static String[] scOldCurrencies;
    static String[] scNewCurrencies;
    static int[] scOldCurrenciesDFD;
    static int[] scNewCurrenciesDFD;
    static int[] scOldCurrenciesNumericCode;
    static int[] scNewCurrenciesNumericCode;
    static String otherCurrencies;
    static int[] otherCurrenciesDFD;
    static int[] otherCurrenciesNumericCode;
    private static final int MAGIC_NUMBER = 1131770436;
    private static final int A_TO_Z = 26;
    private static final int INVALID_COUNTRY_ENTRY = 127;
    private static final int COUNTRY_WITHOUT_CURRENCY_ENTRY = 128;
    private static final int SIMPLE_CASE_COUNTRY_MASK = 0;
    private static final int SIMPLE_CASE_COUNTRY_FINAL_CHAR_MASK = 31;
    private static final int SIMPLE_CASE_COUNTRY_DEFAULT_DIGITS_MASK = 96;
    private static final int SIMPLE_CASE_COUNTRY_DEFAULT_DIGITS_SHIFT = 5;
    private static final int SPECIAL_CASE_COUNTRY_MASK = 128;
    private static final int SPECIAL_CASE_COUNTRY_INDEX_MASK = 31;
    private static final int SPECIAL_CASE_COUNTRY_INDEX_DELTA = 1;
    private static final int COUNTRY_TYPE_MASK = 128;
    private static final int NUMERIC_CODE_MASK = 261888;
    private static final int NUMERIC_CODE_SHIFT = 8;
    private static final int VALID_FORMAT_VERSION = 1;
    private static final int SYMBOL = 0;
    private static final int DISPLAYNAME = 1;

    private Currency(String string, int n2, int n3) {
        this.currencyCode = string;
        this.defaultFractionDigits = n2;
        this.numericCode = n3;
    }

    public static Currency getInstance(String string) {
        return Currency.getInstance(string, Integer.MIN_VALUE, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Currency getInstance(String string, int n2, int n3) {
        Object object = ah.getMonitor(instances);
        synchronized (object) {
            try {
                Currency currency = instances.get(string);
                if (currency != null) {
                    return currency;
                }
                if (n2 == Integer.MIN_VALUE) {
                    char c;
                    if (string.length() != 3) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
                    }
                    char c2 = string.charAt(0);
                    int n4 = Currency.getMainTableEntry(c2, c = string.charAt(1));
                    if ((n4 & 0x80) == 0 && n4 != 127 && string.charAt(2) - 65 == (n4 & 0x1F)) {
                        n2 = (n4 & 0x60) >> 5;
                        n3 = (n4 & 0x3FF00) >> 8;
                    } else {
                        if (string.charAt(2) == '-') {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
                        }
                        int n5 = otherCurrencies.indexOf(string);
                        if (n5 == -1) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
                        }
                        n2 = otherCurrenciesDFD[n5 / 4];
                        n3 = otherCurrenciesNumericCode[n5 / 4];
                    }
                }
                currency = new Currency(string, n2, n3);
                instances.put(string, currency);
                return currency;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public static Currency getInstance(Locale locale) {
        char c;
        String string = locale.getCountry();
        if (string == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        if (string.length() != 2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
        }
        char c2 = string.charAt(0);
        int n2 = Currency.getMainTableEntry(c2, c = string.charAt(1));
        if ((n2 & 0x80) == 0 && n2 != 127) {
            char c3 = (char)((n2 & 0x1F) + 65);
            int n3 = (n2 & 0x60) >> 5;
            int n4 = (n2 & 0x3FF00) >> 8;
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(c3);
            return Currency.getInstance(stringBuffer.toString(), n3, n4);
        }
        if (n2 == 127) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
        }
        if (n2 == 128) {
            return null;
        }
        int n5 = (n2 & 0x1F) - 1;
        if (scCutOverTimes[n5] == Long.MAX_VALUE || System.currentTimeMillis() < scCutOverTimes[n5]) {
            return Currency.getInstance(scOldCurrencies[n5], scOldCurrenciesDFD[n5], scOldCurrenciesNumericCode[n5]);
        }
        return Currency.getInstance(scNewCurrencies[n5], scNewCurrenciesDFD[n5], scNewCurrenciesNumericCode[n5]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Currency> getAvailableCurrencies() {
        Object object = ah.getMonitor(Currency.class);
        synchronized (object) {
            try {
                if (available == null) {
                    available = new HashSet(256);
                    for (char c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
                        for (char c2 = 'A'; c2 <= 'Z'; c2 = (char)(c2 + '\u0001')) {
                            int n2 = Currency.getMainTableEntry(c, c2);
                            if ((n2 & 0x80) != 0 || n2 == 127) continue;
                            char c3 = (char)((n2 & 0x1F) + 65);
                            int n3 = (n2 & 0x60) >> 5;
                            int n4 = (n2 & 0x3FF00) >> 8;
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append(c);
                            stringBuilder.append(c2);
                            stringBuilder.append(c3);
                            available.add(Currency.getInstance(stringBuilder.toString(), n3, n4));
                        }
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(otherCurrencies, "-");
                    while (stringTokenizer.hasMoreElements()) {
                        available.add(Currency.getInstance((String)stringTokenizer.nextElement()));
                    }
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        object = (Set)g.convertForCast((Object)available.clone(), Set.class);
        return object;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public String getSymbol() {
        return this.getSymbol(Locale.getDefault(Locale.Category.DISPLAY));
    }

    public String getSymbol(Locale locale) {
        try {
            Object object;
            LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(CurrencyNameProvider.class);
            if (localeServiceProviderPool.hasProviders()) {
                CurrencyNameGetter currencyNameGetter = CurrencyNameGetter.INSTANCE;
                OpenListResourceBundle openListResourceBundle = (OpenListResourceBundle)((Object)g.convertForCast(null, OpenListResourceBundle.class));
                Object[] objectArray = new Object[1];
                a.arrayStore((Object[])objectArray, (int)0, (Object)0);
                object = (String)localeServiceProviderPool.getLocalizedObject(currencyNameGetter, locale, openListResourceBundle, this.currencyCode, objectArray);
                if (object != null) {
                    return object;
                }
            }
            object = LocaleData.getCurrencyNames(locale);
            return object.getString(this.currencyCode);
        }
        catch (MissingResourceException missingResourceException) {
            return this.currencyCode;
        }
    }

    public int getDefaultFractionDigits() {
        return this.defaultFractionDigits;
    }

    public int getNumericCode() {
        return this.numericCode;
    }

    public String getDisplayName() {
        return this.getDisplayName(Locale.getDefault(Locale.Category.DISPLAY));
    }

    public String getDisplayName(Locale locale) {
        try {
            OpenListResourceBundle openListResourceBundle = LocaleData.getCurrencyNames(locale);
            String string = null;
            String string2 = this.currencyCode.toLowerCase(Locale.ROOT);
            LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(CurrencyNameProvider.class);
            if (localeServiceProviderPool.hasProviders()) {
                CurrencyNameGetter currencyNameGetter = CurrencyNameGetter.INSTANCE;
                Object[] objectArray = new Object[1];
                a.arrayStore((Object[])objectArray, (int)0, (Object)1);
                string = (String)localeServiceProviderPool.getLocalizedObject(currencyNameGetter, locale, string2, openListResourceBundle, this.currencyCode, objectArray);
            }
            if (string == null) {
                string = openListResourceBundle.getString(string2);
            }
            if (string != null) {
                return string;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return this.currencyCode;
    }

    public String toString() {
        return this.currencyCode;
    }

    private Object readResolve() {
        return Currency.getInstance(this.currencyCode);
    }

    private static int getMainTableEntry(char c, char c2) {
        if (c < 'A' || c > 'Z' || c2 < 'A' || c2 > 'Z') {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
        }
        return mainTable[(c - 65) * 26 + (c2 - 65)];
    }

    private static void setMainTableEntry(char c, char c2, int n2) {
        if (c < 'A' || c > 'Z' || c2 < 'A' || c2 > 'Z') {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
        }
        Currency.mainTable[(c - 65) * 26 + (c2 - 65)] = n2;
    }

    private static int[] readIntArray(DataInputStream dataInputStream, int n2) throws IOException {
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = dataInputStream.readInt();
        }
        return nArray;
    }

    private static long[] readLongArray(DataInputStream dataInputStream, int n2) throws IOException {
        long[] lArray = new long[n2];
        for (int i = 0; i < n2; ++i) {
            lArray[i] = dataInputStream.readLong();
        }
        return lArray;
    }

    private static String[] readStringArray(DataInputStream dataInputStream, int n2) throws IOException {
        String[] stringArray = new String[n2];
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = dataInputStream.readUTF();
        }
        return stringArray;
    }

    private static void replaceCurrencyData(Pattern pattern, String string, String string2) {
        int n2;
        if (string.length() != 2) {
            String string3 = "The entry in currency.properties for " + string + " is ignored because of the invalid country code.";
            Currency.info(string3, null);
            return;
        }
        Matcher matcher = pattern.matcher(string2);
        if (!matcher.find()) {
            String string4 = "The entry in currency.properties for " + string + " is ignored because the value format is not recognized.";
            Currency.info(string4, null);
            return;
        }
        String string5 = matcher.group(1);
        int n3 = Integer.parseInt(matcher.group(2));
        int n4 = Integer.parseInt(matcher.group(3));
        int n5 = n3 << 8;
        for (n2 = 0; n2 < scOldCurrencies.length && !scOldCurrencies[n2].equals(string5); ++n2) {
        }
        n5 = n2 == scOldCurrencies.length ? (n5 |= n4 << 5 | string5.charAt(2) - 65) : (n5 |= 0x80 | n2 + 1);
        Currency.setMainTableEntry(string.charAt(0), string.charAt(1), n5);
    }

    private static void info(String string, Throwable throwable) {
        PlatformLogger platformLogger = PlatformLogger.getLogger("java.util.Currency");
        if (platformLogger.isLoggable(800)) {
            if (throwable != null) {
                platformLogger.info(string, throwable);
            } else {
                platformLogger.info(string);
            }
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Object run() {
                h h2;
                Object object;
                String string = System.getProperty("java.home");
                try {
                    object = string + File.separator + "lib" + File.separator + "currency.data";
                    h2 = new DataInputStream(new BufferedInputStream(new FileInputStream((String)object)));
                    if (h2.readInt() != 1131770436) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError("Currency data is possibly corrupted"));
                    }
                    formatVersion = h2.readInt();
                    if (formatVersion != 1) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError("Currency data format is incorrect"));
                    }
                    dataVersion = h2.readInt();
                    mainTable = Currency.readIntArray((DataInputStream)h2, 676);
                    int n2 = h2.readInt();
                    scCutOverTimes = Currency.readLongArray((DataInputStream)h2, n2);
                    scOldCurrencies = Currency.readStringArray((DataInputStream)h2, n2);
                    scNewCurrencies = Currency.readStringArray((DataInputStream)h2, n2);
                    scOldCurrenciesDFD = Currency.readIntArray((DataInputStream)h2, n2);
                    scNewCurrenciesDFD = Currency.readIntArray((DataInputStream)h2, n2);
                    scOldCurrenciesNumericCode = Currency.readIntArray((DataInputStream)h2, n2);
                    scNewCurrenciesNumericCode = Currency.readIntArray((DataInputStream)h2, n2);
                    int n3 = h2.readInt();
                    otherCurrencies = h2.readUTF();
                    otherCurrenciesDFD = Currency.readIntArray((DataInputStream)h2, n3);
                    otherCurrenciesNumericCode = Currency.readIntArray((DataInputStream)h2, n3);
                    h2.close();
                }
                catch (IOException iOException) {
                    InternalError internalError = new InternalError();
                    internalError.initCause(iOException);
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)internalError);
                }
                try {
                    h h3;
                    Object object2;
                    block16: {
                        block17: {
                            object = new File(string + File.separator + "lib" + File.separator + "currency.properties");
                            if (!((File)object).exists()) return null;
                            h2 = new Properties();
                            object2 = new FileReader((File)object);
                            h3 = null;
                            try {
                                h2.load((Reader)object2);
                                if (object2 == null) break block16;
                                if (h3 == null) break block17;
                            }
                            catch (Throwable throwable) {
                                try {
                                    h3 = throwable;
                                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                                }
                                catch (Throwable throwable2) {
                                    if (object2 == null) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable2);
                                    if (h3 == null) {
                                        ((InputStreamReader)object2).close();
                                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable2);
                                    }
                                    try {
                                        ((InputStreamReader)object2).close();
                                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable2);
                                    }
                                    catch (Throwable throwable3) {
                                        h3.addSuppressed(throwable3);
                                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable2);
                                    }
                                }
                            }
                            try {
                                ((InputStreamReader)object2).close();
                            }
                            catch (Throwable throwable) {
                                h3.addSuppressed(throwable);
                            }
                            break block16;
                        }
                        ((InputStreamReader)object2).close();
                    }
                    object2 = h2.stringPropertyNames();
                    h3 = Pattern.compile("([A-Z]{3})\\s*,\\s*(\\d{3})\\s*,\\s*([0-3])");
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        Currency.replaceCurrencyData((Pattern)h3, string2.toUpperCase(Locale.ROOT), h2.getProperty(string2).toUpperCase(Locale.ROOT));
                    }
                    return null;
                }
                catch (IOException iOException) {
                    Currency.info("currency.properties is ignored because of an IOException", iOException);
                }
                return null;
            }
        });
    }

    private static /* synthetic */ String _jr$ig$currencyCode(Currency currency) {
        return currency.currencyCode;
    }

    private static /* synthetic */ void _jr$ip$currencyCode(Currency currency, String string) {
        currency.currencyCode = string;
    }

    private static /* synthetic */ int _jr$ig$defaultFractionDigits(Currency currency) {
        return currency.defaultFractionDigits;
    }

    private static /* synthetic */ void _jr$ip$defaultFractionDigits(Currency currency, int n2) {
        currency.defaultFractionDigits = n2;
    }

    private static /* synthetic */ int _jr$ig$numericCode(Currency currency) {
        return currency.numericCode;
    }

    private static /* synthetic */ void _jr$ip$numericCode(Currency currency, int n2) {
        currency.numericCode = n2;
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    private static class CurrencyNameGetter
    extends h
    implements LocaleServiceProviderPool.LocalizedObjectGetter {
        private static final CurrencyNameGetter INSTANCE = new CurrencyNameGetter();

        private CurrencyNameGetter() {
        }

        public String getObject(CurrencyNameProvider currencyNameProvider, Locale locale, String string, Object ... objectArray) {
            if (!$assertionsDisabled && a.arrayLength((Object[])objectArray) != 1) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            int n2 = (Integer)a.arrayLoad((Object[])objectArray, (int)0);
            switch (n2) {
                case 0: {
                    return currencyNameProvider.getSymbol(string, locale);
                }
                case 1: {
                    return currencyNameProvider.getDisplayName(string, locale);
                }
            }
            if (!$assertionsDisabled) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            return null;
        }

        protected /* synthetic */ CurrencyNameGetter(h h2) {
            super(h2);
        }
    }
}

