/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.facade.x;
import com.zeroturnaround.jrebelbase.h;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.JumboEnumSet;
import java.util.RegularEnumSet;
import sun.misc.SharedSecrets;

public abstract class EnumSet<E extends Enum<E>>
extends AbstractSet<E>
implements Cloneable,
Serializable {
    final Class<E> elementType;
    final Enum[] universe;
    private static Enum[] ZERO_LENGTH_ENUM_ARRAY = new Enum[0];

    EnumSet(Class<E> clazz, Enum[] enumArray) {
        this.elementType = clazz;
        this.universe = enumArray;
    }

    public static <E extends Enum<E>> EnumSet<E> noneOf(Class<E> clazz) {
        Object[] objectArray = EnumSet.getUniverse(clazz);
        if (objectArray == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ClassCastException(clazz + " not an enum"));
        }
        if (a.arrayLength((Object[])objectArray) <= 64) {
            return new RegularEnumSet<E>(clazz, (Enum<?>[])objectArray);
        }
        return new JumboEnumSet<E>(clazz, (Enum[])objectArray);
    }

    public static <E extends Enum<E>> EnumSet<E> allOf(Class<E> clazz) {
        EnumSet<E> enumSet = EnumSet.noneOf(clazz);
        enumSet.addAll();
        return enumSet;
    }

    abstract void addAll();

    public static <E extends Enum<E>> EnumSet<E> copyOf(EnumSet<E> enumSet) {
        return enumSet.clone();
    }

    public static <E extends Enum<E>> EnumSet<E> copyOf(Collection<E> collection) {
        if (g.convertForInstanceOf(collection, EnumSet.class) instanceof EnumSet) {
            return ((EnumSet)g.convertForCast(collection, EnumSet.class)).clone();
        }
        if (collection.isEmpty()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Collection is empty"));
        }
        Iterator<E> iterator = collection.iterator();
        Enum enum_ = (Enum)iterator.next();
        EnumSet<Enum> enumSet = EnumSet.of(enum_);
        while (iterator.hasNext()) {
            enumSet.add((Enum)iterator.next());
        }
        return enumSet;
    }

    public static <E extends Enum<E>> EnumSet<E> complementOf(EnumSet<E> enumSet) {
        EnumSet<E> enumSet2 = EnumSet.copyOf(enumSet);
        enumSet2.complement();
        return enumSet2;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e2) {
        EnumSet enumSet = EnumSet.noneOf(((Enum)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion(e2)).getDeclaringClass());
        enumSet.add(e2);
        return enumSet;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e2, E e3) {
        EnumSet enumSet = EnumSet.noneOf(((Enum)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion(e2)).getDeclaringClass());
        enumSet.add(e2);
        enumSet.add(e3);
        return enumSet;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e2, E e3, E e4) {
        EnumSet enumSet = EnumSet.noneOf(((Enum)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion(e2)).getDeclaringClass());
        enumSet.add(e2);
        enumSet.add(e3);
        enumSet.add(e4);
        return enumSet;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e2, E e3, E e4, E e5) {
        EnumSet enumSet = EnumSet.noneOf(((Enum)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion(e2)).getDeclaringClass());
        enumSet.add(e2);
        enumSet.add(e3);
        enumSet.add(e4);
        enumSet.add(e5);
        return enumSet;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e2, E e3, E e4, E e5, E e6) {
        EnumSet enumSet = EnumSet.noneOf(((Enum)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion(e2)).getDeclaringClass());
        enumSet.add(e2);
        enumSet.add(e3);
        enumSet.add(e4);
        enumSet.add(e5);
        enumSet.add(e6);
        return enumSet;
    }

    @SafeVarargs
    public static <E extends Enum<E>> EnumSet<E> of(E e2, E ... EArray) {
        EnumSet enumSet = EnumSet.noneOf(((Enum)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion(e2)).getDeclaringClass());
        enumSet.add(e2);
        Object[] objectArray = EArray;
        int n2 = a.arrayLength((Object[])objectArray);
        for (int i = 0; i < n2; ++i) {
            Enum enum_ = (Enum)a.arrayLoad((Object[])objectArray, (int)i);
            enumSet.add(enum_);
        }
        return enumSet;
    }

    public static <E extends Enum<E>> EnumSet<E> range(E e2, E e3) {
        if (e2.compareTo(e3) > 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException(e2 + " > " + e3));
        }
        EnumSet<E> enumSet = EnumSet.noneOf(((Enum)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion(e2)).getDeclaringClass());
        enumSet.addRange(e2, e3);
        return enumSet;
    }

    abstract void addRange(E var1, E var2);

    public EnumSet<E> clone() {
        try {
            return (EnumSet)g.convertForCast((Object)super.clone(), EnumSet.class);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError((Object)cloneNotSupportedException));
        }
    }

    abstract void complement();

    final void typeCheck(E e2) {
        Class<?> clazz = e2.getClass();
        if (f.ifAcmp(clazz, (Object)((EnumSet)this).elementType) && f.ifAcmp((Object)x.getSuperclass(clazz), (Object)((EnumSet)this).elementType)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ClassCastException(clazz + " != " + ((EnumSet)this).elementType));
        }
    }

    private static <E extends Enum<E>> E[] getUniverse(Class<E> clazz) {
        return SharedSecrets.getJavaLangAccess().getEnumConstantsShared(clazz);
    }

    Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidObjectException("Proxy required"));
    }

    static /* synthetic */ void _jr$ip$elementType(Object object, Class clazz) {
        ((EnumSet)object).elementType = clazz;
    }

    static /* synthetic */ Enum[] _jr$ig$universe(Object object) {
        return ((EnumSet)object).universe;
    }

    static /* synthetic */ void _jr$ip$universe(Object object, Enum[] enumArray) {
        ((EnumSet)object).universe = enumArray;
    }

    protected /* synthetic */ EnumSet(h h2) {
        super(h2);
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    private static class SerializationProxy
    extends h
    implements Serializable {
        private final Class<E> elementType;
        private final Enum[] elements;
        private static final long serialVersionUID = 362491234563181265L;

        SerializationProxy(EnumSet<E> enumSet) {
            this.elementType = ((EnumSet)enumSet).elementType;
            this.elements = (Enum[])g.convertForCast((Object)enumSet.toArray(ZERO_LENGTH_ENUM_ARRAY), Enum[].class);
        }

        private Object readResolve() {
            EnumSet enumSet = EnumSet.noneOf(this.elementType);
            Object[] objectArray = this.elements;
            int n2 = a.arrayLength((Object[])objectArray);
            for (int i = 0; i < n2; ++i) {
                Enum enum_ = (Enum)a.arrayLoad((Object[])objectArray, (int)i);
                enumSet.add(enum_);
            }
            return enumSet;
        }

        private static /* synthetic */ void _jr$ip$elementType(SerializationProxy serializationProxy, Class clazz) {
            serializationProxy.elementType = clazz;
        }

        private static /* synthetic */ void _jr$ip$elements(SerializationProxy serializationProxy, Enum[] enumArray) {
            serializationProxy.elements = enumArray;
        }

        protected /* synthetic */ SerializationProxy(h h2) {
            super(h2);
        }
    }
}

