/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.DuplicateFormatFlagsException;
import java.util.FormatFlagsConversionMismatchException;
import java.util.Formattable;
import java.util.FormatterClosedException;
import java.util.IllegalFormatCodePointException;
import java.util.IllegalFormatConversionException;
import java.util.IllegalFormatFlagsException;
import java.util.IllegalFormatPrecisionException;
import java.util.IllegalFormatWidthException;
import java.util.Locale;
import java.util.MissingFormatArgumentException;
import java.util.MissingFormatWidthException;
import java.util.Objects;
import java.util.TimeZone;
import java.util.UnknownFormatConversionException;
import java.util.UnknownFormatFlagsException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.misc.FormattedFloatingDecimal;
import sun.misc.FpUtils;

public final class Formatter
extends h
implements Closeable,
Flushable {
    private Appendable a;
    private final Locale l;
    private IOException lastException;
    private final char zero;
    private static double scaleUp;
    private static final int MAX_FD_CHARS = 30;
    private static final String formatSpecifier = "%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])";
    private static Pattern fsPattern;

    private static Charset toCharset(String string) throws UnsupportedEncodingException {
        Objects.requireNonNull(string, "charsetName");
        try {
            return Charset.forName(string);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedEncodingException(string));
        }
    }

    private static final Appendable nonNullAppendable(Appendable appendable) {
        if (appendable == null) {
            return new StringBuilder();
        }
        return appendable;
    }

    private Formatter(Locale locale, Appendable appendable) {
        this.a = appendable;
        this.l = locale;
        this.zero = Formatter.getZero(locale);
    }

    private Formatter(Charset charset, Locale locale, File file) throws FileNotFoundException {
        this(locale, new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset)));
    }

    public Formatter() {
        this(Locale.getDefault(Locale.Category.FORMAT), new StringBuilder());
    }

    public Formatter(Appendable appendable) {
        this(Locale.getDefault(Locale.Category.FORMAT), Formatter.nonNullAppendable(appendable));
    }

    public Formatter(Locale locale) {
        this(locale, new StringBuilder());
    }

    public Formatter(Appendable appendable, Locale locale) {
        this(locale, Formatter.nonNullAppendable(appendable));
    }

    public Formatter(String string) throws FileNotFoundException {
        this(Locale.getDefault(Locale.Category.FORMAT), new BufferedWriter(new OutputStreamWriter(new FileOutputStream(string))));
    }

    public Formatter(String string, String string2) throws FileNotFoundException, UnsupportedEncodingException {
        this(string, string2, Locale.getDefault(Locale.Category.FORMAT));
    }

    public Formatter(String string, String string2, Locale locale) throws FileNotFoundException, UnsupportedEncodingException {
        this(Formatter.toCharset(string2), locale, new File(string));
    }

    public Formatter(File file) throws FileNotFoundException {
        this(Locale.getDefault(Locale.Category.FORMAT), new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file))));
    }

    public Formatter(File file, String string) throws FileNotFoundException, UnsupportedEncodingException {
        this(file, string, Locale.getDefault(Locale.Category.FORMAT));
    }

    public Formatter(File file, String string, Locale locale) throws FileNotFoundException, UnsupportedEncodingException {
        this(Formatter.toCharset(string), locale, file);
    }

    public Formatter(PrintStream printStream) {
        this(Locale.getDefault(Locale.Category.FORMAT), (Appendable)g.convertForCast((Object)Objects.requireNonNull(printStream), Appendable.class));
    }

    public Formatter(OutputStream outputStream) {
        this(Locale.getDefault(Locale.Category.FORMAT), new BufferedWriter(new OutputStreamWriter(outputStream)));
    }

    public Formatter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        this(outputStream, string, Locale.getDefault(Locale.Category.FORMAT));
    }

    public Formatter(OutputStream outputStream, String string, Locale locale) throws UnsupportedEncodingException {
        this(locale, new BufferedWriter(new OutputStreamWriter(outputStream, string)));
    }

    private static char getZero(Locale locale) {
        if (locale != null && !locale.equals(Locale.US)) {
            DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance(locale);
            return decimalFormatSymbols.getZeroDigit();
        }
        return '0';
    }

    public Locale locale() {
        this.ensureOpen();
        return this.l;
    }

    public Appendable out() {
        this.ensureOpen();
        return this.a;
    }

    public String toString() {
        this.ensureOpen();
        return this.a.toString();
    }

    @Override
    public void flush() {
        this.ensureOpen();
        if (g.convertForInstanceOf((Object)this.a, Flushable.class) instanceof Flushable) {
            try {
                ((Flushable)g.convertForCast((Object)this.a, Flushable.class)).flush();
            }
            catch (IOException iOException) {
                this.lastException = iOException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.a == null) {
            return;
        }
        try {
            if (g.convertForInstanceOf((Object)this.a, Closeable.class) instanceof Closeable) {
                ((Closeable)g.convertForCast((Object)this.a, Closeable.class)).close();
            }
            this.a = null;
        }
        catch (IOException iOException) {
            try {
                this.lastException = iOException;
                this.a = null;
            }
            catch (Throwable throwable) {
                this.a = null;
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    private void ensureOpen() {
        if (this.a == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new FormatterClosedException());
        }
    }

    public IOException ioException() {
        return this.lastException;
    }

    public Formatter format(String string, Object ... objectArray) {
        return this.format(this.l, string, objectArray);
    }

    public Formatter format(Locale locale, String string, Object ... objectArray) {
        this.ensureOpen();
        int n2 = -1;
        int n3 = -1;
        Object[] objectArray2 = this.parse(string);
        for (int i = 0; i < com.zeroturnaround.jrebelbase.facade.a.arrayLength((Object[])objectArray2); ++i) {
            FormatString formatString = (FormatString)g.convertForCast((Object)com.zeroturnaround.jrebelbase.facade.a.arrayLoad((Object[])objectArray2, (int)i), FormatString.class);
            int n4 = formatString.index();
            try {
                switch (n4) {
                    case -2: {
                        formatString.print(null, locale);
                        break;
                    }
                    case -1: {
                        if (n2 < 0 || objectArray != null && n2 > com.zeroturnaround.jrebelbase.facade.a.arrayLength((Object[])objectArray) - 1) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new MissingFormatArgumentException(formatString.toString()));
                        }
                        formatString.print(objectArray == null ? null : com.zeroturnaround.jrebelbase.facade.a.arrayLoad((Object[])objectArray, (int)n2), locale);
                        break;
                    }
                    case 0: {
                        n2 = ++n3;
                        if (objectArray != null && n3 > com.zeroturnaround.jrebelbase.facade.a.arrayLength((Object[])objectArray) - 1) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new MissingFormatArgumentException(formatString.toString()));
                        }
                        formatString.print(objectArray == null ? null : com.zeroturnaround.jrebelbase.facade.a.arrayLoad((Object[])objectArray, (int)n3), locale);
                        break;
                    }
                    default: {
                        n2 = n4 - 1;
                        if (objectArray != null && n2 > com.zeroturnaround.jrebelbase.facade.a.arrayLength((Object[])objectArray) - 1) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new MissingFormatArgumentException(formatString.toString()));
                        }
                        formatString.print(objectArray == null ? null : com.zeroturnaround.jrebelbase.facade.a.arrayLoad((Object[])objectArray, (int)n2), locale);
                        break;
                    }
                }
                continue;
            }
            catch (IOException iOException) {
                this.lastException = iOException;
            }
        }
        return this;
    }

    private FormatString[] parse(String string) {
        ArrayList<h> arrayList = new ArrayList<h>();
        Matcher matcher = fsPattern.matcher(string);
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            if (matcher.find(n2)) {
                if (matcher.start() != n2) {
                    Formatter.checkText(string, n2, matcher.start());
                    arrayList.add(new FixedString(this, string.substring(n2, matcher.start())));
                }
                arrayList.add(new FormatSpecifier(this, matcher));
                n2 = matcher.end();
                continue;
            }
            Formatter.checkText(string, n2, n3);
            arrayList.add(new FixedString(this, string.substring(n2)));
            break;
        }
        return (FormatString[])g.convertForCast((Object)arrayList.toArray(new FormatString[arrayList.size()]), FormatString[].class);
    }

    private static void checkText(String string, int n2, int n3) {
        for (int i = n2; i < n3; ++i) {
            if (string.charAt(i) != '%') continue;
            char c2 = i == n3 - 1 ? (char)'%' : (char)string.charAt(i + 1);
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnknownFormatConversionException(String.valueOf(c2)));
        }
    }

    static {
        fsPattern = Pattern.compile(formatSpecifier);
    }

    private static /* synthetic */ Appendable _jr$ig$a(Formatter formatter) {
        return formatter.a;
    }

    private static /* synthetic */ void _jr$ip$a(Formatter formatter, Appendable appendable) {
        formatter.a = appendable;
    }

    private static /* synthetic */ Locale _jr$ig$l(Formatter formatter) {
        return formatter.l;
    }

    private static /* synthetic */ void _jr$ip$l(Formatter formatter, Locale locale) {
        formatter.l = locale;
    }

    private static /* synthetic */ IOException _jr$ig$lastException(Formatter formatter) {
        return formatter.lastException;
    }

    private static /* synthetic */ void _jr$ip$lastException(Formatter formatter, IOException iOException) {
        formatter.lastException = iOException;
    }

    private static /* synthetic */ char _jr$ig$zero(Formatter formatter) {
        return formatter.zero;
    }

    private static /* synthetic */ void _jr$ip$zero(Formatter formatter, char c2) {
        formatter.zero = c2;
    }

    public static enum BigDecimalLayoutForm {
        SCIENTIFIC,
        DECIMAL_FLOAT;

    }

    private static class Conversion
    extends h {
        static final char DECIMAL_INTEGER = 'd';
        static final char OCTAL_INTEGER = 'o';
        static final char HEXADECIMAL_INTEGER = 'x';
        static final char HEXADECIMAL_INTEGER_UPPER = 'X';
        static final char SCIENTIFIC = 'e';
        static final char SCIENTIFIC_UPPER = 'E';
        static final char GENERAL = 'g';
        static final char GENERAL_UPPER = 'G';
        static final char DECIMAL_FLOAT = 'f';
        static final char HEXADECIMAL_FLOAT = 'a';
        static final char HEXADECIMAL_FLOAT_UPPER = 'A';
        static final char CHARACTER = 'c';
        static final char CHARACTER_UPPER = 'C';
        static final char DATE_TIME = 't';
        static final char DATE_TIME_UPPER = 'T';
        static final char BOOLEAN = 'b';
        static final char BOOLEAN_UPPER = 'B';
        static final char STRING = 's';
        static final char STRING_UPPER = 'S';
        static final char HASHCODE = 'h';
        static final char HASHCODE_UPPER = 'H';
        static final char LINE_SEPARATOR = 'n';
        static final char PERCENT_SIGN = '%';

        private Conversion() {
        }

        static boolean isValid(char c2) {
            return Conversion.isGeneral(c2) || Conversion.isInteger(c2) || Conversion.isFloat(c2) || Conversion.isText(c2) || c2 == 't' || Conversion.isCharacter(c2);
        }

        static boolean isGeneral(char c2) {
            switch (c2) {
                case 'B': 
                case 'H': 
                case 'S': 
                case 'b': 
                case 'h': 
                case 's': {
                    return true;
                }
            }
            return false;
        }

        static boolean isCharacter(char c2) {
            switch (c2) {
                case 'C': 
                case 'c': {
                    return true;
                }
            }
            return false;
        }

        static boolean isInteger(char c2) {
            switch (c2) {
                case 'X': 
                case 'd': 
                case 'o': 
                case 'x': {
                    return true;
                }
            }
            return false;
        }

        static boolean isFloat(char c2) {
            switch (c2) {
                case 'A': 
                case 'E': 
                case 'G': 
                case 'a': 
                case 'e': 
                case 'f': 
                case 'g': {
                    return true;
                }
            }
            return false;
        }

        static boolean isText(char c2) {
            switch (c2) {
                case '%': 
                case 'n': {
                    return true;
                }
            }
            return false;
        }

        protected /* synthetic */ Conversion(h h2) {
            super(h2);
        }
    }

    private static class DateTime
    extends h {
        static final char HOUR_OF_DAY_0 = 'H';
        static final char HOUR_0 = 'I';
        static final char HOUR_OF_DAY = 'k';
        static final char HOUR = 'l';
        static final char MINUTE = 'M';
        static final char NANOSECOND = 'N';
        static final char MILLISECOND = 'L';
        static final char MILLISECOND_SINCE_EPOCH = 'Q';
        static final char AM_PM = 'p';
        static final char SECONDS_SINCE_EPOCH = 's';
        static final char SECOND = 'S';
        static final char TIME = 'T';
        static final char ZONE_NUMERIC = 'z';
        static final char ZONE = 'Z';
        static final char NAME_OF_DAY_ABBREV = 'a';
        static final char NAME_OF_DAY = 'A';
        static final char NAME_OF_MONTH_ABBREV = 'b';
        static final char NAME_OF_MONTH = 'B';
        static final char CENTURY = 'C';
        static final char DAY_OF_MONTH_0 = 'd';
        static final char DAY_OF_MONTH = 'e';
        static final char NAME_OF_MONTH_ABBREV_X = 'h';
        static final char DAY_OF_YEAR = 'j';
        static final char MONTH = 'm';
        static final char YEAR_2 = 'y';
        static final char YEAR_4 = 'Y';
        static final char TIME_12_HOUR = 'r';
        static final char TIME_24_HOUR = 'R';
        static final char DATE_TIME = 'c';
        static final char DATE = 'D';
        static final char ISO_STANDARD_DATE = 'F';

        private DateTime() {
        }

        static boolean isValid(char c2) {
            switch (c2) {
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'H': 
                case 'I': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'Y': 
                case 'Z': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'h': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'p': 
                case 'r': 
                case 's': 
                case 'y': 
                case 'z': {
                    return true;
                }
            }
            return false;
        }

        protected /* synthetic */ DateTime(h h2) {
            super(h2);
        }
    }

    private class FixedString
    extends h
    implements FormatString {
        private String s;
        final /* synthetic */ Formatter this$0;

        FixedString(Formatter formatter, String string) {
            this.this$0 = formatter;
            this.s = string;
        }

        @Override
        public int index() {
            return -2;
        }

        public void print(Object object, Locale locale) throws IOException {
            ((FixedString)this).this$0.a.append(this.s);
        }

        @Override
        public String toString() {
            return this.s;
        }

        private static /* synthetic */ void _jr$ip$s(FixedString fixedString, String string) {
            fixedString.s = string;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, Formatter formatter) {
            ((FixedString)object).this$0 = formatter;
        }

        protected /* synthetic */ FixedString(h h2) {
            super(h2);
        }
    }

    private static class Flags
    extends h {
        private int flags;
        static final Flags NONE = new Flags(0);
        static final Flags LEFT_JUSTIFY = new Flags(1);
        static final Flags UPPERCASE = new Flags(2);
        static final Flags ALTERNATE = new Flags(4);
        static final Flags PLUS = new Flags(8);
        static final Flags LEADING_SPACE = new Flags(16);
        static final Flags ZERO_PAD = new Flags(32);
        static final Flags GROUP = new Flags(64);
        static final Flags PARENTHESES = new Flags(128);
        static final Flags PREVIOUS = new Flags(256);

        private Flags(int n2) {
            this.flags = n2;
        }

        public int valueOf() {
            return this.flags;
        }

        public boolean contains(Flags flags) {
            return (this.flags & flags.valueOf()) == flags.valueOf();
        }

        public Flags dup() {
            return new Flags(this.flags);
        }

        private Flags add(Flags flags) {
            Flags flags2 = this;
            flags2.flags = flags2.flags | flags.valueOf();
            return this;
        }

        public Flags remove(Flags flags) {
            Flags flags2 = this;
            flags2.flags = flags2.flags & ~flags.valueOf();
            return this;
        }

        public static Flags parse(String string) {
            char[] cArray = string.toCharArray();
            Flags flags = new Flags(0);
            for (int i = 0; i < cArray.length; ++i) {
                Flags flags2 = Flags.parse(cArray[i]);
                if (flags.contains(flags2)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new DuplicateFormatFlagsException(flags2.toString()));
                }
                flags.add(flags2);
            }
            return flags;
        }

        private static Flags parse(char c2) {
            switch (c2) {
                case '-': {
                    return LEFT_JUSTIFY;
                }
                case '#': {
                    return ALTERNATE;
                }
                case '+': {
                    return PLUS;
                }
                case ' ': {
                    return LEADING_SPACE;
                }
                case '0': {
                    return ZERO_PAD;
                }
                case ',': {
                    return GROUP;
                }
                case '(': {
                    return PARENTHESES;
                }
                case '<': {
                    return PREVIOUS;
                }
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnknownFormatFlagsException(String.valueOf(c2)));
        }

        public static String toString(Flags flags) {
            return flags.toString();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.contains(LEFT_JUSTIFY)) {
                stringBuilder.append('-');
            }
            if (this.contains(UPPERCASE)) {
                stringBuilder.append('^');
            }
            if (this.contains(ALTERNATE)) {
                stringBuilder.append('#');
            }
            if (this.contains(PLUS)) {
                stringBuilder.append('+');
            }
            if (this.contains(LEADING_SPACE)) {
                stringBuilder.append(' ');
            }
            if (this.contains(ZERO_PAD)) {
                stringBuilder.append('0');
            }
            if (this.contains(GROUP)) {
                stringBuilder.append(',');
            }
            if (this.contains(PARENTHESES)) {
                stringBuilder.append('(');
            }
            if (this.contains(PREVIOUS)) {
                stringBuilder.append('<');
            }
            return stringBuilder.toString();
        }

        protected /* synthetic */ Flags(h h2) {
            super(h2);
        }
    }

    private class FormatSpecifier
    extends h
    implements FormatString {
        private int index;
        private Flags f;
        private int width;
        private int precision;
        private boolean dt;
        private char c;
        final /* synthetic */ Formatter this$0;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int index(String string) {
            if (string != null) {
                try {
                    this.index = Integer.parseInt(string.substring(0, string.length() - 1));
                    return this.index;
                }
                catch (NumberFormatException numberFormatException) {
                    if ($assertionsDisabled) return this.index;
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
            } else {
                this.index = 0;
            }
            return this.index;
        }

        @Override
        public int index() {
            return this.index;
        }

        private Flags flags(String string) {
            this.f = Flags.parse(string);
            if (this.f.contains(Flags.PREVIOUS)) {
                this.index = -1;
            }
            return this.f;
        }

        Flags flags() {
            return this.f;
        }

        private int width(String string) {
            block4: {
                this.width = -1;
                if (string != null) {
                    try {
                        this.width = Integer.parseInt(string);
                        if (this.width < 0) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalFormatWidthException(this.width));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if ($assertionsDisabled) break block4;
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                    }
                }
            }
            return this.width;
        }

        int width() {
            return this.width;
        }

        private int precision(String string) {
            block4: {
                this.precision = -1;
                if (string != null) {
                    try {
                        this.precision = Integer.parseInt(string.substring(1));
                        if (this.precision < 0) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalFormatPrecisionException(this.precision));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if ($assertionsDisabled) break block4;
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                    }
                }
            }
            return this.precision;
        }

        int precision() {
            return this.precision;
        }

        private char conversion(String string) {
            this.c = string.charAt(0);
            if (!this.dt) {
                if (!Conversion.isValid(this.c)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnknownFormatConversionException(String.valueOf(this.c)));
                }
                if (Character.isUpperCase(this.c)) {
                    this.f.add(Flags.UPPERCASE);
                }
                this.c = Character.toLowerCase(this.c);
                if (Conversion.isText(this.c)) {
                    this.index = -2;
                }
            }
            return this.c;
        }

        private char conversion() {
            return this.c;
        }

        FormatSpecifier(Formatter formatter, Matcher matcher) {
            this.this$0 = formatter;
            this.index = -1;
            this.f = Flags.NONE;
            this.dt = false;
            int n2 = 1;
            this.index(matcher.group(n2++));
            this.flags(matcher.group(n2++));
            this.width(matcher.group(n2++));
            this.precision(matcher.group(n2++));
            String string = matcher.group(n2++);
            if (string != null) {
                this.dt = true;
                if (string.equals("T")) {
                    this.f.add(Flags.UPPERCASE);
                }
            }
            this.conversion(matcher.group(n2));
            if (this.dt) {
                this.checkDateTime();
            } else if (Conversion.isGeneral(this.c)) {
                this.checkGeneral();
            } else if (Conversion.isCharacter(this.c)) {
                this.checkCharacter();
            } else if (Conversion.isInteger(this.c)) {
                this.checkInteger();
            } else if (Conversion.isFloat(this.c)) {
                this.checkFloat();
            } else if (Conversion.isText(this.c)) {
                this.checkText();
            } else {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnknownFormatConversionException(String.valueOf(this.c)));
            }
        }

        public void print(Object object, Locale locale) throws IOException {
            if (this.dt) {
                this.printDateTime(object, locale);
                return;
            }
            switch (this.c) {
                case 'd': 
                case 'o': 
                case 'x': {
                    this.printInteger(object, locale);
                    break;
                }
                case 'a': 
                case 'e': 
                case 'f': 
                case 'g': {
                    this.printFloat(object, locale);
                    break;
                }
                case 'C': 
                case 'c': {
                    this.printCharacter(object);
                    break;
                }
                case 'b': {
                    this.printBoolean(object);
                    break;
                }
                case 's': {
                    this.printString(object, locale);
                    break;
                }
                case 'h': {
                    this.printHashCode(object);
                    break;
                }
                case 'n': {
                    ((FormatSpecifier)this).this$0.a.append(System.lineSeparator());
                    break;
                }
                case '%': {
                    ((FormatSpecifier)this).this$0.a.append('%');
                    break;
                }
                default: {
                    if ($assertionsDisabled) break;
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
            }
        }

        private void printInteger(Object object, Locale locale) throws IOException {
            if (object == null) {
                this.print("null");
            } else if (object instanceof Byte) {
                this.print((Byte)object, locale);
            } else if (g.convertForInstanceOf((Object)object, Short.class) instanceof Short) {
                this.print((Short)g.convertForCast((Object)object, Short.class), locale);
            } else if (g.convertForInstanceOf((Object)object, Integer.class) instanceof Integer) {
                this.print((Integer)g.convertForCast((Object)object, Integer.class), locale);
            } else if (g.convertForInstanceOf((Object)object, Long.class) instanceof Long) {
                this.print((Long)g.convertForCast((Object)object, Long.class), locale);
            } else if (g.convertForInstanceOf((Object)object, BigInteger.class) instanceof BigInteger) {
                this.print((BigInteger)g.convertForCast((Object)object, BigInteger.class), locale);
            } else {
                this.failConversion(this.c, object);
            }
        }

        private void printFloat(Object object, Locale locale) throws IOException {
            if (object == null) {
                this.print("null");
            } else if (g.convertForInstanceOf((Object)object, Float.class) instanceof Float) {
                this.print(((Float)g.convertForCast((Object)object, Float.class)).floatValue(), locale);
            } else if (object instanceof Double) {
                this.print((Double)object, locale);
            } else if (g.convertForInstanceOf((Object)object, BigDecimal.class) instanceof BigDecimal) {
                this.print((BigDecimal)g.convertForCast((Object)object, BigDecimal.class), locale);
            } else {
                this.failConversion(this.c, object);
            }
        }

        private void printDateTime(Object object, Locale locale) throws IOException {
            if (object == null) {
                this.print("null");
                return;
            }
            Calendar calendar = null;
            if (g.convertForInstanceOf((Object)object, Long.class) instanceof Long) {
                calendar = Calendar.getInstance(locale == null ? Locale.US : locale);
                calendar.setTimeInMillis((Long)g.convertForCast((Object)object, Long.class));
            } else if (g.convertForInstanceOf((Object)object, Date.class) instanceof Date) {
                calendar = Calendar.getInstance(locale == null ? Locale.US : locale);
                calendar.setTime((Date)g.convertForCast((Object)object, Date.class));
            } else if (g.convertForInstanceOf((Object)object, Calendar.class) instanceof Calendar) {
                calendar = (Calendar)g.convertForCast((Object)((Calendar)g.convertForCast((Object)object, Calendar.class)).clone(), Calendar.class);
                calendar.setLenient(true);
            } else {
                this.failConversion(this.c, object);
            }
            this.print(calendar, this.c, locale);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void printCharacter(Object object) throws IOException {
            if (object == null) {
                this.print("null");
                return;
            }
            String string = null;
            if (g.convertForInstanceOf((Object)object, Character.class) instanceof Character) {
                string = ((Character)g.convertForCast((Object)object, Character.class)).toString();
            } else if (object instanceof Byte) {
                byte by = (Byte)object;
                if (!Character.isValidCodePoint(by)) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalFormatCodePointException(by));
                string = new String(Character.toChars(by));
            } else if (g.convertForInstanceOf((Object)object, Short.class) instanceof Short) {
                short s = (Short)g.convertForCast((Object)object, Short.class);
                if (!Character.isValidCodePoint(s)) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalFormatCodePointException(s));
                string = new String(Character.toChars(s));
            } else if (g.convertForInstanceOf((Object)object, Integer.class) instanceof Integer) {
                int n2 = (Integer)g.convertForCast((Object)object, Integer.class);
                if (!Character.isValidCodePoint(n2)) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalFormatCodePointException(n2));
                string = new String(Character.toChars(n2));
            } else {
                this.failConversion(this.c, object);
            }
            this.print(string);
        }

        private void printString(Object object, Locale locale) throws IOException {
            if (g.convertForInstanceOf((Object)object, Formattable.class) instanceof Formattable) {
                Formatter formatter = ((FormatSpecifier)this).this$0;
                if (com.zeroturnaround.jrebelbase.facade.f.ifAcmp((Object)formatter.locale(), (Object)locale)) {
                    formatter = new Formatter(formatter.out(), locale);
                }
                ((Formattable)g.convertForCast((Object)object, Formattable.class)).formatTo(formatter, this.f.valueOf(), this.width, this.precision);
            } else {
                if (this.f.contains(Flags.ALTERNATE)) {
                    this.failMismatch(Flags.ALTERNATE, 's');
                }
                if (object == null) {
                    this.print("null");
                } else {
                    this.print(object.toString());
                }
            }
        }

        private void printBoolean(Object object) throws IOException {
            String string = object != null ? (g.convertForInstanceOf((Object)object, Boolean.class) instanceof Boolean ? ((Boolean)g.convertForCast((Object)object, Boolean.class)).toString() : Boolean.toString(true)) : Boolean.toString(false);
            this.print(string);
        }

        private void printHashCode(Object object) throws IOException {
            String string = object == null ? "null" : Integer.toHexString(object.hashCode());
            this.print(string);
        }

        private void print(String string) throws IOException {
            if (this.precision != -1 && this.precision < string.length()) {
                string = string.substring(0, this.precision);
            }
            if (this.f.contains(Flags.UPPERCASE)) {
                string = string.toUpperCase();
            }
            ((FormatSpecifier)this).this$0.a.append(this.justify(string));
        }

        private String justify(String string) {
            int n2;
            if (this.width == -1) {
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = this.f.contains(Flags.LEFT_JUSTIFY);
            int n3 = this.width - string.length();
            if (!bl) {
                for (n2 = 0; n2 < n3; ++n2) {
                    stringBuilder.append(' ');
                }
            }
            stringBuilder.append(string);
            if (bl) {
                for (n2 = 0; n2 < n3; ++n2) {
                    stringBuilder.append(' ');
                }
            }
            return stringBuilder.toString();
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(37);
            Flags flags = this.f.dup().remove(Flags.UPPERCASE);
            stringBuilder.append(flags.toString());
            if (this.index > 0) {
                stringBuilder.append(this.index).append('$');
            }
            if (this.width != -1) {
                stringBuilder.append(this.width);
            }
            if (this.precision != -1) {
                stringBuilder.append('.').append(this.precision);
            }
            if (this.dt) {
                stringBuilder.append(this.f.contains(Flags.UPPERCASE) ? (char)'T' : 't');
            }
            stringBuilder.append(this.f.contains(Flags.UPPERCASE) ? Character.toUpperCase(this.c) : this.c);
            return stringBuilder.toString();
        }

        private void checkGeneral() {
            if ((this.c == 'b' || this.c == 'h') && this.f.contains(Flags.ALTERNATE)) {
                this.failMismatch(Flags.ALTERNATE, this.c);
            }
            if (this.width == -1 && this.f.contains(Flags.LEFT_JUSTIFY)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new MissingFormatWidthException(this.toString()));
            }
            Flags[] flagsArray = new Flags[5];
            com.zeroturnaround.jrebelbase.facade.a.arrayStore((Object[])flagsArray, (int)0, (Object)((Object)Flags.PLUS));
            com.zeroturnaround.jrebelbase.facade.a.arrayStore((Object[])flagsArray, (int)1, (Object)((Object)Flags.LEADING_SPACE));
            com.zeroturnaround.jrebelbase.facade.a.arrayStore((Object[])flagsArray, (int)2, (Object)((Object)Flags.ZERO_PAD));
            com.zeroturnaround.jrebelbase.facade.a.arrayStore((Object[])flagsArray, (int)3, (Object)((Object)Flags.GROUP));
            com.zeroturnaround.jrebelbase.facade.a.arrayStore((Object[])flagsArray, (int)4, (Object)((Object)Flags.PARENTHESES));
            this.checkBadFlags(flagsArray);
        }

        private void checkDateTime() {
            if (this.precision != -1) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalFormatPrecisionException(this.precision));
            }
            if (!DateTime.isValid(this.c)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnknownFormatConversionException("t" + this.c));
            }
            Flags[] flagsArray = new Flags[6];
            com.zeroturnaround.jrebelbase.facade.a.arrayStore((Object[])flagsArray, (int)0, (Object)((Object)Flags.ALTERNATE));
            com.zeroturnaround.jrebelbase.facade.a.arrayStore((Object[])flagsArray, (int)1, (Object)((Object)Flags.PLUS));
            com.zeroturnaround.jrebelbase.facade.a.arrayStore((Object[])flagsArray, (int)2, (Object)((Object)Flags.LEADING_SPACE));
            com.zeroturnaround.jrebelbase.facade.a.arrayStore((Object[])flagsArray, (int)3, (Object)((Object)Flags.ZERO_PAD));
            com.zeroturnaround.jrebelbase.facade.a.arrayStore((Object[])flagsArray, (int)4, (Object)((Object)Flags.GROUP));
            com.zeroturnaround.jrebelbase.facade.a.arrayStore((Object[])flagsArray, (int)5, (Object)((Object)Flags.PARENTHESES));
            this.checkBadFlags(flagsArray);
            if (this.width == -1 && this.f.contains(Flags.LEFT_JUSTIFY)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new MissingFormatWidthException(this.toString()));
            }
        }

        private void checkCharacter() {
            if (this.precision != -1) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalFormatPrecisionException(this.precision));
            }
            Flags[] flagsArray = new Flags[6];
            com.zeroturnaround.jrebelbase.facade.a.arrayStore((Object[])flagsArray, (int)0, (Object)((Object)Flags.ALTERNATE));
            com.zeroturnaround.jrebelbase.facade.a.arrayStore((Object[])flagsArray, (int)1, (Object)((Object)Flags.PLUS));
            com.zeroturnaround.jrebelbase.facade.a.arrayStore((Object[])flagsArray, (int)2, (Object)((Object)Flags.LEADING_SPACE));
            com.zeroturnaround.jrebelbase.facade.a.arrayStore((Object[])flagsArray, (int)3, (Object)((Object)Flags.ZERO_PAD));
            com.zeroturnaround.jrebelbase.facade.a.arrayStore((Object[])flagsArray, (int)4, (Object)((Object)Flags.GROUP));
            com.zeroturnaround.jrebelbase.facade.a.arrayStore((Object[])flagsArray, (int)5, (Object)((Object)Flags.PARENTHESES));
            this.checkBadFlags(flagsArray);
            if (this.width == -1 && this.f.contains(Flags.LEFT_JUSTIFY)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new MissingFormatWidthException(this.toString()));
            }
        }

        private void checkInteger() {
            this.checkNumeric();
            if (this.precision != -1) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalFormatPrecisionException(this.precision));
            }
            if (this.c == 'd') {
                Flags[] flagsArray = new Flags[1];
                com.zeroturnaround.jrebelbase.facade.a.arrayStore((Object[])flagsArray, (int)0, (Object)((Object)Flags.ALTERNATE));
                this.checkBadFlags(flagsArray);
            } else if (this.c == 'o') {
                Flags[] flagsArray = new Flags[1];
                com.zeroturnaround.jrebelbase.facade.a.arrayStore((Object[])flagsArray, (int)0, (Object)((Object)Flags.GROUP));
                this.checkBadFlags(flagsArray);
            } else {
                Flags[] flagsArray = new Flags[1];
                com.zeroturnaround.jrebelbase.facade.a.arrayStore((Object[])flagsArray, (int)0, (Object)((Object)Flags.GROUP));
                this.checkBadFlags(flagsArray);
            }
        }

        private void checkBadFlags(Flags ... flagsArray) {
            for (int i = 0; i < com.zeroturnaround.jrebelbase.facade.a.arrayLength((Object[])flagsArray); ++i) {
                if (!this.f.contains((Flags)((Object)g.convertForCast((Object)com.zeroturnaround.jrebelbase.facade.a.arrayLoad((Object[])flagsArray, (int)i), Flags.class)))) continue;
                this.failMismatch((Flags)((Object)g.convertForCast((Object)com.zeroturnaround.jrebelbase.facade.a.arrayLoad((Object[])flagsArray, (int)i), Flags.class)), this.c);
            }
        }

        private void checkFloat() {
            this.checkNumeric();
            if (this.c != 'f') {
                if (this.c == 'a') {
                    Flags[] flagsArray = new Flags[2];
                    com.zeroturnaround.jrebelbase.facade.a.arrayStore((Object[])flagsArray, (int)0, (Object)((Object)Flags.PARENTHESES));
                    com.zeroturnaround.jrebelbase.facade.a.arrayStore((Object[])flagsArray, (int)1, (Object)((Object)Flags.GROUP));
                    this.checkBadFlags(flagsArray);
                } else if (this.c == 'e') {
                    Flags[] flagsArray = new Flags[1];
                    com.zeroturnaround.jrebelbase.facade.a.arrayStore((Object[])flagsArray, (int)0, (Object)((Object)Flags.GROUP));
                    this.checkBadFlags(flagsArray);
                } else if (this.c == 'g') {
                    Flags[] flagsArray = new Flags[1];
                    com.zeroturnaround.jrebelbase.facade.a.arrayStore((Object[])flagsArray, (int)0, (Object)((Object)Flags.ALTERNATE));
                    this.checkBadFlags(flagsArray);
                }
            }
        }

        private void checkNumeric() {
            if (this.width != -1 && this.width < 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalFormatWidthException(this.width));
            }
            if (this.precision != -1 && this.precision < 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalFormatPrecisionException(this.precision));
            }
            if (this.width == -1 && (this.f.contains(Flags.LEFT_JUSTIFY) || this.f.contains(Flags.ZERO_PAD))) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new MissingFormatWidthException(this.toString()));
            }
            if (this.f.contains(Flags.PLUS) && this.f.contains(Flags.LEADING_SPACE) || this.f.contains(Flags.LEFT_JUSTIFY) && this.f.contains(Flags.ZERO_PAD)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalFormatFlagsException(this.f.toString()));
            }
        }

        private void checkText() {
            if (this.precision != -1) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalFormatPrecisionException(this.precision));
            }
            switch (this.c) {
                case '%': {
                    if (this.f.valueOf() != Flags.LEFT_JUSTIFY.valueOf() && this.f.valueOf() != Flags.NONE.valueOf()) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalFormatFlagsException(this.f.toString()));
                    }
                    if (this.width != -1 || !this.f.contains(Flags.LEFT_JUSTIFY)) break;
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new MissingFormatWidthException(this.toString()));
                }
                case 'n': {
                    if (this.width != -1) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalFormatWidthException(this.width));
                    }
                    if (this.f.valueOf() == Flags.NONE.valueOf()) break;
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalFormatFlagsException(this.f.toString()));
                }
                default: {
                    if ($assertionsDisabled) break;
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
            }
        }

        private void print(byte by, Locale locale) throws IOException {
            long l2 = by;
            if (by < 0 && (this.c == 'o' || this.c == 'x')) if (!$assertionsDisabled && (l2 += 256L) < 0L) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError(l2));
            }
            this.print(l2, locale);
        }

        private void print(short s, Locale locale) throws IOException {
            long l2 = s;
            if (s < 0 && (this.c == 'o' || this.c == 'x')) if (!$assertionsDisabled && (l2 += 65536L) < 0L) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError(l2));
            }
            this.print(l2, locale);
        }

        private void print(int n2, Locale locale) throws IOException {
            long l2 = n2;
            if (n2 < 0 && (this.c == 'o' || this.c == 'x')) if (!$assertionsDisabled && (l2 += 0x100000000L) < 0L) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError(l2));
            }
            this.print(l2, locale);
        }

        private void print(long l2, Locale locale) throws IOException {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.c == 'd') {
                boolean bl = l2 < 0L;
                char[] cArray = l2 < 0L ? Long.toString(l2, 10).substring(1).toCharArray() : Long.toString(l2, 10).toCharArray();
                this.leadingSign(stringBuilder, bl);
                this.localizedMagnitude(stringBuilder, cArray, this.f, this.adjustWidth(this.width, this.f, bl), locale);
                this.trailingSign(stringBuilder, bl);
            } else if (this.c == 'o') {
                int n2;
                Flags[] flagsArray = new Flags[3];
                com.zeroturnaround.jrebelbase.facade.a.arrayStore((Object[])flagsArray, (int)0, (Object)((Object)Flags.PARENTHESES));
                com.zeroturnaround.jrebelbase.facade.a.arrayStore((Object[])flagsArray, (int)1, (Object)((Object)Flags.LEADING_SPACE));
                com.zeroturnaround.jrebelbase.facade.a.arrayStore((Object[])flagsArray, (int)2, (Object)((Object)Flags.PLUS));
                this.checkBadFlags(flagsArray);
                String string = Long.toOctalString(l2);
                int n3 = n2 = this.f.contains(Flags.ALTERNATE) ? string.length() + 1 : string.length();
                if (this.f.contains(Flags.ALTERNATE)) {
                    stringBuilder.append('0');
                }
                if (this.f.contains(Flags.ZERO_PAD)) {
                    for (int i = 0; i < this.width - n2; ++i) {
                        stringBuilder.append('0');
                    }
                }
                stringBuilder.append(string);
            } else if (this.c == 'x') {
                int n4;
                Flags[] flagsArray = new Flags[3];
                com.zeroturnaround.jrebelbase.facade.a.arrayStore((Object[])flagsArray, (int)0, (Object)((Object)Flags.PARENTHESES));
                com.zeroturnaround.jrebelbase.facade.a.arrayStore((Object[])flagsArray, (int)1, (Object)((Object)Flags.LEADING_SPACE));
                com.zeroturnaround.jrebelbase.facade.a.arrayStore((Object[])flagsArray, (int)2, (Object)((Object)Flags.PLUS));
                this.checkBadFlags(flagsArray);
                String string = Long.toHexString(l2);
                int n5 = n4 = this.f.contains(Flags.ALTERNATE) ? string.length() + 2 : string.length();
                if (this.f.contains(Flags.ALTERNATE)) {
                    stringBuilder.append(this.f.contains(Flags.UPPERCASE) ? "0X" : "0x");
                }
                if (this.f.contains(Flags.ZERO_PAD)) {
                    for (int i = 0; i < this.width - n4; ++i) {
                        stringBuilder.append('0');
                    }
                }
                if (this.f.contains(Flags.UPPERCASE)) {
                    string = string.toUpperCase();
                }
                stringBuilder.append(string);
            }
            ((FormatSpecifier)this).this$0.a.append(this.justify(stringBuilder.toString()));
        }

        private StringBuilder leadingSign(StringBuilder stringBuilder, boolean bl) {
            if (!bl) {
                if (this.f.contains(Flags.PLUS)) {
                    stringBuilder.append('+');
                } else if (this.f.contains(Flags.LEADING_SPACE)) {
                    stringBuilder.append(' ');
                }
            } else if (this.f.contains(Flags.PARENTHESES)) {
                stringBuilder.append('(');
            } else {
                stringBuilder.append('-');
            }
            return stringBuilder;
        }

        private StringBuilder trailingSign(StringBuilder stringBuilder, boolean bl) {
            if (bl && this.f.contains(Flags.PARENTHESES)) {
                stringBuilder.append(')');
            }
            return stringBuilder;
        }

        private void print(BigInteger bigInteger, Locale locale) throws IOException {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = bigInteger.signum() == -1;
            BigInteger bigInteger2 = bigInteger.abs();
            this.leadingSign(stringBuilder, bl);
            if (this.c == 'd') {
                char[] cArray = bigInteger2.toString().toCharArray();
                this.localizedMagnitude(stringBuilder, cArray, this.f, this.adjustWidth(this.width, this.f, bl), locale);
            } else if (this.c == 'o') {
                String string = bigInteger2.toString(8);
                int n2 = string.length() + stringBuilder.length();
                if (bl && this.f.contains(Flags.PARENTHESES)) {
                    ++n2;
                }
                if (this.f.contains(Flags.ALTERNATE)) {
                    ++n2;
                    stringBuilder.append('0');
                }
                if (this.f.contains(Flags.ZERO_PAD)) {
                    for (int i = 0; i < this.width - n2; ++i) {
                        stringBuilder.append('0');
                    }
                }
                stringBuilder.append(string);
            } else if (this.c == 'x') {
                String string = bigInteger2.toString(16);
                int n3 = string.length() + stringBuilder.length();
                if (bl && this.f.contains(Flags.PARENTHESES)) {
                    ++n3;
                }
                if (this.f.contains(Flags.ALTERNATE)) {
                    n3 += 2;
                    stringBuilder.append(this.f.contains(Flags.UPPERCASE) ? "0X" : "0x");
                }
                if (this.f.contains(Flags.ZERO_PAD)) {
                    for (int i = 0; i < this.width - n3; ++i) {
                        stringBuilder.append('0');
                    }
                }
                if (this.f.contains(Flags.UPPERCASE)) {
                    string = string.toUpperCase();
                }
                stringBuilder.append(string);
            }
            this.trailingSign(stringBuilder, bigInteger.signum() == -1);
            ((FormatSpecifier)this).this$0.a.append(this.justify(stringBuilder.toString()));
        }

        private void print(float f2, Locale locale) throws IOException {
            this.print((double)f2, locale);
        }

        private void print(double d, Locale locale) throws IOException {
            boolean bl;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl2 = bl = Double.compare(d, 0.0) == -1;
            if (!Double.isNaN(d)) {
                double d2 = Math.abs(d);
                this.leadingSign(stringBuilder, bl);
                if (!Double.isInfinite(d2)) {
                    this.print(stringBuilder, d2, locale, this.f, this.c, this.precision, bl);
                } else {
                    stringBuilder.append(this.f.contains(Flags.UPPERCASE) ? "INFINITY" : "Infinity");
                }
                this.trailingSign(stringBuilder, bl);
            } else {
                stringBuilder.append(this.f.contains(Flags.UPPERCASE) ? "NAN" : "NaN");
            }
            ((FormatSpecifier)this).this$0.a.append(this.justify(stringBuilder.toString()));
        }

        private void print(StringBuilder stringBuilder, double d, Locale locale, Flags flags, char c2, int n2, boolean bl) throws IOException {
            if (c2 == 'e') {
                char[] cArray;
                int n3 = n2 == -1 ? 6 : n2;
                FormattedFloatingDecimal formattedFloatingDecimal = new FormattedFloatingDecimal(d, n3, FormattedFloatingDecimal.Form.SCIENTIFIC);
                char[] cArray2 = new char[30];
                int n4 = formattedFloatingDecimal.getChars(cArray2);
                char[] cArray3 = this.addZeros(this.mantissa(cArray2, n4), n3);
                if (flags.contains(Flags.ALTERNATE) && n3 == 0) {
                    cArray3 = this.addDot(cArray3);
                }
                if (d == 0.0) {
                    char[] cArray4 = new char[3];
                    cArray4[0] = 43;
                    cArray4[1] = 48;
                    cArray = cArray4;
                    cArray4[2] = 48;
                } else {
                    cArray = this.exponent(cArray2, n4);
                }
                char[] cArray5 = cArray;
                int n5 = this.width;
                if (this.width != -1) {
                    n5 = this.adjustWidth(this.width - cArray5.length - 1, flags, bl);
                }
                this.localizedMagnitude(stringBuilder, cArray3, flags, n5, locale);
                stringBuilder.append(flags.contains(Flags.UPPERCASE) ? (char)'E' : 'e');
                Flags flags2 = flags.dup().remove(Flags.GROUP);
                char c3 = cArray5[0];
                if (!$assertionsDisabled && c3 != '+' && c3 != '-') {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
                stringBuilder.append(c3);
                char[] cArray6 = new char[cArray5.length - 1];
                com.zeroturnaround.jrebelbase.facade.a.arraycopy((Object)cArray5, (int)1, (Object)cArray6, (int)0, (int)(cArray5.length - 1));
                stringBuilder.append((CharSequence)this.localizedMagnitude(null, cArray6, flags2, -1, locale));
            } else if (c2 == 'f') {
                int n6 = n2 == -1 ? 6 : n2;
                FormattedFloatingDecimal formattedFloatingDecimal = new FormattedFloatingDecimal(d, n6, FormattedFloatingDecimal.Form.DECIMAL_FLOAT);
                char[] cArray = new char[31 + Math.abs(formattedFloatingDecimal.getExponent())];
                int n7 = formattedFloatingDecimal.getChars(cArray);
                char[] cArray7 = this.addZeros(this.mantissa(cArray, n7), n6);
                if (flags.contains(Flags.ALTERNATE) && n6 == 0) {
                    cArray7 = this.addDot(cArray7);
                }
                int n8 = this.width;
                if (this.width != -1) {
                    n8 = this.adjustWidth(this.width, flags, bl);
                }
                this.localizedMagnitude(stringBuilder, cArray7, flags, n8, locale);
            } else if (c2 == 'g') {
                int n9 = n2;
                if (n2 == -1) {
                    n9 = 6;
                } else if (n2 == 0) {
                    n9 = 1;
                }
                FormattedFloatingDecimal formattedFloatingDecimal = new FormattedFloatingDecimal(d, n9, FormattedFloatingDecimal.Form.GENERAL);
                char[] cArray = new char[31 + Math.abs(formattedFloatingDecimal.getExponent())];
                int n10 = formattedFloatingDecimal.getChars(cArray);
                char[] cArray8 = this.exponent(cArray, n10);
                n9 = cArray8 != null ? --n9 : n9 - (d == 0.0 ? 0 : formattedFloatingDecimal.getExponentRounded()) - 1;
                char[] cArray9 = this.addZeros(this.mantissa(cArray, n10), n9);
                if (flags.contains(Flags.ALTERNATE) && n9 == 0) {
                    cArray9 = this.addDot(cArray9);
                }
                int n11 = this.width;
                if (this.width != -1) {
                    n11 = cArray8 != null ? this.adjustWidth(this.width - cArray8.length - 1, flags, bl) : this.adjustWidth(this.width, flags, bl);
                }
                this.localizedMagnitude(stringBuilder, cArray9, flags, n11, locale);
                if (cArray8 != null) {
                    stringBuilder.append(flags.contains(Flags.UPPERCASE) ? (char)'E' : 'e');
                    Flags flags3 = flags.dup().remove(Flags.GROUP);
                    char c4 = cArray8[0];
                    if (!$assertionsDisabled && c4 != '+' && c4 != '-') {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                    }
                    stringBuilder.append(c4);
                    char[] cArray10 = new char[cArray8.length - 1];
                    com.zeroturnaround.jrebelbase.facade.a.arraycopy((Object)cArray8, (int)1, (Object)cArray10, (int)0, (int)(cArray8.length - 1));
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, cArray10, flags3, -1, locale));
                }
            } else if (c2 == 'a') {
                int n12;
                int n13 = n2;
                if (n2 == -1) {
                    n13 = 0;
                } else if (n2 == 0) {
                    n13 = 1;
                }
                String string = this.hexDouble(d, n13);
                boolean bl2 = flags.contains(Flags.UPPERCASE);
                stringBuilder.append(bl2 ? "0X" : "0x");
                if (flags.contains(Flags.ZERO_PAD)) {
                    for (n12 = 0; n12 < this.width - string.length() - 2; ++n12) {
                        stringBuilder.append('0');
                    }
                }
                n12 = string.indexOf(112);
                char[] cArray = string.substring(0, n12).toCharArray();
                if (bl2) {
                    String string2 = new String(cArray);
                    string2 = string2.toUpperCase(Locale.US);
                    cArray = string2.toCharArray();
                }
                stringBuilder.append(n13 != 0 ? this.addZeros(cArray, n13) : cArray);
                stringBuilder.append(bl2 ? (char)'P' : 'p');
                stringBuilder.append(string.substring(n12 + 1));
            }
        }

        private char[] mantissa(char[] cArray, int n2) {
            int n3;
            for (n3 = 0; n3 < n2 && cArray[n3] != 'e'; ++n3) {
            }
            char[] cArray2 = new char[n3];
            com.zeroturnaround.jrebelbase.facade.a.arraycopy((Object)cArray, (int)0, (Object)cArray2, (int)0, (int)n3);
            return cArray2;
        }

        private char[] exponent(char[] cArray, int n2) {
            int n3;
            for (n3 = n2 - 1; n3 >= 0 && cArray[n3] != 'e'; --n3) {
            }
            if (n3 == -1) {
                return null;
            }
            char[] cArray2 = new char[n2 - n3 - 1];
            com.zeroturnaround.jrebelbase.facade.a.arraycopy((Object)cArray, (int)(n3 + 1), (Object)cArray2, (int)0, (int)(n2 - n3 - 1));
            return cArray2;
        }

        private char[] addZeros(char[] cArray, int n2) {
            int n3;
            for (n3 = 0; n3 < cArray.length && cArray[n3] != '.'; ++n3) {
            }
            boolean bl = false;
            if (n3 == cArray.length) {
                bl = true;
            }
            int n4 = cArray.length - n3 - (bl ? 0 : 1);
            if (!$assertionsDisabled && n4 > n2) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            if (n4 == n2) {
                return cArray;
            }
            char[] cArray2 = new char[cArray.length + n2 - n4 + (bl ? 1 : 0)];
            com.zeroturnaround.jrebelbase.facade.a.arraycopy((Object)cArray, (int)0, (Object)cArray2, (int)0, (int)cArray.length);
            int n5 = cArray.length;
            if (bl) {
                cArray2[cArray.length] = 46;
                ++n5;
            }
            for (int i = n5; i < cArray2.length; ++i) {
                cArray2[i] = 48;
            }
            return cArray2;
        }

        private String hexDouble(double d, int n2) {
            long l2;
            double d2;
            boolean bl;
            boolean bl2;
            if (!FpUtils.isFinite(d) || d == 0.0 || n2 == 0 || n2 >= 13) {
                return Double.toHexString(d).substring(2);
            }
            if (!($assertionsDisabled || n2 >= 1 && n2 <= 12)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            int n3 = FpUtils.getExponent(d);
            boolean bl3 = bl2 = n3 == -1023;
            if (bl2) {
                scaleUp = FpUtils.scalb(1.0, 54);
                n3 = FpUtils.getExponent(d *= scaleUp);
                if (!($assertionsDisabled || n3 >= -1022 && n3 <= 1023)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError(n3));
                }
            }
            int n4 = 1 + n2 * 4;
            int n5 = 53 - n4;
            if (!($assertionsDisabled || n5 >= 1 && n5 < 53)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            long l3 = Double.doubleToLongBits(d);
            long l4 = (l3 & Long.MAX_VALUE) >> n5;
            long l5 = l3 & (-1L << n5 ^ 0xFFFFFFFFFFFFFFFFL);
            boolean bl4 = (l4 & 1L) == 0L;
            boolean bl5 = (1L << n5 - 1 & l5) != 0L;
            boolean bl6 = bl = n5 > 1 && ((1L << n5 - 1 ^ 0xFFFFFFFFFFFFFFFFL) & l5) != 0L;
            if (bl4 && bl5 && bl || !bl4 && bl5) {
                ++l4;
            }
            if (Double.isInfinite(d2 = Double.longBitsToDouble(l4 = (l2 = l3 & Long.MIN_VALUE) | l4 << n5))) {
                return "1.0p1024";
            }
            String string = Double.toHexString(d2).substring(2);
            if (!bl2) {
                return string;
            }
            int n6 = string.indexOf(112);
            if (n6 == -1) {
                if (!$assertionsDisabled) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
                return null;
            }
            String string2 = string.substring(n6 + 1);
            int n7 = Integer.parseInt(string2) - 54;
            return string.substring(0, n6) + "p" + Integer.toString(n7);
        }

        private void print(BigDecimal bigDecimal, Locale locale) throws IOException {
            if (this.c == 'a') {
                this.failConversion(this.c, bigDecimal);
            }
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = bigDecimal.signum() == -1;
            BigDecimal bigDecimal2 = bigDecimal.abs();
            this.leadingSign(stringBuilder, bl);
            this.print(stringBuilder, bigDecimal2, locale, this.f, this.c, this.precision, bl);
            this.trailingSign(stringBuilder, bl);
            ((FormatSpecifier)this).this$0.a.append(this.justify(stringBuilder.toString()));
        }

        private void print(StringBuilder stringBuilder, BigDecimal bigDecimal, Locale locale, Flags flags, char c2, int n2, boolean bl) throws IOException {
            if (c2 == 'e') {
                int n3;
                int n4 = n2 == -1 ? 6 : n2;
                int n5 = bigDecimal.scale();
                int n6 = bigDecimal.precision();
                int n7 = 0;
                if (n4 > n6 - 1) {
                    n3 = n6;
                    n7 = n4 - (n6 - 1);
                } else {
                    n3 = n4 + 1;
                }
                MathContext mathContext = new MathContext(n3);
                BigDecimal bigDecimal2 = new BigDecimal(bigDecimal.unscaledValue(), n5, mathContext);
                BigDecimalLayout bigDecimalLayout = new BigDecimalLayout(this, bigDecimal2.unscaledValue(), bigDecimal2.scale(), BigDecimalLayoutForm.SCIENTIFIC);
                char[] cArray = bigDecimalLayout.mantissa();
                if (!(n6 != 1 && bigDecimalLayout.hasDot() || n7 <= 0 && !flags.contains(Flags.ALTERNATE))) {
                    cArray = this.addDot(cArray);
                }
                cArray = this.trailingZeros(cArray, n7);
                char[] cArray2 = bigDecimalLayout.exponent();
                int n8 = this.width;
                if (this.width != -1) {
                    n8 = this.adjustWidth(this.width - cArray2.length - 1, flags, bl);
                }
                this.localizedMagnitude(stringBuilder, cArray, flags, n8, locale);
                stringBuilder.append(flags.contains(Flags.UPPERCASE) ? (char)'E' : 'e');
                Flags flags2 = flags.dup().remove(Flags.GROUP);
                char c3 = cArray2[0];
                if (!$assertionsDisabled && c3 != '+' && c3 != '-') {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
                stringBuilder.append(cArray2[0]);
                char[] cArray3 = new char[cArray2.length - 1];
                com.zeroturnaround.jrebelbase.facade.a.arraycopy((Object)cArray2, (int)1, (Object)cArray3, (int)0, (int)(cArray2.length - 1));
                stringBuilder.append((CharSequence)this.localizedMagnitude(null, cArray3, flags2, -1, locale));
            } else if (c2 == 'f') {
                int n9;
                int n10 = n2 == -1 ? 6 : n2;
                int n11 = bigDecimal.scale();
                if (n11 > n10) {
                    int n12 = bigDecimal.precision();
                    bigDecimal = n12 <= n11 ? bigDecimal.setScale(n10, RoundingMode.HALF_UP) : new BigDecimal(bigDecimal.unscaledValue(), n11, new MathContext(n12 -= n11 - n10));
                }
                BigDecimalLayout bigDecimalLayout = new BigDecimalLayout(this, bigDecimal.unscaledValue(), bigDecimal.scale(), BigDecimalLayoutForm.DECIMAL_FLOAT);
                char[] cArray = bigDecimalLayout.mantissa();
                int n13 = n9 = bigDecimalLayout.scale() < n10 ? n10 - bigDecimalLayout.scale() : 0;
                if (bigDecimalLayout.scale() == 0 && (flags.contains(Flags.ALTERNATE) || n9 > 0)) {
                    cArray = this.addDot(bigDecimalLayout.mantissa());
                }
                cArray = this.trailingZeros(cArray, n9);
                this.localizedMagnitude(stringBuilder, cArray, flags, this.adjustWidth(this.width, flags, bl), locale);
            } else if (c2 == 'g') {
                int n14 = n2;
                if (n2 == -1) {
                    n14 = 6;
                } else if (n2 == 0) {
                    n14 = 1;
                }
                BigDecimal bigDecimal3 = BigDecimal.valueOf(1L, 4);
                BigDecimal bigDecimal4 = BigDecimal.valueOf(1L, -n14);
                if (bigDecimal.equals(BigDecimal.ZERO) || bigDecimal.compareTo(bigDecimal3) != -1 && bigDecimal.compareTo(bigDecimal4) == -1) {
                    int n15 = -bigDecimal.scale() + (bigDecimal.unscaledValue().toString().length() - 1);
                    n14 = n14 - n15 - 1;
                    this.print(stringBuilder, bigDecimal, locale, flags, 'f', n14, bl);
                } else {
                    this.print(stringBuilder, bigDecimal, locale, flags, 'e', n14 - 1, bl);
                }
            } else if (c2 == 'a') if (!$assertionsDisabled) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
        }

        private int adjustWidth(int n2, Flags flags, boolean bl) {
            int n3 = n2;
            if (n3 != -1 && bl && flags.contains(Flags.PARENTHESES)) {
                --n3;
            }
            return n3;
        }

        private char[] addDot(char[] cArray) {
            char[] cArray2 = cArray;
            cArray2 = new char[cArray.length + 1];
            com.zeroturnaround.jrebelbase.facade.a.arraycopy((Object)cArray, (int)0, (Object)cArray2, (int)0, (int)cArray.length);
            cArray2[cArray2.length - 1] = 46;
            return cArray2;
        }

        private char[] trailingZeros(char[] cArray, int n2) {
            char[] cArray2 = cArray;
            if (n2 > 0) {
                cArray2 = new char[cArray.length + n2];
                com.zeroturnaround.jrebelbase.facade.a.arraycopy((Object)cArray, (int)0, (Object)cArray2, (int)0, (int)cArray.length);
                for (int i = cArray.length; i < cArray2.length; ++i) {
                    cArray2[i] = 48;
                }
            }
            return cArray2;
        }

        private void print(Calendar calendar, char c2, Locale locale) throws IOException {
            StringBuilder stringBuilder = new StringBuilder();
            this.print(stringBuilder, calendar, c2, locale);
            String string = this.justify(stringBuilder.toString());
            if (this.f.contains(Flags.UPPERCASE)) {
                string = string.toUpperCase();
            }
            ((FormatSpecifier)this).this$0.a.append(string);
        }

        private Appendable print(StringBuilder stringBuilder, Calendar calendar, char c2, Locale locale) throws IOException {
            if (!$assertionsDisabled && this.width != -1) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            switch (c2) {
                case 'H': 
                case 'I': 
                case 'k': 
                case 'l': {
                    int n2 = calendar.get(11);
                    if (c2 == 'I' || c2 == 'l') {
                        n2 = n2 == 0 || n2 == 12 ? 12 : n2 % 12;
                    }
                    Flags flags = c2 == 'H' || c2 == 'I' ? Flags.ZERO_PAD : Flags.NONE;
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, n2, flags, 2, locale));
                    break;
                }
                case 'M': {
                    int n3 = calendar.get(12);
                    Flags flags = Flags.ZERO_PAD;
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, n3, flags, 2, locale));
                    break;
                }
                case 'N': {
                    int n4 = calendar.get(14) * 1000000;
                    Flags flags = Flags.ZERO_PAD;
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, n4, flags, 9, locale));
                    break;
                }
                case 'L': {
                    int n5 = calendar.get(14);
                    Flags flags = Flags.ZERO_PAD;
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, n5, flags, 3, locale));
                    break;
                }
                case 'Q': {
                    long l2 = calendar.getTimeInMillis();
                    Flags flags = Flags.NONE;
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, l2, flags, this.width, locale));
                    break;
                }
                case 'p': {
                    Object object;
                    Object[] objectArray = new String[2];
                    com.zeroturnaround.jrebelbase.facade.a.arrayStore((Object[])objectArray, (int)0, (Object)"AM");
                    com.zeroturnaround.jrebelbase.facade.a.arrayStore((Object[])objectArray, (int)1, (Object)"PM");
                    Object[] objectArray2 = objectArray;
                    if (locale != null && com.zeroturnaround.jrebelbase.facade.f.ifAcmp((Object)locale, (Object)Locale.US)) {
                        object = DateFormatSymbols.getInstance(locale);
                        objectArray2 = ((DateFormatSymbols)object).getAmPmStrings();
                    }
                    object = (String)com.zeroturnaround.jrebelbase.facade.a.arrayLoad((Object[])objectArray2, (int)calendar.get(9));
                    stringBuilder.append(((String)object).toLowerCase(locale != null ? locale : Locale.US));
                    break;
                }
                case 's': {
                    long l3 = calendar.getTimeInMillis() / 1000L;
                    Flags flags = Flags.NONE;
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, l3, flags, this.width, locale));
                    break;
                }
                case 'S': {
                    int n6 = calendar.get(13);
                    Flags flags = Flags.ZERO_PAD;
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, n6, flags, 2, locale));
                    break;
                }
                case 'z': {
                    int n7 = calendar.get(15) + calendar.get(16);
                    boolean bl = n7 < 0;
                    stringBuilder.append(bl ? (char)'-' : '+');
                    if (bl) {
                        n7 = -n7;
                    }
                    int n8 = n7 / 60000;
                    int n9 = n8 / 60 * 100 + n8 % 60;
                    Flags flags = Flags.ZERO_PAD;
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, n9, flags, 4, locale));
                    break;
                }
                case 'Z': {
                    TimeZone timeZone = calendar.getTimeZone();
                    stringBuilder.append(timeZone.getDisplayName(calendar.get(16) != 0, 0, locale == null ? Locale.US : locale));
                    break;
                }
                case 'A': 
                case 'a': {
                    int n10 = calendar.get(7);
                    Locale locale2 = locale == null ? Locale.US : locale;
                    DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(locale2);
                    if (c2 == 'A') {
                        stringBuilder.append((String)com.zeroturnaround.jrebelbase.facade.a.arrayLoad((Object[])dateFormatSymbols.getWeekdays(), (int)n10));
                        break;
                    }
                    stringBuilder.append((String)com.zeroturnaround.jrebelbase.facade.a.arrayLoad((Object[])dateFormatSymbols.getShortWeekdays(), (int)n10));
                    break;
                }
                case 'B': 
                case 'b': 
                case 'h': {
                    int n11 = calendar.get(2);
                    Locale locale3 = locale == null ? Locale.US : locale;
                    DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(locale3);
                    if (c2 == 'B') {
                        stringBuilder.append((String)com.zeroturnaround.jrebelbase.facade.a.arrayLoad((Object[])dateFormatSymbols.getMonths(), (int)n11));
                        break;
                    }
                    stringBuilder.append((String)com.zeroturnaround.jrebelbase.facade.a.arrayLoad((Object[])dateFormatSymbols.getShortMonths(), (int)n11));
                    break;
                }
                case 'C': 
                case 'Y': 
                case 'y': {
                    int n12 = calendar.get(1);
                    int n13 = 2;
                    switch (c2) {
                        case 'C': {
                            n12 /= 100;
                            break;
                        }
                        case 'y': {
                            n12 %= 100;
                            break;
                        }
                        case 'Y': {
                            n13 = 4;
                        }
                    }
                    Flags flags = Flags.ZERO_PAD;
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, n12, flags, n13, locale));
                    break;
                }
                case 'd': 
                case 'e': {
                    int n14 = calendar.get(5);
                    Flags flags = c2 == 'd' ? Flags.ZERO_PAD : Flags.NONE;
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, n14, flags, 2, locale));
                    break;
                }
                case 'j': {
                    int n15 = calendar.get(6);
                    Flags flags = Flags.ZERO_PAD;
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, n15, flags, 3, locale));
                    break;
                }
                case 'm': {
                    int n16 = calendar.get(2) + 1;
                    Flags flags = Flags.ZERO_PAD;
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, n16, flags, 2, locale));
                    break;
                }
                case 'R': 
                case 'T': {
                    char c3 = ':';
                    this.print(stringBuilder, calendar, 'H', locale).append(c3);
                    this.print(stringBuilder, calendar, 'M', locale);
                    if (c2 != 'T') break;
                    stringBuilder.append(c3);
                    this.print(stringBuilder, calendar, 'S', locale);
                    break;
                }
                case 'r': {
                    char c4 = ':';
                    this.print(stringBuilder, calendar, 'I', locale).append(c4);
                    this.print(stringBuilder, calendar, 'M', locale).append(c4);
                    this.print(stringBuilder, calendar, 'S', locale).append(' ');
                    StringBuilder stringBuilder2 = new StringBuilder();
                    this.print(stringBuilder2, calendar, 'p', locale);
                    stringBuilder.append(stringBuilder2.toString().toUpperCase(locale != null ? locale : Locale.US));
                    break;
                }
                case 'c': {
                    char c5 = ' ';
                    this.print(stringBuilder, calendar, 'a', locale).append(c5);
                    this.print(stringBuilder, calendar, 'b', locale).append(c5);
                    this.print(stringBuilder, calendar, 'd', locale).append(c5);
                    this.print(stringBuilder, calendar, 'T', locale).append(c5);
                    this.print(stringBuilder, calendar, 'Z', locale).append(c5);
                    this.print(stringBuilder, calendar, 'Y', locale);
                    break;
                }
                case 'D': {
                    char c6 = '/';
                    this.print(stringBuilder, calendar, 'm', locale).append(c6);
                    this.print(stringBuilder, calendar, 'd', locale).append(c6);
                    this.print(stringBuilder, calendar, 'y', locale);
                    break;
                }
                case 'F': {
                    char c7 = '-';
                    this.print(stringBuilder, calendar, 'Y', locale).append(c7);
                    this.print(stringBuilder, calendar, 'm', locale).append(c7);
                    this.print(stringBuilder, calendar, 'd', locale);
                    break;
                }
                default: {
                    if ($assertionsDisabled) break;
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
            }
            return stringBuilder;
        }

        private void failMismatch(Flags flags, char c2) {
            String string = flags.toString();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new FormatFlagsConversionMismatchException(string, c2));
        }

        private void failConversion(char c2, Object object) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalFormatConversionException(c2, object.getClass()));
        }

        private char getZero(Locale locale) {
            if (locale != null && !locale.equals(((FormatSpecifier)this).this$0.locale())) {
                DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance(locale);
                return decimalFormatSymbols.getZeroDigit();
            }
            return ((FormatSpecifier)this).this$0.zero;
        }

        private StringBuilder localizedMagnitude(StringBuilder stringBuilder, long l2, Flags flags, int n2, Locale locale) {
            char[] cArray = Long.toString(l2, 10).toCharArray();
            return this.localizedMagnitude(stringBuilder, cArray, flags, n2, locale);
        }

        private StringBuilder localizedMagnitude(StringBuilder stringBuilder, char[] cArray, Flags flags, int n2, Locale locale) {
            int n3;
            int n4;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            int n5 = stringBuilder.length();
            char c2 = this.getZero(locale);
            char c3 = '\u0000';
            int n6 = -1;
            char c4 = '\u0000';
            int n7 = n4 = cArray.length;
            for (n3 = 0; n3 < n4; ++n3) {
                if (cArray[n3] != '.') continue;
                n7 = n3;
                break;
            }
            if (n7 < n4) {
                if (locale == null || locale.equals(Locale.US)) {
                    c4 = '.';
                } else {
                    DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance(locale);
                    c4 = decimalFormatSymbols.getDecimalSeparator();
                }
            }
            if (flags.contains(Flags.GROUP)) {
                if (locale == null || locale.equals(Locale.US)) {
                    c3 = ',';
                    n6 = 3;
                } else {
                    DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance(locale);
                    c3 = decimalFormatSymbols.getGroupingSeparator();
                    DecimalFormat decimalFormat = (DecimalFormat)g.convertForCast((Object)NumberFormat.getIntegerInstance(locale), DecimalFormat.class);
                    n6 = decimalFormat.getGroupingSize();
                }
            }
            for (n3 = 0; n3 < n4; ++n3) {
                if (n3 == n7) {
                    stringBuilder.append(c4);
                    c3 = '\u0000';
                    continue;
                }
                char c5 = cArray[n3];
                stringBuilder.append((char)(c5 - 48 + c2));
                if (c3 == '\u0000' || n3 == n7 - 1 || (n7 - n3) % n6 != 1) continue;
                stringBuilder.append(c3);
            }
            n4 = stringBuilder.length();
            if (n2 != -1 && flags.contains(Flags.ZERO_PAD)) {
                for (n3 = 0; n3 < n2 - n4; ++n3) {
                    stringBuilder.insert(n5, c2);
                }
            }
            return stringBuilder;
        }

        private static /* synthetic */ void _jr$ip$dt(FormatSpecifier formatSpecifier, boolean bl) {
            formatSpecifier.dt = bl;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, Formatter formatter) {
            ((FormatSpecifier)object).this$0 = formatter;
        }

        protected /* synthetic */ FormatSpecifier(h h2) {
            super(h2);
        }

        private class BigDecimalLayout
        extends h {
            private StringBuilder mant;
            private StringBuilder exp;
            private boolean dot;
            private int scale;
            final /* synthetic */ FormatSpecifier this$1;

            public BigDecimalLayout(FormatSpecifier formatSpecifier, BigInteger bigInteger, int n2, BigDecimalLayoutForm bigDecimalLayoutForm) {
                this.this$1 = formatSpecifier;
                this.dot = false;
                this.layout(bigInteger, n2, bigDecimalLayoutForm);
            }

            public boolean hasDot() {
                return this.dot;
            }

            public int scale() {
                return this.scale;
            }

            public char[] layoutChars() {
                StringBuilder stringBuilder = new StringBuilder(this.mant);
                if (this.exp != null) {
                    stringBuilder.append('E');
                    stringBuilder.append((CharSequence)this.exp);
                }
                return this.toCharArray(stringBuilder);
            }

            public char[] mantissa() {
                return this.toCharArray(this.mant);
            }

            public char[] exponent() {
                return this.toCharArray(this.exp);
            }

            private char[] toCharArray(StringBuilder stringBuilder) {
                if (stringBuilder == null) {
                    return null;
                }
                char[] cArray = new char[stringBuilder.length()];
                stringBuilder.getChars(0, cArray.length, cArray, 0);
                return cArray;
            }

            private void layout(BigInteger bigInteger, int n2, BigDecimalLayoutForm bigDecimalLayoutForm) {
                char[] cArray = bigInteger.toString().toCharArray();
                this.scale = n2;
                this.mant = new StringBuilder(cArray.length + 14);
                if (n2 == 0) {
                    int n3 = cArray.length;
                    if (n3 > 1) {
                        this.mant.append(cArray[0]);
                        if (!com.zeroturnaround.jrebelbase.facade.f.ifAcmp((Object)((Object)bigDecimalLayoutForm), (Object)((Object)BigDecimalLayoutForm.SCIENTIFIC))) {
                            this.mant.append('.');
                            this.dot = true;
                            this.mant.append(cArray, 1, n3 - 1);
                            this.exp = new StringBuilder("+");
                            if (n3 < 10) {
                                this.exp.append("0").append(n3 - 1);
                            } else {
                                this.exp.append(n3 - 1);
                            }
                        } else {
                            this.mant.append(cArray, 1, n3 - 1);
                        }
                    } else {
                        this.mant.append(cArray);
                        if (!com.zeroturnaround.jrebelbase.facade.f.ifAcmp((Object)((Object)bigDecimalLayoutForm), (Object)((Object)BigDecimalLayoutForm.SCIENTIFIC))) {
                            this.exp = new StringBuilder("+00");
                        }
                    }
                    return;
                }
                long l2 = -((long)n2) + (long)(cArray.length - 1);
                if (!com.zeroturnaround.jrebelbase.facade.f.ifAcmp((Object)((Object)bigDecimalLayoutForm), (Object)((Object)BigDecimalLayoutForm.DECIMAL_FLOAT))) {
                    int n4 = n2 - cArray.length;
                    if (n4 >= 0) {
                        this.mant.append("0.");
                        this.dot = true;
                        while (n4 > 0) {
                            this.mant.append('0');
                            --n4;
                        }
                        this.mant.append(cArray);
                    } else if (-n4 < cArray.length) {
                        this.mant.append(cArray, 0, -n4);
                        this.mant.append('.');
                        this.dot = true;
                        this.mant.append(cArray, -n4, n2);
                    } else {
                        this.mant.append(cArray, 0, cArray.length);
                        for (int i = 0; i < -n2; ++i) {
                            this.mant.append('0');
                        }
                        this.scale = 0;
                    }
                } else {
                    this.mant.append(cArray[0]);
                    if (cArray.length > 1) {
                        this.mant.append('.');
                        this.dot = true;
                        this.mant.append(cArray, 1, cArray.length - 1);
                    }
                    this.exp = new StringBuilder();
                    if (l2 != 0L) {
                        long l3 = Math.abs(l2);
                        this.exp.append(l2 < 0L ? (char)'-' : '+');
                        if (l3 < 10L) {
                            this.exp.append('0');
                        }
                        this.exp.append(l3);
                    } else {
                        this.exp.append("+00");
                    }
                }
            }

            static /* synthetic */ FormatSpecifier _jr$ig$this$1(Object object) {
                return ((BigDecimalLayout)((Object)object)).this$1;
            }

            static /* synthetic */ void _jr$ip$this$1(Object object, FormatSpecifier formatSpecifier) {
                ((BigDecimalLayout)((Object)object)).this$1 = formatSpecifier;
            }

            protected /* synthetic */ BigDecimalLayout(h h2) {
                super(h2);
            }
        }
    }

    static interface FormatString {
        public int index();

        public void print(Formatter var1, Object var2, Locale var3) throws IOException;

        public String toString();
    }
}

