/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import sun.misc.Hashing;
import sun.misc.VM;
import sun.security.action.GetPropertyAction;

public class HashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final Entry<?, ?>[] EMPTY_TABLE = new Entry[0];
    transient Entry<K, V>[] table;
    transient int size;
    int threshold;
    final float loadFactor;
    transient int modCount;
    static final int ALTERNATIVE_HASHING_THRESHOLD_DEFAULT = Integer.MAX_VALUE;
    transient int hashSeed;
    private transient Set<Map.Entry<K, V>> entrySet;
    private static final long serialVersionUID = 362498820763181265L;

    public HashMap(int n, float f2) {
        this.table = (Entry[])g.convertForCast(EMPTY_TABLE, Entry[].class);
        this.hashSeed = 0;
        this.entrySet = null;
        if (n < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Illegal initial capacity: " + n));
        }
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if (f2 <= 0.0f || Float.isNaN(f2)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Illegal load factor: " + f2));
        }
        this.loadFactor = f2;
        this.threshold = n;
        this.init();
    }

    public HashMap(int n) {
        this(n, 0.75f);
    }

    public HashMap() {
        this(16, 0.75f);
    }

    public HashMap(Map<? extends K, ? extends V> map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 16), 0.75f);
        super.inflateTable(this.threshold);
        super.putAllForCreate(map);
    }

    private static int roundUpToPowerOf2(int n) {
        int n2;
        n2 = n >= 0x40000000 ? 0x40000000 : ((n2 = Integer.highestOneBit(n)) != 0 ? (Integer.bitCount(n) > 1 ? n2 << 1 : n2) : 1);
        return n2;
    }

    private void inflateTable(int n) {
        int n2 = HashMap.roundUpToPowerOf2(n);
        ((HashMap)this).threshold = (int)Math.min((float)n2 * ((HashMap)this).loadFactor, 1.0737418E9f);
        ((HashMap)this).table = new Entry[n2];
        this.initHashSeedAsNeeded(n2);
    }

    void init() {
    }

    final boolean initHashSeedAsNeeded(int n) {
        boolean bl;
        boolean bl2 = ((HashMap)this).hashSeed != 0;
        boolean bl3 = bl2 ^ (bl = VM.isBooted() && n >= Holder.ALTERNATIVE_HASHING_THRESHOLD);
        if (bl3) {
            ((HashMap)this).hashSeed = bl ? Hashing.randomHashSeed(this) : 0;
        }
        return bl3;
    }

    final int hash(Object object) {
        int n = ((HashMap)this).hashSeed;
        if (0 != n && object instanceof String) {
            return Hashing.stringHash32((String)object);
        }
        n ^= object.hashCode();
        n ^= n >>> 20 ^ n >>> 12;
        return n ^ n >>> 7 ^ n >>> 4;
    }

    static int indexFor(int n, int n2) {
        return n & n2 - 1;
    }

    @Override
    public int size() {
        return ((HashMap)this).size;
    }

    @Override
    public boolean isEmpty() {
        return ((HashMap)this).size == 0;
    }

    @Override
    public V get(Object object) {
        if (object == null) {
            return this.getForNullKey();
        }
        Entry<K, V> entry = this.getEntry(object);
        return !f.ifAcmp(null, entry) ? null : (V)entry.getValue();
    }

    private V getForNullKey() {
        if (((HashMap)this).size == 0) {
            return null;
        }
        Entry entry = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])((HashMap)this).table, (int)0), Entry.class);
        while (entry != null) {
            if (((Entry)entry).key == null) {
                return (V)((Entry)entry).value;
            }
            entry = ((Entry)entry).next;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.getEntry(object) != null;
    }

    final Entry<K, V> getEntry(Object object) {
        if (((HashMap)this).size == 0) {
            return null;
        }
        int n = object == null ? 0 : this.hash(object);
        Entry entry = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])((HashMap)this).table, (int)HashMap.indexFor(n, a.arrayLength((Object[])((HashMap)this).table))), Entry.class);
        while (entry != null) {
            Object object2;
            if (((Entry)entry).hash == n && (!f.ifAcmp((Object)(object2 = ((Entry)entry).key), (Object)object) || object != null && object.equals(object2))) {
                return entry;
            }
            entry = ((Entry)entry).next;
        }
        return null;
    }

    @Override
    public V put(K k, V v) {
        if (!f.ifAcmp((Object)((HashMap)this).table, EMPTY_TABLE)) {
            this.inflateTable(((HashMap)this).threshold);
        }
        if (k == null) {
            return this.putForNullKey(v);
        }
        int n = this.hash(k);
        int n2 = HashMap.indexFor(n, a.arrayLength((Object[])((HashMap)this).table));
        Entry entry = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])((HashMap)this).table, (int)n2), Entry.class);
        while (entry != null) {
            Object object;
            if (((Entry)entry).hash == n && (!f.ifAcmp((Object)(object = ((Entry)entry).key), k) || k.equals(object))) {
                Object object2 = ((Entry)entry).value;
                ((Entry)entry).value = v;
                entry.recordAccess(this);
                return (V)object2;
            }
            entry = ((Entry)entry).next;
        }
        HashMap hashMap = this;
        ((HashMap)hashMap).modCount = ((HashMap)hashMap).modCount + 1;
        this.addEntry(n, k, v, n2);
        return null;
    }

    private V putForNullKey(V v) {
        Entry entry = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])((HashMap)this).table, (int)0), Entry.class);
        while (entry != null) {
            if (((Entry)entry).key == null) {
                Object object = ((Entry)entry).value;
                ((Entry)entry).value = v;
                entry.recordAccess(this);
                return (V)object;
            }
            entry = ((Entry)entry).next;
        }
        HashMap hashMap = this;
        ((HashMap)hashMap).modCount = ((HashMap)hashMap).modCount + 1;
        this.addEntry(0, null, v, 0);
        return null;
    }

    private void putForCreate(K k, V v) {
        int n = !f.ifAcmp(null, k) ? 0 : this.hash(k);
        int n2 = HashMap.indexFor(n, a.arrayLength((Object[])((HashMap)this).table));
        Entry entry = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])((HashMap)this).table, (int)n2), Entry.class);
        while (entry != null) {
            Object object;
            if (((Entry)entry).hash == n && (!f.ifAcmp((Object)(object = ((Entry)entry).key), k) || k != null && k.equals(object))) {
                ((Entry)entry).value = v;
                return;
            }
            entry = ((Entry)entry).next;
        }
        this.createEntry(n, k, v, n2);
    }

    private void putAllForCreate(Map<? extends K, ? extends V> map) {
        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)g.convertForCast(iterator.next(), Map.Entry.class);
            this.putForCreate(entry.getKey(), entry.getValue());
        }
    }

    void resize(int n) {
        Object[] objectArray = ((HashMap)this).table;
        int n2 = a.arrayLength((Object[])objectArray);
        if (n2 == 0x40000000) {
            ((HashMap)this).threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] entryArray = new Entry[n];
        this.transfer(entryArray, this.initHashSeedAsNeeded(n));
        ((HashMap)this).table = entryArray;
        ((HashMap)this).threshold = (int)Math.min((float)n * ((HashMap)this).loadFactor, 1.0737418E9f);
    }

    void transfer(Entry[] entryArray, boolean bl) {
        int n = a.arrayLength((Object[])entryArray);
        Object[] objectArray = ((HashMap)this).table;
        int n2 = a.arrayLength((Object[])objectArray);
        for (int i = 0; i < n2; ++i) {
            Entry entry = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), Entry.class);
            while (f.ifAcmp(null, (Object)entry)) {
                Entry entry2 = ((Entry)entry).next;
                if (bl) {
                    ((Entry)entry).hash = !f.ifAcmp(null, (Object)((Entry)entry).key) ? 0 : this.hash(((Entry)entry).key);
                }
                int n3 = HashMap.indexFor(((Entry)entry).hash, n);
                ((Entry)entry).next = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])entryArray, (int)n3), Entry.class);
                a.arrayStore((Object[])entryArray, (int)n3, (Object)entry);
                entry = entry2;
            }
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        int n = map.size();
        if (n == 0) {
            return;
        }
        if (!f.ifAcmp((Object)((HashMap)this).table, EMPTY_TABLE)) {
            this.inflateTable((int)Math.max((float)n * ((HashMap)this).loadFactor, (float)((HashMap)this).threshold));
        }
        if (n > ((HashMap)this).threshold) {
            int n2;
            int n3 = (int)((float)n / ((HashMap)this).loadFactor + 1.0f);
            if (n3 > 0x40000000) {
                n3 = 0x40000000;
            }
            for (n2 = a.arrayLength((Object[])((HashMap)this).table); n2 < n3; n2 <<= 1) {
            }
            if (n2 > a.arrayLength((Object[])((HashMap)this).table)) {
                this.resize(n2);
            }
        }
        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)g.convertForCast(iterator.next(), Map.Entry.class);
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        Entry<K, V> entry = this.removeEntryForKey(object);
        return (V)(entry == null ? null : ((Entry)entry).value);
    }

    final Entry<K, V> removeEntryForKey(Object object) {
        Entry entry;
        if (((HashMap)this).size == 0) {
            return null;
        }
        int n = object == null ? 0 : this.hash(object);
        int n2 = HashMap.indexFor(n, a.arrayLength((Object[])((HashMap)this).table));
        Entry entry2 = entry = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])((HashMap)this).table, (int)n2), Entry.class);
        while (entry2 != null) {
            Object object2;
            Entry entry3 = ((Entry)entry2).next;
            if (((Entry)entry2).hash == n && (!f.ifAcmp((Object)(object2 = ((Entry)entry2).key), (Object)object) || object != null && object.equals(object2))) {
                HashMap hashMap = this;
                ((HashMap)hashMap).modCount = ((HashMap)hashMap).modCount + 1;
                HashMap hashMap2 = this;
                ((HashMap)hashMap2).size = ((HashMap)hashMap2).size - 1;
                if (!f.ifAcmp((Object)entry, (Object)entry2)) {
                    a.arrayStore((Object[])((HashMap)this).table, (int)n2, (Object)entry3);
                } else {
                    ((Entry)entry).next = entry3;
                }
                entry2.recordRemoval(this);
                return entry2;
            }
            entry = entry2;
            entry2 = entry3;
        }
        return entry2;
    }

    final Entry<K, V> removeMapping(Object object) {
        Entry entry;
        if (((HashMap)this).size == 0 || !(g.convertForInstanceOf((Object)object, Map.Entry.class) instanceof Map.Entry)) {
            return null;
        }
        Map.Entry entry2 = (Map.Entry)g.convertForCast((Object)object, Map.Entry.class);
        Object k = entry2.getKey();
        int n = k == null ? 0 : this.hash(k);
        int n2 = HashMap.indexFor(n, a.arrayLength((Object[])((HashMap)this).table));
        Entry entry3 = entry = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])((HashMap)this).table, (int)n2), Entry.class);
        while (entry3 != null) {
            Entry entry4 = ((Entry)entry3).next;
            if (((Entry)entry3).hash == n && entry3.equals(entry2)) {
                HashMap hashMap = this;
                ((HashMap)hashMap).modCount = ((HashMap)hashMap).modCount + 1;
                HashMap hashMap2 = this;
                ((HashMap)hashMap2).size = ((HashMap)hashMap2).size - 1;
                if (!f.ifAcmp((Object)entry, (Object)entry3)) {
                    a.arrayStore((Object[])((HashMap)this).table, (int)n2, (Object)entry4);
                } else {
                    ((Entry)entry).next = entry4;
                }
                entry3.recordRemoval(this);
                return entry3;
            }
            entry = entry3;
            entry3 = entry4;
        }
        return entry3;
    }

    @Override
    public void clear() {
        HashMap hashMap = this;
        ((HashMap)hashMap).modCount = ((HashMap)hashMap).modCount + 1;
        Arrays.fill(((HashMap)this).table, null);
        ((HashMap)this).size = 0;
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            return this.containsNullValue();
        }
        Object[] objectArray = ((HashMap)this).table;
        for (int i = 0; i < a.arrayLength((Object[])objectArray); ++i) {
            Entry entry = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), Entry.class);
            while (entry != null) {
                if (object.equals(((Entry)entry).value)) {
                    return true;
                }
                entry = ((Entry)entry).next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Object[] objectArray = ((HashMap)this).table;
        for (int i = 0; i < a.arrayLength((Object[])objectArray); ++i) {
            Entry entry = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), Entry.class);
            while (entry != null) {
                if (((Entry)entry).value == null) {
                    return true;
                }
                entry = ((Entry)entry).next;
            }
        }
        return false;
    }

    @Override
    public Object clone() {
        HashMap hashMap = null;
        try {
            hashMap = (HashMap)g.convertForCast((Object)super.clone(), HashMap.class);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (f.ifAcmp((Object)((HashMap)hashMap).table, EMPTY_TABLE)) {
            hashMap.inflateTable(Math.min((int)Math.min((float)((HashMap)this).size * Math.min(1.0f / ((HashMap)this).loadFactor, 4.0f), 1.0737418E9f), a.arrayLength((Object[])((HashMap)this).table)));
        }
        hashMap.entrySet = null;
        ((HashMap)hashMap).modCount = 0;
        ((HashMap)hashMap).size = 0;
        hashMap.init();
        hashMap.putAllForCreate(this);
        return hashMap;
    }

    void addEntry(int n, K k, V v, int n2) {
        if (((HashMap)this).size >= ((HashMap)this).threshold && f.ifAcmp(null, (Object)((Entry)g.convertForCast((Object)a.arrayLoad((Object[])((HashMap)this).table, (int)n2), Entry.class)))) {
            this.resize(2 * a.arrayLength((Object[])((HashMap)this).table));
            n = f.ifAcmp(null, k) ? this.hash(k) : 0;
            n2 = HashMap.indexFor(n, a.arrayLength((Object[])((HashMap)this).table));
        }
        this.createEntry(n, k, v, n2);
    }

    void createEntry(int n, K k, V v, int n2) {
        Entry entry = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])((HashMap)this).table, (int)n2), Entry.class);
        a.arrayStore((Object[])((HashMap)this).table, (int)n2, (Object)new Entry(n, k, v, entry));
        HashMap hashMap = this;
        ((HashMap)hashMap).size = ((HashMap)hashMap).size + 1;
    }

    Iterator<K> newKeyIterator() {
        return new KeyIterator();
    }

    Iterator<V> newValueIterator() {
        return new ValueIterator();
    }

    Iterator<Map.Entry<K, V>> newEntryIterator() {
        return new EntryIterator();
    }

    @Override
    public Set<K> keySet() {
        Set set;
        Set set2 = HashMap._jr$ig$keySet(this);
        if (set2 != null) {
            set = set2;
        } else {
            KeySet keySet = new KeySet();
            set = keySet;
            HashMap._jr$ip$keySet(this, keySet);
        }
        return set;
    }

    @Override
    public Collection<V> values() {
        Collection collection;
        Collection collection2 = HashMap._jr$ig$values(this);
        if (collection2 != null) {
            collection = collection2;
        } else {
            Values values = new Values();
            collection = values;
            HashMap._jr$ip$values(this, values);
        }
        return collection;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet0();
    }

    private Set<Map.Entry<K, V>> entrySet0() {
        Set set;
        Set set2 = this.entrySet;
        if (set2 != null) {
            set = set2;
        } else {
            EntrySet entrySet = new EntrySet();
            set = entrySet;
            this.entrySet = entrySet;
        }
        return set;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (!f.ifAcmp((Object)((HashMap)this).table, EMPTY_TABLE)) {
            objectOutputStream.writeInt(HashMap.roundUpToPowerOf2(((HashMap)this).threshold));
        } else {
            objectOutputStream.writeInt(a.arrayLength((Object[])((HashMap)this).table));
        }
        objectOutputStream.writeInt(((HashMap)this).size);
        if (((HashMap)this).size > 0) {
            Iterator<Map.Entry<K, V>> iterator = this.entrySet0().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)g.convertForCast(iterator.next(), Map.Entry.class);
                objectOutputStream.writeObject(entry.getKey());
                objectOutputStream.writeObject(entry.getValue());
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (((HashMap)this).loadFactor <= 0.0f || Float.isNaN(((HashMap)this).loadFactor)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidObjectException("Illegal load factor: " + ((HashMap)this).loadFactor));
        }
        ((HashMap)this).table = (Entry[])g.convertForCast(HashMap.EMPTY_TABLE, Entry[].class);
        objectInputStream.readInt();
        int n = objectInputStream.readInt();
        if (n < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidObjectException("Illegal mappings count: " + n));
        }
        int n2 = (int)Math.min((float)n * Math.min(1.0f / ((HashMap)this).loadFactor, 4.0f), 1.0737418E9f);
        if (n > 0) {
            this.inflateTable(n2);
        } else {
            ((HashMap)this).threshold = n2;
        }
        this.init();
        for (int i = 0; i < n; ++i) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.putForCreate(object, object2);
        }
    }

    int capacity() {
        return a.arrayLength((Object[])((HashMap)this).table);
    }

    float loadFactor() {
        return ((HashMap)this).loadFactor;
    }

    static /* synthetic */ void _jr$ip$loadFactor(Object object, float f2) {
        ((HashMap)object).loadFactor = f2;
    }

    protected /* synthetic */ HashMap(h h2) {
        super(h2);
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    static class Entry
    extends h
    implements Map.Entry {
        final K key;
        V value;
        Entry<K, V> next;
        int hash;

        Entry(int n, K k, V v, Entry<K, V> entry) {
            this.value = v;
            this.next = entry;
            this.key = k;
            this.hash = n;
        }

        @Override
        public final K getKey() {
            return ((Entry)this).key;
        }

        @Override
        public final V getValue() {
            return ((Entry)this).value;
        }

        @Override
        public final V setValue(V v) {
            Object object = ((Entry)this).value;
            ((Entry)this).value = v;
            return object;
        }

        @Override
        public final boolean equals(Object object) {
            Object v;
            Object v2;
            Object k;
            if (!(g.convertForInstanceOf((Object)object, Map.Entry.class) instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)g.convertForCast((Object)object, Map.Entry.class);
            Object k2 = this.getKey();
            return (!f.ifAcmp(k2, k = entry.getKey()) || k2 != null && k2.equals(k)) && (!f.ifAcmp(v2 = this.getValue(), v = entry.getValue()) || v2 != null && v2.equals(v));
        }

        @Override
        public final int hashCode() {
            return Objects.hashCode(this.getKey()) ^ Objects.hashCode(this.getValue());
        }

        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        void recordAccess(HashMap<K, V> hashMap) {
        }

        void recordRemoval(HashMap<K, V> hashMap) {
        }

        static /* synthetic */ void _jr$ip$key(Object object, Object object2) {
            ((Entry)object).key = object2;
        }

        protected /* synthetic */ Entry(h h2) {
            super(h2);
        }
    }

    private final class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        private EntryIterator() {
            super(HashMap.this);
        }

        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }

        static /* synthetic */ HashMap _jr$ig$this$0(Object object) {
            return ((EntryIterator)object).HashMap.this;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, HashMap hashMap) {
            ((EntryIterator)object).HashMap.this = hashMap;
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return HashMap.this.newEntryIterator();
        }

        @Override
        public boolean contains(Object object) {
            if (!(g.convertForInstanceOf((Object)object, Map.Entry.class) instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)g.convertForCast((Object)object, Map.Entry.class);
            Entry entry2 = HashMap.this.getEntry(entry.getKey());
            return entry2 != null && entry2.equals(entry);
        }

        @Override
        public boolean remove(Object object) {
            return HashMap.this.removeMapping(object) != null;
        }

        @Override
        public int size() {
            return ((HashMap)HashMap.this).size;
        }

        @Override
        public void clear() {
            HashMap.this.clear();
        }

        static /* synthetic */ HashMap _jr$ig$this$0(Object object) {
            return ((EntrySet)object).HashMap.this;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, HashMap hashMap) {
            ((EntrySet)object).HashMap.this = hashMap;
        }
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    private abstract class HashIterator
    extends h
    implements Iterator {
        Entry<K, V> next;
        int expectedModCount;
        int index;
        Entry<K, V> current;
        final /* synthetic */ HashMap this$0;

        HashIterator(HashMap hashMap) {
            this.this$0 = hashMap;
            this.expectedModCount = ((HashMap)hashMap).modCount;
            if (((HashMap)hashMap).size > 0) {
                Object[] objectArray = ((HashMap)hashMap).table;
                while (this.index < a.arrayLength((Object[])objectArray) && (this.next = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)this.index++), Entry.class)) == null) {
                }
            }
        }

        @Override
        public final boolean hasNext() {
            return ((HashIterator)this).next != null;
        }

        final Entry<K, V> nextEntry() {
            if (((HashMap)((HashIterator)this).this$0).modCount != ((HashIterator)this).expectedModCount) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
            }
            Entry entry = ((HashIterator)this).next;
            if (entry == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
            }
            Entry entry2 = ((Entry)entry).next;
            ((HashIterator)this).next = entry2;
            if (entry2 == null) {
                Object[] objectArray = ((HashMap)((HashIterator)this).this$0).table;
                while (((HashIterator)this).index < a.arrayLength((Object[])objectArray)) {
                    HashIterator hashIterator = this;
                    int n = ((HashIterator)hashIterator).index;
                    ((HashIterator)hashIterator).index = n + 1;
                    Entry entry3 = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)n), Entry.class);
                    ((HashIterator)this).next = entry3;
                    if (entry3 == null) continue;
                }
            }
            ((HashIterator)this).current = entry;
            return entry;
        }

        @Override
        public void remove() {
            if (((HashIterator)this).current == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException());
            }
            if (((HashMap)((HashIterator)this).this$0).modCount != ((HashIterator)this).expectedModCount) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
            }
            Object object = ((Entry)((HashIterator)this).current).key;
            ((HashIterator)this).current = null;
            ((HashIterator)this).this$0.removeEntryForKey(object);
            ((HashIterator)this).expectedModCount = ((HashMap)((HashIterator)this).this$0).modCount;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, HashMap hashMap) {
            ((HashIterator)object).this$0 = hashMap;
        }

        protected /* synthetic */ HashIterator(h h2) {
            super(h2);
        }
    }

    private static class Holder
    extends h {
        static final int ALTERNATIVE_HASHING_THRESHOLD;

        private Holder() {
        }

        static {
            int n;
            String string = (String)AccessController.doPrivileged(new GetPropertyAction("jdk.map.althashing.threshold"));
            try {
                int n2 = n = f.ifAcmp(null, (Object)string) ? Integer.parseInt(string) : Integer.MAX_VALUE;
                if (n == -1) {
                    n = Integer.MAX_VALUE;
                }
                if (n < 0) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("value must be positive integer."));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Error("Illegal value for 'jdk.map.althashing.threshold'", illegalArgumentException));
            }
            ALTERNATIVE_HASHING_THRESHOLD = n;
        }

        protected /* synthetic */ Holder(h h2) {
            super(h2);
        }
    }

    private final class KeyIterator
    extends HashIterator<K> {
        private KeyIterator() {
            super(HashMap.this);
        }

        public K next() {
            return this.nextEntry().getKey();
        }

        static /* synthetic */ HashMap _jr$ig$this$0(Object object) {
            return ((KeyIterator)object).HashMap.this;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, HashMap hashMap) {
            ((KeyIterator)object).HashMap.this = hashMap;
        }
    }

    private final class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return HashMap.this.newKeyIterator();
        }

        @Override
        public int size() {
            return ((HashMap)HashMap.this).size;
        }

        @Override
        public boolean contains(Object object) {
            return HashMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return HashMap.this.removeEntryForKey(object) != null;
        }

        @Override
        public void clear() {
            HashMap.this.clear();
        }

        static /* synthetic */ HashMap _jr$ig$this$0(Object object) {
            return ((KeySet)object).HashMap.this;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, HashMap hashMap) {
            ((KeySet)object).HashMap.this = hashMap;
        }
    }

    private final class ValueIterator
    extends HashIterator<V> {
        private ValueIterator() {
            super(HashMap.this);
        }

        public V next() {
            return ((Entry)this.nextEntry()).value;
        }

        static /* synthetic */ HashMap _jr$ig$this$0(Object object) {
            return ((ValueIterator)object).HashMap.this;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, HashMap hashMap) {
            ((ValueIterator)object).HashMap.this = hashMap;
        }
    }

    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return HashMap.this.newValueIterator();
        }

        @Override
        public int size() {
            return ((HashMap)HashMap.this).size;
        }

        @Override
        public boolean contains(Object object) {
            return HashMap.this.containsValue(object);
        }

        @Override
        public void clear() {
            HashMap.this.clear();
        }

        static /* synthetic */ HashMap _jr$ig$this$0(Object object) {
            return ((Values)object).HashMap.this;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, HashMap hashMap) {
            ((Values)object).HashMap.this = hashMap;
        }
    }
}

