/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.security.AccessController;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import sun.misc.Hashing;
import sun.misc.VM;
import sun.security.action.GetPropertyAction;

public class Hashtable<K, V>
extends Dictionary<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private transient Entry<K, V>[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private transient int modCount;
    private static final long serialVersionUID = 1421746759512286392L;
    static final int ALTERNATIVE_HASHING_THRESHOLD_DEFAULT = Integer.MAX_VALUE;
    transient int hashSeed;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private volatile transient Set<K> keySet;
    private volatile transient Set<Map.Entry<K, V>> entrySet;
    private volatile transient Collection<V> values;
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;

    final boolean initHashSeedAsNeeded(int n) {
        boolean bl;
        boolean bl2 = ((Hashtable)this).hashSeed != 0;
        boolean bl3 = bl2 ^ (bl = VM.isBooted() && n >= Holder.ALTERNATIVE_HASHING_THRESHOLD);
        if (bl3) {
            ((Hashtable)this).hashSeed = bl ? Hashing.randomHashSeed(this) : 0;
        }
        return bl3;
    }

    private int hash(Object object) {
        return ((Hashtable)this).hashSeed ^ object.hashCode();
    }

    public Hashtable(int n, float f2) {
        this.modCount = 0;
        this.keySet = null;
        this.entrySet = null;
        this.values = null;
        if (n < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Illegal Capacity: " + n));
        }
        if (f2 <= 0.0f || Float.isNaN(f2)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Illegal Load: " + f2));
        }
        if (n == 0) {
            n = 1;
        }
        this.loadFactor = f2;
        this.table = new Entry[n];
        this.threshold = (int)Math.min((float)n * f2, 2.1474836E9f);
        this.initHashSeedAsNeeded(n);
    }

    public Hashtable(int n) {
        this(n, 0.75f);
    }

    public Hashtable() {
        this(11, 0.75f);
    }

    public Hashtable(Map<? extends K, ? extends V> map) {
        this(Math.max(2 * map.size(), 11), 0.75f);
        this.putAll(map);
    }

    @Override
    @af(modifiers=33)
    public int size() {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                return this.count;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    @af(modifiers=33)
    public boolean isEmpty() {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                return this.count == 0;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    @af(modifiers=33)
    public Enumeration<K> keys() {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                return this.getEnumeration(0);
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    @af(modifiers=33)
    public Enumeration<V> elements() {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                return this.getEnumeration(1);
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @af(modifiers=33)
    public boolean contains(Object object) {
        Object object2 = ah.getMonitor((Object)this);
        synchronized (object2) {
            try {
                if (object == null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
                }
                Object[] objectArray = this.table;
                int n = a.arrayLength((Object[])objectArray);
                while (n-- > 0) {
                    Entry entry = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)n), Entry.class);
                    while (entry != null) {
                        if (((Entry)entry).value.equals(object)) {
                            return true;
                        }
                        entry = ((Entry)entry).next;
                    }
                }
                return false;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    public boolean containsValue(Object object) {
        return this.contains(object);
    }

    @Override
    @af(modifiers=33)
    public boolean containsKey(Object object) {
        Object object2 = ah.getMonitor((Object)this);
        synchronized (object2) {
            try {
                Object[] objectArray = this.table;
                int n = this.hash(object);
                int n2 = (n & Integer.MAX_VALUE) % a.arrayLength((Object[])objectArray);
                Entry entry = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)n2), Entry.class);
                while (entry != null) {
                    if (((Entry)entry).hash == n && ((Entry)entry).key.equals(object)) {
                        return true;
                    }
                    entry = ((Entry)entry).next;
                }
                return false;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    @af(modifiers=33)
    public V get(Object object) {
        Object object2 = ah.getMonitor((Object)this);
        synchronized (object2) {
            try {
                Object[] objectArray = this.table;
                int n = this.hash(object);
                int n2 = (n & Integer.MAX_VALUE) % a.arrayLength((Object[])objectArray);
                Entry entry = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)n2), Entry.class);
                while (entry != null) {
                    if (((Entry)entry).hash == n && ((Entry)entry).key.equals(object)) {
                        return (V)((Entry)entry).value;
                    }
                    entry = ((Entry)entry).next;
                }
                return null;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    protected void rehash() {
        int n = a.arrayLength((Object[])this.table);
        Object[] objectArray = this.table;
        int n2 = (n << 1) + 1;
        if (n2 - 0x7FFFFFF7 > 0) {
            if (n == 0x7FFFFFF7) {
                return;
            }
            n2 = 0x7FFFFFF7;
        }
        Object[] objectArray2 = new Entry[n2];
        Hashtable hashtable = this;
        hashtable.modCount = hashtable.modCount + 1;
        this.threshold = (int)Math.min((float)n2 * this.loadFactor, 2.1474836E9f);
        boolean bl = this.initHashSeedAsNeeded(n2);
        this.table = (Entry[])objectArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)n3), Entry.class);
            while (entry != null) {
                Entry entry2 = entry;
                entry = ((Entry)entry).next;
                if (bl) {
                    ((Entry)entry2).hash = this.hash(((Entry)entry2).key);
                }
                int n4 = (((Entry)entry2).hash & Integer.MAX_VALUE) % n2;
                ((Entry)entry2).next = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])objectArray2, (int)n4), Entry.class);
                a.arrayStore((Object[])objectArray2, (int)n4, (Object)entry2);
            }
        }
    }

    @Override
    @af(modifiers=33)
    public V put(K k, V v) {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (v == null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
                }
                Object[] objectArray = this.table;
                int n = this.hash(k);
                int n2 = (n & Integer.MAX_VALUE) % a.arrayLength((Object[])objectArray);
                Entry entry = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)n2), Entry.class);
                while (entry != null) {
                    if (((Entry)entry).hash == n && ((Entry)entry).key.equals(k)) {
                        Object object2 = ((Entry)entry).value;
                        ((Entry)entry).value = v;
                        return (V)object2;
                    }
                    entry = ((Entry)entry).next;
                }
                Hashtable hashtable = this;
                hashtable.modCount = hashtable.modCount + 1;
                if (this.count >= this.threshold) {
                    this.rehash();
                    objectArray = this.table;
                    n = this.hash(k);
                    n2 = (n & Integer.MAX_VALUE) % a.arrayLength((Object[])objectArray);
                }
                entry = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)n2), Entry.class);
                a.arrayStore((Object[])objectArray, (int)n2, (Object)new Entry(n, k, v, entry));
                Hashtable hashtable2 = this;
                hashtable2.count = hashtable2.count + 1;
                return null;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    @af(modifiers=33)
    public V remove(Object object) {
        Object object2 = ah.getMonitor((Object)this);
        synchronized (object2) {
            try {
                Object[] objectArray = this.table;
                int n = this.hash(object);
                int n2 = (n & Integer.MAX_VALUE) % a.arrayLength((Object[])objectArray);
                Entry entry = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)n2), Entry.class);
                Entry entry2 = null;
                while (entry != null) {
                    if (((Entry)entry).hash == n && ((Entry)entry).key.equals(object)) {
                        Hashtable hashtable = this;
                        hashtable.modCount = hashtable.modCount + 1;
                        if (entry2 != null) {
                            ((Entry)entry2).next = ((Entry)entry).next;
                        } else {
                            a.arrayStore((Object[])objectArray, (int)n2, (Object)((Entry)entry).next);
                        }
                        Hashtable hashtable2 = this;
                        hashtable2.count = hashtable2.count - 1;
                        Object object3 = ((Entry)entry).value;
                        ((Entry)entry).value = null;
                        return (V)object3;
                    }
                    entry2 = entry;
                    entry = ((Entry)entry).next;
                }
                return null;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    @af(modifiers=33)
    public void putAll(Map<? extends K, ? extends V> map) {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)g.convertForCast(iterator.next(), Map.Entry.class);
                    this.put(entry.getKey(), entry.getValue());
                }
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    @af(modifiers=33)
    public void clear() {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                Object[] objectArray = this.table;
                Hashtable hashtable = this;
                hashtable.modCount = hashtable.modCount + 1;
                int n = a.arrayLength((Object[])objectArray);
                while (--n >= 0) {
                    a.arrayStore((Object[])objectArray, (int)n, null);
                }
                this.count = 0;
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @af(modifiers=33)
    public Object clone() {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                try {
                    Hashtable hashtable = (Hashtable)g.convertForCast((Object)super.clone(), Hashtable.class);
                    hashtable.table = new Entry[a.arrayLength((Object[])this.table)];
                    int n = a.arrayLength((Object[])this.table);
                    while (n-- > 0) {
                        a.arrayStore((Object[])hashtable.table, (int)n, (Entry)g.convertForCast((Object)a.arrayLoad((Object[])this.table, (int)n), Entry.class) != null ? (Entry)g.convertForCast((Object)((Entry)g.convertForCast((Object)a.arrayLoad((Object[])this.table, (int)n), Entry.class)).clone(), Entry.class) : null);
                    }
                    hashtable.keySet = null;
                    hashtable.entrySet = null;
                    hashtable.values = null;
                    hashtable.modCount = 0;
                    return hashtable;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @af(modifiers=33)
    public String toString() {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                int n = this.size() - 1;
                if (n == -1) {
                    return "{}";
                }
                StringBuilder stringBuilder = new StringBuilder();
                Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
                stringBuilder.append('{');
                int n2 = 0;
                while (true) {
                    Map.Entry entry = (Map.Entry)g.convertForCast(iterator.next(), Map.Entry.class);
                    Object k = entry.getKey();
                    Object v = entry.getValue();
                    stringBuilder.append(!f.ifAcmp(k, (Object)this) ? "(this Map)" : k.toString());
                    stringBuilder.append('=');
                    stringBuilder.append(!f.ifAcmp(v, (Object)this) ? "(this Map)" : v.toString());
                    if (n2 == n) {
                        return stringBuilder.append('}').toString();
                    }
                    stringBuilder.append(", ");
                    ++n2;
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    private <T> Enumeration<T> getEnumeration(int n) {
        if (this.count == 0) {
            return Collections.emptyEnumeration();
        }
        return new Enumerator(this, n, false);
    }

    private <T> Iterator<T> getIterator(int n) {
        if (this.count == 0) {
            return Collections.emptyIterator();
        }
        return new Enumerator(this, n, true);
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = Collections.synchronizedSet(new KeySet(this), this);
        }
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = Collections.synchronizedSet(new EntrySet(this), this);
        }
        return this.entrySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = Collections.synchronizedCollection(new ValueCollection(this), this);
        }
        return this.values;
    }

    @Override
    @af(modifiers=33)
    public boolean equals(Object object) {
        Object object2 = ah.getMonitor((Object)this);
        synchronized (object2) {
            try {
                if (!f.ifAcmp((Object)object, (Object)this)) {
                    return true;
                }
                if (!(g.convertForInstanceOf((Object)object, Map.class) instanceof Map)) {
                    return false;
                }
                Map map = (Map)g.convertForCast((Object)object, Map.class);
                if (map.size() != this.size()) {
                    return false;
                }
                try {
                    Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)g.convertForCast(iterator.next(), Map.Entry.class);
                        Object k = entry.getKey();
                        Object v = entry.getValue();
                        if (v == null) {
                            if (map.get(k) == null && map.containsKey(k)) continue;
                            return false;
                        }
                        if (v.equals(map.get(k))) continue;
                        return false;
                    }
                }
                catch (ClassCastException classCastException) {
                    return false;
                }
                catch (NullPointerException nullPointerException) {
                    return false;
                }
                return true;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    @af(modifiers=33)
    public int hashCode() {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                Object[] objectArray;
                int n = 0;
                if (this.count == 0 || this.loadFactor < 0.0f) {
                    return n;
                }
                this.loadFactor = -this.loadFactor;
                Object[] objectArray2 = objectArray = this.table;
                int n2 = a.arrayLength((Object[])objectArray2);
                for (int i = 0; i < n2; ++i) {
                    Entry entry = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])objectArray2, (int)i), Entry.class);
                    while (entry != null) {
                        n += entry.hashCode();
                        entry = ((Entry)entry).next;
                    }
                }
                this.loadFactor = -this.loadFactor;
                return n;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Entry entry = null;
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                objectOutputStream.defaultWriteObject();
                objectOutputStream.writeInt(a.arrayLength((Object[])this.table));
                objectOutputStream.writeInt(this.count);
                for (int i = 0; i < a.arrayLength((Object[])this.table); ++i) {
                    Entry entry2 = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])this.table, (int)i), Entry.class);
                    while (entry2 != null) {
                        entry = new Entry(0, ((Entry)entry2).key, ((Entry)entry2).value, entry);
                        entry2 = ((Entry)entry2).next;
                    }
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        while (entry != null) {
            objectOutputStream.writeObject(((Entry)entry).key);
            objectOutputStream.writeObject(((Entry)entry).value);
            entry = ((Entry)entry).next;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        int n3 = (int)((float)n2 * this.loadFactor) + n2 / 20 + 3;
        if (n3 > n2 && (n3 & 1) == 0) {
            --n3;
        }
        if (n > 0 && n3 > n) {
            n3 = n;
        }
        Entry[] entryArray = new Entry[n3];
        this.threshold = (int)Math.min((float)n3 * this.loadFactor, 2.1474836E9f);
        this.count = 0;
        this.initHashSeedAsNeeded(n3);
        while (n2 > 0) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.reconstitutionPut(entryArray, object, object2);
            --n2;
        }
        this.table = entryArray;
    }

    private void reconstitutionPut(Entry<K, V>[] entryArray, K k, V v) throws StreamCorruptedException {
        if (v == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new StreamCorruptedException());
        }
        int n = this.hash(k);
        int n2 = (n & Integer.MAX_VALUE) % a.arrayLength((Object[])entryArray);
        Entry entry = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])entryArray, (int)n2), Entry.class);
        while (entry != null) {
            if (((Entry)entry).hash == n && ((Entry)entry).key.equals(k)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new StreamCorruptedException());
            }
            entry = ((Entry)entry).next;
        }
        entry = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])entryArray, (int)n2), Entry.class);
        a.arrayStore((Object[])entryArray, (int)n2, (Object)new Entry(n, k, v, entry));
        Hashtable hashtable = this;
        hashtable.count = hashtable.count + 1;
    }

    static /* synthetic */ int access$608(Hashtable hashtable) {
        Hashtable hashtable2 = hashtable;
        int n = hashtable2.modCount;
        hashtable2.modCount = n + 1;
        return n;
    }

    static /* synthetic */ int access$210(Hashtable hashtable) {
        Hashtable hashtable2 = hashtable;
        int n = hashtable2.count;
        hashtable2.count = n - 1;
        return n;
    }

    protected /* synthetic */ Hashtable(h h2) {
        super(h2);
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    private static class Entry
    extends h
    implements Map.Entry {
        int hash;
        final K key;
        V value;
        Entry<K, V> next;

        protected Entry(int n, K k, V v, Entry<K, V> entry) {
            this.hash = n;
            this.key = k;
            this.value = v;
            this.next = entry;
        }

        protected Object clone() {
            return new Entry(((Entry)this).hash, ((Entry)this).key, ((Entry)this).value, ((Entry)this).next == null ? null : (Entry)g.convertForCast((Object)((Entry)this).next.clone(), Entry.class));
        }

        @Override
        public K getKey() {
            return ((Entry)this).key;
        }

        @Override
        public V getValue() {
            return ((Entry)this).value;
        }

        @Override
        public V setValue(V v) {
            if (v == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
            }
            Object object = ((Entry)this).value;
            ((Entry)this).value = v;
            return object;
        }

        @Override
        public boolean equals(Object object) {
            if (!(g.convertForInstanceOf((Object)object, Map.Entry.class) instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)g.convertForCast((Object)object, Map.Entry.class);
            return ((Entry)this).key.equals(entry.getKey()) && ((Entry)this).value.equals(entry.getValue());
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(((Entry)this).key) ^ Objects.hashCode(((Entry)this).value);
        }

        public String toString() {
            return ((Entry)this).key.toString() + "=" + ((Entry)this).value.toString();
        }

        static /* synthetic */ void _jr$ip$key(Object object, Object object2) {
            ((Entry)object).key = object2;
        }

        protected /* synthetic */ Entry(h h2) {
            super(h2);
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        final /* synthetic */ Hashtable this$0;

        private EntrySet(Hashtable hashtable) {
            this.this$0 = hashtable;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return ((EntrySet)this).this$0.getIterator(2);
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            return super.add(entry);
        }

        @Override
        public boolean contains(Object object) {
            if (!(g.convertForInstanceOf((Object)object, Map.Entry.class) instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)g.convertForCast((Object)object, Map.Entry.class);
            Object k = entry.getKey();
            Object[] objectArray = ((EntrySet)this).this$0.table;
            int n = ((EntrySet)this).this$0.hash(k);
            int n2 = (n & Integer.MAX_VALUE) % a.arrayLength((Object[])objectArray);
            Entry entry2 = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)n2), Entry.class);
            while (entry2 != null) {
                if (((Entry)entry2).hash == n && entry2.equals(entry)) {
                    return true;
                }
                entry2 = ((Entry)entry2).next;
            }
            return false;
        }

        @Override
        public boolean remove(Object object) {
            if (!(g.convertForInstanceOf((Object)object, Map.Entry.class) instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)g.convertForCast((Object)object, Map.Entry.class);
            Object k = entry.getKey();
            Object[] objectArray = ((EntrySet)this).this$0.table;
            int n = ((EntrySet)this).this$0.hash(k);
            int n2 = (n & Integer.MAX_VALUE) % a.arrayLength((Object[])objectArray);
            Entry entry2 = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)n2), Entry.class);
            Entry entry3 = null;
            while (entry2 != null) {
                if (((Entry)entry2).hash == n && entry2.equals(entry)) {
                    Hashtable.access$608(((EntrySet)this).this$0);
                    if (entry3 != null) {
                        ((Entry)entry3).next = ((Entry)entry2).next;
                    } else {
                        a.arrayStore((Object[])objectArray, (int)n2, (Object)((Entry)entry2).next);
                    }
                    Hashtable.access$210(((EntrySet)this).this$0);
                    ((Entry)entry2).value = null;
                    return true;
                }
                entry3 = entry2;
                entry2 = ((Entry)entry2).next;
            }
            return false;
        }

        @Override
        public int size() {
            return ((EntrySet)this).this$0.count;
        }

        @Override
        public void clear() {
            ((EntrySet)this).this$0.clear();
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, Hashtable hashtable) {
            ((EntrySet)object).this$0 = hashtable;
        }

        protected /* synthetic */ EntrySet(h h2) {
            super(h2);
        }
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    private class Enumerator
    extends h
    implements Enumeration,
    Iterator {
        Entry[] table;
        int index;
        Entry<K, V> entry;
        Entry<K, V> lastReturned;
        int type;
        boolean iterator;
        protected int expectedModCount;
        final /* synthetic */ Hashtable this$0;

        Enumerator(Hashtable hashtable, int n, boolean bl) {
            this.this$0 = hashtable;
            this.table = this.this$0.table;
            this.index = a.arrayLength((Object[])this.table);
            this.entry = null;
            this.lastReturned = null;
            this.expectedModCount = this.this$0.modCount;
            this.type = n;
            this.iterator = bl;
        }

        @Override
        public boolean hasMoreElements() {
            Entry entry = ((Enumerator)this).entry;
            int n = ((Enumerator)this).index;
            Object[] objectArray = ((Enumerator)this).table;
            while (entry == null && n > 0) {
                entry = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)(--n)), Entry.class);
            }
            ((Enumerator)this).entry = entry;
            ((Enumerator)this).index = n;
            return entry != null;
        }

        public T nextElement() {
            Entry entry = ((Enumerator)this).entry;
            int n = ((Enumerator)this).index;
            Object[] objectArray = ((Enumerator)this).table;
            while (entry == null && n > 0) {
                entry = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)(--n)), Entry.class);
            }
            ((Enumerator)this).entry = entry;
            ((Enumerator)this).index = n;
            if (entry != null) {
                Entry entry2 = ((Enumerator)this).entry;
                ((Enumerator)this).lastReturned = entry2;
                Entry entry3 = entry2;
                ((Enumerator)this).entry = ((Entry)entry3).next;
                return ((Enumerator)this).type == 0 ? ((Entry)entry3).key : (((Enumerator)this).type == 1 ? ((Entry)entry3).value : entry3);
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException("Hashtable Enumerator"));
        }

        @Override
        public boolean hasNext() {
            return this.hasMoreElements();
        }

        public T next() {
            if (((Enumerator)this).this$0.modCount != ((Enumerator)this).expectedModCount) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
            }
            return this.nextElement();
        }

        @Override
        public void remove() {
            if (!((Enumerator)this).iterator) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
            }
            if (((Enumerator)this).lastReturned == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("Hashtable Enumerator"));
            }
            if (((Enumerator)this).this$0.modCount != ((Enumerator)this).expectedModCount) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
            }
            Object object = ah.getMonitor((Object)((Enumerator)this).this$0);
            synchronized (object) {
                try {
                    Object[] objectArray = ((Enumerator)this).this$0.table;
                    int n = (((Entry)((Enumerator)this).lastReturned).hash & Integer.MAX_VALUE) % a.arrayLength((Object[])objectArray);
                    Entry entry = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)n), Entry.class);
                    Entry entry2 = null;
                    while (entry != null) {
                        if (!f.ifAcmp((Object)entry, (Object)((Enumerator)this).lastReturned)) {
                            Hashtable.access$608(((Enumerator)this).this$0);
                            Enumerator enumerator = this;
                            ((Enumerator)enumerator).expectedModCount = ((Enumerator)enumerator).expectedModCount + 1;
                            if (entry2 == null) {
                                a.arrayStore((Object[])objectArray, (int)n, (Object)((Entry)entry).next);
                            } else {
                                ((Entry)entry2).next = ((Entry)entry).next;
                            }
                            Hashtable.access$210(((Enumerator)this).this$0);
                            ((Enumerator)this).lastReturned = null;
                            return;
                        }
                        entry2 = entry;
                        entry = ((Entry)entry).next;
                    }
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }

        static /* synthetic */ void _jr$ip$table(Object object, Entry[] entryArray) {
            ((Enumerator)object).table = entryArray;
        }

        static /* synthetic */ void _jr$ip$type(Object object, int n) {
            ((Enumerator)object).type = n;
        }

        static /* synthetic */ void _jr$ip$iterator(Object object, boolean bl) {
            ((Enumerator)object).iterator = bl;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, Hashtable hashtable) {
            ((Enumerator)object).this$0 = hashtable;
        }

        protected /* synthetic */ Enumerator(h h2) {
            super(h2);
        }
    }

    private static class Holder
    extends h {
        static final int ALTERNATIVE_HASHING_THRESHOLD;

        private Holder() {
        }

        static {
            int n;
            String string = (String)AccessController.doPrivileged(new GetPropertyAction("jdk.map.althashing.threshold"));
            try {
                int n2 = n = f.ifAcmp(null, (Object)string) ? Integer.parseInt(string) : Integer.MAX_VALUE;
                if (n == -1) {
                    n = Integer.MAX_VALUE;
                }
                if (n < 0) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("value must be positive integer."));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Error("Illegal value for 'jdk.map.althashing.threshold'", illegalArgumentException));
            }
            ALTERNATIVE_HASHING_THRESHOLD = n;
        }

        protected /* synthetic */ Holder(h h2) {
            super(h2);
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        final /* synthetic */ Hashtable this$0;

        private KeySet(Hashtable hashtable) {
            this.this$0 = hashtable;
        }

        @Override
        public Iterator<K> iterator() {
            return ((KeySet)this).this$0.getIterator(0);
        }

        @Override
        public int size() {
            return ((KeySet)this).this$0.count;
        }

        @Override
        public boolean contains(Object object) {
            return ((KeySet)this).this$0.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return ((KeySet)this).this$0.remove(object) != null;
        }

        @Override
        public void clear() {
            ((KeySet)this).this$0.clear();
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, Hashtable hashtable) {
            ((KeySet)object).this$0 = hashtable;
        }

        protected /* synthetic */ KeySet(h h2) {
            super(h2);
        }
    }

    private class ValueCollection
    extends AbstractCollection<V> {
        final /* synthetic */ Hashtable this$0;

        private ValueCollection(Hashtable hashtable) {
            this.this$0 = hashtable;
        }

        @Override
        public Iterator<V> iterator() {
            return ((ValueCollection)this).this$0.getIterator(1);
        }

        @Override
        public int size() {
            return ((ValueCollection)this).this$0.count;
        }

        @Override
        public boolean contains(Object object) {
            return ((ValueCollection)this).this$0.containsValue(object);
        }

        @Override
        public void clear() {
            ((ValueCollection)this).this$0.clear();
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, Hashtable hashtable) {
            ((ValueCollection)object).this$0 = hashtable;
        }

        protected /* synthetic */ ValueCollection(h h2) {
            super(h2);
        }
    }
}

