/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.facade.w;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class IdentityHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Serializable,
Cloneable {
    private static final int DEFAULT_CAPACITY = 32;
    private static final int MINIMUM_CAPACITY = 4;
    private static final int MAXIMUM_CAPACITY = 0x20000000;
    private transient Object[] table;
    private int size;
    private transient int modCount;
    private transient int threshold;
    private static final Object NULL_KEY = new Object();
    private transient Set<Map.Entry<K, V>> entrySet;
    private static final long serialVersionUID = 8188218128353913216L;

    private static Object maskNull(Object object) {
        return object == null ? NULL_KEY : object;
    }

    private static Object unmaskNull(Object object) {
        return !f.ifAcmp((Object)object, (Object)NULL_KEY) ? null : object;
    }

    public IdentityHashMap() {
        this.entrySet = null;
        this.init(32);
    }

    public IdentityHashMap(int n2) {
        this.entrySet = null;
        if (n2 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("expectedMaxSize is negative: " + n2));
        }
        this.init(this.capacity(n2));
    }

    private int capacity(int n2) {
        int n3;
        int n4 = 3 * n2 / 2;
        if (n4 > 0x20000000 || n4 < 0) {
            n3 = 0x20000000;
        } else {
            for (n3 = 4; n3 < n4; n3 <<= 1) {
            }
        }
        return n3;
    }

    private void init(int n2) {
        this.threshold = n2 * 2 / 3;
        this.table = new Object[2 * n2];
    }

    public IdentityHashMap(Map<? extends K, ? extends V> map) {
        this((int)((double)(1 + map.size()) * 1.1));
        this.putAll(map);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    private static int hash(Object object, int n2) {
        int n3 = w.getIdentityHashCode((Object)object);
        return (n3 << 1) - (n3 << 8) & n2 - 1;
    }

    private static int nextKeyIndex(int n2, int n3) {
        return n2 + 2 < n3 ? n2 + 2 : 0;
    }

    @Override
    public V get(Object object) {
        Object object2 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n2 = a.arrayLength((Object[])objectArray);
        int n3 = IdentityHashMap.hash(object2, n2);
        Object object3;
        while (f.ifAcmp((Object)(object3 = a.arrayLoad((Object[])objectArray, (int)n3)), (Object)object2)) {
            if (object3 == null) {
                return null;
            }
            n3 = IdentityHashMap.nextKeyIndex(n3, n2);
        }
        return (V)a.arrayLoad((Object[])objectArray, (int)(n3 + 1));
    }

    @Override
    public boolean containsKey(Object object) {
        Object object2 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n2 = a.arrayLength((Object[])objectArray);
        int n3 = IdentityHashMap.hash(object2, n2);
        Object object3;
        while (f.ifAcmp((Object)(object3 = a.arrayLoad((Object[])objectArray, (int)n3)), (Object)object2)) {
            if (object3 == null) {
                return false;
            }
            n3 = IdentityHashMap.nextKeyIndex(n3, n2);
        }
        return true;
    }

    @Override
    public boolean containsValue(Object object) {
        Object[] objectArray = this.table;
        for (int i = 1; i < a.arrayLength((Object[])objectArray); i += 2) {
            if (f.ifAcmp((Object)a.arrayLoad((Object[])objectArray, (int)i), (Object)object) || a.arrayLoad((Object[])objectArray, (int)(i - 1)) == null) continue;
            return true;
        }
        return false;
    }

    private boolean containsMapping(Object object, Object object2) {
        Object object3 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n2 = a.arrayLength((Object[])objectArray);
        int n3 = IdentityHashMap.hash(object3, n2);
        Object object4;
        while (f.ifAcmp((Object)(object4 = a.arrayLoad((Object[])objectArray, (int)n3)), (Object)object3)) {
            if (object4 == null) {
                return false;
            }
            n3 = IdentityHashMap.nextKeyIndex(n3, n2);
        }
        return !f.ifAcmp((Object)a.arrayLoad((Object[])objectArray, (int)(n3 + 1)), (Object)object2);
    }

    @Override
    public V put(K k, V v) {
        Object object;
        Object object2 = IdentityHashMap.maskNull(k);
        Object[] objectArray = this.table;
        int n2 = a.arrayLength((Object[])objectArray);
        int n3 = IdentityHashMap.hash(object2, n2);
        while ((object = a.arrayLoad((Object[])objectArray, (int)n3)) != null) {
            if (!f.ifAcmp((Object)object, (Object)object2)) {
                Object object3 = a.arrayLoad((Object[])objectArray, (int)(n3 + 1));
                a.arrayStore((Object[])objectArray, (int)(n3 + 1), v);
                return (V)object3;
            }
            n3 = IdentityHashMap.nextKeyIndex(n3, n2);
        }
        IdentityHashMap identityHashMap = this;
        identityHashMap.modCount = identityHashMap.modCount + 1;
        a.arrayStore((Object[])objectArray, (int)n3, (Object)object2);
        a.arrayStore((Object[])objectArray, (int)(n3 + 1), v);
        IdentityHashMap identityHashMap2 = this;
        int n4 = identityHashMap2.size + 1;
        identityHashMap2.size = n4;
        if (n4 >= this.threshold) {
            this.resize(n2);
        }
        return null;
    }

    private void resize(int n2) {
        int n3 = n2 * 2;
        Object[] objectArray = this.table;
        int n4 = a.arrayLength((Object[])objectArray);
        if (n4 == 0x40000000) {
            if (this.threshold == 0x1FFFFFFF) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("Capacity exhausted."));
            }
            this.threshold = 0x1FFFFFFF;
            return;
        }
        if (n4 >= n3) {
            return;
        }
        Object[] objectArray2 = new Object[n3];
        this.threshold = n3 / 3;
        for (int i = 0; i < n4; i += 2) {
            Object object = a.arrayLoad((Object[])objectArray, (int)i);
            if (object == null) continue;
            Object object2 = a.arrayLoad((Object[])objectArray, (int)(i + 1));
            a.arrayStore((Object[])objectArray, (int)i, null);
            a.arrayStore((Object[])objectArray, (int)(i + 1), null);
            int n5 = IdentityHashMap.hash(object, n3);
            while (a.arrayLoad((Object[])objectArray2, (int)n5) != null) {
                n5 = IdentityHashMap.nextKeyIndex(n5, n3);
            }
            a.arrayStore((Object[])objectArray2, (int)n5, (Object)object);
            a.arrayStore((Object[])objectArray2, (int)(n5 + 1), (Object)object2);
        }
        this.table = objectArray2;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        int n2 = map.size();
        if (n2 == 0) {
            return;
        }
        if (n2 > this.threshold) {
            this.resize(this.capacity(n2));
        }
        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)g.convertForCast(iterator.next(), Map.Entry.class);
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        Object object2 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n2 = a.arrayLength((Object[])objectArray);
        int n3 = IdentityHashMap.hash(object2, n2);
        while (true) {
            Object object3;
            if (!f.ifAcmp((Object)(object3 = a.arrayLoad((Object[])objectArray, (int)n3)), (Object)object2)) {
                IdentityHashMap identityHashMap = this;
                identityHashMap.modCount = identityHashMap.modCount + 1;
                IdentityHashMap identityHashMap2 = this;
                identityHashMap2.size = identityHashMap2.size - 1;
                Object object4 = a.arrayLoad((Object[])objectArray, (int)(n3 + 1));
                a.arrayStore((Object[])objectArray, (int)(n3 + 1), null);
                a.arrayStore((Object[])objectArray, (int)n3, null);
                this.closeDeletion(n3);
                return (V)object4;
            }
            if (object3 == null) {
                return null;
            }
            n3 = IdentityHashMap.nextKeyIndex(n3, n2);
        }
    }

    private boolean removeMapping(Object object, Object object2) {
        Object object3 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n2 = a.arrayLength((Object[])objectArray);
        int n3 = IdentityHashMap.hash(object3, n2);
        while (true) {
            Object object4;
            if (!f.ifAcmp((Object)(object4 = a.arrayLoad((Object[])objectArray, (int)n3)), (Object)object3)) {
                if (f.ifAcmp((Object)a.arrayLoad((Object[])objectArray, (int)(n3 + 1)), (Object)object2)) {
                    return false;
                }
                IdentityHashMap identityHashMap = this;
                identityHashMap.modCount = identityHashMap.modCount + 1;
                IdentityHashMap identityHashMap2 = this;
                identityHashMap2.size = identityHashMap2.size - 1;
                a.arrayStore((Object[])objectArray, (int)n3, null);
                a.arrayStore((Object[])objectArray, (int)(n3 + 1), null);
                this.closeDeletion(n3);
                return true;
            }
            if (object4 == null) {
                return false;
            }
            n3 = IdentityHashMap.nextKeyIndex(n3, n2);
        }
    }

    private void closeDeletion(int n2) {
        Object object;
        Object[] objectArray = this.table;
        int n3 = a.arrayLength((Object[])objectArray);
        int n4 = IdentityHashMap.nextKeyIndex(n2, n3);
        while ((object = a.arrayLoad((Object[])objectArray, (int)n4)) != null) {
            int n5 = IdentityHashMap.hash(object, n3);
            if (n4 < n5 && (n5 <= n2 || n2 <= n4) || n5 <= n2 && n2 <= n4) {
                a.arrayStore((Object[])objectArray, (int)n2, (Object)object);
                a.arrayStore((Object[])objectArray, (int)(n2 + 1), (Object)a.arrayLoad((Object[])objectArray, (int)(n4 + 1)));
                a.arrayStore((Object[])objectArray, (int)n4, null);
                a.arrayStore((Object[])objectArray, (int)(n4 + 1), null);
                n2 = n4;
            }
            n4 = IdentityHashMap.nextKeyIndex(n4, n3);
        }
    }

    @Override
    public void clear() {
        IdentityHashMap identityHashMap = this;
        identityHashMap.modCount = identityHashMap.modCount + 1;
        Object[] objectArray = this.table;
        for (int i = 0; i < a.arrayLength((Object[])objectArray); ++i) {
            a.arrayStore((Object[])objectArray, (int)i, null);
        }
        this.size = 0;
    }

    @Override
    public boolean equals(Object object) {
        if (!f.ifAcmp((Object)object, (Object)this)) {
            return true;
        }
        if (g.convertForInstanceOf((Object)object, IdentityHashMap.class) instanceof IdentityHashMap) {
            IdentityHashMap identityHashMap = (IdentityHashMap)g.convertForCast((Object)object, IdentityHashMap.class);
            if (identityHashMap.size() != this.size) {
                return false;
            }
            Object[] objectArray = identityHashMap.table;
            for (int i = 0; i < a.arrayLength((Object[])objectArray); i += 2) {
                Object object2 = a.arrayLoad((Object[])objectArray, (int)i);
                if (object2 == null || this.containsMapping(object2, a.arrayLoad((Object[])objectArray, (int)(i + 1)))) continue;
                return false;
            }
            return true;
        }
        if (g.convertForInstanceOf((Object)object, Map.class) instanceof Map) {
            Map map = (Map)g.convertForCast((Object)object, Map.class);
            return this.entrySet().equals(map.entrySet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        Object[] objectArray = this.table;
        for (int i = 0; i < a.arrayLength((Object[])objectArray); i += 2) {
            Object object = a.arrayLoad((Object[])objectArray, (int)i);
            if (object == null) continue;
            Object object2 = IdentityHashMap.unmaskNull(object);
            n2 += w.getIdentityHashCode((Object)object2) ^ w.getIdentityHashCode((Object)a.arrayLoad((Object[])objectArray, (int)(i + 1)));
        }
        return n2;
    }

    @Override
    public Object clone() {
        try {
            IdentityHashMap identityHashMap = (IdentityHashMap)g.convertForCast((Object)super.clone(), IdentityHashMap.class);
            identityHashMap.entrySet = null;
            identityHashMap.table = (Object[])g.convertForCast((Object)a.cloneArray((Object)this.table), Object[].class);
            return identityHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
        }
    }

    @Override
    public Set<K> keySet() {
        Set set = IdentityHashMap._jr$ig$keySet(this);
        if (set != null) {
            return set;
        }
        KeySet keySet = new KeySet(this);
        IdentityHashMap._jr$ip$keySet(this, keySet);
        return keySet;
    }

    @Override
    public Collection<V> values() {
        Collection collection = IdentityHashMap._jr$ig$values(this);
        if (collection != null) {
            return collection;
        }
        Values values = new Values(this);
        IdentityHashMap._jr$ip$values(this, values);
        return values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set set = this.entrySet;
        if (set != null) {
            return set;
        }
        EntrySet entrySet = new EntrySet(this);
        this.entrySet = entrySet;
        return entrySet;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        Object[] objectArray = this.table;
        for (int i = 0; i < a.arrayLength((Object[])objectArray); i += 2) {
            Object object = a.arrayLoad((Object[])objectArray, (int)i);
            if (object == null) continue;
            objectOutputStream.writeObject(IdentityHashMap.unmaskNull(object));
            objectOutputStream.writeObject(a.arrayLoad((Object[])objectArray, (int)(i + 1)));
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        this.init(this.capacity(n2 * 4 / 3));
        for (int i = 0; i < n2; ++i) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.putForCreate(object, object2);
        }
    }

    private void putForCreate(K k, V v) throws IOException {
        Object object;
        Object object2 = IdentityHashMap.maskNull(k);
        Object[] objectArray = this.table;
        int n2 = a.arrayLength((Object[])objectArray);
        int n3 = IdentityHashMap.hash(object2, n2);
        while ((object = a.arrayLoad((Object[])objectArray, (int)n3)) != null) {
            if (!f.ifAcmp((Object)object, (Object)object2)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new StreamCorruptedException());
            }
            n3 = IdentityHashMap.nextKeyIndex(n3, n2);
        }
        a.arrayStore((Object[])objectArray, (int)n3, (Object)object2);
        a.arrayStore((Object[])objectArray, (int)(n3 + 1), v);
    }

    static /* synthetic */ int access$204(IdentityHashMap identityHashMap) {
        IdentityHashMap identityHashMap2 = identityHashMap;
        int n2 = identityHashMap2.modCount + 1;
        identityHashMap2.modCount = n2;
        return n2;
    }

    static /* synthetic */ int access$010(IdentityHashMap identityHashMap) {
        IdentityHashMap identityHashMap2 = identityHashMap;
        int n2 = identityHashMap2.size;
        identityHashMap2.size = n2 - 1;
        return n2;
    }

    protected /* synthetic */ IdentityHashMap(h h2) {
        super(h2);
    }

    private class EntryIterator
    extends IdentityHashMapIterator<Map.Entry<K, V>> {
        private java.util.IdentityHashMap$EntryIterator.Entry lastReturnedEntry;
        final /* synthetic */ IdentityHashMap this$0;

        private EntryIterator(IdentityHashMap identityHashMap) {
            this.this$0 = identityHashMap;
            super(identityHashMap);
            this.lastReturnedEntry = null;
        }

        public Map.Entry<K, V> next() {
            this.lastReturnedEntry = new Entry(this, this.nextIndex());
            return this.lastReturnedEntry;
        }

        @Override
        public void remove() {
            EntryIterator._jr$ip$lastReturnedIndex(this, !f.ifAcmp(null, (Object)this.lastReturnedEntry) ? -1 : Entry._jr$ig$index((Entry)this.lastReturnedEntry));
            super.remove();
            Entry.access$802(this.lastReturnedEntry, EntryIterator._jr$ig$lastReturnedIndex(this));
            this.lastReturnedEntry = null;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, IdentityHashMap identityHashMap) {
            ((EntryIterator)object).this$0 = identityHashMap;
        }

        protected /* synthetic */ EntryIterator(h h2) {
            super(h2);
        }

        /*
         * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
         */
        private class Entry
        extends h
        implements Map.Entry {
            private int index;
            final /* synthetic */ EntryIterator this$1;

            private Entry(EntryIterator entryIterator, int n2) {
                this.this$1 = entryIterator;
                this.index = n2;
            }

            @Override
            public K getKey() {
                this.checkIndexForEntryUse();
                return IdentityHashMap.unmaskNull(a.arrayLoad((Object[])EntryIterator._jr$ig$traversalTable(((Entry)this).this$1), (int)this.index));
            }

            @Override
            public V getValue() {
                this.checkIndexForEntryUse();
                return a.arrayLoad((Object[])EntryIterator._jr$ig$traversalTable(((Entry)this).this$1), (int)(this.index + 1));
            }

            @Override
            public V setValue(V v) {
                this.checkIndexForEntryUse();
                Object object = a.arrayLoad((Object[])EntryIterator._jr$ig$traversalTable(((Entry)this).this$1), (int)(this.index + 1));
                a.arrayStore((Object[])EntryIterator._jr$ig$traversalTable(((Entry)this).this$1), (int)(this.index + 1), v);
                if (f.ifAcmp((Object)EntryIterator._jr$ig$traversalTable(((Entry)this).this$1), (Object)((EntryIterator)((Entry)this).this$1).this$0.table)) {
                    ((EntryIterator)((Entry)this).this$1).this$0.put(a.arrayLoad((Object[])EntryIterator._jr$ig$traversalTable(((Entry)this).this$1), (int)this.index), v);
                }
                return object;
            }

            @Override
            public boolean equals(Object object) {
                if (this.index < 0) {
                    return super.equals(object);
                }
                if (!(g.convertForInstanceOf((Object)object, Map.Entry.class) instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)g.convertForCast((Object)object, Map.Entry.class);
                return !f.ifAcmp(entry.getKey(), (Object)IdentityHashMap.unmaskNull(a.arrayLoad((Object[])EntryIterator._jr$ig$traversalTable(((Entry)this).this$1), (int)this.index))) && !f.ifAcmp(entry.getValue(), (Object)a.arrayLoad((Object[])EntryIterator._jr$ig$traversalTable(((Entry)this).this$1), (int)(this.index + 1)));
            }

            @Override
            public int hashCode() {
                if (EntryIterator._jr$ig$lastReturnedIndex(((Entry)this).this$1) < 0) {
                    return super.hashCode();
                }
                return w.getIdentityHashCode((Object)IdentityHashMap.unmaskNull(a.arrayLoad((Object[])EntryIterator._jr$ig$traversalTable(((Entry)this).this$1), (int)this.index))) ^ w.getIdentityHashCode((Object)a.arrayLoad((Object[])EntryIterator._jr$ig$traversalTable(((Entry)this).this$1), (int)(this.index + 1)));
            }

            public String toString() {
                if (this.index < 0) {
                    return super.toString();
                }
                return IdentityHashMap.unmaskNull(a.arrayLoad((Object[])EntryIterator._jr$ig$traversalTable(((Entry)this).this$1), (int)this.index)) + "=" + a.arrayLoad((Object[])EntryIterator._jr$ig$traversalTable(((Entry)this).this$1), (int)(this.index + 1));
            }

            private void checkIndexForEntryUse() {
                if (this.index < 0) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("Entry was removed"));
                }
            }

            static /* synthetic */ int access$802(Entry entry, int n2) {
                int n3 = n2;
                entry.index = n3;
                return n3;
            }

            static /* synthetic */ void _jr$ip$this$1(Object object, EntryIterator entryIterator) {
                ((Entry)object).this$1 = entryIterator;
            }

            protected /* synthetic */ Entry(h h2) {
                super(h2);
            }
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        final /* synthetic */ IdentityHashMap this$0;

        private EntrySet(IdentityHashMap identityHashMap) {
            this.this$0 = identityHashMap;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(((EntrySet)this).this$0);
        }

        @Override
        public boolean contains(Object object) {
            if (!(g.convertForInstanceOf((Object)object, Map.Entry.class) instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)g.convertForCast((Object)object, Map.Entry.class);
            return ((EntrySet)this).this$0.containsMapping(entry.getKey(), entry.getValue());
        }

        @Override
        public boolean remove(Object object) {
            if (!(g.convertForInstanceOf((Object)object, Map.Entry.class) instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)g.convertForCast((Object)object, Map.Entry.class);
            return ((EntrySet)this).this$0.removeMapping(entry.getKey(), entry.getValue());
        }

        @Override
        public int size() {
            return ((EntrySet)this).this$0.size;
        }

        @Override
        public void clear() {
            ((EntrySet)this).this$0.clear();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean bl = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (!collection.contains(iterator.next())) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }

        @Override
        public Object[] toArray() {
            int n2 = this.size();
            Object[] objectArray = new Object[n2];
            Iterator iterator = this.iterator();
            for (int i = 0; i < n2; ++i) {
                a.arrayStore((Object[])objectArray, (int)i, (Object)new AbstractMap.SimpleEntry((Map.Entry)g.convertForCast(iterator.next(), Map.Entry.class)));
            }
            return objectArray;
        }

        @Override
        public <T> T[] toArray(T[] objectArray) {
            int n2 = this.size();
            if (a.arrayLength((Object[])objectArray) < n2) {
                objectArray = (Object[])g.convertForCast((Object)((Object[])g.convertForCast((Object)Array.newInstance(ai.getCurrentClass(objectArray.getClass()).getComponentType(), n2), Object[].class)), Object[].class);
            }
            Iterator iterator = this.iterator();
            for (int i = 0; i < n2; ++i) {
                a.arrayStore((Object[])objectArray, (int)i, (Object)new AbstractMap.SimpleEntry((Map.Entry)g.convertForCast(iterator.next(), Map.Entry.class)));
            }
            if (a.arrayLength((Object[])objectArray) > n2) {
                a.arrayStore((Object[])objectArray, (int)n2, null);
            }
            return objectArray;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, IdentityHashMap identityHashMap) {
            ((EntrySet)object).this$0 = identityHashMap;
        }

        protected /* synthetic */ EntrySet(h h2) {
            super(h2);
        }
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    private abstract class IdentityHashMapIterator
    extends h
    implements Iterator {
        int index;
        int expectedModCount;
        int lastReturnedIndex;
        boolean indexValid;
        Object[] traversalTable;
        final /* synthetic */ IdentityHashMap this$0;

        private IdentityHashMapIterator(IdentityHashMap identityHashMap) {
            this.this$0 = identityHashMap;
            this.index = this.this$0.size != 0 ? 0 : a.arrayLength((Object[])this.this$0.table);
            this.expectedModCount = this.this$0.modCount;
            this.lastReturnedIndex = -1;
            this.traversalTable = this.this$0.table;
        }

        @Override
        public boolean hasNext() {
            Object[] objectArray = ((IdentityHashMapIterator)this).traversalTable;
            for (int i = ((IdentityHashMapIterator)this).index; i < a.arrayLength((Object[])objectArray); i += 2) {
                Object object = a.arrayLoad((Object[])objectArray, (int)i);
                if (object == null) continue;
                ((IdentityHashMapIterator)this).index = i;
                ((IdentityHashMapIterator)this).indexValid = true;
                return true;
            }
            ((IdentityHashMapIterator)this).index = a.arrayLength((Object[])objectArray);
            return false;
        }

        protected int nextIndex() {
            if (((IdentityHashMapIterator)this).this$0.modCount != ((IdentityHashMapIterator)this).expectedModCount) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
            }
            if (!((IdentityHashMapIterator)this).indexValid && !this.hasNext()) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
            }
            ((IdentityHashMapIterator)this).indexValid = false;
            ((IdentityHashMapIterator)this).lastReturnedIndex = ((IdentityHashMapIterator)this).index;
            IdentityHashMapIterator identityHashMapIterator = this;
            ((IdentityHashMapIterator)identityHashMapIterator).index = ((IdentityHashMapIterator)identityHashMapIterator).index + 2;
            return ((IdentityHashMapIterator)this).lastReturnedIndex;
        }

        @Override
        public void remove() {
            Object object;
            if (((IdentityHashMapIterator)this).lastReturnedIndex == -1) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException());
            }
            if (((IdentityHashMapIterator)this).this$0.modCount != ((IdentityHashMapIterator)this).expectedModCount) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
            }
            ((IdentityHashMapIterator)this).expectedModCount = IdentityHashMap.access$204(((IdentityHashMapIterator)this).this$0);
            int n2 = ((IdentityHashMapIterator)this).lastReturnedIndex;
            ((IdentityHashMapIterator)this).lastReturnedIndex = -1;
            ((IdentityHashMapIterator)this).index = n2;
            ((IdentityHashMapIterator)this).indexValid = false;
            Object[] objectArray = ((IdentityHashMapIterator)this).traversalTable;
            int n3 = a.arrayLength((Object[])objectArray);
            int n4 = n2;
            Object object2 = a.arrayLoad((Object[])objectArray, (int)n4);
            a.arrayStore((Object[])objectArray, (int)n4, null);
            a.arrayStore((Object[])objectArray, (int)(n4 + 1), null);
            if (f.ifAcmp((Object)objectArray, (Object)((IdentityHashMapIterator)this).this$0.table)) {
                ((IdentityHashMapIterator)this).this$0.remove(object2);
                ((IdentityHashMapIterator)this).expectedModCount = ((IdentityHashMapIterator)this).this$0.modCount;
                return;
            }
            IdentityHashMap.access$010(((IdentityHashMapIterator)this).this$0);
            int n5 = IdentityHashMap.nextKeyIndex(n4, n3);
            while ((object = a.arrayLoad((Object[])objectArray, (int)n5)) != null) {
                int n6 = IdentityHashMap.hash(object, n3);
                if (n5 < n6 && (n6 <= n4 || n4 <= n5) || n6 <= n4 && n4 <= n5) {
                    if (n5 < n2 && n4 >= n2 && !f.ifAcmp((Object)((IdentityHashMapIterator)this).traversalTable, (Object)((IdentityHashMapIterator)this).this$0.table)) {
                        int n7 = n3 - n2;
                        Object[] objectArray2 = new Object[n7];
                        a.arraycopy((Object)objectArray, (int)n2, (Object)objectArray2, (int)0, (int)n7);
                        ((IdentityHashMapIterator)this).traversalTable = objectArray2;
                        ((IdentityHashMapIterator)this).index = 0;
                    }
                    a.arrayStore((Object[])objectArray, (int)n4, (Object)object);
                    a.arrayStore((Object[])objectArray, (int)(n4 + 1), (Object)a.arrayLoad((Object[])objectArray, (int)(n5 + 1)));
                    a.arrayStore((Object[])objectArray, (int)n5, null);
                    a.arrayStore((Object[])objectArray, (int)(n5 + 1), null);
                    n4 = n5;
                }
                n5 = IdentityHashMap.nextKeyIndex(n5, n3);
            }
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, IdentityHashMap identityHashMap) {
            ((IdentityHashMapIterator)object).this$0 = identityHashMap;
        }

        protected /* synthetic */ IdentityHashMapIterator(h h2) {
            super(h2);
        }
    }

    private class KeyIterator
    extends IdentityHashMapIterator<K> {
        final /* synthetic */ IdentityHashMap this$0;

        private KeyIterator(IdentityHashMap identityHashMap) {
            this.this$0 = identityHashMap;
            super(identityHashMap);
        }

        public K next() {
            return IdentityHashMap.unmaskNull(a.arrayLoad((Object[])KeyIterator._jr$ig$traversalTable(this), (int)this.nextIndex()));
        }

        static /* synthetic */ IdentityHashMap _jr$ig$this$0(Object object) {
            return ((KeyIterator)object).this$0;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, IdentityHashMap identityHashMap) {
            ((KeyIterator)object).this$0 = identityHashMap;
        }

        protected /* synthetic */ KeyIterator(h h2) {
            super(h2);
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        final /* synthetic */ IdentityHashMap this$0;

        private KeySet(IdentityHashMap identityHashMap) {
            this.this$0 = identityHashMap;
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator(((KeySet)this).this$0);
        }

        @Override
        public int size() {
            return ((KeySet)this).this$0.size;
        }

        @Override
        public boolean contains(Object object) {
            return ((KeySet)this).this$0.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            int n2 = ((KeySet)this).this$0.size;
            ((KeySet)this).this$0.remove(object);
            return ((KeySet)this).this$0.size != n2;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean bl = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (!collection.contains(iterator.next())) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }

        @Override
        public void clear() {
            ((KeySet)this).this$0.clear();
        }

        @Override
        public int hashCode() {
            int n2 = 0;
            for (Object k : this) {
                n2 += w.getIdentityHashCode(k);
            }
            return n2;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, IdentityHashMap identityHashMap) {
            ((KeySet)object).this$0 = identityHashMap;
        }

        protected /* synthetic */ KeySet(h h2) {
            super(h2);
        }
    }

    private class ValueIterator
    extends IdentityHashMapIterator<V> {
        final /* synthetic */ IdentityHashMap this$0;

        private ValueIterator(IdentityHashMap identityHashMap) {
            this.this$0 = identityHashMap;
            super(identityHashMap);
        }

        public V next() {
            return a.arrayLoad((Object[])ValueIterator._jr$ig$traversalTable(this), (int)(this.nextIndex() + 1));
        }

        static /* synthetic */ IdentityHashMap _jr$ig$this$0(Object object) {
            return ((ValueIterator)object).this$0;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, IdentityHashMap identityHashMap) {
            ((ValueIterator)object).this$0 = identityHashMap;
        }

        protected /* synthetic */ ValueIterator(h h2) {
            super(h2);
        }
    }

    private class Values
    extends AbstractCollection<V> {
        final /* synthetic */ IdentityHashMap this$0;

        private Values(IdentityHashMap identityHashMap) {
            this.this$0 = identityHashMap;
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator(((Values)this).this$0);
        }

        @Override
        public int size() {
            return ((Values)this).this$0.size;
        }

        @Override
        public boolean contains(Object object) {
            return ((Values)this).this$0.containsValue(object);
        }

        @Override
        public boolean remove(Object object) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (f.ifAcmp(iterator.next(), (Object)object)) continue;
                iterator.remove();
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            ((Values)this).this$0.clear();
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, IdentityHashMap identityHashMap) {
            ((Values)object).this$0 = identityHashMap;
        }

        protected /* synthetic */ Values(h h2) {
            super(h2);
        }
    }
}

