/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IllformedLocaleException;
import java.util.List;
import java.util.MissingResourceException;
import java.util.PropertyPermission;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.spi.LocaleNameProvider;
import sun.security.action.GetPropertyAction;
import sun.util.LocaleServiceProviderPool;
import sun.util.locale.BaseLocale;
import sun.util.locale.InternalLocaleBuilder;
import sun.util.locale.LanguageTag;
import sun.util.locale.LocaleExtensions;
import sun.util.locale.LocaleObjectCache;
import sun.util.locale.LocaleSyntaxException;
import sun.util.locale.LocaleUtils;
import sun.util.locale.ParseStatus;
import sun.util.locale.UnicodeLocaleExtension;
import sun.util.resources.LocaleData;
import sun.util.resources.OpenListResourceBundle;

public final class Locale
extends h
implements Cloneable,
Serializable {
    private static final Cache LOCALECACHE = new Cache();
    public static final Locale ENGLISH = Locale.createConstant("en", "");
    public static final Locale FRENCH = Locale.createConstant("fr", "");
    public static final Locale GERMAN = Locale.createConstant("de", "");
    public static final Locale ITALIAN = Locale.createConstant("it", "");
    public static final Locale JAPANESE = Locale.createConstant("ja", "");
    public static final Locale KOREAN = Locale.createConstant("ko", "");
    public static final Locale CHINESE = Locale.createConstant("zh", "");
    public static final Locale SIMPLIFIED_CHINESE = Locale.createConstant("zh", "CN");
    public static final Locale TRADITIONAL_CHINESE = Locale.createConstant("zh", "TW");
    public static final Locale FRANCE = Locale.createConstant("fr", "FR");
    public static final Locale GERMANY = Locale.createConstant("de", "DE");
    public static final Locale ITALY = Locale.createConstant("it", "IT");
    public static final Locale JAPAN = Locale.createConstant("ja", "JP");
    public static final Locale KOREA = Locale.createConstant("ko", "KR");
    public static final Locale CHINA = SIMPLIFIED_CHINESE;
    public static final Locale PRC = SIMPLIFIED_CHINESE;
    public static final Locale TAIWAN = TRADITIONAL_CHINESE;
    public static final Locale UK = Locale.createConstant("en", "GB");
    public static final Locale US = Locale.createConstant("en", "US");
    public static final Locale CANADA = Locale.createConstant("en", "CA");
    public static final Locale CANADA_FRENCH = Locale.createConstant("fr", "CA");
    public static final Locale ROOT = Locale.createConstant("", "");
    public static final char PRIVATE_USE_EXTENSION = 'x';
    public static final char UNICODE_LOCALE_EXTENSION = 'u';
    static final long serialVersionUID = 9149081749638150636L;
    private static final int DISPLAY_LANGUAGE = 0;
    private static final int DISPLAY_COUNTRY = 1;
    private static final int DISPLAY_VARIANT = 2;
    private static final int DISPLAY_SCRIPT = 3;
    private transient BaseLocale baseLocale;
    private transient LocaleExtensions localeExtensions;
    private volatile transient int hashCodeValue = 0;
    private static Locale defaultLocale = null;
    private static Locale defaultDisplayLocale = null;
    private static Locale defaultFormatLocale = null;
    private static final ObjectStreamField[] serialPersistentFields;
    private static volatile String[] isoLanguages;
    private static volatile String[] isoCountries;

    private Locale(BaseLocale baseLocale, LocaleExtensions localeExtensions) {
        this.baseLocale = baseLocale;
        this.localeExtensions = localeExtensions;
    }

    public Locale(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        this.baseLocale = BaseLocale.getInstance(Locale.convertOldISOCodes(string), "", string2, string3);
        this.localeExtensions = Locale.getCompatibilityExtensions(string, "", string2, string3);
    }

    public Locale(String string, String string2) {
        this(string, string2, "");
    }

    public Locale(String string) {
        this(string, "", "");
    }

    private static Locale createConstant(String string, String string2) {
        BaseLocale baseLocale = BaseLocale.createInstance(string, string2);
        return Locale.getInstance(baseLocale, null);
    }

    static Locale getInstance(String string, String string2, String string3) {
        return Locale.getInstance(string, "", string2, string3, null);
    }

    static Locale getInstance(String string, String string2, String string3, String string4, LocaleExtensions localeExtensions) {
        if (string == null || string2 == null || string3 == null || string4 == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        if (localeExtensions == null) {
            localeExtensions = Locale.getCompatibilityExtensions(string, string2, string3, string4);
        }
        BaseLocale baseLocale = BaseLocale.getInstance(string, string2, string3, string4);
        return Locale.getInstance(baseLocale, localeExtensions);
    }

    static Locale getInstance(BaseLocale baseLocale, LocaleExtensions localeExtensions) {
        LocaleKey localeKey = new LocaleKey(baseLocale, localeExtensions);
        return (Locale)LOCALECACHE.get(localeKey);
    }

    public static Locale getDefault() {
        if (defaultLocale == null) {
            Locale.initDefault();
        }
        return defaultLocale;
    }

    public static Locale getDefault(Category category) {
        switch (1.$SwitchMap$java$util$Locale$Category[category.ordinal() + 1]) {
            case 1: {
                if (defaultDisplayLocale == null) {
                    Locale.initDefault(category);
                }
                return defaultDisplayLocale;
            }
            case 2: {
                if (defaultFormatLocale == null) {
                    Locale.initDefault(category);
                }
                return defaultFormatLocale;
            }
        }
        if (!$assertionsDisabled) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError((Object)"Unknown Category"));
        }
        return Locale.getDefault();
    }

    private static void initDefault() {
        String string;
        String string2;
        String string3;
        String string4 = (String)AccessController.doPrivileged(new GetPropertyAction("user.language", "en"));
        String string5 = (String)AccessController.doPrivileged(new GetPropertyAction("user.region"));
        if (string5 != null) {
            int n = string5.indexOf(95);
            if (n >= 0) {
                string3 = string5.substring(0, n);
                string2 = string5.substring(n + 1);
            } else {
                string3 = string5;
                string2 = "";
            }
            string = "";
        } else {
            string = (String)AccessController.doPrivileged(new GetPropertyAction("user.script", ""));
            string3 = (String)AccessController.doPrivileged(new GetPropertyAction("user.country", ""));
            string2 = (String)AccessController.doPrivileged(new GetPropertyAction("user.variant", ""));
        }
        defaultLocale = Locale.getInstance(string4, string, string3, string2, null);
    }

    private static void initDefault(Category category) {
        if (defaultLocale == null) {
            Locale.initDefault();
        }
        Locale locale = Locale.getInstance((String)AccessController.doPrivileged(new GetPropertyAction(category.languageKey, defaultLocale.getLanguage())), (String)AccessController.doPrivileged(new GetPropertyAction(category.scriptKey, defaultLocale.getScript())), (String)AccessController.doPrivileged(new GetPropertyAction(category.countryKey, defaultLocale.getCountry())), (String)AccessController.doPrivileged(new GetPropertyAction(category.variantKey, defaultLocale.getVariant())), null);
        switch (1.$SwitchMap$java$util$Locale$Category[category.ordinal() + 1]) {
            case 1: {
                defaultDisplayLocale = locale;
                break;
            }
            case 2: {
                defaultFormatLocale = locale;
            }
        }
    }

    public static synchronized void setDefault(Locale locale) {
        Locale.setDefault(Category.DISPLAY, locale);
        Locale.setDefault(Category.FORMAT, locale);
        defaultLocale = locale;
    }

    public static synchronized void setDefault(Category category, Locale locale) {
        if (category == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("Category cannot be NULL"));
        }
        if (locale == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("Can't set default locale to NULL"));
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission("user.language", "write"));
        }
        switch (1.$SwitchMap$java$util$Locale$Category[category.ordinal() + 1]) {
            case 1: {
                defaultDisplayLocale = locale;
                break;
            }
            case 2: {
                defaultFormatLocale = locale;
                break;
            }
            default: {
                if ($assertionsDisabled) break;
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError((Object)"Unknown Category"));
            }
        }
    }

    public static Locale[] getAvailableLocales() {
        return LocaleServiceProviderPool.getAllAvailableLocales();
    }

    public static String[] getISOCountries() {
        if (isoCountries == null) {
            isoCountries = Locale.getISO2Table("ADANDAEAREAFAFGAGATGAIAIAALALBAMARMANANTAOAGOAQATAARARGASASMATAUTAUAUSAWABWAXALAAZAZEBABIHBBBRBBDBGDBEBELBFBFABGBGRBHBHRBIBDIBJBENBLBLMBMBMUBNBRNBOBOLBQBESBRBRABSBHSBTBTNBVBVTBWBWABYBLRBZBLZCACANCCCCKCDCODCFCAFCGCOGCHCHECICIVCKCOKCLCHLCMCMRCNCHNCOCOLCRCRICUCUBCVCPVCWCUWCXCXRCYCYPCZCZEDEDEUDJDJIDKDNKDMDMADODOMDZDZAECECUEEESTEGEGYEHESHERERIESESPETETHFIFINFJFJIFKFLKFMFSMFOFROFRFRAGAGABGBGBRGDGRDGEGEOGFGUFGGGGYGHGHAGIGIBGLGRLGMGMBGNGINGPGLPGQGNQGRGRCGSSGSGTGTMGUGUMGWGNBGYGUYHKHKGHMHMDHNHNDHRHRVHTHTIHUHUNIDIDNIEIRLILISRIMIMNININDIOIOTIQIRQIRIRNISISLITITAJEJEYJMJAMJOJORJPJPNKEKENKGKGZKHKHMKIKIRKMCOMKNKNAKPPRKKRKORKWKWTKYCYMKZKAZLALAOLBLBNLCLCALILIELKLKALRLBRLSLSOLTLTULULUXLVLVALYLBYMAMARMCMCOMDMDAMEMNEMFMAFMGMDGMHMHLMKMKDMLMLIMMMMRMNMNGMOMACMPMNPMQMTQMRMRTMSMSRMTMLTMUMUSMVMDVMWMWIMXMEXMYMYSMZMOZNANAMNCNCLNENERNFNFKNGNGANINICNLNLDNONORNPNPLNRNRUNUNIUNZNZLOMOMNPAPANPEPERPFPYFPGPNGPHPHLPKPAKPLPOLPMSPMPNPCNPRPRIPSPSEPTPRTPWPLWPYPRYQAQATREREUROROURSSRBRURUSRWRWASASAUSBSLBSCSYCSDSDNSESWESGSGPSHSHNSISVNSJSJMSKSVKSLSLESMSMRSNSENSOSOMSRSURSTSTPSVSLVSXSXMSYSYRSZSWZTCTCATDTCDTFATFTGTGOTHTHATJTJKTKTKLTLTLSTMTKMTNTUNTOTONTRTURTTTTOTVTUVTWTWNTZTZAUAUKRUGUGAUMUMIUSUSAUYURYUZUZBVAVATVCVCTVEVENVGVGBVIVIRVNVNMVUVUTWFWLFWSWSMYEYEMYTMYTZAZAFZMZMBZWZWE");
        }
        String[] stringArray = new String[a.arrayLength((Object[])isoCountries)];
        a.arraycopy((Object)isoCountries, (int)0, (Object)stringArray, (int)0, (int)a.arrayLength((Object[])isoCountries));
        return stringArray;
    }

    public static String[] getISOLanguages() {
        if (isoLanguages == null) {
            isoLanguages = Locale.getISO2Table("aaaarababkaeaveafafrakakaamamhanargararaasasmavavaayaymazazebabakbebelbgbulbhbihbibisbmbambnbenbobodbrbrebsboscacatcechechchacocoscrcrecscescuchucvchvcycymdadandedeudvdivdzdzoeeeweelellenengeoepoesspaetesteueusfafasfffulfifinfjfijfofaofrfrafyfrygaglegdglaglglggngrngugujgvglvhahauhehebhihinhohmohrhrvhthathuhunhyhyehzheriainaidindieileigiboiiiiiikipkinindioidoisislititaiuikuiwhebjajpnjiyidjvjavkakatkgkonkikikkjkuakkkazklkalkmkhmknkankokorkrkaukskaskukurkvkomkwcorkykirlalatlbltzlgluglilimlnlinlolaoltlitlulublvlavmgmlgmhmahmimrimkmkdmlmalmnmonmomolmrmarmsmsamtmltmymyananaunbnobndndenenepngndonlnldnnnnononornrnblnvnavnynyaocociojojiomormororiososspapanpipliplpolpspusptporququermrohrnrunroronrurusrwkinsasanscsrdsdsndsesmesgsagsisinskslkslslvsmsmosnsnasosomsqsqisrsrpsssswstsotsusunsvsweswswatatamteteltgtgkththatitirtktuktltgltntsntotontrturtstsotttattwtwitytahuguigukukrururduzuzbvevenvivievovolwawlnwowolxhxhoyiyidyoyorzazhazhzhozuzul");
        }
        String[] stringArray = new String[a.arrayLength((Object[])isoLanguages)];
        a.arraycopy((Object)isoLanguages, (int)0, (Object)stringArray, (int)0, (int)a.arrayLength((Object[])isoLanguages));
        return stringArray;
    }

    private static final String[] getISO2Table(String string) {
        int n = string.length() / 5;
        Object[] objectArray = new String[n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            a.arrayStore((Object[])objectArray, (int)n2, (Object)string.substring(n3, n3 + 2));
            ++n2;
            n3 += 5;
        }
        return objectArray;
    }

    public String getLanguage() {
        return this.baseLocale.getLanguage();
    }

    public String getScript() {
        return this.baseLocale.getScript();
    }

    public String getCountry() {
        return this.baseLocale.getRegion();
    }

    public String getVariant() {
        return this.baseLocale.getVariant();
    }

    public String getExtension(char c) {
        if (!LocaleExtensions.isValidKey(c)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Ill-formed extension key: " + c));
        }
        return this.localeExtensions == null ? null : this.localeExtensions.getExtensionValue(Character.valueOf(c));
    }

    public Set<Character> getExtensionKeys() {
        if (this.localeExtensions == null) {
            return Collections.emptySet();
        }
        return this.localeExtensions.getKeys();
    }

    public Set<String> getUnicodeLocaleAttributes() {
        if (this.localeExtensions == null) {
            return Collections.emptySet();
        }
        return this.localeExtensions.getUnicodeLocaleAttributes();
    }

    public String getUnicodeLocaleType(String string) {
        if (!UnicodeLocaleExtension.isKey(string)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Ill-formed Unicode locale key: " + string));
        }
        return this.localeExtensions == null ? null : this.localeExtensions.getUnicodeLocaleType(string);
    }

    public Set<String> getUnicodeLocaleKeys() {
        if (this.localeExtensions == null) {
            return Collections.emptySet();
        }
        return this.localeExtensions.getUnicodeLocaleKeys();
    }

    BaseLocale getBaseLocale() {
        return this.baseLocale;
    }

    LocaleExtensions getLocaleExtensions() {
        return this.localeExtensions;
    }

    public final String toString() {
        boolean bl = this.baseLocale.getLanguage().length() != 0;
        boolean bl2 = this.baseLocale.getScript().length() != 0;
        boolean bl3 = this.baseLocale.getRegion().length() != 0;
        boolean bl4 = this.baseLocale.getVariant().length() != 0;
        boolean bl5 = this.localeExtensions != null && this.localeExtensions.getID().length() != 0;
        StringBuilder stringBuilder = new StringBuilder(this.baseLocale.getLanguage());
        if (bl3 || bl && (bl4 || bl2 || bl5)) {
            stringBuilder.append('_').append(this.baseLocale.getRegion());
        }
        if (bl4 && (bl || bl3)) {
            stringBuilder.append('_').append(this.baseLocale.getVariant());
        }
        if (bl2 && (bl || bl3)) {
            stringBuilder.append("_#").append(this.baseLocale.getScript());
        }
        if (bl5 && (bl || bl3)) {
            stringBuilder.append('_');
            if (!bl2) {
                stringBuilder.append('#');
            }
            stringBuilder.append(this.localeExtensions.getID());
        }
        return stringBuilder.toString();
    }

    public String toLanguageTag() {
        LanguageTag languageTag = LanguageTag.parseLocale(this.baseLocale, this.localeExtensions);
        StringBuilder stringBuilder = new StringBuilder();
        String string = languageTag.getLanguage();
        if (string.length() > 0) {
            stringBuilder.append(LanguageTag.canonicalizeLanguage(string));
        }
        if ((string = languageTag.getScript()).length() > 0) {
            stringBuilder.append("-");
            stringBuilder.append(LanguageTag.canonicalizeScript(string));
        }
        if ((string = languageTag.getRegion()).length() > 0) {
            stringBuilder.append("-");
            stringBuilder.append(LanguageTag.canonicalizeRegion(string));
        }
        List<String> list = languageTag.getVariants();
        for (String string2 : list) {
            stringBuilder.append("-");
            stringBuilder.append(string2);
        }
        list = languageTag.getExtensions();
        for (String string2 : list) {
            stringBuilder.append("-");
            stringBuilder.append(LanguageTag.canonicalizeExtension(string2));
        }
        string = languageTag.getPrivateuse();
        if (string.length() > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("-");
            }
            stringBuilder.append("x").append("-");
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static Locale forLanguageTag(String string) {
        LanguageTag languageTag = LanguageTag.parse(string, null);
        InternalLocaleBuilder internalLocaleBuilder = new InternalLocaleBuilder();
        internalLocaleBuilder.setLanguageTag(languageTag);
        BaseLocale baseLocale = internalLocaleBuilder.getBaseLocale();
        LocaleExtensions localeExtensions = internalLocaleBuilder.getLocaleExtensions();
        if (localeExtensions == null && baseLocale.getVariant().length() > 0) {
            localeExtensions = Locale.getCompatibilityExtensions(baseLocale.getLanguage(), baseLocale.getScript(), baseLocale.getRegion(), baseLocale.getVariant());
        }
        return Locale.getInstance(baseLocale, localeExtensions);
    }

    public String getISO3Language() throws MissingResourceException {
        String string = this.baseLocale.getLanguage();
        if (string.length() == 3) {
            return string;
        }
        String string2 = Locale.getISO3Code(string, "aaaarababkaeaveafafrakakaamamhanargararaasasmavavaayaymazazebabakbebelbgbulbhbihbibisbmbambnbenbobodbrbrebsboscacatcechechchacocoscrcrecscescuchucvchvcycymdadandedeudvdivdzdzoeeeweelellenengeoepoesspaetesteueusfafasfffulfifinfjfijfofaofrfrafyfrygaglegdglaglglggngrngugujgvglvhahauhehebhihinhohmohrhrvhthathuhunhyhyehzheriainaidindieileigiboiiiiiikipkinindioidoisislititaiuikuiwhebjajpnjiyidjvjavkakatkgkonkikikkjkuakkkazklkalkmkhmknkankokorkrkaukskaskukurkvkomkwcorkykirlalatlbltzlgluglilimlnlinlolaoltlitlulublvlavmgmlgmhmahmimrimkmkdmlmalmnmonmomolmrmarmsmsamtmltmymyananaunbnobndndenenepngndonlnldnnnnononornrnblnvnavnynyaocociojojiomormororiososspapanpipliplpolpspusptporququermrohrnrunroronrurusrwkinsasanscsrdsdsndsesmesgsagsisinskslkslslvsmsmosnsnasosomsqsqisrsrpsssswstsotsusunsvsweswswatatamteteltgtgkththatitirtktuktltgltntsntotontrturtstsotttattwtwitytahuguigukukrururduzuzbvevenvivievovolwawlnwowolxhxhoyiyidyoyorzazhazhzhozuzul");
        if (string2 == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new MissingResourceException("Couldn't find 3-letter language code for " + string, "FormatData_" + this.toString(), "ShortLanguage"));
        }
        return string2;
    }

    public String getISO3Country() throws MissingResourceException {
        String string = Locale.getISO3Code(this.baseLocale.getRegion(), "ADANDAEAREAFAFGAGATGAIAIAALALBAMARMANANTAOAGOAQATAARARGASASMATAUTAUAUSAWABWAXALAAZAZEBABIHBBBRBBDBGDBEBELBFBFABGBGRBHBHRBIBDIBJBENBLBLMBMBMUBNBRNBOBOLBQBESBRBRABSBHSBTBTNBVBVTBWBWABYBLRBZBLZCACANCCCCKCDCODCFCAFCGCOGCHCHECICIVCKCOKCLCHLCMCMRCNCHNCOCOLCRCRICUCUBCVCPVCWCUWCXCXRCYCYPCZCZEDEDEUDJDJIDKDNKDMDMADODOMDZDZAECECUEEESTEGEGYEHESHERERIESESPETETHFIFINFJFJIFKFLKFMFSMFOFROFRFRAGAGABGBGBRGDGRDGEGEOGFGUFGGGGYGHGHAGIGIBGLGRLGMGMBGNGINGPGLPGQGNQGRGRCGSSGSGTGTMGUGUMGWGNBGYGUYHKHKGHMHMDHNHNDHRHRVHTHTIHUHUNIDIDNIEIRLILISRIMIMNININDIOIOTIQIRQIRIRNISISLITITAJEJEYJMJAMJOJORJPJPNKEKENKGKGZKHKHMKIKIRKMCOMKNKNAKPPRKKRKORKWKWTKYCYMKZKAZLALAOLBLBNLCLCALILIELKLKALRLBRLSLSOLTLTULULUXLVLVALYLBYMAMARMCMCOMDMDAMEMNEMFMAFMGMDGMHMHLMKMKDMLMLIMMMMRMNMNGMOMACMPMNPMQMTQMRMRTMSMSRMTMLTMUMUSMVMDVMWMWIMXMEXMYMYSMZMOZNANAMNCNCLNENERNFNFKNGNGANINICNLNLDNONORNPNPLNRNRUNUNIUNZNZLOMOMNPAPANPEPERPFPYFPGPNGPHPHLPKPAKPLPOLPMSPMPNPCNPRPRIPSPSEPTPRTPWPLWPYPRYQAQATREREUROROURSSRBRURUSRWRWASASAUSBSLBSCSYCSDSDNSESWESGSGPSHSHNSISVNSJSJMSKSVKSLSLESMSMRSNSENSOSOMSRSURSTSTPSVSLVSXSXMSYSYRSZSWZTCTCATDTCDTFATFTGTGOTHTHATJTJKTKTKLTLTLSTMTKMTNTUNTOTONTRTURTTTTOTVTUVTWTWNTZTZAUAUKRUGUGAUMUMIUSUSAUYURYUZUZBVAVATVCVCTVEVENVGVGBVIVIRVNVNMVUVUTWFWLFWSWSMYEYEMYTMYTZAZAFZMZMBZWZWE");
        if (string == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new MissingResourceException("Couldn't find 3-letter country code for " + this.baseLocale.getRegion(), "FormatData_" + this.toString(), "ShortCountry"));
        }
        return string;
    }

    private static final String getISO3Code(String string, String string2) {
        int n;
        int n2 = string.length();
        if (n2 == 0) {
            return "";
        }
        int n3 = n = string2.length();
        if (n2 == 2) {
            char c = string.charAt(0);
            char c2 = string.charAt(1);
            for (n3 = 0; n3 < n && (string2.charAt(n3) != c || string2.charAt(n3 + 1) != c2); n3 += 5) {
            }
        }
        return n3 < n ? string2.substring(n3 + 2, n3 + 5) : null;
    }

    public final String getDisplayLanguage() {
        return this.getDisplayLanguage(Locale.getDefault(Category.DISPLAY));
    }

    public String getDisplayLanguage(Locale locale) {
        return this.getDisplayString(this.baseLocale.getLanguage(), locale, 0);
    }

    public String getDisplayScript() {
        return this.getDisplayScript(Locale.getDefault());
    }

    public String getDisplayScript(Locale locale) {
        return this.getDisplayString(this.baseLocale.getScript(), locale, 3);
    }

    public final String getDisplayCountry() {
        return this.getDisplayCountry(Locale.getDefault(Category.DISPLAY));
    }

    public String getDisplayCountry(Locale locale) {
        return this.getDisplayString(this.baseLocale.getRegion(), locale, 1);
    }

    private String getDisplayString(String string, Locale locale, int n) {
        if (string.length() == 0) {
            return "";
        }
        if (locale == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        try {
            OpenListResourceBundle openListResourceBundle = LocaleData.getLocaleNames(locale);
            String string2 = n == 2 ? "%%" + string : string;
            String string3 = null;
            LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(LocaleNameProvider.class);
            if (localeServiceProviderPool.hasProviders()) {
                LocaleNameGetter localeNameGetter = LocaleNameGetter.INSTANCE;
                Object[] objectArray = new Object[2];
                a.arrayStore((Object[])objectArray, (int)0, (Object)n);
                a.arrayStore((Object[])objectArray, (int)1, (Object)string);
                string3 = (String)localeServiceProviderPool.getLocalizedObject(localeNameGetter, locale, openListResourceBundle, string2, objectArray);
            }
            if (string3 == null) {
                string3 = openListResourceBundle.getString(string2);
            }
            if (string3 != null) {
                return string3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public final String getDisplayVariant() {
        return this.getDisplayVariant(Locale.getDefault(Category.DISPLAY));
    }

    public String getDisplayVariant(Locale locale) {
        if (this.baseLocale.getVariant().length() == 0) {
            return "";
        }
        OpenListResourceBundle openListResourceBundle = LocaleData.getLocaleNames(locale);
        String[] stringArray = this.getDisplayVariantArray(openListResourceBundle, locale);
        String string = null;
        String string2 = null;
        try {
            string = openListResourceBundle.getString("ListPattern");
            string2 = openListResourceBundle.getString("ListCompositionPattern");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return Locale.formatList(stringArray, string, string2);
    }

    public final String getDisplayName() {
        return this.getDisplayName(Locale.getDefault(Category.DISPLAY));
    }

    public String getDisplayName(Locale locale) {
        OpenListResourceBundle openListResourceBundle = LocaleData.getLocaleNames(locale);
        String string = this.getDisplayLanguage(locale);
        String string2 = this.getDisplayScript(locale);
        String string3 = this.getDisplayCountry(locale);
        Object[] objectArray = this.getDisplayVariantArray(openListResourceBundle, locale);
        String string4 = null;
        String string5 = null;
        String string6 = null;
        try {
            string4 = openListResourceBundle.getString("DisplayNamePattern");
            string5 = openListResourceBundle.getString("ListPattern");
            string6 = openListResourceBundle.getString("ListCompositionPattern");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        String string7 = null;
        Object[] objectArray2 = null;
        if (string.length() == 0 && string2.length() == 0 && string3.length() == 0) {
            if (a.arrayLength((Object[])objectArray) == 0) {
                return "";
            }
            return Locale.formatList((String[])objectArray, string5, string6);
        }
        ArrayList<String> arrayList = new ArrayList<String>(4);
        if (string.length() != 0) {
            arrayList.add(string);
        }
        if (string2.length() != 0) {
            arrayList.add(string2);
        }
        if (string3.length() != 0) {
            arrayList.add(string3);
        }
        if (a.arrayLength((Object[])objectArray) != 0) {
            Object[] objectArray3 = objectArray;
            int n = a.arrayLength((Object[])objectArray3);
            for (int i = 0; i < n; ++i) {
                String string8 = (String)a.arrayLoad((Object[])objectArray3, (int)i);
                arrayList.add(string8);
            }
        }
        string7 = (String)arrayList.get(0);
        int n = arrayList.size();
        objectArray2 = n > 1 ? arrayList.subList(1, n).toArray(new String[n - 1]) : new String[]{};
        Object[] objectArray4 = new Object[3];
        a.arrayStore((Object[])objectArray4, (int)0, (Object)new Integer(a.arrayLength((Object[])objectArray2) != 0 ? 2 : 1));
        a.arrayStore((Object[])objectArray4, (int)1, (Object)string7);
        a.arrayStore((Object[])objectArray4, (int)2, a.arrayLength((Object[])objectArray2) != 0 ? Locale.formatList((String[])objectArray2, string5, string6) : null);
        Object[] objectArray5 = objectArray4;
        if (string4 != null) {
            return new MessageFormat(string4).format(objectArray5);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((String)a.arrayLoad((Object[])objectArray5, (int)1));
        if (a.arrayLength((Object[])objectArray5) > 2) {
            stringBuilder.append(" (");
            stringBuilder.append((String)a.arrayLoad((Object[])objectArray5, (int)2));
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    public Object clone() {
        try {
            Locale locale = (Locale)super.clone();
            return locale;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
        }
    }

    public int hashCode() {
        int n = this.hashCodeValue;
        if (n == 0) {
            n = this.baseLocale.hashCode();
            if (this.localeExtensions != null) {
                n ^= this.localeExtensions.hashCode();
            }
            this.hashCodeValue = n;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!f.ifAcmp((Object)this, (Object)object)) {
            return true;
        }
        if (!(object instanceof Locale)) {
            return false;
        }
        BaseLocale baseLocale = ((Locale)object).baseLocale;
        if (!this.baseLocale.equals((Object)baseLocale)) {
            return false;
        }
        if (this.localeExtensions == null) {
            return ((Locale)object).localeExtensions == null;
        }
        return this.localeExtensions.equals((Object)((Locale)object).localeExtensions);
    }

    private String[] getDisplayVariantArray(OpenListResourceBundle openListResourceBundle, Locale locale) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.baseLocale.getVariant(), "_");
        Object[] objectArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < objectArray.length; ++i) {
            a.arrayStore((Object[])objectArray, (int)i, (Object)this.getDisplayString(stringTokenizer.nextToken(), locale, 2));
        }
        return objectArray;
    }

    private static String formatList(String[] stringArray, String string, String string2) {
        Object[] objectArray;
        if (string == null || string2 == null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < a.arrayLength((Object[])stringArray); ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((String)a.arrayLoad((Object[])stringArray, (int)i));
            }
            return stringBuffer.toString();
        }
        if (a.arrayLength((Object[])stringArray) > 3) {
            objectArray = new MessageFormat(string2);
            stringArray = Locale.composeList((MessageFormat)objectArray, stringArray);
        }
        objectArray = new Object[a.arrayLength((Object[])stringArray) + 1];
        a.arraycopy((Object)stringArray, (int)0, (Object)objectArray, (int)1, (int)a.arrayLength((Object[])stringArray));
        a.arrayStore((Object[])objectArray, (int)0, (Object)new Integer(a.arrayLength((Object[])stringArray)));
        MessageFormat messageFormat = new MessageFormat(string);
        return messageFormat.format(objectArray);
    }

    private static String[] composeList(MessageFormat messageFormat, String[] stringArray) {
        if (a.arrayLength((Object[])stringArray) <= 3) {
            return stringArray;
        }
        Object[] objectArray = new String[2];
        a.arrayStore((Object[])objectArray, (int)0, (Object)((String)a.arrayLoad((Object[])stringArray, (int)0)));
        a.arrayStore((Object[])objectArray, (int)1, (Object)((String)a.arrayLoad((Object[])stringArray, (int)1)));
        Object[] objectArray2 = objectArray;
        String string = messageFormat.format(objectArray2);
        Object[] objectArray3 = new String[a.arrayLength((Object[])stringArray) - 1];
        a.arraycopy((Object)stringArray, (int)2, (Object)objectArray3, (int)1, (int)(a.arrayLength((Object[])objectArray3) - 1));
        a.arrayStore((Object[])objectArray3, (int)0, (Object)string);
        return Locale.composeList(messageFormat, (String[])objectArray3);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("language", this.baseLocale.getLanguage());
        putField.put("script", this.baseLocale.getScript());
        putField.put("country", this.baseLocale.getRegion());
        putField.put("variant", this.baseLocale.getVariant());
        putField.put("extensions", this.localeExtensions == null ? "" : this.localeExtensions.getID());
        putField.put("hashcode", -1);
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        String string = (String)getField.get("language", "");
        String string2 = (String)getField.get("script", "");
        String string3 = (String)getField.get("country", "");
        String string4 = (String)getField.get("variant", "");
        String string5 = (String)getField.get("extensions", "");
        this.baseLocale = BaseLocale.getInstance(Locale.convertOldISOCodes(string), string2, string3, string4);
        if (string5.length() > 0) {
            try {
                InternalLocaleBuilder internalLocaleBuilder = new InternalLocaleBuilder();
                internalLocaleBuilder.setExtensions(string5);
                this.localeExtensions = internalLocaleBuilder.getLocaleExtensions();
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllformedLocaleException(localeSyntaxException.getMessage()));
            }
        } else {
            this.localeExtensions = null;
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return Locale.getInstance(this.baseLocale.getLanguage(), this.baseLocale.getScript(), this.baseLocale.getRegion(), this.baseLocale.getVariant(), this.localeExtensions);
    }

    private static String convertOldISOCodes(String string) {
        if (!f.ifAcmp((Object)(string = LocaleUtils.toLowerString(string).intern()), (Object)"he")) {
            return "iw";
        }
        if (!f.ifAcmp((Object)string, (Object)"yi")) {
            return "ji";
        }
        if (!f.ifAcmp((Object)string, (Object)"id")) {
            return "in";
        }
        return string;
    }

    private static LocaleExtensions getCompatibilityExtensions(String string, String string2, String string3, String string4) {
        LocaleExtensions localeExtensions = null;
        if (LocaleUtils.caseIgnoreMatch(string, "ja") && string2.length() == 0 && LocaleUtils.caseIgnoreMatch(string3, "jp") && "JP".equals(string4)) {
            localeExtensions = LocaleExtensions.CALENDAR_JAPANESE;
        } else if (LocaleUtils.caseIgnoreMatch(string, "th") && string2.length() == 0 && LocaleUtils.caseIgnoreMatch(string3, "th") && "TH".equals(string4)) {
            localeExtensions = LocaleExtensions.NUMBER_THAI;
        }
        return localeExtensions;
    }

    static {
        Object[] objectArray = new ObjectStreamField[6];
        a.arrayStore((Object[])objectArray, (int)0, (Object)new ObjectStreamField("language", String.class));
        a.arrayStore((Object[])objectArray, (int)1, (Object)new ObjectStreamField("country", String.class));
        a.arrayStore((Object[])objectArray, (int)2, (Object)new ObjectStreamField("variant", String.class));
        a.arrayStore((Object[])objectArray, (int)3, (Object)new ObjectStreamField("hashcode", Integer.TYPE));
        a.arrayStore((Object[])objectArray, (int)4, (Object)new ObjectStreamField("script", String.class));
        a.arrayStore((Object[])objectArray, (int)5, (Object)new ObjectStreamField("extensions", String.class));
        serialPersistentFields = objectArray;
        isoLanguages = null;
        isoCountries = null;
    }

    private static /* synthetic */ BaseLocale _jr$ig$baseLocale(Locale locale) {
        return locale.baseLocale;
    }

    private static /* synthetic */ void _jr$ip$baseLocale(Locale locale, BaseLocale baseLocale) {
        locale.baseLocale = baseLocale;
    }

    private static /* synthetic */ LocaleExtensions _jr$ig$localeExtensions(Locale locale) {
        return locale.localeExtensions;
    }

    private static /* synthetic */ void _jr$ip$localeExtensions(Locale locale, LocaleExtensions localeExtensions) {
        locale.localeExtensions = localeExtensions;
    }

    private static /* synthetic */ int _jr$ig$hashCodeValue(Locale locale) {
        return locale.hashCodeValue;
    }

    private static /* synthetic */ void _jr$ip$hashCodeValue(Locale locale, int n) {
        locale.hashCodeValue = n;
    }

    public static final class Builder
    extends h {
        private final InternalLocaleBuilder localeBuilder = new InternalLocaleBuilder();

        public Builder setLocale(Locale locale) {
            try {
                this.localeBuilder.setLocale(locale.baseLocale, locale.localeExtensions);
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllformedLocaleException(localeSyntaxException.getMessage(), localeSyntaxException.getErrorIndex()));
            }
            return this;
        }

        public Builder setLanguageTag(String string) {
            ParseStatus parseStatus = new ParseStatus();
            LanguageTag languageTag = LanguageTag.parse(string, parseStatus);
            if (parseStatus.isError()) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllformedLocaleException(parseStatus.getErrorMessage(), parseStatus.getErrorIndex()));
            }
            this.localeBuilder.setLanguageTag(languageTag);
            return this;
        }

        public Builder setLanguage(String string) {
            try {
                this.localeBuilder.setLanguage(string);
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllformedLocaleException(localeSyntaxException.getMessage(), localeSyntaxException.getErrorIndex()));
            }
            return this;
        }

        public Builder setScript(String string) {
            try {
                this.localeBuilder.setScript(string);
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllformedLocaleException(localeSyntaxException.getMessage(), localeSyntaxException.getErrorIndex()));
            }
            return this;
        }

        public Builder setRegion(String string) {
            try {
                this.localeBuilder.setRegion(string);
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllformedLocaleException(localeSyntaxException.getMessage(), localeSyntaxException.getErrorIndex()));
            }
            return this;
        }

        public Builder setVariant(String string) {
            try {
                this.localeBuilder.setVariant(string);
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllformedLocaleException(localeSyntaxException.getMessage(), localeSyntaxException.getErrorIndex()));
            }
            return this;
        }

        public Builder setExtension(char c, String string) {
            try {
                this.localeBuilder.setExtension(c, string);
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllformedLocaleException(localeSyntaxException.getMessage(), localeSyntaxException.getErrorIndex()));
            }
            return this;
        }

        public Builder setUnicodeLocaleKeyword(String string, String string2) {
            try {
                this.localeBuilder.setUnicodeLocaleKeyword(string, string2);
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllformedLocaleException(localeSyntaxException.getMessage(), localeSyntaxException.getErrorIndex()));
            }
            return this;
        }

        public Builder addUnicodeLocaleAttribute(String string) {
            try {
                this.localeBuilder.addUnicodeLocaleAttribute(string);
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllformedLocaleException(localeSyntaxException.getMessage(), localeSyntaxException.getErrorIndex()));
            }
            return this;
        }

        public Builder removeUnicodeLocaleAttribute(String string) {
            try {
                this.localeBuilder.removeUnicodeLocaleAttribute(string);
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllformedLocaleException(localeSyntaxException.getMessage(), localeSyntaxException.getErrorIndex()));
            }
            return this;
        }

        public Builder clear() {
            this.localeBuilder.clear();
            return this;
        }

        public Builder clearExtensions() {
            this.localeBuilder.clearExtensions();
            return this;
        }

        public Locale build() {
            BaseLocale baseLocale = this.localeBuilder.getBaseLocale();
            LocaleExtensions localeExtensions = this.localeBuilder.getLocaleExtensions();
            if (localeExtensions == null && baseLocale.getVariant().length() > 0) {
                localeExtensions = Locale.getCompatibilityExtensions(baseLocale.getLanguage(), baseLocale.getScript(), baseLocale.getRegion(), baseLocale.getVariant());
            }
            return Locale.getInstance(baseLocale, localeExtensions);
        }

        private static /* synthetic */ InternalLocaleBuilder _jr$ig$localeBuilder(Builder builder) {
            return builder.localeBuilder;
        }

        private static /* synthetic */ void _jr$ip$localeBuilder(Builder builder, InternalLocaleBuilder internalLocaleBuilder) {
            builder.localeBuilder = internalLocaleBuilder;
        }
    }

    private static class Cache
    extends LocaleObjectCache<LocaleKey, Locale> {
        private Cache() {
        }

        protected Locale createObject(LocaleKey localeKey) {
            return new Locale(localeKey.base, localeKey.exts);
        }

        protected /* synthetic */ Cache(h h2) {
            super(h2);
        }
    }

    public static enum Category {
        DISPLAY("user.language.display", "user.script.display", "user.country.display", "user.variant.display"),
        FORMAT("user.language.format", "user.script.format", "user.country.format", "user.variant.format");

        final String languageKey;
        final String scriptKey;
        final String countryKey;
        final String variantKey;

        private Category(String string2, String string3, String string4, String string5) {
            this.languageKey = string2;
            this.scriptKey = string3;
            this.countryKey = string4;
            this.variantKey = string5;
        }

        static /* synthetic */ String _jr$ig$languageKey(Object object) {
            return ((Category)((Object)object)).languageKey;
        }

        static /* synthetic */ void _jr$ip$languageKey(Object object, String string) {
            ((Category)((Object)object)).languageKey = string;
        }

        static /* synthetic */ String _jr$ig$scriptKey(Object object) {
            return ((Category)((Object)object)).scriptKey;
        }

        static /* synthetic */ void _jr$ip$scriptKey(Object object, String string) {
            ((Category)((Object)object)).scriptKey = string;
        }

        static /* synthetic */ String _jr$ig$countryKey(Object object) {
            return ((Category)((Object)object)).countryKey;
        }

        static /* synthetic */ void _jr$ip$countryKey(Object object, String string) {
            ((Category)((Object)object)).countryKey = string;
        }

        static /* synthetic */ String _jr$ig$variantKey(Object object) {
            return ((Category)((Object)object)).variantKey;
        }

        static /* synthetic */ void _jr$ip$variantKey(Object object, String string) {
            ((Category)((Object)object)).variantKey = string;
        }
    }

    private static final class LocaleKey
    extends h {
        private final BaseLocale base;
        private final LocaleExtensions exts;
        private final int hash;

        private LocaleKey(BaseLocale baseLocale, LocaleExtensions localeExtensions) {
            this.base = baseLocale;
            this.exts = localeExtensions;
            int n = this.base.hashCode();
            if (this.exts != null) {
                n ^= this.exts.hashCode();
            }
            this.hash = n;
        }

        public boolean equals(Object object) {
            if (!f.ifAcmp((Object)((Object)this), (Object)object)) {
                return true;
            }
            if (!(object instanceof LocaleKey)) {
                return false;
            }
            LocaleKey localeKey = (LocaleKey)((Object)object);
            if (this.hash != localeKey.hash || !this.base.equals((Object)localeKey.base)) {
                return false;
            }
            if (this.exts == null) {
                return localeKey.exts == null;
            }
            return this.exts.equals((Object)localeKey.exts);
        }

        public int hashCode() {
            return this.hash;
        }

        private static /* synthetic */ BaseLocale _jr$ig$base(LocaleKey localeKey) {
            return localeKey.base;
        }

        private static /* synthetic */ void _jr$ip$base(LocaleKey localeKey, BaseLocale baseLocale) {
            localeKey.base = baseLocale;
        }

        private static /* synthetic */ LocaleExtensions _jr$ig$exts(LocaleKey localeKey) {
            return localeKey.exts;
        }

        private static /* synthetic */ void _jr$ip$exts(LocaleKey localeKey, LocaleExtensions localeExtensions) {
            localeKey.exts = localeExtensions;
        }

        private static /* synthetic */ int _jr$ig$hash(LocaleKey localeKey) {
            return localeKey.hash;
        }

        private static /* synthetic */ void _jr$ip$hash(LocaleKey localeKey, int n) {
            localeKey.hash = n;
        }
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    private static class LocaleNameGetter
    extends h
    implements LocaleServiceProviderPool.LocalizedObjectGetter {
        private static final LocaleNameGetter INSTANCE = new LocaleNameGetter();

        private LocaleNameGetter() {
        }

        public String getObject(LocaleNameProvider localeNameProvider, Locale locale, String string, Object ... objectArray) {
            if (!$assertionsDisabled && a.arrayLength((Object[])objectArray) != 2) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            int n = (Integer)a.arrayLoad((Object[])objectArray, (int)0);
            String string2 = (String)a.arrayLoad((Object[])objectArray, (int)1);
            switch (n) {
                case 0: {
                    return localeNameProvider.getDisplayLanguage(string2, locale);
                }
                case 1: {
                    return localeNameProvider.getDisplayCountry(string2, locale);
                }
                case 2: {
                    return localeNameProvider.getDisplayVariant(string2, locale);
                }
                case 3: {
                    return localeNameProvider.getDisplayScript(string2, locale);
                }
            }
            if (!$assertionsDisabled) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            return null;
        }

        protected /* synthetic */ LocaleNameGetter(h h2) {
            super(h2);
        }
    }
}

