/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.PropertyPermissionCollection;

public final class PropertyPermission
extends BasicPermission {
    private static final int READ = 1;
    private static final int WRITE = 2;
    private static final int ALL = 3;
    private static final int NONE = 0;
    private transient int mask;
    private String actions;
    private static final long serialVersionUID = 885438825399942851L;

    private void init(int n) {
        if ((n & 3) != n) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("invalid actions mask"));
        }
        if (n == 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("invalid actions mask"));
        }
        if (this.getName() == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("name can't be null"));
        }
        this.mask = n;
    }

    public PropertyPermission(String string, String string2) {
        super(string, string2);
        this.init(PropertyPermission.getMask(string2));
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof PropertyPermission)) {
            return false;
        }
        PropertyPermission propertyPermission = (PropertyPermission)permission;
        return (this.mask & propertyPermission.mask) == propertyPermission.mask && super.implies(propertyPermission);
    }

    @Override
    public boolean equals(Object object) {
        if (!f.ifAcmp((Object)object, (Object)this)) {
            return true;
        }
        if (!(object instanceof PropertyPermission)) {
            return false;
        }
        PropertyPermission propertyPermission = (PropertyPermission)object;
        return this.mask == propertyPermission.mask && this.getName().equals(propertyPermission.getName());
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    private static int getMask(String string) {
        int n = 0;
        if (string == null) {
            return n;
        }
        if (!f.ifAcmp((Object)string, (Object)"read")) {
            return 1;
        }
        if (!f.ifAcmp((Object)string, (Object)"write")) {
            return 2;
        }
        if (!f.ifAcmp((Object)string, (Object)"read,write")) {
            return 3;
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray.length - 1;
        if (n2 < 0) {
            return n;
        }
        while (n2 != -1) {
            int n3;
            char c;
            while (n2 != -1 && ((c = cArray[n2]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) {
                --n2;
            }
            if (!(n2 < 3 || cArray[n2 - 3] != 'r' && cArray[n2 - 3] != 'R' || cArray[n2 - 2] != 'e' && cArray[n2 - 2] != 'E' || cArray[n2 - 1] != 'a' && cArray[n2 - 1] != 'A' || cArray[n2] != 'd' && cArray[n2] != 'D')) {
                n3 = 4;
                n |= 1;
            } else if (!(n2 < 4 || cArray[n2 - 4] != 'w' && cArray[n2 - 4] != 'W' || cArray[n2 - 3] != 'r' && cArray[n2 - 3] != 'R' || cArray[n2 - 2] != 'i' && cArray[n2 - 2] != 'I' || cArray[n2 - 1] != 't' && cArray[n2 - 1] != 'T' || cArray[n2] != 'e' && cArray[n2] != 'E')) {
                n3 = 5;
                n |= 2;
            } else {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("invalid permission: " + string));
            }
            boolean bl = false;
            while (n2 >= n3 && !bl) {
                switch (cArray[n2 - n3]) {
                    case ',': {
                        bl = true;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("invalid permission: " + string));
                    }
                }
                --n2;
            }
            n2 -= n3;
        }
        return n;
    }

    static String getActions(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        if ((n & 1) == 1) {
            bl = true;
            stringBuilder.append("read");
        }
        if ((n & 2) == 2) {
            if (bl) {
                stringBuilder.append(',');
            } else {
                bl = true;
            }
            stringBuilder.append("write");
        }
        return stringBuilder.toString();
    }

    @Override
    public String getActions() {
        if (this.actions == null) {
            this.actions = PropertyPermission.getActions(this.mask);
        }
        return this.actions;
    }

    int getMask() {
        return this.mask;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new PropertyPermissionCollection();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(PropertyPermission.getMask(this.actions));
    }

    private static /* synthetic */ int _jr$ig$mask(PropertyPermission propertyPermission) {
        return propertyPermission.mask;
    }

    private static /* synthetic */ void _jr$ip$mask(PropertyPermission propertyPermission, int n) {
        propertyPermission.mask = n;
    }

    private static /* synthetic */ String _jr$ig$actions(PropertyPermission propertyPermission) {
        return propertyPermission.actions;
    }

    private static /* synthetic */ void _jr$ip$actions(PropertyPermission propertyPermission, String string) {
        propertyPermission.actions = string;
    }
}

