/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.concurrent.atomic.AtomicLong;
import sun.misc.Unsafe;

public class Random
extends h
implements Serializable {
    static final long serialVersionUID = 3905348978240129619L;
    private final AtomicLong seed;
    private static final long multiplier = 25214903917L;
    private static final long addend = 11L;
    private static final long mask = 0xFFFFFFFFFFFFL;
    private static final AtomicLong seedUniquifier = new AtomicLong(8682522807148012L);
    private double nextNextGaussian;
    private boolean haveNextNextGaussian;
    private static final ObjectStreamField[] serialPersistentFields;
    private static final Unsafe unsafe;
    private static final long seedOffset;

    public Random() {
        this(Random.seedUniquifier() ^ System.nanoTime());
    }

    private static long seedUniquifier() {
        long l;
        long l2;
        while (!seedUniquifier.compareAndSet(l2 = seedUniquifier.get(), l = l2 * 181783497276652981L)) {
        }
        return l;
    }

    public Random(long l) {
        this.haveNextNextGaussian = false;
        if (!f.ifAcmp(this.getClass(), Random.class)) {
            this.seed = new AtomicLong(Random.initialScramble(l));
        } else {
            this.seed = new AtomicLong();
            this.setSeed(l);
        }
    }

    private static long initialScramble(long l) {
        return (l ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
    }

    @af(modifiers=33)
    public void setSeed(long l) {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                this.seed.set(Random.initialScramble(l));
                this.haveNextNextGaussian = false;
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    protected int next(int n2) {
        long l;
        long l2;
        AtomicLong atomicLong = this.seed;
        while (!atomicLong.compareAndSet(l2 = atomicLong.get(), l = l2 * 25214903917L + 11L & 0xFFFFFFFFFFFFL)) {
        }
        return (int)(l >>> 48 - n2);
    }

    public void nextBytes(byte[] byArray) {
        int n2 = 0;
        int n3 = byArray.length;
        while (n2 < n3) {
            int n4 = this.nextInt();
            int n5 = Math.min(n3 - n2, 4);
            while (n5-- > 0) {
                byArray[n2++] = (byte)n4;
                n4 >>= 8;
            }
        }
    }

    public int nextInt() {
        return this.next(32);
    }

    public int nextInt(int n2) {
        int n3;
        int n4;
        if (n2 <= 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("n must be positive"));
        }
        if ((n2 & -n2) == n2) {
            return (int)((long)n2 * (long)this.next(31) >> 31);
        }
        while ((n4 = this.next(31)) - (n3 = n4 % n2) + (n2 - 1) < 0) {
        }
        return n3;
    }

    public long nextLong() {
        return ((long)this.next(32) << 32) + (long)this.next(32);
    }

    public boolean nextBoolean() {
        return this.next(1) != 0;
    }

    public float nextFloat() {
        return (float)this.next(24) / 1.6777216E7f;
    }

    public double nextDouble() {
        return (double)(((long)this.next(26) << 27) + (long)this.next(27)) / 9.007199254740992E15;
    }

    @af(modifiers=33)
    public double nextGaussian() {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                double d;
                double d2;
                double d3;
                if (this.haveNextNextGaussian) {
                    this.haveNextNextGaussian = false;
                    return this.nextNextGaussian;
                }
                while ((d3 = (d2 = 2.0 * this.nextDouble() - 1.0) * d2 + (d = 2.0 * this.nextDouble() - 1.0) * d) >= 1.0 || d3 == 0.0) {
                }
                double d4 = StrictMath.sqrt(-2.0 * StrictMath.log(d3) / d3);
                this.nextNextGaussian = d * d4;
                this.haveNextNextGaussian = true;
                return d2 * d4;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        long l = getField.get("seed", -1L);
        if (l < 0L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new StreamCorruptedException("Random: invalid seed"));
        }
        this.resetSeed(l);
        this.nextNextGaussian = getField.get("nextNextGaussian", 0.0);
        this.haveNextNextGaussian = getField.get("haveNextNextGaussian", false);
    }

    @af(modifiers=34)
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                ObjectOutputStream.PutField putField = objectOutputStream.putFields();
                putField.put("seed", this.seed.get());
                putField.put("nextNextGaussian", this.nextNextGaussian);
                putField.put("haveNextNextGaussian", this.haveNextNextGaussian);
                objectOutputStream.writeFields();
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    private void resetSeed(long l) {
        unsafe.putObjectVolatile(this, seedOffset, new AtomicLong(l));
    }

    static {
        Object[] objectArray = new ObjectStreamField[3];
        a.arrayStore((Object[])objectArray, (int)0, (Object)new ObjectStreamField("seed", Long.TYPE));
        a.arrayStore((Object[])objectArray, (int)1, (Object)new ObjectStreamField("nextNextGaussian", Double.TYPE));
        a.arrayStore((Object[])objectArray, (int)2, (Object)new ObjectStreamField("haveNextNextGaussian", Boolean.TYPE));
        serialPersistentFields = objectArray;
        unsafe = Unsafe.getUnsafe();
        try {
            seedOffset = unsafe.objectFieldOffset(ai.getCurrentClass(Random.class).getDeclaredField("seed"));
        }
        catch (Exception exception) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Error(exception));
        }
    }

    private static /* synthetic */ void _jr$ip$seed(Random random, AtomicLong atomicLong) {
        random.seed = atomicLong;
    }

    protected /* synthetic */ Random(h h2) {
        super(h2);
    }
}

