/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyPermission;
import java.util.concurrent.ConcurrentHashMap;
import sun.misc.JavaAWTAccess;
import sun.misc.SharedSecrets;
import sun.security.action.GetPropertyAction;
import sun.util.TimeZoneNameUtility;
import sun.util.calendar.ZoneInfo;
import sun.util.calendar.ZoneInfoFile;

public abstract class TimeZone
extends h
implements Serializable,
Cloneable {
    public static final int SHORT = 0;
    public static final int LONG = 1;
    private static final int ONE_MINUTE = 60000;
    private static final int ONE_HOUR = 3600000;
    private static final int ONE_DAY = 86400000;
    static final long serialVersionUID = 3581463369166924961L;
    private static final boolean allowSetDefault = AccessController.doPrivileged(new GetPropertyAction("jdk.util.TimeZone.allowSetDefault")) != null;
    static final TimeZone NO_TIMEZONE = null;
    private String ID;
    private static volatile TimeZone defaultTimeZone;
    static final String GMT_ID = "GMT";
    private static final int GMT_ID_LENGTH = 3;
    private static volatile TimeZone mainAppContextDefault;

    public TimeZone() {
    }

    public abstract int getOffset(int var1, int var2, int var3, int var4, int var5, int var6);

    public int getOffset(long l) {
        if (this.inDaylightTime(new Date(l))) {
            return this.getRawOffset() + this.getDSTSavings();
        }
        return this.getRawOffset();
    }

    int getOffsets(long l, int[] nArray) {
        int n2 = this.getRawOffset();
        int n3 = 0;
        if (this.inDaylightTime(new Date(l))) {
            n3 = this.getDSTSavings();
        }
        if (nArray != null) {
            nArray[0] = n2;
            nArray[1] = n3;
        }
        return n2 + n3;
    }

    public abstract void setRawOffset(int var1);

    public abstract int getRawOffset();

    public String getID() {
        return this.ID;
    }

    public void setID(String string) {
        if (string == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        this.ID = string;
    }

    public final String getDisplayName() {
        return this.getDisplayName(false, 1, Locale.getDefault(Locale.Category.DISPLAY));
    }

    public final String getDisplayName(Locale locale) {
        return this.getDisplayName(false, 1, locale);
    }

    public final String getDisplayName(boolean bl, int n2) {
        return this.getDisplayName(bl, n2, Locale.getDefault(Locale.Category.DISPLAY));
    }

    public String getDisplayName(boolean bl, int n2, Locale locale) {
        int n3;
        if (n2 != 0 && n2 != 1) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Illegal style: " + n2));
        }
        String string = this.getID();
        Object[] objectArray = TimeZone.getDisplayNames(string, locale);
        if (objectArray == null) {
            int n4;
            if (string.startsWith(GMT_ID) && ((n4 = (int)string.charAt(3)) == 43 || n4 == 45)) {
                return string;
            }
            n4 = this.getRawOffset();
            if (bl) {
                n4 += this.getDSTSavings();
            }
            return ZoneInfoFile.toCustomID(n4);
        }
        int n5 = n3 = bl ? 3 : 1;
        if (n2 == 0) {
            ++n3;
        }
        return (String)a.arrayLoad((Object[])objectArray, (int)n3);
    }

    private static final String[] getDisplayNames(String string, Locale locale) {
        String[] stringArray;
        Map map = DisplayNames.CACHE;
        SoftReference softReference = (SoftReference)((Object)g.convertForCast(map.get(string), SoftReference.class));
        if (softReference != null && (stringArray = (Map)g.convertForCast(softReference.get(), Map.class)) != null) {
            String[] stringArray2 = (String[])stringArray.get(locale);
            if (stringArray2 != null) {
                return stringArray2;
            }
            stringArray2 = TimeZoneNameUtility.retrieveDisplayNames(string, locale);
            if (stringArray2 != null) {
                stringArray.put(locale, stringArray2);
            }
            return stringArray2;
        }
        stringArray = TimeZoneNameUtility.retrieveDisplayNames(string, locale);
        if (stringArray != null) {
            ConcurrentHashMap<Locale, String[]> concurrentHashMap = new ConcurrentHashMap<Locale, String[]>();
            concurrentHashMap.put(locale, stringArray);
            softReference = new SoftReference(concurrentHashMap);
            map.put(string, softReference);
        }
        return stringArray;
    }

    public int getDSTSavings() {
        if (this.useDaylightTime()) {
            return 3600000;
        }
        return 0;
    }

    public abstract boolean useDaylightTime();

    public boolean observesDaylightTime() {
        return this.useDaylightTime() || this.inDaylightTime(new Date());
    }

    public abstract boolean inDaylightTime(Date var1);

    public static synchronized TimeZone getTimeZone(String string) {
        return TimeZone.getTimeZone(string, true);
    }

    private static TimeZone getTimeZone(String string, boolean bl) {
        TimeZone timeZone = ZoneInfo.getTimeZone(string);
        if (timeZone == null && (timeZone = TimeZone.parseCustomTimeZone(string)) == null && bl) {
            timeZone = new ZoneInfo(GMT_ID, 0);
        }
        return timeZone;
    }

    public static synchronized String[] getAvailableIDs(int n2) {
        return ZoneInfo.getAvailableIDs(n2);
    }

    public static synchronized String[] getAvailableIDs() {
        return ZoneInfo.getAvailableIDs();
    }

    private static native String getSystemTimeZoneID(String var0, String var1);

    private static native String getSystemGMTOffsetID();

    public static TimeZone getDefault() {
        return (TimeZone)g.convertForCast((Object)TimeZone.getDefaultRef().clone(), TimeZone.class);
    }

    static TimeZone getDefaultRef() {
        TimeZone timeZone = TimeZone.getDefaultInAppContext();
        if (timeZone == null && (timeZone = defaultTimeZone) == null) {
            timeZone = TimeZone.setDefaultZone();
            if (!$assertionsDisabled && timeZone == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
        }
        return timeZone;
    }

    private static synchronized TimeZone setDefaultZone() {
        String string;
        TimeZone timeZone = null;
        String string2 = (String)AccessController.doPrivileged(new GetPropertyAction("user.timezone"));
        if (string2 == null || string2.equals("")) {
            string = (String)AccessController.doPrivileged(new GetPropertyAction("user.country"));
            String string3 = (String)AccessController.doPrivileged(new GetPropertyAction("java.home"));
            try {
                string2 = TimeZone.getSystemTimeZoneID(string3, string);
                if (string2 == null) {
                    string2 = GMT_ID;
                }
            }
            catch (NullPointerException nullPointerException) {
                string2 = GMT_ID;
            }
        }
        if ((timeZone = TimeZone.getTimeZone(string2, false)) == null) {
            string = TimeZone.getSystemGMTOffsetID();
            if (string != null) {
                string2 = string;
            }
            timeZone = TimeZone.getTimeZone(string2, true);
        }
        if (!$assertionsDisabled && timeZone == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        string = string2;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.setProperty("user.timezone", string);
                return null;
            }

            static /* synthetic */ String _jr$ig$val$id(Object object) {
                return (object).string;
            }

            static /* synthetic */ void _jr$ip$val$id(Object object, String string2) {
                (object).string = string2;
            }
        });
        defaultTimeZone = timeZone;
        return timeZone;
    }

    private static boolean hasPermission() {
        boolean bl = true;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkPermission(new PropertyPermission("user.timezone", "write"));
            }
            catch (SecurityException securityException) {
                if (!allowSetDefault) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)securityException);
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefault(TimeZone timeZone) {
        if (TimeZone.hasPermission()) {
            Object object = ah.getMonitor(TimeZone.class);
            synchronized (object) {
                try {
                    defaultTimeZone = timeZone;
                    TimeZone.setDefaultInAppContext(null);
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        } else {
            TimeZone.setDefaultInAppContext(timeZone);
        }
    }

    private static TimeZone getDefaultInAppContext() {
        if (allowSetDefault) {
            JavaAWTAccess javaAWTAccess = SharedSecrets.getJavaAWTAccess();
            if (javaAWTAccess == null) {
                return mainAppContextDefault;
            }
            if (!javaAWTAccess.isDisposed()) {
                TimeZone timeZone = (TimeZone)g.convertForCast((Object)javaAWTAccess.get(TimeZone.class), TimeZone.class);
                if (timeZone == null && javaAWTAccess.isMainAppContext()) {
                    return mainAppContextDefault;
                }
                return timeZone;
            }
        }
        return null;
    }

    private static void setDefaultInAppContext(TimeZone timeZone) {
        if (allowSetDefault) {
            JavaAWTAccess javaAWTAccess = SharedSecrets.getJavaAWTAccess();
            if (javaAWTAccess == null) {
                mainAppContextDefault = timeZone;
            } else if (!javaAWTAccess.isDisposed()) {
                javaAWTAccess.put(TimeZone.class, (Object)timeZone);
                if (javaAWTAccess.isMainAppContext()) {
                    mainAppContextDefault = null;
                }
            }
        }
    }

    public boolean hasSameRules(TimeZone timeZone) {
        return timeZone != null && this.getRawOffset() == timeZone.getRawOffset() && this.useDaylightTime() == timeZone.useDaylightTime();
    }

    public Object clone() {
        try {
            TimeZone timeZone = (TimeZone)g.convertForCast((Object)super.clone(), TimeZone.class);
            timeZone.ID = this.ID;
            return timeZone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
        }
    }

    private static final TimeZone parseCustomTimeZone(String string) {
        char c;
        int n2 = string.length();
        if (n2 < 5 || string.indexOf(GMT_ID) != 0) {
            return null;
        }
        ZoneInfo zoneInfo = ZoneInfoFile.getZoneInfo(string);
        if (zoneInfo != null) {
            return zoneInfo;
        }
        int n3 = 3;
        boolean bl = false;
        if ((c = string.charAt(n3++)) == '-') {
            bl = true;
        } else if (c != '+') {
            return null;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n3 < n2) {
            if ((c = string.charAt(n3++)) == ':') {
                if (n6 > 0) {
                    return null;
                }
                if (n7 > 2) {
                    return null;
                }
                n4 = n5;
                ++n6;
                n5 = 0;
                n7 = 0;
                continue;
            }
            if (c < '0' || c > '9') {
                return null;
            }
            n5 = n5 * 10 + (c - 48);
            ++n7;
        }
        if (n3 != n2) {
            return null;
        }
        if (n6 == 0) {
            if (n7 <= 2) {
                n4 = n5;
                n5 = 0;
            } else {
                n4 = n5 / 100;
                n5 %= 100;
            }
        } else if (n7 != 2) {
            return null;
        }
        if (n4 > 23 || n5 > 59) {
            return null;
        }
        int n8 = (n4 * 60 + n5) * 60 * 1000;
        if (n8 == 0) {
            zoneInfo = ZoneInfoFile.getZoneInfo(GMT_ID);
            if (bl) {
                zoneInfo.setID("GMT-00:00");
            } else {
                zoneInfo.setID("GMT+00:00");
            }
        } else {
            zoneInfo = ZoneInfoFile.getCustomTimeZone(string, bl ? -n8 : n8);
        }
        return zoneInfo;
    }

    protected /* synthetic */ TimeZone(h h2) {
        super(h2);
    }

    private static class DisplayNames
    extends h {
        private static final Map<String, SoftReference<Map<Locale, String[]>>> CACHE = new ConcurrentHashMap<String, SoftReference<Map<Locale, String[]>>>();

        private DisplayNames() {
        }

        protected /* synthetic */ DisplayNames(h h2) {
            super(h2);
        }
    }
}

