/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.h;
import java.util.Date;
import java.util.TaskQueue;
import java.util.TimerTask;
import java.util.TimerThread;
import java.util.concurrent.atomic.AtomicInteger;

public class Timer
extends h {
    private final TaskQueue queue;
    private final TimerThread thread;
    private final Object threadReaper;
    private static final AtomicInteger nextSerialNumber = new AtomicInteger(0);

    private static int serialNumber() {
        return nextSerialNumber.getAndIncrement();
    }

    public Timer() {
        this("Timer-" + Timer.serialNumber());
    }

    public Timer(boolean bl) {
        this("Timer-" + Timer.serialNumber(), bl);
    }

    public Timer(String string) {
        this.queue = new TaskQueue();
        this.thread = new TimerThread(this.queue);
        this.threadReaper = new /* Unavailable Anonymous Inner Class!! */;
        this.thread.setName(string);
        this.thread.start();
    }

    public Timer(String string, boolean bl) {
        this.queue = new TaskQueue();
        this.thread = new TimerThread(this.queue);
        this.threadReaper = new /* Unavailable Anonymous Inner Class!! */;
        this.thread.setName(string);
        this.thread.setDaemon(bl);
        this.thread.start();
    }

    public void schedule(TimerTask timerTask, long l) {
        if (l < 0L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Negative delay."));
        }
        this.sched(timerTask, System.currentTimeMillis() + l, 0L);
    }

    public void schedule(TimerTask timerTask, Date date) {
        this.sched(timerTask, date.getTime(), 0L);
    }

    public void schedule(TimerTask timerTask, long l, long l2) {
        if (l < 0L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Negative delay."));
        }
        if (l2 <= 0L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Non-positive period."));
        }
        this.sched(timerTask, System.currentTimeMillis() + l, -l2);
    }

    public void schedule(TimerTask timerTask, Date date, long l) {
        if (l <= 0L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Non-positive period."));
        }
        this.sched(timerTask, date.getTime(), -l);
    }

    public void scheduleAtFixedRate(TimerTask timerTask, long l, long l2) {
        if (l < 0L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Negative delay."));
        }
        if (l2 <= 0L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Non-positive period."));
        }
        this.sched(timerTask, System.currentTimeMillis() + l, l2);
    }

    public void scheduleAtFixedRate(TimerTask timerTask, Date date, long l) {
        if (l <= 0L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Non-positive period."));
        }
        this.sched(timerTask, date.getTime(), l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sched(TimerTask timerTask, long l, long l2) {
        if (l < 0L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Illegal execution time."));
        }
        if (Math.abs(l2) > 0x3FFFFFFFFFFFFFFFL) {
            l2 >>= 1;
        }
        Object object = ah.getMonitor((Object)((Object)this.queue));
        synchronized (object) {
            try {
                if (!TimerThread._jr$ig$newTasksMayBeScheduled(this.thread)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("Timer already cancelled."));
                }
                Object object2 = ah.getMonitor((Object)TimerTask._jr$ig$lock(timerTask));
                synchronized (object2) {
                    try {
                        if (TimerTask._jr$ig$state(timerTask) != 0) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("Task already scheduled or cancelled"));
                        }
                        TimerTask._jr$ip$nextExecutionTime(timerTask, l);
                        TimerTask._jr$ip$period(timerTask, l2);
                        TimerTask._jr$ip$state(timerTask, 1);
                    }
                    catch (Throwable throwable) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                    }
                }
                this.queue.add(timerTask);
                if (!f.ifAcmp((Object)this.queue.getMin(), (Object)timerTask)) {
                    ah.getMonitor((Object)((Object)this.queue)).notify();
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = ah.getMonitor((Object)((Object)this.queue));
        synchronized (object) {
            try {
                TimerThread._jr$ip$newTasksMayBeScheduled(this.thread, false);
                this.queue.clear();
                ah.getMonitor((Object)((Object)this.queue)).notify();
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int purge() {
        int n = 0;
        Object object = ah.getMonitor((Object)((Object)this.queue));
        synchronized (object) {
            try {
                for (int i = this.queue.size(); i > 0; --i) {
                    if (TimerTask._jr$ig$state(this.queue.get(i)) != 3) continue;
                    this.queue.quickRemove(i);
                    ++n;
                }
                if (n != 0) {
                    this.queue.heapify();
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        return n;
    }

    static /* synthetic */ TaskQueue access$000(Timer timer) {
        return timer.queue;
    }

    static /* synthetic */ TimerThread access$100(Timer timer) {
        return timer.thread;
    }

    private static /* synthetic */ void _jr$ip$queue(Timer timer, TaskQueue taskQueue) {
        timer.queue = taskQueue;
    }

    private static /* synthetic */ void _jr$ip$thread(Timer timer, TimerThread timerThread) {
        timer.thread = timerThread;
    }

    private static /* synthetic */ Object _jr$ig$threadReaper(Timer timer) {
        return timer.threadReaper;
    }

    private static /* synthetic */ void _jr$ip$threadReaper(Timer timer, Object object) {
        timer.threadReaper = object;
    }

    protected /* synthetic */ Timer(h h2) {
        super(h2);
    }
}

